/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.DBScriptRunner;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.sql.SqlCommand;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.sql.SqlScript;
import org.jetbrains.dekaf.sql.SqlStatement;

public class BaseScriptRunner
implements DBScriptRunner {
    @NotNull
    private final DBTransaction myTransaction;
    @NotNull
    private final SqlScript myScript;

    BaseScriptRunner(@NotNull DBTransaction transaction, @NotNull SqlScript script) {
        this.myTransaction = transaction;
        this.myScript = script;
    }

    @Override
    public DBScriptRunner run() {
        List<? extends SqlStatement> statements = this.myScript.getStatements();
        for (SqlStatement sqlStatement : statements) {
            if (sqlStatement instanceof SqlCommand) {
                this.runCommand((SqlCommand)sqlStatement);
            }
            if (!(sqlStatement instanceof SqlQuery)) continue;
            this.runQuery((SqlQuery)sqlStatement);
        }
        return this;
    }

    private void runCommand(SqlCommand command) {
        this.myTransaction.command(command).run();
    }

    private void runQuery(SqlQuery query) {
        this.myTransaction.query(query).run();
    }
}

