/*
 * Decompiled with CFR 0.152.
 */
package me.xuender.unidecode;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Unidecode {
    private static final String[][] cache = new String[256][];

    public static String decode(String str) {
        if (str == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            int codepoint = str.codePointAt(i);
            if (codepoint < 128) {
                sb.append(c);
                continue;
            }
            if (codepoint > 65535) continue;
            int section = codepoint >> 8;
            int position = codepoint % 256;
            String[] table = Unidecode.getCache(section);
            if (table == null || table.length <= position) continue;
            sb.append(table[position]);
        }
        return sb.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getCache(int section) {
        String[] ret = cache[section];
        if (ret == null) {
            InputStream inStream = null;
            try {
                inStream = Unidecode.class.getResourceAsStream(String.format("/data/X%03x", section));
                BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
                String line = null;
                ret = new String[256];
                int i = 0;
                while ((line = reader.readLine()) != null) {
                    ret[i] = line;
                    ++i;
                }
                Unidecode.cache[section] = ret;
            }
            catch (Exception e) {
                Unidecode.cache[section] = new String[0];
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else if (ret.length == 0) {
            return null;
        }
        return ret;
    }

    public static String initials(String str) {
        if (str == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Pattern p = Pattern.compile("^\\w|\\s+\\w");
        Matcher m = p.matcher(Unidecode.decode(str));
        while (m.find()) {
            sb.append(m.group().replaceAll(" ", ""));
        }
        return sb.toString();
    }

    private Unidecode() {
    }
}

