/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom.schema;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import com.jetbrains.php.phing.dom.schema.ValuesResolvingConverter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class PhingAttributeType {
    private static final Map<String, ClassBasedType> FREQUENT_CLASS_TYPE_TO_ID_CACHE;
    private static final Map<Class, ClassBasedType> FREQUENT_CLASS_TYPE_CACHE;
    @NonNls
    private static final String TYPE_ATTRIBUTE_NAME = "type";

    PhingAttributeType() {
    }

    @NotNull
    abstract DomExtension registerXmlName(String var1, DomExtensionsRegistrar var2);

    void writeTo(Element element) {
        String representation = this.getRepresentation();
        if (!StringUtil.isEmptyOrSpaces((String)representation)) {
            element.setAttribute(TYPE_ATTRIBUTE_NAME, representation);
        }
    }

    @Nullable
    protected abstract String getRepresentation();

    @NotNull
    static PhingAttributeType fromString(@Nullable String description) {
        PhingAttributeType result = ClassBasedType.parseRepresentation(description);
        if (result == null) {
            result = ValuesBasedType.parseRepresentation(description);
        }
        PhingAttributeType phingAttributeType = result;
        if (phingAttributeType == null) {
            PhingAttributeType.$$$reportNull$$$0(0);
        }
        return phingAttributeType;
    }

    @NotNull
    public static PhingAttributeType readFrom(Element element) {
        String typeValue = element.getAttributeValue(TYPE_ATTRIBUTE_NAME);
        PhingAttributeType phingAttributeType = PhingAttributeType.fromString(typeValue);
        if (phingAttributeType == null) {
            PhingAttributeType.$$$reportNull$$$0(1);
        }
        return phingAttributeType;
    }

    public static PhingAttributeType getForClass(Class aClass) {
        PhingAttributeType type = FREQUENT_CLASS_TYPE_CACHE.get(aClass);
        if (type != null) {
            return type;
        }
        return new ClassBasedType(aClass);
    }

    static {
        HashMap<Class, ClassBasedType> classToType = new HashMap<Class, ClassBasedType>();
        classToType.put(String.class, new ClassBasedType(String.class, ""));
        classToType.put(Boolean.class, new ClassBasedType(Boolean.class, "boolean"));
        classToType.put(Integer.class, new ClassBasedType(Integer.class, "int"));
        classToType.put(PsiFileSystemItem.class, new ClassBasedType(PsiFileSystemItem.class, "psiFSItem"));
        FREQUENT_CLASS_TYPE_CACHE = Collections.unmodifiableMap(classToType);
        HashMap<String, ClassBasedType> idToAttr = new HashMap<String, ClassBasedType>();
        for (ClassBasedType classBasedType : FREQUENT_CLASS_TYPE_CACHE.values()) {
            idToAttr.put(classBasedType.getRepresentation(), classBasedType);
        }
        FREQUENT_CLASS_TYPE_TO_ID_CACHE = Collections.unmodifiableMap(idToAttr);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/phing/dom/schema/PhingAttributeType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "fromString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "readFrom";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ValuesBasedType
    extends PhingAttributeType {
        private final List<String> myValues;

        private ValuesBasedType(List<String> values) {
            this.myValues = values;
        }

        @Override
        @NotNull
        DomExtension registerXmlName(String name, DomExtensionsRegistrar registrar) {
            DomExtension extension = registrar.registerGenericAttributeValueChildExtension(new XmlName(name), String.class);
            extension.setConverter((Converter)new ValuesResolvingConverter(this.myValues));
            DomExtension domExtension = extension;
            if (domExtension == null) {
                ValuesBasedType.$$$reportNull$$$0(0);
            }
            return domExtension;
        }

        @Override
        protected String getRepresentation() {
            return StringUtil.join(this.myValues, (String)",");
        }

        public static PhingAttributeType parseRepresentation(String description) {
            List values = StringUtil.split((String)description, (String)",");
            return new ValuesBasedType(values);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/phing/dom/schema/PhingAttributeType$ValuesBasedType", "registerXmlName"));
        }
    }

    private static class ClassBasedType
    extends PhingAttributeType {
        private final Class myType;
        private final String myRepresentation;

        private ClassBasedType(Class type) {
            this(type, type.getName());
        }

        private ClassBasedType(Class type, @NonNls String representation) {
            this.myType = type;
            this.myRepresentation = representation;
        }

        @Override
        @NotNull
        DomExtension registerXmlName(String name, DomExtensionsRegistrar registrar) {
            DomExtension domExtension = registrar.registerGenericAttributeValueChildExtension(new XmlName(name), (Type)this.myType);
            if (domExtension == null) {
                ClassBasedType.$$$reportNull$$$0(0);
            }
            return domExtension;
        }

        @Override
        protected String getRepresentation() {
            return this.myRepresentation;
        }

        public Class getType() {
            return this.myType;
        }

        public static PhingAttributeType parseRepresentation(String description) {
            Class<?> result;
            description = StringUtil.notNullize((String)description);
            ClassBasedType frequentType = (ClassBasedType)FREQUENT_CLASS_TYPE_TO_ID_CACHE.get(description);
            if (frequentType != null) {
                return frequentType;
            }
            try {
                result = Class.forName(description);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            return result == null ? null : ClassBasedType.getForClass(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/phing/dom/schema/PhingAttributeType$ClassBasedType", "registerXmlName"));
        }
    }
}

