/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import a.b.lb;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryTable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.Nullable;

public class ScriptingLibraryTableModel
extends AbstractTableModel {
    public static final int LIB_ENABLED_COL = 0;
    public static final int LIB_NAME_COL = 1;
    public static final int LIB_TYPE_COL = 2;
    private final ScriptingLibraryManager b;
    private LibraryScope[] a;
    private final ScriptingLibraryMappings c;
    private boolean d;
    private static final long e = lb.a(1254191506345390507L, -4720250014477860117L, MethodHandles.lookup().lookupClass()).a(79698686319254L);

    public ScriptingLibraryTableModel(ScriptingLibraryManager libManager, ScriptingLibraryMappings mappings) {
        this.b = libManager;
        this.c = mappings;
        this.d = false;
        this.a = this.getLibrariesScopes();
    }

    public void resetTable() {
        this.c.reset();
        this.a = this.getLibrariesScopes();
        this.d = false;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.a.length;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        long l3 = e ^ 0x2FC6083AE358L;
        LibraryScope libraryScope = this.a[rowIndex];
        assert (libraryScope != null);
        switch (columnIndex) {
            case 0: {
                return libraryScope.myState;
            }
            case 1: {
                return libraryScope.myLibrary.getName();
            }
            case 2: {
                switch (libraryScope.myLibrary.getLibraryLevel()) {
                    case PREDEFINED: {
                        return "Predefined";
                    }
                    case GLOBAL: {
                        return "Global";
                    }
                    case PROJECT: {
                        return "Project";
                    }
                }
            }
        }
        return "?";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.d = true;
        if (columnIndex == 0 && aValue instanceof Boolean) {
            LibraryScope libraryScope = this.a[rowIndex];
            libraryScope.myState = Boolean.TRUE.equals(aValue) ? EnabledState.ON : EnabledState.OFF;
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        long l3 = e ^ 0x687C9DEB33FBL;
        switch (column) {
            case 0: {
                return "Enabled";
            }
            case 1: {
                return "Name";
            }
            case 2: {
                return "Type";
            }
        }
        return "?";
    }

    public void applyChanges() {
        Set set = this.c.getMappings().keySet();
        for (LibraryScope libraryScope : this.a) {
            String string = libraryScope.myLibrary.getName();
            if (libraryScope.myState == EnabledState.ON && !this.c.isAssociatedWithProject(string)) {
                this.c.associate(null, string, libraryScope.myLibrary.isPredefined());
                continue;
            }
            if (libraryScope.myState != EnabledState.OFF) continue;
            this.c.disassociate(null, string);
            for (VirtualFile virtualFile : set) {
                if (!this.c.isAssociatedWith(virtualFile, string)) continue;
                this.c.disassociate(virtualFile, string);
            }
        }
    }

    public void applyMappings() {
        Map map = this.c.getMappings();
        for (Map.Entry entry : map.entrySet()) {
            if (!(entry.getValue() instanceof ScriptingLibraryMappings.CompoundLibrary)) continue;
            ScriptingLibraryMappings.CompoundLibrary compoundLibrary = (ScriptingLibraryMappings.CompoundLibrary)entry.getValue();
            List list2 = ContainerUtil.map((Collection)compoundLibrary.getLibraries(), scriptingLibraryModel -> scriptingLibraryModel.getName());
            for (LibraryScope libraryScope : this.a) {
                if (libraryScope.myState == EnabledState.OFF && list2.contains(libraryScope.myLibrary.getName())) {
                    compoundLibrary.toggleLibrary(libraryScope.myLibrary);
                    continue;
                }
                if (libraryScope.myState != EnabledState.ON || entry.getKey() != null || list2.contains(libraryScope.myLibrary.getName())) continue;
                compoundLibrary.toggleLibrary(libraryScope.myLibrary);
            }
        }
    }

    public ScriptingLibraryModel createLibrary(String name, VirtualFile[] sourceFiles, VirtualFile[] compactFiles, String[] docUrls, ScriptingLibraryModel.LibraryLevel level, boolean isOnByDefault) {
        return (ScriptingLibraryModel)WriteAction.compute(() -> {
            ScriptingLibraryModel scriptingLibraryModel = this.b.createLibrary(name, sourceFiles, compactFiles, docUrls, level, isOnByDefault);
            this.fireLibTableChanged(true);
            for (int i10 = 0; i10 < this.a.length; ++i10) {
                LibraryScope libraryScope = this.a[i10];
                if (libraryScope.myLibrary != scriptingLibraryModel) continue;
                this.setValueAt(Boolean.TRUE, i10, 0);
                break;
            }
            return scriptingLibraryModel;
        });
    }

    @Nullable
    public ScriptingLibraryModel getLibrary(String name) {
        ScriptingLibraryTable scriptingLibraryTable = this.b.getScriptingLibraryTable();
        return scriptingLibraryTable.getLibraryByName(name);
    }

    public int getLibraryIndex(String name) {
        int n2 = 0;
        for (LibraryScope libraryScope : this.a) {
            if (libraryScope.myLibrary.getName().equals(name)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void removeLibrary(String name) {
        ScriptingLibraryModel scriptingLibraryModel = this.getLibrary(name);
        if (scriptingLibraryModel != null) {
            this.b.removeLibrary(scriptingLibraryModel);
            this.fireLibTableChanged(true);
        }
    }

    @Nullable
    public ScriptingLibraryModel updateLibrary(String oldName, String name, VirtualFile[] sourceFiles, VirtualFile[] compactFiles, String[] docUrls) {
        return (ScriptingLibraryModel)WriteAction.compute(() -> {
            ScriptingLibraryModel scriptingLibraryModel = this.b.updateLibrary(oldName, name, sourceFiles, compactFiles, docUrls);
            this.d = true;
            this.fireTableDataChanged();
            return scriptingLibraryModel;
        });
    }

    public void fireLibTableChanged(boolean keepMappings) {
        this.d = true;
        LibraryScope[] libraryScopeArray = this.getLibrariesScopes();
        if (keepMappings) {
            for (LibraryScope libraryScope : libraryScopeArray) {
                for (LibraryScope libraryScope2 : this.a) {
                    if (!libraryScope2.myLibrary.getName().equals(libraryScope.myLibrary.getName())) continue;
                    libraryScope.myState = libraryScope2.myState;
                }
            }
        }
        this.a = libraryScopeArray;
        this.fireTableDataChanged();
    }

    @Nullable
    public String getLibNameAt(int row) {
        ScriptingLibraryModel scriptingLibraryModel = this.a[row].myLibrary;
        return scriptingLibraryModel != null ? scriptingLibraryModel.getName() : null;
    }

    @Nullable
    public ScriptingLibraryModel getLibraryAt(int row) {
        return this.a[row].myLibrary;
    }

    public boolean isChanged() {
        return this.d;
    }

    private static ScriptingLibraryModel[] a(ScriptingLibraryTable scriptingLibraryTable) {
        ArrayList<ScriptingLibraryModel> arrayList = new ArrayList<ScriptingLibraryModel>();
        for (ScriptingLibraryModel scriptingLibraryModel3 : scriptingLibraryTable.getAllLibraries()) {
            if (scriptingLibraryModel3 == null) continue;
            arrayList.add(scriptingLibraryModel3);
        }
        Collections.sort(arrayList, (scriptingLibraryModel, scriptingLibraryModel2) -> {
            if (scriptingLibraryModel.isPredefined() != scriptingLibraryModel2.isPredefined()) {
                return (scriptingLibraryModel.isPredefined() ? 1 : 0) - (scriptingLibraryModel2.isPredefined() ? 1 : 0);
            }
            return scriptingLibraryModel.getName().compareToIgnoreCase(scriptingLibraryModel2.getName());
        });
        return arrayList.toArray(ScriptingLibraryModel.EMPTY_ARRAY);
    }

    public LibraryScope[] getLibrariesScopes() {
        Object object;
        Object object2;
        Map map = this.c.getMappings();
        HashMap<String, HashSet<VirtualFile>> hashMap = new HashMap<String, HashSet<VirtualFile>>();
        for (Map.Entry libraryScopeArray2 : map.entrySet()) {
            VirtualFile i10 = (VirtualFile)libraryScopeArray2.getKey();
            object2 = (ScriptingLibraryModel)libraryScopeArray2.getValue();
            if (!(object2 instanceof ScriptingLibraryMappings.CompoundLibrary)) continue;
            object = (ScriptingLibraryMappings.CompoundLibrary)object2;
            Collection collection = object.getLibraries();
            VirtualFile virtualFile = collection.iterator();
            while (virtualFile.hasNext()) {
                ScriptingLibraryModel scriptingLibraryModel = (ScriptingLibraryModel)virtualFile.next();
                HashSet<VirtualFile> hashSet = (HashSet<VirtualFile>)hashMap.get(scriptingLibraryModel.getName());
                if (hashSet == null) {
                    hashSet = new HashSet<VirtualFile>();
                    hashMap.put(scriptingLibraryModel.getName(), hashSet);
                }
                hashSet.add(i10);
            }
        }
        ScriptingLibraryModel[] scriptingLibraryModelArray = ScriptingLibraryTableModel.a(this.b.getScriptingLibraryTable());
        LibraryScope[] libraryScopeArray = new LibraryScope[scriptingLibraryModelArray.length];
        for (int i10 = 0; i10 < scriptingLibraryModelArray.length; ++i10) {
            object2 = EnabledState.OFF;
            object = scriptingLibraryModelArray[i10].getName();
            if (hashMap.containsKey(object)) {
                if (this.c.isAssociatedWithProject((String)object)) {
                    object2 = EnabledState.ON;
                } else {
                    for (VirtualFile virtualFile : (Set)hashMap.get(object)) {
                        if (virtualFile == null) continue;
                        object2 = EnabledState.PARTLY;
                        break;
                    }
                }
            }
            libraryScopeArray[i10] = new LibraryScope(scriptingLibraryModelArray[i10], (EnabledState)((Object)object2));
        }
        return libraryScopeArray;
    }

    private static class LibraryScope {
        public ScriptingLibraryModel myLibrary;
        public EnabledState myState;

        private LibraryScope(ScriptingLibraryModel library, EnabledState state) {
            this.myLibrary = library;
            this.myState = state;
        }
    }

    public static final class EnabledState
    extends Enum<EnabledState> {
        public static final /* enum */ EnabledState ON;
        public static final /* enum */ EnabledState PARTLY;
        public static final /* enum */ EnabledState OFF;
        private static final /* synthetic */ EnabledState[] a;

        public static EnabledState[] values() {
            return (EnabledState[])a.clone();
        }

        public static EnabledState valueOf(String name) {
            return Enum.valueOf(EnabledState.class, name);
        }

        static {
            long l3 = lb.a(2284290038140076808L, 9062070196214599836L, MethodHandles.lookup().lookupClass()).a(154291664094300L) ^ 0x471D71065C20L;
            ON = new EnabledState();
            PARTLY = new EnabledState();
            OFF = new EnabledState();
            a = new EnabledState[]{ON, PARTLY, OFF};
        }
    }
}

