/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wiztools.restclient.IGlobalOptions;
import org.wiztools.restclient.ServiceLocator;

public final class ProxyConfig {
    private static final Logger LOG = Logger.getLogger(ProxyConfig.class.getName());
    public static final int DEFAULT_PORT = 8080;
    private static final String PROP_PREFIX = "proxy.options.";
    private static ProxyConfig _proxy;
    private final Lock _lck = new ReentrantLock();
    private boolean enabled = false;
    private String host;
    private int port = 8080;
    private boolean authEnabled = false;
    private String username;
    private char[] password;

    public static ProxyConfig getInstance() {
        if (_proxy == null) {
            _proxy = new ProxyConfig();
            try {
                _proxy.init();
            }
            catch (Exception ex) {
                LOG.log(Level.INFO, "Cannot load Proxy options from properties.", ex);
            }
        }
        return _proxy;
    }

    private void init() {
        IGlobalOptions options = ServiceLocator.getInstance(IGlobalOptions.class);
        _proxy.setEnabled(Boolean.valueOf(options.getProperty("proxy.options.is_enabled")));
        _proxy.setHost(options.getProperty("proxy.options.host"));
        String portStr = options.getProperty("proxy.options.port");
        if (portStr != null) {
            _proxy.setPort(Integer.parseInt(portStr));
        }
        _proxy.setAuthEnabled(Boolean.valueOf(options.getProperty("proxy.options.is_auth_enabled")));
        _proxy.setUsername(options.getProperty("proxy.options.username"));
        String pwdStr = options.getProperty("proxy.options.password");
        if (pwdStr != null) {
            _proxy.setPassword(pwdStr.toCharArray());
        }
    }

    public void write() {
        IGlobalOptions options = ServiceLocator.getInstance(IGlobalOptions.class);
        options.setProperty("proxy.options.is_enabled", String.valueOf(_proxy.isEnabled()));
        options.setProperty("proxy.options.host", _proxy.getHost());
        options.setProperty("proxy.options.port", String.valueOf(_proxy.getPort()));
        options.setProperty("proxy.options.is_auth_enabled", String.valueOf(_proxy.isAuthEnabled()));
        options.setProperty("proxy.options.username", _proxy.getUsername());
        String pwd = _proxy.getPassword() == null ? "" : new String(_proxy.getPassword());
        options.setProperty("proxy.options.password", pwd);
    }

    private ProxyConfig() {
    }

    public void acquire() {
        this._lck.lock();
    }

    public void release() {
        this._lck.unlock();
    }

    public boolean isAuthEnabled() {
        return this.authEnabled;
    }

    public void setAuthEnabled(boolean authEnabled) {
        this.authEnabled = authEnabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

