/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomEvent;
import gnu.xml.dom.DomIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.w3c.dom.traversal.NodeFilter;

public abstract class DomNode
implements Node,
NodeList,
EventTarget,
DocumentEvent,
Cloneable,
Comparable {
    private static final int NKIDS_DELTA = 8;
    private static final int ANCESTORS_INIT = 20;
    private static final int NOTIFICATIONS_INIT = 10;
    static final boolean reportMutations = true;
    private static final Object lockNode = new Object();
    private static boolean dispatchDataLock;
    private static DomNode[] ancestors;
    private static ListenerRecord[] notificationSet;
    private static boolean eventDataLock;
    private static DomEvent.DomMutationEvent mutationEvent;
    DomDocument owner;
    DomNode parent;
    DomNode previous;
    DomNode next;
    DomNode first;
    DomNode last;
    int index;
    int depth;
    int length;
    final short nodeType;
    boolean readonly;
    private ListenerRecord[] listeners;
    private int nListeners;
    private HashMap userData;
    private HashMap userDataHandlers;

    public void compact() {
        if (this.listeners != null && this.listeners.length != this.nListeners) {
            if (this.nListeners == 0) {
                this.listeners = null;
            } else {
                ListenerRecord[] l = new ListenerRecord[this.nListeners];
                System.arraycopy(this.listeners, 0, l, 0, this.nListeners);
                this.listeners = l;
            }
        }
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public boolean hasAttributes() {
        return false;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Node getFirstChild() {
        return this.first;
    }

    public Node getLastChild() {
        return this.last;
    }

    public boolean hasChildNodes() {
        boolean bl = false;
        if (this.length != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isReadonly() {
        return this.readonly;
    }

    public void makeReadonly() {
        this.readonly = true;
        DomNode child = this.first;
        while (child != null) {
            child.makeReadonly();
            child = child.next;
        }
    }

    void setOwner(DomDocument doc) {
        this.owner = doc;
        DomNode ctx = this.first;
        while (ctx != null) {
            ctx.setOwner(doc);
            ctx = ctx.next;
        }
    }

    private final void checkMisc(DomNode child) {
        if (this.readonly && !this.owner.building) {
            throw new DomDOMException(7, null, this, 0);
        }
        DomNode ctx = this;
        while (ctx != null) {
            if (child == ctx) {
                throw new DomDOMException(3, "can't make ancestor into a child", this, 0);
            }
            ctx = ctx.parent;
        }
        DomDocument owner = this.nodeType == 9 ? (DomDocument)this : this.owner;
        DomDocument childOwner = child.owner;
        short childNodeType = child.nodeType;
        if (childOwner != owner && (childNodeType != 10 || childOwner != null)) {
            throw new DomDOMException(4, null, child, 0);
        }
        switch (this.nodeType) {
            case 9: {
                switch (childNodeType) {
                    case 1: 
                    case 7: 
                    case 8: 
                    case 10: {
                        return;
                    }
                }
                break;
            }
            case 2: {
                switch (childNodeType) {
                    case 3: 
                    case 5: {
                        return;
                    }
                }
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 11: {
                switch (childNodeType) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        return;
                    }
                }
                break;
            }
        }
        if (owner.checkingWellformedness) {
            throw new DomDOMException(3, "can't append " + this.nodeTypeToString(childNodeType) + " to node of type " + this.nodeTypeToString(this.nodeType), this, 0);
        }
    }

    private final void insertionEvent(DomEvent.DomMutationEvent event, DomNode target) {
        if (this.owner == null || this.owner.building) {
            return;
        }
        boolean doFree = false;
        if (event == null) {
            event = DomNode.getMutationEvent();
        }
        if (event != null) {
            doFree = true;
        } else {
            event = new DomEvent.DomMutationEvent(null);
        }
        event.initMutationEvent("DOMNodeInserted", true, false, this, null, null, null, (short)0);
        target.dispatchEvent(event);
        if (doFree) {
            event.target = null;
            event.relatedNode = null;
            event.currentNode = null;
            eventDataLock = false;
        }
    }

    private final void removalEvent(DomEvent.DomMutationEvent event, DomNode target) {
        if (this.owner == null || this.owner.building) {
            return;
        }
        boolean doFree = false;
        if (event == null) {
            event = DomNode.getMutationEvent();
        }
        if (event != null) {
            doFree = true;
        } else {
            event = new DomEvent.DomMutationEvent(null);
        }
        event.initMutationEvent("DOMNodeRemoved", true, false, this, null, null, null, (short)0);
        target.dispatchEvent(event);
        event.target = null;
        event.relatedNode = null;
        event.currentNode = null;
        if (doFree) {
            eventDataLock = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final DomEvent.DomMutationEvent getMutationEvent() {
        Object object = lockNode;
        synchronized (object) {
            if (eventDataLock) {
                return null;
            }
            eventDataLock = true;
            return mutationEvent;
        }
    }

    private static final void freeMutationEvent() {
        mutationEvent.clear();
        eventDataLock = false;
    }

    void setDepth(int depth) {
        this.depth = depth;
        DomNode ctx = this.first;
        while (ctx != null) {
            ctx.setDepth(depth + 1);
            ctx = ctx.next;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Node appendChild(Node newChild) {
        try {
            void e;
            DomNode child = (DomNode)newChild;
            if (child.nodeType == 11) {
                DomNode ctx = child.first;
                while (ctx != null) {
                    this.checkMisc(ctx);
                    ctx = ctx.next;
                }
                ctx = child.first;
                while (ctx != null) {
                    DomNode ctxNext = ctx.next;
                    this.appendChild(ctx);
                    ctx = ctxNext;
                }
            } else {
                this.checkMisc(child);
                if (child.parent != null) {
                    child.parent.removeChild(child);
                }
                child.parent = this;
                child.index = this.length++;
                child.setDepth(this.depth + 1);
                child.next = null;
                if (this.last == null) {
                    this.first = child;
                    child.previous = null;
                } else {
                    this.last.next = child;
                    child.previous = this.last;
                }
                this.last = child;
                this.insertionEvent(null, child);
            }
            return e;
        }
        catch (ClassCastException e) {
            throw new DomDOMException(4, null, newChild, 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Node insertBefore(Node newChild, Node refChild) {
        if (refChild == null) {
            return this.appendChild(newChild);
        }
        try {
            void e;
            DomNode child = (DomNode)newChild;
            DomNode ref = (DomNode)refChild;
            if (child.nodeType == 11) {
                DomNode ctx = child.first;
                while (ctx != null) {
                    this.checkMisc(ctx);
                    ctx = ctx.next;
                }
                ctx = child.first;
                while (ctx != null) {
                    DomNode ctxNext = ctx.next;
                    this.insertBefore(ctx, ref);
                    ctx = ctxNext;
                }
            } else {
                this.checkMisc(child);
                if (ref == null || ref.parent != this) {
                    throw new DomDOMException(8, null, ref, 0);
                }
                if (ref == child) {
                    throw new DomDOMException(3, "can't insert node before itself", ref, 0);
                }
                if (child.parent != null) {
                    child.parent.removeChild(child);
                }
                child.parent = this;
                int i = ref.index;
                child.setDepth(this.depth + 1);
                child.next = ref;
                if (ref.previous != null) {
                    ref.previous.next = child;
                }
                child.previous = ref.previous;
                ref.previous = child;
                if (this.first == ref) {
                    this.first = child;
                }
                DomNode ctx = child;
                while (ctx != null) {
                    ctx.index = i++;
                    ctx = ctx.next;
                }
                this.insertionEvent(null, child);
            }
            return e;
        }
        catch (ClassCastException e) {
            throw new DomDOMException(4, null, newChild, 0);
        }
    }

    public Node replaceChild(Node newChild, Node refChild) {
        try {
            boolean doFree;
            DomNode child = (DomNode)newChild;
            DomNode ref = (DomNode)refChild;
            DomEvent.DomMutationEvent event = DomNode.getMutationEvent();
            boolean bl = false;
            if (event != null) {
                bl = doFree = true;
            }
            if (child.nodeType == 11) {
                DomNode ctx = child.first;
                while (ctx != null) {
                    this.checkMisc(ctx);
                    ctx = ctx.next;
                }
                if (ref == null || ref.parent != this) {
                    throw new DomDOMException(8, null, ref, 0);
                }
                this.removalEvent(event, ref);
                --this.length;
                this.length += child.length;
                if (child.length == 0) {
                    if (ref.previous != null) {
                        ref.previous.next = ref.next;
                    }
                    if (ref.next != null) {
                        ref.next.previous = ref.previous;
                    }
                    if (this.first == ref) {
                        this.first = ref.next;
                    }
                    if (this.last == ref) {
                        this.last = ref.previous;
                    }
                } else {
                    int i = ref.index;
                    DomNode ctx2 = child.first;
                    while (ctx2 != null) {
                        ctx2.parent = this;
                        ctx2.index = i++;
                        ctx2.setDepth(ref.depth);
                        if (ctx2 == child.first) {
                            ctx2.previous = ref.previous;
                        }
                        if (ctx2 == child.last) {
                            ctx2.next = ref.next;
                        }
                        ctx2 = ctx2.next;
                    }
                    if (this.first == ref) {
                        this.first = child.first;
                    }
                    if (this.last == ref) {
                        this.last = child.last;
                    }
                }
            } else {
                this.checkMisc(child);
                if (ref == null || ref.parent != this) {
                    throw new DomDOMException(8, null, ref, 0);
                }
                this.removalEvent(event, ref);
                if (child.parent != null) {
                    child.parent.removeChild(child);
                }
                child.parent = this;
                child.index = ref.index;
                child.setDepth(ref.depth);
                if (ref.previous != null) {
                    ref.previous.next = child;
                }
                child.previous = ref.previous;
                if (ref.next != null) {
                    ref.next.previous = child;
                }
                child.next = ref.next;
                if (this.first == ref) {
                    this.first = child;
                }
                if (this.last == ref) {
                    this.last = child;
                }
                this.insertionEvent(event, child);
                if (doFree) {
                    DomNode.freeMutationEvent();
                }
            }
            ref.parent = null;
            ref.index = 0;
            ref.setDepth(0);
            ref.previous = null;
            ref.next = null;
            return ref;
        }
        catch (ClassCastException e) {
            throw new DomDOMException(4, null, newChild, 0);
        }
    }

    public Node removeChild(Node refChild) {
        try {
            DomNode ref = (DomNode)refChild;
            if (ref == null || ref.parent != this) {
                throw new DomDOMException(8, null, ref, 0);
            }
            if (this.readonly && !this.owner.building) {
                throw new DomDOMException(7, null, this, 0);
            }
            DomNode child = this.first;
            while (child != null) {
                if (child == ref) {
                    this.removalEvent(null, child);
                    --this.length;
                    if (ref.previous != null) {
                        ref.previous.next = ref.next;
                    }
                    if (ref.next != null) {
                        ref.next.previous = ref.previous;
                    }
                    if (this.first == ref) {
                        this.first = ref.next;
                    }
                    if (this.last == ref) {
                        this.last = ref.previous;
                    }
                    int i = 0;
                    DomNode ctx = this.first;
                    while (ctx != null) {
                        ctx.index = i++;
                        ctx = ctx.next;
                    }
                    ref.parent = null;
                    ref.setDepth(0);
                    ref.index = 0;
                    ref.previous = null;
                    ref.next = null;
                    return ref;
                }
                child = child.next;
            }
            throw new DomDOMException(8, "that's no child of mine", refChild, 0);
        }
        catch (ClassCastException e) {
            throw new DomDOMException(4, null, refChild, 0);
        }
    }

    public Node item(int index) {
        DomNode child = this.first;
        int count = 0;
        while (child != null && count < index) {
            child = child.next;
            ++count;
        }
        return child;
    }

    public int getLength() {
        return this.length;
    }

    public void trimToSize() {
        if (this.listeners != null && this.listeners.length != this.nListeners) {
            ListenerRecord[] newKids = new ListenerRecord[this.length];
            System.arraycopy(this.listeners, 0, newKids, 0, this.nListeners);
            this.listeners = newKids;
        }
    }

    public Node getNextSibling() {
        return this.next;
    }

    public Node getPreviousSibling() {
        return this.previous;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public boolean isSupported(String feature, String version) {
        Document doc = this.owner;
        DOMImplementation impl = null;
        if (doc == null && this.nodeType == 9) {
            doc = (Document)((Object)this);
        }
        if (doc == null) {
            throw new IllegalStateException("unbound ownerDocument");
        }
        impl = doc.getImplementation();
        return impl.hasFeature(feature, version);
    }

    public final Document getOwnerDocument() {
        return this.owner;
    }

    public void setNodeValue(String value) {
    }

    public String getNodeValue() {
        return null;
    }

    public final short getNodeType() {
        return this.nodeType;
    }

    public abstract String getNodeName();

    public void setPrefix(String prefix) {
    }

    public String getPrefix() {
        return null;
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getLocalName() {
        return null;
    }

    public Node cloneNode(boolean deep) {
        DomNode node2 = (DomNode)this.clone();
        if (deep) {
            DomDocument doc = this.nodeType == 9 ? (DomDocument)node2 : node2.owner;
            DomNode ctx = this.first;
            while (ctx != null) {
                DomNode newChild = (DomNode)ctx.cloneNode(deep);
                newChild.setOwner(doc);
                node2.appendChild(newChild);
                ctx = ctx.next;
            }
        }
        if (this.nodeType == 5) {
            node2.makeReadonly();
        }
        this.notifyUserDataHandlers((short)1, this, node2);
        return node2;
    }

    void notifyUserDataHandlers(short op, Node src, Node dst) {
        if (this.userDataHandlers != null) {
            Iterator i = this.userDataHandlers.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                String key = (String)entry.getKey();
                UserDataHandler handler = (UserDataHandler)entry.getValue();
                Object data = this.userData.get(key);
                handler.handle(op, key, data, src, dst);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void x;
            DomNode node2 = (DomNode)super.clone();
            node2.parent = null;
            node2.depth = 0;
            node2.index = 0;
            node2.length = 0;
            node2.first = null;
            node2.last = null;
            node2.previous = null;
            node2.next = null;
            node2.readonly = false;
            node2.listeners = null;
            node2.nListeners = 0;
            return x;
        }
        catch (CloneNotSupportedException x) {
            throw new Error("clone didn't work");
        }
    }

    public NodeList getElementsByTagName(String tag) {
        return new ShadowList(null, tag);
    }

    public NodeList getElementsByTagNameNS(String namespace, String local) {
        return new ShadowList(namespace, local);
    }

    public Event createEvent(String eventType) {
        if ("mutationevents".equals(eventType = eventType.toLowerCase())) {
            return new DomEvent.DomMutationEvent(null);
        }
        if ("htmlevents".equals(eventType) || "events".equals(eventType) || "user-events".equals(eventType)) {
            return new DomEvent(null);
        }
        if ("uievents".equals(eventType)) {
            return new DomEvent.DomUIEvent(null);
        }
        throw new DomDOMException(9, eventType, null, 0);
    }

    public final void addEventListener(String type, EventListener listener, boolean useCapture) {
        if (this.listeners == null) {
            this.listeners = new ListenerRecord[1];
        } else if (this.nListeners == this.listeners.length) {
            ListenerRecord[] newListeners = new ListenerRecord[this.listeners.length + 8];
            System.arraycopy(this.listeners, 0, newListeners, 0, this.nListeners);
            this.listeners = newListeners;
        }
        ListenerRecord record = new ListenerRecord(type, listener, useCapture);
        int i = 0;
        while (i < this.nListeners) {
            if (record.equals(this.listeners[i])) {
                return;
            }
            ++i;
        }
        this.listeners[this.nListeners++] = record;
    }

    /*
     * Exception decompiling
     */
    public final boolean dispatchEvent(Event event) throws EventException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 55->100)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final void notifyNode(DomEvent e, DomNode current, boolean capture, ListenerRecord[] notificationSet) {
        int count = 0;
        int i = 0;
        while (i < current.nListeners) {
            ListenerRecord rec = current.listeners[i];
            if (rec.useCapture == capture && e.type.equals(rec.type)) {
                if (count >= notificationSet.length) {
                    int len = Math.max(notificationSet.length, 1);
                    ListenerRecord[] tmp = new ListenerRecord[len * 2];
                    System.arraycopy(notificationSet, 0, tmp, 0, notificationSet.length);
                    notificationSet = tmp;
                }
                notificationSet[count++] = rec;
            }
            ++i;
        }
        e.currentNode = current;
        i = 0;
        while (i < count) {
            try {
                int j = 0;
                while (j < current.nListeners) {
                    if (current.listeners[j].equals(notificationSet[i])) {
                        notificationSet[i].listener.handleEvent(e);
                        break;
                    }
                    ++j;
                }
            }
            catch (Exception x) {
                // empty catch block
            }
            notificationSet[i] = null;
            ++i;
        }
    }

    public final void removeEventListener(String type, EventListener listener, boolean useCapture) {
        int i = 0;
        while (i < this.nListeners) {
            if (this.listeners[i].listener == listener && this.listeners[i].useCapture == useCapture && this.listeners[i].type.equals(type)) {
                if (this.nListeners == 1) {
                    this.listeners = null;
                    this.nListeners = 0;
                    break;
                }
                int j = i + 1;
                while (j < this.nListeners) {
                    this.listeners[i++] = this.listeners[j++];
                    ++j;
                }
                this.listeners[--this.nListeners] = null;
                break;
            }
            ++i;
        }
    }

    public final void normalize() {
        boolean saved = this.readonly;
        this.readonly = false;
        DomNode ctx = this.first;
        while (ctx != null) {
            switch (ctx.nodeType) {
                case 3: {
                    while (ctx.next != null && ctx.next.nodeType == 3) {
                        Text text = (Text)((Object)ctx);
                        text.appendData(ctx.next.getNodeValue());
                        this.removeChild(ctx.next);
                    }
                    break;
                }
                case 1: {
                    NamedNodeMap attrs = ctx.getAttributes();
                    int len = attrs.getLength();
                    int i = 0;
                    while (i < len) {
                        attrs.item(i).normalize();
                        ++i;
                    }
                }
                case 2: 
                case 5: 
                case 9: 
                case 11: {
                    ctx.normalize();
                    break;
                }
            }
            ctx = ctx.next;
        }
        this.readonly = saved;
    }

    public boolean nameAndTypeEquals(Node other) {
        if (other == this) {
            return true;
        }
        if (this.nodeType != other.getNodeType()) {
            return false;
        }
        String ns1 = this.getNamespaceURI();
        String ns2 = other.getNamespaceURI();
        if (ns1 != null && ns2 != null) {
            boolean bl = false;
            if (ns1.equals(ns2) && this.equal(this.getLocalName(), other.getLocalName())) {
                bl = true;
            }
            return bl;
        }
        if (ns1 == null && ns2 == null) {
            return this.getNodeName().equals(other.getNodeName());
        }
        return false;
    }

    public String getBaseURI() {
        return this.parent != null ? this.parent.getBaseURI() : null;
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        return (short)this.compareTo(other);
    }

    public final int compareTo(Object other) {
        if (other instanceof DomNode) {
            DomNode n1 = this;
            DomNode n2 = (DomNode)other;
            if (n1.owner != n2.owner) {
                return 0;
            }
            int d1 = n1.depth;
            int d2 = n2.depth;
            int delta = d1 - d2;
            while (d1 > d2) {
                n1 = n1.parent;
                --d1;
            }
            while (d2 > d1) {
                n2 = n2.parent;
                --d2;
            }
            int c = this.compareTo2(n1, n2);
            return c != 0 ? c : delta;
        }
        return 0;
    }

    final int compareTo2(DomNode n1, DomNode n2) {
        if (n1 == n2 || n1.depth == 0 || n2.depth == 0) {
            return 0;
        }
        int c = this.compareTo2(n1.parent, n2.parent);
        return c != 0 ? c : n1.index - n2.index;
    }

    public final String getTextContent() throws DOMException {
        return this.getTextContent(true);
    }

    final String getTextContent(boolean topLevel) throws DOMException {
        switch (this.nodeType) {
            case 1: 
            case 5: 
            case 6: 
            case 11: {
                StringBuffer buffer = new StringBuffer();
                DomNode ctx = this.first;
                while (ctx != null) {
                    String textContent = ctx.getTextContent(false);
                    if (textContent != null) {
                        buffer.append(textContent);
                    }
                    ctx = ctx.next;
                }
                return buffer.toString();
            }
            case 3: 
            case 4: {
                if (((Text)((Object)this)).isElementContentWhitespace()) {
                    return "";
                }
                return this.getNodeValue();
            }
            case 2: {
                return this.getNodeValue();
            }
            case 7: 
            case 8: {
                return topLevel ? this.getNodeValue() : "";
            }
        }
        return null;
    }

    public void setTextContent(String textContent) throws DOMException {
        switch (this.nodeType) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                DomNode ctx = this.first;
                while (ctx != null) {
                    DomNode n = ctx.next;
                    this.removeChild(ctx);
                    ctx = n;
                }
                if (textContent == null) break;
                Text text = this.owner.createTextNode(textContent);
                this.appendChild(text);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                this.setNodeValue(textContent);
                break;
            }
        }
    }

    public boolean isSameNode(Node other) {
        boolean bl = false;
        if (this == other) {
            bl = true;
        }
        return bl;
    }

    public String lookupPrefix(String namespaceURI) {
        return this.parent == null || this.parent == this.owner ? null : this.parent.lookupPrefix(namespaceURI);
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        boolean bl = false;
        if (this.parent != null && this.parent != this.owner) {
            bl = this.parent.isDefaultNamespace(namespaceURI);
        }
        return bl;
    }

    public String lookupNamespaceURI(String prefix) {
        return this.parent == null || this.parent == this.owner ? null : this.parent.lookupNamespaceURI(prefix);
    }

    public boolean isEqualNode(Node arg) {
        if (this == arg) {
            return true;
        }
        if (arg == null) {
            return false;
        }
        if (!(this.nodeType == arg.getNodeType() && this.equal(this.getNodeName(), arg.getNodeName()) && this.equal(this.getLocalName(), arg.getLocalName()) && this.equal(this.getNamespaceURI(), arg.getNamespaceURI()) && this.equal(this.getPrefix(), arg.getPrefix()) && this.equal(this.getNodeValue(), arg.getNodeValue()))) {
            return false;
        }
        Node argCtx = arg.getFirstChild();
        this.getFirstChild();
        DomNode ctx = this.first;
        while (ctx != null) {
            if (!ctx.isEqualNode(argCtx)) {
                return false;
            }
            argCtx = argCtx.getNextSibling();
            ctx = ctx.next;
        }
        return argCtx == null;
    }

    boolean equal(String arg1, String arg2) {
        boolean bl = false;
        if (arg1 == null && arg2 == null || arg1 != null && arg1.equals(arg2)) {
            bl = true;
        }
        return bl;
    }

    public Object getFeature(String feature, String version) {
        DOMImplementation impl;
        DOMImplementation dOMImplementation = impl = this.nodeType == 9 ? ((Document)((Object)this)).getImplementation() : this.owner.getImplementation();
        if (impl.hasFeature(feature, version)) {
            return this;
        }
        return null;
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if (this.userData == null) {
            this.userData = new HashMap();
        }
        if (handler != null) {
            if (this.userDataHandlers == null) {
                this.userDataHandlers = new HashMap();
            }
            this.userDataHandlers.put(key, handler);
        }
        return this.userData.put(key, data);
    }

    public Object getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(key);
    }

    public String toString() {
        String nodeName = this.getNodeName();
        String nodeValue = this.getNodeValue();
        StringBuffer buf = new StringBuffer(this.getClass().getName());
        buf.append('[');
        if (nodeName != null) {
            buf.append(nodeName);
        }
        if (nodeValue != null) {
            if (nodeName != null) {
                buf.append('=');
            }
            buf.append('\'');
            buf.append(this.encode(nodeValue));
            buf.append('\'');
        }
        buf.append(']');
        return buf.toString();
    }

    String encode(String value) {
        StringBuffer buf = null;
        int len = value.length();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            if (c == '\n') {
                if (buf == null) {
                    buf = new StringBuffer(value.substring(0, i));
                }
                buf.append("\\n");
            } else if (c == '\r') {
                if (buf == null) {
                    buf = new StringBuffer(value.substring(0, i));
                }
                buf.append("\\r");
            } else if (buf != null) {
                buf.append(c);
            }
            ++i;
        }
        return buf != null ? buf.toString() : value;
    }

    String nodeTypeToString(short nodeType) {
        switch (nodeType) {
            case 1: {
                return "ELEMENT_NODE";
            }
            case 2: {
                return "ATTRIBUTE_NODE";
            }
            case 3: {
                return "TEXT_NODE";
            }
            case 4: {
                return "CDATA_SECTION_NODE";
            }
            case 9: {
                return "DOCUMENT_NODE";
            }
            case 10: {
                return "DOCUMENT_TYPE_NODE";
            }
            case 8: {
                return "COMMENT_NODE";
            }
            case 7: {
                return "PROCESSING_INSTRUCTION_NODE";
            }
            case 11: {
                return "DOCUMENT_FRAGMENT_NODE";
            }
            case 6: {
                return "ENTITY_NODE";
            }
            case 5: {
                return "ENTITY_REFERENCE_NODE";
            }
            case 12: {
                return "NOTATION_NODE";
            }
        }
        return "UNKNOWN";
    }

    protected DomNode(short nodeType, DomDocument owner) {
        this.nodeType = nodeType;
        if (owner == null && nodeType != 9 && nodeType != 10) {
            throw new IllegalArgumentException("no owner!");
        }
        this.owner = owner;
    }

    static {
        ancestors = new DomNode[20];
        notificationSet = new ListenerRecord[10];
        mutationEvent = new DomEvent.DomMutationEvent(null);
    }

    static final class ListenerRecord {
        String type;
        EventListener listener;
        boolean useCapture;

        final boolean equals(ListenerRecord rec) {
            boolean bl = false;
            if (this.listener == rec.listener && this.useCapture == rec.useCapture && this.type == rec.type) {
                bl = true;
            }
            return bl;
        }

        ListenerRecord(String type, EventListener listener, boolean useCapture) {
            this.type = type.intern();
            this.listener = listener;
            this.useCapture = useCapture;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class ShadowList
    implements NodeList {
        private LiveNodeList liveList;

        public final void finalize() {
            this.liveList.detach();
            this.liveList = null;
        }

        public final Node item(int index) {
            return this.liveList.item(index);
        }

        public final int getLength() {
            return this.liveList.getLength();
        }

        ShadowList(String ns, String local) {
            this.liveList = new LiveNodeList(ns, local);
        }
    }

    static final class DomEventException
    extends EventException {
        DomEventException() {
            super((short)0, "unspecified event type");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    final class LiveNodeList
    implements NodeList,
    EventListener,
    NodeFilter {
        private final boolean matchAnyURI;
        private final boolean matchAnyName;
        private final String elementURI;
        private final String elementName;
        private DomIterator current;
        private int lastIndex;

        final void detach() {
            this.current.detach();
            this.current = null;
            DomNode.this.removeEventListener("DOMNodeInserted", this, true);
            DomNode.this.removeEventListener("DOMNodeRemoved", this, true);
        }

        public final short acceptNode(Node element) {
            if (element == DomNode.this) {
                return 3;
            }
            if (this.elementURI != null) {
                if (!this.matchAnyURI && !this.elementURI.equals(element.getNamespaceURI())) {
                    return 3;
                }
                if (!this.matchAnyName && !this.elementName.equals(element.getLocalName())) {
                    return 3;
                }
            } else if (!this.matchAnyName && !this.elementName.equals(element.getNodeName())) {
                return 3;
            }
            return 1;
        }

        private final DomIterator createIterator() {
            return new DomIterator(DomNode.this, 1, this, true);
        }

        public final void handleEvent(Event e) {
            MutationEvent mutation = (MutationEvent)e;
            Node related = mutation.getRelatedNode();
            if (related.getNodeType() != 1 || related.getNodeName() != this.elementName || related.getNamespaceURI() != this.elementURI) {
                return;
            }
            this.current = null;
        }

        /*
         * Unable to fully structure code
         */
        public final Node item(int index) {
            if (this.current == null) {
                this.current = this.createIterator();
                this.lastIndex = -1;
            }
            if (index > this.lastIndex) ** GOTO lbl15
            while (index != this.lastIndex) {
                this.current.previousNode();
                --this.lastIndex;
            }
            ret = this.current.previousNode();
            this.current = null;
            return ret;
lbl-1000:
            // 1 sources

            {
                this.current.nextNode();
lbl15:
                // 2 sources

                ** while (++this.lastIndex != index)
            }
lbl16:
            // 1 sources

            ret = this.current.nextNode();
            this.current = null;
            return ret;
        }

        public final int getLength() {
            int retval = 0;
            DomIterator iter = this.createIterator();
            while (iter.nextNode() != null) {
                ++retval;
            }
            this.current = null;
            return retval;
        }

        LiveNodeList(String uri, String name) {
            this.elementURI = uri;
            this.elementName = name;
            this.matchAnyURI = "*".equals(uri);
            this.matchAnyName = "*".equals(name);
            DomNode.this.addEventListener("DOMNodeInserted", this, true);
            DomNode.this.addEventListener("DOMNodeRemoved", this, true);
        }
    }
}

