/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import sun.awt.dnd.SunDragSourceContextPeer;

class TonicDragGestureRecognizer
implements MouseListener,
MouseMotionListener {
    private MouseEvent dndArmedEvent = null;
    private static int motionThreshold;
    private static boolean checkedMotionThreshold;

    static {
        checkedMotionThreshold = false;
    }

    TonicDragGestureRecognizer() {
    }

    private static int getMotionThreshold() {
        if (checkedMotionThreshold) {
            return motionThreshold;
        }
        checkedMotionThreshold = true;
        try {
            motionThreshold = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
        }
        catch (Exception e) {
            motionThreshold = 5;
        }
        return motionThreshold;
    }

    protected int mapDragOperationFromModifiers(MouseEvent e) {
        int mods = e.getModifiersEx();
        if ((mods & 0x400) != 1024) {
            return 0;
        }
        JComponent c = this.getComponent(e);
        TransferHandler th = c.getTransferHandler();
        return SunDragSourceContextPeer.convertModifiersToDropAction(mods, th.getSourceActions(c));
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.dndArmedEvent = null;
        if (this.isDragPossible(e) && this.mapDragOperationFromModifiers(e) != 0) {
            this.dndArmedEvent = e;
            e.consume();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.dndArmedEvent = null;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.dndArmedEvent != null) {
            e.consume();
            int action = this.mapDragOperationFromModifiers(e);
            if (action == 0) {
                return;
            }
            int dx = Math.abs(e.getX() - this.dndArmedEvent.getX());
            int dy = Math.abs(e.getY() - this.dndArmedEvent.getY());
            if (dx > TonicDragGestureRecognizer.getMotionThreshold() || dy > TonicDragGestureRecognizer.getMotionThreshold()) {
                JComponent c = this.getComponent(e);
                TransferHandler th = c.getTransferHandler();
                th.exportAsDrag(c, this.dndArmedEvent, action);
                this.dndArmedEvent = null;
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    private TransferHandler getTransferHandler(MouseEvent e) {
        JComponent c = this.getComponent(e);
        return c == null ? null : c.getTransferHandler();
    }

    protected boolean isDragPossible(MouseEvent e) {
        JComponent c = this.getComponent(e);
        return c == null ? true : c.getTransferHandler() != null;
    }

    protected JComponent getComponent(MouseEvent e) {
        Object src = e.getSource();
        if (src instanceof JComponent) {
            JComponent c = (JComponent)src;
            return c;
        }
        return null;
    }
}

