/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf.jtattoo;

import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class JTattooLafData {
    private static ILogger s_log = LoggerController.createLogger(JTattooLafData.class);
    private HashMap<String, Class<?>> lafMap = new HashMap();
    private ClassLoader cl = null;
    public static final String MCWIN_LAF_CLASS_NAME = "com.jtattoo.plaf.mcwin.McWinLookAndFeel";

    public JTattooLafData(ClassLoader cl) {
        this.cl = cl;
        this.initLafMap();
    }

    private void initLafMap() {
        this.putClass("Acryl", "com.jtattoo.plaf.acryl.AcrylLookAndFeel");
        this.putClass("Aluminium", "com.jtattoo.plaf.aluminium.AluminiumLookAndFeel");
        this.putClass("Bernstein", "com.jtattoo.plaf.bernstein.BernsteinLookAndFeel");
        this.putClass("Fast", "com.jtattoo.plaf.fast.FastLookAndFeel");
        this.putClass("Graphite", "com.jtattoo.plaf.graphite.GraphiteLookAndFeel");
        this.putClass("HiFi", "com.jtattoo.plaf.hifi.HiFiLookAndFeel");
        this.putClass("Luna", "com.jtattoo.plaf.luna.LunaLookAndFeel");
        this.putClass("McWin", MCWIN_LAF_CLASS_NAME);
        this.putClass("Mint", "com.jtattoo.plaf.mint.MintLookAndFeel");
        this.putClass("Noire", "com.jtattoo.plaf.noire.NoireLookAndFeel");
        this.putClass("Smart", "com.jtattoo.plaf.smart.SmartLookAndFeel");
        this.putClass("Texture", "com.jtattoo.plaf.texture.TextureLookAndFeel");
    }

    public Class<?> getSkinClassForName(String skinName) {
        return this.lafMap.get(skinName);
    }

    public Set<String> getSkins() {
        TreeSet<String> result = new TreeSet<String>(this.lafMap.keySet());
        return result;
    }

    private void putClass(String skinName, String className) {
        try {
            Class<?> skinClass = Class.forName(className, true, this.cl);
            this.lafMap.put(skinName, skinClass);
        }
        catch (ClassNotFoundException e) {
            s_log.error((Object)("Unable to load LAF class (" + className + "):" + e.getMessage()), (Throwable)e);
        }
    }
}

