/*
 * This file contains D-Bus client proxy classes generated by qt-client-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <TelepathyQt/Types>

#include <QtGlobal>

#include <QString>
#include <QObject>
#include <QVariant>

#include <QDBusPendingReply>

#include <TelepathyQt/AbstractInterface>
#include <TelepathyQt/DBusProxy>
#include <TelepathyQt/Global>

namespace Tp
{
class PendingVariant;
class PendingOperation;
}

namespace Tp
{
namespace Client
{

/**
 * \class CallContentInterface
 * \headerfile TelepathyQt/call-content.h <TelepathyQt/CallContent>
 * \ingroup clientcall
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Call1.Content".
 */
class TP_QT_EXPORT CallContentInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Call1.Content", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Call1.Content");
    }

    /**
     * Creates a CallContentInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    CallContentInterface(Tp::DBusProxy *proxy);

    /**
     * Asynchronous getter for the remote object property \c Interfaces of type \c QStringList.
     *
     * 
     * \htmlonly
     * <p>Extra interfaces provided by this content, such as  \endhtmlonly CallContentInterfaceMediaInterface \htmlonly ,
     *    \endhtmlonly ChannelInterfaceHoldInterface \htmlonly  or
     *    \endhtmlonly CallInterfaceMuteInterface \htmlonly .
     *   This SHOULD NOT include the Content interface itself, and cannot
     *   change once the content has been created.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyInterfaces() const
    {
        return internalRequestProperty(QLatin1String("Interfaces"));
    }

    /**
     * Asynchronous getter for the remote object property \c Name of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The name of the content.</p>
     * 
     * <div class="rationale">
     *   The content name property should be meaningful, so should be
     *   given a name which is significant to the user. The name
     *   could be the "audio" or "video" string localized, or perhaps
     *   include some string identifying the source, such as a webcam
     *   identifier.
     * </div>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyName() const
    {
        return internalRequestProperty(QLatin1String("Name"));
    }

    /**
     * Asynchronous getter for the remote object property \c Type of type \c uint.
     *
     * 
     * \htmlonly
     * <p>The media type of this content.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyType() const
    {
        return internalRequestProperty(QLatin1String("Type"));
    }

    /**
     * Asynchronous getter for the remote object property \c Disposition of type \c uint.
     *
     * 
     * The disposition of this content.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyDisposition() const
    {
        return internalRequestProperty(QLatin1String("Disposition"));
    }

    /**
     * Asynchronous getter for the remote object property \c Streams of type \c Tp::ObjectPathList.
     *
     * 
     * \htmlonly
     * <p>The list of  \endhtmlonly CallStreamInterface \htmlonly  objects that exist in this
     *   content.</p>
     * 
     * <div class="rationale">
     *   In a conference call multiple parties can share one media
     *   content (say, audio), but the streaming of that media can
     *   either be shared or separate. For example, in a multicast
     *   conference all contacts would share one stream, while in a
     *   Muji conference there would be a stream for each
     *   participant.
     * </div>
     * 
     * <p>Change notification is through the
     *    \endhtmlonly StreamsAdded() \htmlonly  and
     *    \endhtmlonly StreamsRemoved() \htmlonly  signals.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyStreams() const
    {
        return internalRequestProperty(QLatin1String("Streams"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c Remove on the remote object.
     * 
     * Remove the content from the call. This will cause 
     * Call1.ContentRemoved((self_handle, User_Requested, &quot;&quot;, 
     * &quot;&quot;)) to be emitted.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Remove(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Remove"));
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c StreamsAdded on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when streams are added to a call.</p>
     * \endhtmlonly
     *
     * \param streams
     *     
     *     The Streams which were added.
     */
    void StreamsAdded(const Tp::ObjectPathList& streams);

    /**
     * Represents the signal \c StreamsRemoved on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when streams are removed from a call</p>
     * \endhtmlonly
     *
     * \param streams
     *     
     *     The Streams which were removed.
     *
     * \param reason
     *     
     *     Why the content was removed.
     */
    void StreamsRemoved(const Tp::ObjectPathList& streams, const Tp::CallStateReason& reason);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class CallContentInterfaceAudioControlInterface
 * \headerfile TelepathyQt/call-content.h <TelepathyQt/CallContent>
 * \ingroup clientcall
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Call1.Content.Interface.AudioControl".
 */
class TP_QT_EXPORT CallContentInterfaceAudioControlInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Call1.Content.Interface.AudioControl", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Call1.Content.Interface.AudioControl");
    }

    /**
     * Creates a CallContentInterfaceAudioControlInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentInterfaceAudioControlInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentInterfaceAudioControlInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentInterfaceAudioControlInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentInterfaceAudioControlInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    CallContentInterfaceAudioControlInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a CallContentInterfaceAudioControlInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit CallContentInterfaceAudioControlInterface(const Tp::Client::CallContentInterface& mainInterface);

    /**
     * Creates a CallContentInterfaceAudioControlInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    CallContentInterfaceAudioControlInterface(const Tp::Client::CallContentInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c RequestedInputVolume of type \c int.
     *
     * 
     * The input volume as requested by the Connection Manager. Initially and 
     * on any changes the client should change its input volume to match the 
     * requested volume.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRequestedInputVolume() const
    {
        return internalRequestProperty(QLatin1String("RequestedInputVolume"));
    }

    /**
     * Asynchronous getter for the remote object property \c RequestedOutputVolume of type \c int.
     *
     * 
     * The input volume as requested by the Connection Manager. Initially and 
     * on any changes the client should change its input volume to match the 
     * requested volume.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRequestedOutputVolume() const
    {
        return internalRequestProperty(QLatin1String("RequestedOutputVolume"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c ReportInputVolume on the remote object.
     * 
     * Report to the CM that the Content input volume has been changed by the 
     * client. It is the client&apos;s responsibility to change the input 
     * volume used for the content. However, the client MUST call this 
     * whenever it changes input volume for the content.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param volume
     *     
     *     Report the input volume level as set by the client.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> ReportInputVolume(int volume, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("ReportInputVolume"));
        callMessage << QVariant::fromValue(volume);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c ReportOutputVolume on the remote object.
     * 
     * Report to the CM that the content output volume has been changed by the 
     * client. It is the client&apos;s responsibility to change the output 
     * volume used for the content. However, the client MUST call this 
     * whenever it changes output volume for the content.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param volume
     *     
     *     Report the output volume level as set by the client.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> ReportOutputVolume(int volume, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("ReportOutputVolume"));
        callMessage << QVariant::fromValue(volume);
        return this->connection().asyncCall(callMessage, timeout);
    }

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class CallContentInterfaceDTMFInterface
 * \headerfile TelepathyQt/call-content.h <TelepathyQt/CallContent>
 * \ingroup clientcall
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Call1.Content.Interface.DTMF".
 */
class TP_QT_EXPORT CallContentInterfaceDTMFInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Call1.Content.Interface.DTMF", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Call1.Content.Interface.DTMF");
    }

    /**
     * Creates a CallContentInterfaceDTMFInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentInterfaceDTMFInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentInterfaceDTMFInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentInterfaceDTMFInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentInterfaceDTMFInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    CallContentInterfaceDTMFInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a CallContentInterfaceDTMFInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit CallContentInterfaceDTMFInterface(const Tp::Client::CallContentInterface& mainInterface);

    /**
     * Creates a CallContentInterfaceDTMFInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    CallContentInterfaceDTMFInterface(const Tp::Client::CallContentInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c CurrentlySendingTones of type \c bool.
     *
     * 
     * Indicates whether there are DTMF tones currently being sent in the 
     * channel. If so, the client should wait for StoppedTones signal before 
     * trying to send more tones.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCurrentlySendingTones() const
    {
        return internalRequestProperty(QLatin1String("CurrentlySendingTones"));
    }

    /**
     * Asynchronous getter for the remote object property \c DeferredTones of type \c QString.
     *
     * 
     * \htmlonly
     * <p>The tones waiting for the user to continue, if any.</p>
     * 
     * <p>When this property is set to a non-empty value,
     *    \endhtmlonly TonesDeferred() \htmlonly  is emitted.
     *   When any tones are played (i.e. whenever
     *    \endhtmlonly SendingTones() \htmlonly  is emitted),
     *   this property is reset to the empty string.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyDeferredTones() const
    {
        return internalRequestProperty(QLatin1String("DeferredTones"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c StartTone on the remote object.
     * 
     * Start sending a DTMF tone to all eligible streams in the channel. Where 
     * possible, the tone will continue until StopTone is called. On certain 
     * protocols, it may only be possible to send events with a predetermined 
     * length. In this case, the implementation MAY emit a fixed-length tone, 
     * and the StopTone method call SHOULD return NotAvailable. The client may 
     * wish to control the exact duration and timing of the tones sent as a 
     * result of user&apos;s interaction with the dialpad, thus starting and 
     * stopping the tone sending explicitly. Tone overlaping or queueing is 
     * not supported, so this method can only be called if no DTMF tones are 
     * already being played.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param event
     *     
     *     A numeric event code from the DTMF_Event enum.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> StartTone(uchar event, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("StartTone"));
        callMessage << QVariant::fromValue(event);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c StopTone on the remote object.
     * 
     * Stop sending any DTMF tones which have been started using the StartTone 
     * or MultipleTones methods. If there is no current tone, this method will 
     * do nothing. If MultipleTones was used, the client should not assume the 
     * sending has stopped immediately; instead, the client should wait for 
     * the StoppedTones signal. On some protocols it might be impossible to 
     * cancel queued tones immediately.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> StopTone(int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("StopTone"));
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c MultipleTones on the remote object.
     * 
     * Send multiple DTMF events to all eligible streams in the channel. Each 
     * tone will be played for an implementation-defined number of 
     * milliseconds (typically 250ms), followed by a gap before the next tone 
     * is played (typically 100ms). The duration and gap are defined by the 
     * protocol or connection manager. In cases where the client knows in 
     * advance the tone sequence it wants to send, it&apos;s easier to use 
     * this method than manually start and stop each tone in the sequence. The 
     * tone and gap lengths may need to vary for interoperability, according 
     * to the protocol and other implementations&apos; ability to recognise 
     * tones. At the time of writing, GStreamer uses a minimum of 250ms tones 
     * and 100ms gaps when playing in-band DTMF in the normal audio stream, or 
     * 70ms tones and 50ms gaps when encoding DTMF as audio/telephone-event. 
     * Tone overlaping or queueing is not supported, so this method can only 
     * be called if no DTMF tones are already being played.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param tones
     *     
     *     \htmlonly
     *     <p>A string representation of one or more DTMF
     *       events. Implementations of this method MUST support all of the
     *       following characters in this string:</p>
     *     
     *     <ul>
     *       <li>the digits 0-9, letters A-D and a-d, and symbols '*' and '#'
     *         correspond to the members of <tp:type>DTMF_Event</tp:type></li>
     *     
     *       <li>any of 'p', 'P', 'x', 'X' or ',' (comma) results in an
     *         implementation-defined pause, typically for 3 seconds</li>
     *     
     *       <li>'w' or 'W' waits for the user to continue, by stopping
     *         interpretation of the string, and if there is more to be played,
     *         emitting the  \endhtmlonly TonesDeferred() \htmlonly  signal
     *         with the rest of the string as its argument: see that signal
     *         for details</li>
     *     </ul>
     *     \endhtmlonly
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> MultipleTones(const QString& tones, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("MultipleTones"));
        callMessage << QVariant::fromValue(tones);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c TonesDeferred on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when 'w' or 'W', indicating "wait for the user to continue",
     *   is encountered while playing a DTMF string queued by
     *    \endhtmlonly MultipleTones() \htmlonly . Any queued DTMF events
     *   after the 'w', which have not yet been played, are placed in the
     *    \endhtmlonly \link requestPropertyDeferredTones() DeferredTones \endlink \htmlonly  property and copied
     *   into this signal's argument.</p>
     * 
     * <p>When the channel handler is ready to continue, it MAY pass the
     *   value of  \endhtmlonly \link requestPropertyDeferredTones() DeferredTones \endlink \htmlonly  to
     *    \endhtmlonly MultipleTones() \htmlonly , to resume sending.
     *   Alternatively, it MAY ignore the deferred tones, or even play
     *   different tones instead. Any deferred tones are discarded the next
     *   time a tone is played.</p>
     * 
     * <p>This signal SHOULD NOT be emitted if there is nothing left to play,
     *   i.e. if the 'w' was the last character in the DTMF string.</p>
     * \endhtmlonly
     *
     * \param tones
     *     
     *     The new non-empty value of DeferredTones.
     */
    void TonesDeferred(const QString& tones);

    /**
     * Represents the signal \c SendingTones on the remote object.
     * 
     * \htmlonly
     * <p>DTMF tone(s)are being sent to all eligible streams in the channel.
     * The signal is provided to indicating the fact that the streams are
     * currently being used to send one or more DTMF tones, so any other
     * media input is not getting through to the audio stream. It also
     * serves as a cue for the
     *  \endhtmlonly StopTone() \htmlonly  method.</p>
     * \endhtmlonly
     *
     * \param tones
     *     
     *     DTMF string (one or more events) that is to be played.
     */
    void SendingTones(const QString& tones);

    /**
     * Represents the signal \c StoppedTones on the remote object.
     * 
     * \htmlonly
     * <p>DTMF tones have finished playing on streams in this channel.</p>
     * \endhtmlonly
     *
     * \param cancelled
     *     
     *     True if the DTMF tones were actively cancelled via StopTone.
     */
    void StoppedTones(bool cancelled);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class CallContentInterfaceMediaInterface
 * \headerfile TelepathyQt/call-content.h <TelepathyQt/CallContent>
 * \ingroup clientcall
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Call1.Content.Interface.Media".
 */
class TP_QT_EXPORT CallContentInterfaceMediaInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Call1.Content.Interface.Media", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Call1.Content.Interface.Media");
    }

    /**
     * Creates a CallContentInterfaceMediaInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentInterfaceMediaInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentInterfaceMediaInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentInterfaceMediaInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentInterfaceMediaInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    CallContentInterfaceMediaInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a CallContentInterfaceMediaInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit CallContentInterfaceMediaInterface(const Tp::Client::CallContentInterface& mainInterface);

    /**
     * Creates a CallContentInterfaceMediaInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    CallContentInterfaceMediaInterface(const Tp::Client::CallContentInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c RemoteMediaDescriptions of type \c Tp::ContactMediaDescriptionPropertiesMap.
     *
     * 
     * A map from contact handles to descriptions supported by that contact. 
     * Keys of this map will appear in at most one RemoteMembers. See 
     * RemoteContact for more details on how to map between MediaDescriptions 
     * and Streams.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyRemoteMediaDescriptions() const
    {
        return internalRequestProperty(QLatin1String("RemoteMediaDescriptions"));
    }

    /**
     * Asynchronous getter for the remote object property \c LocalMediaDescriptions of type \c Tp::ContactMediaDescriptionPropertiesMap.
     *
     * 
     * A map from contact handles to the descriptions the local side responsed 
     * with.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyLocalMediaDescriptions() const
    {
        return internalRequestProperty(QLatin1String("LocalMediaDescriptions"));
    }

    /**
     * Asynchronous getter for the remote object property \c MediaDescriptionOffer of type \c Tp::MediaDescriptionOffer.
     *
     * 
     * \htmlonly
     * <p>The object path to the current
     *    \endhtmlonly CallContentMediaDescriptionInterface \htmlonly  object, its
     *      \endhtmlonly \link CallContentMediaDescriptionInterface::requestPropertyRemoteContact() CallContentMediaDescriptionInterface::RemoteContact \endlink \htmlonly  and
     *     a mapping of the MediaDescriptions properties.
     *     If the object path is "/" then there isn't an outstanding
     *     content description, and the mapping MUST be empty.</p>
     * 
     * <div class="rationale">
     *   Having all  \endhtmlonly CallContentMediaDescriptionInterface \htmlonly 
     *   properties here saves a D-Bus round-trip - it shouldn't be
     *   necessary to get these properties from the Content MediaDescription
     *   object, in practice.
     * </div>
     * 
     * <p>Change notification is via the
     *    \endhtmlonly NewMediaDescriptionOffer() \htmlonly  and
     *    \endhtmlonly MediaDescriptionOfferDone() \htmlonly  signals.
     *  </p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMediaDescriptionOffer() const
    {
        return internalRequestProperty(QLatin1String("MediaDescriptionOffer"));
    }

    /**
     * Asynchronous getter for the remote object property \c Packetization of type \c uint.
     *
     * 
     * \htmlonly
     * <p>The packetization method in use for this content.</p>
     * \endhtmlonly
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyPacketization() const
    {
        return internalRequestProperty(QLatin1String("Packetization"));
    }

    /**
     * Asynchronous getter for the remote object property \c CurrentDTMFEvent of type \c uchar.
     *
     * 
     * The currently requested DTMF event (for state-recoverability of 
     * DTMFChangeRequested). Should be ignored if CurrentDTMFState is None.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCurrentDTMFEvent() const
    {
        return internalRequestProperty(QLatin1String("CurrentDTMFEvent"));
    }

    /**
     * Asynchronous getter for the remote object property \c CurrentDTMFState of type \c uint.
     *
     * 
     * The current DTMF state (for state-recoverability of 
     * DTMFChangeRequested).
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyCurrentDTMFState() const
    {
        return internalRequestProperty(QLatin1String("CurrentDTMFState"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

public Q_SLOTS:
    /**
     * Begins a call to the D-Bus method \c UpdateLocalMediaDescription on the remote object.
     * 
     * Update the local codec mapping and other interfaces of the 
     * MediaDescription. This method should only be used during an existing 
     * call to update the local media description. This may trigger a 
     * re-negotiation which may result in new new MediaDescriptionOffers if 
     * the &quot;FurtherNegotiationRequired&quot; property is TRUE. Otherwise, 
     * only parameters which strictly describe the media being sent can be 
     * changed.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param mediaDescription
     *     
     *     The updated media description that the local side wants to use.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> UpdateLocalMediaDescription(const QVariantMap& mediaDescription, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("UpdateLocalMediaDescription"));
        callMessage << QVariant::fromValue(mediaDescription);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c AcknowledgeDTMFChange on the remote object.
     * 
     * Called by the streaming implementation in response to 
     * DTMFChangeRequested to confirm that it has started or stopped sending 
     * the event in question.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param event
     *     
     *     The event referred to in the corresponding DTMFChangeRequested 
     *     signal.
     *
     * \param state
     *     
     *     Either Sending or None.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> AcknowledgeDTMFChange(uchar event, uint state, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("AcknowledgeDTMFChange"));
        callMessage << QVariant::fromValue(event) << QVariant::fromValue(state);
        return this->connection().asyncCall(callMessage, timeout);
    }

    /**
     * Begins a call to the D-Bus method \c Fail on the remote object.
     * 
     * Signal an unrecoverable error for this content, and remove it.
     *
     * Note that \a timeout is ignored as of now. It will be used once
     * http://bugreports.qt.nokia.com/browse/QTBUG-11775 is fixed.
     *
     *
     * \param reason
     *     
     *     A reason struct describing the error.
     * \param timeout The timeout in milliseconds.
     */
    inline QDBusPendingReply<> Fail(const Tp::CallStateReason& reason, int timeout = -1)
    {
        if (!invalidationReason().isEmpty()) {
            return QDBusPendingReply<>(QDBusMessage::createError(
                invalidationReason(),
                invalidationMessage()
            ));
        }

        QDBusMessage callMessage = QDBusMessage::createMethodCall(this->service(), this->path(),
                this->staticInterfaceName(), QLatin1String("Fail"));
        callMessage << QVariant::fromValue(reason);
        return this->connection().asyncCall(callMessage, timeout);
    }

Q_SIGNALS:
    /**
     * Represents the signal \c NewMediaDescriptionOffer on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when a new  \endhtmlonly CallContentMediaDescriptionInterface \htmlonly  appears. The streaming
     *   &gt;implementation MUST respond by calling the
     *    \endhtmlonly CallContentMediaDescriptionInterface::Accept() \htmlonly  or  \endhtmlonly CallContentMediaDescriptionInterface::Reject() \htmlonly  method on the description object appeared.</p>
     * 
     * <p>Emission of this signal indicates that the
     *    \endhtmlonly \link requestPropertyMediaDescriptionOffer() MediaDescriptionOffer \endlink \htmlonly  property has
     *   changed to
     *     <code>(Description, Contact, MediaDescriptionProperties)</code>.</p>
     * 
     * <p>When the MediaDescriptionOffer has been dealt with then
     *    \endhtmlonly CallContentInterfaceMediaInterface::MediaDescriptionOfferDone() \htmlonly  must be emitted
     *   before  \endhtmlonly CallContentInterfaceMediaInterface::NewMediaDescriptionOffer() \htmlonly  is emitted again.
     * </p>
     * \endhtmlonly
     *
     * \param mediaDescription
     *     
     *     The object path of the new media description. This replaces any 
     *     previous media description.
     *
     * \param properties
     *     
     *     The immutable properties of the remote media description. Having 
     *     all the MediaDescription properties here saves a D-Bus round-trip - 
     *     it shouldn&apos;t be necessary to get the properties from the 
     *     MediaDescription object, in practice.
     */
    void NewMediaDescriptionOffer(const QDBusObjectPath& mediaDescription, const QVariantMap& properties);

    /**
     * Represents the signal \c MediaDescriptionOfferDone on the remote object.
     * 
     * \htmlonly
     * <p>Emitted when a  \endhtmlonly CallContentMediaDescriptionInterface \htmlonly  has been handled. </p>
     * <p>Emission of this signal indicates that the
     *    \endhtmlonly \link requestPropertyMediaDescriptionOffer() MediaDescriptionOffer \endlink \htmlonly  property has
     *   changed to
     *     <code>("/", 0, {})</code>.</p>
     * \endhtmlonly
     */
    void MediaDescriptionOfferDone();

    /**
     * Represents the signal \c LocalMediaDescriptionChanged on the remote object.
     * 
     * \htmlonly
     * <p>Change notification for
     *      \endhtmlonly \link CallContentInterfaceMediaInterface::requestPropertyLocalMediaDescriptions() CallContentInterfaceMediaInterface::LocalMediaDescriptions \endlink \htmlonly 
     * </p>
     * \endhtmlonly
     *
     * \param updatedMediaDescription
     *     
     *     \htmlonly
     *     <p>The local content description that was updated</p>
     *     \endhtmlonly
     */
    void LocalMediaDescriptionChanged(const QVariantMap& updatedMediaDescription);

    /**
     * Represents the signal \c RemoteMediaDescriptionsChanged on the remote object.
     * 
     * \htmlonly
     * <p>Change notification for
     *      \endhtmlonly \link CallContentInterfaceMediaInterface::requestPropertyRemoteMediaDescriptions() CallContentInterfaceMediaInterface::RemoteMediaDescriptions \endlink \htmlonly 
     * </p>
     * \endhtmlonly
     *
     * \param updatedMediaDescriptions
     *     
     *     \htmlonly
     *     <p>The remote content descriptions that were updated</p>
     *     \endhtmlonly
     */
    void RemoteMediaDescriptionsChanged(const Tp::ContactMediaDescriptionPropertiesMap& updatedMediaDescriptions);

    /**
     * Represents the signal \c MediaDescriptionsRemoved on the remote object.
     * 
     * \htmlonly
     * <p>Removal notification for
     *      \endhtmlonly \link CallContentInterfaceMediaInterface::requestPropertyRemoteMediaDescriptions() CallContentInterfaceMediaInterface::RemoteMediaDescriptions \endlink \htmlonly 
     *     and
     *      \endhtmlonly \link CallContentInterfaceMediaInterface::requestPropertyLocalMediaDescriptions() CallContentInterfaceMediaInterface::LocalMediaDescriptions \endlink \htmlonly 
     * </p>
     * \endhtmlonly
     *
     * \param removedMediaDescriptions
     *     
     *     \htmlonly
     *     <p>The local and remote content descriptions that are no longer part
     *        of this content</p>
     *     \endhtmlonly
     */
    void MediaDescriptionsRemoved(const Tp::UIntList& removedMediaDescriptions);

    /**
     * Represents the signal \c DTMFChangeRequested on the remote object.
     * 
     * Used by the CM to relay instructions from Channel.Interface.DTMF to the 
     * streaming implementation. If any contact in this call supports the 
     * telephone-event codec in their MediaDescription, this event should be 
     * sent as outlined in RFC 4733. Otherwise, it should be sent as an 
     * audible tone.
     *
     * \param event
     *     
     *     The event to send (or stop sending).
     *
     * \param state
     *     
     *     Either Pending_Send or Pending_Stop_Sending.
     */
    void DTMFChangeRequested(uchar event, uint state);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};

/**
 * \class CallContentInterfaceVideoControlInterface
 * \headerfile TelepathyQt/call-content.h <TelepathyQt/CallContent>
 * \ingroup clientcall
 *
 * Proxy class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Call1.Content.Interface.VideoControl".
 */
class TP_QT_EXPORT CallContentInterfaceVideoControlInterface : public Tp::AbstractInterface
{
    Q_OBJECT

public:
    /**
     * Returns the name of the interface "org.freedesktop.Telepathy.Call1.Content.Interface.VideoControl", which this class
     * represents.
     *
     * \return The D-Bus interface name.
     */
    static inline QLatin1String staticInterfaceName()
    {
        return QLatin1String("org.freedesktop.Telepathy.Call1.Content.Interface.VideoControl");
    }

    /**
     * Creates a CallContentInterfaceVideoControlInterface associated with the given object on the session bus.
     *
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentInterfaceVideoControlInterface(
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentInterfaceVideoControlInterface associated with the given object on the given bus.
     *
     * \param connection The bus via which the object can be reached.
     * \param busName Name of the service the object is on.
     * \param objectPath Path to the object on the service.
     * \param parent Passed to the parent class constructor.
     */
    CallContentInterfaceVideoControlInterface(
        const QDBusConnection& connection,
        const QString& busName,
        const QString& objectPath,
        QObject* parent = 0
    );

    /**
     * Creates a CallContentInterfaceVideoControlInterface associated with the same object as the given proxy.
     *
     * \param proxy The proxy to use. It will also be the QObject::parent()
     *               for this object.
     */
    CallContentInterfaceVideoControlInterface(Tp::DBusProxy *proxy);

    /**
     * Creates a CallContentInterfaceVideoControlInterface associated with the same object as the given proxy.
     * Additionally, the created proxy will have the same parent as the given
     * proxy.
     *
     * \param mainInterface The proxy to use.
     */
    explicit CallContentInterfaceVideoControlInterface(const Tp::Client::CallContentInterface& mainInterface);

    /**
     * Creates a CallContentInterfaceVideoControlInterface associated with the same object as the given proxy.
     * However, a different parent object can be specified.
     *
     * \param mainInterface The proxy to use.
     * \param parent Passed to the parent class constructor.
     */
    CallContentInterfaceVideoControlInterface(const Tp::Client::CallContentInterface& mainInterface, QObject* parent);

    /**
     * Asynchronous getter for the remote object property \c VideoResolution of type \c Tp::VideoResolution.
     *
     * 
     * The resolution at which the streaming engine should be sending. Change 
     * notification is via the VideoResolutionChanged signal.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyVideoResolution() const
    {
        return internalRequestProperty(QLatin1String("VideoResolution"));
    }

    /**
     * Asynchronous getter for the remote object property \c Bitrate of type \c uint.
     *
     * 
     * The bitrate the streaming engine should be sending at. Change 
     * notification is via the BitrateChanged signal.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyBitrate() const
    {
        return internalRequestProperty(QLatin1String("Bitrate"));
    }

    /**
     * Asynchronous getter for the remote object property \c Framerate of type \c uint.
     *
     * 
     * The framerate the streaming engine should be sending at. Change 
     * notification is via the FramerateChanged signal.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyFramerate() const
    {
        return internalRequestProperty(QLatin1String("Framerate"));
    }

    /**
     * Asynchronous getter for the remote object property \c MTU of type \c uint.
     *
     * 
     * The Maximum Transmission Unit Change notification is via the MTUChanged 
     * signal.
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyMTU() const
    {
        return internalRequestProperty(QLatin1String("MTU"));
    }

    /**
     * Asynchronous getter for the remote object property \c ManualKeyFrames of type \c bool.
     *
     * 
     * Only send key frames when manually requested
     *
     * \return A pending variant which will emit finished when the property has been
     *          retrieved.
     */
    inline Tp::PendingVariant *requestPropertyManualKeyFrames() const
    {
        return internalRequestProperty(QLatin1String("ManualKeyFrames"));
    }

    /**
     * Request all of the DBus properties on the interface.
     *
     * \return A pending variant map which will emit finished when the properties have
     *          been retrieved.
     */
    Tp::PendingVariantMap *requestAllProperties() const
    {
        return internalRequestAllProperties();
    }

Q_SIGNALS:
    /**
     * Represents the signal \c KeyFrameRequested on the remote object.
     * 
     * Request that the video encoder produce a new key frame as soon as 
     * possible.
     */
    void KeyFrameRequested();

    /**
     * Represents the signal \c VideoResolutionChanged on the remote object.
     * 
     * The desired video resolution has changed.
     */
    void VideoResolutionChanged(const Tp::VideoResolution& newResolution);

    /**
     * Represents the signal \c BitrateChanged on the remote object.
     * 
     * The desired bitrate has changed
     */
    void BitrateChanged(uint newBitrate);

    /**
     * Represents the signal \c FramerateChanged on the remote object.
     * 
     * The desired framerate has changed
     */
    void FramerateChanged(uint newFramerate);

    /**
     * Represents the signal \c MTUChanged on the remote object.
     * 
     * The Maximum Transmission Unit has changed
     */
    void MTUChanged(uint newMTU);

protected:
    virtual void invalidate(Tp::DBusProxy *, const QString &, const QString &);
};
}
}
Q_DECLARE_METATYPE(Tp::Client::CallContentInterface*)
Q_DECLARE_METATYPE(Tp::Client::CallContentInterfaceAudioControlInterface*)
Q_DECLARE_METATYPE(Tp::Client::CallContentInterfaceDTMFInterface*)
Q_DECLARE_METATYPE(Tp::Client::CallContentInterfaceMediaInterface*)
Q_DECLARE_METATYPE(Tp::Client::CallContentInterfaceVideoControlInterface*)
