/*
 * This file contains D-Bus adaptor classes generated by qt-svc-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#include <TelepathyQt/AbstractAdaptor>
#include <TelepathyQt/Global>
#include <TelepathyQt/Types>

#include <QObject>
#include <QtDBus>

namespace Tp
{
namespace Service
{

/**
 * \class ConnectionManagerAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection-manager.h <TelepathyQt/_gen/svc-connection-manager.h>
 * \ingroup servicecm
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.ConnectionManager".
 */
class TP_QT_EXPORT ConnectionManagerAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.ConnectionManager")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.ConnectionManager\">\n"
"    <property access=\"read\" type=\"a{sa{sv}}\" name=\"Protocols\">\n"
"      <annotation value=\"Tp::ProtocolPropertiesMap\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"as\" name=\"Interfaces\"/>\n"
"    <method name=\"GetParameters\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"protocol\"/>\n"
"      <arg direction=\"out\" type=\"a(susv)\" name=\"parameters\">\n"
"        <annotation value=\"Tp::ParamSpecList\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"ListProtocols\">\n"
"      <arg direction=\"out\" type=\"as\" name=\"protocols\"/>\n"
"    </method>\n"
"    <method name=\"RequestConnection\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"protocol\"/>\n"
"      <arg direction=\"in\" type=\"a{sv}\" name=\"parameters\">\n"
"        <annotation value=\"QVariantMap\" name=\"com.trolltech.QtDBus.QtTypeName.In1\"/>\n"
"      </arg>\n"
"      <arg direction=\"out\" type=\"s\" name=\"busName\"/>\n"
"      <arg direction=\"out\" type=\"o\" name=\"objectPath\"/>\n"
"    </method>\n"
"    <signal name=\"NewConnection\">\n"
"      <arg type=\"s\" name=\"busName\"/>\n"
"      <arg type=\"o\" name=\"objectPath\"/>\n"
"      <arg type=\"s\" name=\"protocol\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(Tp::ProtocolPropertiesMap Protocols READ Protocols )
    Q_PROPERTY(QStringList Interfaces READ Interfaces )

public:
    ConnectionManagerAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionManagerAdaptor();

    typedef Tp::MethodInvocationContextPtr< Tp::ParamSpecList > GetParametersContextPtr;
    typedef Tp::MethodInvocationContextPtr< QStringList > ListProtocolsContextPtr;
    typedef Tp::MethodInvocationContextPtr< QString, QDBusObjectPath > RequestConnectionContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c Protocols of type \c Tp::ProtocolPropertiesMap.
     *
     * Adaptees should export this property as a Qt property named
     * 'protocols' with type Tp::ProtocolPropertiesMap.
     *
     * 
     * \htmlonly
     * <p>A map from protocol identifiers supported by this connection
     *   manager to the immutable properties of the corresponding
     *    \endhtmlonly ProtocolInterface \htmlonly  objects.</p>
     * 
     * <div class="rationale">
     *   <p>Providing the immutable properties here means that
     *     when the API of Protocol objects has been finalized,
     *     most clients will only need one D-Bus round trip to interrogate
     *     the ConnectionManager about all its protocols.</p>
     * </div>
     * 
     * <p>If this map is empty or missing, clients SHOULD fall back to
     *   calling  \endhtmlonly ListProtocols() \htmlonly  and
     *    \endhtmlonly GetParameters() \htmlonly .</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Protocols.
     */
    Tp::ProtocolPropertiesMap Protocols() const;
    /**
     * Return the value of the exported D-Bus object property \c Interfaces of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'interfaces' with type QStringList.
     *
     * 
     * \htmlonly
     * <p>A list of the extra interfaces provided by this connection manager
     *   (i.e. extra functionality that can be provided even before a
     *   connection has been created).</p>
     * 
     * <p>No interfaces suitable for listing in this property are currently
     *   defined; it's provided as a hook for possible future
     *   functionality.</p>
     * 
     * <p>To be compatible with older connection managers, if retrieving
     *   this property fails, clients SHOULD assume that its value is
     *   an empty list.</p>
     * 
     * <p>Connection managers with a non-empty list of Interfaces MUST
     *   represent them in the <code>.manager</code> file, if they have one,
     *   as an <code>Interfaces</code> key in the
     *   group headed <code>[ConnectionManager]</code>, whose value is a list
     *   of strings each followed by a semicolon.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Interfaces.
     */
    QStringList Interfaces() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c GetParameters on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getParameters(const QString& protocol, const Tp::Service::ConnectionManagerAdaptor::GetParametersContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Get a list of the parameters which may be specified in the Parameters 
     * of an Account (or, for specialised applications which do not use the 
     * account manager, passed to RequestConnection). Some parameters are 
     * mandatory, and some parameters only make sense when registering new 
     * accounts with the server; see the Param_Spec documentation for more 
     * details.
     *
     * \param protocol
     *     
     *     The required protocol name
     * \return
     *     
     *     \htmlonly
     *     An array of structs representing possible parameters.
     *     \endhtmlonly
     */
    Tp::ParamSpecList GetParameters(const QString& protocol, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c ListProtocols on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void listProtocols(const Tp::Service::ConnectionManagerAdaptor::ListProtocolsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Get a list of protocol identifiers that are implemented by this 
     * connection manager.
     *
     * \return
     *     
     *     The keys of the Protocols map.
     */
    QStringList ListProtocols(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RequestConnection on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void requestConnection(const QString& protocol, const QVariantMap& parameters, const Tp::Service::ConnectionManagerAdaptor::RequestConnectionContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Request a
     *    \endhtmlonly ConnectionInterface \htmlonly 
     *   object representing a given account on a given
     *   protocol with the given parameters. The method returns the bus name
     *   and the object path where the new Connection object can be found,
     *   which should have the status of Connection_Status_Disconnected, to
     *   allow signal handlers to be attached before connecting is started
     *   with the
     *    \endhtmlonly ConnectionInterface::Connect() \htmlonly 
     *   method.</p>
     * 
     * <p><strong>Most applications should not use this method</strong>: they
     *   should instead use the the  \endhtmlonly \link AccountInterface::requestPropertyConnection() AccountInterface::Connection \endlink \htmlonly  property on an
     *    \endhtmlonly AccountInterface \htmlonly  object obtained
     *   from the  \endhtmlonly AccountManagerInterface \htmlonly . This method is used
     *   internally by the account manager to create connections when
     *   needed.</p>
     * 
     * <p>The parameters which must and may be provided in the parameters
     * dictionary can be discovered with the
     *  \endhtmlonly GetParameters() \htmlonly  method. These
     * parameters, their types, and their default values may be cached
     * in files so that all available connection managers do not need to be
     * started to discover which protocols are available.</p>
     * 
     * <p>To request values for these parameters from the user, a client must
     * have prior knowledge of the meaning of the parameter names, so the
     * well-known names and types defined by the
     * <tp:type>Connection_Parameter_Name</tp:type> type should be used where
     * appropriate.</p>
     * 
     * <p>Connection manager authors SHOULD avoid introducing parameters
     *   whose default values would not be serializable in a
     *   <code>.manager</code> file.</p>
     * 
     * <div class="rationale">
     *   <p>The same serialization format is used in Mission Control
     *     to store accounts.</p>
     * </div>
     * 
     * <p>Every successful RequestConnection call will cause the emission of a
     *  \endhtmlonly NewConnection() \htmlonly  signal for the same newly
     * created connection. The
     * requester can use the returned object path and service name
     * independently of the emission of that signal. In that case this signal
     * emission is most useful for, e.g. other processes that are monitoring
     * the creation of new connections.</p>
     * \endhtmlonly
     *
     * \param protocol
     *     
     *     The protocol identifier
     * \param parameters
     *     
     *     A dictionary mapping parameter names to values of the appropriate 
     *     type, as indicated by GetParameters and the well-known list of 
     *     names and value types documented on the Connection_Parameter_Name 
     *     type.
     * \param objectPath Output parameter
     *     
     *     The D-Bus object path to the Connection on this service
     * \return
     *     
     *     A D-Bus service name where the new Connection object can be found
     */
    QString RequestConnection(const QString& protocol, const QVariantMap& parameters, const QDBusMessage& dbusMessage, QDBusObjectPath& objectPath);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c NewConnection on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void newConnection(const QString& busName, const QDBusObjectPath& objectPath, const QString& protocol);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param busName
     *     
     *     The D-Bus service where the connection object can be found
     * \param objectPath
     *     
     *     The object path of the Connection object on this service
     * \param protocol
     *     
     *     The identifier for the protocol this connection uses
     */
    void NewConnection(const QString& busName, const QDBusObjectPath& objectPath, const QString& protocol);
};

/**
 * \class ProtocolAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection-manager.h <TelepathyQt/_gen/svc-connection-manager.h>
 * \ingroup servicecm
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Protocol".
 */
class TP_QT_EXPORT ProtocolAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Protocol")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Protocol\">\n"
"    <property access=\"read\" type=\"as\" name=\"Interfaces\"/>\n"
"    <property access=\"read\" type=\"a(susv)\" name=\"Parameters\">\n"
"      <annotation value=\"Tp::ParamSpecList\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"as\" name=\"ConnectionInterfaces\"/>\n"
"    <property access=\"read\" type=\"a(a{sv}as)\" name=\"RequestableChannelClasses\">\n"
"      <annotation value=\"Tp::RequestableChannelClassList\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"s\" name=\"VCardField\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"EnglishName\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"Icon\"/>\n"
"    <property access=\"read\" type=\"as\" name=\"AuthenticationTypes\"/>\n"
"    <method name=\"IdentifyAccount\">\n"
"      <arg direction=\"in\" type=\"a{sv}\" name=\"parameters\">\n"
"        <annotation value=\"QVariantMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"      <arg direction=\"out\" type=\"s\" name=\"accountID\"/>\n"
"    </method>\n"
"    <method name=\"NormalizeContact\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"contactID\"/>\n"
"      <arg direction=\"out\" type=\"s\" name=\"normalizedContactID\"/>\n"
"    </method>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QStringList Interfaces READ Interfaces )
    Q_PROPERTY(Tp::ParamSpecList Parameters READ Parameters )
    Q_PROPERTY(QStringList ConnectionInterfaces READ ConnectionInterfaces )
    Q_PROPERTY(Tp::RequestableChannelClassList RequestableChannelClasses READ RequestableChannelClasses )
    Q_PROPERTY(QString VCardField READ VCardField )
    Q_PROPERTY(QString EnglishName READ EnglishName )
    Q_PROPERTY(QString Icon READ Icon )
    Q_PROPERTY(QStringList AuthenticationTypes READ AuthenticationTypes )

public:
    ProtocolAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ProtocolAdaptor();

    typedef Tp::MethodInvocationContextPtr< QString > IdentifyAccountContextPtr;
    typedef Tp::MethodInvocationContextPtr< QString > NormalizeContactContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c Interfaces of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'interfaces' with type QStringList.
     *
     * 
     * \htmlonly
     * <p>A list of interfaces supported by this Protocol object.</p>
     * 
     * <p>This property should not be confused with
     *    \endhtmlonly \link requestPropertyConnectionInterfaces() ConnectionInterfaces \endlink \htmlonly ,
     *   which refers to the interfaces of <em>connections</em> to this
     *   protocol.</p>
     * 
     * <p>Connection managers with a <code>.manager</code> file
     *   (as described as part of the
     *    \endhtmlonly ConnectionManagerInterface \htmlonly  interface) MUST cache this
     *   property in the protocol's section of the <code>.manager</code>
     *   file, using the key <code>Interfaces</code>. The corresponding value
     *   is a list of D-Bus interface names, each followed by a semicolon.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Interfaces.
     */
    QStringList Interfaces() const;
    /**
     * Return the value of the exported D-Bus object property \c Parameters of type \c Tp::ParamSpecList.
     *
     * Adaptees should export this property as a Qt property named
     * 'parameters' with type Tp::ParamSpecList.
     *
     * 
     * \htmlonly
     * <p>The parameters which may be specified in the
     *    \endhtmlonly \link AccountInterface::requestPropertyParameters() AccountInterface::Parameters \endlink \htmlonly  of an
     *    \endhtmlonly AccountInterface \htmlonly  (or, for
     *   specialised applications which do not use the account manager, passed
     *   to  \endhtmlonly ConnectionManagerInterface::RequestConnection() \htmlonly ).
     *   Some parameters are mandatory, and some parameters only make sense
     *   when registering new accounts with the server; see the
     *   <tp:type>Param_Spec</tp:type> documentation for more details.</p>
     * 
     * <p>Connection managers with a <code>.manager</code> file
     *   (as described as part of the
     *    \endhtmlonly ConnectionManagerInterface \htmlonly  interface) MUST cache this
     *   property in the protocol's section of the <code>.manager</code>
     *   file via keys of the form <code>param-<em>p</em></code> and
     *   <code>default-<em>p</em></code>, as documented in the
     *    \endhtmlonly ConnectionManagerInterface \htmlonly  interface.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Parameters.
     */
    Tp::ParamSpecList Parameters() const;
    /**
     * Return the value of the exported D-Bus object property \c ConnectionInterfaces of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'connectionInterfaces' with type QStringList.
     *
     * 
     * \htmlonly
     * <p>A list of interface names which might be in the
     *    \endhtmlonly \link ConnectionInterface::requestPropertyInterfaces() ConnectionInterface::Interfaces \endlink \htmlonly  property of a
     *    \endhtmlonly ConnectionInterface \htmlonly  to this protocol. Whether a Connection
     *   will have all, some or none of these interfaces depends on server
     *   capabilities.</p>
     * 
     * <p>This property should not be confused with
     *    \endhtmlonly \link requestPropertyInterfaces() Interfaces \endlink \htmlonly .</p>
     * 
     * <p>Connection managers with a <code>.manager</code> file
     *   MUST cache this property in the protocol's section of the
     *   <code>.manager</code> file, using the key
     *   <code>ConnectionInterfaces</code>. The corresponding value
     *   is a list of D-Bus interface names, each followed by a semicolon.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c ConnectionInterfaces.
     */
    QStringList ConnectionInterfaces() const;
    /**
     * Return the value of the exported D-Bus object property \c RequestableChannelClasses of type \c Tp::RequestableChannelClassList.
     *
     * Adaptees should export this property as a Qt property named
     * 'requestableChannelClasses' with type Tp::RequestableChannelClassList.
     *
     * 
     * \htmlonly
     *         <p>A list of channel classes which might be requestable from a
     *            \endhtmlonly ConnectionInterface \htmlonly  to this protocol (i.e. they will,
     *           or might, appear in the Connection's  \endhtmlonly \link ConnectionInterfaceRequestsInterface::requestPropertyRequestableChannelClasses() ConnectionInterfaceRequestsInterface::RequestableChannelClasses \endlink \htmlonly  property).</p>
     * 
     *         <p>Whether a Connection will have all, some or none of these
     *           requestable channel classes depends on server capabilities;
     *           similarly, individual contacts are not guaranteed to support
     *           all of these channel classes.</p>
     * 
     *         <p>Connection managers with a <code>.manager</code> file
     *           MUST cache this property in the protocol's section of the
     *           <code>.manager</code> file, using the key
     *           <code>RequestableChannelClasses</code>. The corresponding value
     *           is a list of opaque strings, each followed by a semicolon; each
     *           of those strings is the name of a group in the <code>.manager</code>
     *           file which represents a channel class.</p>
     * 
     *         <p>The names of the groups representing channel classes are not
     *           significant, and MUST NOT be interpreted. When writing
     *           <tt>.manager</tt> files, authors MAY choose mnemonic group names,
     *           generate group names mechanically (e.g. with an incrementing
     *           integer), or use some combination of these.</p>
     * 
     *         <p>Each group representing a channel class has a key
     *           <code>allowed</code> which is a list of D-Bus property names
     *           representing allowed parameters. Any other keys that do not contain
     *           a space MUST be ignored. Any key containing a space represents
     *           a fixed property; the key has the form
     *           "<code><em>propertyname</em> <em>type</em></code>", and the value
     *           is encoded in the same way as for the <code>default-<em>p</em></code>
     *           keys described in the  \endhtmlonly ConnectionManagerInterface \htmlonly  documentation.</p>
     * 
     *         <p>Connection managers that have channel classes whose fixed
     *           properties are not representable in this form SHOULD NOT have
     *           <code>.manager</code> files.</p>
     * 
     *         <p>For instance, this <code>.manager</code> file could represent
     *           a connection manager that supports 1-1 Text messages and
     *           StreamedMedia audio calls:</p>
     * 
     * <pre>[Protocol jabber]
     * param-account=s required
     * param-password=s required
     * RequestableChannelClasses=rcc0;rcc1;
     * 
     * [rcc0]
     * org.freedesktop.Telepathy.Channel.ChannelType s=org.freedesktop.Telepathy.Channel.Type.Text
     * org.freedesktop.Telepathy.Channel.TargetHandleType u=1
     * allowed=org.freedesktop.Telepathy.Channel.TargetHandle;org.freedesktop.Telepathy.Channel.TargetID;
     * 
     * [rcc1]
     * org.freedesktop.Telepathy.Channel.ChannelType s=org.freedesktop.Telepathy.Channel.Type.StreamedMedia
     * org.freedesktop.Telepathy.Channel.TargetHandleType u=1
     * allowed=org.freedesktop.Telepathy.Channel.TargetHandle;org.freedesktop.Telepathy.Channel.TargetID;org.freedesktop.Telepathy.Channel.Type.StreamedMedia.InitialAudio;
     * </pre>
     * \endhtmlonly
     *
     * \return The value of exported property \c RequestableChannelClasses.
     */
    Tp::RequestableChannelClassList RequestableChannelClasses() const;
    /**
     * Return the value of the exported D-Bus object property \c VCardField of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'vcardField' with type QString.
     *
     * 
     * \htmlonly
     * <p>The name of the most common vCard field used for this protocol's
     *   contact identifiers, normalized to lower case, or the empty string
     *   if there is no such field.</p>
     * 
     * <p>For example, this would be <code>x-jabber</code> for
     *   Jabber/XMPP (including Google Talk), or <code>tel</code> for
     *   the <abbr title="Public Switched Telephone Network">PSTN</abbr>.</p>
     * 
     * <p>A more exhaustive list of addressable vCard fields can be found in
     *   the Protocol's Addressing interface's
     *    \endhtmlonly \link ProtocolInterfaceAddressingInterface::requestPropertyAddressableVCardFields() ProtocolInterfaceAddressingInterface::AddressableVCardFields \endlink \htmlonly .</p>
     * 
     * <p>It is not necessarily valid to interpret contacts' identifiers
     *   as values of this vCard field. For instance, telepathy-sofiasip
     *   supports contacts whose identifiers are of the form
     *   sip:jenny@example.com or tel:8675309, which would not normally
     *   both be represented by any single vCard field. Arbitrary
     *   handles/identifiers as vCard fields are represented
     *   through the Connection's
     *    \endhtmlonly ConnectionInterfaceAddressingInterface \htmlonly 
     *   contact attributes.</p>
     * 
     * <div class="rationale">
     *   <p>This is taken from Mission Control profiles as used on Maemo 5.
     *     One valid use of this field is to answer the question: given a
     *     contact's vCard containing an X-JABBER field, how can you
     *     communicate with the contact? By iterating through protocols
     *     looking for an x-jabber VCardField, one can build up a list of
     *     protocols that handle x-jabber, then offer the user a list of
     *     accounts for those protocols and/or the option to create a new
     *     account for one of those protocols.</p>
     * </div>
     * 
     * <p>Connection managers with a <code>.manager</code> file
     *   MUST cache this property in the protocol's section of the
     *   <code>.manager</code> file if it is non-empty, using the key
     *   <code>VCardField</code>. The corresponding value
     *   is a string, following the syntax of the "localestring" type from
     *   the Desktop Entry Specification.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c VCardField.
     */
    QString VCardField() const;
    /**
     * Return the value of the exported D-Bus object property \c EnglishName of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'englishName' with type QString.
     *
     * 
     * \htmlonly
     * <p>The name of the protocol in a form suitable for display to users,
     *   such as "AIM" or "Yahoo!", or the empty string if none is
     *   available.</p>
     * 
     * <p>This is effectively in the C locale (international English);
     *   user interfaces requiring a localized protocol name SHOULD look
     *   one up in their own message catalog based on either the Telepathy
     *   <tp:type>Protocol</tp:type> name or this property, but SHOULD use
     *   this English version as a fallback if no translated version can be
     *   found.</p>
     * 
     * <div class="rationale">
     *   <p>Many protocols are named after a company or product which isn't
     *     translated in non-English locales. This also provides a fallback
     *     display name, for UIs with no prior knowledge of a particular
     *     protocol.</p>
     * </div>
     * 
     * <p>If this property's value is empty, clients MAY fall back to using
     *   the Telepathy <tp:type>Protocol</tp:type> name, possibly with its
     *   capitalization adjusted.</p>
     * 
     * <p>Connection managers with a <code>.manager</code> file
     *   MUST cache this property in the protocol's section of the
     *   <code>.manager</code> file if it is non-empty, using the key
     *   <code>EnglishName</code>. The corresponding value
     *   is a string, following the syntax of the "localestring" type from
     *   the Desktop Entry Specification.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c EnglishName.
     */
    QString EnglishName() const;
    /**
     * Return the value of the exported D-Bus object property \c Icon of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'icon' with type QString.
     *
     * 
     * \htmlonly
     * <p>The name of an icon in the system's icon theme, such as "im-msn", or
     *   the empty string.</p>
     * 
     * <div class="rationale">
     *   <p>This can be used as a default if the  \endhtmlonly \link AccountInterface::requestPropertyIcon() AccountInterface::Icon \endlink \htmlonly 
     *     property is not set on an Account, or used by the  \endhtmlonly AccountManagerInterface \htmlonly 
     *     to choose a default icon if none is set during account
     *     creation.</p>
     * </div>
     * 
     * <p>If this property's value is empty, clients MAY fall back to
     *   generating a name based on the <tp:type>Protocol</tp:type> name.</p>
     * 
     * <p>Connection managers with a <code>.manager</code> file
     *   MUST cache this property in the protocol's section of the
     *   <code>.manager</code> file if it is non-empty, using the key
     *   <code>Icon</code>. The corresponding value
     *   is a string, following the syntax of the "localestring" type from
     *   the Desktop Entry Specification.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Icon.
     */
    QString Icon() const;
    /**
     * Return the value of the exported D-Bus object property \c AuthenticationTypes of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'authenticationTypes' with type QStringList.
     *
     * 
     * \htmlonly
     *         <p>A list of D-Bus interfaces which provide information as to
     *           what kind of authentication channels can possibly appear
     *           before the connection reaches the CONNECTED state.</p>
     * 
     *         <p>These can either be channel types, or where the channel
     *           type isn't enough information to be useful, interfaces
     *           indicating a specific use of a channel type. For example,
     *            \endhtmlonly ChannelTypeServerTLSConnectionInterface \htmlonly 
     *           channels are obviously about TLS certificates so the channel
     *           type would appear in this list. However, a
     *            \endhtmlonly ChannelTypeServerAuthenticationInterface \htmlonly 
     *           channel type alone does not explain enough about the authentication type
     *           in use as it is merely a base for the channel interfaces that appear in
     *           said channels. In this case, CMs should use the value of the
     *            \endhtmlonly \link ChannelTypeServerAuthenticationInterface::requestPropertyAuthenticationMethod() ChannelTypeServerAuthenticationInterface::AuthenticationMethod \endlink \htmlonly 
     *           property in this list.</p>
     * 
     *         <p>For example, if a protocol's
     *            \endhtmlonly \link requestPropertyAuthenticationTypes() AuthenticationTypes \endlink \htmlonly  contains
     *           two values:</p>
     * 
     *         <blockquote>
     *           <pre>
     * [ ... \endhtmlonly ChannelTypeServerTLSConnectionInterface \htmlonly ,
     *   ... \endhtmlonly ChannelInterfaceSASLAuthenticationInterface \htmlonly  ]</pre></blockquote>
     * 
     *         <p>This tells a client that before the connection status
     *           reached CONNECTED, a  \endhtmlonly ChannelTypeServerTLSConnectionInterface \htmlonly 
     *           could appear carrying a TLS certificate. It also tells the
     *           client that before the connection status reaches CONNECTED, a
     *            \endhtmlonly ChannelTypeServerAuthenticationInterface \htmlonly 
     *           channel could also appear, where  \endhtmlonly \link ChannelTypeServerAuthenticationInterface::requestPropertyAuthenticationMethod() ChannelTypeServerAuthenticationInterface::AuthenticationMethod \endlink \htmlonly = \endhtmlonly ChannelInterfaceSASLAuthenticationInterface \htmlonly . A
     *           hypothetical future Channel.Interface.Captcha interface would
     *           also appear in this list if the CM might require the user
     *           solve a captcha before connecting.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c AuthenticationTypes.
     */
    QStringList AuthenticationTypes() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c IdentifyAccount on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void identifyAccount(const QVariantMap& parameters, const Tp::Service::ProtocolAdaptor::IdentifyAccountContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Return a string which uniquely identifies the account to which the
     *   given parameters would connect.</p>
     * 
     * <div class="rationale">
     *   <p>For many protocols, this would return the well-known 'account'
     *     parameter. However, for IRC the returned string would be composed
     *     from the 'account' (i.e. nickname) and 'server' parameters.
     *     AccountManager implementations can use this to form the
     *     account-specific part of an Account's object path.</p>
     * </div>
     * \endhtmlonly
     *
     * \param parameters
     *     
     *     A set of parameters as would be provided to RequestConnection
     * \return
     *     
     *     An opaque string suitable for use as the account-specific part of 
     *     an Account&apos;s object path. This is not necessarily globally 
     *     unique, but should represent a &quot;best-effort&quot; 
     *     identification of the account. For a pathological case, consider a 
     *     user signing in as &apos;me@example.com&apos; with 
     *     &apos;server&apos; set to either jabber1.example.com or 
     *     jabber2.example.com. Both of these should result in me@example.com 
     *     being returned from this method, even if the user can actually be 
     *     signed in to those two servers simultaneously.
     */
    QString IdentifyAccount(const QVariantMap& parameters, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c NormalizeContact on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void normalizeContact(const QString& contactID, const Tp::Service::ProtocolAdaptor::NormalizeContactContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Attempt to normalize the given contact ID. Where possible, this
     *   SHOULD return the same thing that would be returned by
     *   InspectHandles(RequestHandles(CONTACT, [Contact_ID])) on a connected
     *    \endhtmlonly ConnectionInterface \htmlonly .</p>
     * 
     * <p>If full normalization requires network activity or is otherwise
     *   impossible to do without a  \endhtmlonly ConnectionInterface \htmlonly ,
     *   this method SHOULD perform a best-effort normalization.</p>
     * 
     * <div class="rationale">
     *   <p>One common example of a best-effort offline normalization
     *     differing from the ideal normalization is XMPP.</p>
     * 
     *   <p>On XMPP, contacts' JIDs should normally have the resource removed
     *     during normalization, but for contacts in a MUC (chatroom), the
     *     resource is an integral part of the JID - so the contact JID
     *     alice@example.com/Empathy should normalize to alice@example.com,
     *     but the in-MUC JID wonderland@conference.example.com/Alice should
     *     normalize to itself.</p>
     * 
     *   <p>While online, the connection manager has enough context to know
     *     which chatrooms the user is in, and can infer from that whether
     *     to remove resources, but the best-effort normalization performed
     *     while offline does not have this context, so the best that can be
     *     done is to remove the resource from all JIDs.</p>
     * </div>
     * 
     * <p>This method MAY simply raise NotImplemented on some protocols.</p>
     * 
     * <div class="rationale">
     *   <p>In link-local XMPP, you can't talk to someone who isn't present
     *     on your local network, so normalizing identifiers in advance is
     *     meaningless.</p>
     * </div>
     * \endhtmlonly
     *
     * \param contactID
     *     
     *     The identifier of a contact in this protocol
     * \return
     *     
     *     The identifier of a contact in this protocol, normalized as much as 
     *     possible
     */
    QString NormalizeContact(const QString& contactID, const QDBusMessage& dbusMessage);
};

/**
 * \class ProtocolInterfaceAddressingAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection-manager.h <TelepathyQt/_gen/svc-connection-manager.h>
 * \ingroup servicecm
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Protocol.Interface.Addressing".
 */
class TP_QT_EXPORT ProtocolInterfaceAddressingAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Protocol.Interface.Addressing")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Protocol.Interface.Addressing\">\n"
"    <property access=\"read\" type=\"as\" name=\"AddressableVCardFields\"/>\n"
"    <property access=\"read\" type=\"as\" name=\"AddressableURISchemes\"/>\n"
"    <method name=\"NormalizeVCardAddress\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"VCardField\"/>\n"
"      <arg direction=\"in\" type=\"s\" name=\"VCardAddress\"/>\n"
"      <arg direction=\"out\" type=\"s\" name=\"normalizedVCardAddress\"/>\n"
"    </method>\n"
"    <method name=\"NormalizeContactURI\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"URI\"/>\n"
"      <arg direction=\"out\" type=\"s\" name=\"normalizedURI\"/>\n"
"    </method>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QStringList AddressableVCardFields READ AddressableVCardFields )
    Q_PROPERTY(QStringList AddressableURISchemes READ AddressableURISchemes )

public:
    ProtocolInterfaceAddressingAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ProtocolInterfaceAddressingAdaptor();

    typedef Tp::MethodInvocationContextPtr< QString > NormalizeVCardAddressContextPtr;
    typedef Tp::MethodInvocationContextPtr< QString > NormalizeContactURIContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c AddressableVCardFields of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'addressableVCardFields' with type QStringList.
     *
     * 
     * \htmlonly
     * <p>The vCard fields that can be used to request a contact with
     *   normalized to lower case. If the <code>URL</code> vCard
     *   field is addressable, a colon, followed by the supported URI
     *   schemes will be concatenated.</p>
     * 
     *   <p>For example: <code>["tel", "x-sip"]</code>.</p>
     * 
     *   <p>The <code>url</code> vCard field MUST NOT appear here; see
     *      \endhtmlonly \link requestPropertyAddressableURISchemes() AddressableURISchemes \endlink \htmlonly  instead.</p>
     * 
     *   <div class="rationale">
     *     <p>In practice, protocols have a limited set of URI
     *       schemes that make sense to resolve as a contact.</p>
     *   </div>
     * 
     * <p>Connection managers with a <code>.manager</code> file
     *   MUST cache this property in the protocol's section of the
     *   <code>.manager</code> file if it is non-empty, using the key
     *   <code>AddressableVCardFields</code>. The corresponding value
     *   is a list of strings, each followed with a semicolon and in the
     *   syntax of the "localestring" type from the Desktop Entry
     *   Specification.</p>
     * 
     * <p>Well-known vCard fields:</p>
     * 
     * <dl>
     *   <dt><code>tel</code></dt>
     *   <dd>The TEL vCard field. Used for phone numbers.</dd>
     *   <dt><code>x-sip</code></dt>
     *   <dd>The X-SIP vCard field. Used for SIP addresses.</dd>
     *   <dt><code>x-aim</code></dt>
     *   <dd>The X-AIM vCard field. Used for AIM user IDs.</dd>
     *   <dt><code>x-icq</code></dt>
     *   <dd>The X-ICQ vCard field. Used for ICQ UINs.</dd>
     *   <dt><code>x-skype</code></dt>
     *   <dd>The X-SKYPE vCard field. Used for Skype user names or
     *   telephone numbers. There is also a X-SKYPE-USERNAME field,
     *   but for Telepathy purposes, <code>x-skype</code> is preferred</dd>
     *   <dt><code>x-groupwise</code></dt>
     *   <dd>The X-GROUPWISE vCard field. Used for Groupwise contacts.</dd>
     *   <dt><code>x-gadugadu</code></dt>
     *   <dd>The X-GADUGADU vCard field. Used for Gadu-Gadu contacts.</dd>
     *   <dt><code>x-jabber</code></dt>
     *   <dd>The X-JABBER vCard field. Used for XMPP JIDs.</dd>
     *   <dt><code>x-msn</code></dt>
     *   <dd>The X-MSN vCard field. Used for MSN contacts.</dd>
     *   <dt><code>x-yahoo</code></dt>
     *   <dd>The X-YAHOO vCard field. Used for Yahoo! IDs.</dd>
     *   <dt><code>x-facebook-id</code></dt>
     *   <dd>Used for Facebook IDs in XMPP. If the user JID is
     *   "-12345@chat.facebook.com" then the x-facebook-id is "12345"</dd>
     * </dl>
     * \endhtmlonly
     *
     * \return The value of exported property \c AddressableVCardFields.
     */
    QStringList AddressableVCardFields() const;
    /**
     * Return the value of the exported D-Bus object property \c AddressableURISchemes of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'addressableURISchemes' with type QStringList.
     *
     * 
     * \htmlonly
     * <p>The URI schemes that are supported by this protocol.</p>
     * 
     * <p>For example: <code>["tel", "sip"]</code>.</p>
     * 
     * <p>This property should only be used when the connection is
     *   offline. When it is connected the addressable URI schemes should be
     *   retrieved from the
     *    \endhtmlonly \link ConnectionInterfaceRequestsInterface::requestPropertyRequestableChannelClasses() ConnectionInterfaceRequestsInterface::RequestableChannelClasses \endlink \htmlonly 's
     *      TargetURIScheme fixed-property instead.</p>
     * 
     * <p>Connection managers with a <code>.manager</code> file
     *   MUST cache this property in the protocol's section of the
     *   <code>.manager</code> file if it is non-empty, using the key
     *   <code>AddressableURISchemes</code>. The corresponding value
     *   is a list of strings, each followed with a semicolon and in the
     *   syntax of the "localestring" type from the Desktop Entry
     *   Specification.</p>
     * 
     * <p>Well-known URI schemes:</p>
     * 
     * <dl>
     *   <dt><code>sip</code></dt>
     *   <dd>SIP protocol.
     *     For example: <code>sip:julien@example.com</code>.</dd>
     *   <dt><code>sips</code></dt>
     *   <dd>Secure (encrypted) SIP protocol.
     *     For example: <code>sips:julien@example.com</code>.</dd>
     *   <dt><code>tel</code></dt>
     *   <dd>Used for telephone numbers.
     *     For example: <code>tel:+12065551234</code>.</dd>
     *   <dt><code>xmpp</code></dt>
     *   <dd>XMPP protocol.
     *     For example: <code>xmpp:julien@example.com</code>.</dd>
     *   <dt><code>msnim</code></dt>
     *   <dd>For the purposes of
     *      \endhtmlonly ProtocolInterfaceAddressingInterface \htmlonly ,
     *      \endhtmlonly ConnectionInterfaceAddressingInterface \htmlonly ,
     *     and
     *      \endhtmlonly org.freedesktop.Telepathy.Channel.Interface.Addressing1 \htmlonly ,
     *     the verb part is ignored, and SHOULD be <code>add</code>; the
     *     <code>contact</code> field in the query string is used to
     *     identify the contact.
     *     For example: <code>msnim:add?contact=julien</code>.</dd>
     *   <dt><code>aim</code></dt>
     *   <dd>For the purposes of
     *      \endhtmlonly ProtocolInterfaceAddressingInterface \htmlonly ,
     *      \endhtmlonly ConnectionInterfaceAddressingInterface \htmlonly ,
     *     and
     *      \endhtmlonly org.freedesktop.Telepathy.Channel.Interface.Addressing1 \htmlonly ,
     *     the verb part is ignored, and SHOULD be <code>addbuddy</code>; the
     *     <code>screenname</code> field in the query string is used to
     *     identify the contact.
     *     For example: <code>aim:addbuddy?screenname=julien</code>.</dd>
     *   <dt><code>skype</code></dt>
     *   <dd>Skype protocol.
     *     For example: <code>skype:julien</code>.</dd>
     *   <dt><code>ymsgr</code></dt>
     *   <dd>For the purposes of
     *      \endhtmlonly ProtocolInterfaceAddressingInterface \htmlonly ,
     *      \endhtmlonly ConnectionInterfaceAddressingInterface \htmlonly ,
     *     and
     *      \endhtmlonly org.freedesktop.Telepathy.Channel.Interface.Addressing1 \htmlonly ,
     *     the verb part is ignored, and SHOULD be <code>addfriend</code>; the
     *     query string is used to identify the contact.
     *     For example: <code>ymsgr:addfriend?julien</code>.</dd>
     *   <dt><code>gg</code></dt>
     *   <dd>Gadu-Gadu protocol.
     *     For example: <code>gg:julien</code>.</dd>
     * </dl>
     * \endhtmlonly
     *
     * \return The value of exported property \c AddressableURISchemes.
     */
    QStringList AddressableURISchemes() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c NormalizeVCardAddress on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void normalizeVCardAddress(const QString& VCardField, const QString& VCardAddress, const Tp::Service::ProtocolInterfaceAddressingAdaptor::NormalizeVCardAddressContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Attempt to normalize the given vCard address. Where possible, this
     *   SHOULD return an address that would appear in the
     *   <code>org.freedesktop.Telepathy.Connection.Interface.Addressing1/addresses</code>
     *   attribute for a contact on a connected
     *    \endhtmlonly ConnectionInterface \htmlonly .
     * </p>
     * 
     * <p>If full normalization requires network activity or is otherwise
     *   impossible to do without a  \endhtmlonly ConnectionInterface \htmlonly ,
     *   this method SHOULD perform a best-effort normalization.</p>
     * 
     * <p>An example would be a vCard TEL field with a formatted
     *   number in the form of <code>+1 (206) 555 1234</code>, this would be
     *   normalized to <code>+12065551234</code>.</p>
     * 
     * <p>This method MAY simply raise NotImplemented on some
     * protocols, if it has no use.</p>
     * \endhtmlonly
     *
     * \param VCardField
     *     
     *     The vCard field of the address we are normalizing. The field name 
     *     SHOULD be in lower case, and MUST appear in AddressableVCardFields.
     * \param VCardAddress
     *     
     *     The address to normalize, which is assumed to belong to a contact 
     *     (and not, for instance, a chatroom or server).
     * \return
     *     
     *     The vCard address, normalized as much as possible.
     */
    QString NormalizeVCardAddress(const QString& VCardField, const QString& VCardAddress, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c NormalizeContactURI on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void normalizeContactURI(const QString& URI, const Tp::Service::ProtocolInterfaceAddressingAdaptor::NormalizeContactURIContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Attempt to normalize the given contact URI. Where possible, this
     *   SHOULD return an address that would appear in the
     *   <code>org.freedesktop.Telepathy.Connection.Interface.Addressing1/uris</code>
     *   attribute for a contact on a connected
     *    \endhtmlonly ConnectionInterface \htmlonly .
     * </p>
     * 
     * <p>If full normalization requires network activity or is otherwise
     *   impossible to do without a  \endhtmlonly ConnectionInterface \htmlonly ,
     *   this method SHOULD perform a best-effort normalization.</p>
     * 
     * <p>If the URI has extra information beyond what's necessary to
     *   identify a particular contact, such as an XMPP resource or an
     *   action to carry out, this extra information SHOULD be removed.
     *   If all URIs in a scheme contain a verb or action
     *   (like <code>aim</code>, <code>ymsgr</code> and
     *   <code>msnim</code> URIs), then the verb SHOULD be replaced
     *   with the one specified in
     *    \endhtmlonly \link requestPropertyAddressableURISchemes() AddressableURISchemes \endlink \htmlonly .</p>
     * 
     * <div class="rationale">
     *   <p>This method is intended to normalize URIs stored in address
     *     books, for instance. In protocols like XMPP, if you
     *     vary the resource or action (query string), the URI still
     *     refers to the same high-level contact.</p>
     * </div>
     * 
     * <p>For instance,
     *   <code>xmpp:romeo@Example.Com/Empathy?message;body=Hello</code>
     *   would be normalized to <code>xmpp:romeo@example.com</code>,
     *   and <code>aim:goim?screenname=Romeo%20M&amp;message=Hello</code>
     *   would be normalized to
     *   <code>aim:addbuddy?screenname=romeom</code>.</p>
     * 
     * <p>This method MAY simply raise NotImplemented on some
     * protocols, if it has no use.</p>
     * \endhtmlonly
     *
     * \param URI
     *     
     *     The URI to normalize, which is assumed to refer to a contact (as 
     *     opposed to, for instance, a chatroom or a server). In some 
     *     protocols, like XMPP, there is no way to tell whether a given URI 
     *     refers to a contact or a chatroom by looking at its syntax. The 
     *     URI&apos;s scheme (i.e. the part before the first colon) MUST 
     *     appear in AddressableURISchemes.
     * \return
     *     
     *     A URI, normalized as much as possible.
     */
    QString NormalizeContactURI(const QString& URI, const QDBusMessage& dbusMessage);
};

/**
 * \class ProtocolInterfaceAvatarsAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection-manager.h <TelepathyQt/_gen/svc-connection-manager.h>
 * \ingroup servicecm
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Protocol.Interface.Avatars".
 */
class TP_QT_EXPORT ProtocolInterfaceAvatarsAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Protocol.Interface.Avatars")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Protocol.Interface.Avatars\">\n"
"    <property access=\"read\" type=\"as\" name=\"SupportedAvatarMIMETypes\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"MinimumAvatarHeight\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"MinimumAvatarWidth\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"RecommendedAvatarHeight\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"RecommendedAvatarWidth\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"MaximumAvatarHeight\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"MaximumAvatarWidth\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"MaximumAvatarBytes\"/>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QStringList SupportedAvatarMIMETypes READ SupportedAvatarMIMETypes )
    Q_PROPERTY(uint MinimumAvatarHeight READ MinimumAvatarHeight )
    Q_PROPERTY(uint MinimumAvatarWidth READ MinimumAvatarWidth )
    Q_PROPERTY(uint RecommendedAvatarHeight READ RecommendedAvatarHeight )
    Q_PROPERTY(uint RecommendedAvatarWidth READ RecommendedAvatarWidth )
    Q_PROPERTY(uint MaximumAvatarHeight READ MaximumAvatarHeight )
    Q_PROPERTY(uint MaximumAvatarWidth READ MaximumAvatarWidth )
    Q_PROPERTY(uint MaximumAvatarBytes READ MaximumAvatarBytes )

public:
    ProtocolInterfaceAvatarsAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ProtocolInterfaceAvatarsAdaptor();


public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c SupportedAvatarMIMETypes of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'supportedAvatarMIMETypes' with type QStringList.
     *
     * 
     * The expected value of the 
     * Connection.Interface.Avatars.SupportedAvatarMIMETypes property on 
     * connections to this protocol.
     *
     * \return The value of exported property \c SupportedAvatarMIMETypes.
     */
    QStringList SupportedAvatarMIMETypes() const;
    /**
     * Return the value of the exported D-Bus object property \c MinimumAvatarHeight of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'minimumAvatarHeight' with type uint.
     *
     * 
     * The expected value of the 
     * Connection.Interface.Avatars.MinimumAvatarHeight property on 
     * connections to this protocol.
     *
     * \return The value of exported property \c MinimumAvatarHeight.
     */
    uint MinimumAvatarHeight() const;
    /**
     * Return the value of the exported D-Bus object property \c MinimumAvatarWidth of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'minimumAvatarWidth' with type uint.
     *
     * 
     * The expected value of the 
     * Connection.Interface.Avatars.MinimumAvatarWidth property on connections 
     * to this protocol.
     *
     * \return The value of exported property \c MinimumAvatarWidth.
     */
    uint MinimumAvatarWidth() const;
    /**
     * Return the value of the exported D-Bus object property \c RecommendedAvatarHeight of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'recommendedAvatarHeight' with type uint.
     *
     * 
     * The expected value of the 
     * Connection.Interface.Avatars.RecommendedAvatarHeight property on 
     * connections to this protocol.
     *
     * \return The value of exported property \c RecommendedAvatarHeight.
     */
    uint RecommendedAvatarHeight() const;
    /**
     * Return the value of the exported D-Bus object property \c RecommendedAvatarWidth of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'recommendedAvatarWidth' with type uint.
     *
     * 
     * The expected value of the 
     * Connection.Interface.Avatars.RecommendedAvatarWidth property on 
     * connections to this protocol.
     *
     * \return The value of exported property \c RecommendedAvatarWidth.
     */
    uint RecommendedAvatarWidth() const;
    /**
     * Return the value of the exported D-Bus object property \c MaximumAvatarHeight of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'maximumAvatarHeight' with type uint.
     *
     * 
     * The expected value of the 
     * Connection.Interface.Avatars.MaximumAvatarHeight property on 
     * connections to this protocol.
     *
     * \return The value of exported property \c MaximumAvatarHeight.
     */
    uint MaximumAvatarHeight() const;
    /**
     * Return the value of the exported D-Bus object property \c MaximumAvatarWidth of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'maximumAvatarWidth' with type uint.
     *
     * 
     * The expected value of the 
     * Connection.Interface.Avatars.MaximumAvatarWidth property on connections 
     * to this protocol.
     *
     * \return The value of exported property \c MaximumAvatarWidth.
     */
    uint MaximumAvatarWidth() const;
    /**
     * Return the value of the exported D-Bus object property \c MaximumAvatarBytes of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'maximumAvatarBytes' with type uint.
     *
     * 
     * The expected value of the 
     * Connection.Interface.Avatars.MaximumAvatarBytes property on connections 
     * to this protocol.
     *
     * \return The value of exported property \c MaximumAvatarBytes.
     */
    uint MaximumAvatarBytes() const;
};

/**
 * \class ProtocolInterfacePresenceAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection-manager.h <TelepathyQt/_gen/svc-connection-manager.h>
 * \ingroup servicecm
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Protocol.Interface.Presence".
 */
class TP_QT_EXPORT ProtocolInterfacePresenceAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Protocol.Interface.Presence")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Protocol.Interface.Presence\">\n"
"    <property access=\"read\" type=\"a{s(ubb)}\" name=\"Statuses\">\n"
"      <annotation value=\"Tp::SimpleStatusSpecMap\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"  </interface>\n"
"")
    Q_PROPERTY(Tp::SimpleStatusSpecMap Statuses READ Statuses )

public:
    ProtocolInterfacePresenceAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ProtocolInterfacePresenceAdaptor();


public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c Statuses of type \c Tp::SimpleStatusSpecMap.
     *
     * Adaptees should export this property as a Qt property named
     * 'statuses' with type Tp::SimpleStatusSpecMap.
     *
     * 
     * The statuses that might appear in the 
     * Connection.Interface.SimplePresence.Statuses property on a connection 
     * to this protocol that supports SimplePresence. This property is 
     * immutable. Depending on server capabilities, it is possible that not 
     * all of these will actually appear on the Connection.
     *
     * \return The value of exported property \c Statuses.
     */
    Tp::SimpleStatusSpecMap Statuses() const;
};

}
}