/*
 * This file contains D-Bus adaptor classes generated by qt-svc-gen.py.
 *
 * This file can be distributed under the same terms as the specification from
 * which it was generated.
 */

#include <TelepathyQt/AbstractAdaptor>
#include <TelepathyQt/Global>
#include <TelepathyQt/Types>

#include <QObject>
#include <QtDBus>

namespace Tp
{
namespace Service
{

/**
 * \class ConnectionAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection".
 */
class TP_QT_EXPORT ConnectionAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection\">\n"
"    <property access=\"read\" type=\"as\" name=\"Interfaces\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"SelfHandle\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"SelfID\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"Status\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"HasImmortalHandles\"/>\n"
"    <method name=\"Connect\"/>\n"
"    <method name=\"Disconnect\"/>\n"
"    <method name=\"GetInterfaces\">\n"
"      <arg direction=\"out\" type=\"as\" name=\"interfaces\"/>\n"
"    </method>\n"
"    <method name=\"GetProtocol\">\n"
"      <arg direction=\"out\" type=\"s\" name=\"protocol\"/>\n"
"    </method>\n"
"    <method name=\"GetSelfHandle\">\n"
"      <arg direction=\"out\" type=\"u\" name=\"selfHandle\"/>\n"
"    </method>\n"
"    <method name=\"GetStatus\">\n"
"      <arg direction=\"out\" type=\"u\" name=\"status\"/>\n"
"    </method>\n"
"    <method name=\"HoldHandles\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"handleType\"/>\n"
"      <arg direction=\"in\" type=\"au\" name=\"handles\"/>\n"
"    </method>\n"
"    <method name=\"InspectHandles\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"handleType\"/>\n"
"      <arg direction=\"in\" type=\"au\" name=\"handles\"/>\n"
"      <arg direction=\"out\" type=\"as\" name=\"identifiers\"/>\n"
"    </method>\n"
"    <method name=\"ListChannels\">\n"
"      <arg direction=\"out\" type=\"a(osuu)\" name=\"channelInfo\">\n"
"        <annotation value=\"Tp::ChannelInfoList\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"ReleaseHandles\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"handleType\"/>\n"
"      <arg direction=\"in\" type=\"au\" name=\"handles\"/>\n"
"    </method>\n"
"    <method name=\"RequestChannel\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"type\"/>\n"
"      <arg direction=\"in\" type=\"u\" name=\"handleType\"/>\n"
"      <arg direction=\"in\" type=\"u\" name=\"handle\"/>\n"
"      <arg direction=\"in\" type=\"b\" name=\"suppressHandler\"/>\n"
"      <arg direction=\"out\" type=\"o\" name=\"objectPath\"/>\n"
"    </method>\n"
"    <method name=\"RequestHandles\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"handleType\"/>\n"
"      <arg direction=\"in\" type=\"as\" name=\"identifiers\"/>\n"
"      <arg direction=\"out\" type=\"au\" name=\"handles\"/>\n"
"    </method>\n"
"    <method name=\"AddClientInterest\">\n"
"      <arg direction=\"in\" type=\"as\" name=\"tokens\"/>\n"
"    </method>\n"
"    <method name=\"RemoveClientInterest\">\n"
"      <arg direction=\"in\" type=\"as\" name=\"tokens\"/>\n"
"    </method>\n"
"    <signal name=\"SelfHandleChanged\">\n"
"      <arg type=\"u\" name=\"selfHandle\"/>\n"
"    </signal>\n"
"    <signal name=\"SelfContactChanged\">\n"
"      <arg type=\"u\" name=\"selfHandle\"/>\n"
"      <arg type=\"s\" name=\"selfID\"/>\n"
"    </signal>\n"
"    <signal name=\"NewChannel\">\n"
"      <arg type=\"o\" name=\"objectPath\"/>\n"
"      <arg type=\"s\" name=\"channelType\"/>\n"
"      <arg type=\"u\" name=\"handleType\"/>\n"
"      <arg type=\"u\" name=\"handle\"/>\n"
"      <arg type=\"b\" name=\"suppressHandler\"/>\n"
"    </signal>\n"
"    <signal name=\"ConnectionError\">\n"
"      <arg type=\"s\" name=\"error\"/>\n"
"      <arg type=\"a{sv}\" name=\"details\"/>\n"
"    </signal>\n"
"    <signal name=\"StatusChanged\">\n"
"      <arg type=\"u\" name=\"status\"/>\n"
"      <arg type=\"u\" name=\"reason\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QStringList Interfaces READ Interfaces )
    Q_PROPERTY(uint SelfHandle READ SelfHandle )
    Q_PROPERTY(QString SelfID READ SelfID )
    Q_PROPERTY(uint Status READ Status )
    Q_PROPERTY(bool HasImmortalHandles READ HasImmortalHandles )

public:
    ConnectionAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > ConnectContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > DisconnectContextPtr;
    typedef Tp::MethodInvocationContextPtr< QStringList > GetInterfacesContextPtr;
    typedef Tp::MethodInvocationContextPtr< QString > GetProtocolContextPtr;
    typedef Tp::MethodInvocationContextPtr< uint > GetSelfHandleContextPtr;
    typedef Tp::MethodInvocationContextPtr< uint > GetStatusContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > HoldHandlesContextPtr;
    typedef Tp::MethodInvocationContextPtr< QStringList > InspectHandlesContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::ChannelInfoList > ListChannelsContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > ReleaseHandlesContextPtr;
    typedef Tp::MethodInvocationContextPtr< QDBusObjectPath > RequestChannelContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::UIntList > RequestHandlesContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > AddClientInterestContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > RemoveClientInterestContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c Interfaces of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'interfaces' with type QStringList.
     *
     * 
     * \htmlonly
     * <p>The set of optional interfaces supported by this connection.
     *   Before the connection status changes to CONNECTED,
     *   this property may change at any time, but it is guaranteed that
     *   interfaces will only be added, not removed. After the connection
     *   status changes to CONNECTED, this property cannot
     *   change further.</p>
     * 
     * <p>There is no explicit change notification; reasonable behaviour
     *   for a client would be to retrieve the interfaces list once
     *   initially, and once more when it becomes CONNECTED.</p>
     * 
     * <div class="rationale">
     *   <p>In some connection managers, certain capabilities of a connection
     *     are known to be implemented for all connections (e.g. support
     *     for SimplePresence), and some interfaces (like SimplePresence) can
     *     even be used before connecting. Other capabilities may
     *     or may not exist, depending on server functionality; by the time
     *     the connection goes CONNECTED, the connection manager is expected
     *     to have evaluated the server's functionality and enabled any extra
     *     interfaces for the remainder of the Connection's lifetime.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c Interfaces.
     */
    QStringList Interfaces() const;
    /**
     * Return the value of the exported D-Bus object property \c SelfHandle of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'selfHandle' with type uint.
     *
     * 
     * The handle which represents the user on this connection, which will 
     * remain valid for the lifetime of this connection, or until a change in 
     * the user&apos;s identifier is signalled by the SelfContactChanged 
     * signal. If the connection is not yet in the CONNECTED state, the value 
     * of this property MAY be zero.
     *
     * \return The value of exported property \c SelfHandle.
     */
    uint SelfHandle() const;
    /**
     * Return the value of the exported D-Bus object property \c SelfID of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'selfID' with type QString.
     *
     * 
     * The identifier which represents the user on this connection, which will 
     * remain valid for the lifetime of this connection, or until a change in 
     * the user&apos;s identifier is signalled by the SelfContactChanged 
     * signal. If the connection is not yet in the CONNECTED state, the value 
     * of this property MAY be empty string.
     *
     * \return The value of exported property \c SelfID.
     */
    QString SelfID() const;
    /**
     * Return the value of the exported D-Bus object property \c Status of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'status' with type uint.
     *
     * 
     * \htmlonly
     * <p>The current status of the connection. Change notification is via
     *   the  \endhtmlonly StatusChanged() \htmlonly  signal.</p>
     * 
     * <p>If retrieval of property succeeds and yields the value Disconnected,
     *   this indicates that the connection has not yet been established.
     *   If connection has been attempted and failed, the Connection object
     *   SHOULD be removed from the bus entirely, meaning that retrieval of
     *   this property SHOULD fail.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Status.
     */
    uint Status() const;
    /**
     * Return the value of the exported D-Bus object property \c HasImmortalHandles of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'hasImmortalHandles' with type bool.
     *
     * 
     * \htmlonly
     * <p>True if handles last for the whole lifetime of the Connection.
     *   This SHOULD be the case in all connection managers, but clients
     *   MUST interoperate with older connection managers
     *   (which reference-count handles).</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c HasImmortalHandles.
     */
    bool HasImmortalHandles() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c Connect on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void connect(const Tp::Service::ConnectionAdaptor::ConnectContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Request that the connection be established. This will be done
     *   asynchronously and errors will be returned by emitting
     *    \endhtmlonly StatusChanged() \htmlonly  signals.</p>
     * 
     * <p>Calling this method on a Connection that is already connecting
     *   or connected is allowed, and has no effect.</p>
     * \endhtmlonly
     *
     */
    void Connect(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c Disconnect on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void disconnect(const Tp::Service::ConnectionAdaptor::DisconnectContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Request that the connection be closed. This closes the connection if 
     * it&apos;s not already in DISCONNECTED state, and destroys the 
     * connection object.
     *
     */
    void Disconnect(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetInterfaces on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getInterfaces(const Tp::Service::ConnectionAdaptor::GetInterfacesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Returns the set of optional interfaces supported by this
     *   connection. See  \endhtmlonly \link requestPropertyInterfaces() Interfaces \endlink \htmlonly  for more
     *   details.</p>
     * \endhtmlonly
     *
     * \return
     *     
     *     The value of the Interfaces property
     */
    QStringList GetInterfaces(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetProtocol on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getProtocol(const Tp::Service::ConnectionAdaptor::GetProtocolContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Get the protocol this connection is using.
     *
     * \return
     *     
     *     A string identifier for the protocol
     */
    QString GetProtocol(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetSelfHandle on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getSelfHandle(const Tp::Service::ConnectionAdaptor::GetSelfHandleContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Returns the value of the SelfHandle property. Change notification is 
     * via the SelfHandleChanged signal.
     *
     * \return
     *     
     *     The value of the SelfHandle property
     */
    uint GetSelfHandle(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetStatus on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getStatus(const Tp::Service::ConnectionAdaptor::GetStatusContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Get the current status as defined in the StatusChanged signal.
     *
     * \return
     *     
     *     The value of the Status property
     */
    uint GetStatus(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c HoldHandles on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void holdHandles(uint handleType, const Tp::UIntList& handles, const Tp::Service::ConnectionAdaptor::HoldHandlesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>If  \endhtmlonly \link requestPropertyHasImmortalHandles() HasImmortalHandles \endlink \htmlonly  is true,
     *   which SHOULD always be the case in this version of telepathy-spec,
     *   this method does nothing and returns successfully, unless
     *   the given handle type or any of the given handles is invalid.</p>
     * 
     * <p>In older connection managers, this method
     * notifies the connection manger that your client is holding a copy
     * of handles which may not be in use in any existing channel or
     * list, and were not obtained by using the
     *  \endhtmlonly RequestHandles() \htmlonly  method. For
     * example, a handle observed in an emitted signal, or displayed
     * somewhere in the UI that is not associated with a channel. The
     * connection manager must not deallocate a handle where any clients
     * have used this method to indicate it is in use until the
     *  \endhtmlonly ReleaseHandles() \htmlonly 
     * method is called, or the clients disappear from the bus.</p>
     * 
     * <p>Note that HoldHandles is idempotent - calling it multiple times
     *   is equivalent to calling it once. If a handle is "referenced" by
     *   several components which share a D-Bus unique name, the client
     *   should perform reference counting internally, and only call
     *   ReleaseHandles when none of the cooperating components need the
     *   handle any longer.</p>
     * \endhtmlonly
     *
     * \param handleType
     *     
     *     The type of handle to be held
     * \param handles
     *     
     *     A array of integer handles to hold
     */
    void HoldHandles(uint handleType, const Tp::UIntList& handles, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c InspectHandles on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void inspectHandles(uint handleType, const Tp::UIntList& handles, const Tp::Service::ConnectionAdaptor::InspectHandlesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Return a string representation for a number of handles of a given type.
     *
     * \param handleType
     *     
     *     The type of handle to be inspected
     * \param handles
     *     
     *     An array of integer handles of this type
     * \return
     *     
     *     An array of identifiers corresponding to the given handles, in the 
     *     same order.
     */
    QStringList InspectHandles(uint handleType, const Tp::UIntList& handles, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c ListChannels on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void listChannels(const Tp::Service::ConnectionAdaptor::ListChannelsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * List all the channels which currently exist on this connection.
     *
     * \return
     *     
     *     An array of structs representing channels.
     */
    Tp::ChannelInfoList ListChannels(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c ReleaseHandles on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void releaseHandles(uint handleType, const Tp::UIntList& handles, const Tp::Service::ConnectionAdaptor::ReleaseHandlesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * If HasImmortalHandles is true, which SHOULD always be the case in this 
     * version of telepathy-spec, this method does nothing and returns 
     * successfully, unless the given handle type or any of the given handles 
     * is invalid. In older connection managers, this method explicitly 
     * notifies the connection manager that your client is no longer holding 
     * any references to the given handles, and that they may be deallocated 
     * if they are not held by any other clients or referenced by any existing 
     * channels. See HoldHandles for notes.
     *
     * \param handleType
     *     
     *     An integer handle type (as defined in RequestHandle)
     * \param handles
     *     
     *     An array of integer handles being held by the client
     */
    void ReleaseHandles(uint handleType, const Tp::UIntList& handles, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RequestChannel on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void requestChannel(const QString& type, uint handleType, uint handle, bool suppressHandler, const Tp::Service::ConnectionAdaptor::RequestChannelContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Request a channel satisfying the specified type and communicating
     *   with the contact, room, list etc. indicated by the given
     *   handle_type and handle. The handle_type and handle may both be
     *   zero to request the creation of a new, empty channel, which may
     *   or may not be possible, depending on the protocol and channel
     *   type.</p>
     * 
     * <p>On success, the returned channel will always be of the requested
     *   type (i.e. implement the requested channel-type interface).</p>
     * 
     * <p>If a new, empty channel is requested, on success the returned
     *   channel will always be an "anonymous" channel for which the type
     *   and handle are both zero.</p>
     * 
     * <p>If a channel to a contact, room etc. is requested, on success, the
     *   returned channel may either be a new or existing channel to
     *   the requested entity (i.e. its
     *    \endhtmlonly \link ChannelInterface::requestPropertyTargetHandleType() ChannelInterface::TargetHandleType \endlink \htmlonly 
     *   and  \endhtmlonly \link ChannelInterface::requestPropertyTargetHandle() ChannelInterface::TargetHandle \endlink \htmlonly 
     *   properties are the
     *   requested handle type and handle), or a newly created "anonymous"
     *   channel associated with the requested handle in some
     *   implementation-specific way.</p>
     * 
     * <p>For example, for a contact handle, the returned channel
     *   might be "anonymous", but implement the groups interface and have
     *   the requested contact already present among the members.</p>
     * 
     * <p>If the request cannot be satisfied, an error is raised and no
     *   channel is created.</p>
     * \endhtmlonly
     *
     * \param type
     *     
     *     A D-Bus interface name representing base channel type
     * \param handleType
     *     
     *     An integer representing the handle type, or Handle_Type_None if no 
     *     handle is specified
     * \param handle
     *     
     *     A nonzero integer handle representing a contact, room, list etc. 
     *     according to handle_type, or zero if the handle_type is 
     *     Handle_Type_None
     * \param suppressHandler
     *     
     *     Clients SHOULD always set this to true. The historical meaning was 
     *     that clients that did not intend to take responsibility for 
     *     displaying the channel to the user could set this to FALSE, in 
     *     which case the channel dispatcher would launch an appropriate 
     *     channel handler. However, clients whose functionality relies on 
     *     having a working channel dispatcher should obtain that 
     *     functionality by calling methods on the channel dispatcher, so that 
     *     they will get an appropriate error if the channel dispatcher is 
     *     missing or not working. The channel dispatcher itself should set 
     *     this to true too, so that it will ignore the NewChannel signal that 
     *     results from the creation of the channel. It can then dispatch the 
     *     channel returned from this method to an appropriate handler. So, 
     *     there is no sensible use-case for setting this to false, and 
     *     setting it to false can result in unhandled channels (in the case 
     *     where clients assume that a channel dispatcher is present, but it 
     *     isn&apos;t).
     * \return
     *     
     *     The D-Bus object path for the channel created or retrieved
     */
    QDBusObjectPath RequestChannel(const QString& type, uint handleType, uint handle, bool suppressHandler, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RequestHandles on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void requestHandles(uint handleType, const QStringList& identifiers, const Tp::Service::ConnectionAdaptor::RequestHandlesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Request several handles from the connection manager which represent a
     *   number of contacts, rooms or server-stored lists on the service.</p>
     * 
     * <p>If  \endhtmlonly \link requestPropertyHasImmortalHandles() HasImmortalHandles \endlink \htmlonly  is true,
     *   which SHOULD always be the case in this version of telepathy-spec,
     *   the handles remain valid until the connection disconnects.</p>
     * 
     * <p>The implementation of this method in older connection managers
     * must record that these handles are in use by the
     * client who invokes this method, and must not deallocate the handles
     * until the client disconnects from the bus or calls the
     *  \endhtmlonly ReleaseHandles() \htmlonly 
     * method. Where the identifier refers to an entity that already has a
     * handle in this connection manager, this handle should be returned
     * instead. The handle number 0 must not be returned by the connection
     * manager.</p>
     * \endhtmlonly
     *
     * \param handleType
     *     
     *     The type of handle required
     * \param identifiers
     *     
     *     An array of identifiers of entities to request handles for
     * \return
     *     
     *     An array of integer handle numbers in the same order as the given 
     *     identifiers.
     */
    Tp::UIntList RequestHandles(uint handleType, const QStringList& identifiers, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c AddClientInterest on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void addClientInterest(const QStringList& tokens, const Tp::Service::ConnectionAdaptor::AddClientInterestContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Register a client's interest in notifications related to one or
     *   more interfaces.</p>
     * 
     * <p>Groups of notifications are identified by a token which is either
     *   a D-Bus interface name, or a string that starts with a D-Bus
     *   interface name. The meaning of each token is given by that D-Bus
     *   interface, which MUST define it in its documentation.</p>
     * 
     * <div class="rationale">
     *   <p>Initially, all interests are in entire interface, but allowing
     *     other strings allows subscription to part of an interface; for
     *     instance, an interest in ...MailNotification/count could track
     *     the number of messages without caring about their detailed
     *     content.</p>
     * </div>
     * 
     * <p>For each token with which this method interacts, the
     *   Connection tracks an "interest count" (like a reference count) for
     *   each unique bus name that has called this method. When a client
     *   calls this method, for each token, the interest count for its
     *   unique bus name is incremented; when
     *    \endhtmlonly RemoveClientInterest() \htmlonly  is called,
     *   all interest counts for that unique bus name are decremented.
     *   If the unique bus name leaves the bus (for instance, if the
     *   client crashes or exits), all interest counts for that unique bus
     *   name are set to zero.</p>
     * 
     * <p>The Connection can then use these reference counts to
     *   avoid subscribing to protocol-level notifications unless at least
     *   one client has a non-zero interest count for the relevant
     *   token.</p>
     * 
     * <div class="rationale">
     *   <p>This method exists to reduce memory and network overhead when
     *     there is no active subscription.</p>
     * 
     *   <p>One situation where this is useful is  \endhtmlonly ConnectionInterfaceLocationInterface \htmlonly : on XMPP, location updates are received
     *     over PEP. If the Connection advertises the
     *     <code>geoloc+notify</code> capability, it will be sent location
     *     updates for all contacts. To avoid consuming resources for this,
     *     the connection should avoid advertising that capability until
     *     a client has expressed an interest in contacts' locations.</p>
     * 
     *   <p>Another example of a protocol that benefits from this method is
     *     the Google XMPP Mail Notification extension, which can be used
     *     to implement  \endhtmlonly ConnectionInterfaceMailNotificationInterface \htmlonly . In this protocol, the CM
     *     receives a notification that something has changed, but to get
     *     more information, the CM must request this information. Knowing
     *     that nobody is currently interested in this information, the CM
     *     can avoid generating useless network traffic. Similarly, the CM
     *     may free the list of unread messages to reduce memory overhead.</p>
     * </div>
     * 
     * <p>If this method is called for an interface that might require
     *   protocol-level subscription, but the connection cannot set up
     *   that subscription yet (for instance because the
     *    \endhtmlonly \link requestPropertyStatus() Status \endlink \htmlonly  is not Connected yet), the
     *   Connection MUST remember the client's interest, and attempt to
     *   subscribe to the appropriate protocol feature when this becomes
     *   possible.</p>
     * 
     * <p>Clients MAY ignore any errors raised by this method; it is intended
     *   to be called with the reply ignored.</p>
     * 
     * <div class="rationale">
     *   <p>The only reason it could fail is if it's unimplemented, in which
     *     case the only thing the client can usefully do is to proceed as if
     *     it had succeeded.</p>
     * </div>
     * \endhtmlonly
     *
     * \param tokens
     *     
     *     \htmlonly
     *     <p>Interfaces or parts of interfaces in which to register an
     *       interest, represented by either a
     *       <tp:type>DBus_Interface</tp:type>, or a string prefixed with a
     *       <tp:type>DBus_Interface</tp:type>.</p>
     *     
     *     <p>If the Connection does not support one of these tokens, this
     *       is not considered to be an error; the unsupported token is
     *       simply ignored.</p>
     *     \endhtmlonly
     */
    void AddClientInterest(const QStringList& tokens, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RemoveClientInterest on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void removeClientInterest(const QStringList& tokens, const Tp::Service::ConnectionAdaptor::RemoveClientInterestContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Release an interest registered using
     *    \endhtmlonly AddClientInterest() \htmlonly . See that
     *   method's documentation for details.</p>
     * 
     * <p>Clients MAY ignore any errors raised by this method; it is intended
     *   to be called with the reply ignored.</p>
     * 
     * <div class="rationale">
     *   <p>The only reasons it could fail are if it's unimplemented, or if
     *     the client's reference-counting is wrong and it has tried to
     *     remove a client interest that it did not add. In both cases,
     *     there's nothing the client could do about it.</p>
     * </div>
     * \endhtmlonly
     *
     * \param tokens
     *     
     *     \htmlonly
     *     <p>Interfaces or parts of interfaces that were previously passed to
     *        \\\\endhtmlonly AddClientInterest() \\\\htmlonly .</p>
     *     \endhtmlonly
     */
    void RemoveClientInterest(const QStringList& tokens, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c SelfHandleChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void selfHandleChanged(uint selfHandle);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param selfHandle
     *     
     *     The new value of the SelfHandle property.
     */
    void SelfHandleChanged(uint selfHandle);
    /**
     * Represents the exported D-Bus signal \c SelfContactChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void selfContactChanged(uint selfHandle, const QString& selfID);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param selfHandle
     *     
     *     The new value of the SelfHandle property.
     * \param selfID
     *     
     *     The new value of the SelfID property.
     */
    void SelfContactChanged(uint selfHandle, const QString& selfID);
    /**
     * Represents the exported D-Bus signal \c NewChannel on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void newChannel(const QDBusObjectPath& objectPath, const QString& channelType, uint handleType, uint handle, bool suppressHandler);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param objectPath
     *     
     *     A D-Bus object path for the channel object on this service
     * \param channelType
     *     
     *     A D-Bus interface name representing the channel type
     * \param handleType
     *     
     *     An integer representing the type of handle this channel 
     *     communicates with, or Handle_Type_None if no handle is specified
     * \param handle
     *     
     *     A handle indicating the specific contact, room or list this channel 
     *     communicates with, or zero if no handle is specified
     * \param suppressHandler
     *     
     *     \htmlonly
     *     <p>If true, the channel was requested by a client that intends to
     *       present it to the user itself (i.e. it passed suppress_handler=TRUE
     *       to the  \\\\endhtmlonly RequestChannel() \\\\htmlonly  method), so no
     *       other handler should be
     *       launched. Clients MAY assume that channels where this is true
     *       were created by a user request.</p>
     *     
     *     <p>If false, either the channel was created due to incoming
     *       information from the service, or the channel was requested by
     *       a local client that does not intend to handle the channel itself
     *       (this usage is deprecated).</p>
     *     
     *     <p>Clients MUST NOT assume that only incoming channels will have
     *       this flag set to false.</p>
     *     \endhtmlonly
     */
    void NewChannel(const QDBusObjectPath& objectPath, const QString& channelType, uint handleType, uint handle, bool suppressHandler);
    /**
     * Represents the exported D-Bus signal \c ConnectionError on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void connectionError(const QString& error, const QVariantMap& details);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param error
     *     
     *     The name of a D-Bus error describing the error that occurred, which 
     *     may correspond to a Connection_Status_Reason, or may be a more 
     *     specific Telepathy error (such as 
     *     org.freedesktop.Telepathy.Error.ConnectionRefused for 
     *     Connection_Status_Reason_Network_Error) or a protocol-specific or 
     *     connection-manager-specific error in a suitable namespace. For 
     *     instance, a SIP connection manager could signal &quot;402 Payment 
     *     Required&quot; as an error in a connection-manager-specific 
     *     namespace, or a link-local XMPP implementation that used Avahi 
     *     could provide the error given to it by the avahi-daemon.
     * \param details
     *     
     *     \htmlonly
     *               <p>Additional information about the error, which may include
     *                 the following well-known keys:</p>
     *     
     *               <dl>
     *                 <dt>debug-message (s)</dt>
     *                 <dd>Debugging information on the change, corresponding to the
     *                   message part of a D-Bus error message, which SHOULD NOT be
     *                   displayed to users under normal circumstances</dd>
     *     
     *                 <dt>server-message (s)</dt>
     *                 <dd>A human-readable message from the server explaining what
     *                   happened. This may be in the user's native language, or in the
     *                   server operator's native language, or even in Lojban.</dd>
     *     
     *     	    <dt>user-requested (b), expected-hostname (s), certificate-hostname (s)</dt>
     *     	    <dd>The same details defined in <tp:type>TLS_Certificate_Rejection</tp:type>.</dd>
     *               </dl>
     *     \endhtmlonly
     */
    void ConnectionError(const QString& error, const QVariantMap& details);
    /**
     * Represents the exported D-Bus signal \c StatusChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void statusChanged(uint status, uint reason);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param status
     *     
     *     An integer indicating the new status, as defined by ConnectionStatus
     * \param reason
     *     
     *     An integer indicating the reason for the status change, as defined 
     *     by ConnectionStatusReason
     */
    void StatusChanged(uint status, uint reason);
};

/**
 * \class ConnectionInterfaceAddressingAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Addressing1".
 */
class TP_QT_EXPORT ConnectionInterfaceAddressingAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.Addressing1")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.Addressing1\">\n"
"    <method name=\"GetContactsByVCardField\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"field\"/>\n"
"      <arg direction=\"in\" type=\"as\" name=\"addresses\"/>\n"
"      <arg direction=\"in\" type=\"as\" name=\"interfaces\"/>\n"
"      <arg direction=\"out\" type=\"a{su}\" name=\"requested\">\n"
"        <annotation value=\"Tp::AddressingNormalizationMap\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"      <arg direction=\"out\" type=\"a{ua{sv}}\" name=\"attributes\">\n"
"        <annotation value=\"Tp::ContactAttributesMap\" name=\"com.trolltech.QtDBus.QtTypeName.Out1\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"GetContactsByURI\">\n"
"      <arg direction=\"in\" type=\"as\" name=\"URIs\"/>\n"
"      <arg direction=\"in\" type=\"as\" name=\"interfaces\"/>\n"
"      <arg direction=\"out\" type=\"a{su}\" name=\"requested\">\n"
"        <annotation value=\"Tp::AddressingNormalizationMap\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"      <arg direction=\"out\" type=\"a{ua{sv}}\" name=\"attributes\">\n"
"        <annotation value=\"Tp::ContactAttributesMap\" name=\"com.trolltech.QtDBus.QtTypeName.Out1\"/>\n"
"      </arg>\n"
"    </method>\n"
"  </interface>\n"
"")

public:
    ConnectionInterfaceAddressingAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceAddressingAdaptor();

    typedef Tp::MethodInvocationContextPtr< Tp::AddressingNormalizationMap, Tp::ContactAttributesMap > GetContactsByVCardFieldContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::AddressingNormalizationMap, Tp::ContactAttributesMap > GetContactsByURIContextPtr;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c GetContactsByVCardField on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getContactsByVCardField(const QString& field, const QStringList& addresses, const QStringList& interfaces, const Tp::Service::ConnectionInterfaceAddressingAdaptor::GetContactsByVCardFieldContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Request contacts and retrieve their attributes using a given field
     *   in their vCards.</p>
     * 
     * <p>The connection manager should record that these handles are in
     *   use by the client who invokes this method, and must not
     *   deallocate the handles until the client disconnects from the
     *   bus or calls the
     *    \endhtmlonly ConnectionInterface::ReleaseHandles() \htmlonly 
     *   method.</p>
     * \endhtmlonly
     *
     * \param field
     *     
     *     \htmlonly
     *     <p>The vCard field of the addresses we are requesting. The
     *       field name SHOULD be in lower case. Supported
     *       fields can be found in
     *        \\\\endhtmlonly \\\\link ProtocolInterfaceAddressingInterface::requestPropertyAddressableVCardFields() ProtocolInterfaceAddressingInterface::AddressableVCardFields \\\\endlink \\\\htmlonly .</p>
     *     
     *     <p>The <code>url</code> vCard field MUST NOT appear here; see
     *        \\\\endhtmlonly GetContactsByURI() \\\\htmlonly  instead.</p>
     *     
     *     <div class="rationale">
     *       <p>In practice, protocols have a limited set of URI
     *         schemes that make sense to resolve as a contact.</p>
     *     </div>
     *     \endhtmlonly
     * \param addresses
     *     
     *     The addresses to get contact handles for. The address types should 
     *     match the given vCard field.
     * \param interfaces
     *     
     *     \htmlonly
     *     <p>A list of strings indicating which D-Bus interfaces the calling
     *       process is interested in. All supported attributes from these
     *       interfaces, whose values can be obtained without additional network
     *       activity, will be in the reply.</p>
     *     
     *     <p>Attributes from this interface and from
     *        \\\\endhtmlonly ConnectionInterface \\\\htmlonly 
     *       are always returned, and need not be requested
     *       explicitly.</p>
     *     
     *     <p>The behavior of this parameter is similar to the same
     *       parameter in
     *        \\\\endhtmlonly ConnectionInterfaceContactsInterface::GetContactAttributes() \\\\htmlonly .</p>
     *     \endhtmlonly
     * \param attributes Output parameter
     *     
     *     \htmlonly
     *     <p>A dictionary mapping the contact handles to contact attributes.
     *       If any of the requested addresses are in fact invalid, they are
     *       simply omitted from this mapping. If contact attributes are not
     *       immediately known, the behaviour is defined by the interface;
     *       the attribute should either be omitted from the result or
     *       replaced with a default value.</p>
     *     
     *     <p>Requested addresses that are not valid or understood for this protocol
     *       MUST be omitted from the mapping.</p>
     *     
     *     <p>Each contact's attributes will always include at least the
     *       identifier that would be obtained by inspecting the handle
     *       (<code>org.freedesktop.Telepathy.Connection/contact-id</code>).
     *     </p>
     *     \endhtmlonly
     * \return
     *     
     *     \htmlonly
     *     <p>A mapping from requested vCard addresses to the corresponding
     *       contact handles.</p>
     *     
     *     <p>Requested addresses that are not valid or understood for this protocol
     *       MUST be omitted from the mapping.</p>
     *     \endhtmlonly
     */
    Tp::AddressingNormalizationMap GetContactsByVCardField(const QString& field, const QStringList& addresses, const QStringList& interfaces, const QDBusMessage& dbusMessage, Tp::ContactAttributesMap& attributes);
    /**
     * Begins a call to the exported D-Bus method \c GetContactsByURI on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getContactsByURI(const QStringList& URIs, const QStringList& interfaces, const Tp::Service::ConnectionInterfaceAddressingAdaptor::GetContactsByURIContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Request contacts and retrieve their attributes using URI addresses.</p>
     * 
     * <p>The connection manager should record that these handles are in
     *   use by the client who invokes this method, and must not
     *   deallocate the handles until the client disconnects from the
     *   bus or calls the
     *    \endhtmlonly ConnectionInterface::ReleaseHandles() \htmlonly 
     *   method.</p>
     * \endhtmlonly
     *
     * \param URIs
     *     
     *     The URI addresses to get contact handles for. Supported schemes can 
     *     be found in AddressableURISchemes.
     * \param interfaces
     *     
     *     \htmlonly
     *     <p>A list of strings indicating which D-Bus interfaces the calling
     *       process is interested in. All supported attributes from these
     *       interfaces, whose values can be obtained without additional network
     *       activity, will be in the reply.</p>
     *     
     *     <p>Attributes from this interface and from
     *        \\\\endhtmlonly ConnectionInterface \\\\htmlonly 
     *       are always returned, and need not be requested
     *       explicitly.</p>
     *     
     *     <p>The behavior of this parameter is similar to the same
     *       parameter in
     *        \\\\endhtmlonly ConnectionInterfaceContactsInterface::GetContactAttributes() \\\\htmlonly .</p>
     *     \endhtmlonly
     * \param attributes Output parameter
     *     
     *     \htmlonly
     *     <p>A dictionary mapping the contact handles to contact attributes.
     *       If any of the requested addresses are in fact invalid, they are
     *       simply omitted from this mapping. If contact attributes are not
     *       immediately known, the behaviour is defined by the interface;
     *       the attribute should either be omitted from the result or
     *       replaced with a default value.</p>
     *     
     *     <p>Requested URIs that are not valid or understood for this protocol
     *       MUST be omitted from the mapping.</p>
     *     
     *     <p>Each contact's attributes will always include at least the
     *       identifier that would be obtained by inspecting the handle
     *       (<code>org.freedesktop.Telepathy.Connection/contact-id</code>).
     *     </p>
     *     \endhtmlonly
     * \return
     *     
     *     \htmlonly
     *     <p>A mapping of requested URIs to the corresponding contact handles.</p>
     *     
     *     <p>Requested URIs that are not valid or understood for this protocol
     *       MUST be omitted from the mapping.</p>
     *     \endhtmlonly
     */
    Tp::AddressingNormalizationMap GetContactsByURI(const QStringList& URIs, const QStringList& interfaces, const QDBusMessage& dbusMessage, Tp::ContactAttributesMap& attributes);
};

/**
 * \class ConnectionInterfaceAliasingAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Aliasing".
 */
class TP_QT_EXPORT ConnectionInterfaceAliasingAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.Aliasing")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.Aliasing\">\n"
"    <method name=\"GetAliasFlags\">\n"
"      <arg direction=\"out\" type=\"u\" name=\"aliasFlags\"/>\n"
"    </method>\n"
"    <method name=\"RequestAliases\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"      <arg direction=\"out\" type=\"as\" name=\"aliases\"/>\n"
"    </method>\n"
"    <method name=\"GetAliases\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"      <arg direction=\"out\" type=\"a{us}\" name=\"aliases\">\n"
"        <annotation value=\"Tp::AliasMap\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"SetAliases\">\n"
"      <arg direction=\"in\" type=\"a{us}\" name=\"aliases\">\n"
"        <annotation value=\"Tp::AliasMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <signal name=\"AliasesChanged\">\n"
"      <arg type=\"a(us)\" name=\"aliases\">\n"
"        <annotation value=\"Tp::AliasPairList\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </signal>\n"
"  </interface>\n"
"")

public:
    ConnectionInterfaceAliasingAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceAliasingAdaptor();

    typedef Tp::MethodInvocationContextPtr< uint > GetAliasFlagsContextPtr;
    typedef Tp::MethodInvocationContextPtr< QStringList > RequestAliasesContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::AliasMap > GetAliasesContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > SetAliasesContextPtr;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c GetAliasFlags on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getAliasFlags(const Tp::Service::ConnectionInterfaceAliasingAdaptor::GetAliasFlagsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Return a bitwise OR of flags detailing the behaviour of aliases on this 
     * connection.
     *
     * \return
     *     
     *     An integer with a bitwise OR of flags from ConnectionAliasFlags
     */
    uint GetAliasFlags(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RequestAliases on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void requestAliases(const Tp::UIntList& contacts, const Tp::Service::ConnectionInterfaceAliasingAdaptor::RequestAliasesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Request the value of several contacts&apos; aliases at once.
     *
     * \param contacts
     *     
     *     An array of handles representing contacts
     * \return
     *     
     *     A list of aliases in the same order as the contact handles
     */
    QStringList RequestAliases(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetAliases on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getAliases(const Tp::UIntList& contacts, const Tp::Service::ConnectionInterfaceAliasingAdaptor::GetAliasesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Request the value of several contacts&apos; aliases at once. This 
     * SHOULD only return cached aliases, falling back on the contact 
     * identifier (i.e. the string corresponding to the handle) if none is 
     * present. Also if there was no cached alias, a request SHOULD be started 
     * of which the result is later signalled by AliasesChanged.
     *
     * \param contacts
     *     
     *     An array of handles representing contacts
     * \return
     *     
     *     A dictionary mapping contact handles to aliases
     */
    Tp::AliasMap GetAliases(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c SetAliases on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void setAliases(const Tp::AliasMap& aliases, const Tp::Service::ConnectionInterfaceAliasingAdaptor::SetAliasesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Request that the alias of the given contact be changed. Success will be 
     * indicated by emitting an AliasesChanged signal. On connections where 
     * the CONNECTION_ALIAS_FLAG_USER_SET flag is not set, this method will 
     * only ever succeed if the contact is the user&apos;s own handle (as 
     * returned by Connection.GetSelfHandle).
     *
     * \param aliases
     *     
     *     A dictionary mapping integer handles of contacts to strings of the 
     *     new alias to set.
     */
    void SetAliases(const Tp::AliasMap& aliases, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c AliasesChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void aliasesChanged(const Tp::AliasPairList& aliases);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param aliases
     *     
     *     \htmlonly
     *     An array containing structs of:
     *     <ul>
     *       <li>the handle representing the contact</li>
     *       <li>the new alias</li>
     *     </ul>
     *     \endhtmlonly
     */
    void AliasesChanged(const Tp::AliasPairList& aliases);
};

/**
 * \class ConnectionInterfaceAnonymityAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Anonymity".
 */
class TP_QT_EXPORT ConnectionInterfaceAnonymityAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.Anonymity")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.Anonymity\">\n"
"    <property access=\"read\" type=\"u\" name=\"SupportedAnonymityModes\"/>\n"
"    <property access=\"readwrite\" type=\"b\" name=\"AnonymityMandatory\"/>\n"
"    <property access=\"readwrite\" type=\"u\" name=\"AnonymityModes\"/>\n"
"    <signal name=\"AnonymityModesChanged\">\n"
"      <arg type=\"u\" name=\"modes\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(uint SupportedAnonymityModes READ SupportedAnonymityModes )
    Q_PROPERTY(bool AnonymityMandatory READ AnonymityMandatory WRITE SetAnonymityMandatory)
    Q_PROPERTY(uint AnonymityModes READ AnonymityModes WRITE SetAnonymityModes)

public:
    ConnectionInterfaceAnonymityAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceAnonymityAdaptor();


public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c SupportedAnonymityModes of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'supportedAnonymityModes' with type uint.
     *
     * 
     * The anonymity modes supported by the CM for this connection. Once 
     * Connection.Status has moved to Connected, this property MUST NOT change.
     *
     * \return The value of exported property \c SupportedAnonymityModes.
     */
    uint SupportedAnonymityModes() const;
    /**
     * Return the value of the exported D-Bus object property \c AnonymityMandatory of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'anonymityMandatory' with type bool.
     *
     * 
     * This specifies whether or not the anonymity settings MUST be respected 
     * by the CM and any intermediaries between the local and remote contacts. 
     * If this is set to true but anonymity settings cannot be followed, then 
     * the session MUST be denied with a 
     * org.freedesktop.Telepathy.Error.WouldBreakAnonymity error. Any client 
     * that sets AnonymityModes SHOULD also set this property first (rather 
     * than accepting the CM&apos;s default value).
     *
     * \return The value of exported property \c AnonymityMandatory.
     */
    bool AnonymityMandatory() const;
    /**
     * Set the value of the exported D-Bus object property \c AnonymityMandatory of type \c bool.
     *
     * Adaptees should export this property as a writable Qt property named
     * 'anonymityMandatory' with type bool.
     *
     * 
     * This specifies whether or not the anonymity settings MUST be respected 
     * by the CM and any intermediaries between the local and remote contacts. 
     * If this is set to true but anonymity settings cannot be followed, then 
     * the session MUST be denied with a 
     * org.freedesktop.Telepathy.Error.WouldBreakAnonymity error. Any client 
     * that sets AnonymityModes SHOULD also set this property first (rather 
     * than accepting the CM&apos;s default value).
     */
    void SetAnonymityMandatory(const bool &newValue);
    /**
     * Return the value of the exported D-Bus object property \c AnonymityModes of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'anonymityModes' with type uint.
     *
     * 
     * The currently enabled anonymity modes for the connection. Setting has 
     * the effect of requesting new modes for the connection, and may raise an 
     * error if the unsupported modes are set. Successfully changing the modes 
     * will result in emission of AnonymityModesChanged signal.
     *
     * \return The value of exported property \c AnonymityModes.
     */
    uint AnonymityModes() const;
    /**
     * Set the value of the exported D-Bus object property \c AnonymityModes of type \c uint.
     *
     * Adaptees should export this property as a writable Qt property named
     * 'anonymityModes' with type uint.
     *
     * 
     * The currently enabled anonymity modes for the connection. Setting has 
     * the effect of requesting new modes for the connection, and may raise an 
     * error if the unsupported modes are set. Successfully changing the modes 
     * will result in emission of AnonymityModesChanged signal.
     */
    void SetAnonymityModes(const uint &newValue);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c AnonymityModesChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void anonymityModesChanged(uint modes);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param modes
     *     
     *     The new anonymity modes for this connection.
     */
    void AnonymityModesChanged(uint modes);
};

/**
 * \class ConnectionInterfaceAvatarsAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Avatars".
 */
class TP_QT_EXPORT ConnectionInterfaceAvatarsAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.Avatars")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.Avatars\">\n"
"    <property access=\"read\" type=\"as\" name=\"SupportedAvatarMIMETypes\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"MinimumAvatarHeight\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"MinimumAvatarWidth\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"RecommendedAvatarHeight\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"RecommendedAvatarWidth\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"MaximumAvatarHeight\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"MaximumAvatarWidth\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"MaximumAvatarBytes\"/>\n"
"    <method name=\"GetAvatarRequirements\">\n"
"      <arg direction=\"out\" type=\"as\" name=\"MIMETypes\"/>\n"
"      <arg direction=\"out\" type=\"q\" name=\"minWidth\"/>\n"
"      <arg direction=\"out\" type=\"q\" name=\"minHeight\"/>\n"
"      <arg direction=\"out\" type=\"q\" name=\"maxWidth\"/>\n"
"      <arg direction=\"out\" type=\"q\" name=\"maxHeight\"/>\n"
"      <arg direction=\"out\" type=\"u\" name=\"maxBytes\"/>\n"
"    </method>\n"
"    <method name=\"GetAvatarTokens\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"      <arg direction=\"out\" type=\"as\" name=\"tokens\"/>\n"
"    </method>\n"
"    <method name=\"GetKnownAvatarTokens\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"      <arg direction=\"out\" type=\"a{us}\" name=\"tokens\">\n"
"        <annotation value=\"Tp::AvatarTokenMap\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"RequestAvatar\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"contact\"/>\n"
"      <arg direction=\"out\" type=\"ay\" name=\"data\"/>\n"
"      <arg direction=\"out\" type=\"s\" name=\"MIMEType\"/>\n"
"    </method>\n"
"    <method name=\"RequestAvatars\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"    </method>\n"
"    <method name=\"SetAvatar\">\n"
"      <arg direction=\"in\" type=\"ay\" name=\"avatar\"/>\n"
"      <arg direction=\"in\" type=\"s\" name=\"MIMEType\"/>\n"
"      <arg direction=\"out\" type=\"s\" name=\"token\"/>\n"
"    </method>\n"
"    <method name=\"ClearAvatar\"/>\n"
"    <signal name=\"AvatarUpdated\">\n"
"      <arg type=\"u\" name=\"contact\"/>\n"
"      <arg type=\"s\" name=\"newAvatarToken\"/>\n"
"    </signal>\n"
"    <signal name=\"AvatarRetrieved\">\n"
"      <arg type=\"u\" name=\"contact\"/>\n"
"      <arg type=\"s\" name=\"token\"/>\n"
"      <arg type=\"ay\" name=\"avatar\"/>\n"
"      <arg type=\"s\" name=\"type\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QStringList SupportedAvatarMIMETypes READ SupportedAvatarMIMETypes )
    Q_PROPERTY(uint MinimumAvatarHeight READ MinimumAvatarHeight )
    Q_PROPERTY(uint MinimumAvatarWidth READ MinimumAvatarWidth )
    Q_PROPERTY(uint RecommendedAvatarHeight READ RecommendedAvatarHeight )
    Q_PROPERTY(uint RecommendedAvatarWidth READ RecommendedAvatarWidth )
    Q_PROPERTY(uint MaximumAvatarHeight READ MaximumAvatarHeight )
    Q_PROPERTY(uint MaximumAvatarWidth READ MaximumAvatarWidth )
    Q_PROPERTY(uint MaximumAvatarBytes READ MaximumAvatarBytes )

public:
    ConnectionInterfaceAvatarsAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceAvatarsAdaptor();

    typedef Tp::MethodInvocationContextPtr< QStringList, ushort, ushort, ushort, ushort, uint > GetAvatarRequirementsContextPtr;
    typedef Tp::MethodInvocationContextPtr< QStringList > GetAvatarTokensContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::AvatarTokenMap > GetKnownAvatarTokensContextPtr;
    typedef Tp::MethodInvocationContextPtr< QByteArray, QString > RequestAvatarContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > RequestAvatarsContextPtr;
    typedef Tp::MethodInvocationContextPtr< QString > SetAvatarContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > ClearAvatarContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c SupportedAvatarMIMETypes of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'supportedAvatarMIMETypes' with type QStringList.
     *
     * 
     * An array of supported MIME types (e.g. &quot;image/jpeg&quot;). Clients 
     * MAY assume that the first type in this array is preferred. This 
     * property cannot change after the Connection goes to the Connected state.
     *
     * \return The value of exported property \c SupportedAvatarMIMETypes.
     */
    QStringList SupportedAvatarMIMETypes() const;
    /**
     * Return the value of the exported D-Bus object property \c MinimumAvatarHeight of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'minimumAvatarHeight' with type uint.
     *
     * 
     * The minimum height in pixels of an avatar on this protocol, which MAY 
     * be 0. This property cannot change after the Connection goes to the 
     * Connected state.
     *
     * \return The value of exported property \c MinimumAvatarHeight.
     */
    uint MinimumAvatarHeight() const;
    /**
     * Return the value of the exported D-Bus object property \c MinimumAvatarWidth of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'minimumAvatarWidth' with type uint.
     *
     * 
     * The minimum width in pixels of an avatar on this protocol, which MAY be 
     * 0. This property cannot change after the Connection goes to the 
     * Connected state.
     *
     * \return The value of exported property \c MinimumAvatarWidth.
     */
    uint MinimumAvatarWidth() const;
    /**
     * Return the value of the exported D-Bus object property \c RecommendedAvatarHeight of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'recommendedAvatarHeight' with type uint.
     *
     * 
     * The recommended height in pixels of an avatar on this protocol, or 0 if 
     * there is no preferred height. This property cannot change after the 
     * Connection goes to the Connected state. In XMPP a recommended width is 
     * given by the protocol specification; in proprietary protocols, using 
     * the same avatar size as the proprietary client is likely to lead to the 
     * best display to other users.
     *
     * \return The value of exported property \c RecommendedAvatarHeight.
     */
    uint RecommendedAvatarHeight() const;
    /**
     * Return the value of the exported D-Bus object property \c RecommendedAvatarWidth of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'recommendedAvatarWidth' with type uint.
     *
     * 
     * The recommended width in pixels of an avatar on this protocol, or 0 if 
     * there is no preferred width. This property cannot change after the 
     * Connection goes to the Connected state. The rationale is the same as 
     * for RecommendedAvatarHeight.
     *
     * \return The value of exported property \c RecommendedAvatarWidth.
     */
    uint RecommendedAvatarWidth() const;
    /**
     * Return the value of the exported D-Bus object property \c MaximumAvatarHeight of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'maximumAvatarHeight' with type uint.
     *
     * 
     * The maximum height in pixels of an avatar on this protocol, or 0 if 
     * there is no limit. This property cannot change after the Connection 
     * goes to the Connected state.
     *
     * \return The value of exported property \c MaximumAvatarHeight.
     */
    uint MaximumAvatarHeight() const;
    /**
     * Return the value of the exported D-Bus object property \c MaximumAvatarWidth of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'maximumAvatarWidth' with type uint.
     *
     * 
     * The maximum width in pixels of an avatar on this protocol, or 0 if 
     * there is no limit. This property cannot change after the Connection 
     * goes to the Connected state.
     *
     * \return The value of exported property \c MaximumAvatarWidth.
     */
    uint MaximumAvatarWidth() const;
    /**
     * Return the value of the exported D-Bus object property \c MaximumAvatarBytes of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'maximumAvatarBytes' with type uint.
     *
     * 
     * The maximum size in bytes of an avatar on this protocol, or 0 if there 
     * is no limit. This property cannot change after the Connection goes to 
     * the Connected state.
     *
     * \return The value of exported property \c MaximumAvatarBytes.
     */
    uint MaximumAvatarBytes() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c GetAvatarRequirements on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getAvatarRequirements(const Tp::Service::ConnectionInterfaceAvatarsAdaptor::GetAvatarRequirementsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Get the required format of avatars on this connection.
     *
     * \param minWidth Output parameter
     *     
     *     The minimum image width in pixels
     * \param minHeight Output parameter
     *     
     *     The minimum image height in pixels
     * \param maxWidth Output parameter
     *     
     *     The maximum image width in pixels, or 0 if there is no limit
     * \param maxHeight Output parameter
     *     
     *     The maximum image height in pixels, or 0 if there is no limit
     * \param maxBytes Output parameter
     *     
     *     The maximum image size in bytes, or 0 if there is no limit
     * \return
     *     
     *     An array of supported MIME types (eg image/jpeg)
     */
    QStringList GetAvatarRequirements(const QDBusMessage& dbusMessage, ushort& minWidth, ushort& minHeight, ushort& maxWidth, ushort& maxHeight, uint& maxBytes);
    /**
     * Begins a call to the exported D-Bus method \c GetAvatarTokens on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getAvatarTokens(const Tp::UIntList& contacts, const Tp::Service::ConnectionInterfaceAvatarsAdaptor::GetAvatarTokensContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Get the unique tokens for all of the given contacts&apos; avatars. 
     * Using this method in new Telepathy clients is deprecated; use 
     * GetKnownAvatarTokens instead.
     *
     * \param contacts
     *     
     *     An array of handles representing contacts
     * \return
     *     
     *     An array of avatar tokens or empty strings (if no avatar is set) in 
     *     the same order as the given array of contact handles
     */
    QStringList GetAvatarTokens(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetKnownAvatarTokens on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getKnownAvatarTokens(const Tp::UIntList& contacts, const Tp::Service::ConnectionInterfaceAvatarsAdaptor::GetKnownAvatarTokensContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Get the unique tokens for the given contacts&apos; avatars. These 
     * tokens can be persisted across connections, and should be used by the 
     * client to check whether the avatars have been updated. For handles 
     * other than the self handle, only tokens that are already known are 
     * returned; an empty token means the given contact has no avatar. 
     * However, a CM must always have the tokens for the self handle if one is 
     * set (even if it is set to no avatar). On protocols where the avatar 
     * does not persist between connections, a CM should omit the self handle 
     * from the returned map until an avatar is explicitly set or cleared.
     *
     * \param contacts
     *     
     *     An array of handles representing contacts
     * \return
     *     
     *     A dictionary of handles mapped to avatar tokens, containing only 
     *     the known avatar tokens.
     */
    Tp::AvatarTokenMap GetKnownAvatarTokens(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RequestAvatar on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void requestAvatar(uint contact, const Tp::Service::ConnectionInterfaceAvatarsAdaptor::RequestAvatarContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Request the avatar for a given contact. Using this method in new 
     * Telepathy clients is deprecated; use RequestAvatars instead.
     *
     * \param contact
     *     
     *     An integer handle for the contact to request the avatar for
     * \param MIMEType Output parameter
     *     
     *     A string containing the image MIME type (eg image/jpeg), or empty 
     *     if unknown
     * \return
     *     
     *     An array of bytes containing the image data
     */
    QByteArray RequestAvatar(uint contact, const QDBusMessage& dbusMessage, QString& MIMEType);
    /**
     * Begins a call to the exported D-Bus method \c RequestAvatars on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void requestAvatars(const Tp::UIntList& contacts, const Tp::Service::ConnectionInterfaceAvatarsAdaptor::RequestAvatarsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Request avatars for a number of contacts. The AvatarRetrieved signal is 
     * emitted for each avatar retrieved. If the handles are valid but 
     * retrieving an avatar fails (for any reason, including the contact not 
     * having an avatar) the AvatarRetrieved signal is not emitted for that 
     * contact.
     *
     * \param contacts
     *     
     *     The contacts to retrieve avatars for
     */
    void RequestAvatars(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c SetAvatar on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void setAvatar(const QByteArray& avatar, const QString& MIMEType, const Tp::Service::ConnectionInterfaceAvatarsAdaptor::SetAvatarContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Set a new avatar image for this connection. The avatar image must 
     * respect the requirements obtained by GetAvatarRequirements.
     *
     * \param avatar
     *     
     *     An array of bytes representing the avatar image data
     * \param MIMEType
     *     
     *     A string representing the image MIME type
     * \return
     *     
     *     The string token of the new avatar
     */
    QString SetAvatar(const QByteArray& avatar, const QString& MIMEType, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c ClearAvatar on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void clearAvatar(const Tp::Service::ConnectionInterfaceAvatarsAdaptor::ClearAvatarContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Remove the avatar image for this connection.
     *
     */
    void ClearAvatar(const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c AvatarUpdated on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void avatarUpdated(uint contact, const QString& newAvatarToken);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param contact
     *     
     *     An integer handle for the contact whose avatar has changed
     * \param newAvatarToken
     *     
     *     Unique token for their new avatar
     */
    void AvatarUpdated(uint contact, const QString& newAvatarToken);
    /**
     * Represents the exported D-Bus signal \c AvatarRetrieved on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void avatarRetrieved(uint contact, const QString& token, const QByteArray& avatar, const QString& type);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param contact
     *     
     *     The contact whose avatar has been retrieved
     * \param token
     *     
     *     The token corresponding to the avatar
     * \param avatar
     *     
     *     An array of bytes containing the image data
     * \param type
     *     
     *     A string containing the image MIME type (eg image/jpeg), or empty 
     *     if unknown
     */
    void AvatarRetrieved(uint contact, const QString& token, const QByteArray& avatar, const QString& type);
};

/**
 * \class ConnectionInterfaceBalanceAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Balance".
 */
class TP_QT_EXPORT ConnectionInterfaceBalanceAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.Balance")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.Balance\">\n"
"    <property access=\"read\" type=\"(ius)\" name=\"AccountBalance\">\n"
"      <annotation value=\"Tp::CurrencyAmount\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"s\" name=\"ManageCreditURI\"/>\n"
"    <signal name=\"BalanceChanged\">\n"
"      <arg type=\"(ius)\" name=\"balance\">\n"
"        <annotation value=\"Tp::CurrencyAmount\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(Tp::CurrencyAmount AccountBalance READ AccountBalance )
    Q_PROPERTY(QString ManageCreditURI READ ManageCreditURI )

public:
    ConnectionInterfaceBalanceAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceBalanceAdaptor();


public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c AccountBalance of type \c Tp::CurrencyAmount.
     *
     * Adaptees should export this property as a Qt property named
     * 'accountBalance' with type Tp::CurrencyAmount.
     *
     * 
     * \htmlonly
     * <p>The user's balance on the account corresponding to this  \endhtmlonly ConnectionInterface \htmlonly .
     *   A negative amount may be possible on some services, and indicates
     *   that the user owes money to the service provider.</p>
     * 
     * <p>On initial connection, this property may have an unknown
     *   value, represented by <var>Amount</var> = <tt>0</tt>,
     *   <var>Scale</var> = <tt>2**32 - 1</tt> (the largest possible 32-bit
     *   unsigned integer) and <var>Currency</var> = <tt>""</tt>.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c AccountBalance.
     */
    Tp::CurrencyAmount AccountBalance() const;
    /**
     * Return the value of the exported D-Bus object property \c ManageCreditURI of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'manageCreditURI' with type QString.
     *
     * 
     * A URI the user may visit via the web browser to manage and top-up their 
     * account balance. This property is not guaranteed to be well-defined 
     * until the connection becomes Connected; there is no change 
     * notification. Different protocols and even servers or gateways (e.g. 
     * SIP and XMPP PSTN gateways) will have a different website used to 
     * manage a user&apos;s account balance. This property enables the client 
     * to provide that to the user. A Connection Manager MAY set this itself 
     * (because it is static or discoverable), or expose it as a connection 
     * parameter.
     *
     * \return The value of exported property \c ManageCreditURI.
     */
    QString ManageCreditURI() const;

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c BalanceChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void balanceChanged(const Tp::CurrencyAmount& balance);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param balance
     *     
     *     \htmlonly
     *     <p>The new value of the  \\\\endhtmlonly \\\\link requestPropertyAccountBalance() AccountBalance \\\\endlink \\\\htmlonly 
     *       property.</p>
     *     \endhtmlonly
     */
    void BalanceChanged(const Tp::CurrencyAmount& balance);
};

/**
 * \class ConnectionInterfaceCellularAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Cellular".
 */
class TP_QT_EXPORT ConnectionInterfaceCellularAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.Cellular")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.Cellular\">\n"
"    <property access=\"readwrite\" type=\"u\" name=\"MessageValidityPeriod\"/>\n"
"    <property access=\"readwrite\" type=\"b\" name=\"OverrideMessageServiceCentre\"/>\n"
"    <property access=\"readwrite\" type=\"s\" name=\"MessageServiceCentre\"/>\n"
"    <property access=\"read\" type=\"s\" name=\"IMSI\"/>\n"
"    <property access=\"readwrite\" type=\"b\" name=\"MessageReducedCharacterSet\"/>\n"
"    <property access=\"readwrite\" type=\"s\" name=\"MessageNationalCharacterSet\"/>\n"
"    <signal name=\"IMSIChanged\">\n"
"      <arg type=\"s\" name=\"IMSI\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(uint MessageValidityPeriod READ MessageValidityPeriod WRITE SetMessageValidityPeriod)
    Q_PROPERTY(bool OverrideMessageServiceCentre READ OverrideMessageServiceCentre WRITE SetOverrideMessageServiceCentre)
    Q_PROPERTY(QString MessageServiceCentre READ MessageServiceCentre WRITE SetMessageServiceCentre)
    Q_PROPERTY(QString IMSI READ IMSI )
    Q_PROPERTY(bool MessageReducedCharacterSet READ MessageReducedCharacterSet WRITE SetMessageReducedCharacterSet)
    Q_PROPERTY(QString MessageNationalCharacterSet READ MessageNationalCharacterSet WRITE SetMessageNationalCharacterSet)

public:
    ConnectionInterfaceCellularAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceCellularAdaptor();


public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c MessageValidityPeriod of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'messageValidityPeriod' with type uint.
     *
     * 
     * \htmlonly
     * <p>Define how long should the service centre try message delivery before
     *   giving up, failing delivery and deleting the message. A value of 0
     *   means to use the service centre's default period.</p>
     * 
     * <p>The value specified is in seconds. Note that various protocols or
     *   implementations may round the value up (eg. to a minute or hour
     *   precision). The maximum validity period may vary depending on
     *   protocol or provider.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c MessageValidityPeriod.
     */
    uint MessageValidityPeriod() const;
    /**
     * Set the value of the exported D-Bus object property \c MessageValidityPeriod of type \c uint.
     *
     * Adaptees should export this property as a writable Qt property named
     * 'messageValidityPeriod' with type uint.
     *
     * 
     * \htmlonly
     * <p>Define how long should the service centre try message delivery before
     *   giving up, failing delivery and deleting the message. A value of 0
     *   means to use the service centre's default period.</p>
     * 
     * <p>The value specified is in seconds. Note that various protocols or
     *   implementations may round the value up (eg. to a minute or hour
     *   precision). The maximum validity period may vary depending on
     *   protocol or provider.</p>
     * \endhtmlonly
     */
    void SetMessageValidityPeriod(const uint &newValue);
    /**
     * Return the value of the exported D-Bus object property \c OverrideMessageServiceCentre of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'overrideMessageServiceCentre' with type bool.
     *
     * 
     * \htmlonly
     * <p>If <code>True</code>, SMSes will be sent via the service centre
     *   specified by  \endhtmlonly \link requestPropertyMessageServiceCentre() MessageServiceCentre \endlink \htmlonly . If
     *   <code>False</code>, the SIM's default SMSC will be used, ignoring the
     *   value of MessageServiceCentre.</p>
     * 
     * <div class="rationale">
     *   <p>It could be desirable for a configuration interface to remember
     *     the user's previous choice of custom SMSC, even if it's not in use.
     *     This boolean allows that choice to be saved as an account parameter
     *     by Mission Control, rather than the UI needing to save it elsewhere
     *     to be restored if the user wants to reactivate it.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c OverrideMessageServiceCentre.
     */
    bool OverrideMessageServiceCentre() const;
    /**
     * Set the value of the exported D-Bus object property \c OverrideMessageServiceCentre of type \c bool.
     *
     * Adaptees should export this property as a writable Qt property named
     * 'overrideMessageServiceCentre' with type bool.
     *
     * 
     * \htmlonly
     * <p>If <code>True</code>, SMSes will be sent via the service centre
     *   specified by  \endhtmlonly \link requestPropertyMessageServiceCentre() MessageServiceCentre \endlink \htmlonly . If
     *   <code>False</code>, the SIM's default SMSC will be used, ignoring the
     *   value of MessageServiceCentre.</p>
     * 
     * <div class="rationale">
     *   <p>It could be desirable for a configuration interface to remember
     *     the user's previous choice of custom SMSC, even if it's not in use.
     *     This boolean allows that choice to be saved as an account parameter
     *     by Mission Control, rather than the UI needing to save it elsewhere
     *     to be restored if the user wants to reactivate it.</p>
     * </div>
     * \endhtmlonly
     */
    void SetOverrideMessageServiceCentre(const bool &newValue);
    /**
     * Return the value of the exported D-Bus object property \c MessageServiceCentre of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'messageServiceCentre' with type QString.
     *
     * 
     * \htmlonly
     * <p>Address for the messaging service centre. Typically (as is the case
     *   for GSM's SMSC), it's the ISDN / telephony address (ie. a phone
     *   number). If
     *    \endhtmlonly \link requestPropertyOverrideMessageServiceCentre() OverrideMessageServiceCentre \endlink \htmlonly  is
     *   <code>False</code>, this property's value should be ignored by the CM
     *   in favour of the SIM's default SMSC.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c MessageServiceCentre.
     */
    QString MessageServiceCentre() const;
    /**
     * Set the value of the exported D-Bus object property \c MessageServiceCentre of type \c QString.
     *
     * Adaptees should export this property as a writable Qt property named
     * 'messageServiceCentre' with type QString.
     *
     * 
     * \htmlonly
     * <p>Address for the messaging service centre. Typically (as is the case
     *   for GSM's SMSC), it's the ISDN / telephony address (ie. a phone
     *   number). If
     *    \endhtmlonly \link requestPropertyOverrideMessageServiceCentre() OverrideMessageServiceCentre \endlink \htmlonly  is
     *   <code>False</code>, this property's value should be ignored by the CM
     *   in favour of the SIM's default SMSC.</p>
     * \endhtmlonly
     */
    void SetMessageServiceCentre(const QString &newValue);
    /**
     * Return the value of the exported D-Bus object property \c IMSI of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'imsi' with type QString.
     *
     * 
     * \htmlonly
     * <p>The International Mobile Subscriber Identifier, if it exists. This
     *   would originate from a SIM card.  If the IMSI is unknown, this will
     *   contain an empty string ("").</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c IMSI.
     */
    QString IMSI() const;
    /**
     * Return the value of the exported D-Bus object property \c MessageReducedCharacterSet of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'messageReducedCharacterSet' with type bool.
     *
     * 
     * \htmlonly
     * <p>Determines how to encode SMSes containing characters that do not
     *   fit into a non-Unicode character set.
     *   If <code>False</code> (which SHOULD be the default), messages will
     *   be encoded as UCS-2 and sent with no loss of fidelity (at the
     *   potential financial cost of using twice as many SMSes); if
     *   <code>True</code>, the message will be recoded in an
     *   implementation‐specific way to fit into a GSM reduced character
     *   set.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c MessageReducedCharacterSet.
     */
    bool MessageReducedCharacterSet() const;
    /**
     * Set the value of the exported D-Bus object property \c MessageReducedCharacterSet of type \c bool.
     *
     * Adaptees should export this property as a writable Qt property named
     * 'messageReducedCharacterSet' with type bool.
     *
     * 
     * \htmlonly
     * <p>Determines how to encode SMSes containing characters that do not
     *   fit into a non-Unicode character set.
     *   If <code>False</code> (which SHOULD be the default), messages will
     *   be encoded as UCS-2 and sent with no loss of fidelity (at the
     *   potential financial cost of using twice as many SMSes); if
     *   <code>True</code>, the message will be recoded in an
     *   implementation‐specific way to fit into a GSM reduced character
     *   set.</p>
     * \endhtmlonly
     */
    void SetMessageReducedCharacterSet(const bool &newValue);
    /**
     * Return the value of the exported D-Bus object property \c MessageNationalCharacterSet of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'messageNationalCharacterSet' with type QString.
     *
     * 
     * \htmlonly
     * <p>Hint for the connection manager for the GSM character set that
     *   should be used to send SMSes. The connection manager SHOULD follow
     *   this hint unless it has other ways to determine a better encoding.
     *   If the value is <code>"gsm"</code> (which SHOULD be the default),
     *   SMSes will be encoded in the normal 7-bit GSM character set,
     *   eventually falling back to UCS-2; see the
     *    \endhtmlonly \link requestPropertyMessageReducedCharacterSet() MessageReducedCharacterSet \endlink \htmlonly  property
     *   for details.
     *   Other valid character sets are specified in the
     *   <a href="http://www.3gpp.org/ftp/specs/archive/23_series/23.038/">GSM standard</a> and are, for instance, <code>"turkey"</code>,
     *   <code>"spain"</code> or <code>"portugal"</code>.
     *   If the SMS cannot be encoded using the requested character set the
     *   behaviour is implementation-specific, but it is RECOMMENDED that
     *   the connection manager should behave as if this property was set
     *   to <code>"gsm"</code>.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c MessageNationalCharacterSet.
     */
    QString MessageNationalCharacterSet() const;
    /**
     * Set the value of the exported D-Bus object property \c MessageNationalCharacterSet of type \c QString.
     *
     * Adaptees should export this property as a writable Qt property named
     * 'messageNationalCharacterSet' with type QString.
     *
     * 
     * \htmlonly
     * <p>Hint for the connection manager for the GSM character set that
     *   should be used to send SMSes. The connection manager SHOULD follow
     *   this hint unless it has other ways to determine a better encoding.
     *   If the value is <code>"gsm"</code> (which SHOULD be the default),
     *   SMSes will be encoded in the normal 7-bit GSM character set,
     *   eventually falling back to UCS-2; see the
     *    \endhtmlonly \link requestPropertyMessageReducedCharacterSet() MessageReducedCharacterSet \endlink \htmlonly  property
     *   for details.
     *   Other valid character sets are specified in the
     *   <a href="http://www.3gpp.org/ftp/specs/archive/23_series/23.038/">GSM standard</a> and are, for instance, <code>"turkey"</code>,
     *   <code>"spain"</code> or <code>"portugal"</code>.
     *   If the SMS cannot be encoded using the requested character set the
     *   behaviour is implementation-specific, but it is RECOMMENDED that
     *   the connection manager should behave as if this property was set
     *   to <code>"gsm"</code>.</p>
     * \endhtmlonly
     */
    void SetMessageNationalCharacterSet(const QString &newValue);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c IMSIChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void imsiChanged(const QString& IMSI);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param IMSI
     *     
     *     The new IMSI value. This may be an empty string in the case where 
     *     the IMSI is being reset or removed.
     */
    void IMSIChanged(const QString& IMSI);
};

/**
 * \class ConnectionInterfaceClientTypesAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.ClientTypes".
 */
class TP_QT_EXPORT ConnectionInterfaceClientTypesAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.ClientTypes")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.ClientTypes\">\n"
"    <method name=\"GetClientTypes\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"      <arg direction=\"out\" type=\"a{uas}\" name=\"clientTypes\">\n"
"        <annotation value=\"Tp::ContactClientTypes\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"RequestClientTypes\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"contact\"/>\n"
"      <arg direction=\"out\" type=\"as\" name=\"clientTypes\"/>\n"
"    </method>\n"
"    <signal name=\"ClientTypesUpdated\">\n"
"      <arg type=\"u\" name=\"contact\"/>\n"
"      <arg type=\"as\" name=\"clientTypes\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")

public:
    ConnectionInterfaceClientTypesAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceClientTypesAdaptor();

    typedef Tp::MethodInvocationContextPtr< Tp::ContactClientTypes > GetClientTypesContextPtr;
    typedef Tp::MethodInvocationContextPtr< QStringList > RequestClientTypesContextPtr;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c GetClientTypes on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getClientTypes(const Tp::UIntList& contacts, const Tp::Service::ConnectionInterfaceClientTypesAdaptor::GetClientTypesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Return the client types of the given contacts, if they are already 
     * known. If any of the given contacts&apos; client types are not known, 
     * request their current client types, but return immediately without 
     * waiting for a reply; if a reply with a non-empty client type array is 
     * later received for those contacts, the ClientTypesUpdated signal will 
     * be emitted for them. This method is appropriate for &quot;lazy&quot; 
     * client type finding, for instance displaying the client types (if 
     * available) of everyone in your contact list.
     *
     * \param contacts
     *     
     *     The contacts whose client types should be returned or signalled.
     * \return
     *     
     *     The contacts&apos; client types, if already known. Contacts whose 
     *     client types are not already known are omitted from the mapping; 
     *     contacts known to have no client type information appear in the 
     *     mapping with an empty list.
     */
    Tp::ContactClientTypes GetClientTypes(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RequestClientTypes on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void requestClientTypes(uint contact, const Tp::Service::ConnectionInterfaceClientTypesAdaptor::RequestClientTypesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Return the current client types of the given contact. If necessary, 
     * make a request to the server for up-to-date information, and wait for a 
     * reply. This method is appropriate for use in a &quot;Contact 
     * Information...&quot; dialog; it can be used to show progress 
     * information (while waiting for the method to return), and can 
     * distinguish between various error conditions.
     *
     * \param contact
     *     
     *     The contact whose client types should be returned.
     * \return
     *     
     *     The contact&apos;s client types. It MAY be empty, indicating that 
     *     no client type information was found.
     */
    QStringList RequestClientTypes(uint contact, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c ClientTypesUpdated on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void clientTypesUpdated(uint contact, const QStringList& clientTypes);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param contact
     *     
     *     The contact.
     * \param clientTypes
     *     
     *     The contact&apos;s client types, or an empty list to indicate that 
     *     nothing is known about the contact&apos;s client types.
     */
    void ClientTypesUpdated(uint contact, const QStringList& clientTypes);
};

/**
 * \class ConnectionInterfaceContactBlockingAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.ContactBlocking".
 */
class TP_QT_EXPORT ConnectionInterfaceContactBlockingAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.ContactBlocking")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.ContactBlocking\">\n"
"    <property access=\"read\" type=\"u\" name=\"ContactBlockingCapabilities\"/>\n"
"    <method name=\"BlockContacts\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"      <arg direction=\"in\" type=\"b\" name=\"reportAbusive\"/>\n"
"    </method>\n"
"    <method name=\"UnblockContacts\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"    </method>\n"
"    <method name=\"RequestBlockedContacts\">\n"
"      <arg direction=\"out\" type=\"a{us}\" name=\"contacts\">\n"
"        <annotation value=\"Tp::HandleIdentifierMap\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <signal name=\"BlockedContactsChanged\">\n"
"      <arg type=\"a{us}\" name=\"blockedContacts\">\n"
"        <annotation value=\"Tp::HandleIdentifierMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"      <arg type=\"a{us}\" name=\"unblockedContacts\">\n"
"        <annotation value=\"Tp::HandleIdentifierMap\" name=\"com.trolltech.QtDBus.QtTypeName.In1\"/>\n"
"      </arg>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(uint ContactBlockingCapabilities READ ContactBlockingCapabilities )

public:
    ConnectionInterfaceContactBlockingAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceContactBlockingAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > BlockContactsContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > UnblockContactsContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::HandleIdentifierMap > RequestBlockedContactsContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c ContactBlockingCapabilities of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'contactBlockingCapabilities' with type uint.
     *
     * 
     * \htmlonly
     * <p>Additional capabilities for contact blocking; currently, this is
     *   limited to whether contacts may be reported as abusive.</p>
     * 
     * <p>Note that there is no capability for supporting blocking itself:
     *   the presence of this interface on a  \endhtmlonly ConnectionInterface \htmlonly  indicates that blocking
     *   contacts is supported.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c ContactBlockingCapabilities.
     */
    uint ContactBlockingCapabilities() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c BlockContacts on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void blockContacts(const Tp::UIntList& contacts, bool reportAbusive, const Tp::Service::ConnectionInterfaceContactBlockingAdaptor::BlockContactsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Direct the server to block some contacts. The precise effect is
     *   protocol-dependent, but SHOULD include ignoring all current and
     *   subsequent communications from the given contacts, avoiding sending
     *   presence to them in future, and if they were already receiving the
     *   local user's presence, behaving as if the local user went
     *   offline.</p>
     * \endhtmlonly
     *
     * \param contacts
     *     
     *     Some contacts to block. If some of the contacts in this list are 
     *     already blocked, the connection manager MUST act as if they were 
     *     not specified in this list.
     * \param reportAbusive
     *     
     *     \htmlonly
     *     <p>In addition to blocking, report these contacts as abusive to the
     *       server administrators.</p>
     *     
     *     <p>Clients can determine whether this capability is available by
     *       checking the
     *        \\\\endhtmlonly \\\\link requestPropertyContactBlockingCapabilities() ContactBlockingCapabilities \\\\endlink \\\\htmlonly 
     *       property. If this argument is set to <code>True</code> by a client
     *       despite  \\\\endhtmlonly \\\\link requestPropertyContactBlockingCapabilities() ContactBlockingCapabilities \\\\endlink \\\\htmlonly 
     *       not containing the <code>Can_Report_Abusive</code> flag, the
     *       connection manager SHOULD act as if it were <code>False</code> and
     *       simply block the supplied contacts.</p>
     *     
     *     <div class="rationale">
     *       <p>A correct user interface shouldn't get this far without knowing
     *         that reporting abusive contacts is not supported. If it does,
     *         then the user has expressed their intention to block these
     *         contacts. Returning an error would leave the UI with three
     *         options:</p>
     *     
     *       <ul>
     *         <li>Ignore the error, leaving the contacts not actually blocked;</li>
     *         <li>Display an error to the user;</li>
     *         <li>Call this method again, passing <code>False</code> for this
     *         argument.</li>
     *       </ul>
     *     
     *       <p>None of these seem preferable to the CM just ignoring this flag
     *         if it doesn't support it: that way, the contacts will be blocked,
     *         as the user requested, and UIs have fewer ways to mess up
     *         entirely.</p>
     *     </div>
     *     \endhtmlonly
     */
    void BlockContacts(const Tp::UIntList& contacts, bool reportAbusive, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c UnblockContacts on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void unblockContacts(const Tp::UIntList& contacts, const Tp::Service::ConnectionInterfaceContactBlockingAdaptor::UnblockContactsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Direct the server to unblock some contacts.</p>
     * \endhtmlonly
     *
     * \param contacts
     *     
     *     Some contacts to unblock. If some of the contacts in this list are 
     *     not currently blocked, the connection manager MUST act as if they 
     *     were not specified in this list.
     */
    void UnblockContacts(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RequestBlockedContacts on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void requestBlockedContacts(const Tp::Service::ConnectionInterfaceContactBlockingAdaptor::RequestBlockedContactsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>List the contacts that are blocked.</p>
     * 
     * <p>Clients SHOULD allow a relatively long timeout for calls to this
     *   method, since on some protocols contact blocking is part of the
     *   contact list, which can take a significant time to retrieve.</p>
     * \endhtmlonly
     *
     * \return
     *     
     *     The blocked contacts’ handles, together with their identifiers.
     */
    Tp::HandleIdentifierMap RequestBlockedContacts(const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c BlockedContactsChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void blockedContactsChanged(const Tp::HandleIdentifierMap& blockedContacts, const Tp::HandleIdentifierMap& unblockedContacts);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param blockedContacts
     *     
     *     Contacts added to the result of RequestBlockedContacts.
     * \param unblockedContacts
     *     
     *     Contacts removed from the result of RequestBlockedContacts.
     */
    void BlockedContactsChanged(const Tp::HandleIdentifierMap& blockedContacts, const Tp::HandleIdentifierMap& unblockedContacts);
};

/**
 * \class ConnectionInterfaceContactCapabilitiesAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.ContactCapabilities".
 */
class TP_QT_EXPORT ConnectionInterfaceContactCapabilitiesAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.ContactCapabilities")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.ContactCapabilities\">\n"
"    <method name=\"UpdateCapabilities\">\n"
"      <arg direction=\"in\" type=\"a(saa{sv}as)\" name=\"handlerCapabilities\">\n"
"        <annotation value=\"Tp::HandlerCapabilitiesList\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"GetContactCapabilities\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"handles\"/>\n"
"      <arg direction=\"out\" type=\"a{ua(a{sv}as)}\" name=\"contactCapabilities\">\n"
"        <annotation value=\"Tp::ContactCapabilitiesMap\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <signal name=\"ContactCapabilitiesChanged\">\n"
"      <arg type=\"a{ua(a{sv}as)}\" name=\"caps\">\n"
"        <annotation value=\"Tp::ContactCapabilitiesMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </signal>\n"
"  </interface>\n"
"")

public:
    ConnectionInterfaceContactCapabilitiesAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceContactCapabilitiesAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > UpdateCapabilitiesContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::ContactCapabilitiesMap > GetContactCapabilitiesContextPtr;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c UpdateCapabilities on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void updateCapabilities(const Tp::HandlerCapabilitiesList& handlerCapabilities, const Tp::Service::ConnectionInterfaceContactCapabilitiesAdaptor::UpdateCapabilitiesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Alter the connection's advertised capabilities to include
     *   the intersection of the given clients' capabilities with what the
     *   connection manager is able to implement.</p>
     * 
     * <p>On connections managed by the ChannelDispatcher, processes other
     *   than the ChannelDispatcher SHOULD NOT call this method, and the
     *   ChannelDispatcher SHOULD use this method to advertise the
     *   capabilities of all the registered  \endhtmlonly ClientHandlerInterface \htmlonly 
     *   implementations.On connections not managed by the ChannelDispatcher,
     *   clients MAY use this method directly, to indicate the channels they
     *   will handle and the extra capabilities they have.</p>
     * 
     * <p>Upon a successful invocation of this method, the connection manager
     *   will only emit the
     *    \endhtmlonly ContactCapabilitiesChanged() \htmlonly  signal
     *   for the user's  \endhtmlonly \link ConnectionInterface::requestPropertySelfHandle() ConnectionInterface::SelfHandle \endlink \htmlonly 
     *   if, in the underlying protocol, the new capabilities are distinct
     *   from the previous state.</p>
     * 
     * <div class="rationale">
     *   <p>The connection manager will essentially intersect the provided
     *     capabilities and the channel classes it implements. Therefore,
     *     certain properties which are never fixed for a channel class
     *     (such as the target handle, or the Parameters property of a tube
     *     channel) will almost certainly not be advertised.</p>
     * </div>
     * 
     * <p>This method MAY be called on a newly-created connection while it
     *   is still in the DISCONNECTED state, to request that when the
     *   connection connects, it will do so with the appropriate
     *   capabilities. Doing so MUST NOT fail.</p>
     * \endhtmlonly
     *
     * \param handlerCapabilities
     *     
     *     The capabilities of one or more clients. For each client in the 
     *     given list, any capabilities previously advertised for the same 
     *     client name are discarded, then replaced by the capabilities 
     *     indicated. As a result, if a client becomes unavailable, this 
     *     method SHOULD be called with a Handler_Capabilities structure 
     *     containing its name, an empty list of channel classes, and an empty 
     *     list of capabilities. When this is done, the connection manager 
     *     SHOULD free all memory associated with that client name. This 
     *     method takes a list of clients so that when the channel dispatcher 
     *     first calls it (with a list of all the Handlers that are initially 
     *     available), the changes can be made atomically, with only one 
     *     transmission of updated capabilities to the network. Afterwards, 
     *     the channel dispatcher will call this method with a single-element 
     *     list every time a Handler becomes available or unavailable. The 
     *     connection manager MUST ignore any channel classes and client 
     *     capabilities for which there is no representation in the protocol 
     *     or no support in the connection manager.
     */
    void UpdateCapabilities(const Tp::HandlerCapabilitiesList& handlerCapabilities, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetContactCapabilities on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getContactCapabilities(const Tp::UIntList& handles, const Tp::Service::ConnectionInterfaceContactCapabilitiesAdaptor::GetContactCapabilitiesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Returns an array of requestable channel classes for the given
     *   contact handles, representing the channel requests that are
     *   expected to succeed.</p>
     * \endhtmlonly
     *
     * \param handles
     *     
     *     \htmlonly
     *     <p>An array of contact handles for this connection.</p>
     *     
     *     <p>The handle zero MUST NOT be included in the request.</p>
     *     \endhtmlonly
     * \return
     *     
     *     \htmlonly
     *     <p>A map from contact handles to lists of requestable channel
     *       classes, representing the channel requests that are expected
     *       to succeed for that contact.</p>
     *     
     *     <p>Contacts listed among Handles whose capabilities are unknown
     *       SHOULD be omitted from this map; contacts known to have an empty
     *       set of capabilities SHOULD be included in the keys of this map,
     *       with an empty array as the corresponding value.</p>
     *     \endhtmlonly
     */
    Tp::ContactCapabilitiesMap GetContactCapabilities(const Tp::UIntList& handles, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c ContactCapabilitiesChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void contactCapabilitiesChanged(const Tp::ContactCapabilitiesMap& caps);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param caps
     *     
     *     \htmlonly
     *     All the capabilities of the contacts
     *     \endhtmlonly
     */
    void ContactCapabilitiesChanged(const Tp::ContactCapabilitiesMap& caps);
};

/**
 * \class ConnectionInterfaceContactGroupsAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.ContactGroups".
 */
class TP_QT_EXPORT ConnectionInterfaceContactGroupsAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.ContactGroups")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.ContactGroups\">\n"
"    <property access=\"read\" type=\"b\" name=\"DisjointGroups\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"GroupStorage\"/>\n"
"    <property access=\"read\" type=\"as\" name=\"Groups\"/>\n"
"    <method name=\"SetContactGroups\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"contact\"/>\n"
"      <arg direction=\"in\" type=\"as\" name=\"groups\"/>\n"
"    </method>\n"
"    <method name=\"SetGroupMembers\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"group\"/>\n"
"      <arg direction=\"in\" type=\"au\" name=\"members\"/>\n"
"    </method>\n"
"    <method name=\"AddToGroup\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"group\"/>\n"
"      <arg direction=\"in\" type=\"au\" name=\"members\"/>\n"
"    </method>\n"
"    <method name=\"RemoveFromGroup\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"group\"/>\n"
"      <arg direction=\"in\" type=\"au\" name=\"members\"/>\n"
"    </method>\n"
"    <method name=\"RemoveGroup\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"group\"/>\n"
"    </method>\n"
"    <method name=\"RenameGroup\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"oldName\"/>\n"
"      <arg direction=\"in\" type=\"s\" name=\"newName\"/>\n"
"    </method>\n"
"    <signal name=\"GroupsChanged\">\n"
"      <arg type=\"au\" name=\"contact\"/>\n"
"      <arg type=\"as\" name=\"added\"/>\n"
"      <arg type=\"as\" name=\"removed\"/>\n"
"    </signal>\n"
"    <signal name=\"GroupsCreated\">\n"
"      <arg type=\"as\" name=\"names\"/>\n"
"    </signal>\n"
"    <signal name=\"GroupRenamed\">\n"
"      <arg type=\"s\" name=\"oldName\"/>\n"
"      <arg type=\"s\" name=\"newName\"/>\n"
"    </signal>\n"
"    <signal name=\"GroupsRemoved\">\n"
"      <arg type=\"as\" name=\"names\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(bool DisjointGroups READ DisjointGroups )
    Q_PROPERTY(uint GroupStorage READ GroupStorage )
    Q_PROPERTY(QStringList Groups READ Groups )

public:
    ConnectionInterfaceContactGroupsAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceContactGroupsAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > SetContactGroupsContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > SetGroupMembersContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > AddToGroupContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > RemoveFromGroupContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > RemoveGroupContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > RenameGroupContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c DisjointGroups of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'disjointGroups' with type bool.
     *
     * 
     * \htmlonly
     * <p>True if each contact can be in at most one group; false if each
     *   contact can be in many groups.</p>
     * 
     * <p>This property cannot change after the connection has moved to the
     *   Connected state. Until then, its value is undefined, and it may
     *   change at any time, without notification.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c DisjointGroups.
     */
    bool DisjointGroups() const;
    /**
     * Return the value of the exported D-Bus object property \c GroupStorage of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'groupStorage' with type uint.
     *
     * 
     * Indicates the extent to which contacts&apos; groups can be set and 
     * stored. This property cannot change after the connection has moved to 
     * the Connected state. Until then, its value is undefined, and it may 
     * change at any time, without notification.
     *
     * \return The value of exported property \c GroupStorage.
     */
    uint GroupStorage() const;
    /**
     * Return the value of the exported D-Bus object property \c Groups of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'groups' with type QStringList.
     *
     * 
     * \htmlonly
     * <p>The names of all groups that currently exist. This may be a
     *   larger set than the union of all contacts' <code>groups</code>
     *   contact attributes, if the connection allows groups to be
     *   empty.</p>
     * 
     * <p>Change notification is via
     *    \endhtmlonly GroupsCreated() \htmlonly  and
     *    \endhtmlonly GroupsRemoved() \htmlonly ; clients can also
     *   distinguish between a create/remove pair and a renamed group by
     *   receiving  \endhtmlonly GroupRenamed() \htmlonly .</p>
     * 
     * <p>This property's value is not meaningful until the
     *    \endhtmlonly \link ConnectionInterfaceContactListInterface::requestPropertyContactListState() ConnectionInterfaceContactListInterface::ContactListState \endlink \htmlonly  has become Success.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c Groups.
     */
    QStringList Groups() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c SetContactGroups on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void setContactGroups(uint contact, const QStringList& groups, const Tp::Service::ConnectionInterfaceContactGroupsAdaptor::SetContactGroupsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Add the given contact to the given groups (creating new groups
     *   if necessary), and remove them from all other groups.</p>
     * 
     * <div class="rationale">
     *   <p>This is the easiest and most correct way to implement user
     *     interfaces that display a single contact with a list of groups,
     *     resulting in a user expectation that when they apply the changes,
     *     the contact's set of groups will become exactly what was
     *     displayed.</p>
     * </div>
     * 
     * <p>If the user is removed from a group of which they were the only
     *   member, the group MAY be removed automatically.</p>
     * 
     * <div class="rationale">
     *   <p>In protocols like XMPP where groups behave like tags, a group
     *     with no members has no protocol representation.</p>
     * </div>
     * 
     * <p>Any  \endhtmlonly GroupsCreated() \htmlonly ,
     *    \endhtmlonly GroupsChanged() \htmlonly  and
     *    \endhtmlonly GroupsRemoved() \htmlonly  signals that result from
     *   this method call MUST be emitted before the method returns.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link ConnectionInterfaceContactListInterface::requestPropertyContactListState() ConnectionInterfaceContactListInterface::ContactListState \endlink \htmlonly  changes to Success.
     *   If the ContactListState is Failure, this method SHOULD raise the
     *   same error as
     *    \endhtmlonly ConnectionInterfaceContactListInterface::GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * \param contact
     *     
     *     The contact to alter.
     * \param groups
     *     
     *     The set of groups which the contact should be in.
     */
    void SetContactGroups(uint contact, const QStringList& groups, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c SetGroupMembers on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void setGroupMembers(const QString& group, const Tp::UIntList& members, const Tp::Service::ConnectionInterfaceContactGroupsAdaptor::SetGroupMembersContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Add the given members to the given group (creating it if necessary),
     *   and remove all other members.</p>
     * 
     * <div class="rationale">
     *   <p>This is the easiest and most correct way to implement user
     *     interfaces that display a single group with a list of contacts,
     *     resulting in a user expectation that when they apply the changes,
     *     the groups's set of members will become exactly what was
     *     displayed.</p>
     * </div>
     * 
     * <p>If  \endhtmlonly \link requestPropertyDisjointGroups() DisjointGroups \endlink \htmlonly  is true,
     *   this will also remove each member from their previous group.</p>
     * 
     * <p>If the user is removed from a group of which they were the only
     *   member, the group MAY be removed automatically.</p>
     * 
     * <p>Any  \endhtmlonly GroupsCreated() \htmlonly ,
     *    \endhtmlonly GroupsChanged() \htmlonly  and
     *    \endhtmlonly GroupsRemoved() \htmlonly  signals that result from
     *   this method call MUST be emitted before the method returns.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link ConnectionInterfaceContactListInterface::requestPropertyContactListState() ConnectionInterfaceContactListInterface::ContactListState \endlink \htmlonly  changes to Success.
     *   If the ContactListState is Failure, this method SHOULD raise the
     *   same error as
     *    \endhtmlonly ConnectionInterfaceContactListInterface::GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * \param group
     *     
     *     The group to alter.
     * \param members
     *     
     *     The set of members for the group. If this set is empty, this method 
     *     MAY remove the group.
     */
    void SetGroupMembers(const QString& group, const Tp::UIntList& members, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c AddToGroup on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void addToGroup(const QString& group, const Tp::UIntList& members, const Tp::Service::ConnectionInterfaceContactGroupsAdaptor::AddToGroupContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Add the given members to the given group, creating it if
     *   necessary.</p>
     * 
     * <p>If  \endhtmlonly \link requestPropertyDisjointGroups() DisjointGroups \endlink \htmlonly  is true,
     *   this will also remove each member from their previous group.</p>
     * 
     * <div class="rationale">
     *   <p>This is good for user interfaces in which you can edit groups
     *     via drag-and-drop.</p>
     * </div>
     * 
     * <p>Any  \endhtmlonly GroupsCreated() \htmlonly ,
     *    \endhtmlonly GroupsChanged() \htmlonly  and
     *    \endhtmlonly GroupsRemoved() \htmlonly  signals that result from
     *   this method call MUST be emitted before the method returns.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link ConnectionInterfaceContactListInterface::requestPropertyContactListState() ConnectionInterfaceContactListInterface::ContactListState \endlink \htmlonly  changes to Success.
     *   If the ContactListState is Failure, this method SHOULD raise the
     *   same error as
     *    \endhtmlonly ConnectionInterfaceContactListInterface::GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * \param group
     *     
     *     The group to alter.
     * \param members
     *     
     *     The set of members to include in the group.
     */
    void AddToGroup(const QString& group, const Tp::UIntList& members, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RemoveFromGroup on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void removeFromGroup(const QString& group, const Tp::UIntList& members, const Tp::Service::ConnectionInterfaceContactGroupsAdaptor::RemoveFromGroupContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Remove the given members from the given group.</p>
     * 
     * <div class="rationale">
     *   <p>This is good for user interfaces in which you can edit groups
     *     via drag-and-drop.</p>
     * </div>
     * 
     * <p>Any  \endhtmlonly GroupsChanged() \htmlonly  or
     *    \endhtmlonly GroupsRemoved() \htmlonly  signals that result from
     *   this method call MUST be emitted before the method returns.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link ConnectionInterfaceContactListInterface::requestPropertyContactListState() ConnectionInterfaceContactListInterface::ContactListState \endlink \htmlonly  changes to Success.
     *   If the ContactListState is Failure, this method SHOULD raise the
     *   same error as
     *    \endhtmlonly ConnectionInterfaceContactListInterface::GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * \param group
     *     
     *     The group to alter. If it does not exist, then it has no members by 
     *     definition, so this method SHOULD return successfully.
     * \param members
     *     
     *     The set of members to remove from the group. It is not an error to 
     *     remove members who are already not in the group. If there are no 
     *     members left in the group afterwards, the group MAY itself be 
     *     removed.
     */
    void RemoveFromGroup(const QString& group, const Tp::UIntList& members, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RemoveGroup on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void removeGroup(const QString& group, const Tp::Service::ConnectionInterfaceContactGroupsAdaptor::RemoveGroupContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Remove all members from the given group, then remove the group
     *   itself. If the group already does not exist, this method SHOULD
     *   return successfully.</p>
     * 
     * <p>Any  \endhtmlonly GroupsChanged() \htmlonly  or
     *    \endhtmlonly GroupsRemoved() \htmlonly  signals that result from
     *   this method call MUST be emitted before the method returns.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link ConnectionInterfaceContactListInterface::requestPropertyContactListState() ConnectionInterfaceContactListInterface::ContactListState \endlink \htmlonly  changes to Success.
     *   If the ContactListState is Failure, this method SHOULD raise the
     *   same error as
     *    \endhtmlonly ConnectionInterfaceContactListInterface::GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * \param group
     *     
     *     The group to remove.
     */
    void RemoveGroup(const QString& group, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RenameGroup on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void renameGroup(const QString& oldName, const QString& newName, const Tp::Service::ConnectionInterfaceContactGroupsAdaptor::RenameGroupContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Rename the given group.</p>
     * 
     * <p>On protocols where groups behave like tags, this is an API
     *   short-cut for adding all of the group's members to a group with
     *   the new name, then removing the old group.</p>
     * 
     * <div class="rationale">
     *   <p>Otherwise, clients can't perform this operation atomically, even
     *     if the connection could.</p>
     * </div>
     * 
     * <p>Any  \endhtmlonly GroupRenamed() \htmlonly  or
     *    \endhtmlonly GroupsRemoved() \htmlonly  signals that result from
     *   this method call MUST be emitted before the method returns.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link ConnectionInterfaceContactListInterface::requestPropertyContactListState() ConnectionInterfaceContactListInterface::ContactListState \endlink \htmlonly  changes to Success.
     *   If the ContactListState is Failure, this method SHOULD raise the
     *   same error as
     *    \endhtmlonly ConnectionInterfaceContactListInterface::GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * \param oldName
     *     
     *     The group to rename.
     * \param newName
     *     
     *     The new name for the group.
     */
    void RenameGroup(const QString& oldName, const QString& newName, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c GroupsChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void groupsChanged(const Tp::UIntList& contact, const QStringList& added, const QStringList& removed);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param contact
     *     
     *     The relevant contacts.
     * \param added
     *     
     *     The names of groups to which the contacts were added.
     * \param removed
     *     
     *     The names of groups from which the contacts were removed.
     */
    void GroupsChanged(const Tp::UIntList& contact, const QStringList& added, const QStringList& removed);
    /**
     * Represents the exported D-Bus signal \c GroupsCreated on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void groupsCreated(const QStringList& names);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param names
     *     
     *     The names of the new groups.
     */
    void GroupsCreated(const QStringList& names);
    /**
     * Represents the exported D-Bus signal \c GroupRenamed on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void groupRenamed(const QString& oldName, const QString& newName);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param oldName
     *     
     *     The old name of the group.
     * \param newName
     *     
     *     The new name of the group.
     */
    void GroupRenamed(const QString& oldName, const QString& newName);
    /**
     * Represents the exported D-Bus signal \c GroupsRemoved on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void groupsRemoved(const QStringList& names);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param names
     *     
     *     The names of the groups.
     */
    void GroupsRemoved(const QStringList& names);
};

/**
 * \class ConnectionInterfaceContactInfoAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.ContactInfo".
 */
class TP_QT_EXPORT ConnectionInterfaceContactInfoAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.ContactInfo")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.ContactInfo\">\n"
"    <property access=\"read\" type=\"u\" name=\"ContactInfoFlags\"/>\n"
"    <property access=\"read\" type=\"a(sasuu)\" name=\"SupportedFields\">\n"
"      <annotation value=\"Tp::FieldSpecs\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <method name=\"GetContactInfo\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"      <arg direction=\"out\" type=\"a{ua(sasas)}\" name=\"contactInfo\">\n"
"        <annotation value=\"Tp::ContactInfoMap\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"RefreshContactInfo\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"    </method>\n"
"    <method name=\"RequestContactInfo\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"contact\"/>\n"
"      <arg direction=\"out\" type=\"a(sasas)\" name=\"contactInfo\">\n"
"        <annotation value=\"Tp::ContactInfoFieldList\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"SetContactInfo\">\n"
"      <arg direction=\"in\" type=\"a(sasas)\" name=\"contactInfo\">\n"
"        <annotation value=\"Tp::ContactInfoFieldList\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <signal name=\"ContactInfoChanged\">\n"
"      <arg type=\"u\" name=\"contact\"/>\n"
"      <arg type=\"a(sasas)\" name=\"contactInfo\">\n"
"        <annotation value=\"Tp::ContactInfoFieldList\" name=\"com.trolltech.QtDBus.QtTypeName.In1\"/>\n"
"      </arg>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(uint ContactInfoFlags READ ContactInfoFlags )
    Q_PROPERTY(Tp::FieldSpecs SupportedFields READ SupportedFields )

public:
    ConnectionInterfaceContactInfoAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceContactInfoAdaptor();

    typedef Tp::MethodInvocationContextPtr< Tp::ContactInfoMap > GetContactInfoContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > RefreshContactInfoContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::ContactInfoFieldList > RequestContactInfoContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > SetContactInfoContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c ContactInfoFlags of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'contactInfoFlags' with type uint.
     *
     * 
     * \htmlonly
     * <p>An integer representing the bitwise-OR of flags on this
     *   connection.</p>
     * 
     * <p>This property MAY change, without change notification, at any time
     *   before the connection moves to status Connection_Status_Connected.
     *   It MUST NOT change after that point.</p>
     * 
     * <div class="rationale">
     *   <p>Some XMPP servers, like Facebook Chat, do not allow the vCard to
     *     be changed (and so would not have the Can_Set flag). Whether the
     *     user's server is one of these cannot necessarily be detected until
     *     quite late in the connection process.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c ContactInfoFlags.
     */
    uint ContactInfoFlags() const;
    /**
     * Return the value of the exported D-Bus object property \c SupportedFields of type \c Tp::FieldSpecs.
     *
     * Adaptees should export this property as a Qt property named
     * 'supportedFields' with type Tp::FieldSpecs.
     *
     * 
     * \htmlonly
     *         <p>A list of field specifications describing the kinds of fields which may
     *           be passed to  \endhtmlonly SetContactInfo() \htmlonly .  The empty
     *           list indicates that arbitrary vCard fields are permitted.  This
     *           property SHOULD be the empty list, and be ignored by clients, if
     *            \endhtmlonly \link requestPropertyContactInfoFlags() ContactInfoFlags \endlink \htmlonly  does not contain the
     *           Can_Set flag.</p>
     * 
     *         <p>For example, a protocol in which arbitrary vCards were stored
     *           as-is would set this property to the
     *           empty list. A protocol whose notion of contact information is one
     *           each of personal phone number, mobile phone number, location, email
     *           address and date of birth, with no attributes allowed on each piece
     *           of information, would set this property to (in Python-like
     *           syntax):</p>
     * 
     *         <pre>
     * [
     *   ('tel', ['type=home'], Parameters_Exact, 1),
     *   ('tel', ['type=cell'], Parameters_Exact, 1),
     *   ('adr', [], Parameters_Exact, 1),
     *   ('bday', [], Parameters_Exact, 1),
     *   ('email', ['type=internet'], Parameters_Exact, 1),
     * ]</pre>
     * 
     *         <p>A protocol which allows users to specify up to four phone numbers,
     *           which may be labelled as personal and/or mobile, would set this
     *           property to
     *           <code>[ ('tel', ['type=home', 'type=cell'], 0, 4), ]</code>.</p>
     * 
     *         <div class="rationale">
     *           <p>Studying existing IM protocols shows that in practice protocols
     *             allow either a very restricted set of fields (such as MSN, which
     *             seems to correspond roughly to the largest example above), or
     *             something mapping 1:1 to a large subset of vCard (such as XMPP's
     *             XEP-0054).</p>
     *         </div>
     * 
     *         <p>This property MAY change, without change notification, at any time
     *           before the connection moves to status Connection_Status_Connected.
     *           It MUST NOT change after that point.</p>
     * 
     *         <div class="rationale">
     *           <p>Some XMPP servers, like Google Talk, only allow a small subset of
     *             the "vcard-temp" protocol. Whether the user's server is one of
     *             these cannot be detected until quite late in the connection
     *             process.</p>
     *         </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c SupportedFields.
     */
    Tp::FieldSpecs SupportedFields() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c GetContactInfo on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getContactInfo(const Tp::UIntList& contacts, const Tp::Service::ConnectionInterfaceContactInfoAdaptor::GetContactInfoContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Request information on several contacts at once. This SHOULD only 
     * return cached information, omitting handles for which no information is 
     * cached from the returned map.
     *
     * \param contacts
     *     
     *     An array of handles representing contacts.
     * \return
     *     
     *     A dictionary mapping contact handles to information, whose keys are 
     *     the subset of the requested list of handles for which information 
     *     was cached.
     */
    Tp::ContactInfoMap GetContactInfo(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RefreshContactInfo on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void refreshContactInfo(const Tp::UIntList& contacts, const Tp::Service::ConnectionInterfaceContactInfoAdaptor::RefreshContactInfoContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Retrieve information for the given contact, requesting it from the 
     * network if an up-to-date version is not cached locally. This method 
     * SHOULD return immediately, emitting ContactInfoChanged when the 
     * contacts&apos; updated contact information is returned. This method 
     * allows a client with cached contact information to update its cache 
     * after a number of days.
     *
     * \param contacts
     *     
     *     Integer handles for contacts.
     */
    void RefreshContactInfo(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RequestContactInfo on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void requestContactInfo(uint contact, const Tp::Service::ConnectionInterfaceContactInfoAdaptor::RequestContactInfoContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Retrieve information for a contact, requesting it from the network if 
     * it is not cached locally. This method is appropriate for an explicit 
     * user request to show a contact&apos;s information; it allows a UI to 
     * wait for the contact info to be returned.
     *
     * \param contact
     *     
     *     An integer handle for a contact.
     * \return
     *     
     *     Information about that contact.
     */
    Tp::ContactInfoFieldList RequestContactInfo(uint contact, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c SetContactInfo on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void setContactInfo(const Tp::ContactInfoFieldList& contactInfo, const Tp::Service::ConnectionInterfaceContactInfoAdaptor::SetContactInfoContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Set new contact information for this connection, replacing existing 
     * information. This method is only suppported if ContactInfoFlags 
     * contains Can_Set, and may only be passed fields conforming to 
     * SupportedFields.
     *
     * \param contactInfo
     *     
     *     The new information to be set.
     */
    void SetContactInfo(const Tp::ContactInfoFieldList& contactInfo, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c ContactInfoChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void contactInfoChanged(uint contact, const Tp::ContactInfoFieldList& contactInfo);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param contact
     *     
     *     An integer handle for the contact whose info has changed.
     * \param contactInfo
     *     
     *     \htmlonly
     *     An array of fields representing information about this contact.
     *     \endhtmlonly
     */
    void ContactInfoChanged(uint contact, const Tp::ContactInfoFieldList& contactInfo);
};

/**
 * \class ConnectionInterfaceContactListAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.ContactList".
 */
class TP_QT_EXPORT ConnectionInterfaceContactListAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.ContactList")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.ContactList\">\n"
"    <property access=\"read\" type=\"u\" name=\"ContactListState\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"ContactListPersists\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"CanChangeContactList\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"RequestUsesMessage\"/>\n"
"    <property access=\"read\" type=\"b\" name=\"DownloadAtConnection\"/>\n"
"    <method name=\"GetContactListAttributes\">\n"
"      <arg direction=\"in\" type=\"as\" name=\"interfaces\"/>\n"
"      <arg direction=\"in\" type=\"b\" name=\"hold\"/>\n"
"      <arg direction=\"out\" type=\"a{ua{sv}}\" name=\"attributes\">\n"
"        <annotation value=\"Tp::ContactAttributesMap\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"RequestSubscription\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"      <arg direction=\"in\" type=\"s\" name=\"message\"/>\n"
"    </method>\n"
"    <method name=\"AuthorizePublication\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"    </method>\n"
"    <method name=\"RemoveContacts\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"    </method>\n"
"    <method name=\"Unsubscribe\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"    </method>\n"
"    <method name=\"Unpublish\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"    </method>\n"
"    <method name=\"Download\"/>\n"
"    <signal name=\"ContactListStateChanged\">\n"
"      <arg type=\"u\" name=\"contactListState\"/>\n"
"    </signal>\n"
"    <signal name=\"ContactsChangedWithID\">\n"
"      <arg type=\"a{u(uus)}\" name=\"changes\">\n"
"        <annotation value=\"Tp::ContactSubscriptionMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"      <arg type=\"a{us}\" name=\"identifiers\">\n"
"        <annotation value=\"Tp::HandleIdentifierMap\" name=\"com.trolltech.QtDBus.QtTypeName.In1\"/>\n"
"      </arg>\n"
"      <arg type=\"a{us}\" name=\"removals\">\n"
"        <annotation value=\"Tp::HandleIdentifierMap\" name=\"com.trolltech.QtDBus.QtTypeName.In2\"/>\n"
"      </arg>\n"
"    </signal>\n"
"    <signal name=\"ContactsChanged\">\n"
"      <arg type=\"a{u(uus)}\" name=\"changes\">\n"
"        <annotation value=\"Tp::ContactSubscriptionMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"      <arg type=\"au\" name=\"removals\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(uint ContactListState READ ContactListState )
    Q_PROPERTY(bool ContactListPersists READ ContactListPersists )
    Q_PROPERTY(bool CanChangeContactList READ CanChangeContactList )
    Q_PROPERTY(bool RequestUsesMessage READ RequestUsesMessage )
    Q_PROPERTY(bool DownloadAtConnection READ DownloadAtConnection )

public:
    ConnectionInterfaceContactListAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceContactListAdaptor();

    typedef Tp::MethodInvocationContextPtr< Tp::ContactAttributesMap > GetContactListAttributesContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > RequestSubscriptionContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > AuthorizePublicationContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > RemoveContactsContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > UnsubscribeContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > UnpublishContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > DownloadContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c ContactListState of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'contactListState' with type uint.
     *
     * 
     * The progress made in retrieving the contact list. Change notification 
     * is via ContactListStateChanged.
     *
     * \return The value of exported property \c ContactListState.
     */
    uint ContactListState() const;
    /**
     * Return the value of the exported D-Bus object property \c ContactListPersists of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'contactListPersists' with type bool.
     *
     * 
     * \htmlonly
     * <p>If true, presence subscriptions (in both directions) on this
     *   connection are stored by the server or other infrastructure.</p>
     * 
     * <div class="rationale">
     *   <p>XMPP, MSN, ICQ, etc. all behave like this.</p>
     * </div>
     * 
     * <p>If false, presence subscriptions on this connection are not
     *   stored.</p>
     * 
     * <div class="rationale">
     *   <p>In SIMPLE (SIP), <em>clients</em> are expected to keep a record
     *     of subscriptions, as described below. In link-local XMPP,
     *     subscriptions are implicit (everyone on the local network receives
     *     presence from everyone else) so nothing is ever stored.</p>
     * </div>
     * 
     * <p>If  \endhtmlonly \link requestPropertyCanChangeContactList() CanChangeContactList \endlink \htmlonly 
     *   is true, Telepathy clients (e.g. user interfaces or address books)
     *   MAY keep a record of permission to publish and requests to subscribe
     *   locally, and attempt to restore it for each Connection. If
     *   ContactListPersists is false, clients MAY do this for all contacts;
     *   if ContactListPersists is true, clients SHOULD NOT change the state
     *   of contacts that were not changed locally.</p>
     * 
     * <div class="rationale">
     *   <p>In SIMPLE (SIP), ContactListPersists is false, but
     *     CanChangeContactList is true. Presence will not be received
     *     unless clients renew any subscriptions they have for each
     *     connection, in the way described. There is no server-side storage,
     *     so clients have no alternative but to maintain independent contact
     *     lists.</p>
     * 
     *   <p>In protocols like XMPP and MSN, it may be useful for clients to
     *     queue up subscription requests or removals made while offline and
     *     process them next time the connection is online. However, clients
     *     should only replay the changes, rather than resetting the contact
     *     list to match a stored copy, to avoid overwriting changes that
     *     were made on the server.</p>
     * </div>
     * 
     * <p>Clients that replay requests like this SHOULD do so by calling
     *   AuthorizePublication to pre-approve publication of presence to the
     *   appropriate contacts, followed by RequestSubscription to request the
     *   appropriate contacts' presences.</p>
     * 
     * <p>This property cannot change after the connection has moved to the
     *   Connected state. Until then, its value is undefined, and it may
     *   change at any time, without notification.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c ContactListPersists.
     */
    bool ContactListPersists() const;
    /**
     * Return the value of the exported D-Bus object property \c CanChangeContactList of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'canChangeContactList' with type bool.
     *
     * 
     * \htmlonly
     * <p>If true, presence subscription and publication can be changed
     *   using the
     *    \endhtmlonly RequestSubscription() \htmlonly ,
     *    \endhtmlonly AuthorizePublication() \htmlonly  and
     *    \endhtmlonly RemoveContacts() \htmlonly  methods.</p>
     * 
     * <p>If false, all of those methods will always fail; they SHOULD raise
     *   the error org.freedesktop.Telepathy.Error.NotImplemented.</p>
     * 
     * <div class="rationale">
     *   <p>In XEP-0174 "Serverless Messaging" (link-local XMPP), presence is
     *     implicitly published to everyone in the local subnet, so the user
     *     cannot control their presence publication.</p>
     * </div>
     * 
     * <p>This property cannot change after the connection has moved to the
     *   Connected state. Until then, its value is undefined, and it may
     *   change at any time, without notification.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c CanChangeContactList.
     */
    bool CanChangeContactList() const;
    /**
     * Return the value of the exported D-Bus object property \c RequestUsesMessage of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'requestUsesMessage' with type bool.
     *
     * 
     * \htmlonly
     * <p>If true, the Message parameter to
     *    \endhtmlonly RequestSubscription() \htmlonly  is likely to be
     *   significant, and user interfaces SHOULD prompt the user for a
     *   message to send with the request; a message such as "I would like
     *   to add you to my contact list", translated into the local user's
     *   language, might make a suitable default.</p>
     * 
     * <div class="rationale">
     *   <p>This matches user expectations in XMPP and ICQ, for instance.</p>
     * </div>
     * 
     * <p>If false, the parameter is ignored; user interfaces SHOULD avoid
     *   prompting the user, and SHOULD pass an empty string to
     *   RequestSubscription.</p>
     * 
     * <div class="rationale">
     *   <p><em>FIXME: is there any such protocol?</em></p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c RequestUsesMessage.
     */
    bool RequestUsesMessage() const;
    /**
     * Return the value of the exported D-Bus object property \c DownloadAtConnection of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'downloadAtConnection' with type bool.
     *
     * 
     * \htmlonly
     * <p>If true, the contact list is automatically downloaded at
     *   connection. If false, the contact list is only downloaded
     *   when requested explicitely with
     *    \endhtmlonly Download() \htmlonly .</p>
     * 
     * <div class="rationale">
     *   <p>Downloading the contact list uses bandwidth and is not always
     *     necessary or desired. For example, a client could cache the
     *     contact list from previous connections and accept less regular
     *     updates, it could get the contact list from an out-of-band
     *     protocol-specific way, or it could not need the contact list at
     *     all.</p>
     * </div>
     * 
     * <p>Connection managers MUST default to true.</p>
     * 
     * <div class="rationale">
     *   <p>If a connection manager starts supporting this property but
     *     defaults to false, it would break all existing clients that don't
     *     call  \endhtmlonly Download() \htmlonly .</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c DownloadAtConnection.
     */
    bool DownloadAtConnection() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c GetContactListAttributes on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getContactListAttributes(const QStringList& interfaces, bool hold, const Tp::Service::ConnectionInterfaceContactListAdaptor::GetContactListAttributesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Return some contact attributes for a list of contacts
     *   associated with the user. This list MUST include at least:</p>
     * 
     * <ul>
     *   <li>all contacts whose <tp:token-ref>subscribe</tp:token-ref>
     *     attribute is not No</li>
     *   <li>all contacts whose <tp:token-ref>publish</tp:token-ref>
     *     attribute is not No</li>
     * </ul>
     * 
     * <p>but MAY contain other contacts.</p>
     * 
     * <div class="rationale">
     *   <p>For instance, on XMPP, all contacts on the roster would appear
     *     here even if they have subscription="none", unless there's
     *     reason to believe the user does not want to see them (such as
     *     having been blocked).</p>
     * </div>
     * 
     * <p>This list does not need to contain every visible contact: for
     *   instance, contacts seen in XMPP or IRC chatrooms SHOULD NOT appear
     *   here. Blocked contacts SHOULD NOT appear here, unless they still
     *   have a non-<tt>No</tt> <tp:token-ref>subscribe</tp:token-ref> or
     *   <tp:token-ref>publish</tp:token-ref> attribute
     *   for some reason.</p>
     * 
     * <div class="rationale">
     *   <p>It's reasonable to assume that blocked contacts should not be
     *     visible to the user unless they specifically go looking for them,
     *     at least in protocols like XMPP where blocking a contact
     *     suppresses presence.</p>
     * </div>
     * \endhtmlonly
     *
     * \param interfaces
     *     
     *     \htmlonly
     *     <p>A list of strings indicating which D-Bus interfaces the calling
     *       process is interested in. Equivalent to the corresponding argument
     *       to  \\\\endhtmlonly ConnectionInterfaceContactsInterface::GetContactAttributes() \\\\htmlonly ,
     *       except that if this list does not contain the ContactList
     *       interface itself, it is treated as though that interface was also
     *       requested.</p>
     *     \endhtmlonly
     * \param hold
     *     
     *     \htmlonly
     *     <p>If true, all handles that appear as keys in the result have been
     *       held on behalf of the calling process, as if by a call to
     *        \\\\endhtmlonly ConnectionInterface::HoldHandles() \\\\htmlonly .
     *       (If  \\\\endhtmlonly \\\\link ConnectionInterface::requestPropertyHasImmortalHandles() ConnectionInterface::HasImmortalHandles \\\\endlink \\\\htmlonly  is true, which SHOULD be the
     *       case in all new connection managers, this has no effect.)</p>
     *     \endhtmlonly
     * \return
     *     
     *     \htmlonly
     *     <p>A dictionary mapping the contact handles to contact attributes,
     *       equivalent to the result of  \\\\endhtmlonly ConnectionInterfaceContactsInterface::GetContactAttributes() \\\\htmlonly .</p>
     *     \endhtmlonly
     */
    Tp::ContactAttributesMap GetContactListAttributes(const QStringList& interfaces, bool hold, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RequestSubscription on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void requestSubscription(const Tp::UIntList& contacts, const QString& message, const Tp::Service::ConnectionInterfaceContactListAdaptor::RequestSubscriptionContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Request that the given contacts allow the local user to
     *   subscribe to their presence, i.e. that their subscribe attribute
     *   becomes Yes.</p>
     * 
     * <p>Connection managers SHOULD NOT attempt to enforce a
     *   mutual-subscription policy (i.e. when this method is called, they
     *   should not automatically allow the contacts to see the local user's
     *   presence). User interfaces that require mutual subscription
     *   MAY call  \endhtmlonly AuthorizePublication() \htmlonly 
     *   at the same time as this method.</p>
     * 
     * <div class="rationale">
     *   <p>Whether to enforce mutual subscription is a matter of policy,
     *     so it is left to the user interface and/or the server.</p>
     * </div>
     * 
     * <p>Before calling this method on a connection where  \endhtmlonly ConnectionInterfaceAliasingInterface::GetAliasFlags() \htmlonly  returns the <code>User_Set</code> flag,
     *   user interfaces SHOULD obtain, from the user, an alias to
     *   identify the contact in future, and store it using  \endhtmlonly ConnectionInterfaceAliasingInterface::SetAliases() \htmlonly .</p>
     * 
     * <p>The user MAY be
     *   prompted using the contact's current self-assigned nickname, or
     *   something derived from the contact's (presumably self-assigned)
     *   identifier, as a default, but these names chosen by the contact
     *   SHOULD NOT be used without user approval.</p>
     * 
     * <div class="rationale">
     *   <p>This is a generalization of
     *     <a href="http://xmpp.org/extensions/xep-0165.html">XEP-0165 "Best Practices to Discourage JID Mimicking"</a>)
     *     to protocols other than XMPP. A reasonable user interface for
     *     this, as used in many XMPP clients, is to have a text entry
     *     for the alias adjacent to the text entry for the identifier
     *     to add.</p>
     * </div>
     * 
     * <p>For contacts with subscribe=Yes, this method has no effect.
     *   It MUST return successfully if all contacts are in this state.</p>
     * 
     * <p>For contacts with subscribe=Ask, this method SHOULD send a new
     *   request, with the given message, if allowed by the underlying
     *   protocol.</p>
     * 
     * <p>For contacts with subscribe=No or subscribe=Rejected, this method
     *   SHOULD request that the contact allows the local user to subscribe
     *   to their presence; in general, this will change their publish
     *   attribute to Ask (although it could change directly to Yes in some
     *   situations).</p>
     * 
     * <p>Any state changes that immediately result from this request MUST
     *   be signalled via  \endhtmlonly ContactsChanged() \htmlonly 
     *   before this method returns.</p>
     * 
     * <div class="rationale">
     *   <p>This makes it easy for user interfaces to see what practical
     *     effect this method had.</p>
     * </div>
     * 
     * <p>If the remote contact accepts the request, their subscribe
     *   attribute will later change from Ask to Yes.</p>
     * 
     * <p>If the remote contact explicitly rejects the request (in protocols
     *   that allow this), their subscribe attribute will later change from
     *   Ask to Rejected.</p>
     * 
     * <p>If the subscription request is cancelled by the local user, the
     *   contact's subscribe attribute will change from Ask to No.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to Success.
     *   If the  \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to
     *   Failure, this method SHOULD raise the same error as
     *    \endhtmlonly GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * \param contacts
     *     
     *     \htmlonly
     *     <p>One or more contacts to whom requests are to be sent.</p>
     *     \endhtmlonly
     * \param message
     *     
     *     \htmlonly
     *     <p>An optional plain-text message from the user, to send to those
     *       contacts with the subscription request. The
     *        \\\\endhtmlonly \\\\link requestPropertyRequestUsesMessage() RequestUsesMessage \\\\endlink \\\\htmlonly  property
     *       indicates whether this message will be used or ignored.</p>
     *     
     *     <p>Clients SHOULD NOT send a non-empty message without first giving
     *       the user an opportunity to edit it.</p>
     *     
     *     <div class="rationale">
     *       <p>These messages are typically presented to the remote contact
     *         as if the user had typed them, so as a minimum, the user should be
     *         allowed to see what the UI will be saying on their behalf.</p>
     *     </div>
     *     
     *     <p>Connections where this message is not useful MUST still allow it to
     *       be non-empty.</p>
     *     \endhtmlonly
     */
    void RequestSubscription(const Tp::UIntList& contacts, const QString& message, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c AuthorizePublication on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void authorizePublication(const Tp::UIntList& contacts, const Tp::Service::ConnectionInterfaceContactListAdaptor::AuthorizePublicationContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>For each of the given contacts, request that the local user's
     *   presence is sent to that contact, i.e. that their publish attribute
     *   becomes Yes.</p>
     * 
     * <p>Connection managers SHOULD NOT attempt to enforce a
     *   mutual-subscription policy (i.e. when this method is called, they
     *   should not automatically request that the contacts allow the user to
     *   subscribe to their presence). User interfaces that require mutual
     *   subscription MAY call
     *    \endhtmlonly RequestSubscription() \htmlonly  at the same time
     *   as this method.</p>
     * 
     * <div class="rationale">
     *   <p>Whether to enforce mutual subscription is a matter of policy,
     *     so it is left to the user interface and/or the server.</p>
     * </div>
     * 
     * <p>For contacts with publish=Yes, this method has no effect; it
     *   MUST return successfully if all contacts given have this state.</p>
     * 
     * <p>For contacts with publish=Ask, this method accepts the
     *   contact's request to see the local user's presence, changing
     *   their publish attribute from Ask to Yes.</p>
     * 
     * <p>For contacts with publish=No, if the protocol allows it, this
     *   method allows the contacts to see the local user's presence even
     *   though they have not requested it, changing their publish attribute
     *   from No to Yes. Otherwise, it merely records the fact that
     *   presence publication to those contacts is allowed; if any of
     *   those contacts ask to receive the local user's presence
     *   later in the lifetime of the connection, the connection SHOULD
     *   immediately allow them to do so, changing their publish
     *   attribute directly from No to Yes.</p>
     * 
     * <div class="rationale">
     *   <p>This makes it easy to implement the common UI policy that if
     *     the user attempts to subscribe to a contact's presence, requests
     *     for reciprocal subscription are automatically approved.</p>
     * </div>
     * 
     * <p>Any state changes that immediately result from this request MUST
     *   be signalled via  \endhtmlonly ContactsChanged() \htmlonly 
     *   before this method returns.</p>
     * 
     * <div class="rationale">
     *   <p>This makes it easy for user interfaces to see what practical
     *     effect this method had.</p>
     * </div>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to Success.
     *   If the  \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to
     *   Failure, this method SHOULD raise the same error as
     *    \endhtmlonly GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * \param contacts
     *     
     *     \htmlonly
     *     <p>One or more contacts to authorize.</p>
     *     \endhtmlonly
     */
    void AuthorizePublication(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RemoveContacts on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void removeContacts(const Tp::UIntList& contacts, const Tp::Service::ConnectionInterfaceContactListAdaptor::RemoveContactsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Remove the given contacts from the contact list entirely. It is
     *   protocol-dependent whether this works, and under which
     *   circumstances.</p>
     * 
     * <p>If possible, this method SHOULD set the contacts' subscribe and
     *   publish attributes to No, remove any stored aliases for those
     *   contacts, and remove the contacts from the result of
     *    \endhtmlonly GetContactListAttributes() \htmlonly .</p>
     * 
     * <p>This method SHOULD succeed even if it was not possible to carry out
     *   the request entirely or for all contacts (for instance, if there is an
     *   outstanding request to subscribe to the contact's presence, and it's
     *   not possible to cancel such requests). However, all signals that
     *   immediately result from this method call MUST be emitted before it
     *   returns, so that clients can interpret the result.</p>
     * 
     * <div class="rationale">
     *   <p>User interfaces removing a contact from the contact list are
     *     unlikely to want spurious failure notifications resulting from
     *     limitations of a particular protocol. However, emitting the
     *     signals first means that if a client does want to check exactly
     *     what happened, it can wait for the method to return (while
     *     applying change-notification signals to its local cache of the
     *     contact list's state), then consult its local cache of the
     *     contact list's state to see whether the contact is still there.</p>
     * </div>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to Success.
     *   If the  \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to
     *   Failure, this method SHOULD raise the same error as
     *    \endhtmlonly GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * \param contacts
     *     
     *     \htmlonly
     *     <p>One or more contacts to remove.</p>
     *     \endhtmlonly
     */
    void RemoveContacts(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c Unsubscribe on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void unsubscribe(const Tp::UIntList& contacts, const Tp::Service::ConnectionInterfaceContactListAdaptor::UnsubscribeContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Attempt to set the given contacts' subscribe attribute to No,
     *   i.e. stop receiving their presence.</p>
     * 
     * <p>For contacts with subscribe=Ask, this attempts to cancel
     *   an earlier request to subscribe to the contact's presence; for
     *   contacts with subscribe=Yes, this attempts to
     *   unsubscribe from the contact's presence.</p>
     * 
     * <p>As with  \endhtmlonly RemoveContacts() \htmlonly , this method
     *   SHOULD succeed even if it was not possible to carry out the request
     *   entirely or for all contacts; however, all signals that
     *   immediately result from this method call MUST be emitted before it
     *   returns.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to Success.
     *   If the  \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to
     *   Failure, this method SHOULD raise the same error as
     *    \endhtmlonly GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * \param contacts
     *     
     *     \htmlonly
     *     <p>One or more contacts to remove.</p>
     *     \endhtmlonly
     */
    void Unsubscribe(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c Unpublish on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void unpublish(const Tp::UIntList& contacts, const Tp::Service::ConnectionInterfaceContactListAdaptor::UnpublishContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Attempt to set the given contacts' publish attribute to No,
     *   i.e. stop sending presence to them.</p>
     * 
     * <p>For contacts with publish=Ask, this method explicitly rejects the
     *   contact's request to subscribe to the user's presence; for
     *   contacts with publish=Yes, this method attempts to prevent the
     *   user's presence from being received by the contact.</p>
     * 
     * <p>As with  \endhtmlonly RemoveContacts() \htmlonly , this method
     *   SHOULD succeed even if it was not possible to carry out the request
     *   entirely or for all contacts; however, all signals that
     *   immediately result from this method call MUST be emitted before it
     *   returns.</p>
     * 
     * <p>This method SHOULD NOT be called until the
     *    \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to Success.
     *   If the  \endhtmlonly \link requestPropertyContactListState() ContactListState \endlink \htmlonly  changes to
     *   Failure, this method SHOULD raise the same error as
     *    \endhtmlonly GetContactListAttributes() \htmlonly .</p>
     * \endhtmlonly
     *
     * \param contacts
     *     
     *     \htmlonly
     *     <p>One or more contacts to remove.</p>
     *     \endhtmlonly
     */
    void Unpublish(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c Download on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void download(const Tp::Service::ConnectionInterfaceContactListAdaptor::DownloadContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Download the contact list from the server. If
     *    \endhtmlonly \link requestPropertyDownloadAtConnection() DownloadAtConnection \endlink \htmlonly  is true,
     *   Download does nothing.</p>
     * \endhtmlonly
     *
     */
    void Download(const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c ContactListStateChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void contactListStateChanged(uint contactListState);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param contactListState
     *     
     *     The new value of ContactListState.
     */
    void ContactListStateChanged(uint contactListState);
    /**
     * Represents the exported D-Bus signal \c ContactsChangedWithID on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void contactsChangedWithID(const Tp::ContactSubscriptionMap& changes, const Tp::HandleIdentifierMap& identifiers, const Tp::HandleIdentifierMap& removals);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param changes
     *     
     *     The new subscribe, publish and publish-request attributes of all 
     *     the contacts that have been added, and all the contacts for which 
     *     those attributes have changed.
     * \param identifiers
     *     
     *     \htmlonly
     *     The identifiers of the contacts in the <var>Changes</var> map.
     *     \endhtmlonly
     * \param removals
     *     
     *     \htmlonly
     *     The contacts that have been removed from the list that would be
     *     returned by
     *      \\\\endhtmlonly GetContactListAttributes() \\\\htmlonly .
     *     This also implies that they have subscribe = No and publish = No;
     *     contacts MUST NOT be listed both here and in <var>Changes</var>.
     *     \endhtmlonly
     */
    void ContactsChangedWithID(const Tp::ContactSubscriptionMap& changes, const Tp::HandleIdentifierMap& identifiers, const Tp::HandleIdentifierMap& removals);
    /**
     * Represents the exported D-Bus signal \c ContactsChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void contactsChanged(const Tp::ContactSubscriptionMap& changes, const Tp::UIntList& removals);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param changes
     *     
     *     The same as the corresponding argument to ContactsChangedWithID.
     * \param removals
     *     
     *     The same as the corresponding argument to ContactsChangedWithID, 
     *     except that it only includes handles and not identifiers.
     */
    void ContactsChanged(const Tp::ContactSubscriptionMap& changes, const Tp::UIntList& removals);
};

/**
 * \class ConnectionInterfaceContactsAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Contacts".
 */
class TP_QT_EXPORT ConnectionInterfaceContactsAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.Contacts")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.Contacts\">\n"
"    <property access=\"read\" type=\"as\" name=\"ContactAttributeInterfaces\"/>\n"
"    <method name=\"GetContactAttributes\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"handles\"/>\n"
"      <arg direction=\"in\" type=\"as\" name=\"interfaces\"/>\n"
"      <arg direction=\"in\" type=\"b\" name=\"hold\"/>\n"
"      <arg direction=\"out\" type=\"a{ua{sv}}\" name=\"attributes\">\n"
"        <annotation value=\"Tp::ContactAttributesMap\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"GetContactByID\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"identifier\"/>\n"
"      <arg direction=\"in\" type=\"as\" name=\"interfaces\"/>\n"
"      <arg direction=\"out\" type=\"u\" name=\"handle\"/>\n"
"      <arg direction=\"out\" type=\"a{sv}\" name=\"attributes\">\n"
"        <annotation value=\"QVariantMap\" name=\"com.trolltech.QtDBus.QtTypeName.Out1\"/>\n"
"      </arg>\n"
"    </method>\n"
"  </interface>\n"
"")
    Q_PROPERTY(QStringList ContactAttributeInterfaces READ ContactAttributeInterfaces )

public:
    ConnectionInterfaceContactsAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceContactsAdaptor();

    typedef Tp::MethodInvocationContextPtr< Tp::ContactAttributesMap > GetContactAttributesContextPtr;
    typedef Tp::MethodInvocationContextPtr< uint, QVariantMap > GetContactByIDContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c ContactAttributeInterfaces of type \c QStringList.
     *
     * Adaptees should export this property as a Qt property named
     * 'contactAttributeInterfaces' with type QStringList.
     *
     * 
     * A list of D-Bus interfaces for which GetContactAttributes is expected 
     * to work. This cannot change during the lifetime of the Connection.
     *
     * \return The value of exported property \c ContactAttributeInterfaces.
     */
    QStringList ContactAttributeInterfaces() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c GetContactAttributes on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getContactAttributes(const Tp::UIntList& handles, const QStringList& interfaces, bool hold, const Tp::Service::ConnectionInterfaceContactsAdaptor::GetContactAttributesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Return any number of contact attributes for the given handles.
     *
     * \param handles
     *     
     *     An array of handles representing contacts.
     * \param interfaces
     *     
     *     \htmlonly
     *     <p>A list of strings indicating which D-Bus interfaces the calling
     *       process is interested in. All supported attributes from these
     *       interfaces, whose values can be obtained without additional network
     *       activity, will be in the reply.</p>
     *     
     *     <p>Connection managers SHOULD ignore interfaces requested which they
     *       do not support (i.e. those not mentioned in the
     *        \\\\endhtmlonly \\\\link requestPropertyContactAttributeInterfaces() ContactAttributeInterfaces \\\\endlink \\\\htmlonly 
     *       property.)</p>
     *     
     *     <div class="rationale">
     *       <p>This simplifies client-side code. Clients which care may
     *         distinguish between unsupported interfaces (e.g. this Connection
     *         does not support Avatars), and interfaces on which no information
     *         is known for these contacts (e.g. we don't know the avatar tokens
     *         of any of the contacts, so we omitted them all) by inspecting
     *          \\\\endhtmlonly \\\\link requestPropertyContactAttributeInterfaces() ContactAttributeInterfaces \\\\endlink \\\\htmlonly .</p>
     *     </div>
     *     
     *     <p>Attributes from the interface
     *        \\\\endhtmlonly ConnectionInterface \\\\htmlonly 
     *       are always returned, and need not be requested explicitly.</p>
     *     
     *     <p>As well as returning cached information immediately, the
     *       connection MAY start asynchronous requests to obtain better
     *       values for the contact attributes. If better values are later
     *       obtained by this process, they will be indicated with the usual
     *       signals (such as  \\\\endhtmlonly ConnectionInterfaceAliasingInterface::AliasesChanged() \\\\htmlonly ).</p>
     *     
     *     <div class="rationale">
     *       For instance, an XMPP connection manager could download vCards
     *       in response to a request for  \\\\endhtmlonly ConnectionInterfaceAliasingInterface \\\\htmlonly 
     *       attributes.
     *     </div>
     *     \endhtmlonly
     * \param hold
     *     
     *     \htmlonly
     *     <p>If true, all handles that appear as keys in the result have been
     *       held on behalf of the calling process, as if by a call to
     *        \\\\endhtmlonly ConnectionInterface::HoldHandles() \\\\htmlonly .
     *       (If  \\\\endhtmlonly \\\\link ConnectionInterface::requestPropertyHasImmortalHandles() ConnectionInterface::HasImmortalHandles \\\\endlink \\\\htmlonly  is true, which SHOULD be the
     *       case in all new connection managers, this has no effect.)</p>
     *     
     *     <div class="rationale">
     *       <p>For further round-trip avoidance.</p>
     *     </div>
     *     \endhtmlonly
     * \return
     *     
     *     \htmlonly
     *     <p>A dictionary mapping the contact handles to contact attributes.
     *       If any of the requested handles are in fact invalid, they are
     *       simply omitted from this mapping. If contact attributes are not
     *       immediately known, the behaviour is defined by the interface;
     *       the attribute should either be omitted from the result or
     *       replaced with a default value.</p>
     *     
     *     <p>Each contact's attributes will always include at least the
     *       identifier that would be obtained by inspecting the handle
     *       (<code>org.freedesktop.Telepathy.Connection/contact-id</code>).</p>
     *     \endhtmlonly
     */
    Tp::ContactAttributesMap GetContactAttributes(const Tp::UIntList& handles, const QStringList& interfaces, bool hold, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetContactByID on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getContactByID(const QString& identifier, const QStringList& interfaces, const Tp::Service::ConnectionInterfaceContactsAdaptor::GetContactByIDContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Return any number of contact attributes for the given identifier. This 
     * is for a single identifier to make it simpler to use for the most 
     * common use case. For multiple contacts case, GetContactAttributes 
     * should be used.
     *
     * \param identifier
     *     
     *     An identifier representing a contact.
     * \param interfaces
     *     
     *     \htmlonly
     *     <p>A list of strings indicating which D-Bus interfaces the calling
     *       process is interested in. All supported attributes from these
     *       interfaces, whose values can be obtained without additional network
     *       activity, will be in the reply.</p>
     *     <p>See  \\\\endhtmlonly GetContactAttributes() \\\\htmlonly  for
     *       details.</p>
     *     \endhtmlonly
     * \param attributes Output parameter
     *     
     *     \htmlonly
     *     <p>All supported attributes of the contact on
     *       the given interfaces that can be returned without network
     *       round-trips. If contact attributes are not immediately known, the
     *       behaviour is defined by the interface; the attribute should either
     *       be omitted from the result or replaced with a default value.</p>
     *     
     *     <p>The contact's attributes will always include at least the
     *       identifier that would be obtained by inspecting the handle
     *       (<code>org.freedesktop.Telepathy.Connection/contact-id</code>).</p>
     *     \endhtmlonly
     * \return
     *     
     *     \htmlonly
     *     <p>The contact's handle, as returned by  \\\\endhtmlonly ConnectionInterface::RequestHandles() \\\\htmlonly </p>
     *     \endhtmlonly
     */
    uint GetContactByID(const QString& identifier, const QStringList& interfaces, const QDBusMessage& dbusMessage, QVariantMap& attributes);
};

/**
 * \class ConnectionInterfaceLocationAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Location".
 */
class TP_QT_EXPORT ConnectionInterfaceLocationAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.Location")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.Location\">\n"
"    <property access=\"read\" type=\"au\" name=\"LocationAccessControlTypes\"/>\n"
"    <property access=\"readwrite\" type=\"(uv)\" name=\"LocationAccessControl\">\n"
"      <annotation value=\"Tp::RichPresenceAccessControl\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"u\" name=\"SupportedLocationFeatures\"/>\n"
"    <method name=\"GetLocations\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"      <arg direction=\"out\" type=\"a{ua{sv}}\" name=\"locations\">\n"
"        <annotation value=\"Tp::ContactLocations\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"RequestLocation\">\n"
"      <arg direction=\"in\" type=\"u\" name=\"contact\"/>\n"
"      <arg direction=\"out\" type=\"a{sv}\" name=\"location\">\n"
"        <annotation value=\"QVariantMap\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"SetLocation\">\n"
"      <arg direction=\"in\" type=\"a{sv}\" name=\"location\">\n"
"        <annotation value=\"QVariantMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <signal name=\"LocationUpdated\">\n"
"      <arg type=\"u\" name=\"contact\"/>\n"
"      <arg type=\"a{sv}\" name=\"location\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(Tp::UIntList LocationAccessControlTypes READ LocationAccessControlTypes )
    Q_PROPERTY(Tp::RichPresenceAccessControl LocationAccessControl READ LocationAccessControl WRITE SetLocationAccessControl)
    Q_PROPERTY(uint SupportedLocationFeatures READ SupportedLocationFeatures )

public:
    ConnectionInterfaceLocationAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceLocationAdaptor();

    typedef Tp::MethodInvocationContextPtr< Tp::ContactLocations > GetLocationsContextPtr;
    typedef Tp::MethodInvocationContextPtr< QVariantMap > RequestLocationContextPtr;
    typedef Tp::MethodInvocationContextPtr<  > SetLocationContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c LocationAccessControlTypes of type \c Tp::UIntList.
     *
     * Adaptees should export this property as a Qt property named
     * 'locationAccessControlTypes' with type Tp::UIntList.
     *
     * 
     * The types of access control that are supported by this connection.
     *
     * \return The value of exported property \c LocationAccessControlTypes.
     */
    Tp::UIntList LocationAccessControlTypes() const;
    /**
     * Return the value of the exported D-Bus object property \c LocationAccessControl of type \c Tp::RichPresenceAccessControl.
     *
     * Adaptees should export this property as a Qt property named
     * 'locationAccessControl' with type Tp::RichPresenceAccessControl.
     *
     * 
     * The current access control mechanism and settings for this connection. 
     * Before publishing location for the first time, if this has not been set 
     * by a client, implementations SHOULD set it to be as restrictive as 
     * possible (an empty whitelist, if supported).
     *
     * \return The value of exported property \c LocationAccessControl.
     */
    Tp::RichPresenceAccessControl LocationAccessControl() const;
    /**
     * Set the value of the exported D-Bus object property \c LocationAccessControl of type \c Tp::RichPresenceAccessControl.
     *
     * Adaptees should export this property as a writable Qt property named
     * 'locationAccessControl' with type Tp::RichPresenceAccessControl.
     *
     * 
     * The current access control mechanism and settings for this connection. 
     * Before publishing location for the first time, if this has not been set 
     * by a client, implementations SHOULD set it to be as restrictive as 
     * possible (an empty whitelist, if supported).
     */
    void SetLocationAccessControl(const Tp::RichPresenceAccessControl &newValue);
    /**
     * Return the value of the exported D-Bus object property \c SupportedLocationFeatures of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'supportedLocationFeatures' with type uint.
     *
     * 
     * \htmlonly
     * Indicates the Location features supported by this connection. This
     * property MAY be undefined before  \endhtmlonly \link ConnectionInterface::requestPropertyStatus() ConnectionInterface::Status \endlink \htmlonly 
     * becomes <code>Connected</code>, but MUST remain constant thereafter.
     * \endhtmlonly
     *
     * \return The value of exported property \c SupportedLocationFeatures.
     */
    uint SupportedLocationFeatures() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c GetLocations on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getLocations(const Tp::UIntList& contacts, const Tp::Service::ConnectionInterfaceLocationAdaptor::GetLocationsContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Return the current locations of the given contacts, if they are
     *   already known. If any of the given contacts' locations are not known,
     *   request their current locations, but return immediately without waiting
     *   for a reply; if a reply with a non-empty location is later received
     *   for those contacts, the  \endhtmlonly LocationUpdated() \htmlonly 
     *   signal will be emitted for them.</p>
     * 
     * <div class="rationale">
     *   <p>This method is appropriate for "lazy" location finding, for instance
     *     displaying the location (if available) of everyone in your contact
     *     list.</p>
     * </div>
     * 
     * <p>For backwards compatibility, if this method is called by a client
     *   whose "interest count" for this interface, as defined by  \endhtmlonly ConnectionInterface::AddClientInterest() \htmlonly , is zero, the
     *   Connection SHOULD behave as if AddClientInterest had been called for
     *   this interface just before that method call. Clients that do not
     *   explicitly call AddClientInterest SHOULD NOT call  \endhtmlonly ConnectionInterface::RemoveClientInterest() \htmlonly  either.</p>
     * \endhtmlonly
     *
     * \param contacts
     *     
     *     The contacts whose locations should be returned or signalled.
     * \return
     *     
     *     The contacts&apos; locations, if already known. Contacts whose 
     *     locations are not already known are omitted from the mapping; 
     *     contacts known to have no location information appear in the 
     *     mapping with an empty Location dictionary.
     */
    Tp::ContactLocations GetLocations(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RequestLocation on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void requestLocation(uint contact, const Tp::Service::ConnectionInterfaceLocationAdaptor::RequestLocationContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Return the current location of the given contact. If necessary, make a 
     * request to the server for up-to-date information, and wait for a reply. 
     * This method is appropriate for use in a &quot;Contact 
     * Information...&quot; dialog; it can be used to show progress 
     * information (while waiting for the method to return), and can 
     * distinguish between various error conditions.
     *
     * \param contact
     *     
     *     The contact whose location should be returned.
     * \return
     *     
     *     The contact&apos;s location. It MAY be empty, indicating that no 
     *     location information was found.
     */
    QVariantMap RequestLocation(uint contact, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c SetLocation on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void setLocation(const QVariantMap& location, const Tp::Service::ConnectionInterfaceLocationAdaptor::SetLocationContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Set the local user&apos;s own location.
     *
     * \param location
     *     
     *     The location to advertise. If the user wants to obscure their exact 
     *     location by reducing the precision or accuracy, clients MUST do 
     *     this themselves, rather than relying on the connection manager to 
     *     do so. Clients that interact with more than one connection SHOULD 
     *     advertise the same reduced-accuracy location to all of them, so 
     *     that contacts cannot obtain an undesirably accurate location by 
     *     assuming that random errors have been added and averaging the 
     *     locations advertised on multiple connections.
     */
    void SetLocation(const QVariantMap& location, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c LocationUpdated on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void locationUpdated(uint contact, const QVariantMap& location);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param contact
     *     
     *     The contact
     * \param location
     *     
     *     The contact&apos;s location, or empty to indicate that nothing is 
     *     known about the contact&apos;s location.
     */
    void LocationUpdated(uint contact, const QVariantMap& location);
};

/**
 * \class ConnectionInterfaceMailNotificationAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.MailNotification".
 */
class TP_QT_EXPORT ConnectionInterfaceMailNotificationAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.MailNotification")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.MailNotification\">\n"
"    <property access=\"read\" type=\"u\" name=\"MailNotificationFlags\"/>\n"
"    <property access=\"read\" type=\"u\" name=\"UnreadMailCount\"/>\n"
"    <property access=\"read\" type=\"aa{sv}\" name=\"UnreadMails\">\n"
"      <annotation value=\"Tp::MailList\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"s\" name=\"MailAddress\"/>\n"
"    <method name=\"RequestInboxURL\">\n"
"      <arg direction=\"out\" type=\"(sua(ss))\" name=\"URL\">\n"
"        <annotation value=\"Tp::MailURL\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"RequestMailURL\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"ID\"/>\n"
"      <arg direction=\"in\" type=\"v\" name=\"URLData\"/>\n"
"      <arg direction=\"out\" type=\"(sua(ss))\" name=\"URL\">\n"
"        <annotation value=\"Tp::MailURL\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <signal name=\"MailsReceived\">\n"
"      <arg type=\"aa{sv}\" name=\"mails\">\n"
"        <annotation value=\"Tp::MailList\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </signal>\n"
"    <signal name=\"UnreadMailsChanged\">\n"
"      <arg type=\"u\" name=\"count\"/>\n"
"      <arg type=\"aa{sv}\" name=\"mailsAdded\">\n"
"        <annotation value=\"Tp::MailList\" name=\"com.trolltech.QtDBus.QtTypeName.In1\"/>\n"
"      </arg>\n"
"      <arg type=\"as\" name=\"mailsRemoved\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(uint MailNotificationFlags READ MailNotificationFlags )
    Q_PROPERTY(uint UnreadMailCount READ UnreadMailCount )
    Q_PROPERTY(Tp::MailList UnreadMails READ UnreadMails )
    Q_PROPERTY(QString MailAddress READ MailAddress )

public:
    ConnectionInterfaceMailNotificationAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceMailNotificationAdaptor();

    typedef Tp::MethodInvocationContextPtr< Tp::MailURL > RequestInboxURLContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::MailURL > RequestMailURLContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c MailNotificationFlags of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'mailNotificationFlags' with type uint.
     *
     * 
     * Integer representing the bitwise-OR of supported features for e-mails 
     * notification on this server. This property MUST NOT change after the 
     * Connection becomes CONNECTED. This property indicates the behavior and 
     * availability of the other properties and signals within this interface. 
     * A connection manager that cannot at least set one of the flags in the 
     * Mail_Notification_Flags SHOULD NOT provide this interface.
     *
     * \return The value of exported property \c MailNotificationFlags.
     */
    uint MailNotificationFlags() const;
    /**
     * Return the value of the exported D-Bus object property \c UnreadMailCount of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'unreadMailCount' with type uint.
     *
     * 
     * \htmlonly
     * <p>The number of unread messages in the Inbox. Change notification is
     *   via  \endhtmlonly UnreadMailsChanged() \htmlonly .</p>
     * 
     * <p>This property is only useful if <tt>Supports_Unread_Mail_Count</tt>
     *   is set in the  \endhtmlonly \link requestPropertyMailNotificationFlags() MailNotificationFlags \endlink \htmlonly ;
     *   otherwise, it MUST be zero.</p>
     * 
     * <p>If <tt>Thread_Based</tt> appears in the
     *    \endhtmlonly \link requestPropertyMailNotificationFlags() MailNotificationFlags \endlink \htmlonly , this property
     *   counts the number of threads, not the number of mails.</p>
     * 
     * <p>Note that this count MAY be bigger than the number of items in
     *    \endhtmlonly \link requestPropertyUnreadMails() UnreadMails \endlink \htmlonly . See
     *    \endhtmlonly \link requestPropertyUnreadMails() UnreadMails \endlink \htmlonly  for more details.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c UnreadMailCount.
     */
    uint UnreadMailCount() const;
    /**
     * Return the value of the exported D-Bus object property \c UnreadMails of type \c Tp::MailList.
     *
     * Adaptees should export this property as a Qt property named
     * 'unreadMails' with type Tp::MailList.
     *
     * 
     * An array of unread Mails. Change notification is via 
     * UnreadMailsChanged. This property is only useful if 
     * Supports_Unread_Mails is set in MailNotificationFlags; otherwise, it 
     * MUST be an empty list. The array size MAY be shorter than 
     * UnreadMailCount. Some servers may limits the amount of detailed e-mails 
     * sent. This can significantly reduce the network traffic for large 
     * inbox. For this reason, it is normal that UnreadMailCount be bigger or 
     * equal to the size of this array.
     *
     * \return The value of exported property \c UnreadMails.
     */
    Tp::MailList UnreadMails() const;
    /**
     * Return the value of the exported D-Bus object property \c MailAddress of type \c QString.
     *
     * Adaptees should export this property as a Qt property named
     * 'mailAddress' with type QString.
     *
     * 
     * A string representing the e-mail address of the account. The CMs MUST 
     * provide this information. In close integration of MailNotification with 
     * other e-mail services, the e-mail address can be used has a unique 
     * identifier for the account. Possible integration could be between 
     * Telepathy and Evolution where the e-mail address is the common 
     * information in both interfaces.
     *
     * \return The value of exported property \c MailAddress.
     */
    QString MailAddress() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c RequestInboxURL on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void requestInboxURL(const Tp::Service::ConnectionInterfaceMailNotificationAdaptor::RequestInboxURLContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * This method creates and returns a URL and an optional POST data that 
     * allow opening the Inbox folder of a webmail account. This URL MAY 
     * contain tokens with a short lifetime, so clients SHOULD request a new 
     * URL for each visit to the webmail interface. This method is implemented 
     * only if the Supports_Request_Inbox_URL flag is set in 
     * MailNotificationFlags. We are not using properties here because the 
     * tokens are unsuitable for sharing between clients, and network 
     * round-trips may be required to obtain the information that leads to 
     * authentication free webmail access.
     *
     * \return
     *     
     *     A struture containing a URL and optional additional data to open a 
     *     webmail client, without re-authentication if possible.
     */
    Tp::MailURL RequestInboxURL(const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c RequestMailURL on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void requestMailURL(const QString& ID, const QDBusVariant& URLData, const Tp::Service::ConnectionInterfaceMailNotificationAdaptor::RequestMailURLContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * This method creates and returns a URL and optional POST data that allow 
     * opening a specific mail in a webmail interface. This method is 
     * implemented only if Supports_Request_Mail_URL flag is set in 
     * MailNotificationFlags. See RequestInboxURL for design rationale.
     *
     * \param ID
     *     
     *     The mail&apos;s id as found in the Mail structure, or the empty 
     *     string if no id key was provided.
     * \param URLData
     *     
     *     Whatever url-data was found in the Mail structure, or the boolean 
     *     value False (D-Bus type &apos;b&apos;) if no url-data was provided 
     *     in the Mail.
     * \return
     *     
     *     A struture that contains a URL and optional additional data to open 
     *     a webmail client, without re-authentication if possible.
     */
    Tp::MailURL RequestMailURL(const QString& ID, const QDBusVariant& URLData, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c MailsReceived on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void mailsReceived(const Tp::MailList& mails);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param mails
     *     
     *     \htmlonly
     *     <p>An array of <tp:type>Mail</tp:type>s. Those e-mail MUST NOT have
     *       the "id" key.</p>
     *     
     *     <div class="rationale">
     *       <p>On connections that emit this signal, it's impossible to tell
     *         when a mail has been removed, and hence when "id" has become
     *         invalid.</p>
     *     </div>
     *     \endhtmlonly
     */
    void MailsReceived(const Tp::MailList& mails);
    /**
     * Represents the exported D-Bus signal \c UnreadMailsChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void unreadMailsChanged(uint count, const Tp::MailList& mailsAdded, const QStringList& mailsRemoved);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param count
     *     
     *     Number of unread messages in the inbox (the new value of 
     *     UnreadMailCount).
     * \param mailsAdded
     *     
     *     \htmlonly
     *     <p>A list of <tp:type>Mail</tp:type> that are being added or updated
     *       in  \\\\endhtmlonly \\\\link requestPropertyUnreadMails() UnreadMails \\\\endlink \\\\htmlonly .</p>
     *     
     *     <div class="rationale">
     *       <p>Mails may be updated when the URL information (URL and POST data)
     *         have changed, or senders were added or removed from an e-mail
     *         thread.</p>
     *     </div>
     *     
     *     <p>If the <tt>Supports_Unread_Mails</tt> flag is not set, this list
     *       MUST be empty, even if Count has increased.</p>
     *     \endhtmlonly
     * \param mailsRemoved
     *     
     *     A list of e-mail IDs that are being removed from UnreadMails. If 
     *     the Supports_Unread_Mails flag is not set, this list MUST be empty, 
     *     even if Count has decreased.
     */
    void UnreadMailsChanged(uint count, const Tp::MailList& mailsAdded, const QStringList& mailsRemoved);
};

/**
 * \class ConnectionInterfacePowerSavingAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.PowerSaving".
 */
class TP_QT_EXPORT ConnectionInterfacePowerSavingAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.PowerSaving")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.PowerSaving\">\n"
"    <property access=\"read\" type=\"b\" name=\"PowerSavingActive\"/>\n"
"    <method name=\"SetPowerSaving\">\n"
"      <arg direction=\"in\" type=\"b\" name=\"activate\"/>\n"
"    </method>\n"
"    <signal name=\"PowerSavingChanged\">\n"
"      <arg type=\"b\" name=\"active\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(bool PowerSavingActive READ PowerSavingActive )

public:
    ConnectionInterfacePowerSavingAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfacePowerSavingAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > SetPowerSavingContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c PowerSavingActive of type \c bool.
     *
     * Adaptees should export this property as a Qt property named
     * 'powerSavingActive' with type bool.
     *
     * 
     * \htmlonly
     * <p><code>True</code> if protocol-level power saving features are
     *   currently activated. This property can be changed using the
     *    \endhtmlonly SetPowerSaving() \htmlonly  method; change
     *   notifications is via the
     *    \endhtmlonly PowerSavingChanged() \htmlonly  signal.</p>
     * \endhtmlonly
     *
     * \return The value of exported property \c PowerSavingActive.
     */
    bool PowerSavingActive() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c SetPowerSaving on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void setPowerSaving(bool activate, const Tp::Service::ConnectionInterfacePowerSavingAdaptor::SetPowerSavingContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Turn power saving mode on or off.</p>
     * 
     * <div class="rationale">
     *   <p>Depending on the device's activity level, the
     *     connection can have its power saving mode turned on or off.</p>
     * </div>
     * 
     * <p>Errors raised by this method indicate that power saving could not be
     *   enabled, which SHOULD NOT generally be treated as fatal.</p>
     * 
     * <div class="rationale">
     *   If the CM cannot switch modes, either because of the
     *   protocol (<code>NotImplemented</code>), or because of the service
     *   (<code>NotAvailable</code>), Mission Control (or whoever manages this)
     *   should be made aware. The error could be ignored or, in the extreme,
     *   be fascist and disconnect the account.
     * </div>
     * \endhtmlonly
     *
     * \param activate
     *     
     *     True if protocol-level power saving features should be activated; 
     *     False if they should be de-activated.
     */
    void SetPowerSaving(bool activate, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c PowerSavingChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void powerSavingChanged(bool active);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param active
     *     
     *     The new state of the power saving feature.
     */
    void PowerSavingChanged(bool active);
};

/**
 * \class ConnectionInterfaceRequestsAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.Requests".
 */
class TP_QT_EXPORT ConnectionInterfaceRequestsAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.Requests")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.Requests\">\n"
"    <property access=\"read\" type=\"a(oa{sv})\" name=\"Channels\">\n"
"      <annotation value=\"Tp::ChannelDetailsList\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"a(a{sv}as)\" name=\"RequestableChannelClasses\">\n"
"      <annotation value=\"Tp::RequestableChannelClassList\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <method name=\"CreateChannel\">\n"
"      <arg direction=\"in\" type=\"a{sv}\" name=\"request\">\n"
"        <annotation value=\"QVariantMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"      <arg direction=\"out\" type=\"o\" name=\"channel\"/>\n"
"      <arg direction=\"out\" type=\"a{sv}\" name=\"properties\">\n"
"        <annotation value=\"QVariantMap\" name=\"com.trolltech.QtDBus.QtTypeName.Out1\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <method name=\"EnsureChannel\">\n"
"      <arg direction=\"in\" type=\"a{sv}\" name=\"request\">\n"
"        <annotation value=\"QVariantMap\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"      <arg direction=\"out\" type=\"b\" name=\"yours\"/>\n"
"      <arg direction=\"out\" type=\"o\" name=\"channel\"/>\n"
"      <arg direction=\"out\" type=\"a{sv}\" name=\"properties\">\n"
"        <annotation value=\"QVariantMap\" name=\"com.trolltech.QtDBus.QtTypeName.Out2\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <signal name=\"NewChannels\">\n"
"      <arg type=\"a(oa{sv})\" name=\"channels\">\n"
"        <annotation value=\"Tp::ChannelDetailsList\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </signal>\n"
"    <signal name=\"ChannelClosed\">\n"
"      <arg type=\"o\" name=\"removed\"/>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(Tp::ChannelDetailsList Channels READ Channels )
    Q_PROPERTY(Tp::RequestableChannelClassList RequestableChannelClasses READ RequestableChannelClasses )

public:
    ConnectionInterfaceRequestsAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceRequestsAdaptor();

    typedef Tp::MethodInvocationContextPtr< QDBusObjectPath, QVariantMap > CreateChannelContextPtr;
    typedef Tp::MethodInvocationContextPtr< bool, QDBusObjectPath, QVariantMap > EnsureChannelContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c Channels of type \c Tp::ChannelDetailsList.
     *
     * Adaptees should export this property as a Qt property named
     * 'channels' with type Tp::ChannelDetailsList.
     *
     * 
     * A list of all the channels which currently exist on this connection. 
     * Change notification is via the NewChannels and ChannelClosed signals.
     *
     * \return The value of exported property \c Channels.
     */
    Tp::ChannelDetailsList Channels() const;
    /**
     * Return the value of the exported D-Bus object property \c RequestableChannelClasses of type \c Tp::RequestableChannelClassList.
     *
     * Adaptees should export this property as a Qt property named
     * 'requestableChannelClasses' with type Tp::RequestableChannelClassList.
     *
     * 
     * \htmlonly
     * <p>The classes of channel that are expected to be available on this
     *   connection, i.e. those for which
     *    \endhtmlonly CreateChannel() \htmlonly  can reasonably
     *   be expected to succeed. User interfaces can use this information
     *   to show or hide UI components.</p>
     * 
     * <p>This property cannot change after the connection has gone to
     *   state Connection_Status_Connected, so there is no change
     *   notification (if the connection has context-dependent capabilities,
     *   it SHOULD advertise support for all classes of channel that it might
     *   support during its lifetime). Before this state has been reached,
     *   the value of this property is undefined.</p>
     * 
     * <div class="rationale">
     *   <p>This is not on an optional interface, because connection
     *     managers can always offer some sort of clue about the channel
     *     classes they expect to support (at worst, they can announce
     *     support for everything for which they have code).</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c RequestableChannelClasses.
     */
    Tp::RequestableChannelClassList RequestableChannelClasses() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c CreateChannel on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void createChannel(const QVariantMap& request, const Tp::Service::ConnectionInterfaceRequestsAdaptor::CreateChannelContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Request that an entirely new channel is created.</p>
     * 
     * <div class="rationale">
     *   <p>There is deliberately no flag corresponding to the
     *     suppress_handler argument to
     *      \endhtmlonly ConnectionInterface::RequestChannel() \htmlonly ,
     *     because passing a FALSE value for that argument is deprecated.
     *     Requests made using this interface always behave as though
     *     suppress_handler was TRUE.</p>
     * </div>
     * \endhtmlonly
     *
     * \param request
     *     
     *     \htmlonly
     *     <p>A dictionary containing desirable properties, which MUST include
     *        \\\\endhtmlonly \\\\link ChannelInterface::requestPropertyChannelType() ChannelInterface::ChannelType \\\\endlink \\\\htmlonly .
     *       Some properties
     *       are defined such that only an exact match makes sense, and
     *       connection managers MUST NOT satisfy a request with a channel
     *       where that property does not match; some properties are defined
     *       such that the connection manager MAY treat the request as merely
     *       a hint, and make a best-effort attempt to satisfy it. This is
     *       documented separately for each property.</p>
     *     
     *     <p>If this dictionary contains a property whose semantics
     *       are not known to the connection manager, this method MUST fail
     *       without side-effects (in particular it must not create a new
     *       channel).</p>
     *     
     *     <div class="rationale">
     *       <p>This is necessary if we want to be able to invent properties
     *         in future that, when used in a request, are hard requirements
     *         rather than just hints. A connection manager that did not know
     *         the semantics of those properties could incorrectly return a
     *         new channel that did not satisfy the requirements.</p>
     *     </div>
     *     
     *     <p>The connection manager MUST NOT respond successfully,
     *       and SHOULD NOT create a new channel or cause any other
     *       side-effects, unless it can create a new channel that satisfies
     *       the client's requirements.</p>
     *     
     *     <p>Properties that will be set by this argument need not have write
     *       access after the channel has been created - indeed, it is
     *       expected that most will be read-only.</p>
     *     \endhtmlonly
     * \param properties Output parameter
     *     
     *     \htmlonly
     *     <p>Properties of the channel that was produced, equivalent to
     *       the properties in <tp:type>Channel_Details</tp:type>.
     *       Connection managers MUST NOT include properties here whose
     *       values can change, for the same reasons as in
     *       <tp:type>Channel_Details</tp:type>.</p>
     *     \endhtmlonly
     * \return
     *     
     *     \htmlonly
     *     <p>The Channel object, which MUST NOT be signalled with
     *        \\\\endhtmlonly NewChannels() \\\\htmlonly  until after this method
     *       returns.</p>
     *     
     *     <div class="rationale">
     *       <p>This allows the requester to alter its handling of
     *         NewChannels by knowing whether one of the channels satisfied
     *         a request it made.</p>
     *     </div>
     *     \endhtmlonly
     */
    QDBusObjectPath CreateChannel(const QVariantMap& request, const QDBusMessage& dbusMessage, QVariantMap& properties);
    /**
     * Begins a call to the exported D-Bus method \c EnsureChannel on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void ensureChannel(const QVariantMap& request, const Tp::Service::ConnectionInterfaceRequestsAdaptor::EnsureChannelContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Request that channels are ensured to exist.</p>
     * 
     * <div class="rationale">
     *   <p>The connection manager is in the best position to determine which
     *     existing channels could satisfy which requests.</p>
     * </div>
     * \endhtmlonly
     *
     * \param request
     *     
     *     \htmlonly
     *     <p>A dictionary containing desirable properties, with the same
     *       semantics as the corresponding parameter to
     *        \\\\endhtmlonly CreateChannel() \\\\htmlonly .</p>
     *     \endhtmlonly
     * \param channel Output parameter
     *     
     *     The Channel object. If it was created as a result of this method 
     *     call, it MUST NOT be signalled by NewChannels until after this 
     *     method returns. This allows the requester to alter its handling of 
     *     NewChannels by knowing whether one of the channels satisfied a 
     *     request it made.
     * \param properties Output parameter
     *     
     *     \htmlonly
     *     <p>Properties of the channel that was produced, equivalent to
     *       the properties in <tp:type>Channel_Details</tp:type>.
     *       Connection managers MUST NOT include properties here whose
     *       values can change, for the same reasons as in
     *       <tp:type>Channel_Details</tp:type>.</p>
     *     \endhtmlonly
     * \return
     *     
     *     \htmlonly
     *     <p>If false, the caller of EnsureChannel MUST assume that some
     *       other process is handling this channel; if true, the caller of
     *       EnsureChannel SHOULD handle it themselves or delegate it to another
     *       client.</p>
     *     
     *     <p>If the creation of a channel makes several calls to EnsureChannel
     *       (and no other requests) successful, exactly one of those calls MUST
     *       return a true value for this argument.</p>
     *     
     *     <p>If the creation of a channel makes other requests successful,
     *       the value returned for this argument MUST be such that exactly
     *       one of the clients making requests ends up responsible for the
     *       channel. In particular, if
     *        \\\\endhtmlonly CreateChannel() \\\\htmlonly  returns a channel
     *       <em>C</em>, any EnsureChannel calls that also return <em>C</em>
     *       MUST return a false value for this argument.</p>
     *     \endhtmlonly
     */
    bool EnsureChannel(const QVariantMap& request, const QDBusMessage& dbusMessage, QDBusObjectPath& channel, QVariantMap& properties);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c NewChannels on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void newChannels(const Tp::ChannelDetailsList& channels);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param channels
     *     
     *     The channels and their details. All channels that are signalled 
     *     together like this MUST have the same Bundle property, which may 
     *     either refer to an existing bundle, or establish a new bundle.
     */
    void NewChannels(const Tp::ChannelDetailsList& channels);
    /**
     * Represents the exported D-Bus signal \c ChannelClosed on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void channelClosed(const QDBusObjectPath& removed);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param removed
     *     
     *     The channel which has been removed from the Channels property
     */
    void ChannelClosed(const QDBusObjectPath& removed);
};

/**
 * \class ConnectionInterfaceServicePointAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.ServicePoint".
 */
class TP_QT_EXPORT ConnectionInterfaceServicePointAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.ServicePoint")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.ServicePoint\">\n"
"    <property access=\"read\" type=\"a((us)as)\" name=\"KnownServicePoints\">\n"
"      <annotation value=\"Tp::ServicePointInfoList\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <signal name=\"ServicePointsChanged\">\n"
"      <arg type=\"a((us)as)\" name=\"servicePoints\">\n"
"        <annotation value=\"Tp::ServicePointInfoList\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(Tp::ServicePointInfoList KnownServicePoints READ KnownServicePoints )

public:
    ConnectionInterfaceServicePointAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceServicePointAdaptor();


public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c KnownServicePoints of type \c Tp::ServicePointInfoList.
     *
     * Adaptees should export this property as a Qt property named
     * 'knownServicePoints' with type Tp::ServicePointInfoList.
     *
     * 
     * \htmlonly
     * The list of all (known) service points.
     * \endhtmlonly
     *
     * \return The value of exported property \c KnownServicePoints.
     */
    Tp::ServicePointInfoList KnownServicePoints() const;

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c ServicePointsChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void servicePointsChanged(const Tp::ServicePointInfoList& servicePoints);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param servicePoints
     *     
     *     \htmlonly
     *     <p>The new value of
     *        \\\\endhtmlonly \\\\link requestPropertyKnownServicePoints() KnownServicePoints \\\\endlink \\\\htmlonly .</p>
     *     \endhtmlonly
     */
    void ServicePointsChanged(const Tp::ServicePointInfoList& servicePoints);
};

/**
 * \class ConnectionInterfaceSimplePresenceAdaptor
 * \headerfile TelepathyQt/_gen/svc-connection.h <TelepathyQt/_gen/svc-connection.h>
 * \ingroup serviceconn
 *
 * Adaptor class providing a 1:1 mapping of the D-Bus interface "org.freedesktop.Telepathy.Connection.Interface.SimplePresence".
 */
class TP_QT_EXPORT ConnectionInterfaceSimplePresenceAdaptor : public Tp::AbstractAdaptor
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.freedesktop.Telepathy.Connection.Interface.SimplePresence")
    Q_CLASSINFO("D-Bus Introspection", ""
"  <interface name=\"org.freedesktop.Telepathy.Connection.Interface.SimplePresence\">\n"
"    <property access=\"read\" type=\"a{s(ubb)}\" name=\"Statuses\">\n"
"      <annotation value=\"Tp::SimpleStatusSpecMap\" name=\"com.trolltech.QtDBus.QtTypeName\"/>\n"
"    </property>\n"
"    <property access=\"read\" type=\"u\" name=\"MaximumStatusMessageLength\"/>\n"
"    <method name=\"SetPresence\">\n"
"      <arg direction=\"in\" type=\"s\" name=\"status\"/>\n"
"      <arg direction=\"in\" type=\"s\" name=\"statusMessage\"/>\n"
"    </method>\n"
"    <method name=\"GetPresences\">\n"
"      <arg direction=\"in\" type=\"au\" name=\"contacts\"/>\n"
"      <arg direction=\"out\" type=\"a{u(uss)}\" name=\"presence\">\n"
"        <annotation value=\"Tp::SimpleContactPresences\" name=\"com.trolltech.QtDBus.QtTypeName.Out0\"/>\n"
"      </arg>\n"
"    </method>\n"
"    <signal name=\"PresencesChanged\">\n"
"      <arg type=\"a{u(uss)}\" name=\"presence\">\n"
"        <annotation value=\"Tp::SimpleContactPresences\" name=\"com.trolltech.QtDBus.QtTypeName.In0\"/>\n"
"      </arg>\n"
"    </signal>\n"
"  </interface>\n"
"")
    Q_PROPERTY(Tp::SimpleStatusSpecMap Statuses READ Statuses )
    Q_PROPERTY(uint MaximumStatusMessageLength READ MaximumStatusMessageLength )

public:
    ConnectionInterfaceSimplePresenceAdaptor(const QDBusConnection& dbusConnection, QObject* adaptee, QObject* parent);
    virtual ~ConnectionInterfaceSimplePresenceAdaptor();

    typedef Tp::MethodInvocationContextPtr<  > SetPresenceContextPtr;
    typedef Tp::MethodInvocationContextPtr< Tp::SimpleContactPresences > GetPresencesContextPtr;

public: // PROPERTIES
    /**
     * Return the value of the exported D-Bus object property \c Statuses of type \c Tp::SimpleStatusSpecMap.
     *
     * Adaptees should export this property as a Qt property named
     * 'statuses' with type Tp::SimpleStatusSpecMap.
     *
     * 
     * \htmlonly
     * <p>A dictionary where the keys are the presence statuses that are
     *   available on this connection, and the values are the corresponding
     *   presence types.</p>
     * 
     * <p>While the connection is in the DISCONNECTED state, it contains
     *   the set of presence statuses allowed to be set before connecting.
     *   The connection manager will attempt to set the appropriate status
     *   when the connection becomes connected, but cannot necessarily
     *   guarantee it. The available statuses cannot change until the
     *   connection status changes, so there is no change notification.</p>
     * 
     * <p>While the connection is in the CONNECTED state, this property
     *   contains the set of presence statuses which are actually available
     *   on this protocol. This set is constant for the remaining lifetime
     *   of the connection, so again, there is no change notification.</p>
     * 
     * <p>While the connection is in the CONNECTING state, the value of
     *   this property is undefined and SHOULD NOT be used. It can change
     *   at any time without notification (in particular, any cached values
     *   from when the connection was in the DISCONNECTED or CONNECTING
     *   state MUST NOT be assumed to still be correct when the state has
     *   become CONNECTED).</p>
     * 
     * <p>This property MUST include the special statuses "unknown" and
     *   "error" if and only if the connection manager can emit them
     *   as a contact's status.</p>
     * 
     * <div class="rationale">
     *   For instance, connection managers for local-xmpp (XEP-0174) would
     *   omit "unknown" since there is no such concept.
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c Statuses.
     */
    Tp::SimpleStatusSpecMap Statuses() const;
    /**
     * Return the value of the exported D-Bus object property \c MaximumStatusMessageLength of type \c uint.
     *
     * Adaptees should export this property as a Qt property named
     * 'maximumStatusMessageLength' with type uint.
     *
     * 
     * \htmlonly
     * <p>The maximum length in characters for any individual status
     *   message, or 0 if there is no limit.</p>
     * 
     * <p>While the connection is in the DISCONNECTED state, this property will
     *   be 0. The connection manager will attempt to set the appropriate value
     *   when the connection becomes connected, but cannot necessarily
     *   guarantee it. The maximum length cannot change until the
     *   connection status changes, so there is no change notification.</p>
     * 
     * <p>While the connection is in the CONNECTED state, this property
     *   contains the maximum length in characters for any individual status
     *   message which is actually allowed on this protocol.
     *   This value is constant for the remaining lifetime
     *   of the connection, so again, there is no change notification.</p>
     * 
     * <p>While the connection is in the CONNECTING state, the value of
     *   this property is undefined and SHOULD NOT be used. It can change
     *   at any time without notification (in particular, any cached values
     *   from when the connection was in the DISCONNECTED or CONNECTING
     *   state MUST NOT be assumed to still be correct when the state has
     *   become CONNECTED).</p>
     * 
     * <p>If a message passed to  \endhtmlonly SetPresence() \htmlonly  is
     *   longer than allowed by this property, the connection manager MUST
     *   truncate the supplied message; when emitting
     *    \endhtmlonly PresencesChanged() \htmlonly , the truncated version
     *   of the message MUST be used.</p>
     * 
     * <div class="rationale">
     *   <p>Some XMPP servers, like Google Talk, define a maximum length for
     *   status messages. Whether the user's server is one of
     *   these cannot be detected until quite late in the connection
     *   process.</p>
     * </div>
     * \endhtmlonly
     *
     * \return The value of exported property \c MaximumStatusMessageLength.
     */
    uint MaximumStatusMessageLength() const;

public Q_SLOTS: // METHODS
    /**
     * Begins a call to the exported D-Bus method \c SetPresence on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void setPresence(const QString& status, const QString& statusMessage, const Tp::Service::ConnectionInterfaceSimplePresenceAdaptor::SetPresenceContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * \htmlonly
     * <p>Request that the presence status and status message are published for
     *   the connection.  Changes will be indicated by
     *    \endhtmlonly PresencesChanged() \htmlonly 
     *   signals being emitted.</p>
     * 
     * <p>This method may be called on a newly-created connection while it
     *   is still in the DISCONNECTED state, to request that when the
     *   connection connects, it will do so with the selected status.</p>
     * 
     * <p>In DISCONNECTED state the
     *    \endhtmlonly \link requestPropertyStatuses() Statuses \endlink \htmlonly 
     *   property will indicate which statuses are allowed to be set
     *   while DISCONNECTED (none, if the Connection Manager doesn't allow
     *   this). This value MUST NOT be cached, as the set of allowed
     *   presences might change upon connecting.</p>
     * \endhtmlonly
     *
     * \param status
     *     
     *     \htmlonly
     *     <p>The string identifier of the desired status. Possible status
     *       identifiers are defined in the
     *        \\\\endhtmlonly \\\\link requestPropertyStatuses() Statuses \\\\endlink \\\\htmlonly  property.</p>
     *     
     *     <p>Clients MUST NOT set a status whose string value they do not
     *       recognise, even if its presence type in Statuses
     *       matches what the user requested.</p>
     *     
     *     <div class="rationale">
     *       <p>Suppose a protocol has statuses that include 'phone' (of type
     *         BUSY) and 'in-a-meeting' (of type BUSY), but there is no
     *         generic 'busy' status.</p>
     *     
     *       <p>If the user requests "Busy" status from a menu, a
     *         client author might be tempted to pick an arbitrary status
     *         that has type BUSY. However, on this protocol, neither of
     *         the choices would be appropriate, and incorrect information
     *         about the user would be conveyed.</p>
     *     </div>
     *     
     *     <p>Statuses whose <tp:type>Connection_Presence_Type</tp:type>
     *       is Offline, Error or Unknown MUST NOT be passed to this
     *       function. Connection managers SHOULD reject these statuses.</p>
     *     
     *     <div class="rationale">
     *       <p>To go offline, call  \\\\endhtmlonly ConnectionInterface::Disconnect() \\\\htmlonly 
     *       instead. The "error" and "unknown" statuses make no sense.</p>
     *     </div>
     *     \endhtmlonly
     * \param statusMessage
     *     
     *     The status message associated with the current status.
     */
    void SetPresence(const QString& status, const QString& statusMessage, const QDBusMessage& dbusMessage);
    /**
     * Begins a call to the exported D-Bus method \c GetPresences on this object.
     *
     * Adaptees should export this method as a Qt slot with the following signature:
     * void getPresences(const Tp::UIntList& contacts, const Tp::Service::ConnectionInterfaceSimplePresenceAdaptor::GetPresencesContextPtr &context);
     *
     * Implementations should call MethodInvocationContext::setFinished (or setFinishedWithError
     * accordingly) on the received \a context object once the method has finished processing.
     *
     * 
     * Get presence previously emitted by PresencesChanged for the given 
     * contacts. Data is returned in the same structure as the 
     * PresencesChanged signal; no additional network requests are made.
     *
     * \param contacts
     *     
     *     An array of the contacts whose presence should be obtained.
     * \return
     *     
     *     \htmlonly
     *     <p>Presence information in the same format as for the
     *        \\\\endhtmlonly PresencesChanged() \\\\htmlonly  signal.
     *       The returned mapping MUST include an entry for each contact
     *       in the method's argument.</p>
     *     
     *     <p>The definition of the connection presence types Unknown
     *       and Offline means that if a connection manager will return
     *       Unknown for contacts not on the subscribe list, it MUST delay
     *       the reply to this method call until it has found out which
     *       contacts are, in fact, on the subscribe list.</p>
     *     \endhtmlonly
     */
    Tp::SimpleContactPresences GetPresences(const Tp::UIntList& contacts, const QDBusMessage& dbusMessage);

Q_SIGNALS: // SIGNALS
    /**
     * Represents the exported D-Bus signal \c PresencesChanged on this object.
     *
     * Adaptees should export this signal as a Qt signal with the following signature:
     * void presencesChanged(const Tp::SimpleContactPresences& presence);
     *
     * The adaptee signal will be automatically relayed as a D-Bus signal once emitted.
     *
     * \param presence
     *     
     *     A dictionary of contact handles mapped to the status, presence type 
     *     and status message.
     */
    void PresencesChanged(const Tp::SimpleContactPresences& presence);
};

}
}