/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

#ifndef VATOMIC_CORE_U32_H
#define VATOMIC_CORE_U32_H
/*******************************************************************************
 * @file core_u32.h
 * @brief Atomic functions for vatomic32_t variables.
 *
 * This file declares and documents the core atomic functions operating on
 * vatomic32_t variables.
 *
 * Please do not include this file directly, instead use:
 * ```c
 * #include <vsync/atomic/core.h>
 * ```
 ******************************************************************************/
/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */
#ifndef VATOMIC_CORE_H
    #error "File included directly. Include <vsync/atomic/core.h> instead!"
#endif

/**
 * Initializes the atomic variable a with value v.
 *
 * The initialization is equivalent to an vatomic32_write().
 *
 * @param a atomic variable
 * @param v initial value
 * @memord seq_cst
 */
static inline void vatomic32_init(vatomic32_t *a, vuint32_t v);

/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_read(const vatomic32_t *a);
/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord acquire
 */
static inline vuint32_t vatomic32_read_acq(const vatomic32_t *a);
/**
 * Returns the value of the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @return current value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_read_rlx(const vatomic32_t *a);

/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord seq_cst
 */
static inline void vatomic32_write(vatomic32_t *a, vuint32_t v);
/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord release
 */
static inline void vatomic32_write_rel(vatomic32_t *a, vuint32_t v);
/**
 * Writes value v in the atomic variable pointed by a.
 *
 * @param a atomic variable
 * @param v new value
 * @memord relaxed
 */
static inline void vatomic32_write_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_xchg(vatomic32_t *a, vuint32_t v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord acquire
 */
static inline vuint32_t vatomic32_xchg_acq(vatomic32_t *a, vuint32_t v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord release
 */
static inline vuint32_t vatomic32_xchg_rel(vatomic32_t *a, vuint32_t v);
/**
 * Writes v in a and returns old value.
 *
 * @param a atomic variable
 * @param v new value
 * @return old value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_xchg_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vuint32_t vatomic32_cmpxchg(vatomic32_t *a, vuint32_t e,
                                          vuint32_t v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vuint32_t vatomic32_cmpxchg_acq(vatomic32_t *a, vuint32_t e,
                                              vuint32_t v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vuint32_t vatomic32_cmpxchg_rel(vatomic32_t *a, vuint32_t e,
                                              vuint32_t v);
/**
 * Writes value v in a if e is the current value.
 *
 * @param a atomic variable
 * @param e expected value
 * @param v new value
 * @return old value
 */
static inline vuint32_t vatomic32_cmpxchg_rlx(vatomic32_t *a, vuint32_t e,
                                              vuint32_t v);

/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_get_max(vatomic32_t *a, vuint32_t v);
/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord acquire
 */
static inline vuint32_t vatomic32_get_max_acq(vatomic32_t *a, vuint32_t v);
/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord release
 */
static inline vuint32_t vatomic32_get_max_rel(vatomic32_t *a, vuint32_t v);
/**
 * Writes v to a if v is greater than *a and returns the old value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return old max value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_get_max_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_max_get(vatomic32_t *a, vuint32_t v);
/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord acquire
 */
static inline vuint32_t vatomic32_max_get_acq(vatomic32_t *a, vuint32_t v);
/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord release
 */
static inline vuint32_t vatomic32_max_get_rel(vatomic32_t *a, vuint32_t v);
/**
 * Writes v to a if v is greater than *a and returns the new value.
 *
 * @param a atomic variable
 * @param v potential max value
 * @return new max value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_max_get_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Writes v to a if v is greater than *a.
 *
 * @param a atomic variable
 * @param v potential max value
 * @memord seq_cst
 */
static inline void vatomic32_max(vatomic32_t *a, vuint32_t v);
/**
 * Writes v to a if v is greater than *a.
 *
 * @param a atomic variable
 * @param v potential max value
 * @memord release
 */
static inline void vatomic32_max_rel(vatomic32_t *a, vuint32_t v);
/**
 * Writes v to a if v is greater than *a.
 *
 * @param a atomic variable
 * @param v potential max value
 * @memord relaxed
 */
static inline void vatomic32_max_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_get_and(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord acquire
 */
static inline vuint32_t vatomic32_get_and_acq(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord release
 */
static inline vuint32_t vatomic32_get_and_rel(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise and to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_get_and_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_and_get(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord acquire
 */
static inline vuint32_t vatomic32_and_get_acq(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord release
 */
static inline vuint32_t vatomic32_and_get_rel(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise and operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_and_get_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Applies bitwise and operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord seq_cst
 */
static inline void vatomic32_and(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise and operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord release
 */
static inline void vatomic32_and_rel(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise and operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord relaxed
 */
static inline void vatomic32_and_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_get_or(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord acquire
 */
static inline vuint32_t vatomic32_get_or_acq(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord release
 */
static inline vuint32_t vatomic32_get_or_rel(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_get_or_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_or_get(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord acquire
 */
static inline vuint32_t vatomic32_or_get_acq(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord release
 */
static inline vuint32_t vatomic32_or_get_rel(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise or operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_or_get_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Applies bitwise or operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord seq_cst
 */
static inline void vatomic32_or(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise or operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord release
 */
static inline void vatomic32_or_rel(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise or operation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord relaxed
 */
static inline void vatomic32_or_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_get_xor(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord acquire
 */
static inline vuint32_t vatomic32_get_xor_acq(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord release
 */
static inline vuint32_t vatomic32_get_xor_rel(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the old value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return old value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_get_xor_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_xor_get(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord acquire
 */
static inline vuint32_t vatomic32_xor_get_acq(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord release
 */
static inline vuint32_t vatomic32_xor_get_rel(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise xor operation with v to the value of a and returns
 * the new value.
 *
 * @param a atomic variable
 * @param v mask value
 * @return new value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_xor_get_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Applies bitwise xor opeation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord seq_cst
 */
static inline void vatomic32_xor(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise xor opeation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord release
 */
static inline void vatomic32_xor_rel(vatomic32_t *a, vuint32_t v);
/**
 * Applies bitwise xor opeation with v to the value of a.
 *
 * @param a atomic variable
 * @param v mask value
 * @memord relaxed
 */
static inline void vatomic32_xor_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_get_add(vatomic32_t *a, vuint32_t v);
/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord acquire
 */
static inline vuint32_t vatomic32_get_add_acq(vatomic32_t *a, vuint32_t v);
/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord release
 */
static inline vuint32_t vatomic32_get_add_rel(vatomic32_t *a, vuint32_t v);
/**
 * Adds v to the value of a and returns the old value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return old value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_get_add_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_add_get(vatomic32_t *a, vuint32_t v);
/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord acquire
 */
static inline vuint32_t vatomic32_add_get_acq(vatomic32_t *a, vuint32_t v);
/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord release
 */
static inline vuint32_t vatomic32_add_get_rel(vatomic32_t *a, vuint32_t v);
/**
 * Adds v to the value of a and returns the new value.
 *
 * @param a atomic variable
 * @param v addend value
 * @return new value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_add_get_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Adds v to the value of a.
 *
 * @param a atomic variable
 * @param v addend value
 * @memord seq_cst
 */
static inline void vatomic32_add(vatomic32_t *a, vuint32_t v);
/**
 * Adds v to the value of a.
 *
 * @param a atomic variable
 * @param v addend value
 * @memord release
 */
static inline void vatomic32_add_rel(vatomic32_t *a, vuint32_t v);
/**
 * Adds v to the value of a.
 *
 * @param a atomic variable
 * @param v addend value
 * @memord relaxed
 */
static inline void vatomic32_add_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_get_inc(vatomic32_t *a);
/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord acquire
 */
static inline vuint32_t vatomic32_get_inc_acq(vatomic32_t *a);
/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord release
 */
static inline vuint32_t vatomic32_get_inc_rel(vatomic32_t *a);
/**
 * Increments the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_get_inc_rlx(vatomic32_t *a);

/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_inc_get(vatomic32_t *a);
/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord acquire
 */
static inline vuint32_t vatomic32_inc_get_acq(vatomic32_t *a);
/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord release
 */
static inline vuint32_t vatomic32_inc_get_rel(vatomic32_t *a);
/**
 * Increments the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return  new value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_inc_get_rlx(vatomic32_t *a);

/**
 * Increments the value of a.
 *
 * @param a atomic variable
 * @memord seq_cst
 */
static inline void vatomic32_inc(vatomic32_t *a);
/**
 * Increments the value of a.
 *
 * @param a atomic variable
 * @memord release
 */
static inline void vatomic32_inc_rel(vatomic32_t *a);
/**
 * Increments the value of a.
 *
 * @param a atomic variable
 * @memord relaxed
 */
static inline void vatomic32_inc_rlx(vatomic32_t *a);

/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_get_sub(vatomic32_t *a, vuint32_t v);
/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord acquire
 */
static inline vuint32_t vatomic32_get_sub_acq(vatomic32_t *a, vuint32_t v);
/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord release
 */
static inline vuint32_t vatomic32_get_sub_rel(vatomic32_t *a, vuint32_t v);
/**
 * Subtracts v from a and returns the old value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return old value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_get_sub_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_sub_get(vatomic32_t *a, vuint32_t v);
/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord acquire
 */
static inline vuint32_t vatomic32_sub_get_acq(vatomic32_t *a, vuint32_t v);
/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord release
 */
static inline vuint32_t vatomic32_sub_get_rel(vatomic32_t *a, vuint32_t v);
/**
 * Subtracts v from a and returns the new value.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @return new value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_sub_get_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Subtracts v from a.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @memord seq_cst
 */
static inline void vatomic32_sub(vatomic32_t *a, vuint32_t v);
/**
 * Subtracts v from a.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @memord release
 */
static inline void vatomic32_sub_rel(vatomic32_t *a, vuint32_t v);
/**
 * Subtracts v from a.
 *
 * @param a atomic variable
 * @param v subtrahend value
 * @memord relaxed
 */
static inline void vatomic32_sub_rlx(vatomic32_t *a, vuint32_t v);

/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_get_dec(vatomic32_t *a);
/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord acquire
 */
static inline vuint32_t vatomic32_get_dec_acq(vatomic32_t *a);
/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord release
 */
static inline vuint32_t vatomic32_get_dec_rel(vatomic32_t *a);
/**
 * Decrements the value of a and returns the old value.
 *
 * @param a atomic variable
 * @return old value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_get_dec_rlx(vatomic32_t *a);

/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord seq_cst
 */
static inline vuint32_t vatomic32_dec_get(vatomic32_t *a);
/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord acquire
 */
static inline vuint32_t vatomic32_dec_get_acq(vatomic32_t *a);
/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord release
 */
static inline vuint32_t vatomic32_dec_get_rel(vatomic32_t *a);
/**
 * Decrements the value of a and returns the new value.
 *
 * @param a atomic variable
 * @return new value
 * @memord relaxed
 */
static inline vuint32_t vatomic32_dec_get_rlx(vatomic32_t *a);

/**
 * Decrements the value of a.
 *
 * @param a atomic variable
 * @memord seq_cst
 */
static inline void vatomic32_dec(vatomic32_t *a);
/**
 * Decrements the value of a.
 *
 * @param a atomic variable
 * @memord release
 */
static inline void vatomic32_dec_rel(vatomic32_t *a);
/**
 * Decrements the value of a.
 *
 * @param a atomic variable
 * @memord relaxed
 */
static inline void vatomic32_dec_rlx(vatomic32_t *a);

#endif
