/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

#ifndef VATOMIC_ARM32_V8_H
#define VATOMIC_ARM32_V8_H
/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */

/*******************************************************************************
 * options
 ******************************************************************************/
#if !defined(VATOMIC_ARM32_V8)
    #error "include <vsync/atomic.h> and don't include this file directly"
#endif

#if !defined(VATOMIC_DISABLE_POLITE_AWAIT)
    #define vatomic_cpu_pause() __asm__ volatile("yield" ::: "memory")
#endif

#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
    #define VATOMIC_LI_ENDIAN
#endif
/******************************************************************************
 * vatomic_fence
 ******************************************************************************/
#ifndef VATOMIC_FENCE
    #define VATOMIC_FENCE
static inline void
vatomic_fence(void)
{
    __asm__ volatile("dmb ish" ::: "memory");
}
#endif
/******************************************************************************
 * vatomic_fence_rel
 ******************************************************************************/
#ifndef VATOMIC_FENCE_REL
    #define VATOMIC_FENCE_REL
static inline void
vatomic_fence_rel(void)
{
    __asm__ volatile("dmb ish" ::: "memory");
}
#endif
/******************************************************************************
 * vatomic_fence_acq
 ******************************************************************************/
#ifndef VATOMIC_FENCE_ACQ
    #define VATOMIC_FENCE_ACQ
static inline void
vatomic_fence_acq(void)
{
    __asm__ volatile("dmb ishld" ::: "memory");
}
#endif
/******************************************************************************
 * vatomic_fence_rlx
 ******************************************************************************/
#ifndef VATOMIC_FENCE_RLX
    #define VATOMIC_FENCE_RLX
static inline void
vatomic_fence_rlx(void)
{
    __asm__ volatile(V_FENCE_RLX_INSTRUCTION ::: "memory");
}
#endif
/******************************************************************************
 * vatomic32_read
 ******************************************************************************/
#ifndef VATOMIC32_READ
    #define VATOMIC32_READ
static inline vuint32_t
vatomic32_read(const vatomic32_t *a)
{
    vuint32_t val;
    __asm__ volatile("lda %[v], %[a] \n"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomic32_read_acq
 ******************************************************************************/
#ifndef VATOMIC32_READ_ACQ
    #define VATOMIC32_READ_ACQ
static inline vuint32_t
vatomic32_read_acq(const vatomic32_t *a)
{
    vuint32_t val;
    __asm__ volatile("lda %[v], %[a] \n"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomic32_read_rlx
 ******************************************************************************/
#ifndef VATOMIC32_READ_RLX
    #define VATOMIC32_READ_RLX
static inline vuint32_t
vatomic32_read_rlx(const vatomic32_t *a)
{
    vuint32_t val;
    __asm__ volatile("ldr %[v], %[a] \n"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomic64_read
 ******************************************************************************/
#ifndef VATOMIC64_READ
    #define VATOMIC64_READ
static inline vuint64_t
vatomic64_read(const vatomic64_t *a)
{
    vuint64_t val;
    __asm__ volatile("ldaexd %[v], %[a] \n"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomic64_read_acq
 ******************************************************************************/
#ifndef VATOMIC64_READ_ACQ
    #define VATOMIC64_READ_ACQ
static inline vuint64_t
vatomic64_read_acq(const vatomic64_t *a)
{
    vuint64_t val;
    __asm__ volatile("ldaexd %[v], %[a] \n"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomic64_read_rlx
 ******************************************************************************/
#ifndef VATOMIC64_READ_RLX
    #define VATOMIC64_READ_RLX
static inline vuint64_t
vatomic64_read_rlx(const vatomic64_t *a)
{
    vuint64_t val;
    __asm__ volatile("ldrexd %[v], %[a] \n"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomicptr_read
 ******************************************************************************/
#ifndef VATOMICPTR_READ
    #define VATOMICPTR_READ
static inline void *
vatomicptr_read(const vatomicptr_t *a)
{
    void *val;
    __asm__ volatile("lda %[v], %[a] \n"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomicptr_read_acq
 ******************************************************************************/
#ifndef VATOMICPTR_READ_ACQ
    #define VATOMICPTR_READ_ACQ
static inline void *
vatomicptr_read_acq(const vatomicptr_t *a)
{
    void *val;
    __asm__ volatile("lda %[v], %[a] \n"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomicptr_read_rlx
 ******************************************************************************/
#ifndef VATOMICPTR_READ_RLX
    #define VATOMICPTR_READ_RLX
static inline void *
vatomicptr_read_rlx(const vatomicptr_t *a)
{
    void *val;
    __asm__ volatile("ldr %[v], %[a] \n"
                     : [v] "=&r"(val)
                     : [a] "Q"(a->_v)
                     : "memory");
    return val;
}
#endif
/******************************************************************************
 * vatomic32_write
 ******************************************************************************/
#ifndef VATOMIC32_WRITE
    #define VATOMIC32_WRITE
static inline void
vatomic32_write(vatomic32_t *a, vuint32_t v)
{
    __asm__ volatile("stl %[v], %[a]\n"
                     :
                     : [v] "r"(v), [a] "Q"(a->_v)
                     : "memory");
}
#endif
/******************************************************************************
 * vatomic32_write_rel
 ******************************************************************************/
#ifndef VATOMIC32_WRITE_REL
    #define VATOMIC32_WRITE_REL
static inline void
vatomic32_write_rel(vatomic32_t *a, vuint32_t v)
{
    __asm__ volatile("stl %[v], %[a]\n"
                     :
                     : [v] "r"(v), [a] "Q"(a->_v)
                     : "memory");
}
#endif
/******************************************************************************
 * vatomic32_write_rlx
 ******************************************************************************/
#ifndef VATOMIC32_WRITE_RLX
    #define VATOMIC32_WRITE_RLX
static inline void
vatomic32_write_rlx(vatomic32_t *a, vuint32_t v)
{
    __asm__ volatile("str %[v], %[a]\n"
                     :
                     : [v] "r"(v), [a] "Q"(a->_v)
                     : "memory");
}
#endif
/******************************************************************************
 * vatomicptr_write
 ******************************************************************************/
#ifndef VATOMICPTR_WRITE
    #define VATOMICPTR_WRITE
static inline void
vatomicptr_write(vatomicptr_t *a, void *v)
{
    __asm__ volatile("stl %[v], %[a]\n"
                     :
                     : [v] "r"(v), [a] "Q"(a->_v)
                     : "memory");
}
#endif
/******************************************************************************
 * vatomicptr_write_rel
 ******************************************************************************/
#ifndef VATOMICPTR_WRITE_REL
    #define VATOMICPTR_WRITE_REL
static inline void
vatomicptr_write_rel(vatomicptr_t *a, void *v)
{
    __asm__ volatile("stl %[v], %[a]\n"
                     :
                     : [v] "r"(v), [a] "Q"(a->_v)
                     : "memory");
}
#endif
/******************************************************************************
 * vatomicptr_write_rlx
 ******************************************************************************/
#ifndef VATOMICPTR_WRITE_RLX
    #define VATOMICPTR_WRITE_RLX
static inline void
vatomicptr_write_rlx(vatomicptr_t *a, void *v)
{
    __asm__ volatile("str %[v], %[a]\n"
                     :
                     : [v] "r"(v), [a] "Q"(a->_v)
                     : "memory");
}
#endif
/******************************************************************************
 * vatomic64_write
 ******************************************************************************/
#ifndef VATOMIC64_WRITE
    #define VATOMIC64_WRITE
static inline void
vatomic64_write(vatomic64_t *a, vuint64_t v)
{
    vuint64_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaexd %[oldv], %H[oldv], %[a]\n"
        "stlexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_write_rel
 ******************************************************************************/
#ifndef VATOMIC64_WRITE_REL
    #define VATOMIC64_WRITE_REL
static inline void
vatomic64_write_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrexd %[oldv], %H[oldv], %[a]\n"
        "stlexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_write_rlx
 ******************************************************************************/
#ifndef VATOMIC64_WRITE_RLX
    #define VATOMIC64_WRITE_RLX
static inline void
vatomic64_write_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrexd %[oldv], %H[oldv], %[a]\n"
        "strexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_xchg
 ******************************************************************************/
#ifndef VATOMIC32_XCHG
    #define VATOMIC32_XCHG
static inline vuint32_t
vatomic32_xchg(vatomic32_t *a, vuint32_t v)
{
    vuint32_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomic32_xchg_acq
 ******************************************************************************/
#ifndef VATOMIC32_XCHG_ACQ
    #define VATOMIC32_XCHG_ACQ
static inline vuint32_t
vatomic32_xchg_acq(vatomic32_t *a, vuint32_t v)
{
    vuint32_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomic32_xchg_rel
 ******************************************************************************/
#ifndef VATOMIC32_XCHG_REL
    #define VATOMIC32_XCHG_REL
static inline vuint32_t
vatomic32_xchg_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomic32_xchg_rlx
 ******************************************************************************/
#ifndef VATOMIC32_XCHG_RLX
    #define VATOMIC32_XCHG_RLX
static inline vuint32_t
vatomic32_xchg_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomicptr_xchg
 ******************************************************************************/
#ifndef VATOMICPTR_XCHG
    #define VATOMICPTR_XCHG
static inline void *
vatomicptr_xchg(vatomicptr_t *a, void *v)
{
    void *old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomicptr_xchg_acq
 ******************************************************************************/
#ifndef VATOMICPTR_XCHG_ACQ
    #define VATOMICPTR_XCHG_ACQ
static inline void *
vatomicptr_xchg_acq(vatomicptr_t *a, void *v)
{
    void *old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomicptr_xchg_rel
 ******************************************************************************/
#ifndef VATOMICPTR_XCHG_REL
    #define VATOMICPTR_XCHG_REL
static inline void *
vatomicptr_xchg_rel(vatomicptr_t *a, void *v)
{
    void *old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomicptr_xchg_rlx
 ******************************************************************************/
#ifndef VATOMICPTR_XCHG_RLX
    #define VATOMICPTR_XCHG_RLX
static inline void *
vatomicptr_xchg_rlx(vatomicptr_t *a, void *v)
{
    void *old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomic64_xchg
 ******************************************************************************/
#ifndef VATOMIC64_XCHG
    #define VATOMIC64_XCHG
static inline vuint64_t
vatomic64_xchg(vatomic64_t *a, vuint64_t v)
{
    vuint64_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaexd %[oldv], %H[oldv], %[a]\n"
        "stlexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomic64_xchg_acq
 ******************************************************************************/
#ifndef VATOMIC64_XCHG_ACQ
    #define VATOMIC64_XCHG_ACQ
static inline vuint64_t
vatomic64_xchg_acq(vatomic64_t *a, vuint64_t v)
{
    vuint64_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaexd %[oldv], %H[oldv], %[a]\n"
        "strexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomic64_xchg_rel
 ******************************************************************************/
#ifndef VATOMIC64_XCHG_REL
    #define VATOMIC64_XCHG_REL
static inline vuint64_t
vatomic64_xchg_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrexd %[oldv], %H[oldv], %[a]\n"
        "stlexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomic64_xchg_rlx
 ******************************************************************************/
#ifndef VATOMIC64_XCHG_RLX
    #define VATOMIC64_XCHG_RLX
static inline vuint64_t
vatomic64_xchg_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrexd %[oldv], %H[oldv], %[a]\n"
        "strexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomic32_cmpxchg
 ******************************************************************************/
#ifndef VATOMIC32_CMPXCHG
    #define VATOMIC32_CMPXCHG
static inline vuint32_t
vatomic32_cmpxchg(vatomic32_t *a, vuint32_t e, vuint32_t v)
{
    vuint32_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "cmp %[oldv], %[expv]\n"
        "bne 2f\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        "2:\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [expv] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomic32_cmpxchg_acq
 ******************************************************************************/
#ifndef VATOMIC32_CMPXCHG_ACQ
    #define VATOMIC32_CMPXCHG_ACQ
static inline vuint32_t
vatomic32_cmpxchg_acq(vatomic32_t *a, vuint32_t e, vuint32_t v)
{
    vuint32_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "cmp %[oldv], %[expv]\n"
        "bne 2f\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        "2:\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [expv] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomic32_cmpxchg_rel
 ******************************************************************************/
#ifndef VATOMIC32_CMPXCHG_REL
    #define VATOMIC32_CMPXCHG_REL
static inline vuint32_t
vatomic32_cmpxchg_rel(vatomic32_t *a, vuint32_t e, vuint32_t v)
{
    vuint32_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "cmp %[oldv], %[expv]\n"
        "bne 2f\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        "2:\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [expv] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomic32_cmpxchg_rlx
 ******************************************************************************/
#ifndef VATOMIC32_CMPXCHG_RLX
    #define VATOMIC32_CMPXCHG_RLX
static inline vuint32_t
vatomic32_cmpxchg_rlx(vatomic32_t *a, vuint32_t e, vuint32_t v)
{
    vuint32_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "cmp %[oldv], %[expv]\n"
        "bne 2f\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        "2:\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [expv] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomicptr_cmpxchg
 ******************************************************************************/
#ifndef VATOMICPTR_CMPXCHG
    #define VATOMICPTR_CMPXCHG
static inline void *
vatomicptr_cmpxchg(vatomicptr_t *a, void *e, void *v)
{
    void *old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "cmp %[oldv], %[expv]\n"
        "bne 2f\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        "2:\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [expv] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomicptr_cmpxchg_acq
 ******************************************************************************/
#ifndef VATOMICPTR_CMPXCHG_ACQ
    #define VATOMICPTR_CMPXCHG_ACQ
static inline void *
vatomicptr_cmpxchg_acq(vatomicptr_t *a, void *e, void *v)
{
    void *old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "cmp %[oldv], %[expv]\n"
        "bne 2f\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        "2:\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [expv] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomicptr_cmpxchg_rel
 ******************************************************************************/
#ifndef VATOMICPTR_CMPXCHG_REL
    #define VATOMICPTR_CMPXCHG_REL
static inline void *
vatomicptr_cmpxchg_rel(vatomicptr_t *a, void *e, void *v)
{
    void *old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "cmp %[oldv], %[expv]\n"
        "bne 2f\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        "2:\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [expv] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomicptr_cmpxchg_rlx
 ******************************************************************************/
#ifndef VATOMICPTR_CMPXCHG_RLX
    #define VATOMICPTR_CMPXCHG_RLX
static inline void *
vatomicptr_cmpxchg_rlx(vatomicptr_t *a, void *e, void *v)
{
    void *old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "cmp %[oldv], %[expv]\n"
        "bne 2f\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        "2:\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [expv] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomic64_cmpxchg
 ******************************************************************************/
#ifndef VATOMIC64_CMPXCHG
    #define VATOMIC64_CMPXCHG
static inline vuint64_t
vatomic64_cmpxchg(vatomic64_t *a, vuint64_t e, vuint64_t v)
{
    vuint64_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaexd %[oldv], %H[oldv], %[a]\n"
        "cmp %H[oldv], %H[expv]\n"
        "cmpeq %[oldv], %[expv]\n"
        "bne 2f\n"
        "stlexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        "2:\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [expv] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomic64_cmpxchg_acq
 ******************************************************************************/
#ifndef VATOMIC64_CMPXCHG_ACQ
    #define VATOMIC64_CMPXCHG_ACQ
static inline vuint64_t
vatomic64_cmpxchg_acq(vatomic64_t *a, vuint64_t e, vuint64_t v)
{
    vuint64_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaexd %[oldv], %H[oldv], %[a]\n"
        "cmp %H[oldv], %H[expv]\n"
        "cmpeq %[oldv], %[expv]\n"
        "bne 2f\n"
        "strexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        "2:\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [expv] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomic64_cmpxchg_rel
 ******************************************************************************/
#ifndef VATOMIC64_CMPXCHG_REL
    #define VATOMIC64_CMPXCHG_REL
static inline vuint64_t
vatomic64_cmpxchg_rel(vatomic64_t *a, vuint64_t e, vuint64_t v)
{
    vuint64_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrexd %[oldv], %H[oldv], %[a]\n"
        "cmp %H[oldv], %H[expv]\n"
        "cmpeq %[oldv], %[expv]\n"
        "bne 2f\n"
        "stlexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        "2:\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [expv] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomic64_cmpxchg_rlx
 ******************************************************************************/
#ifndef VATOMIC64_CMPXCHG_RLX
    #define VATOMIC64_CMPXCHG_RLX
static inline vuint64_t
vatomic64_cmpxchg_rlx(vatomic64_t *a, vuint64_t e, vuint64_t v)
{
    vuint64_t old;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrexd %[oldv], %H[oldv], %[a]\n"
        "cmp %H[oldv], %H[expv]\n"
        "cmpeq %[oldv], %[expv]\n"
        "bne 2f\n"
        "strexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        "2:\n"
        : [oldv] "=&r"(old), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [expv] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return old;
}
#endif
/******************************************************************************
 * vatomic32_get_and
 ******************************************************************************/
#ifndef VATOMIC32_GET_AND
    #define VATOMIC32_GET_AND
static inline vuint32_t
vatomic32_get_and(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "and %[newv], %[oldv], %[v]\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_or
 ******************************************************************************/
#ifndef VATOMIC32_GET_OR
    #define VATOMIC32_GET_OR
static inline vuint32_t
vatomic32_get_or(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "orr %[newv], %[oldv], %[v]\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_xor
 ******************************************************************************/
#ifndef VATOMIC32_GET_XOR
    #define VATOMIC32_GET_XOR
static inline vuint32_t
vatomic32_get_xor(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "eor %[newv], %[oldv], %[v]\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_add
 ******************************************************************************/
#ifndef VATOMIC32_GET_ADD
    #define VATOMIC32_GET_ADD
static inline vuint32_t
vatomic32_get_add(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "add %[newv], %[oldv], %[v]\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_sub
 ******************************************************************************/
#ifndef VATOMIC32_GET_SUB
    #define VATOMIC32_GET_SUB
static inline vuint32_t
vatomic32_get_sub(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "sub %[newv], %[oldv], %[v]\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_and_acq
 ******************************************************************************/
#ifndef VATOMIC32_GET_AND_ACQ
    #define VATOMIC32_GET_AND_ACQ
static inline vuint32_t
vatomic32_get_and_acq(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "and %[newv], %[oldv], %[v]\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_or_acq
 ******************************************************************************/
#ifndef VATOMIC32_GET_OR_ACQ
    #define VATOMIC32_GET_OR_ACQ
static inline vuint32_t
vatomic32_get_or_acq(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "orr %[newv], %[oldv], %[v]\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_xor_acq
 ******************************************************************************/
#ifndef VATOMIC32_GET_XOR_ACQ
    #define VATOMIC32_GET_XOR_ACQ
static inline vuint32_t
vatomic32_get_xor_acq(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "eor %[newv], %[oldv], %[v]\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_add_acq
 ******************************************************************************/
#ifndef VATOMIC32_GET_ADD_ACQ
    #define VATOMIC32_GET_ADD_ACQ
static inline vuint32_t
vatomic32_get_add_acq(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "add %[newv], %[oldv], %[v]\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_sub_acq
 ******************************************************************************/
#ifndef VATOMIC32_GET_SUB_ACQ
    #define VATOMIC32_GET_SUB_ACQ
static inline vuint32_t
vatomic32_get_sub_acq(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaex %[oldv], %[a]\n"
        "sub %[newv], %[oldv], %[v]\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_and_rel
 ******************************************************************************/
#ifndef VATOMIC32_GET_AND_REL
    #define VATOMIC32_GET_AND_REL
static inline vuint32_t
vatomic32_get_and_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "and %[newv], %[oldv], %[v]\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_or_rel
 ******************************************************************************/
#ifndef VATOMIC32_GET_OR_REL
    #define VATOMIC32_GET_OR_REL
static inline vuint32_t
vatomic32_get_or_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "orr %[newv], %[oldv], %[v]\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_xor_rel
 ******************************************************************************/
#ifndef VATOMIC32_GET_XOR_REL
    #define VATOMIC32_GET_XOR_REL
static inline vuint32_t
vatomic32_get_xor_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "eor %[newv], %[oldv], %[v]\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_add_rel
 ******************************************************************************/
#ifndef VATOMIC32_GET_ADD_REL
    #define VATOMIC32_GET_ADD_REL
static inline vuint32_t
vatomic32_get_add_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "add %[newv], %[oldv], %[v]\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_sub_rel
 ******************************************************************************/
#ifndef VATOMIC32_GET_SUB_REL
    #define VATOMIC32_GET_SUB_REL
static inline vuint32_t
vatomic32_get_sub_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "sub %[newv], %[oldv], %[v]\n"
        "stlex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_and_rlx
 ******************************************************************************/
#ifndef VATOMIC32_GET_AND_RLX
    #define VATOMIC32_GET_AND_RLX
static inline vuint32_t
vatomic32_get_and_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "and %[newv], %[oldv], %[v]\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_or_rlx
 ******************************************************************************/
#ifndef VATOMIC32_GET_OR_RLX
    #define VATOMIC32_GET_OR_RLX
static inline vuint32_t
vatomic32_get_or_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "orr %[newv], %[oldv], %[v]\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_xor_rlx
 ******************************************************************************/
#ifndef VATOMIC32_GET_XOR_RLX
    #define VATOMIC32_GET_XOR_RLX
static inline vuint32_t
vatomic32_get_xor_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "eor %[newv], %[oldv], %[v]\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_add_rlx
 ******************************************************************************/
#ifndef VATOMIC32_GET_ADD_RLX
    #define VATOMIC32_GET_ADD_RLX
static inline vuint32_t
vatomic32_get_add_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "add %[newv], %[oldv], %[v]\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_sub_rlx
 ******************************************************************************/
#ifndef VATOMIC32_GET_SUB_RLX
    #define VATOMIC32_GET_SUB_RLX
static inline vuint32_t
vatomic32_get_sub_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrex %[oldv], %[a]\n"
        "sub %[newv], %[oldv], %[v]\n"
        "strex %[tmp], %[newv], %[a]\n"
        "cmp %[tmp], #0\n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_and
 ******************************************************************************/
#ifndef VATOMIC64_GET_AND
    #define VATOMIC64_GET_AND
static inline vuint64_t
vatomic64_get_and(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "and %[newv], %[oldv], %[v]\n"
        "and %H[newv], %H[oldv], %H[v]\n"
    #else
        "and %H[newv], %H[oldv], %H[v]\n"
        "and %[newv], %[oldv], %[v]\n"
    #endif
        "stlexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_or
 ******************************************************************************/
#ifndef VATOMIC64_GET_OR
    #define VATOMIC64_GET_OR
static inline vuint64_t
vatomic64_get_or(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "orr %[newv], %[oldv], %[v]\n"
        "orr %H[newv], %H[oldv], %H[v]\n"
    #else
        "orr %H[newv], %H[oldv], %H[v]\n"
        "orr %[newv], %[oldv], %[v]\n"
    #endif
        "stlexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_xor
 ******************************************************************************/
#ifndef VATOMIC64_GET_XOR
    #define VATOMIC64_GET_XOR
static inline vuint64_t
vatomic64_get_xor(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "eor %[newv], %[oldv], %[v]\n"
        "eor %H[newv], %H[oldv], %H[v]\n"
    #else
        "eor %H[newv], %H[oldv], %H[v]\n"
        "eor %[newv], %[oldv], %[v]\n"
    #endif
        "stlexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_add
 ******************************************************************************/
#ifndef VATOMIC64_GET_ADD
    #define VATOMIC64_GET_ADD
static inline vuint64_t
vatomic64_get_add(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "adds %[newv], %[oldv], %[v]\n"
        "adc %H[newv], %H[oldv], %H[v]\n"
    #else
        "adds %H[newv], %H[oldv], %H[v]\n"
        "adc %[newv], %[oldv], %[v]\n"
    #endif
        "stlexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_sub
 ******************************************************************************/
#ifndef VATOMIC64_GET_SUB
    #define VATOMIC64_GET_SUB
static inline vuint64_t
vatomic64_get_sub(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "subs %[newv], %[oldv], %[v]\n"
        "sbc %H[newv], %H[oldv], %H[v]\n"
    #else
        "subs %H[newv], %H[oldv], %H[v]\n"
        "sbc %[newv], %[oldv], %[v]\n"
    #endif
        "stlexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_and_acq
 ******************************************************************************/
#ifndef VATOMIC64_GET_AND_ACQ
    #define VATOMIC64_GET_AND_ACQ
static inline vuint64_t
vatomic64_get_and_acq(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "and %[newv], %[oldv], %[v]\n"
        "and %H[newv], %H[oldv], %H[v]\n"
    #else
        "and %H[newv], %H[oldv], %H[v]\n"
        "and %[newv], %[oldv], %[v]\n"
    #endif
        "strexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_or_acq
 ******************************************************************************/
#ifndef VATOMIC64_GET_OR_ACQ
    #define VATOMIC64_GET_OR_ACQ
static inline vuint64_t
vatomic64_get_or_acq(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "orr %[newv], %[oldv], %[v]\n"
        "orr %H[newv], %H[oldv], %H[v]\n"
    #else
        "orr %H[newv], %H[oldv], %H[v]\n"
        "orr %[newv], %[oldv], %[v]\n"
    #endif
        "strexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_xor_acq
 ******************************************************************************/
#ifndef VATOMIC64_GET_XOR_ACQ
    #define VATOMIC64_GET_XOR_ACQ
static inline vuint64_t
vatomic64_get_xor_acq(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "eor %[newv], %[oldv], %[v]\n"
        "eor %H[newv], %H[oldv], %H[v]\n"
    #else
        "eor %H[newv], %H[oldv], %H[v]\n"
        "eor %[newv], %[oldv], %[v]\n"
    #endif
        "strexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_add_acq
 ******************************************************************************/
#ifndef VATOMIC64_GET_ADD_ACQ
    #define VATOMIC64_GET_ADD_ACQ
static inline vuint64_t
vatomic64_get_add_acq(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "adds %[newv], %[oldv], %[v]\n"
        "adc %H[newv], %H[oldv], %H[v]\n"
    #else
        "adds %H[newv], %H[oldv], %H[v]\n"
        "adc %[newv], %[oldv], %[v]\n"
    #endif
        "strexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_sub_acq
 ******************************************************************************/
#ifndef VATOMIC64_GET_SUB_ACQ
    #define VATOMIC64_GET_SUB_ACQ
static inline vuint64_t
vatomic64_get_sub_acq(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldaexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "subs %[newv], %[oldv], %[v]\n"
        "sbc %H[newv], %H[oldv], %H[v]\n"
    #else
        "subs %H[newv], %H[oldv], %H[v]\n"
        "sbc %[newv], %[oldv], %[v]\n"
    #endif
        "strexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_and_rel
 ******************************************************************************/
#ifndef VATOMIC64_GET_AND_REL
    #define VATOMIC64_GET_AND_REL
static inline vuint64_t
vatomic64_get_and_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "and %[newv], %[oldv], %[v]\n"
        "and %H[newv], %H[oldv], %H[v]\n"
    #else
        "and %H[newv], %H[oldv], %H[v]\n"
        "and %[newv], %[oldv], %[v]\n"
    #endif
        "stlexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_or_rel
 ******************************************************************************/
#ifndef VATOMIC64_GET_OR_REL
    #define VATOMIC64_GET_OR_REL
static inline vuint64_t
vatomic64_get_or_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "orr %[newv], %[oldv], %[v]\n"
        "orr %H[newv], %H[oldv], %H[v]\n"
    #else
        "orr %H[newv], %H[oldv], %H[v]\n"
        "orr %[newv], %[oldv], %[v]\n"
    #endif
        "stlexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_xor_rel
 ******************************************************************************/
#ifndef VATOMIC64_GET_XOR_REL
    #define VATOMIC64_GET_XOR_REL
static inline vuint64_t
vatomic64_get_xor_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "eor %[newv], %[oldv], %[v]\n"
        "eor %H[newv], %H[oldv], %H[v]\n"
    #else
        "eor %H[newv], %H[oldv], %H[v]\n"
        "eor %[newv], %[oldv], %[v]\n"
    #endif
        "stlexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_add_rel
 ******************************************************************************/
#ifndef VATOMIC64_GET_ADD_REL
    #define VATOMIC64_GET_ADD_REL
static inline vuint64_t
vatomic64_get_add_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "adds %[newv], %[oldv], %[v]\n"
        "adc %H[newv], %H[oldv], %H[v]\n"
    #else
        "adds %H[newv], %H[oldv], %H[v]\n"
        "adc %[newv], %[oldv], %[v]\n"
    #endif
        "stlexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_sub_rel
 ******************************************************************************/
#ifndef VATOMIC64_GET_SUB_REL
    #define VATOMIC64_GET_SUB_REL
static inline vuint64_t
vatomic64_get_sub_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "subs %[newv], %[oldv], %[v]\n"
        "sbc %H[newv], %H[oldv], %H[v]\n"
    #else
        "subs %H[newv], %H[oldv], %H[v]\n"
        "sbc %[newv], %[oldv], %[v]\n"
    #endif
        "stlexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_and_rlx
 ******************************************************************************/
#ifndef VATOMIC64_GET_AND_RLX
    #define VATOMIC64_GET_AND_RLX
static inline vuint64_t
vatomic64_get_and_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "and %[newv], %[oldv], %[v]\n"
        "and %H[newv], %H[oldv], %H[v]\n"
    #else
        "and %H[newv], %H[oldv], %H[v]\n"
        "and %[newv], %[oldv], %[v]\n"
    #endif
        "strexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_or_rlx
 ******************************************************************************/
#ifndef VATOMIC64_GET_OR_RLX
    #define VATOMIC64_GET_OR_RLX
static inline vuint64_t
vatomic64_get_or_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "orr %[newv], %[oldv], %[v]\n"
        "orr %H[newv], %H[oldv], %H[v]\n"
    #else
        "orr %H[newv], %H[oldv], %H[v]\n"
        "orr %[newv], %[oldv], %[v]\n"
    #endif
        "strexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_xor_rlx
 ******************************************************************************/
#ifndef VATOMIC64_GET_XOR_RLX
    #define VATOMIC64_GET_XOR_RLX
static inline vuint64_t
vatomic64_get_xor_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "eor %[newv], %[oldv], %[v]\n"
        "eor %H[newv], %H[oldv], %H[v]\n"
    #else
        "eor %H[newv], %H[oldv], %H[v]\n"
        "eor %[newv], %[oldv], %[v]\n"
    #endif
        "strexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_add_rlx
 ******************************************************************************/
#ifndef VATOMIC64_GET_ADD_RLX
    #define VATOMIC64_GET_ADD_RLX
static inline vuint64_t
vatomic64_get_add_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "adds %[newv], %[oldv], %[v]\n"
        "adc %H[newv], %H[oldv], %H[v]\n"
    #else
        "adds %H[newv], %H[oldv], %H[v]\n"
        "adc %[newv], %[oldv], %[v]\n"
    #endif
        "strexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_sub_rlx
 ******************************************************************************/
#ifndef VATOMIC64_GET_SUB_RLX
    #define VATOMIC64_GET_SUB_RLX
static inline vuint64_t
vatomic64_get_sub_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "1:\n"
        "ldrexd %[oldv], %H[oldv], %[a]\n"
    #if defined(VATOMIC_LI_ENDIAN)
        "subs %[newv], %[oldv], %[v]\n"
        "sbc %H[newv], %H[oldv], %H[v]\n"
    #else
        "subs %H[newv], %H[oldv], %H[v]\n"
        "sbc %[newv], %[oldv], %[v]\n"
    #endif
        "strexd %[tmp], %[newv], %H[newv], %[a]\n"
        "cmp %[tmp], #0 \n"
        "bne 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp)
        : [v] "r"(v), [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
#endif
