/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.graalvm.libgraal;

import java.io.IOException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshot;
import org.graalvm.visualvm.application.views.ApplicationViewsSupport;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.ui.DataSourceViewPlugin;
import org.graalvm.visualvm.core.ui.DataSourceViewPluginProvider;
import org.graalvm.visualvm.graalvm.libgraal.MemoryModel;
import org.graalvm.visualvm.graalvm.libgraal.MemoryViewPlugin;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;

public class MemoryViewPluginProvider
extends DataSourceViewPluginProvider<Application> {
    static final String LIBGRAAL_HEAP = "Libgraal";
    private final ObjectName libgraalName = MemoryViewPluginProvider.getLibgraalName();

    protected DataSourceViewPlugin createPlugin(Application application) {
        return new MemoryViewPlugin((DataSource)application, MemoryModel.create(application, LIBGRAAL_HEAP, this.libgraalName));
    }

    protected boolean supportsPluginFor(Application t) {
        return this.isSupported(t);
    }

    protected boolean supportsSavePluginFor(Application application, Class<? extends Snapshot> snapshotClass) {
        return ApplicationSnapshot.class.isAssignableFrom(snapshotClass);
    }

    protected void savePlugin(Application application, Snapshot snapshot) {
        MemoryViewPlugin view = (MemoryViewPlugin)this.getCachedPlugin((DataSource)application);
        if (view != null) {
            view.getModel().save(snapshot);
        } else {
            MemoryModel.create((DataSource)application, LIBGRAAL_HEAP).save(snapshot);
        }
    }

    private MemoryViewPluginProvider() {
    }

    public static void initialize() {
        ApplicationViewsSupport.sharedInstance().getMonitorView().registerPluginProvider((DataSourceViewPluginProvider)new MemoryViewPluginProvider());
    }

    private static ObjectName getLibgraalName() {
        try {
            return new ObjectName("java.lang:type=MemoryPool,name=Libgraal");
        }
        catch (MalformedObjectNameException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static MBeanServerConnection getConnection(Application app) {
        JmxModel jmxModel = JmxModelFactory.getJmxModelFor((Application)app);
        if (jmxModel != null && jmxModel.getConnectionState() == JmxModel.ConnectionState.CONNECTED) {
            return jmxModel.getMBeanServerConnection();
        }
        return null;
    }

    private boolean isSupported(Application app) {
        try {
            MBeanServerConnection conn = MemoryViewPluginProvider.getConnection(app);
            if (conn != null) {
                return conn.isRegistered(this.libgraalName);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

