/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.inspector;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.zookeeper.inspector.gui.ZooInspectorPanel;
import org.apache.zookeeper.inspector.logger.LoggerFactory;
import org.apache.zookeeper.inspector.manager.ZooInspectorManagerImpl;

public class ZooInspector {
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            JFrame frame = new JFrame("ZooInspector");
            frame.setDefaultCloseOperation(3);
            final ZooInspectorPanel zooInspectorPanel = new ZooInspectorPanel(new ZooInspectorManagerImpl());
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    super.windowClosed(e);
                    zooInspectorPanel.disconnect(true);
                }
            });
            frame.setContentPane(zooInspectorPanel);
            frame.setSize(1024, 768);
            frame.setVisible(true);
        }
        catch (Exception e) {
            LoggerFactory.getLogger().error("Error occurred loading ZooInspector", (Throwable)e);
            JOptionPane.showMessageDialog(null, "ZooInspector failed to start: " + e.getMessage(), "Error", 0);
        }
    }
}

