/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.watcher.WatcherFeatureSetUsage;
import org.elasticsearch.xpack.core.watcher.client.WatcherClient;
import org.elasticsearch.xpack.core.watcher.common.stats.Counters;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsResponse;

public class WatcherFeatureSet
implements XPackFeatureSet {
    private final boolean enabled;
    private final XPackLicenseState licenseState;
    private Client client;

    @Inject
    public WatcherFeatureSet(Settings settings, @Nullable XPackLicenseState licenseState, Client client) {
        this.enabled = (Boolean)XPackSettings.WATCHER_ENABLED.get(settings);
        this.licenseState = licenseState;
        this.client = client;
    }

    public String name() {
        return "watcher";
    }

    public String description() {
        return "Alerting, Notification and Automation for the Elastic Stack";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isWatcherAllowed();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        if (this.enabled) {
            try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("watcher");){
                WatcherClient watcherClient = new WatcherClient(this.client);
                WatcherStatsRequest request = new WatcherStatsRequest();
                request.includeStats(true);
                watcherClient.watcherStats(request, ActionListener.wrap(r -> {
                    List countersPerNode = r.getNodes().stream().map(WatcherStatsResponse.Node::getStats).filter(Objects::nonNull).collect(Collectors.toList());
                    Counters mergedCounters = Counters.merge(countersPerNode);
                    listener.onResponse((Object)new WatcherFeatureSetUsage(this.available(), this.enabled(), mergedCounters.toNestedMap()));
                }, arg_0 -> listener.onFailure(arg_0)));
            }
        } else {
            listener.onResponse((Object)new WatcherFeatureSetUsage(this.available(), this.enabled(), Collections.emptyMap()));
        }
    }
}

