/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic;

import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.gen.script.Scripts;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Arithmetics;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.UnaryArithmeticProcessor;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public class Neg
extends UnaryScalarFunction {
    public Neg(Source source, Expression field) {
        super(source, field);
    }

    @Override
    protected NodeInfo<Neg> info() {
        return NodeInfo.create(this, Neg::new, this.field());
    }

    @Override
    protected Neg replaceChild(Expression newChild) {
        return new Neg(this.source(), newChild);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isNumeric(this.field(), this.sourceText(), Expressions.ParamOrdinal.DEFAULT);
    }

    @Override
    public Object fold() {
        return Arithmetics.negate((Number)this.field().fold());
    }

    @Override
    public DataType dataType() {
        return this.field().dataType();
    }

    @Override
    public String processScript(String script) {
        return Scripts.formatTemplate("{sql}.neg(" + script + ")");
    }

    @Override
    protected Processor makeProcessor() {
        return new UnaryArithmeticProcessor(UnaryArithmeticProcessor.UnaryArithmeticOperation.NEGATE);
    }
}

