/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.token;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authc.support.TokensInvalidationResult;

public final class InvalidateTokenResponse
extends ActionResponse
implements ToXContent {
    private TokensInvalidationResult result;

    public InvalidateTokenResponse() {
    }

    public InvalidateTokenResponse(TokensInvalidationResult result) {
        this.result = result;
    }

    public TokensInvalidationResult getResult() {
        return this.result;
    }

    private boolean isCreated() {
        return this.result.getInvalidatedTokens().size() > 0 && this.result.getPreviouslyInvalidatedTokens().isEmpty() && this.result.getErrors().isEmpty();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_6_6_0)) {
            out.writeBoolean(this.isCreated());
        } else {
            this.result.writeTo(out);
        }
    }

    public void readFrom(StreamInput in) throws IOException {
        boolean created;
        super.readFrom(in);
        this.result = in.getVersion().before(Version.V_6_6_0) ? ((created = in.readBoolean()) ? new TokensInvalidationResult(Arrays.asList(""), Collections.emptyList(), Collections.emptyList(), 0) : new TokensInvalidationResult(Collections.emptyList(), Arrays.asList(""), Collections.emptyList(), 0)) : new TokensInvalidationResult(in);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.result.toXContent(builder, params);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        InvalidateTokenResponse that = (InvalidateTokenResponse)((Object)o);
        return Objects.equals(this.result, that.result);
    }

    public int hashCode() {
        return Objects.hash(this.result);
    }
}

