/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dependencies;

import com.google.common.base.Objects;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.CachingDependencyResolveContext;
import org.gradle.api.internal.artifacts.dependencies.AbstractModuleDependency;
import org.gradle.api.internal.artifacts.dependencies.ProjectDependencyInternal;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultTaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.internal.component.resolution.failure.exception.VariantSelectionByNameException;
import org.gradle.internal.component.resolution.failure.type.ConfigurationNotConsumableFailure;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.util.Path;
import org.gradle.util.internal.GUtil;

public class DefaultProjectDependency
extends AbstractModuleDependency
implements ProjectDependencyInternal {
    private final ProjectInternal dependencyProject;
    private final boolean buildProjectDependencies;
    private final TaskDependencyFactory taskDependencyFactory;

    public DefaultProjectDependency(ProjectInternal dependencyProject, boolean buildProjectDependencies, TaskDependencyFactory taskDependencyFactory) {
        this(dependencyProject, null, buildProjectDependencies, taskDependencyFactory);
    }

    public DefaultProjectDependency(ProjectInternal dependencyProject, boolean buildProjectDependencies) {
        this(dependencyProject, null, buildProjectDependencies, DefaultTaskDependencyFactory.withNoAssociatedProject());
    }

    public DefaultProjectDependency(ProjectInternal dependencyProject, @Nullable String configuration, boolean buildProjectDependencies, TaskDependencyFactory taskDependencyFactory) {
        super(configuration);
        this.dependencyProject = dependencyProject;
        this.buildProjectDependencies = buildProjectDependencies;
        this.taskDependencyFactory = taskDependencyFactory;
    }

    public Project getDependencyProject() {
        return this.dependencyProject;
    }

    public String getGroup() {
        return this.dependencyProject.getGroup().toString();
    }

    public String getName() {
        return this.dependencyProject.getName();
    }

    public String getVersion() {
        return this.dependencyProject.getVersion().toString();
    }

    public Path getIdentityPath() {
        return this.dependencyProject.getIdentityPath();
    }

    public ProjectIdentity getTargetProjectIdentity() {
        return this.dependencyProject.getOwner().getIdentity();
    }

    private Configuration findProjectConfiguration() {
        String declaredConfiguration;
        ConfigurationContainer dependencyConfigurations = this.getDependencyProject().getConfigurations();
        Configuration selectedConfiguration = dependencyConfigurations.getByName(GUtil.isTrue((Object)(declaredConfiguration = this.getTargetConfiguration())) ? declaredConfiguration : "default");
        if (!selectedConfiguration.isCanBeConsumed()) {
            this.failDueToNonConsumableConfigurationSelection(selectedConfiguration);
        }
        ((DeprecatableConfiguration)selectedConfiguration).maybeEmitConsumptionDeprecation();
        return selectedConfiguration;
    }

    private void failDueToNonConsumableConfigurationSelection(Configuration selectedConfiguration) {
        ConfigurationNotConsumableFailure failure = new ConfigurationNotConsumableFailure((ComponentIdentifier)this.dependencyProject.getOwner().getComponentIdentifier(), selectedConfiguration.getName());
        String message = String.format("Selected configuration '" + failure.getRequestedConfigurationName() + "' on " + failure.getTargetComponent().getDisplayName() + " but it can't be used as a project dependency because it isn't intended for consumption by other components.", new Object[0]);
        throw new VariantSelectionByNameException(message, failure, Collections.emptyList());
    }

    public ProjectDependency copy() {
        DefaultProjectDependency copiedProjectDependency = new DefaultProjectDependency(this.dependencyProject, this.getTargetConfiguration(), this.buildProjectDependencies, this.taskDependencyFactory);
        this.copyTo(copiedProjectDependency);
        return copiedProjectDependency;
    }

    @Deprecated
    public Set<File> resolve() {
        return this.resolve(true);
    }

    @Deprecated
    public Set<File> resolve(boolean transitive) {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecate((String)("Directly resolving the files of project dependency '" + this.getIdentityPath() + "'")).withAdvice("Add the dependency to a resolvable configuration and resolve the configuration.").willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "deprecate_self_resolving_dependency")).nagUser();
        CachingDependencyResolveContext context = new CachingDependencyResolveContext(this.taskDependencyFactory, transitive, Collections.emptyMap());
        context.add((Object)this);
        return context.resolve().getFiles();
    }

    @Deprecated
    public void resolve(CachingDependencyResolveContext context) {
        boolean transitive;
        boolean bl = transitive = this.isTransitive() && context.isTransitive();
        if (transitive) {
            Configuration projectConfiguration = this.findProjectConfiguration();
            for (Dependency dependency : projectConfiguration.getAllDependencies()) {
                context.add((Object)dependency);
            }
            for (DependencyConstraint dependencyConstraint : projectConfiguration.getAllDependencyConstraints()) {
                context.add((Object)dependencyConstraint);
            }
        }
    }

    @Deprecated
    public TaskDependencyInternal getBuildDependencies() {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecate((String)("Accessing the build dependencies of project dependency '" + this.getIdentityPath() + "'")).withAdvice("Add the dependency to a resolvable configuration and use the configuration to track task dependencies.").willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "deprecate_self_resolving_dependency")).nagUser();
        return this.taskDependencyFactory.visitingDependencies(context -> {
            if (!this.buildProjectDependencies) {
                return;
            }
            Configuration configuration = this.findProjectConfiguration();
            context.add((Object)configuration);
            context.add((Object)configuration.getAllArtifacts());
        });
    }

    public boolean contentEquals(Dependency dependency) {
        if (this == dependency) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != dependency.getClass()) {
            return false;
        }
        DefaultProjectDependency that = (DefaultProjectDependency)dependency;
        if (!this.isCommonContentEquals((ModuleDependency)that)) {
            return false;
        }
        return this.getIdentityPath().equals((Object)that.getIdentityPath());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DefaultProjectDependency that = (DefaultProjectDependency)((Object)o);
        if (!this.getIdentityPath().equals((Object)that.getIdentityPath())) {
            return false;
        }
        if (this.getTargetConfiguration() != null ? !this.getTargetConfiguration().equals(that.getTargetConfiguration()) : that.getTargetConfiguration() != null) {
            return false;
        }
        if (this.buildProjectDependencies != that.buildProjectDependencies) {
            return false;
        }
        if (!Objects.equal((Object)this.getAttributes(), (Object)that.getAttributes())) {
            return false;
        }
        return Objects.equal((Object)this.getRequestedCapabilities(), (Object)that.getRequestedCapabilities());
    }

    public int hashCode() {
        return this.getIdentityPath().hashCode() ^ (this.getTargetConfiguration() != null ? this.getTargetConfiguration().hashCode() : 31) ^ (this.buildProjectDependencies ? 1 : 0);
    }

    public String toString() {
        return "DefaultProjectDependency{identityPath='" + this.getIdentityPath() + '\'' + ", configuration='" + (this.getTargetConfiguration() == null ? "default" : this.getTargetConfiguration()) + '\'' + '}';
    }
}

