/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.CacheFlushListener;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;

class ForwardingCacheFlushListener<K, V>
implements CacheFlushListener<K, V> {
    private final InternalProcessorContext context;
    private final boolean sendOldValues;
    private final ProcessorNode myNode;

    ForwardingCacheFlushListener(ProcessorContext context, boolean sendOldValues) {
        this.context = (InternalProcessorContext)context;
        this.myNode = this.context.currentNode();
        this.sendOldValues = sendOldValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(K key, V newValue, V oldValue) {
        ProcessorNode prev = this.context.currentNode();
        this.context.setCurrentNode(this.myNode);
        try {
            if (this.sendOldValues) {
                this.context.forward(key, new Change<V>(newValue, oldValue));
            } else {
                this.context.forward(key, new Change<Object>(newValue, null));
            }
        }
        finally {
            this.context.setCurrentNode(prev);
        }
    }
}

