/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

public final class TextHitInfo {
    private int charIndex;
    private boolean leadingEdge;

    public final int getCharIndex() {
        return this.charIndex;
    }

    public final boolean isLeadingEdge() {
        return this.leadingEdge;
    }

    public final int getInsertionIndex() {
        return this.leadingEdge ? this.charIndex : this.charIndex + 1;
    }

    public final int hashCode() {
        return this.charIndex;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof TextHitInfo) {
            return this.equals((TextHitInfo)obj);
        }
        return false;
    }

    public final boolean equals(TextHitInfo hitInfo) {
        boolean bl = false;
        if (this.charIndex == hitInfo.getCharIndex() && this.leadingEdge == hitInfo.isLeadingEdge()) {
            bl = true;
        }
        return bl;
    }

    public static final TextHitInfo leading(int charIndex) {
        return new TextHitInfo(charIndex, true);
    }

    public static final TextHitInfo trailing(int charIndex) {
        return new TextHitInfo(charIndex, false);
    }

    public static final TextHitInfo beforeOffset(int offset) {
        return new TextHitInfo(offset, false);
    }

    public static final TextHitInfo afterOffset(int offset) {
        return new TextHitInfo(offset, true);
    }

    public final TextHitInfo getOtherHit() {
        return this.leadingEdge ? TextHitInfo.trailing(this.charIndex - 1) : TextHitInfo.leading(this.charIndex + 1);
    }

    public final TextHitInfo getOffsetHit(int offset) {
        return new TextHitInfo(this.charIndex + offset, this.leadingEdge);
    }

    public final String toString() {
        return "TextHitInfo[" + this.charIndex + (this.leadingEdge ? "L" : "T") + ']';
    }

    TextHitInfo(int charIndex, boolean leadingEdge) {
        this.charIndex = charIndex;
        this.leadingEdge = leadingEdge;
    }
}

