package JConv;
# $Id: JConv.pm,v 1.16 2000/12/25 05:46:48 tom Exp $
################################################################

=head1 NAME

 JConv - japanese kanji converter

=cut

# $Id: JConv.pm,v 1.16 2000/12/25 05:46:48 tom Exp $
################################################################

use Exporter;
use strict qw(vars);
use vars qw(@ISA @EXPORT
	    $Mode $DefaultOutputJcode $DefaultInputJcode %CodeTable %cheat);

@ISA = qw(Exporter);
@EXPORT = qw(jconv jconv_a2i jconv_auto mkjconv SetDefaultJcode);

BEGIN{
    ### NKF.pmѲݤȽ
    eval 'use NKF';
    unless ($@){    # NKF.pm 
	$Mode = "NKF";
	return;
    }

    ### jcode.plѲݤȽ
    eval 'require "jcode.pl"';
    unless ($@){
	$Mode = "jcode";
	return;
    }

    # die "'NKF.pm' or 'jcode.pl' required.\n";
    $Mode = "none";
}

%CodeTable = ('jis'  => 'jis',	'iso-2022-jp' => 'jis',
	      'euc'  => 'euc',	'ujis' => 'euc',
	      'sjis' => 'sjis', 'shift_jis' => 'sjis',
	      'us-ascii' => 'us-ascii',
	      );

$DefaultOutputJcode = 'euc';
$DefaultInputJcode   = 'auto';
%cheat = ();

sub mkjconv(;$$);

### Ϥ$System::InputJcodeȲꤷơ$System::InternalJcodeEUC
### ɤѴ롣
### $System::InternalJcode  $System::InputJcodeѹƤȿ
### ʤΤա
sub jconv;
#*jconv = mkjconv($DefaultInputJcode, $DefaultOutputJcode);

# jconv() ϡѴؿȤơauto ȽȤ
*jconv = mkjconv();

sub jconv_a2i;
#*jconv_a2i = mkjconv('auto', $DefaultInputJcode);

### ʸɤưȽꤷơ$System::InternalJcodeEUCɤ
### Ѵ롣ʸɤȽƤϡJconv::mkjconv()
### 륳ɥե󥹤Ѥ®
### $System::InternalJcodeѹȿǤʤΤա
sub jconv_auto;
#*jconv_auto = mkjconv();

### mkjconv($jcode_in, $jcode_out)
### ꤵ줿ʸɤѴؿؤΥե󥹤֤
### ̵άϡjconv_auto()ƱʤΤǡä꤬ʤ
### Сľ jconv_auto() Ѥ뤳ȡ
### 줿ؿ֤ͤȤ̯ʻͤޤ®ΰ
### ǤΤǡɤλm(__)m
sub mkjconv (;$$){
    my ($jcode_in, $jcode_out) = @_;

    ### $jcode_out'auto'ˤʤ뤳ȤϤʤ
    $jcode_out = namecheck($jcode_out) || $DefaultOutputJcode;
    $jcode_in  = namecheck($jcode_in)  || $DefaultInputJcode;

    ### ѴɬפʤС⤷ʤؿؤΥե󥹤֤
    if (($jcode_in eq $jcode_out) or ($Mode eq 'none')
     or ($jcode_in eq 'us-ascii')) {
	return sub{};
    }
    ### ʸɤus-asciiʳξ硢us-asciiؤѴǧʤ
    die "can't convert $jcode_in -> us-ascii!" if ($jcode_out eq 'us-ascii');

    ### ǤƱΥ㤬Ф֤
    my $opt_jconv = "${Mode}\:${jcode_in}2${jcode_out}";
    my $rc_jconv = $cheat{$opt_jconv};
    if (defined($rc_jconv) and (ref($rc_jconv) eq 'CODE')) {
	return $rc_jconv;
    }

    if ($Mode eq 'NKF') {
	my %opt_in  = ('jis'=>'J', 'euc'=>'E', 'sjis'=>'S', 'auto'=> '');
	my %opt_out = ('jis'=>'j', 'euc'=>'e', 'sjis'=>'s');
	my $opt = "-$opt_out{$jcode_out}$opt_in{$jcode_in}m0";    # m0  iso-2022-jp?= Ѵʤ褦
	### ιԤʤ԰¡ʸ򤽤Τޤ֤Τ1ǤΤ(^^;)
    
	#$rc_jconv = sub {${$_[0]} = nkf($opt, ${$_[0]});1;}; # perl-mode ʤΤѹޤ    
	$rc_jconv = sub {my $r_text = shift; $$r_text = nkf($opt, $$r_text);1;};
    } elsif ($Mode eq 'jcode') {
	# print "content-type: text/html\n\n";
        if ($jcode_in eq 'auto') {
	    ### $jcode_optϡΥ֥åȴǤ⡢
	    ### ǡͤݻ³롣
	    my $jcode_opt = $jcode_out;
            #$rc_jconv = sub {jcode::convert($_[0], $jcode_opt);};
            $rc_jconv = sub {
	      #jcode::convert($_[0], $jcode_opt);
#		my $r_text = shift;
		&jcode::convert($_[0], $jcode_opt);
#		print "t:$$r_text, ";
	    };
	    
	} else {
	    ### %jcode::convfPerl4Ȥθߴΰ٤˷֤ݻƤΤǡΤޤ
	    ### ȡ*jconv_html = Jconv::mkjconv('euc', 'jis');ǡ$jconv_html˲
	    ### Ƥޤǡ\&{}ǳäƥɥե󥹤Τߤ֤Ƥ롣
	    #print "$jcode_in, $jcode_out";
	    $rc_jconv = \&{$jcode::convf{$jcode_in, $jcode_out}};
	}
    } else {
    ### $Mode  'none' ξϤޤʤΤǡ¤餫˻Ǥ(
	die "Mode:$Mode can't use.";
    }
    $cheat{$opt_jconv} = $rc_jconv;
    return $rc_jconv;
}

#ʸåơJconv.pmͭʸ֤̾
#̵ʾ϶ʸ֤
sub namecheck ($) {
    my ($name) = @_;
    return '' unless defined($name);
    $name = lc($name);
    if (exists($CodeTable{$name})) {
	return $CodeTable{$name};
    } else {
	return '';
    }
}

#
sub SetDefaultJcode($$)
{
    my ($in, $out) = @_;

    $DefaultInputJcode = $in;
    $DefaultOutputJcode = $out;

    *jconv = mkjconv($in, $out);
    *jconv_a2i = mkjconv('auto', $in);
}
################################################################
sub GetCharset($)
{
    my $code = shift;
    
    my $default = "us-ascii";
    my %table = (euc=>'EUC-JP',
		 sjis=>'Shift_JIS',
		 jis=>'ISO-2022-JP');
    return $table{$code} || $default;
}
1;
