/*
* MyGoGrinder - a program to practice Go problems
* This class' code copyright (c)2014 Ruediger Klehn
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder;
import javax.swing.*;
import GoGrinder.Main;
import GoGrinder.FileWorks;
import GoGrinder.ui.SelectionDialog;
import java.io.File;
// import javax.swing.filechooser.FileFilter;

// analyzing (and later: testing) the starter String for the sgf editor is done here
public class EditorStarter{
  public EditorStarter(){/*nothing in here*/;}
  
  public static boolean editorStarter(String starter, String editThisFile){
    // parse command line for an editor from the settings entry and separate the switches
    String[] runString = null; // at the end, we give this (array) to the executor
    String[] cmdParts = null;  // we use this to split the command string from the settings entry
// String execStrings = "";  // /*DEBUG*/
    String[] runStringTmp = null;
    if (starter == null || starter.trim().equals("")){
      JOptionPane.showMessageDialog(null, Messages.getString("ProbFrame.FirstCfgEditor")); //$NON-NLS-1$
      return false;
    }
    String editWith = starter.trim();
    int runStringCount = 0; // count of valid command parts (for runString[0]-[n]
    int count=0;
    while (true){
      switch (editWith.trim().charAt(0)){
        case '"':  // ( "command" -switch1 "parameter" -switch2 ... )
          editWith = editWith.substring(1); // ( command" -switch1 "parameter" -switch2 ... ) 
          if (runStringCount == 0 && editWith.length() < 3){  // no valid command path 
              // (too short command; e.g. /c (minus the 2nd '"') would be valid in Lnx)
            JOptionPane.showMessageDialog(null, Messages.getString("ProbFrame.FirstCfgEditor"));
            return false; 
          }
          cmdParts = editWith.split("\"", 2); // ( command   +   -switch1 "parameter" -switch2 ... )
          break;
        case '\'':  // ( 'command' -switch1 'parameter' -switch2 ... )
          editWith = editWith.substring(1); // ( command' -switch1 'parameter' -switch2 ... ) 
          if (runStringCount == 0 && editWith.length() < 3){   // no valid command path 
            JOptionPane.showMessageDialog(null, Messages.getString("ProbFrame.FirstCfgEditor"));
            return false;
          }
          cmdParts = editWith.split("'", 2); // ( command   +   -switch1 "parameter" -switch2 ... )
          break;
        default: // doesn't start with (") or (') (at the moment we don't look for (`) )
          if (runStringCount == 0 && editWith.length() < 2){  // no valid command path
            JOptionPane.showMessageDialog(null, Messages.getString("ProbFrame.FirstCfgEditor"));
            return false;
          }
          cmdParts = editWith.split(" ", 2);
          break;
      }//switch

      if (runStringCount > 0){ // not first loop
        runStringTmp = new String[runStringCount]; // runStringTmp is an array, gets (new) count of fields here
        runStringTmp = runString;                  
      }
      runStringCount = runStringCount + 1;
      runString = new String[runStringCount];
      if (runStringCount > 1){
        for (int i=0; i < runStringCount - 1; i++){
          runString[i] = runStringTmp[i];
        }
        runString[runStringCount - 1] = cmdParts[0]; // .trim()
      }
      else runString[0] = cmdParts[0]; //.trim() - spaces were apparently enclosed by (")/(') - we keep them

 /*DEBUG*/
//execStrings = "";
// JOptionPane.showMessageDialog(null, "runString[0]: " + runString[0] + "\n"    /*DEBUG*/
//                                   + "cmdParts[0]: " + cmdParts[0]);           /*DEBUG*/
// if (runString.length > 0)                                                     /*DEBUG*/
//  for (int i=0;i<runString.length;i++)                                         /*DEBUG*/
//    execStrings = execStrings + ">" + runString[i] + "<\n";                    /*DEBUG*/
//else execStrings = "NIX";                                                      /*DEBUG*/
//JOptionPane.showMessageDialog(null, "5 Parsing editor starter (loop) \n"       /*DEBUG*/
//                                    + execStrings);                            /*DEBUG*/
 /*DEBUG*/

      // test the first part of runString for canExecute
      if (runStringCount == 1){
        File runStringF = new File(runString[0]); // is it good to declare runStringF here?
        if (!runStringF.isFile()){
          JOptionPane.showMessageDialog(null, "Unfortunately, the begin of your starter is not a (Java-)\"File\": \n"
                                            + starter + "\n"
                                            + "The executable part, which we got: \n"
                                            + runString[0]);
          return false;
        }
        else{ 
          if (SysInfo.JAVA_VERSION.startsWith("1.5")){ // Java 1.4 and lower is already blocked in Main.checkJavaVersion()
                                                    //   Java 5 doesn't know about File.canExecute()
            String question = "Unfortunately, Java 5 cannot check a \"File\" for \n"
                            + "\"canExecute()\", so we omit the test here. \n"
                            + "So YOU need to take care, that the executable part \n"
                            + "\"" + runString[0] + "\" in your starter: \n"
                            + "\"" + starter + "\" is really executable. \n\n"
                            + "Continue here?";
            String caption = "Sorry! No test for canExecute() in Java 5";
            if (!SelectionDialog.OKCancelMsg(question, caption))
            return false;
          }   
          else{
              if (!runStringF.canExecute()){ // there are some differences in handling "canExecute()" in some Unixes
                JOptionPane.showMessageDialog(null, "Unfortunately, the begin of your starter is not executable: \n"
                                                  + starter + "\n"
                                                  + "The executable part, which we got: \n"
                                                  + runString[0]);
                return false;
              }
            }
        }
      }//testExec
      if (cmdParts.length == 1) break; // split() didn't find split condition
      editWith = cmdParts[1].trim();
      
      if (editWith.trim().length() == 0 || editWith.trim() == "") break; // runString is complete (but without the sgf!!)
        // interesting results: 
        // if (editWith.trim().length() == 0 ) -> true (ok)
        // if (editWith.trim() == "") -> false (ooops?) MUST BE .equals("")
        // if (editWith == null) -> false (ok))
        // if (editWith.equals(null)) -> false (ok)
    }//while
    
    // add the sgf to the runString array
    runStringTmp = new String[runStringCount];
    runStringTmp = runString;
    runStringCount = runStringCount + 1;
    runString = new String[runStringCount];
    for (int i=0; i < runStringCount - 1; i++){
      runString[i] = runStringTmp[i];
    }
    runString[runStringCount - 1] = editThisFile;
    
    File workingDir = new File(runString[0]).getParentFile();
//    File workingDir = new File(editThisFile).getParentFile();

    FileWorks.execute(runString, workingDir);
    return true;
  }//method
}