/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.diylc.swingframework.ButtonDialog;

public class ProgressDialog
extends ButtonDialog {
    private static final long serialVersionUID = 1L;
    private String description;
    private boolean useProgress;
    private JPanel mainPanel;
    private JProgressBar progressBar;

    public ProgressDialog(JFrame owner, String title, String[] buttonCaptions, String description, boolean useProgress) {
        super(owner, title, buttonCaptions);
        this.description = description;
        this.useProgress = useProgress;
        this.setDefaultCloseOperation(0);
        this.layoutGui();
    }

    public void setProgress(int value) {
        this.getProgressBar().setValue(value);
    }

    @Override
    protected JComponent getMainComponent() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new GridBagLayout());
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 21;
            gbc.fill = 0;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.mainPanel.add((Component)new JLabel(this.description), gbc);
            gbc.gridy = 1;
            this.mainPanel.add((Component)this.getProgressBar(), gbc);
        }
        return this.mainPanel;
    }

    private JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setIndeterminate(!this.useProgress);
        }
        return this.progressBar;
    }
}

