/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.sql.proto.Mode;

public class Configuration {
    private final ZoneId zoneId;
    private final int pageSize;
    private final TimeValue requestTimeout;
    private final TimeValue pageTimeout;
    private final Mode mode;
    private final String clientId;
    private final String username;
    private final String clusterName;
    private final boolean multiValueFieldLeniency;
    private final ZonedDateTime now;
    @Nullable
    private QueryBuilder filter;

    public Configuration(ZoneId zi, int pageSize, TimeValue requestTimeout, TimeValue pageTimeout, QueryBuilder filter, Mode mode, String clientId, String username, String clusterName, boolean multiValueFieldLeniency) {
        this.zoneId = zi.normalized();
        this.pageSize = pageSize;
        this.requestTimeout = requestTimeout;
        this.pageTimeout = pageTimeout;
        this.filter = filter;
        this.mode = mode == null ? Mode.PLAIN : mode;
        this.clientId = clientId;
        this.username = username;
        this.clusterName = clusterName;
        this.multiValueFieldLeniency = multiValueFieldLeniency;
        this.now = ZonedDateTime.now(this.zoneId);
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public TimeValue requestTimeout() {
        return this.requestTimeout;
    }

    public TimeValue pageTimeout() {
        return this.pageTimeout;
    }

    public QueryBuilder filter() {
        return this.filter;
    }

    public Mode mode() {
        return this.mode;
    }

    public String clientId() {
        return this.clientId;
    }

    public String username() {
        return this.username;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public ZonedDateTime now() {
        return this.now;
    }

    public boolean multiValueFieldLeniency() {
        return this.multiValueFieldLeniency;
    }
}

