/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.mdarray;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;

public final class MDDoubleArray
extends MDAbstractArray<Double> {
    private static final long serialVersionUID = 1L;
    private double[] flattenedArray;

    public MDDoubleArray(long[] dimensions) {
        this(new double[MDDoubleArray.getLength(dimensions, 0L)], MDDoubleArray.toInt(dimensions), false);
    }

    public MDDoubleArray(long[] dimensions, long capacityHyperRows) {
        this(new double[MDDoubleArray.getLength(dimensions, capacityHyperRows)], MDDoubleArray.toInt(dimensions), false);
    }

    public MDDoubleArray(double[] flattenedArray, long[] dimensions) {
        this(flattenedArray, MDDoubleArray.toInt(dimensions), true);
    }

    public MDDoubleArray(double[] flattenedArray, long[] dimensions, boolean checkdimensions) {
        this(flattenedArray, MDDoubleArray.toInt(dimensions), checkdimensions);
    }

    public MDDoubleArray(int[] dimensions) {
        this(new double[MDDoubleArray.getLength(dimensions, 0)], dimensions, false);
    }

    public MDDoubleArray(int[] dimensions, int capacityHyperRows) {
        this(new double[MDDoubleArray.getLength(dimensions, capacityHyperRows)], dimensions, false);
    }

    public MDDoubleArray(double[] flattenedArray, int[] dimensions) {
        this(flattenedArray, dimensions, true);
    }

    public MDDoubleArray(double[] flattenedArray, int[] dimensions, boolean checkdimensions) {
        super(dimensions, flattenedArray.length, 0);
        int expectedLength;
        assert (flattenedArray != null);
        if (checkdimensions && flattenedArray.length != (expectedLength = MDDoubleArray.getLength(dimensions, 0))) {
            throw new IllegalArgumentException("Actual array length " + flattenedArray.length + " does not match expected length " + expectedLength + ".");
        }
        this.flattenedArray = flattenedArray;
    }

    public MDDoubleArray(double[][] matrix) {
        this(matrix, MDDoubleArray.getDimensions(matrix));
    }

    public MDDoubleArray(double[][] matrix, int[] dimensions) {
        super(dimensions, 0, matrix.length);
        int sizeX = dimensions[0];
        int sizeY = dimensions[1];
        int length = MDDoubleArray.getLength(dimensions, 0);
        this.flattenedArray = new double[length];
        int i = 0;
        while (i < sizeX) {
            System.arraycopy(matrix[i], 0, this.flattenedArray, i * sizeY, sizeY);
            ++i;
        }
    }

    private static int[] getDimensions(double[][] matrix) {
        assert (matrix != null);
        return new int[]{matrix.length, matrix.length == 0 ? 0 : matrix[0].length};
    }

    @Override
    public int capacity() {
        return this.flattenedArray.length;
    }

    @Override
    public Double getAsObject(int ... indices) {
        return this.get(indices);
    }

    @Override
    public void setToObject(Double value, int ... indices) {
        this.set((double)value, indices);
    }

    @Override
    public Double getAsObject(int linearIndex) {
        return this.get(linearIndex);
    }

    @Override
    public void setToObject(Double value, int linearIndex) {
        this.set((double)value, linearIndex);
    }

    public double[] getAsFlatArray() {
        return this.flattenedArray;
    }

    public double[] getCopyAsFlatArray() {
        return ArrayUtils.subarray(this.flattenedArray, 0, this.dimensions[0] * this.hyperRowLength);
    }

    @Override
    protected void adaptCapacityHyperRows() {
        double[] oldArray = this.flattenedArray;
        this.flattenedArray = new double[this.capacityHyperRows * this.hyperRowLength];
        System.arraycopy(oldArray, 0, this.flattenedArray, 0, Math.min(oldArray.length, this.flattenedArray.length));
    }

    public double get(int ... indices) {
        return this.flattenedArray[this.computeIndex(indices)];
    }

    public double get(int index) {
        return this.flattenedArray[index];
    }

    public double get(int indexX, int indexY) {
        return this.flattenedArray[this.computeIndex(indexX, indexY)];
    }

    public double get(int indexX, int indexY, int indexZ) {
        return this.flattenedArray[this.computeIndex(indexX, indexY, indexZ)];
    }

    public void set(double value, int ... indices) {
        this.flattenedArray[this.computeIndex((int[])indices)] = value;
    }

    public void set(double value, int index) {
        this.flattenedArray[index] = value;
    }

    public void set(double value, int indexX, int indexY) {
        this.flattenedArray[this.computeIndex((int)indexX, (int)indexY)] = value;
    }

    public void set(double value, int indexX, int indexY, int indexZ) {
        this.flattenedArray[this.computeIndex((int)indexX, (int)indexY, (int)indexZ)] = value;
    }

    public double[][] toMatrix() {
        int sizeX = this.dimensions[0];
        int sizeY = this.dimensions[1];
        double[][] result = new double[sizeX][sizeY];
        int i = 0;
        while (i < sizeX) {
            System.arraycopy(this.flattenedArray, i * sizeY, result[i], 0, sizeY);
            ++i;
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.getValuesAsFlatArray());
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MDDoubleArray other = (MDDoubleArray)obj;
        if (!Arrays.equals(this.getValuesAsFlatArray(), other.getValuesAsFlatArray())) {
            return false;
        }
        return Arrays.equals(this.dimensions, other.dimensions);
    }

    private double[] getValuesAsFlatArray() {
        return this.dimensions[0] < this.capacityHyperRows ? this.getCopyAsFlatArray() : this.getAsFlatArray();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.hyperRowLength == 0) {
            this.hyperRowLength = this.computeHyperRowLength(this.dimensions);
        }
        if (this.capacityHyperRows == 0) {
            this.capacityHyperRows = this.dimensions[0];
        }
        if (this.size == 0) {
            this.size = this.hyperRowLength * this.dimensions[0];
        }
    }
}

