/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.gtp.GtpUtils;
import net.sf.gogui.gui.AnalyzeCommand;
import net.sf.gogui.gui.GuiBoard;
import net.sf.gogui.gui.GuiBoardUtils;
import net.sf.gogui.utils.StringUtils;

public final class AnalyzeShow {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String show(AnalyzeCommand analyzeCommand, GuiBoard guiBoard, Board board, String string) throws GtpError {
        GoPoint goPoint = analyzeCommand.getPointArg();
        ArrayList arrayList = analyzeCommand.getPointListArg();
        guiBoard.clearAllSelect();
        GuiBoardUtils.setSelect(guiBoard, arrayList, true);
        if (goPoint != null) {
            guiBoard.setSelect(goPoint, true);
        }
        int n = analyzeCommand.getType();
        int n2 = board.getSize();
        String string2 = null;
        switch (n) {
            case 0: {
                String[][] stringArray = GtpUtils.parseStringBoard((String)string, (int)n2);
                GuiBoardUtils.showBWBoard(guiBoard, stringArray);
                break;
            }
            case 1: {
                String[][] stringArray = GtpUtils.parseStringBoard((String)string, (int)n2);
                GuiBoardUtils.showColorBoard(guiBoard, stringArray);
                break;
            }
            case 2: {
                double[][] dArray = GtpUtils.parseDoubleBoard((String)string, (int)n2);
                GuiBoardUtils.showDoubleBoard(guiBoard, dArray);
                break;
            }
            case 4: {
                string2 = AnalyzeShow.showGfx(string, guiBoard);
                break;
            }
            case 9: {
                GoPoint[] goPointArray = GtpUtils.parsePointList((String)string, (int)n2);
                GuiBoardUtils.showPointList(guiBoard, goPointArray);
                break;
            }
            case 6: 
            case 10: {
                GoPoint[] goPointArray = GtpUtils.parsePointString((String)string, (int)n2);
                GuiBoardUtils.showPointList(guiBoard, goPointArray);
                break;
            }
            case 11: {
                ArrayList arrayList2 = new ArrayList(32);
                ArrayList arrayList3 = new ArrayList(32);
                GtpUtils.parsePointStringList((String)string, arrayList2, arrayList3, (int)n2);
                GuiBoardUtils.showPointStringList(guiBoard, arrayList2, arrayList3);
                break;
            }
            case 13: {
                String[][] stringArray = GtpUtils.parseStringBoard((String)string, (int)n2);
                GuiBoardUtils.showStringBoard(guiBoard, stringArray);
                break;
            }
            case 14: {
                AnalyzeShow.showVariation(guiBoard, string, board.getToMove());
                break;
            }
            case 15: {
                AnalyzeShow.showVariation(guiBoard, string, GoColor.BLACK);
                break;
            }
            case 16: {
                AnalyzeShow.showVariation(guiBoard, string, analyzeCommand.getColorArg());
                break;
            }
            case 19: {
                AnalyzeShow.showVariation(guiBoard, string, GoColor.WHITE);
                break;
            }
            case 17: {
                GoColor goColor = AnalyzeShow.getColor(board, goPoint, arrayList);
                if (goColor == GoColor.EMPTY) break;
                AnalyzeShow.showVariation(guiBoard, string, goColor);
                break;
            }
            case 18: {
                GoColor goColor = AnalyzeShow.getColor(board, goPoint, arrayList);
                if (goColor == GoColor.EMPTY) break;
                AnalyzeShow.showVariation(guiBoard, string, goColor.otherColor());
                break;
            }
        }
        return string2;
    }

    public static String showGfx(String string, GuiBoard guiBoard) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        String string2 = null;
        while (true) {
            String string3;
            try {
                string3 = bufferedReader.readLine();
            }
            catch (IOException iOException) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
            if (string3 == null) break;
            String string4 = AnalyzeShow.showGfxLine(string3, guiBoard);
            if (string4 == null) continue;
            string2 = string4;
        }
        return string2;
    }

    public static void showGfxCircle(String[] stringArray, GuiBoard guiBoard) {
        int n = guiBoard.getBoardSize();
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                GoPoint goPoint = GoPoint.parsePoint(stringArray[i], n);
                if (goPoint == null) continue;
                guiBoard.setMarkCircle(goPoint, true);
                continue;
            }
            catch (GoPoint.InvalidPoint invalidPoint) {
                // empty catch block
            }
        }
    }

    public static void showGfxColor(String[] stringArray, GuiBoard guiBoard) {
        if (stringArray.length < 2) {
            return;
        }
        int n = guiBoard.getBoardSize();
        Color color = GuiBoardUtils.getColor(stringArray[1]);
        for (int i = 2; i < stringArray.length; ++i) {
            try {
                GoPoint goPoint = GoPoint.parsePoint(stringArray[i], n);
                if (goPoint == null) continue;
                guiBoard.setFieldBackground(goPoint, color);
                continue;
            }
            catch (GoPoint.InvalidPoint invalidPoint) {
                // empty catch block
            }
        }
    }

    public static void showGfxInfluence(String[] stringArray, GuiBoard guiBoard) {
        int n = guiBoard.getBoardSize();
        for (int i = 1; i < stringArray.length; i += 2) {
            try {
                GoPoint goPoint = GoPoint.parsePoint(stringArray[i], n);
                if (i + 1 >= stringArray.length) break;
                if (goPoint == null) continue;
                double d = Double.parseDouble(stringArray[i + 1]);
                guiBoard.setInfluence(goPoint, d);
                continue;
            }
            catch (GoPoint.InvalidPoint invalidPoint) {
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static void showGfxLabel(String[] stringArray, GuiBoard guiBoard) {
        int n = guiBoard.getBoardSize();
        for (int i = 1; i < stringArray.length; i += 2) {
            try {
                GoPoint goPoint = GoPoint.parsePoint(stringArray[i], n);
                if (i + 1 >= stringArray.length) break;
                if (goPoint == null) continue;
                guiBoard.setLabel(goPoint, stringArray[i + 1]);
                continue;
            }
            catch (GoPoint.InvalidPoint invalidPoint) {
                // empty catch block
            }
        }
    }

    public static String showGfxLine(String string, GuiBoard guiBoard) {
        String[] stringArray = StringUtils.splitArguments(string);
        if (stringArray.length == 0) {
            return null;
        }
        String string2 = null;
        String string3 = stringArray[0].toUpperCase();
        if (string3.equals("BLACK")) {
            AnalyzeShow.showGfxTerritory(stringArray, GoColor.BLACK, guiBoard);
        } else if (string3.equals("CIRCLE")) {
            AnalyzeShow.showGfxCircle(stringArray, guiBoard);
        } else if (string3.equals("CLEAR")) {
            guiBoard.clearAll();
        } else if (string3.equals("COLOR")) {
            AnalyzeShow.showGfxColor(stringArray, guiBoard);
        } else if (string3.equals("INFLUENCE")) {
            AnalyzeShow.showGfxInfluence(stringArray, guiBoard);
        } else if (string3.equals("LABEL")) {
            AnalyzeShow.showGfxLabel(stringArray, guiBoard);
        } else if (string3.equals("MARK")) {
            AnalyzeShow.showGfxMark(stringArray, guiBoard);
        } else if (string3.equals("SQUARE")) {
            AnalyzeShow.showGfxSquare(stringArray, guiBoard);
        } else if (string3.equals("TEXT")) {
            int n = (string = string.trim()).indexOf(32);
            if (n > 0) {
                string2 = string.substring(n + 1);
            }
        } else if (string3.equals("TRIANGLE")) {
            AnalyzeShow.showGfxTriangle(stringArray, guiBoard);
        } else if (string3.equals("VAR")) {
            AnalyzeShow.showGfxVariation(stringArray, guiBoard);
        } else if (string3.equals("WHITE")) {
            AnalyzeShow.showGfxTerritory(stringArray, GoColor.WHITE, guiBoard);
        }
        return string2;
    }

    public static void showGfxMark(String[] stringArray, GuiBoard guiBoard) {
        int n = guiBoard.getBoardSize();
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                GoPoint goPoint = GoPoint.parsePoint(stringArray[i], n);
                if (goPoint == null) continue;
                guiBoard.setMark(goPoint, true);
                continue;
            }
            catch (GoPoint.InvalidPoint invalidPoint) {
                // empty catch block
            }
        }
    }

    public static void showGfxSquare(String[] stringArray, GuiBoard guiBoard) {
        int n = guiBoard.getBoardSize();
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                GoPoint goPoint = GoPoint.parsePoint(stringArray[i], n);
                if (goPoint == null) continue;
                guiBoard.setMarkSquare(goPoint, true);
                continue;
            }
            catch (GoPoint.InvalidPoint invalidPoint) {
                // empty catch block
            }
        }
    }

    public static void showGfxTriangle(String[] stringArray, GuiBoard guiBoard) {
        int n = guiBoard.getBoardSize();
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                GoPoint goPoint = GoPoint.parsePoint(stringArray[i], n);
                if (goPoint == null) continue;
                guiBoard.setMarkTriangle(goPoint, true);
                continue;
            }
            catch (GoPoint.InvalidPoint invalidPoint) {
                // empty catch block
            }
        }
    }

    public static void showGfxTerritory(String[] stringArray, GoColor goColor, GuiBoard guiBoard) {
        int n = guiBoard.getBoardSize();
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                GoPoint goPoint = GoPoint.parsePoint(stringArray[i], n);
                if (goPoint == null) continue;
                guiBoard.setTerritory(goPoint, goColor);
                continue;
            }
            catch (GoPoint.InvalidPoint invalidPoint) {
                // empty catch block
            }
        }
    }

    public static void showGfxVariation(String[] stringArray, GuiBoard guiBoard) {
        int n = guiBoard.getBoardSize();
        int n2 = 0;
        for (int i = 1; i < stringArray.length; i += 2) {
            try {
                GoColor goColor;
                if (stringArray[i].equalsIgnoreCase("b")) {
                    goColor = GoColor.BLACK;
                } else {
                    if (!stringArray[i].equalsIgnoreCase("w")) break;
                    goColor = GoColor.WHITE;
                }
                if (i + 1 >= stringArray.length) break;
                GoPoint goPoint = GoPoint.parsePoint(stringArray[i + 1], n);
                ++n2;
                if (goPoint == null) continue;
                guiBoard.setColor(goPoint, goColor);
                guiBoard.setLabel(goPoint, Integer.toString(n2));
                continue;
            }
            catch (GoPoint.InvalidPoint invalidPoint) {
                // empty catch block
            }
        }
    }

    private AnalyzeShow() {
    }

    private static GoColor getColor(Board board, GoPoint goPoint, ArrayList arrayList) {
        GoPoint goPoint2;
        GoColor goColor = GoColor.EMPTY;
        if (goPoint != null) {
            goColor = board.getColor(goPoint);
        }
        if (goColor != GoColor.EMPTY) {
            return goColor;
        }
        for (int i = 0; i < arrayList.size() && (goColor = board.getColor(goPoint2 = (GoPoint)arrayList.get(i))) == GoColor.EMPTY; ++i) {
        }
        return goColor;
    }

    private static void showVariation(GuiBoard guiBoard, String string, GoColor goColor) {
        int n = guiBoard.getBoardSize();
        Move[] moveArray = GtpUtils.parseVariation((String)string, (GoColor)goColor, (int)n);
        GuiBoardUtils.showVariation(guiBoard, moveArray);
    }

    static {
        $assertionsDisabled = !AnalyzeShow.class.desiredAssertionStatus();
    }
}

