/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.utils;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class RadialGradientContext
implements PaintContext {
    private final int m_red1;
    private final int m_redDiff;
    private final int m_green1;
    private final int m_greenDiff;
    private final int m_blue1;
    private final int m_blueDiff;
    private final int m_alpha1;
    private final int m_alphaDiff;
    private int m_x;
    private int m_y;
    private int m_height;
    private int m_width;
    private final double m_radius;
    private final Point2D m_point;
    private WritableRaster m_raster;

    public RadialGradientContext(Point2D point2D, Color color, Point2D point2D2, Color color2) {
        this.m_point = point2D;
        this.m_red1 = color.getRed();
        this.m_green1 = color.getGreen();
        this.m_blue1 = color.getBlue();
        this.m_alpha1 = color.getAlpha();
        this.m_radius = point2D2.distance(0.0, 0.0);
        this.m_redDiff = color2.getRed() - this.m_red1;
        this.m_greenDiff = color2.getGreen() - this.m_green1;
        this.m_blueDiff = color2.getBlue() - this.m_blue1;
        this.m_alphaDiff = color2.getAlpha() - this.m_alpha1;
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        if (this.m_raster != null && n == this.m_x && n2 == this.m_y && n3 == this.m_width && n4 == this.m_height) {
            return this.m_raster;
        }
        this.m_x = n;
        this.m_y = n2;
        this.m_height = n4;
        this.m_width = n3;
        ColorModel colorModel = this.getColorModel();
        this.m_raster = colorModel.createCompatibleWritableRaster(n3, n4);
        int[] nArray = new int[n3 * n4 * 4];
        int n5 = -1;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                double d = this.m_point.distance(n + j, n2 + i);
                double d2 = Math.min(d / this.m_radius, 1.0);
                nArray[++n5] = (int)((double)this.m_red1 + d2 * (double)this.m_redDiff);
                nArray[++n5] = (int)((double)this.m_green1 + d2 * (double)this.m_greenDiff);
                nArray[++n5] = (int)((double)this.m_blue1 + d2 * (double)this.m_blueDiff);
                nArray[++n5] = (int)((double)this.m_alpha1 + d2 * (double)this.m_alphaDiff);
            }
        }
        this.m_raster.setPixels(0, 0, n3, n4, nArray);
        return this.m_raster;
    }
}

