################################################################################
#    iGMT: Interactive Mapping of Geoscientific Datasets.                      #
#               Easy access to GMT via a Tcl/Tk GUI                            #
#                                                                              #
#    Copyright (C) 1998 - 2000 Thorsten W. Becker, Alexander Braun             #
#                                                                              #
#    This program is free software; you can redistribute it and/or modify      #
#    it under the terms of the GNU General Public License as published by      #
#    the Free Software Foundation; either version 2 of the License, or         #
#    (at your option) any later version.                                       #
#                                                                              #
#    This program is distributed in the hope that it will be useful,           #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#    GNU General Public License for more details.                              #
#                                                                              #
#    In addition, iGMT is not to be used for any military purposes or          #
#    for any other activities that are against the spirit as expressed         #
#    in the Student Pugwash Pledge (www.spusa.org/pugwash/pledge.html).        #
#                                                                              #
#    You should have received a copy of the GNU General Public License         #
#    along with this program; see the file COPYING.  If not, write to          #
#    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,          #
#    Boston, MA 02111-1307, USA.                                               #
#                                                                              #
################################################################################

################################################################################
# igmt_init.tcl -- startup procedures
#
# part of the iGMT package
#
################################################################################

# create some of the files as empty, make the future  script executable
# and check for write permissions

if { [catch "[ list exec touch $batcherr]" var ] } {
    puts "iGMT: Can't create $batcherr."
    puts "iGMT: Please make sure that you have write permission, e.g."
    puts "iGMT: change to your home directory."
    exit -1 
}
if { [catch "[ list exec touch $batchfile]" var ] } {
    puts "iGMT: Can't create $batchfile."
    puts "iGMT: Please make sure that you have write permission, e.g."
    puts "iGMT: change to your home directory."
    exit -1 
}

exec chmod u+x $batchfile

# temporarily move the $env(PWD)/.gmtdefault file (if there is one) 
# and tell the user later in the igmt.tcl file
# Otherwise, put a standard .gmtdefaults file temporarily in the current directory

set changed_gmtdefaults  [ exec $igmt_root/igmt_helper_handle_gmtdefaults 1 $igmt_root 0 $gmt_version ]




