;;;
;;; irchat-pj-specific-nemacs.el
;;; last modify : Thu, 28 Oct 1999 00:04:46 +0900
;;;               by simm@irc.fan.gr.jp / irchat-PJ Project
;;; (date format modification by simm@irc.fan.gr.jp, Sun, 27 Jun 1999)
;;; see file irchat-copyright.el for change log and copyright info
;;;

;; load defsubst

(or (fboundp 'defsubst)
    (fset 'defsubst 'defun))

;;; for irchat-pj-coding-system.el

;; define service / set process

(defsubst irchat-pj-define-service-coding-system (service)
  (define-service-kanji-code service nil 0))

(defsubst irchat-pj-set-process-coding-system (proc)
  (set-process-kanji-code proc 0))

;; output functions

(defsubst irchat-pj-string-out-iso-2022-jp (str)
  (let ((orig-to-ascii-process to-ascii-process)
	(orig-to-kanji-process to-kanji-process))
    (setq to-ascii-process ?B)
    (setq to-kanji-process ?B)
    (setq str (convert-string-kanji-code str 3 2))
    (setq to-ascii-process orig-to-ascii-process)
    (setq to-kanji-process orig-to-kanji-process)
    str))

(fset 'irchat-pj-string-out-iso-2022-7bit-ss2
      'irchat-pj-string-out-iso-2022-jp)

(defsubst irchat-pj-string-out-euc-jp (str)
  str)

(defsubst irchat-pj-string-out-sjis (str)
  (let ((orig-to-ascii-process to-ascii-process)
	(orig-to-kanji-process to-kanji-process))
    (setq to-ascii-process ?B)
    (setq to-kanji-process ?B)
    (setq str (convert-string-kanji-code str 3 1))
    (setq to-ascii-process orig-to-ascii-process)
    (setq to-kanji-process orig-to-kanji-process)
    str))

;; input functions

(defsubst irchat-pj-string-in-iso-2022-jp (str)
  (convert-string-kanji-code str 2 3))

(fset 'irchat-pj-string-in-iso-2022-7bit-ss2
      'irchat-pj-string-in-iso-2022-jp)

(defsubst irchat-pj-string-in-euc-jp-internal (str)
  str)

(defsubst irchat-pj-string-in-sjis-internal (str)
  (convert-string-kanji-code str 1 3))

;;; for irchat-pj-version-string.el

(defun irchat-pj-set-emacs-version-string ()
  "Set Emacs version string for CTCP VERSION"
  (concat "NEmacs " nemacs-version " based on Emacs " emacs-version))

(provide 'irchat-pj-specific-nemacs)

;;;
;;; end
;;;
