require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_DEV_ATA_ATAVAR_H_)) {
    eval 'sub _DEV_ATA_ATAVAR_H_ () {1;}' unless defined(&_DEV_ATA_ATAVAR_H_);
    require 'sys/lock.ph';
    require 'sys/queue.ph';
    require 'dev/ata/ataconf.ph';
    require 'dev/scsipi/scsipi_all.ph';
    require 'dev/scsipi/atapiconf.ph';
    eval 'sub ATA_POLL () {0x2;}' unless defined(&ATA_POLL);
    eval 'sub ATA_ITSDONE () {0x4;}' unless defined(&ATA_ITSDONE);
    eval 'sub ATA_SINGLE () {0x8;}' unless defined(&ATA_SINGLE);
    eval 'sub ATA_LBA () {0x10;}' unless defined(&ATA_LBA);
    eval 'sub ATA_READ () {0x20;}' unless defined(&ATA_READ);
    eval 'sub ATA_CORR () {0x40;}' unless defined(&ATA_CORR);
    eval 'sub ATA_LBA48 () {0x80;}' unless defined(&ATA_LBA48);
    eval 'sub ATA_FUA () {0x100;}' unless defined(&ATA_FUA);
    eval 'sub ATA_PRIO_HIGH () {0x200;}' unless defined(&ATA_PRIO_HIGH);
    eval 'sub NOERROR () {0;}' unless defined(&NOERROR);
    eval 'sub ERROR () {1;}' unless defined(&ERROR);
    eval 'sub ERR_DF () {2;}' unless defined(&ERR_DF);
    eval 'sub ERR_DMA () {3;}' unless defined(&ERR_DMA);
    eval 'sub TIMEOUT () {4;}' unless defined(&TIMEOUT);
    eval 'sub ERR_NODEV () {5;}' unless defined(&ERR_NODEV);
    eval 'sub ERR_RESET () {6;}' unless defined(&ERR_RESET);
    eval 'sub REQUEUE () {7;}' unless defined(&REQUEUE);
    eval 'sub AT_READ () {0x1;}' unless defined(&AT_READ);
    eval 'sub AT_WRITE () {0x2;}' unless defined(&AT_WRITE);
    eval 'sub AT_WAIT () {0x8;}' unless defined(&AT_WAIT);
    eval 'sub AT_POLL () {0x10;}' unless defined(&AT_POLL);
    eval 'sub AT_DONE () {0x20;}' unless defined(&AT_DONE);
    eval 'sub AT_XFDONE () {0x40;}' unless defined(&AT_XFDONE);
    eval 'sub AT_ERROR () {0x80;}' unless defined(&AT_ERROR);
    eval 'sub AT_TIMEOU () {0x100;}' unless defined(&AT_TIMEOU);
    eval 'sub AT_DF () {0x200;}' unless defined(&AT_DF);
    eval 'sub AT_RESET () {0x400;}' unless defined(&AT_RESET);
    eval 'sub AT_GONE () {0x800;}' unless defined(&AT_GONE);
    eval 'sub AT_READREG () {0x1000;}' unless defined(&AT_READREG);
    eval 'sub AT_LBA () {0x2000;}' unless defined(&AT_LBA);
    eval 'sub AT_LBA48 () {0x4000;}' unless defined(&AT_LBA48);
    eval 'sub ATACH_ERR_ST {
        my($error, $status) = @_;
	    eval q((($error) << 8| ($status)));
    }' unless defined(&ATACH_ERR_ST);
    eval 'sub ATACH_ERR {
        my($val) = @_;
	    eval q(((($val) >> 8) & 0xff));
    }' unless defined(&ATACH_ERR);
    eval 'sub ATACH_ST {
        my($val) = @_;
	    eval q(((($val) >> 0) & 0xff));
    }' unless defined(&ATACH_ST);
    eval 'sub c_bio () { ($u->{c_bio});}' unless defined(&c_bio);
    eval 'sub c_ata_c () { ($u->{c_ata_c});}' unless defined(&c_ata_c);
    eval 'sub c_atapi () { ($u->{atapi});}' unless defined(&c_atapi);
    eval 'sub c_scsipi () { ($c_atapi->{c_scsipi});}' unless defined(&c_scsipi);
    eval 'sub ATASTART_STARTED () {0;}' unless defined(&ATASTART_STARTED);
    eval 'sub ATASTART_TH () {1;}' unless defined(&ATASTART_TH);
    eval 'sub ATASTART_POLL () {2;}' unless defined(&ATASTART_POLL);
    eval 'sub ATASTART_ABORT () {3;}' unless defined(&ATASTART_ABORT);
    eval 'sub ATAPOLL_DONE () {0;}' unless defined(&ATAPOLL_DONE);
    eval 'sub ATAPOLL_AGAIN () {1;}' unless defined(&ATAPOLL_AGAIN);
    eval 'sub C_ATAPI () {0x1;}' unless defined(&C_ATAPI);
    eval 'sub C_TIMEOU () {0x2;}' unless defined(&C_TIMEOU);
    eval 'sub C_POLL () {0x4;}' unless defined(&C_POLL);
    eval 'sub C_DMA () {0x8;}' unless defined(&C_DMA);
    eval 'sub C_WAIT () {0x10;}' unless defined(&C_WAIT);
    eval 'sub C_WAITACT () {0x20;}' unless defined(&C_WAITACT);
    eval 'sub C_FREE () {0x40;}' unless defined(&C_FREE);
    eval 'sub C_PIOBM () {0x80;}' unless defined(&C_PIOBM);
    eval 'sub C_NCQ () {0x100;}' unless defined(&C_NCQ);
    eval 'sub C_SKIP_QUEUE () {0x200;}' unless defined(&C_SKIP_QUEUE);
    eval 'sub C_WAITTIMO () {0x400;}' unless defined(&C_WAITTIMO);
    eval 'sub C_CHAOS () {0x800;}' unless defined(&C_CHAOS);
    eval 'sub C_RECOVERED () {0x1000;}' unless defined(&C_RECOVERED);
    eval 'sub C_PRIVATE_ALLOC () {0x2000;}' unless defined(&C_PRIVATE_ALLOC);
    eval 'sub KILL_GONE () {1;}' unless defined(&KILL_GONE);
    eval 'sub KILL_RESET () {2;}' unless defined(&KILL_RESET);
    eval 'sub KILL_GONE_INACTIVE () {3;}' unless defined(&KILL_GONE_INACTIVE);
    eval 'sub KILL_REQUEUE () {4;}' unless defined(&KILL_REQUEUE);
    eval 'sub ATA_MAX_OPENINGS () {32;}' unless defined(&ATA_MAX_OPENINGS);
    eval 'sub ATA_REAL_OPENINGS {
        my($op) = @_;
	    eval q((($op) > 1? ($op) - 1: 1));
    }' unless defined(&ATA_REAL_OPENINGS);
    eval 'sub ATA_BSIZE () {512;}' unless defined(&ATA_BSIZE);
    unless(defined(&ATABUS_PRIVATE)) {
    } else {
	eval 'sub QF_IDLE_WAIT () {0x1;}' unless defined(&QF_IDLE_WAIT);
	eval 'sub QF_NEED_XFER () {0x2;}' unless defined(&QF_NEED_XFER);
    }
    eval 'sub ATABUSCF_OPEN () {0x1;}' unless defined(&ATABUSCF_OPEN);
    eval 'sub ATA_DRIVE_CAP32 () {0x1;}' unless defined(&ATA_DRIVE_CAP32);
    eval 'sub ATA_DRIVE_DMA () {0x2;}' unless defined(&ATA_DRIVE_DMA);
    eval 'sub ATA_DRIVE_UDMA () {0x4;}' unless defined(&ATA_DRIVE_UDMA);
    eval 'sub ATA_DRIVE_MODE () {0x8;}' unless defined(&ATA_DRIVE_MODE);
    eval 'sub ATA_DRIVE_RESET () {0x10;}' unless defined(&ATA_DRIVE_RESET);
    eval 'sub ATA_DRIVE_WAITDRAIN () {0x20;}' unless defined(&ATA_DRIVE_WAITDRAIN);
    eval 'sub ATA_DRIVE_NOSTREAM () {0x40;}' unless defined(&ATA_DRIVE_NOSTREAM);
    eval 'sub ATA_DRIVE_ATAPIDSCW () {0x80;}' unless defined(&ATA_DRIVE_ATAPIDSCW);
    eval 'sub ATA_DRIVE_WFUA () {0x100;}' unless defined(&ATA_DRIVE_WFUA);
    eval 'sub ATA_DRIVE_NCQ () {0x200;}' unless defined(&ATA_DRIVE_NCQ);
    eval 'sub ATA_DRIVE_NCQ_PRIO () {0x400;}' unless defined(&ATA_DRIVE_NCQ_PRIO);
    eval 'sub ATA_DRIVE_TH_RESET () {0x800;}' unless defined(&ATA_DRIVE_TH_RESET);
    eval 'sub ATA_DRIVET_NONE () {0;}' unless defined(&ATA_DRIVET_NONE);
    eval 'sub ATA_DRIVET_ATA () {1;}' unless defined(&ATA_DRIVET_ATA);
    eval 'sub ATA_DRIVET_ATAPI () {2;}' unless defined(&ATA_DRIVET_ATAPI);
    eval 'sub ATA_DRIVET_OLD () {3;}' unless defined(&ATA_DRIVET_OLD);
    eval 'sub ATA_DRIVET_PM () {4;}' unless defined(&ATA_DRIVET_PM);
    if((defined(&NATA_DMA) ? &NATA_DMA : undef)) {
	if((defined(&NATA_UDMA) ? &NATA_UDMA : undef)) {
	}
    }
    if((defined(&NATA_DMA) ? &NATA_DMA : undef)) {
	if((defined(&NATA_UDMA) ? &NATA_UDMA : undef)) {
	}
    }
    eval 'sub RESET () {0;}' unless defined(&RESET);
    eval 'sub READY () {1;}' unless defined(&READY);
    if((defined(&NATA_DMA) ? &NATA_DMA : undef)) {
	eval 'sub NERRS_MAX () {4;}' unless defined(&NERRS_MAX);
	eval 'sub NXFER () {4000;}' unless defined(&NXFER);
    }
    eval 'sub ATA_CONFIG_PIO_MODES () {0x7;}' unless defined(&ATA_CONFIG_PIO_MODES);
    eval 'sub ATA_CONFIG_PIO_SET () {0x8;}' unless defined(&ATA_CONFIG_PIO_SET);
    eval 'sub ATA_CONFIG_PIO_OFF () {0;}' unless defined(&ATA_CONFIG_PIO_OFF);
    eval 'sub ATA_CONFIG_DMA_MODES () {0x70;}' unless defined(&ATA_CONFIG_DMA_MODES);
    eval 'sub ATA_CONFIG_DMA_SET () {0x80;}' unless defined(&ATA_CONFIG_DMA_SET);
    eval 'sub ATA_CONFIG_DMA_DISABLE () {0x70;}' unless defined(&ATA_CONFIG_DMA_DISABLE);
    eval 'sub ATA_CONFIG_DMA_OFF () {4;}' unless defined(&ATA_CONFIG_DMA_OFF);
    eval 'sub ATA_CONFIG_UDMA_MODES () {0x700;}' unless defined(&ATA_CONFIG_UDMA_MODES);
    eval 'sub ATA_CONFIG_UDMA_SET () {0x800;}' unless defined(&ATA_CONFIG_UDMA_SET);
    eval 'sub ATA_CONFIG_UDMA_DISABLE () {0x700;}' unless defined(&ATA_CONFIG_UDMA_DISABLE);
    eval 'sub ATA_CONFIG_UDMA_OFF () {8;}' unless defined(&ATA_CONFIG_UDMA_OFF);
    eval 'sub ATACMD_COMPLETE () {0x1;}' unless defined(&ATACMD_COMPLETE);
    eval 'sub ATACMD_QUEUED () {0x2;}' unless defined(&ATACMD_QUEUED);
    eval 'sub ATACMD_TRY_AGAIN () {0x3;}' unless defined(&ATACMD_TRY_AGAIN);
    eval 'sub SCSIPI_BUSTYPE_ATA () {2;}' unless defined(&SCSIPI_BUSTYPE_ATA);
    eval 'sub ATACH_SHUTDOWN () {0x2;}' unless defined(&ATACH_SHUTDOWN);
    eval 'sub ATACH_IRQ_WAIT () {0x10;}' unless defined(&ATACH_IRQ_WAIT);
    eval 'sub ATACH_DMA_WAIT () {0x20;}' unless defined(&ATACH_DMA_WAIT);
    eval 'sub ATACH_PIOBM_WAIT () {0x40;}' unless defined(&ATACH_PIOBM_WAIT);
    eval 'sub ATACH_DISABLED () {0x80;}' unless defined(&ATACH_DISABLED);
    eval 'sub ATACH_TH_RUN () {0x100;}' unless defined(&ATACH_TH_RUN);
    eval 'sub ATACH_TH_RESET () {0x200;}' unless defined(&ATACH_TH_RESET);
    eval 'sub ATACH_TH_RESCAN () {0x400;}' unless defined(&ATACH_TH_RESCAN);
    eval 'sub ATACH_NCQ () {0x800;}' unless defined(&ATACH_NCQ);
    eval 'sub ATACH_DMA_BEFORE_CMD () {0x1000;}' unless defined(&ATACH_DMA_BEFORE_CMD);
    eval 'sub ATACH_TH_DRIVE_RESET () {0x2000;}' unless defined(&ATACH_TH_DRIVE_RESET);
    eval 'sub ATACH_RECOVERING () {0x4000;}' unless defined(&ATACH_RECOVERING);
    eval 'sub ATACH_TH_RECOVERY () {0x8000;}' unless defined(&ATACH_TH_RECOVERY);
    eval 'sub ATACH_DETACHED () {0x10000;}' unless defined(&ATACH_DETACHED);
    eval 'sub ATACH_NODRIVE () {0xff;}' unless defined(&ATACH_NODRIVE);
    eval 'sub ATAC_CAP_DATA16 () {0x1;}' unless defined(&ATAC_CAP_DATA16);
    eval 'sub ATAC_CAP_DATA32 () {0x2;}' unless defined(&ATAC_CAP_DATA32);
    eval 'sub ATAC_CAP_DMA () {0x8;}' unless defined(&ATAC_CAP_DMA);
    eval 'sub ATAC_CAP_UDMA () {0x10;}' unless defined(&ATAC_CAP_UDMA);
    eval 'sub ATAC_CAP_PIOBM () {0x20;}' unless defined(&ATAC_CAP_PIOBM);
    eval 'sub ATAC_CAP_ATA_NOSTREAM () {0x40;}' unless defined(&ATAC_CAP_ATA_NOSTREAM);
    eval 'sub ATAC_CAP_ATAPI_NOSTREAM () {0x80;}' unless defined(&ATAC_CAP_ATAPI_NOSTREAM);
    eval 'sub ATAC_CAP_NOIRQ () {0x1000;}' unless defined(&ATAC_CAP_NOIRQ);
    eval 'sub ATAC_CAP_RAID () {0x4000;}' unless defined(&ATAC_CAP_RAID);
    eval 'sub ATAC_CAP_NCQ () {0x8000;}' unless defined(&ATAC_CAP_NCQ);
    if((defined(&NATA_DMA) ? &NATA_DMA : undef)) {
	if((defined(&NATA_UDMA) ? &NATA_UDMA : undef)) {
	}
    }
    if(defined(&_KERNEL)) {
	eval 'sub CMD_OK () {0;}' unless defined(&CMD_OK);
	eval 'sub CMD_ERR () {1;}' unless defined(&CMD_ERR);
	eval 'sub CMD_AGAIN () {2;}' unless defined(&CMD_AGAIN);
	if((defined(&NATA_DMA) ? &NATA_DMA : undef)) {
	}
	if((defined(&NATA_DMA) ? &NATA_DMA : undef)) {
	}
	if(defined(&ATADEBUG)) {
	}
    }
}
1;
