require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_NET80211_IEEE80211_NODE_H_)) {
    eval 'sub _NET80211_IEEE80211_NODE_H_ () {1;}' unless defined(&_NET80211_IEEE80211_NODE_H_);
    require 'sys/atomic.ph';
    require 'net80211/ieee80211_netbsd.ph';
    require 'net80211/ieee80211_ioctl.ph';
    if(defined(&_KERNEL)) {
	eval 'sub IEEE80211_INACT_WAIT () {15;}' unless defined(&IEEE80211_INACT_WAIT);
	eval 'sub IEEE80211_INACT_INIT () {(30/ &IEEE80211_INACT_WAIT);}' unless defined(&IEEE80211_INACT_INIT);
	eval 'sub IEEE80211_INACT_AUTH () {(180/ &IEEE80211_INACT_WAIT);}' unless defined(&IEEE80211_INACT_AUTH);
	eval 'sub IEEE80211_INACT_RUN () {(300/ &IEEE80211_INACT_WAIT);}' unless defined(&IEEE80211_INACT_RUN);
	eval 'sub IEEE80211_INACT_PROBE () {(30/ &IEEE80211_INACT_WAIT);}' unless defined(&IEEE80211_INACT_PROBE);
	eval 'sub IEEE80211_INACT_SCAN () {(300/ &IEEE80211_INACT_WAIT);}' unless defined(&IEEE80211_INACT_SCAN);
	eval 'sub IEEE80211_TRANS_WAIT () {5;}' unless defined(&IEEE80211_TRANS_WAIT);
	eval 'sub IEEE80211_NODE_HASHSIZE () {32;}' unless defined(&IEEE80211_NODE_HASHSIZE);
	eval 'sub IEEE80211_NODE_HASH {
	    my($addr) = @_;
    	    eval q(((( &const  &u_int8_t *)($addr))[ &IEEE80211_ADDR_LEN - 1] %  &IEEE80211_NODE_HASHSIZE));
	}' unless defined(&IEEE80211_NODE_HASH);
	eval 'sub IEEE80211_NODE_AUTH () {0x1;}' unless defined(&IEEE80211_NODE_AUTH);
	eval 'sub IEEE80211_NODE_QOS () {0x2;}' unless defined(&IEEE80211_NODE_QOS);
	eval 'sub IEEE80211_NODE_ERP () {0x4;}' unless defined(&IEEE80211_NODE_ERP);
	eval 'sub IEEE80211_NODE_PWR_MGT () {0x10;}' unless defined(&IEEE80211_NODE_PWR_MGT);
	eval 'sub IEEE80211_NODE_AREF () {0x20;}' unless defined(&IEEE80211_NODE_AREF);
	eval 'sub IEEE80211_NODE_AID {
	    my($ni) = @_;
    	    eval q( &IEEE80211_AID( ($ni->{ni_associd})));
	}' unless defined(&IEEE80211_NODE_AID);
	eval 'sub IEEE80211_NODE_STAT {
	    my($ni,$stat) = @_;
    	    eval q(( ($ni->{ni_stats}->{ns_})$stat++));
	}' unless defined(&IEEE80211_NODE_STAT);
	eval 'sub IEEE80211_NODE_STAT_ADD {
	    my($ni,$stat,$v) = @_;
    	    eval q(( ($ni->{ni_stats}->{ns_})$stat += $v));
	}' unless defined(&IEEE80211_NODE_STAT_ADD);
	eval 'sub IEEE80211_NODE_STAT_SET {
	    my($ni,$stat,$v) = @_;
    	    eval q(( ($ni->{ni_stats}->{ns_})$stat = $v));
	}' unless defined(&IEEE80211_NODE_STAT_SET);
	eval 'sub ieee80211_node_is_authorized {
	    my($ni) = @_;
    	    eval q({ ( ($ni->{ni_flags}) &  &IEEE80211_NODE_AUTH); });
	}' unless defined(&ieee80211_node_is_authorized);
	if(defined(&IEEE80211_DEBUG_REFCNT)) {
	    eval 'sub ieee80211_free_node {
	        my($ni) = @_;
    		eval q( &ieee80211_free_node_debug($ni,  &__func__,  &__LINE__));
	    }' unless defined(&ieee80211_free_node);
	    eval 'sub ieee80211_find_node {
	        my($nt, $mac) = @_;
    		eval q( &ieee80211_find_node_debug($nt, $mac,  &__func__,  &__LINE__));
	    }' unless defined(&ieee80211_find_node);
	    eval 'sub ieee80211_find_rxnode {
	        my($nt, $wh) = @_;
    		eval q( &ieee80211_find_rxnode_debug($nt, $wh,  &__func__,  &__LINE__));
	    }' unless defined(&ieee80211_find_rxnode);
	    eval 'sub ieee80211_find_rxnode_withkey {
	        my($nt, $wh, $keyix) = @_;
    		eval q( &ieee80211_find_rxnode_withkey_debug($nt, $wh, $keyix,  &__func__,  &__LINE__));
	    }' unless defined(&ieee80211_find_rxnode_withkey);
	    eval 'sub ieee80211_find_txnode {
	        my($nt, $mac) = @_;
    		eval q( &ieee80211_find_txnode_debug($nt, $mac,  &__func__,  &__LINE__));
	    }' unless defined(&ieee80211_find_txnode);
	    eval 'sub ieee80211_find_node_with_channel {
	        my($nt, $mac, $c) = @_;
    		eval q( &ieee80211_find_node_with_channel_debug($nt, $mac, $c,  &__func__,  &__LINE__));
	    }' unless defined(&ieee80211_find_node_with_channel);
	    eval 'sub ieee80211_find_node_with_ssid {
	        my($nt, $mac, $sl, $ss) = @_;
    		eval q( &ieee80211_find_node_with_ssid_debug($nt, $mac, $sl, $ss,  &__func__,  &__LINE__));
	    }' unless defined(&ieee80211_find_node_with_ssid);
	} else {
	}
	eval 'sub ieee80211_node_incref {
	    my($ni) = @_;
    	    eval q({  &atomic_inc_uint( ($ni->{ni_refcnt})); });
	}' unless defined(&ieee80211_node_incref);
	eval 'sub ieee80211_node_decref {
	    my($ni) = @_;
    	    eval q({  &atomic_dec_uint( ($ni->{ni_refcnt})); });
	}' unless defined(&ieee80211_node_decref);
	eval 'sub ieee80211_node_refcnt {
	    my($ni) = @_;
    	    eval q({  ($ni->{ni_refcnt}); });
	}' unless defined(&ieee80211_node_refcnt);
	eval 'sub ieee80211_ref_node {
	    my($ni) = @_;
    	    eval q({  &ieee80211_node_incref($ni); $ni; });
	}' unless defined(&ieee80211_ref_node);
	eval 'sub ieee80211_unref_node {
	    my($ni) = @_;
    	    eval q({  &ieee80211_node_decref(*$ni); *$ni =  &NULL; });
	}' unless defined(&ieee80211_unref_node);
    }
}
1;
