<?php

error_reporting(-1);

if (function_exists('ini_set')) {
    @ini_set('display_errors', 1);
    @ini_set('display_startup_errors', 1);
    @ini_set('opcache.enable_cli', '0');

    if (isset($_GET['opcache_reset']) && $_GET['opcache_reset'] === md5(Phar::running(false))) {
        $GLOBALS['opcacheEnabled'] = @ini_get('opcache.enable');
    } else {
        $GLOBALS['opcacheEnabled'] = @ini_set('opcache.enable', '0');
    }
}

if (PHP_VERSION_ID < 50509) {
    die('You are using PHP '.PHP_VERSION." but you need least PHP 5.5.9 to run the Contao Manager.\n");
}

if (!extension_loaded('Phar')) {
    echo 'PHP\'s phar extension is missing. Contao Manager requires it to run. Enable the extension or recompile php without --disable-phar then try again.' . PHP_EOL;
    exit(1);
}

if (('cli' === PHP_SAPI || !isset($_SERVER['REQUEST_URI'])) && isset($_SERVER['argv'][1]) && 'test' === $_SERVER['argv'][1]) {
    die(json_encode(['version' => PHP_VERSION, 'version_id' => PHP_VERSION_ID, 'sapi' => PHP_SAPI]));
}

if (PHP_VERSION_ID < 80100) {
    Phar::mapPhar('contao-manager.phar');
    @include 'phar://contao-manager.phar/downgrade.php';
    die('<script>setTimeout(function() { window.location.reload(true) }, 1000)</script>');
}

if (function_exists('date_default_timezone_set') && function_exists('date_default_timezone_get')) {
    date_default_timezone_set(@date_default_timezone_get());
}

if ('cli' === PHP_SAPI || !isset($_SERVER['REQUEST_URI'])) {
    Phar::mapPhar('contao-manager.phar');
    require 'phar://contao-manager.phar/api/console';
} else {
    function rewrites()
    {
        // The function argument is unreliable across servers, Nginx for example is always empty
        list(,$url) = explode(basename(__FILE__), $_SERVER['REQUEST_URI'], 2);

        if (strpos($url, '..')) {
            return false;
        }

        if ('' === $url) {
            header('Location: /'.basename(__FILE__).'/');
            exit;
        }

        if (0 === strpos($url, '/api/')) {
            return '/dist/api.php'.$url;
        }

        if (!empty($url) && is_file('phar://'.__FILE__.'/dist'.$url)) {
            return '/dist'.$url;
        }

        return '/dist/index.html';
    }

    Phar::webPhar(
        null,
        'index.html',
        null,
        array(
            'log' => 'text/plain',
            'txt' => 'text/plain',
            'php' => Phar::PHP, // parse as PHP
            'css' => 'text/css',
            'gif' => 'image/gif',
            'html' => 'text/html',
            'ico' => 'image/x-ico',
            'jpg' => 'image/jpeg',
            'jpeg' => 'image/jpeg',
            'js' => 'application/x-javascript',
            'png' => 'image/png',
            'svg' => 'image/svg+xml',
            'json' => 'application/json'
        ),
        'rewrites'
    );
}

__HALT_COMPILER(); ?>
-'                  .box/bin/check-requirements.php  yKAh  ^ʨ         .box/.requirements.phpf  yKAhf  [X         .box/vendor/autoload.php   yKAh   s      ,   .box/vendor/composer/autoload_namespaces.php   yKAh   t!פ         .box/vendor/composer/LICENSE.  yKAh.         $   .box/vendor/composer/ClassLoader.php>  yKAh>  5Ky      &   .box/vendor/composer/autoload_psr4.php6  yKAh6   0Ӥ      *   .box/vendor/composer/autoload_classmap.php,
  yKAh,
  ӽǤ      (   .box/vendor/composer/autoload_static.phpK  yKAhK  ?      &   .box/vendor/composer/autoload_real.php   yKAh   yi\      .   .box/vendor/composer/semver/src/Comparator.phpu  yKAhu  	74      *   .box/vendor/composer/semver/src/Semver.php  yKAh  ׯ      1   .box/vendor/composer/semver/src/VersionParser.php9  yKAh9  Wz      B   .box/vendor/composer/semver/src/Constraint/ConstraintInterface.php  yKAh  wQ      >   .box/vendor/composer/semver/src/Constraint/MultiConstraint.php~  yKAh~  5[e      9   .box/vendor/composer/semver/src/Constraint/Constraint.php'&  yKAh'&  `         .box/src/Terminal.php
  yKAh
  %V         .box/src/IO.php   yKAh   [l%      !   .box/src/IsExtensionFulfilled.phpv  yKAhv  '0Ҥ         .box/src/Checker.php  yKAh  )W>      "   .box/src/IsPhpVersionFulfilled.php  yKAh  !83      "   .box/src/RequirementCollection.php  yKAh  Wb?         .box/src/Printer.php  yKAh  )8AV         .box/src/IsFulfilled.phpv   yKAhv   %*H         .box/src/Requirement.phpm  yKAhm  B         LICENSE  yKAh  p         dist/index.htmlH'  yKAhH'  ?         dist/api.php--  yKAh  L|R         dist/css/367.25211792.cssl  yKAhl  A         dist/css/522.44f2aba0.cssO  yKAhO  o         dist/css/app.78aea309.cssU  yKAhU           dist/css/909.2589534e.css  yKAh           dist/css/782.eb3ccfd5.cssi?  yKAhi?  Wq         dist/css/335.e18cb2b2.css  yKAh  26&         dist/css/826.11002f25.css  yKAh  +         dist/css/380.93b3a21a.css0  yKAh0  	G         dist/css/904.3a60e65a.css  yKAh  i_Ӥ      #   dist/css/chunk-vendors.4e650cae.csss  yKAhs   -         dist/js/523.024d09d8.js  yKAh           dist/js/28.ec57a4f8.jsw  yKAhw  Ig0         dist/js/60.63bbe8ae.jsI"  yKAhI"  H[         dist/js/477.5046f228.js  yKAh  |         dist/js/553.7da028f7.jsg  yKAhg  
N^         dist/js/551.f5fd138e.js  yKAh  Z         dist/js/194.520ccb65.js  yKAh  Τ         dist/js/638.ebc81223.jsa  yKAha  a         dist/js/851.de2537b9.js  yKAh  Q         dist/js/120.75250efe.js  yKAh  v"         dist/js/540.7447dfbb.js̫  yKAh̫           dist/js/904.dbbbfcc5.js6  yKAh6  V         dist/js/560.d7cbad40.js  yKAh  /Ҥ         dist/js/335.5446ec61.jso
  yKAho
  Lޤ         dist/js/367.5add6572.js_
  yKAh_
  {         dist/js/542.2a7ece7e.jsN
  yKAhN
  EJˤ         dist/js/874.fcb753e0.jsc  yKAhc  j5ͤ         dist/js/180.03013187.js&  yKAh&           dist/js/716.2fcdd2df.js  yKAh  1         dist/js/474.01393a50.jsM  yKAhM           dist/js/643.b4e0291b.js  yKAh  Z0         dist/js/557.32851d13.js  yKAh  <d         dist/js/826.3d9d8358.js,  yKAh,  V[         dist/js/139.aa9cf5f9.jsU  yKAhU  x0L6      !   dist/js/chunk-vendors.65173aa8.jsP yKAhP B<qä         dist/js/953.9ea61c64.js  yKAh  IP         dist/js/748.2ad02c68.jsF  yKAhF  ݤ         dist/js/164.b82ac3d4.js  yKAh  <a2         dist/js/486.a5512a72.jsq  yKAhq  b
         dist/js/715.0c8337cc.jsO  yKAhO  (3         dist/js/909.7d314c8f.js  yKAh  ﭤ         dist/js/219.3e87ebaf.js  yKAh  q伤         dist/js/958.d2146865.jsS  yKAhS  CIsƤ         dist/js/669.0cbe6924.js  yKAh           dist/js/769.7ff2380b.js  yKAh  ^         dist/js/721.f305df88.js  yKAh  O憤         dist/js/52.e4b26831.js  yKAh  |         dist/js/518.11cd8ca7.js  yKAh  ?MD         dist/js/app.6d458114.js yKAh =]Ĥ         dist/js/140.cbc1e5ae.js=  yKAh=  3N         dist/js/606.98b967fa.js  yKAh  |         dist/js/554.b7ccbdff.jsY  yKAhY  +i\         dist/js/581.2f384acc.js  yKAh  6         dist/js/706.93cf9c0e.js  yKAh           dist/js/44.6fcd0b80.js  yKAh           dist/js/782.d9aac0b7.js  yKAh  ͙         dist/js/710.38857bbe.js| yKAh| 02         dist/js/522.8581957a.js
O  yKAh
O  i      !   dist/img/button-show.2336e1d9.svgS  yKAhS  U         dist/img/warning.9a7cd776.svg   yKAh   fh         dist/img/logo.d9707286.svg  yKAh  ;w          dist/img/button-add.759df12e.svg   yKAh   O
         dist/img/favers.056e2836.svgH  yKAhH  y,ͤ      #   dist/img/server-config.1a2d0888.svgg  yKAhg  RN      %   dist/img/button-database.5282fc7e.svg   yKAh   P      "   dist/img/symfony-logo.5c162c73.svg
  yKAh
  Os@      !   dist/img/button-link.dd42e161.svg   yKAh   ֖>      (   dist/img/button-maintenance.93830369.svgE  yKAhE  O      $   dist/img/create-project.b22522ee.svg   yKAh   ʅ      )   dist/img/button-incompatible.3eb2b686.svg  yKAh  /$      #   dist/img/document-root.0e6dd2e4.svg   yKAh   D      '   dist/img/search-by-algolia.72f0ac9a.svg  yKAh           dist/img/boot.92149bf5.svg   yKAh   So      #   dist/img/button-search.44ce1d4b.svgL  yKAhL  w         dist/img/oauth.1243e742.svg.  yKAh.  @
         dist/img/private.a1c65662.svg  yKAh  _50w      %   dist/img/button-download.e1ba6f25.svg1  yKAh1  O#         dist/img/person.00d78897.svg   yKAh   w*      )   dist/img/widget-checkbox--on.8b830157.svg   yKAh   #;      !   dist/img/button-lock.98988f08.svgc  yKAhc  5=6z      "   dist/img/button-check.7a3b5ada.svg   yKAh   ]R         dist/img/user.129e863d.svg   yKAh   cǤ         dist/img/offline.0c23d1ce.svg  yKAh  У-      $   dist/img/button-passkey.3806f98a.svg=  yKAh=  }      (   dist/img/symfony-logo--dark.ea265042.svg  yKAh  溤      #   dist/img/private--dark.41b90022.svg  yKAh  b      &   dist/img/button-cloud-off.dd8ba18e.svg  yKAh  ܡ<      "   dist/img/button-power.298a8072.svg6  yKAh6  Kb      %   dist/img/downloads--dark.034bf7a3.svg-  yKAh-  	Ǥ      "   dist/img/button-trash.855f57fa.svgt  yKAht  2}          dist/img/link-blank.eb57b3fa.svg   yKAh   f^      &   dist/img/button-clipboard.9ef63d39.svgJ  yKAhJ  v,N      '   dist/img/widget-radio--off.4e93f443.svg  yKAh           dist/img/task.e9e5333f.svg{  yKAh{  Jl      #   dist/img/button-update.ad79c617.svg\  yKAh\  Į         dist/img/hint.ba2ac97e.svg!  yKAh!        !   dist/img/button-hide.d23f6533.svg  yKAh  m3(         dist/img/database.7f0a8c49.svg  yKAh  <	         dist/img/updated.3b47bebb.svgH  yKAhH  ʦ      $   dist/img/language--dark.a24e849e.svgx  yKAhx  G7?      !   dist/img/button-save.3b5224de.svg  yKAh           dist/img/lock.3c42a55f.svgf  yKAhf  gG      $   dist/img/button-details.8ce780e9.svg  yKAh  `         dist/img/downloads.c1db2a9e.svg0  yKAh0  ¤      "   dist/img/color_scheme.d527d153.svg   yKAh   t         dist/img/recovery.70ee118a.svg   yKAh   OTM`      #   dist/img/button-upload.ca8e9cfc.svg3  yKAh3  0U      !   dist/img/button-edit.40a4be06.svg  yKAh  !.      &   dist/img/link-blank--dark.07eeaee6.svg   yKAh   B|         dist/img/funding.cf78a0a0.svgJ  yKAhJ  `1_      #   dist/img/button-unlock.51b76e07.svgi  yKAhi  
         dist/img/php-logo.7376e212.svg	  yKAh	  k9q      #   dist/img/updated--dark.c21fdd5b.svgE  yKAhE  Ey      "   dist/img/button-cloud.bc42f267.svg  yKAh  I[      "   dist/img/favers--dark.4765f7d4.svgE  yKAhE        !   dist/img/button-more.e3eb2622.svg  yKAh  v         dist/img/language.582b2920.svg{  yKAh{  tW      &   dist/img/widget-radio--on.181461b6.svg:  yKAh:  j
M      $   dist/img/button-console.05dcdfc4.svg   yKAh   >y      (   dist/img/color_scheme--dark.ef0f0aed.svg:  yKAh:  <      !   dist/img/button-gear.a2dc1f09.svg  yKAh  0         dist/img/sad.c7de6e95.svg5  yKAh5  h          dist/img/button-run.b6310c5a.svg  yKAh           dist/img/close.8b27dbcb.svg   yKAh   e      "   dist/img/link-funding.b25cd92d.svg  yKAh  PԤ      *   dist/img/widget-checkbox--off.73856538.svg   yKAh   ~      (   dist/icons/task-active/favicon-16x16.png3  yKAh3  K       "   dist/icons/task-active/favicon.ico:  yKAh:  8      (   dist/icons/task-active/favicon-32x32.pngF  yKAhF  )fx      '   dist/icons/task-error/favicon-16x16.png;  yKAh;        !   dist/icons/task-error/favicon.ico:  yKAh:  u      '   dist/icons/task-error/favicon-32x32.pngB  yKAhB        )   dist/icons/task-success/favicon-16x16.pngU  yKAhU  {ؤ      #   dist/icons/task-success/favicon.ico:  yKAh:  TIm      )   dist/icons/task-success/favicon-32x32.pngq  yKAhq  ?.         dist/api.php  yKAh  C¾         dist/assets/favicon-16x16.png  yKAh           dist/assets/mstile-310x310.png%  yKAh%  xH      &   dist/assets/android-chrome-384x384.png%  yKAh%  1|&      3   dist/assets/apple-touch-startup-image-1125x2436.png  yKAh  5      2   dist/assets/apple-touch-startup-image-1792x828.png  yKAh  8Q      2   dist/assets/apple-touch-startup-image-1334x750.png}y  yKAh}y  Դ         dist/assets/mstile-144x144.png  yKAh        3   dist/assets/apple-touch-startup-image-1290x2796.pngu  yKAhu  ^v         dist/assets/favicon.ico  yKAh  }*~      (   dist/assets/apple-touch-icon-120x120.png
  yKAh
        3   dist/assets/apple-touch-startup-image-2732x2048.png yKAh .uE      &   dist/assets/android-chrome-192x192.png3  yKAh3  '\          dist/assets/apple-touch-icon.png  yKAh  :5      3   dist/assets/apple-touch-startup-image-1242x2688.png&  yKAh&  :Pg      &   dist/assets/android-chrome-256x256.pngh  yKAhh  j't      3   dist/assets/apple-touch-startup-image-2436x1125.png  yKAh  5x         dist/assets/mstile-70x70.png  yKAh  eݺ=      2   dist/assets/apple-touch-startup-image-640x1136.pngP  yKAhP  n      3   dist/assets/apple-touch-startup-image-1170x2532.png@  yKAh@  ˨      *   dist/assets/apple-touch-icon-1024x1024.pngr|  yKAhr|  T      (   dist/assets/apple-touch-icon-152x152.png  yKAh  o      3   dist/assets/apple-touch-startup-image-1620x2160.pngb  yKAhb  RE      3   dist/assets/apple-touch-startup-image-1668x2388.png  yKAh  I      2   dist/assets/apple-touch-startup-image-828x1792.pngv  yKAhv  >H      3   dist/assets/apple-touch-startup-image-2048x1536.pngn yKAhn xEy      (   dist/assets/apple-touch-icon-180x180.png  yKAh  :5      (   dist/assets/yandex-browser-manifest.json   yKAh   p#Ȥ      3   dist/assets/apple-touch-startup-image-1640x2160.pngv  yKAhv  <o      3   dist/assets/apple-touch-startup-image-2224x1668.png+ yKAh+       3   dist/assets/apple-touch-startup-image-1179x2556.pngZ  yKAhZ           dist/assets/favicon-48x48.png  yKAh  .i         dist/assets/mstile-310x150.png  yKAh  ƒܤ      3   dist/assets/apple-touch-startup-image-1242x2208.pngٸ  yKAhٸ  &Nf      (   dist/assets/apple-touch-icon-114x114.pngR	  yKAhR	  M      &   dist/assets/apple-touch-icon-76x76.png)  yKAh)  b      &   dist/assets/android-chrome-512x512.pngL6  yKAhL6  x9      3   dist/assets/apple-touch-startup-image-2556x1179.png  yKAh  jW      2   dist/assets/apple-touch-startup-image-1136x640.pngd  yKAhd  %¤      3   dist/assets/apple-touch-startup-image-2532x1170.png  yKAh  Ҫ      3   dist/assets/apple-touch-startup-image-2208x1242.png  yKAh  PQ      3   dist/assets/apple-touch-startup-image-1488x2266.pngb  yKAhb  Wzۤ      &   dist/assets/apple-touch-icon-57x57.png  yKAh  1@      2   dist/assets/apple-touch-startup-image-750x1334.pnga  yKAha  ΃      3   dist/assets/apple-touch-startup-image-2266x1488.pngP yKAhP aФ      ,   dist/assets/apple-touch-icon-precomposed.png  yKAh  :5      3   dist/assets/apple-touch-startup-image-2160x1620.png" yKAh" A'      3   dist/assets/apple-touch-startup-image-1284x2778.pngh  yKAhh  eX:      3   dist/assets/apple-touch-startup-image-1668x2224.pngl  yKAhl  N      3   dist/assets/apple-touch-startup-image-2688x1242.png  yKAh  v      &   dist/assets/apple-touch-icon-72x72.png  yKAh  ^F W      3   dist/assets/apple-touch-startup-image-2778x1284.png  yKAh   Z      3   dist/assets/apple-touch-startup-image-1536x2048.pngW  yKAhW  q)ݤ      3   dist/assets/apple-touch-startup-image-2388x1668.png1 yKAh1 [3j         dist/assets/mstile-150x150.png  yKAh  	          dist/assets/manifest.webmanifest  yKAh  `l      3   dist/assets/apple-touch-startup-image-2796x1290.png  yKAh  3ق      $   dist/assets/android-chrome-36x36.png+  yKAh+        $   dist/assets/android-chrome-96x96.png  yKAh  l@w      (   dist/assets/apple-touch-icon-167x167.png
  yKAh
  dP      $   dist/assets/android-chrome-72x72.png  yKAh  hQ\      &   dist/assets/apple-touch-icon-60x60.png  yKAh        3   dist/assets/apple-touch-startup-image-2160x1640.pngV& yKAhV& 7E      3   dist/assets/apple-touch-startup-image-2048x2732.pngDE yKAhDE bpF      (   dist/assets/apple-touch-icon-144x144.png	  yKAh	  Np      $   dist/assets/yandex-browser-50x50.pngX  yKAhX  X         dist/assets/browserconfig.xmlr  yKAhr  v,      $   dist/assets/android-chrome-48x48.png  yKAh  .i         dist/assets/favicon-32x32.png  yKAh  ɹ      &   dist/assets/android-chrome-144x144.png  yKAh        %   api/HttpKernel/ApiProblemResponse.php	  yKAh	        
   api/console--A  yKAhA  C~Ƥ         api/Config/UploadsConfig.php9  yKAh9  Bɤ         api/Config/UserConfig.php%  yKAh%  bf         api/Config/ManagerConfig.php9  yKAh9  v         api/Config/AbstractConfig.phpk  yKAhk  L@         api/Config/ComposerConfig.php  yKAh  5[
         api/Config/PartialConfig.php  yKAh  +tŅ         api/Config/AuthConfig.php  yKAh  $Ĥ      *   api/Security/PasswordlessAuthenticator.php
  yKAh
  E&      &   api/Security/WebauthnAuthenticator.phpr)  yKAhr)  If      #   api/Security/TokenAuthenticator.php  yKAh  <U7         api/Security/UserProvider.php  yKAh  &N}         api/Security/User.php/
  yKAh/
  [      !   api/Security/JwtAuthenticator.php	  yKAh	  %Ȥ      -   api/Security/AbstractBrowserAuthenticator.php  yKAh  ,         api/Security/TotpBadge.php;  yKAh;  lz      #   api/Security/LoginAuthenticator.php  yKAh  b         api/Security/JwtManager.php  yKAh        .   api/TaskOperation/Composer/RemoveOperation.php  yKAh  '}٤      2   api/TaskOperation/Composer/ClearCacheOperation.php  yKAh  [Ǥ      4   api/TaskOperation/Composer/DumpAutoloadOperation.php  yKAh        /   api/TaskOperation/Composer/InstallOperation.php  yKAh  Y      .   api/TaskOperation/Composer/UpdateOperation.php  yKAh        /   api/TaskOperation/Composer/RequireOperation.php9  yKAh9  z]3      5   api/TaskOperation/Composer/CreateProjectOperation.php  yKAh  2F=      -   api/TaskOperation/Composer/CloudOperation.php9  yKAh9  n      8   api/TaskOperation/Filesystem/InstallUploadsOperation.php  yKAh  *դ      9   api/TaskOperation/Filesystem/RemoveArtifactsOperation.php  yKAh  dm-      6   api/TaskOperation/Filesystem/RemoveVendorOperation.php  yKAh  Nx      7   api/TaskOperation/Filesystem/RemoveUploadsOperation.php  yKAh        5   api/TaskOperation/Filesystem/RemoveCacheOperation.php  yKAh  (٤      1   api/TaskOperation/Manager/SelfUpdateOperation.php  yKAh  3:      -   api/TaskOperation/AbstractInlineOperation.php
  yKAh
  \.      1   api/TaskOperation/SponsoredOperationInterface.php"  yKAh"  :      #   api/TaskOperation/ConsoleOutput.php?  yKAh?  Tv      .   api/TaskOperation/AbstractProcessOperation.phpK
  yKAhK
  KG      5   api/TaskOperation/Contao/MaintenanceModeOperation.phps  yKAhs  m6ͤ      2   api/TaskOperation/Contao/BackupCreateOperation.php<  yKAh<  w      1   api/TaskOperation/Contao/CacheWarmupOperation.phpX  yKAhX  hzۤ      2   api/TaskOperation/Contao/CreateContaoOperation.php  yKAh  
l      3   api/TaskOperation/Contao/BackupRestoreOperation.php{  yKAh{  n<!      0   api/TaskOperation/Contao/CacheClearOperation.phpo  yKAho  n      ,   api/TaskOperation/TaskOperationInterface.php  yKAh  6         api/Composer/CloudResolver.phpM  yKAhM  ~2         api/Composer/CloudChanges.phpe  yKAhe  #l֤         api/Composer/CloudJob.php	  yKAh	  yP         api/Composer/CloudException.php  yKAh  ߬         api/Composer/Environment.php+.  yKAh+.  4?      2   api/Resources/cache/url_generating_routes.php.meta!  yKAh!  FY`      @   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php  yKAh  5Tg      %   api/Resources/cache/serialization.phpx   yKAhx   [J      E   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php.lock    yKAh              E   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.php.meta+w yKAh+w v      -   api/Resources/cache/url_generating_routes.phpv  yKAhv  w      +   api/Resources/cache/url_matching_routes.php5  yKAh5  v݈      0   api/Resources/cache/url_matching_routes.php.meta!  yKAh!  FY`      H   api/Resources/cache/Contao_ManagerApi_ApiKernelProdContainer.preload.phptu  yKAhtu  m-      T   api/Resources/cache/ContainerLaZhPOO/getSecurity_Firewall_Map_Context_ApiService.php^
  yKAh^
  lZ      W   api/Resources/cache/ContainerLaZhPOO/getContainer_GetRoutingConditionServiceService.php  yKAh        F   api/Resources/cache/ContainerLaZhPOO/getComposerController2Service.php  yKAh  .-W      N   api/Resources/cache/ContainerLaZhPOO/getSecurity_UserCheckerLocatorService.php  yKAh  ]פ      N   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_SecretsListService.php  yKAh        P   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_SecretsRemoveService.php  yKAh  DR      C   api/Resources/cache/ContainerLaZhPOO/getGraphicsLibCheckService.php  yKAh        C   api/Resources/cache/ContainerLaZhPOO/getPhpCliControllerService.php  yKAh  (֤      Y   api/Resources/cache/ContainerLaZhPOO/getSecurity_Authenticator_ManagersLocatorService.php  yKAh  qb      D   api/Resources/cache/ContainerLaZhPOO/getTaskDeleteCommandService.php  yKAh   &<      `   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_SecretsEncryptFromLocal_LazyService.php~  yKAh~  Uݤ      G   api/Resources/cache/ContainerLaZhPOO/getConstraintControllerService.php  yKAh  p      V   api/Resources/cache/ContainerLaZhPOO/getArgumentResolver_BackedEnumResolverService.php  yKAh  Ur      4   api/Resources/cache/ContainerLaZhPOO/removed-ids.phpi  yKAhi        G   api/Resources/cache/ContainerLaZhPOO/getProcessRunnerCommandService.php/  yKAh/  #c      C   api/Resources/cache/ContainerLaZhPOO/getJwtAuthenticatorService.php  yKAh        C   api/Resources/cache/ContainerLaZhPOO/getContaoControllerService.php?  yKAh?  -Z%      E   api/Resources/cache/ContainerLaZhPOO/getSecurity_AccessMapService.php*  yKAh*  (@      H   api/Resources/cache/ContainerLaZhPOO/getIntegrityCheckFactoryService.php?  yKAh?  #      Q   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_ContainerDebugService.php)  yKAh)  t      W   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_ContainerDebug_LazyService.php(  yKAh(   %      H   api/Resources/cache/ContainerLaZhPOO/getWebauthnAuthenticatorService.php	  yKAh	  *
      F   api/Resources/cache/ContainerLaZhPOO/getJwtCookieControllerService.php:  yKAh:  @      E   api/Resources/cache/ContainerLaZhPOO/getRouter_CacheWarmerService.phpu  yKAhu  *Z      D   api/Resources/cache/ContainerLaZhPOO/getBackupRestoreTaskService.phpL  yKAhL  [fk      H   api/Resources/cache/ContainerLaZhPOO/getConsole_CommandLoaderService.phpN'  yKAhN'  :%      <   api/Resources/cache/ContainerLaZhPOO/getCache_AppService.phpb  yKAhb  yr      M   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_SecretsSetService.php  yKAh  Ui,      T   api/Resources/cache/ContainerLaZhPOO/getSecurity_Command_UserPasswordHashService.php  yKAh  ؤ      H   api/Resources/cache/ContainerLaZhPOO/getConsoleProcessFactoryService.phpd  yKAhd  Vb      \   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_ConfigDumpReference_LazyService.php^  yKAh^  $xd      C   api/Resources/cache/ContainerLaZhPOO/getCache_AppClearerService.php  yKAh  ^      A   api/Resources/cache/ContainerLaZhPOO/getUserControllerService.php  yKAh  ֤      N   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_RouterDebugService.php  yKAh  #OB      Q   api/Resources/cache/ContainerLaZhPOO/Contao_ManagerApi_ApiKernelProdContainer.phpa  yKAha  Q      W   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_CachePoolPrune_LazyService.php  yKAh        D   api/Resources/cache/ContainerLaZhPOO/getTaskUpdateCommandService.php  yKAh  S
      A   api/Resources/cache/ContainerLaZhPOO/getTaskControllerService.php  yKAh  +      L   api/Resources/cache/ContainerLaZhPOO/getMaintenanceModeControllerService.php  yKAh  gB      A   api/Resources/cache/ContainerLaZhPOO/getFileControllerService.php/  yKAh/  "Gf      J   api/Resources/cache/ContainerLaZhPOO/get_ServiceLocator_Y_Xs7MwService.phpT  yKAhT        A   api/Resources/cache/ContainerLaZhPOO/getRouting_LoaderService.phpN
  yKAhN
  =      >   api/Resources/cache/ContainerLaZhPOO/getEnvironmentService.php  yKAh  HS3      T   api/Resources/cache/ContainerLaZhPOO/getSecurity_Listener_UserChecker_ApiService.php  yKAh  aQ¤      C   api/Resources/cache/ContainerLaZhPOO/getServicesResetterService.php~  yKAh~  ~      e   api/Resources/cache/ContainerLaZhPOO/getCache_SecurityIsGrantedAttributeExpressionLanguageService.php  yKAh  W$$      D   api/Resources/cache/ContainerLaZhPOO/getOpcacheControllerService.php  yKAh  !2      P   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_AssetsInstallService.php  yKAh  +      Q   api/Resources/cache/ContainerLaZhPOO/getSerializer_Mapping_CacheWarmerService.php  yKAh  b      E   api/Resources/cache/ContainerLaZhPOO/getLoginAuthenticatorService.php  yKAh  yB      O   api/Resources/cache/ContainerLaZhPOO/getSecurity_EventDispatcher_ApiService.php&  yKAh&        ?   api/Resources/cache/ContainerLaZhPOO/getCache_SystemService.php  yKAh  N1      A   api/Resources/cache/ContainerLaZhPOO/getMonolog_LoggerService.php  yKAh  >l      X   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_CachePoolDelete_LazyService.php+  yKAh+  
      J   api/Resources/cache/ContainerLaZhPOO/getMonolog_Logger_SecurityService.php  yKAh  B      @   api/Resources/cache/ContainerLaZhPOO/getUpdateCommandService.php  yKAh  4      Q   api/Resources/cache/ContainerLaZhPOO/getDebug_ErrorHandlerConfiguratorService.php\  yKAh\  vX7      I   api/Resources/cache/ContainerLaZhPOO/getTaskDeleteCommand_LazyService.php  yKAh         U   api/Resources/cache/ContainerLaZhPOO/getSecurity_Access_AuthenticatedVoterService.phpL  yKAhL        ?   api/Resources/cache/ContainerLaZhPOO/getProcessCheckService.php
  yKAh
  !      D   api/Resources/cache/ContainerLaZhPOO/getSessionControllerService.php  yKAh  Y      V   api/Resources/cache/ContainerLaZhPOO/getSecurity_Listener_PasswordMigratingService.php$  yKAh$        A   api/Resources/cache/ContainerLaZhPOO/getSelfUpdateTaskService.php*  yKAh*  XD      X   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_SerializerDebug_LazyService.php  yKAh        F   api/Resources/cache/ContainerLaZhPOO/getCache_GlobalClearerService.phpn  yKAhn  !      >   api/Resources/cache/ContainerLaZhPOO/getTaskManagerService.php  yKAh  N      H   api/Resources/cache/ContainerLaZhPOO/getConsole_ErrorListenerService.php  yKAh        K   api/Resources/cache/ContainerLaZhPOO/getUploadPackagesControllerService.php  yKAh        <   api/Resources/cache/ContainerLaZhPOO/getContaoApiService.php^  yKAh^        C   api/Resources/cache/ContainerLaZhPOO/getMemoryLimitCheckService.php  yKAh  cYw      W   api/Resources/cache/ContainerLaZhPOO/get_Security_Command_DebugFirewall_LazyService.php+  yKAh+  
p      B   api/Resources/cache/ContainerLaZhPOO/getSysTempDirCheckService.php  yKAh  żi      V   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_SecretsRemove_LazyService.php  yKAh  D"`      _   api/Resources/cache/ContainerLaZhPOO/getArgumentResolver_QueryParameterValueResolverService.php  yKAh  qp      I   api/Resources/cache/ContainerLaZhPOO/getTaskUpdateCommand_LazyService.php  yKAh  QLj      C   api/Resources/cache/ContainerLaZhPOO/getConfigControllerService.php  yKAh  k/      =   api/Resources/cache/ContainerLaZhPOO/getSelfUpdateService.php  yKAh  `      C   api/Resources/cache/ContainerLaZhPOO/getTaskAbortCommandService.php  yKAh  N      @   api/Resources/cache/ContainerLaZhPOO/getCloudResolverService.php  yKAh  ̺~      ^   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_SecretsDecryptToLocal_LazyService.php|  yKAh|  Pt      F   api/Resources/cache/ContainerLaZhPOO/getAccessKeyControllerService.php:  yKAh:  #      S   api/Resources/cache/ContainerLaZhPOO/getPropertyInfo_SerializerExtractorService.php$  yKAh$  j`      ?   api/Resources/cache/ContainerLaZhPOO/getUserProviderService.php  yKAh  *e      C   api/Resources/cache/ContainerLaZhPOO/getPhpWebControllerService.phpJ  yKAhJ  ̤      D   api/Resources/cache/ContainerLaZhPOO/getAboutCommand_LazyService.php  yKAh  "      P   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_ContainerLintService.php<  yKAh<  r      N   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_About_LazyService.php  yKAh  ܪoۤ      T   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_RouterMatch_LazyService.php  yKAh  .\      =   api/Resources/cache/ContainerLaZhPOO/getTranslatorService.php  yKAh        G   api/Resources/cache/ContainerLaZhPOO/getSelfUpdateControllerService.php  yKAh  ldg      K   api/Resources/cache/ContainerLaZhPOO/getSecurity_ChannelListenerService.php  yKAh        L   api/Resources/cache/ContainerLaZhPOO/getArgumentResolver_VariadicService.php  yKAh  +=<[      D   api/Resources/cache/ContainerLaZhPOO/getManagerControllerService.php7  yKAh7  cNr      C   api/Resources/cache/ContainerLaZhPOO/getBackupControllerService.php  yKAh  ?      B   api/Resources/cache/ContainerLaZhPOO/getSecurity_HelperService.php;  yKAh;  rL      Q   api/Resources/cache/ContainerLaZhPOO/getSecurity_Listener_UserProviderService.php  yKAh  ߳8      Q   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_YamlLint_LazyService.php  yKAh  a+      @   api/Resources/cache/ContainerLaZhPOO/getSecrets_VaultService.phpE  yKAhE  i:Ǥ      V   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_ConfigDumpReferenceService.phpN  yKAhN  bGɤ      N   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_CacheWarmupService.phpS  yKAhS  X#
      U   api/Resources/cache/ContainerLaZhPOO/getSecurity_Access_RoleHierarchyVoterService.php*  yKAh*  D      T   api/Resources/cache/ContainerLaZhPOO/getArgumentResolver_RequestAttributeService.php  yKAh  4      C   api/Resources/cache/ContainerLaZhPOO/getBackupCreateTaskService.phpG  yKAhG  .      L   api/Resources/cache/ContainerLaZhPOO/getProcessRunnerCommand_LazyService.php  yKAh  R|      R   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_CachePoolDeleteService.phpt  yKAht        B   api/Resources/cache/ContainerLaZhPOO/getCloudControllerService.php	  yKAh	  M$_      <   api/Resources/cache/ContainerLaZhPOO/getSetupTaskService.phpX  yKAhX  	;      S   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_SecretsSet_LazyService.php  yKAh  
P      E   api/Resources/cache/ContainerLaZhPOO/getTemplateControllerService.php  yKAh  nYaI      Z   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_CachePoolInvalidateTagsService.php  yKAh  VcӁ      ]   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_EventDispatcherDebug_LazyService.phpg  yKAhg  !k      V   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_CachePoolList_LazyService.php  yKAh  &ʤ      W   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_EventDispatcherDebugService.php  yKAh  `      K   api/Resources/cache/ContainerLaZhPOO/getArgumentResolver_ServiceService.php  yKAh  D-      `   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_CachePoolInvalidateTags_LazyService.php  yKAh  #RS      T   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_CacheWarmup_LazyService.php  yKAh  ֤      F   api/Resources/cache/ContainerLaZhPOO/getCache_SystemClearerService.php  yKAh        J   api/Resources/cache/ContainerLaZhPOO/get_ServiceLocator_BvkMlPlService.phpP  yKAhP  :      G   api/Resources/cache/ContainerLaZhPOO/getMonolog_Logger_TasksService.php  yKAh  E      F   api/Resources/cache/ContainerLaZhPOO/getAdminUserControllerService.phpB  yKAhB  nY	      H   api/Resources/cache/ContainerLaZhPOO/getIntegrityCheckCommandService.php  yKAh  mY      V   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_AssetsInstall_LazyService.php)  yKAh)  .z3      [   api/Resources/cache/ContainerLaZhPOO/getSecurity_Firewall_EventDispatcherLocatorService.php  yKAh  H      R   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_SerializerDebugService.php  yKAh  #      E   api/Resources/cache/ContainerLaZhPOO/getPhpExtensionsCheckService.php(  yKAh(  o]      K   api/Resources/cache/ContainerLaZhPOO/getArgumentResolver_DefaultService.php  yKAh  X5      A   api/Resources/cache/ContainerLaZhPOO/getAuthControllerService.php  yKAh  Ud      L   api/Resources/cache/ContainerLaZhPOO/getArgumentResolver_DatetimeService.php  yKAh  9	      G   api/Resources/cache/ContainerLaZhPOO/getArgumentResolver_UidService.php  yKAh  b      L   api/Resources/cache/ContainerLaZhPOO/getInstallToolLockControllerService.php  yKAh  83      E   api/Resources/cache/ContainerLaZhPOO/getUpdateCommand_LazyService.php  yKAh  .rF      E   api/Resources/cache/ContainerLaZhPOO/getComposerControllerService.php>  yKAh>  G)      K   api/Resources/cache/ContainerLaZhPOO/getArgumentResolver_SessionService.php  yKAh         >   api/Resources/cache/ContainerLaZhPOO/getCacheWarmerService.php  yKAh  q      E   api/Resources/cache/ContainerLaZhPOO/getRedirectControllerService.php  yKAh  Mؒ      @   api/Resources/cache/ContainerLaZhPOO/getUploadsConfigService.php  yKAh  7V      N   api/Resources/cache/ContainerLaZhPOO/getDatabaseMigrationControllerService.php=  yKAh=  R      K   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_YamlLintService.php	  yKAh	  xBYJ      G   api/Resources/cache/ContainerLaZhPOO/getConfigBuilder_WarmerService.php  yKAh  f      L   api/Resources/cache/ContainerLaZhPOO/getPasswordlessAuthenticatorService.php  yKAh  "      A   api/Resources/cache/ContainerLaZhPOO/getClearCacheTaskService.phpE  yKAhE  rΤ      H   api/Resources/cache/ContainerLaZhPOO/getRootPackageControllerService.phpQ  yKAhQ  q[      E   api/Resources/cache/ContainerLaZhPOO/getCache_App_TaggableService.php  yKAh  c&o      @   api/Resources/cache/ContainerLaZhPOO/getContaoConsoleService.php  yKAh  [{      @   api/Resources/cache/ContainerLaZhPOO/getManagerConfigService.php  yKAh  W%      M   api/Resources/cache/ContainerLaZhPOO/getSecurity_UserValueResolverService.php  yKAh  #      X   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_DebugAutowiring_LazyService.php8  yKAh8  <v      Q   api/Resources/cache/ContainerLaZhPOO/getSecurity_Command_DebugFirewallService.php  yKAh  ¤      b   api/Resources/cache/ContainerLaZhPOO/getSecurity_Listener_CheckAuthenticatorCredentialsService.phpH  yKAhH  lV-      W   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_CachePoolClear_LazyService.php  yKAh  e=      M   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_CacheClearService.php  yKAh  e2Ӥ      D   api/Resources/cache/ContainerLaZhPOO/getPhpinfoControllerService.php  yKAh  A{      P   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_CachePoolListService.php  yKAh  V`      U   api/Resources/cache/ContainerLaZhPOO/getSecurity_Authenticator_Manager_ApiService.php  yKAh  1      E   api/Resources/cache/ContainerLaZhPOO/getAllowUrlFopenCheckService.php(  yKAh(  xwФ      C   api/Resources/cache/ContainerLaZhPOO/getRebuildCacheTaskService.phpp  yKAhp  9      V   api/Resources/cache/ContainerLaZhPOO/getSecurity_Firewall_Authenticator_ApiService.php  yKAh  
=      [   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_SecretsGenerateKey_LazyService.phpE  yKAhE        T   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_RouterDebug_LazyService.php  yKAh        Q   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_CachePoolClearService.php_  yKAh_  j|.      @   api/Resources/cache/ContainerLaZhPOO/getLogControllerService.php*  yKAh*  nʊ^      L   api/Resources/cache/ContainerLaZhPOO/getContainer_EnvVarProcessorService.php,  yKAh,  M
      U   api/Resources/cache/ContainerLaZhPOO/getSecurity_Listener_Api_UserProviderService.php!  yKAh!  gY      >   api/Resources/cache/ContainerLaZhPOO/getInstallTaskService.php#  yKAh#  2b      T   api/Resources/cache/ContainerLaZhPOO/getContainer_EnvVarProcessorsLocatorService.php
  yKAh
  3tv8      D   api/Resources/cache/ContainerLaZhPOO/getExceptionListenerService.php  yKAh  gʮ      ?   api/Resources/cache/ContainerLaZhPOO/getSymlinkCheckService.php  yKAh  CI٤      :   api/Resources/cache/ContainerLaZhPOO/getRequestService.php  yKAh  tXy.      ?   api/Resources/cache/ContainerLaZhPOO/getSessionCheckService.php
  yKAh
  Is      L   api/Resources/cache/ContainerLaZhPOO/getMissingPackagesControllerService.phpe  yKAhe  ,b      U   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_SecretsGenerateKeyService.php8  yKAh8  /      =   api/Resources/cache/ContainerLaZhPOO/getUpdateTaskService.php  yKAh        T   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_SecretsList_LazyService.php  yKAh  }O      A   api/Resources/cache/ContainerLaZhPOO/getComposerConfigService.php   yKAh   =p      Z   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_SecretsEncryptFromLocalService.php`  yKAh`  }      J   api/Resources/cache/ContainerLaZhPOO/getSecurity_AccessListenerService.php  yKAh  !      Q   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_CachePoolPruneService.php  yKAh  ORy      Z   api/Resources/cache/ContainerLaZhPOO/get_Security_Command_UserPasswordHash_LazyService.php6  yKAh6  [      N   api/Resources/cache/ContainerLaZhPOO/getSecurity_RouteLoader_LogoutService.php  yKAh  ⩪o      T   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_ConfigDebug_LazyService.php  yKAh  Bx      E   api/Resources/cache/ContainerLaZhPOO/getDatabaseControllerService.php  yKAh  :|RV      X   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_SecretsDecryptToLocalService.phpd  yKAhd        J   api/Resources/cache/ContainerLaZhPOO/getLocalPackagesControllerService.php[  yKAh[  2      ?   api/Resources/cache/ContainerLaZhPOO/getAboutCommandService.php  yKAh  ,      H   api/Resources/cache/ContainerLaZhPOO/getTaskAbortCommand_LazyService.php  yKAh  A(      V   api/Resources/cache/ContainerLaZhPOO/getSecurity_SecurityTokenValueResolverService.php@  yKAh@  S      E   api/Resources/cache/ContainerLaZhPOO/getTokenAuthenticatorService.php  yKAh  x      R   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_DebugAutowiringService.php  yKAh  u      =   api/Resources/cache/ContainerLaZhPOO/getServerInfoService.php  yKAh  R=      N   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_RouterMatchService.php  yKAh  ?7      M   api/Resources/cache/ContainerLaZhPOO/getIntegrityCheckCommand_LazyService.php  yKAh  #3      J   api/Resources/cache/ContainerLaZhPOO/get_ServiceLocator_AH5O6SdService.phph  yKAhh  s      B   api/Resources/cache/ContainerLaZhPOO/getErrorControllerService.php  yKAh  Ϥ      J   api/Resources/cache/ContainerLaZhPOO/get_ServiceLocator_EZsc_DOService.phpb  yKAhb  $h"      S   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_CacheClear_LazyService.php  yKAh  \5      K   api/Resources/cache/ContainerLaZhPOO/getArgumentResolver_RequestService.php  yKAh  F      P   api/Resources/cache/ContainerLaZhPOO/RequestPayloadValueResolverGhost8d82153.phpX  yKAhX  謭      H   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_AboutService.php  yKAh  .M      C   api/Resources/cache/ContainerLaZhPOO/getDumpAutoloadTaskService.phpO  yKAhO  dָ      V   api/Resources/cache/ContainerLaZhPOO/get_Console_Command_ContainerLint_LazyService.php8  yKAh8  u+D      N   api/Resources/cache/ContainerLaZhPOO/getConsole_Command_ConfigDebugService.php  yKAh  Zy/      @   api/Resources/cache/Symfony/Config/Framework/HttpCacheConfig.php#  yKAh#  
1      F   api/Resources/cache/Symfony/Config/Framework/Webhook/RoutingConfig.phpv  yKAhv  j3      <   api/Resources/cache/Symfony/Config/Framework/CacheConfig.php$  yKAh$  "      @   api/Resources/cache/Symfony/Config/Framework/FragmentsConfig.php
  yKAh
  	[b      J   api/Resources/cache/Symfony/Config/Framework/Form/CsrfProtectionConfig.php  yKAh  7eG      P   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptionsConfig.phpxE  yKAhxE  ^Me      i   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/RetryFailed/HttpCodeConfig.php  yKAh        d   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/PeerFingerprintConfig.php
  yKAh
  E      `   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig/RetryFailedConfig.php  yKAh  #      N   api/Resources/cache/Symfony/Config/Framework/HttpClient/ScopedClientConfig.php4S  yKAh4S  S¤      e   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/RetryFailed/HttpCodeConfig.php  yKAh  ,@Ϥ      `   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/PeerFingerprintConfig.php	  yKAh	   !j      \   api/Resources/cache/Symfony/Config/Framework/HttpClient/DefaultOptions/RetryFailedConfig.php  yKAh  =q      I   api/Resources/cache/Symfony/Config/Framework/Serializer/MappingConfig.phpF  yKAhF  $v      A   api/Resources/cache/Symfony/Config/Framework/ValidationConfig.php(  yKAh(  i      B   api/Resources/cache/Symfony/Config/Framework/RateLimiterConfig.php	  yKAh	        U   api/Resources/cache/Symfony/Config/Framework/RateLimiter/LimiterConfig/RateConfig.phpm  yKAhm  $S      J   api/Resources/cache/Symfony/Config/Framework/RateLimiter/LimiterConfig.php  yKAh  9§      A   api/Resources/cache/Symfony/Config/Framework/Cache/PoolConfig.php  yKAh  -.-      A   api/Resources/cache/Symfony/Config/Framework/SerializerConfig.php  yKAh  `o      E   api/Resources/cache/Symfony/Config/Framework/CsrfProtectionConfig.php7  yKAh7  g	      =   api/Resources/cache/Symfony/Config/Framework/AssetsConfig.php+  yKAh+  (      N   api/Resources/cache/Symfony/Config/Framework/Notifier/AdminRecipientConfig.phpZ  yKAhZ  ¾      @   api/Resources/cache/Symfony/Config/Framework/MessengerConfig.phpe*  yKAhe*  ]      >   api/Resources/cache/Symfony/Config/Framework/WebhookConfig.php  yKAh  &J      =   api/Resources/cache/Symfony/Config/Framework/RouterConfig.php  yKAh  Ǚw      A   api/Resources/cache/Symfony/Config/Framework/TranslatorConfig.php"  yKAh"  f      @   api/Resources/cache/Symfony/Config/Framework/WorkflowsConfig.php  yKAh  
      J   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig.php~+  yKAh~+  7      [   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/AuditTrailConfig.phpN  yKAhN  VN      ]   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/MarkingStoreConfig.php	  yKAh	  h4      [   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/TransitionConfig.php]  yKAh]  Eg :      V   api/Resources/cache/Symfony/Config/Framework/Workflows/WorkflowsConfig/PlaceConfig.php  yKAh  i:      :   api/Resources/cache/Symfony/Config/Framework/EsiConfig.php-  yKAh-  5      >   api/Resources/cache/Symfony/Config/Framework/WebLinkConfig.php1  yKAh1        F   api/Resources/cache/Symfony/Config/Framework/Mailer/EnvelopeConfig.php  yKAh  R      D   api/Resources/cache/Symfony/Config/Framework/Mailer/HeaderConfig.php,  yKAh,  lu      :   api/Resources/cache/Symfony/Config/Framework/SsiConfig.php-  yKAh-  (      T   api/Resources/cache/Symfony/Config/Framework/Translator/PseudoLocalizationConfig.php  yKAh  |Њ      J   api/Resources/cache/Symfony/Config/Framework/Translator/ProviderConfig.php
  yKAh
  ܤ      ?   api/Resources/cache/Symfony/Config/Framework/ProfilerConfig.php  yKAh  pé      @   api/Resources/cache/Symfony/Config/Framework/SemaphoreConfig.php  yKAh  R8      >   api/Resources/cache/Symfony/Config/Framework/SecretsConfig.php  yKAh  |1      E   api/Resources/cache/Symfony/Config/Framework/PropertyAccessConfig.php  yKAh  S(      J   api/Resources/cache/Symfony/Config/Framework/Messenger/TransportConfig.php  yKAh  	      ]   api/Resources/cache/Symfony/Config/Framework/Messenger/Serializer/SymfonySerializerConfig.php  yKAh  +]      K   api/Resources/cache/Symfony/Config/Framework/Messenger/SerializerConfig.php  yKAh  Ot      ^   api/Resources/cache/Symfony/Config/Framework/Messenger/TransportConfig/RetryStrategyConfig.php?  yKAh?  [T      H   api/Resources/cache/Symfony/Config/Framework/Messenger/RoutingConfig.php]  yKAh]  zT      U   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig/MiddlewareConfig.php  yKAh  i      \   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig/DefaultMiddlewareConfig.php
  yKAh
  Ԥ      D   api/Resources/cache/Symfony/Config/Framework/Messenger/BusConfig.php  yKAh        C   api/Resources/cache/Symfony/Config/Framework/PropertyInfoConfig.php5  yKAh5        =   api/Resources/cache/Symfony/Config/Framework/MailerConfig.php2  yKAh2        :   api/Resources/cache/Symfony/Config/Framework/UidConfig.php  yKAh  ե      B   api/Resources/cache/Symfony/Config/Framework/RemoteeventConfig.php5  yKAh5  `      B   api/Resources/cache/Symfony/Config/Framework/AssetMapperConfig.phpY(  yKAhY(  Pm      D   api/Resources/cache/Symfony/Config/Framework/HtmlSanitizerConfig.php*
  yKAh*
  
?      @   api/Resources/cache/Symfony/Config/Framework/ExceptionConfig.phpO  yKAhO        >   api/Resources/cache/Symfony/Config/Framework/SessionConfig.php`2  yKAh`2        N   api/Resources/cache/Symfony/Config/Framework/HtmlSanitizer/SanitizerConfig.php9  yKAh9  ,      A   api/Resources/cache/Symfony/Config/Framework/HttpClientConfig.phpm  yKAhm        @   api/Resources/cache/Symfony/Config/Framework/PhpErrorsConfig.php  yKAh  .m      ?   api/Resources/cache/Symfony/Config/Framework/NotifierConfig.phpS  yKAhS  6S2      >   api/Resources/cache/Symfony/Config/Framework/RequestConfig.phpg  yKAhg  Ϊ      B   api/Resources/cache/Symfony/Config/Framework/AnnotationsConfig.php  yKAh  c:Ĥ      E   api/Resources/cache/Symfony/Config/Framework/Assets/PackageConfig.php!  yKAh!  `      X   api/Resources/cache/Symfony/Config/Framework/Validation/NotCompromisedPasswordConfig.php9  yKAh9  r9`      I   api/Resources/cache/Symfony/Config/Framework/Validation/MappingConfig.phpF  yKAhF  Һ      M   api/Resources/cache/Symfony/Config/Framework/Validation/AutoMappingConfig.phpn  yKAhn  }      ;   api/Resources/cache/Symfony/Config/Framework/LockConfig.php  yKAh  $      @   api/Resources/cache/Symfony/Config/Framework/SchedulerConfig.php3  yKAh3        ;   api/Resources/cache/Symfony/Config/Framework/FormConfig.php
  yKAh
  ܥ;      P   api/Resources/cache/Symfony/Config/Security/ProviderConfig/Memory/UserConfig.php  yKAh  K      I   api/Resources/cache/Symfony/Config/Security/ProviderConfig/LdapConfig.php  yKAh  OK      K   api/Resources/cache/Symfony/Config/Security/ProviderConfig/MemoryConfig.phpO  yKAhO  >]      J   api/Resources/cache/Symfony/Config/Security/ProviderConfig/ChainConfig.php  yKAh  y4      D   api/Resources/cache/Symfony/Config/Security/PasswordHasherConfig.php  yKAh  j{쾤      >   api/Resources/cache/Symfony/Config/Security/ProviderConfig.php  yKAh  73      >   api/Resources/cache/Symfony/Config/Security/FirewallConfig.php&n  yKAh&n        P   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessTokenConfig.php  yKAh  ?3      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMeConfig.php1  yKAh1  ڊ      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/FormLoginConfig.phpA  yKAhA  ǌ       R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/JsonLoginLdapConfig.php,*  yKAh,*  Ex      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/HttpBasicConfig.php  yKAh  j      ]   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessToken/TokenHandlerConfig.php  yKAh  J      j   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessToken/TokenHandler/OidcUserInfoConfig.php
  yKAh
  
      b   api/Resources/cache/Symfony/Config/Security/FirewallConfig/AccessToken/TokenHandler/OidcConfig.php  yKAh  .}e      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/JsonLoginConfig.php  yKAh  \      X   api/Resources/cache/Symfony/Config/Security/FirewallConfig/Logout/DeleteCookieConfig.php  yKAh  8x      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/SwitchUserConfig.php  yKAh  j a      T   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LoginThrottlingConfig.php
  yKAh
  >      N   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LoginLinkConfig.php3  yKAh3  ~1      f   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMe/TokenProvider/DoctrineConfig.php  yKAh  =      ]   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RememberMe/TokenProviderConfig.php
  yKAh
        R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/FormLoginLdapConfig.phpNN  yKAhNN  jN      R   api/Resources/cache/Symfony/Config/Security/FirewallConfig/HttpBasicLdapConfig.php  yKAh  B      I   api/Resources/cache/Symfony/Config/Security/FirewallConfig/X509Config.php  yKAh  I      O   api/Resources/cache/Symfony/Config/Security/FirewallConfig/RemoteUserConfig.php  yKAh  U8      K   api/Resources/cache/Symfony/Config/Security/FirewallConfig/LogoutConfig.php#  yKAh#        K   api/Resources/cache/Symfony/Config/Security/AccessDecisionManagerConfig.php  yKAh  O^      C   api/Resources/cache/Symfony/Config/Security/AccessControlConfig.php  yKAh  XAL      5   api/Resources/cache/Symfony/Config/SecurityConfig.php
1  yKAh
1  Y~      4   api/Resources/cache/Symfony/Config/MonologConfig.php  yKAh  FF      <   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig.php* yKAh* J      V   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ProcessPsr3MessagesConfig.php
  yKAh
  U      L   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/PublisherConfig.php"  yKAh"  -      H   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/RedisConfig.php  yKAh  ע      P   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ElasticsearchConfig.php  yKAh  !a      Q   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/EmailPrototypeConfig.phpZ  yKAhZ  q:_      H   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/MongoConfig.php  yKAh  =o      R   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/VerbosityLevelsConfig.php  yKAh  =1ޤ      I   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/PredisConfig.php:  yKAh:  f ɤ      S   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ExcludedHttpCodeConfig.php~  yKAh~  4:T      K   api/Resources/cache/Symfony/Config/Monolog/HandlerConfig/ChannelsConfig.php  yKAh  у      6   api/Resources/cache/Symfony/Config/FrameworkConfig.php' yKAh' oA      #   api/Resources/cache/annotations.map  yKAh  r'      "   api/Resources/config/services.yamlx
  yKAhx
  K~I      $   api/Resources/config/config_dev.yaml  yKAh        %   api/Resources/config/config_prod.yaml   yKAh   H          api/Resources/config/config.yaml*  yKAh*  "H         api/Resources/i18n/cs.yml  yKAh  f         api/Resources/i18n/br.yml  yKAh           api/Resources/i18n/es.ymlP  yKAhP  eͺ         api/Resources/i18n/pt.yml  yKAh  hǤ         api/Resources/i18n/de.yml  yKAh  V=         api/Resources/i18n/it.yml  yKAh  `         api/Resources/i18n/pl.yml3  yKAh3  fi         api/Resources/i18n/fa.yml;	  yKAh;	  1,         api/Resources/i18n/sv.yml6  yKAh6  kM4Ť         api/Resources/i18n/en.ymlm  yKAhm  hDh>         api/Resources/i18n/ja.yml  yKAh  8E~         api/Resources/i18n/ru.yml  yKAh  2          api/Resources/i18n/sr.yml  yKAh  jU         api/Resources/i18n/fr.yml7  yKAh7  	         api/Resources/i18n/lv.yml  yKAh           api/Resources/i18n/tr.ymlj  yKAhj  ;٤         api/Resources/i18n/nl.yml  yKAh  դ         api/Resources/i18n/zh.yml
  yKAh
  ^a         api/ApiApplication.php  yKAh  -r      #   api/Tests/Composer/CloudJobTest.php  yKAh  !L      '   api/Tests/Controller/LogPatternTest.php0  yKAh0  Ly      !   api/Controller/FileController.php  yKAh        !   api/Controller/UserController.php>  yKAh>  Տ"          api/Controller/LogController.php  yKAh  '%      (   api/Controller/Config/AuthController.phpg  yKAhg  rI6      2   api/Controller/Config/AbstractConfigController.php  yKAh  <V      ,   api/Controller/Config/ComposerController.php  yKAh  gƤ      +   api/Controller/Config/ManagerController.php  yKAh  ݤ      !   api/Controller/TaskController.phpy  yKAhy  fId      *   api/Controller/Server/PhpWebController.phpD  yKAhD  1eŤ      *   api/Controller/Server/ContaoController.php"  yKAh"  ͚v      ,   api/Controller/Server/DatabaseController.php2
  yKAh2
  W?      -   api/Controller/Server/AdminUserController.php
  yKAh
  DV      +   api/Controller/Server/PhpinfoController.phpr  yKAhr  %E      +   api/Controller/Server/OpcacheController.php  yKAh  "      *   api/Controller/Server/ConfigController.php  yKAh  $      ,   api/Controller/Server/ComposerController.php?  yKAh?  j$Np      *   api/Controller/Server/PhpCliController.php  yKAh  K|Q      .   api/Controller/Server/SelfUpdateController.php  yKAh  $w      $   api/Controller/SessionController.phps  yKAhs  YK~      5   api/Controller/Packages/MissingPackagesController.php
  yKAh
  2c      4   api/Controller/Packages/UploadPackagesController.php'  yKAh'  +T      1   api/Controller/Packages/RootPackageController.php'  yKAh'  &H)      +   api/Controller/Packages/CloudController.php  yKAh  ߼      3   api/Controller/Packages/LocalPackagesController.phpN  yKAhN        '   api/Controller/ConstraintController.phpY  yKAhY  kۤ      3   api/Controller/Contao/InstallToolLockController.php3  yKAh3  AÖ      5   api/Controller/Contao/DatabaseMigrationController.php%  yKAh%  Zb      -   api/Controller/Contao/AccessKeyController.php0  yKAh0  I>      *   api/Controller/Contao/BackupController.php,  yKAh,  >]6      3   api/Controller/Contao/MaintenanceModeController.php  yKAh  $iW      -   api/Controller/Contao/JwtCookieController.php  yKAh  bˤ         api/ApiKernel.php>&  yKAh>&  M         api/System/ServerInfo.phpq  yKAhq  ƾq         api/System/Request.php[  yKAh[  y9[<         api/System/SelfUpdate.phpD  yKAhD  qׂ         api/Task/TaskStatus.php=  yKAh=  %s      &   api/Task/Composer/DumpAutoloadTask.php  yKAh  Wj      $   api/Task/Composer/ClearCacheTask.php  yKAh        #   api/Task/Manager/SelfUpdateTask.php  yKAh  @?&         api/Task/AbstractTask.php  yKAh  ߪO         api/Task/Packages/SetupTask.php
  yKAh
  f          api/Task/Packages/UpdateTask.phpF+  yKAhF+  .      !   api/Task/Packages/InstallTask.php-  yKAh-  }~BC      *   api/Task/Packages/AbstractPackagesTask.php
  yKAh
  #c      $   api/Task/Contao/BackupCreateTask.php  yKAh  E      %   api/Task/Contao/BackupRestoreTask.php  yKAh  UF      $   api/Task/Contao/RebuildCacheTask.php  yKAh  lK         api/Task/TaskManager.phpC  yKAhC  W         api/Task/TaskInterface.php  yKAh  r         api/Task/TaskConfig.php	  yKAh	  /ʤ      %   api/Command/IntegrityCheckCommand.php	  yKAh	           api/Command/UpdateCommand.php  yKAh  %          api/Command/TaskAbortCommand.phpJ  yKAhJ  {P峤      !   api/Command/TaskUpdateCommand.phpz  yKAhz  k      $   api/Command/ProcessRunnerCommand.phpy  yKAhy  `݃y         api/Command/AboutCommand.php  yKAh  pSe      !   api/Command/TaskDeleteCommand.phpa  yKAha  
W         api/I18n/Translator.php
  yKAh
  q
      %   api/Exception/ApiProblemException.php5  yKAh5  W{       (   api/Exception/ProcessOutputException.php  yKAh  o      &   api/Exception/InvalidTotpException.php  yKAh  ʤ      &   api/Exception/InvalidJsonException.php
  yKAh
  8Y      "   api/Exception/RequestException.php  yKAh  Ű      )   api/IntegrityCheck/AllowUrlFopenCheck.php%  yKAh%  z2Ť      '   api/IntegrityCheck/GraphicsLibCheck.php  yKAh  kp¤         api/IntegrityCheck/ZipCheck.php  yKAh  k"      &   api/IntegrityCheck/SysTempDirCheck.php  yKAh  Ƥ      .   api/IntegrityCheck/IntegrityCheckInterface.php~  yKAh~        #   api/IntegrityCheck/ProcessCheck.php  yKAh  \.sg      #   api/IntegrityCheck/SymlinkCheck.php  yKAh  ;W      #   api/IntegrityCheck/SessionCheck.php  yKAh  ˭K      '   api/IntegrityCheck/MemoryLimitCheck.phpK  yKAhK  ^      )   api/IntegrityCheck/PhpExtensionsCheck.php  yKAh  	:      -   api/IntegrityCheck/AbstractIntegrityCheck.php  yKAh        ,   api/IntegrityCheck/IntegrityCheckFactory.php  yKAh  R,         api/Process/ContaoApi.phpF  yKAhF  B      !   api/Process/ProcessController.php  yKAh  ٧e      %   api/Process/Forker/AbstractForker.php
  yKAh
  ȮH      &   api/Process/Forker/ForkerInterface.phpn  yKAhn  |5oq      #   api/Process/Forker/DisownForker.php  yKAh  w4h      "   api/Process/Forker/NohupForker.php  yKAh  ZA      )   api/Process/Forker/WindowsStartForker.php  yKAh  a\"      #   api/Process/Forker/InlineForker.php  yKAh  Ѷ#         api/Process/Utf8Process.php  yKAh  x         api/Process/ProcessRunner.php  yKAh  |E         api/Process/AbstractProcess.php  yKAh  6?=         api/Process/ContaoConsole.php   yKAh   v)1      #   api/Process/PhpExecutableFinder.php  yKAh  r      %   api/Process/ConsoleProcessFactory.php  yKAh  k         api/console8  yKAh8  i.      $   api/EventListener/LocaleListener.php.  yKAh.        '   api/EventListener/ExceptionListener.php~
  yKAh~
  
      &   api/EventListener/SecurityListener.php  yKAh  O      '   api/EventListener/CheckTotpListener.php  yKAh  5%T      )   api/EventListener/JsonRequestListener.phpM  yKAhM  ä      
   downgrade.php0  yKAh0  8-ˤ      $   vendor/seld/phar-utils/composer.lock/  yKAh/  cւ(         vendor/seld/phar-utils/LICENSE"  yKAh"  ?e          vendor/seld/phar-utils/README.mde  yKAhe  :N      $   vendor/seld/phar-utils/composer.json;  yKAh;  =      %   vendor/seld/phar-utils/src/Linter.php
  yKAh
  #:	      )   vendor/seld/phar-utils/src/Timestamps.phpk  yKAhk  F         vendor/seld/jsonlint/LICENSE"  yKAh"  asy      !   vendor/seld/jsonlint/bin/jsonlint  yKAh   
      !   vendor/seld/jsonlint/CHANGELOG.md	  yKAh	  ݣʤ         vendor/seld/jsonlint/README.md
  yKAh
  f      "   vendor/seld/jsonlint/composer.jsonU  yKAhU  TR      @   vendor/seld/jsonlint/src/Seld/JsonLint/DuplicateKeyException.php  yKAh  ArQ      ;   vendor/seld/jsonlint/src/Seld/JsonLint/ParsingException.php  yKAh  m2;      0   vendor/seld/jsonlint/src/Seld/JsonLint/Lexer.php"  yKAh"  ;      4   vendor/seld/jsonlint/src/Seld/JsonLint/Undefined.php*  yKAh*        5   vendor/seld/jsonlint/src/Seld/JsonLint/JsonParser.php,_  yKAh,_  v      "   vendor/seld/signal-handler/LICENSE"  yKAh"  ?e      (   vendor/seld/signal-handler/composer.json  yKAh  c      0   vendor/seld/signal-handler/src/SignalHandler.phpO  yKAhO  ,C         vendor/autoload.php  yKAh  {
^      $   vendor/phpstan/phpdoc-parser/LICENSEQ  yKAhQ  w      &   vendor/phpstan/phpdoc-parser/README.md  yKAh  0h      )   vendor/phpstan/phpdoc-parser/UPGRADING.md#  yKAh#  &~g      *   vendor/phpstan/phpdoc-parser/composer.json  yKAh  R	      0   vendor/phpstan/phpdoc-parser/src/Lexer/Lexer.php  yKAh  &eo      5   vendor/phpstan/phpdoc-parser/src/Printer/DiffElem.php  yKAh  
      3   vendor/phpstan/phpdoc-parser/src/Printer/Differ.phpj  yKAhj  yT      4   vendor/phpstan/phpdoc-parser/src/Printer/Printer.phpG  yKAhG  |"&v      ;   vendor/phpstan/phpdoc-parser/src/Parser/ParserException.php	  yKAh	  2Ф      8   vendor/phpstan/phpdoc-parser/src/Parser/PhpDocParser.phpޭ  yKAhޭ   a      ;   vendor/phpstan/phpdoc-parser/src/Parser/ConstExprParser.php!  yKAh!  HH      ;   vendor/phpstan/phpdoc-parser/src/Parser/StringUnescaper.php\
  yKAh\
  k'#      6   vendor/phpstan/phpdoc-parser/src/Parser/TypeParser.php_  yKAh_  YeG      9   vendor/phpstan/phpdoc-parser/src/Parser/TokenIterator.php8)  yKAh8)  \j      1   vendor/phpstan/phpdoc-parser/src/ParserConfig.php`  yKAh`  Kä      V   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PureUnlessCallableIsImpureTagValueNode.php  yKAh  ;      A   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/MixinTagValueNode.php  yKAh  0      D   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TemplateTagValueNode.php  yKAh        B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/AssertTagValueNode.php:  yKAh:  
f      B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ThrowsTagValueNode.php  yKAh  }      U   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamLaterInvokedCallableTagValueNode.php  yKAh  OS^      B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocTagValueNode.php   yKAh   ck      J   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/AssertTagPropertyValueNode.php  yKAh  -      M   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/RequireImplementsTagValueNode.php  yKAh  Z3      F   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ImplementsTagValueNode.php  yKAh  ^Ĥ      >   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocTextNode.php  yKAh  h%      :   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocNode.phpI)  yKAhI)        L   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamClosureThisTagValueNode.php-  yKAh-  =H      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/GenericTagValueNode.php  yKAh  ~T      E   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TypeAliasTagValueNode.phpc  yKAhc        B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ReturnTagValueNode.php  yKAh  ^T      @   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/UsesTagValueNode.php  yKAh  Z!K      K   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/MethodTagValueParameterNode.php4  yKAh4  ܤ      I   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineArgument.php  yKAh  =      K   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineAnnotation.php  yKAh  ;k      M   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineTagValueNode.php  yKAh  j$Ѥ      J   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineArrayItem.php  yKAh  K      F   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/Doctrine/DoctrineArray.php  yKAh  (Ҥ      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/InvalidTagValueNode.php  yKAh  ^ߤ      ?   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/VarTagValueNode.phpL  yKAhL  KHx      =   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocTagNode.php  yKAh  ɿ      D   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamOutTagValueNode.php%  yKAh%        I   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TypelessParamTagValueNode.php  yKAh  m#w      H   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/AssertTagMethodValueNode.php  yKAh  {֤      K   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/TypeAliasImportTagValueNode.php  yKAh  jW      D   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PropertyTagValueNode.php   yKAh   7b!      [   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamImmediatelyInvokedCallableTagValueNode.php  yKAh  'D      ?   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/PhpDocChildNode.php   yKAh   )5Q      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ExtendsTagValueNode.php  yKAh  ݤ      A   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/ParamTagValueNode.phpU  yKAhU  ~,      B   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/MethodTagValueNode.php  yKAh  7Ǥ      C   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/SelfOutTagValueNode.php  yKAh  L~      F   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/DeprecatedTagValueNode.php  yKAh  K]C      J   vendor/phpstan/phpdoc-parser/src/Ast/PhpDoc/RequireExtendsTagValueNode.php  yKAh  >      A   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstFetchNode.php  yKAh  "iT      E   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprArrayNode.phpF  yKAhF  Y7      @   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprNode.php   yKAh         F   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprStringNode.php  yKAh  &m      D   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprTrueNode.php5  yKAh5  #6      G   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprIntegerNode.php  yKAh  80      E   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprFalseNode.php7  yKAh7  c󷯤      I   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprArrayItemNode.php  yKAh  ۋ      D   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprNullNode.php5  yKAh5  "      N   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/DoctrineConstExprStringNode.phpt  yKAht  <      E   vendor/phpstan/phpdoc-parser/src/Ast/ConstExpr/ConstExprFloatNode.php  yKAh  Gʤ      4   vendor/phpstan/phpdoc-parser/src/Ast/NodeVisitor.php
  yKAh
  һc      C   vendor/phpstan/phpdoc-parser/src/Ast/NodeVisitor/CloningVisitor.php  yKAh        2   vendor/phpstan/phpdoc-parser/src/Ast/Attribute.phpp  yKAhp  B      -   vendor/phpstan/phpdoc-parser/src/Ast/Node.php  yKAh  I       ;   vendor/phpstan/phpdoc-parser/src/Ast/Type/UnionTypeNode.php  yKAh  '¤      B   vendor/phpstan/phpdoc-parser/src/Ast/Type/IntersectionTypeNode.php
  yKAh
  m      @   vendor/phpstan/phpdoc-parser/src/Ast/Type/IdentifierTypeNode.php  yKAh  z21      @   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayShapeItemNode.php  yKAh  o=      ;   vendor/phpstan/phpdoc-parser/src/Ast/Type/ConstTypeNode.php  yKAh  V0	      G   vendor/phpstan/phpdoc-parser/src/Ast/Type/CallableTypeParameterNode.php  yKAh        >   vendor/phpstan/phpdoc-parser/src/Ast/Type/CallableTypeNode.phpz  yKAhz  z"      6   vendor/phpstan/phpdoc-parser/src/Ast/Type/TypeNode.php   yKAh   9      A   vendor/phpstan/phpdoc-parser/src/Ast/Type/ObjectShapeItemNode.php  yKAh  [Z      :   vendor/phpstan/phpdoc-parser/src/Ast/Type/ThisTypeNode.php'  yKAh'  |      =   vendor/phpstan/phpdoc-parser/src/Ast/Type/ObjectShapeNode.phpR  yKAhR  7Nf      =   vendor/phpstan/phpdoc-parser/src/Ast/Type/InvalidTypeNode.phpg  yKAhg  L      B   vendor/phpstan/phpdoc-parser/src/Ast/Type/OffsetAccessTypeNode.php  yKAh  4      A   vendor/phpstan/phpdoc-parser/src/Ast/Type/ConditionalTypeNode.php  yKAh  Rפ      H   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayShapeUnsealedTypeNode.php  yKAh  t       M   vendor/phpstan/phpdoc-parser/src/Ast/Type/ConditionalTypeForParameterNode.php  yKAh  +$      >   vendor/phpstan/phpdoc-parser/src/Ast/Type/NullableTypeNode.php  yKAh  qo      <   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayShapeNode.php  yKAh  \鿤      =   vendor/phpstan/phpdoc-parser/src/Ast/Type/GenericTypeNode.php.  yKAh.  3      ;   vendor/phpstan/phpdoc-parser/src/Ast/Type/ArrayTypeNode.phpi  yKAhi  <p      <   vendor/phpstan/phpdoc-parser/src/Ast/AbstractNodeVisitor.php  yKAh  }$      0   vendor/phpstan/phpdoc-parser/src/Ast/Comment.php  yKAh  c軤      7   vendor/phpstan/phpdoc-parser/src/Ast/NodeAttributes.php+  yKAh+        6   vendor/phpstan/phpdoc-parser/src/Ast/NodeTraverser.php*  yKAh*           vendor/lcobucci/clock/LICENSE.  yKAh.  >z      #   vendor/lcobucci/clock/renovate.json   yKAh   ]G(      #   vendor/lcobucci/clock/composer.json,  yKAh,  ;      #   vendor/lcobucci/clock/src/Clock.php   yKAh   *	      )   vendor/lcobucci/clock/src/FrozenClock.php*  yKAh*  8o      )   vendor/lcobucci/clock/src/SystemClock.php  yKAh            vendor/bin/yaml-lint
  yKAh
  8<h      "   vendor/bin/patch-type-declarations`
  yKAh`
  +դ         vendor/bin/validate-json0
  yKAh0
  ̤         vendor/bin/composer	
  yKAh	
  k?ۤ         vendor/bin/var-dump-server?
  yKAh?
  &j         vendor/bin/jsonlint  yKAh  X      $   vendor/web-auth/webauthn-lib/LICENSE1  yKAh1  2      *   vendor/web-auth/webauthn-lib/composer.json	  yKAh	  =K      <   vendor/web-auth/webauthn-lib/src/FakeCredentialGenerator.php1  yKAh1  cF,Ȥ      1   vendor/web-auth/webauthn-lib/src/StringStream.php'  yKAh'  K1ۤ      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckAlgorithm.php$  yKAh$  $      D   vendor/web-auth/webauthn-lib/src/CeremonyStep/TopOriginValidator.php   yKAh   Q      A   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckUserHandle.php  yKAh         P   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckHasAttestedCredentialData.phpC  yKAhC  $Q      E   vendor/web-auth/webauthn-lib/src/CeremonyStep/CeremonyStepManager.php  yKAh  \TP      G   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckUserVerification.php3  yKAh3  PX,      L   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckAllowedCredentialList.php  yKAh        C   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckCredentialId.php  yKAh  \	      W   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckAttestationFormatIsKnownAndValid.phpH  yKAhH  $@s      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckSignature.php  yKAh  !Ǥ      H   vendor/web-auth/webauthn-lib/src/CeremonyStep/HostTopOriginValidator.php
  yKAh
  #o      K   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckRelyingPartyIdIdHash.php
  yKAh
  Oû      N   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckBackupBitsAreConsistent.php  yKAh  a      E   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckUserWasPresent.php  yKAh  w      N   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckClientDataCollectorType.php  yKAh  =&      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckChallenge.php  yKAh  g      >   vendor/web-auth/webauthn-lib/src/CeremonyStep/CeremonyStep.php  yKAh  ujv      >   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckCounter.php  yKAh  ʤ      @   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckTopOrigin.php  yKAh  "      =   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckOrigin.php  yKAh  Ť      A   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckExtensions.phpt  yKAht  =      H   vendor/web-auth/webauthn-lib/src/CeremonyStep/CheckMetadataStatement.php	   yKAh	   `      L   vendor/web-auth/webauthn-lib/src/CeremonyStep/CeremonyStepManagerFactory.php  yKAh  ^fr      B   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialUserEntity.php  yKAh  yP      7   vendor/web-auth/webauthn-lib/src/CertificateToolbox.php  yKAh  µ      V   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensions.php  yKAh  ;k      [   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/ExtensionOutputCheckerHandler.php}  yKAh}  %}h      b   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensionsClientInputs.php  yKAh  `i      R   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/ExtensionOutputError.php  yKAh  H'      U   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtension.php  yKAh  R      T   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/ExtensionOutputChecker.php   yKAh   DA      c   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensionsClientOutputs.php  yKAh  
QT      i   vendor/web-auth/webauthn-lib/src/AuthenticationExtensions/AuthenticationExtensionsClientOutputsLoader.php  yKAh  D+      e   vendor/web-auth/webauthn-lib/src/AttestationStatement/AndroidSafetyNetAttestationStatementSupport.php66  yKAh66  v      \   vendor/web-auth/webauthn-lib/src/AttestationStatement/FidoU2FAttestationStatementSupport.phpZ  yKAhZ  T      Z   vendor/web-auth/webauthn-lib/src/AttestationStatement/AppleAttestationStatementSupport.phpR  yKAhR  9      Y   vendor/web-auth/webauthn-lib/src/AttestationStatement/NoneAttestationStatementSupport.phpz  yKAhz  |       U   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationStatementSupport.php  yKAh  0Hä      Q   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationObjectLoader.php  yKAh  a      [   vendor/web-auth/webauthn-lib/src/AttestationStatement/PackedAttestationStatementSupport.php+  yKAh+  ɯ      K   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationObject.php  yKAh  _f      _   vendor/web-auth/webauthn-lib/src/AttestationStatement/AndroidKeyAttestationStatementSupport.phpM"  yKAhM"  O~O      \   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationStatementSupportManager.php  yKAh  o      X   vendor/web-auth/webauthn-lib/src/AttestationStatement/TPMAttestationStatementSupport.php=  yKAh=  $3Y      N   vendor/web-auth/webauthn-lib/src/AttestationStatement/AttestationStatement.php  yKAh  *      >   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialLoader.php  yKAh  x&      B   vendor/web-auth/webauthn-lib/src/SimpleFakeCredentialGenerator.php  yKAh  Aݤ      >   vendor/web-auth/webauthn-lib/src/TokenBinding/TokenBinding.php  yKAh  jhդ      H   vendor/web-auth/webauthn-lib/src/TokenBinding/SecTokenBindingHandler.php  yKAh        K   vendor/web-auth/webauthn-lib/src/TokenBinding/IgnoreTokenBindingHandler.php  yKAh  ɗCڤ      Q   vendor/web-auth/webauthn-lib/src/TokenBinding/TokenBindingNotSupportedHandler.php  yKAh  W      E   vendor/web-auth/webauthn-lib/src/TokenBinding/TokenBindingHandler.phph  yKAhh        <   vendor/web-auth/webauthn-lib/src/Util/CoseSignatureFixer.php`  yKAh`  _nW      0   vendor/web-auth/webauthn-lib/src/Util/Base64.phps  yKAhs  ݤ      ;   vendor/web-auth/webauthn-lib/src/AttestedCredentialData.php
  yKAh
  sr      /   vendor/web-auth/webauthn-lib/src/Credential.php  yKAh  h      N   vendor/web-auth/webauthn-lib/src/AuthenticatorAttestationResponseValidator.phpd2  yKAhd2  s      B   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialParameters.php	  yKAh	  #8r      B   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialDescriptor.php 
  yKAh 
  9\o      @   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialRpEntity.phpX  yKAhX  {B      E   vendor/web-auth/webauthn-lib/src/AuthenticatorAttestationResponse.php  yKAh  J      ?   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialOptions.php  yKAh  ^9      6   vendor/web-auth/webauthn-lib/src/AuthenticatorData.phpo
  yKAho
  Wo      L   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialDescriptorCollection.php  yKAh  
?Ҥ      :   vendor/web-auth/webauthn-lib/src/AuthenticatorResponse.php  yKAh  J      L   vendor/web-auth/webauthn-lib/src/AuthenticatorAssertionResponseValidator.php0  yKAh0  Dߤ      C   vendor/web-auth/webauthn-lib/src/AuthenticatorAssertionResponse.php=  yKAh=  Ȫ       W   vendor/web-auth/webauthn-lib/src/CertificateChainChecker/PhpCertificateChainChecker.php  yKAh  {Ϥ      T   vendor/web-auth/webauthn-lib/src/CertificateChainChecker/CertificateChainChecker.php  yKAh  2Ƥ      F   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialRequestOptions.php.  yKAh.  Dg      <   vendor/web-auth/webauthn-lib/src/AuthenticatorDataLoader.php  yKAh  Lڤ      H   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialSourceRepository.php   yKAh   z      >   vendor/web-auth/webauthn-lib/src/TrustPath/TrustPathLoader.php  yKAh  @b      B   vendor/web-auth/webauthn-lib/src/TrustPath/EcdaaKeyIdTrustPath.php  yKAh  ,q      8   vendor/web-auth/webauthn-lib/src/TrustPath/TrustPath.php  yKAh  "ߣ      =   vendor/web-auth/webauthn-lib/src/TrustPath/EmptyTrustPath.php  yKAh  b_      C   vendor/web-auth/webauthn-lib/src/TrustPath/CertificateTrustPath.php  yKAh  A#      >   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialEntity.php  yKAh         L   vendor/web-auth/webauthn-lib/src/ClientDataCollector/ClientDataCollector.phpA  yKAhA  У      S   vendor/web-auth/webauthn-lib/src/ClientDataCollector/ClientDataCollectorManager.php  yKAh  [6      X   vendor/web-auth/webauthn-lib/src/ClientDataCollector/WebauthnAuthenticationCollector.php  yKAh  =m      D   vendor/web-auth/webauthn-lib/src/Counter/ThrowExceptionIfInvalid.phpw  yKAhw  <Sڤ      ;   vendor/web-auth/webauthn-lib/src/Counter/CounterChecker.php  yKAh        V   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticationExtensionsDenormalizer.php	  yKAh	  Jo0Ӥ      R   vendor/web-auth/webauthn-lib/src/Denormalizer/AttestationStatementDenormalizer.php  yKAh        S   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticationExtensionNormalizer.php  yKAh  9A      G   vendor/web-auth/webauthn-lib/src/Denormalizer/TrustPathDenormalizer.php  yKAh        Q   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialDenormalizer.php  yKAh  ژؤ      K   vendor/web-auth/webauthn-lib/src/Denormalizer/WebauthnSerializerFactory.phpF
  yKAhF
  y      Q   vendor/web-auth/webauthn-lib/src/Denormalizer/CollectedClientDataDenormalizer.php  yKAh  ߺ䥤      [   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialParametersDenormalizer.php  yKAh  1      ^   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorAttestationResponseDenormalizer.php:  yKAh:  .֤      R   vendor/web-auth/webauthn-lib/src/Denormalizer/AttestedCredentialDataNormalizer.phpj  yKAhj  !wJ      Y   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialDescriptorNormalizer.phpy  yKAhy  薆      O   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorDataDenormalizer.php  yKAh  IV      O   vendor/web-auth/webauthn-lib/src/Denormalizer/AttestationObjectDenormalizer.php|  yKAh|  =G      W   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialSourceDenormalizer.php  yKAh  h2eԤ      [   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialUserEntityDenormalizer.php  yKAh  Wݤ      Q   vendor/web-auth/webauthn-lib/src/Denormalizer/ExtensionDescriptorDenormalizer.php(  yKAh(  PwФ      _   vendor/web-auth/webauthn-lib/src/Denormalizer/VerificationMethodANDCombinationsDenormalizer.php  yKAh  Eڵ      \   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorAssertionResponseDenormalizer.php  yKAh  s2P      S   vendor/web-auth/webauthn-lib/src/Denormalizer/AuthenticatorResponseDenormalizer.php  yKAh  Wi      X   vendor/web-auth/webauthn-lib/src/Denormalizer/PublicKeyCredentialOptionsDenormalizer.php  yKAh  w~      8   vendor/web-auth/webauthn-lib/src/PublicKeyCredential.php  yKAh        D   vendor/web-auth/webauthn-lib/src/MetadataService/Psr18HttpClient.phpf  yKAhf  	\      K   vendor/web-auth/webauthn-lib/src/MetadataService/StatusReportRepository.php3  yKAh3  |`4&      _   vendor/web-auth/webauthn-lib/src/MetadataService/CertificateChain/CertificateChainValidator.phpT  yKAhT  Ѓv      X   vendor/web-auth/webauthn-lib/src/MetadataService/CertificateChain/CertificateToolbox.php  yKAh  W֮y      b   vendor/web-auth/webauthn-lib/src/MetadataService/CertificateChain/PhpCertificateChainValidator.php'  yKAh'  K%C      ?   vendor/web-auth/webauthn-lib/src/MetadataService/CanLogData.php   yKAh   .j       P   vendor/web-auth/webauthn-lib/src/MetadataService/MetadataStatementRepository.php  yKAh  8T      R   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/ExtensionDescriptor.php  yKAh  I      U   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/CodeAccuracyDescriptor.php	  yKAh	  P2      X   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/PatternAccuracyDescriptor.php	  yKAh	  7\      P   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/MetadataStatement.phpQ  yKAhQ  02      S   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AuthenticatorGetInfo.php  yKAh  ;T      `   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/VerificationMethodANDCombinations.php  yKAh  J      T   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/BiometricStatusReport.php  yKAh  t%{      R   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AuthenticatorStatus.php  yKAh  IJ>      Q   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AbstractDescriptor.phpC  yKAhC  e0@      O   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/EcdaaTrustAnchor.php0
  yKAh0
  Ҩ      K   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/StatusReport.php7  yKAh7  P	      [   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/VerificationMethodDescriptor.php!  yKAh!   +9      V   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/AlternativeDescriptions.php+  yKAh+  c      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/BiometricAccuracyDescriptor.php	  yKAh	  nX}}      F   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/Version.phpV	  yKAhV	        N   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/RgbPaletteEntry.php\	  yKAh\	  Pnu      M   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/RogueListEntry.php  yKAh  x"#      b   vendor/web-auth/webauthn-lib/src/MetadataService/Statement/DisplayPNGCharacteristicsDescriptor.php  yKAh  ꠼      @   vendor/web-auth/webauthn-lib/src/MetadataService/ValueFilter.phpo  yKAho  jPOϤ      a   vendor/web-auth/webauthn-lib/src/MetadataService/Denormalizer/ExtensionDescriptorDenormalizer.php  yKAh  Ћz      d   vendor/web-auth/webauthn-lib/src/MetadataService/Denormalizer/MetadataStatementSerializerFactory.php  yKAh  yx      a   vendor/web-auth/webauthn-lib/src/MetadataService/Service/FidoAllianceCompliantMetadataService.php'  yKAh'  +X5դ      P   vendor/web-auth/webauthn-lib/src/MetadataService/Service/JsonMetadataService.php	  yKAh	  K      R   vendor/web-auth/webauthn-lib/src/MetadataService/Service/StringMetadataService.php  yKAh  :)Ĥ      U   vendor/web-auth/webauthn-lib/src/MetadataService/Service/MetadataBLOBPayloadEntry.php  yKAh  7      [   vendor/web-auth/webauthn-lib/src/MetadataService/Service/DistantResourceMetadataService.php  yKAh  fB      P   vendor/web-auth/webauthn-lib/src/MetadataService/Service/MetadataBLOBPayload.php  yKAh  4n      L   vendor/web-auth/webauthn-lib/src/MetadataService/Service/MetadataService.php  yKAh        Y   vendor/web-auth/webauthn-lib/src/MetadataService/Service/LocalResourceMetadataService.php

  yKAh

  i      T   vendor/web-auth/webauthn-lib/src/MetadataService/Service/ChainedMetadataServices.php  yKAh        Z   vendor/web-auth/webauthn-lib/src/MetadataService/Service/FolderResourceMetadataService.php
  yKAh
  -NZ      T   vendor/web-auth/webauthn-lib/src/MetadataService/Service/InMemoryMetadataService.phpA  yKAhA  T      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/InvalidCertificateException.php  yKAh  z]      W   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MetadataServiceException.php  yKAh  Y1ص      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/ExpiredCertificateException.php  yKAh  g/      S   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/CertificateException.phpq  yKAhq  h      `   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MissingMetadataStatementException.php  yKAh  m %      Z   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/RevokedCertificateException.php  yKAh  /      `   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MetadataStatementLoadingException.php  yKAh  /V      Y   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/MetadataStatementException.php  yKAh  c       X   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/CertificateChainException.php  yKAh  ]ཤ      a   vendor/web-auth/webauthn-lib/src/MetadataService/Exception/CertificateRevocationListException.php  yKAh  [      L   vendor/web-auth/webauthn-lib/src/MetadataService/Event/CanDispatchEvents.phpU  yKAhU  x      H   vendor/web-auth/webauthn-lib/src/MetadataService/Event/WebauthnEvent.phpA  yKAhA  o      [   vendor/web-auth/webauthn-lib/src/MetadataService/Event/BeforeCertificateChainValidation.php  yKAh  <s
      [   vendor/web-auth/webauthn-lib/src/MetadataService/Event/CertificateChainValidationFailed.php  yKAh  @2      ^   vendor/web-auth/webauthn-lib/src/MetadataService/Event/CertificateChainValidationSucceeded.php  yKAh  
$      Q   vendor/web-auth/webauthn-lib/src/MetadataService/Event/MetadataStatementFound.phpp  yKAhp  3	      N   vendor/web-auth/webauthn-lib/src/MetadataService/Event/NullEventDispatcher.phpa  yKAha  D
      C   vendor/web-auth/webauthn-lib/src/AuthenticatorSelectionCriteria.phpH   yKAhH   EѤ      X   vendor/web-auth/webauthn-lib/src/Exception/AttestationStatementVerificationException.phpn  yKAhn  66      J   vendor/web-auth/webauthn-lib/src/Exception/InvalidCertificateException.php  yKAh  ,s      S   vendor/web-auth/webauthn-lib/src/Exception/InvalidAttestationStatementException.php  yKAh        G   vendor/web-auth/webauthn-lib/src/Exception/MetadataServiceException.php1  yKAh1  \	      O   vendor/web-auth/webauthn-lib/src/Exception/AuthenticationExtensionException.php:  yKAh:  CVs      @   vendor/web-auth/webauthn-lib/src/Exception/WebauthnException.php*  yKAh*  m2      H   vendor/web-auth/webauthn-lib/src/Exception/InvalidTrustPathException.php3  yKAh3  ".      Y   vendor/web-auth/webauthn-lib/src/Exception/AuthenticatorResponseVerificationException.php>  yKAh>  
      J   vendor/web-auth/webauthn-lib/src/Exception/ExpiredCertificateException.php  yKAh  p      J   vendor/web-auth/webauthn-lib/src/Exception/UnsupportedFeatureException.php5  yKAh5  G      C   vendor/web-auth/webauthn-lib/src/Exception/CertificateException.phpO  yKAhO  Zl      P   vendor/web-auth/webauthn-lib/src/Exception/MissingMetadataStatementException.php;  yKAh;  )<Ԥ      J   vendor/web-auth/webauthn-lib/src/Exception/RevokedCertificateException.php   yKAh   cO      L   vendor/web-auth/webauthn-lib/src/Exception/AttestationStatementException.php   yKAh   n      P   vendor/web-auth/webauthn-lib/src/Exception/MetadataStatementLoadingException.phpz  yKAhz  $BC      ?   vendor/web-auth/webauthn-lib/src/Exception/CounterException.phpL  yKAhL        I   vendor/web-auth/webauthn-lib/src/Exception/MetadataStatementException.php   yKAh   ng      H   vendor/web-auth/webauthn-lib/src/Exception/CertificateChainException.php  yKAh  [4ۤ      S   vendor/web-auth/webauthn-lib/src/Exception/AttestationStatementLoadingException.php  yKAh        C   vendor/web-auth/webauthn-lib/src/Exception/InvalidDataException.php  yKAh  ޘ+      Q   vendor/web-auth/webauthn-lib/src/Exception/CertificateRevocationListException.php  yKAh  q9      I   vendor/web-auth/webauthn-lib/src/Exception/InvalidUserHandleException.phpe  yKAhe  |      1   vendor/web-auth/webauthn-lib/src/U2FPublicKey.php  yKAh  T      <   vendor/web-auth/webauthn-lib/src/Event/CanDispatchEvents.php  yKAh  ':      c   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAttestationResponseValidationSucceededEvent.php7  yKAh7  \Z      8   vendor/web-auth/webauthn-lib/src/Event/WebauthnEvent.phpg   yKAhg   >G      B   vendor/web-auth/webauthn-lib/src/Event/AttestationObjectLoaded.php  yKAh  ob      a   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAssertionResponseValidationSucceededEvent.php  yKAh         ^   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAssertionResponseValidationFailedEvent.php  yKAh  o~֤      K   vendor/web-auth/webauthn-lib/src/Event/BeforeCertificateChainValidation.phpX  yKAhX  /      K   vendor/web-auth/webauthn-lib/src/Event/CertificateChainValidationFailed.phpX  yKAhX  p      N   vendor/web-auth/webauthn-lib/src/Event/CertificateChainValidationSucceeded.php[  yKAh[  (ɤ      A   vendor/web-auth/webauthn-lib/src/Event/MetadataStatementFound.php  yKAh  
      >   vendor/web-auth/webauthn-lib/src/Event/NullEventDispatcher.php8  yKAh8  }o      `   vendor/web-auth/webauthn-lib/src/Event/AuthenticatorAttestationResponseValidationFailedEvent.php  yKAh  <?      E   vendor/web-auth/webauthn-lib/src/Event/AttestationStatementLoaded.php  yKAh  |7      >   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialSource.php"  yKAh"  Ik      G   vendor/web-auth/webauthn-lib/src/PublicKeyCredentialCreationOptions.phpo)  yKAho)  í      8   vendor/web-auth/webauthn-lib/src/CollectedClientData.phpr  yKAhr  +Ĥ          vendor/web-auth/cose-lib/LICENSE,  yKAh,  C      "   vendor/web-auth/cose-lib/README.md  yKAh  Ŭ      &   vendor/web-auth/cose-lib/composer.json  yKAh  B:+j      $   vendor/web-auth/cose-lib/SECURITY.md  yKAh  Y{      %   vendor/web-auth/cose-lib/src/Hash.php  yKAh  8pȤ      (   vendor/web-auth/cose-lib/src/Key/Key.php	  yKAh	  o      +   vendor/web-auth/cose-lib/src/Key/RsaKey.php
  yKAh
  ZΤ      1   vendor/web-auth/cose-lib/src/Key/SymmetricKey.php  yKAh  f      +   vendor/web-auth/cose-lib/src/Key/Ec2Key.php  yKAh  ʤ      +   vendor/web-auth/cose-lib/src/Key/OkpKey.php
  yKAh
  ?      9   vendor/web-auth/cose-lib/src/Algorithm/ManagerFactory.php  yKAh  E      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES256.php  yKAh  U0      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ECDSA.php  yKAh  Af      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES384.php  yKAh  "8      F   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ECSignature.php  yKAh  3y      A   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES256K.php  yKAh  8      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/ECDSA/ES512.php  yKAh  ˤ      <   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS1.php  yKAh  ]2      <   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RSA.php  yKAh  #2      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS384.php  yKAh  
f¤      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PS256.php  yKAh  掤      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PS384.php  yKAh  {      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS256.php  yKAh        >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/RS512.php  yKAh  *(z      ?   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PSSRSA.php\  yKAh\  i"      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/RSA/PS512.php  yKAh  kJ      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/Ed512.php  yKAh  ƩK      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/EdDSA.php  yKAh  ~e0      @   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/Ed256.php  yKAh  Xy      B   vendor/web-auth/cose-lib/src/Algorithm/Signature/EdDSA/Ed25519.php@  yKAh@  	      >   vendor/web-auth/cose-lib/src/Algorithm/Signature/Signature.phpV  yKAhV  ;      4   vendor/web-auth/cose-lib/src/Algorithm/Algorithm.php   yKAh   =
h      4   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS512.php  yKAh  4X e      3   vendor/web-auth/cose-lib/src/Algorithm/Mac/Hmac.php  yKAh  Jd      2   vendor/web-auth/cose-lib/src/Algorithm/Mac/Mac.phpJ  yKAhJ  l'      4   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS384.php  yKAh  5YF      ?   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS256Truncated64.php  yKAh  y      4   vendor/web-auth/cose-lib/src/Algorithm/Mac/HS256.php  yKAh        2   vendor/web-auth/cose-lib/src/Algorithm/Manager.php  yKAh  ,      +   vendor/web-auth/cose-lib/src/BigInteger.php  yKAh  Yy      +   vendor/web-auth/cose-lib/src/Algorithms.phpX  yKAhX  S@      '   vendor/composer/autoload_namespaces.php   yKAh   /t      &   vendor/composer/xdebug-handler/LICENSE)  yKAh)  #;^      +   vendor/composer/xdebug-handler/CHANGELOG.md  yKAh  !YsK      (   vendor/composer/xdebug-handler/README.md4  yKAh4  S%      ,   vendor/composer/xdebug-handler/composer.jsony  yKAhy  -      0   vendor/composer/xdebug-handler/src/PhpConfig.php  yKAh  ]      -   vendor/composer/xdebug-handler/src/Status.phpz  yKAhz  "      4   vendor/composer/xdebug-handler/src/XdebugHandler.phpKV  yKAhKV  Eb      .   vendor/composer/xdebug-handler/src/Process.phpH  yKAhH  G      +   vendor/composer/class-map-generator/LICENSE  yKAh  DӤ      -   vendor/composer/class-map-generator/README.mdN  yKAhN  K(      1   vendor/composer/class-map-generator/composer.json  yKAh  |(~      =   vendor/composer/class-map-generator/src/ClassMapGenerator.phpk6  yKAhk6  2Bgn      :   vendor/composer/class-map-generator/src/PhpFileCleaner.php?  yKAh?  s      4   vendor/composer/class-map-generator/src/FileList.phpc  yKAhc  r5      9   vendor/composer/class-map-generator/src/PhpFileParser.php  yKAh  Ӡ      4   vendor/composer/class-map-generator/src/ClassMap.php  yKAh           vendor/composer/LICENSE.  yKAh.            vendor/composer/ClassLoader.php?  yKAh?  2@u      +   vendor/composer/composer/phpstan/rules.neon  yKAh  ~d      1   vendor/composer/composer/res/composer-schema.json  yKAh  -Zy       6   vendor/composer/composer/res/composer-lock-schema.json
  yKAh
  rf      <   vendor/composer/composer/res/composer-repository-schema.json   yKAh   븂      &   vendor/composer/composer/composer.lockK yKAhK R          vendor/composer/composer/LICENSE,  yKAh,  Vg      %   vendor/composer/composer/bin/composer  yKAh  -0~      $   vendor/composer/composer/bin/compile  yKAh  \0      &   vendor/composer/composer/composer.json  yKAh  Sv'      S   vendor/composer/composer/src/Composer/PHPStan/RuleReasonDataReturnTypeExtension.php
  yKAh
  
      K   vendor/composer/composer/src/Composer/PHPStan/ConfigReturnTypeExtension.phpL"  yKAhL"  W      1   vendor/composer/composer/src/Composer/Factory.php  yKAh  z0      H   vendor/composer/composer/src/Composer/Repository/RepositoryInterface.php  yKAh  й      R   vendor/composer/composer/src/Composer/Repository/InstalledFilesystemRepository.php  yKAh  J=      F   vendor/composer/composer/src/Composer/Repository/PackageRepository.phpl  yKAhl  +Z%      H   vendor/composer/composer/src/Composer/Repository/LockArrayRepository.php  yKAh  Ȥ      G   vendor/composer/composer/src/Composer/Repository/PlatformRepository.php  yKAh  ,+      F   vendor/composer/composer/src/Composer/Repository/RepositoryFactory.php$   yKAh$   8l      Q   vendor/composer/composer/src/Composer/Repository/InstalledRepositoryInterface.php  yKAh  +      P   vendor/composer/composer/src/Composer/Repository/WritableRepositoryInterface.php@  yKAh@  ek      D   vendor/composer/composer/src/Composer/Repository/RepositoryUtils.php
  yKAh
        P   vendor/composer/composer/src/Composer/Repository/RepositorySecurityException.php  yKAh  l	Ф      H   vendor/composer/composer/src/Composer/Repository/CompositeRepository.php  yKAh  $	)      D   vendor/composer/composer/src/Composer/Repository/ArrayRepository.phpw(  yKAhw(  x)      L   vendor/composer/composer/src/Composer/Repository/WritableArrayRepository.php	  yKAh	  X      B   vendor/composer/composer/src/Composer/Repository/VcsRepository.phpR  yKAhR  Bq      G   vendor/composer/composer/src/Composer/Repository/ComposerRepository.php1 yKAh1 h)      C   vendor/composer/composer/src/Composer/Repository/PearRepository.php`  yKAh`        B   vendor/composer/composer/src/Composer/Repository/RepositorySet.phpA  yKAhA  _O      G   vendor/composer/composer/src/Composer/Repository/ArtifactRepository.php  yKAh  e      J   vendor/composer/composer/src/Composer/Repository/RootPackageRepository.php:  yKAh:  V>      F   vendor/composer/composer/src/Composer/Repository/RepositoryManager.php  yKAh  nH      E   vendor/composer/composer/src/Composer/Repository/Vcs/GitHubDriver.phpZ  yKAhZ  U s      B   vendor/composer/composer/src/Composer/Repository/Vcs/VcsDriver.php  yKAh  rO      B   vendor/composer/composer/src/Composer/Repository/Vcs/SvnDriver.php3  yKAh3  ʍE      A   vendor/composer/composer/src/Composer/Repository/Vcs/HgDriver.php6  yKAh6         G   vendor/composer/composer/src/Composer/Repository/Vcs/PerforceDriver.php  yKAh  %6ɤ      K   vendor/composer/composer/src/Composer/Repository/Vcs/GitBitbucketDriver.php8  yKAh8  Mn      B   vendor/composer/composer/src/Composer/Repository/Vcs/GitDriver.php!  yKAh!  Zf      E   vendor/composer/composer/src/Composer/Repository/Vcs/GitLabDriver.php4R  yKAh4R  \6L      K   vendor/composer/composer/src/Composer/Repository/Vcs/VcsDriverInterface.php
  yKAh
  O
4ۤ      E   vendor/composer/composer/src/Composer/Repository/Vcs/FossilDriver.php\  yKAh\  b:      C   vendor/composer/composer/src/Composer/Repository/PathRepository.phpK"  yKAhK"  -Ƥ      J   vendor/composer/composer/src/Composer/Repository/VersionCacheInterface.phpd  yKAhd  ~      K   vendor/composer/composer/src/Composer/Repository/CanonicalPackagesTrait.php  yKAh  =      E   vendor/composer/composer/src/Composer/Repository/FilterRepository.php  yKAh  X      H   vendor/composer/composer/src/Composer/Repository/InstalledRepository.phpI3  yKAhI3  ̤      N   vendor/composer/composer/src/Composer/Repository/AdvisoryProviderInterface.php  yKAh  XD@      I   vendor/composer/composer/src/Composer/Repository/FilesystemRepository.php??  yKAh??  W      M   vendor/composer/composer/src/Composer/Repository/InstalledArrayRepository.php  yKAh  f~      T   vendor/composer/composer/src/Composer/Repository/ConfigurableRepositoryInterface.php  yKAh  F*'      O   vendor/composer/composer/src/Composer/Repository/InvalidRepositoryException.php  yKAh  f=      <   vendor/composer/composer/src/Composer/Util/PackageSorter.phpN  yKAhN  8
      >   vendor/composer/composer/src/Composer/Util/ConfigValidator.php[$  yKAh[$   zf      2   vendor/composer/composer/src/Composer/Util/Git.phpqi  yKAhqi        2   vendor/composer/composer/src/Composer/Util/Svn.php&  yKAh&  sH      =   vendor/composer/composer/src/Composer/Util/NoProxyPattern.php)  yKAh)  x      =   vendor/composer/composer/src/Composer/Util/ComposerMirror.phpW	  yKAhW	  ~w      :   vendor/composer/composer/src/Composer/Util/PackageInfo.phpA  yKAhA  #R      9   vendor/composer/composer/src/Composer/Util/AuthHelper.php8  yKAh8        2   vendor/composer/composer/src/Composer/Util/Zip.phpR
  yKAhR
  Aä      7   vendor/composer/composer/src/Composer/Util/Silencer.php/  yKAh/  <      9   vendor/composer/composer/src/Composer/Util/Filesystem.phpd{  yKAhd{  d}`      2   vendor/composer/composer/src/Composer/Util/Tar.php  yKAh  
Ǥ      5   vendor/composer/composer/src/Composer/Util/GitHub.php!  yKAh!  j\	v      5   vendor/composer/composer/src/Composer/Util/GitLab.php/  yKAh/  |!      8   vendor/composer/composer/src/Composer/Util/Bitbucket.php9&  yKAh9&  	ǽ      =   vendor/composer/composer/src/Composer/Util/HttpDownloader.php)H  yKAh)H  s%G      8   vendor/composer/composer/src/Composer/Util/IniHelper.phpm  yKAhm  7r      7   vendor/composer/composer/src/Composer/Util/Platform.php*  yKAh*  hP      C   vendor/composer/composer/src/Composer/Util/StreamContextFactory.php"  yKAh"  ?x      8   vendor/composer/composer/src/Composer/Util/TlsHelper.php  yKAh  5FϤ      2   vendor/composer/composer/src/Composer/Util/Url.php  yKAh  ʉ٤      7   vendor/composer/composer/src/Composer/Util/Perforce.php2L  yKAh2L  
Ǥ      @   vendor/composer/composer/src/Composer/Util/Http/ProxyManager.php  yKAh  ewY      <   vendor/composer/composer/src/Composer/Util/Http/Response.phpa  yKAha  ^      @   vendor/composer/composer/src/Composer/Util/Http/RequestProxy.php  yKAh  Mg      B   vendor/composer/composer/src/Composer/Util/Http/CurlDownloader.phpy  yKAhy  'B      @   vendor/composer/composer/src/Composer/Util/Http/CurlResponse.php  yKAh  1'ɤ      =   vendor/composer/composer/src/Composer/Util/Http/ProxyItem.php  yKAh  =eY      ?   vendor/composer/composer/src/Composer/Util/MetadataMinifier.php  yKAh  #`      >   vendor/composer/composer/src/Composer/Util/ProcessExecutor.phpE  yKAhE  5U      1   vendor/composer/composer/src/Composer/Util/Hg.php  yKAh  Q5      ?   vendor/composer/composer/src/Composer/Util/RemoteFilesystem.php?l  yKAh?l  q'      ;   vendor/composer/composer/src/Composer/Util/ErrorHandler.php,
  yKAh,
  JC      9   vendor/composer/composer/src/Composer/Util/SyncHelper.php
  yKAh
  ެpQ      3   vendor/composer/composer/src/Composer/Util/Loop.php2  yKAh2        A   vendor/composer/composer/src/Composer/Config/JsonConfigSource.phpv)  yKAhv)        F   vendor/composer/composer/src/Composer/Config/ConfigSourceInterface.phpf  yKAhf  (פ      =   vendor/composer/composer/src/Composer/SelfUpdate/Versions.php  yKAh  .]!      9   vendor/composer/composer/src/Composer/SelfUpdate/Keys.php  yKAh  -*      /   vendor/composer/composer/src/Composer/Cache.php+  yKAh+  @U      ?   vendor/composer/composer/src/Composer/EventDispatcher/Event.php  yKAh  ~ k      R   vendor/composer/composer/src/Composer/EventDispatcher/ScriptExecutionException.php  yKAh  ;;      I   vendor/composer/composer/src/Composer/EventDispatcher/EventDispatcher.php4  yKAh4  Dפ      R   vendor/composer/composer/src/Composer/EventDispatcher/EventSubscriberInterface.phpu  yKAhu  h_}      9   vendor/composer/composer/src/Composer/PartialComposer.php'
  yKAh'
  c      :   vendor/composer/composer/src/Composer/Platform/Runtime.php
	  yKAh
	  :K(      ?   vendor/composer/composer/src/Composer/Platform/HhvmDetector.php  yKAh  H껥      :   vendor/composer/composer/src/Composer/Platform/Version.php
  yKAh
  \      5   vendor/composer/composer/src/Composer/IO/BufferIO.php  yKAh  '˄      6   vendor/composer/composer/src/Composer/IO/ConsoleIO.phpK)  yKAhK)  51      3   vendor/composer/composer/src/Composer/IO/BaseIO.phpX#  yKAhX#        3   vendor/composer/composer/src/Composer/IO/NullIO.php	  yKAh	  {      8   vendor/composer/composer/src/Composer/IO/IOInterface.phpZ   yKAhZ   
      =   vendor/composer/composer/src/Composer/Plugin/PluginEvents.phpe  yKAhe  1+ˤ      C   vendor/composer/composer/src/Composer/Plugin/PreCommandRunEvent.php2  yKAh2  :q@      K   vendor/composer/composer/src/Composer/Plugin/Capability/CommandProvider.php  yKAh  d,      F   vendor/composer/composer/src/Composer/Plugin/Capability/Capability.php  yKAh  Lk      G   vendor/composer/composer/src/Composer/Plugin/PluginBlockedException.php  yKAh  Nu      =   vendor/composer/composer/src/Composer/Plugin/CommandEvent.phpy  yKAhy  /      @   vendor/composer/composer/src/Composer/Plugin/PluginInterface.php?  yKAh?  #?"      >   vendor/composer/composer/src/Composer/Plugin/PluginManager.phpP  yKAhP  .r      E   vendor/composer/composer/src/Composer/Plugin/PreFileDownloadEvent.php9  yKAh9        F   vendor/composer/composer/src/Composer/Plugin/PostFileDownloadEvent.php
  yKAh
        8   vendor/composer/composer/src/Composer/Plugin/Capable.php  yKAh  u      C   vendor/composer/composer/src/Composer/Plugin/PrePoolCreateEvent.php  yKAh  H      B   vendor/composer/composer/src/Composer/Downloader/RarDownloader.php	  yKAh	  "Ĥ      R   vendor/composer/composer/src/Composer/Downloader/VcsCapableDownloaderInterface.phpC  yKAhC  H      B   vendor/composer/composer/src/Composer/Downloader/VcsDownloader.php4  yKAh4  \4=      H   vendor/composer/composer/src/Composer/Downloader/FilesystemException.php  yKAh  J      D   vendor/composer/composer/src/Composer/Downloader/DownloadManager.phpR<  yKAhR<  H      B   vendor/composer/composer/src/Composer/Downloader/TarDownloader.php  yKAh  K7J      E   vendor/composer/composer/src/Composer/Downloader/FossilDownloader.php  yKAh  WΤ      Q   vendor/composer/composer/src/Composer/Downloader/MaxFileSizeExceededException.php  yKAh  `ܤ      H   vendor/composer/composer/src/Composer/Downloader/DownloaderInterface.php  yKAh  x      A   vendor/composer/composer/src/Composer/Downloader/XzDownloader.phpQ  yKAhQ  aYŤ      A   vendor/composer/composer/src/Composer/Downloader/HgDownloader.php  yKAh  p      B   vendor/composer/composer/src/Composer/Downloader/SvnDownloader.php"  yKAh"  rv      C   vendor/composer/composer/src/Composer/Downloader/FileDownloader.phpCS  yKAhCS  R      J   vendor/composer/composer/src/Composer/Downloader/ChangeReportInterface.php'  yKAh'  }s$      G   vendor/composer/composer/src/Composer/Downloader/TransportException.php  yKAh  ʤ      F   vendor/composer/composer/src/Composer/Downloader/ArchiveDownloader.php!  yKAh!  {Z      L   vendor/composer/composer/src/Composer/Downloader/DvcsDownloaderInterface.php6  yKAh6  1N}      C   vendor/composer/composer/src/Composer/Downloader/PharDownloader.php  yKAh  /&֤      C   vendor/composer/composer/src/Composer/Downloader/PathDownloader.php6  yKAh6  ,_      G   vendor/composer/composer/src/Composer/Downloader/PerforceDownloader.php
  yKAh
  R.      B   vendor/composer/composer/src/Composer/Downloader/GitDownloader.phpa  yKAha  5Ȥ      B   vendor/composer/composer/src/Composer/Downloader/ZipDownloader.phpL9  yKAhL9  0      C   vendor/composer/composer/src/Composer/Downloader/GzipDownloader.php  yKAh  S      0   vendor/composer/composer/src/Composer/Config.phpCa  yKAhCa  ~s      6   vendor/composer/composer/src/Composer/Script/Event.php  yKAh  D]      =   vendor/composer/composer/src/Composer/Script/ScriptEvents.php  yKAh  KGꮤ      M   vendor/composer/composer/src/Composer/Question/StrictConfirmationQuestion.php  yKAh  `a      2   vendor/composer/composer/src/Composer/Composer.php  yKAh  o]Ƥ      F   vendor/composer/composer/src/Composer/Json/JsonValidationException.phpl  yKAhl  exˤ      <   vendor/composer/composer/src/Composer/Json/JsonFormatter.phpe  yKAhe        7   vendor/composer/composer/src/Composer/Json/JsonFile.php3  yKAh3  N      >   vendor/composer/composer/src/Composer/Json/JsonManipulator.php8S  yKAh8S  WT      ;   vendor/composer/composer/src/Composer/InstalledVersions.phpIB  yKAhIB   "      W   vendor/composer/composer/src/Composer/DependencyResolver/Operation/InstallOperation.phpz  yKAhz  =~i      b   vendor/composer/composer/src/Composer/DependencyResolver/Operation/MarkAliasInstalledOperation.phpx  yKAhx  nҤ      Y   vendor/composer/composer/src/Composer/DependencyResolver/Operation/OperationInterface.php  yKAh  }|(̤      V   vendor/composer/composer/src/Composer/DependencyResolver/Operation/UpdateOperation.phpw  yKAhw  c;      V   vendor/composer/composer/src/Composer/DependencyResolver/Operation/SolverOperation.php  yKAh  Iw      Y   vendor/composer/composer/src/Composer/DependencyResolver/Operation/UninstallOperation.phpb  yKAhb  &Yl      d   vendor/composer/composer/src/Composer/DependencyResolver/Operation/MarkAliasUninstalledOperation.php~  yKAh~        H   vendor/composer/composer/src/Composer/DependencyResolver/Transaction.php8  yKAh8  |Ԥ      L   vendor/composer/composer/src/Composer/DependencyResolver/PolicyInterface.php  yKAh         Q   vendor/composer/composer/src/Composer/DependencyResolver/LocalRepoTransaction.php(  yKAh(  tʺ      K   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchGraph.phpA  yKAhA  >      H   vendor/composer/composer/src/Composer/DependencyResolver/GenericRule.php  yKAh  >>MV      L   vendor/composer/composer/src/Composer/DependencyResolver/LockTransaction.php  yKAh  h      C   vendor/composer/composer/src/Composer/DependencyResolver/Solver.phph  yKAhh  s      A   vendor/composer/composer/src/Composer/DependencyResolver/Rule.phpN  yKAhN  d ۤ      J   vendor/composer/composer/src/Composer/DependencyResolver/Rule2Literals.php
  yKAh
  dײ      T   vendor/composer/composer/src/Composer/DependencyResolver/SolverProblemsException.php  yKAh  18M      O   vendor/composer/composer/src/Composer/DependencyResolver/SolverBugException.php  yKAh  /d      J   vendor/composer/composer/src/Composer/DependencyResolver/DefaultPolicy.php(  yKAh(  
8      J   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchNode.php  yKAh  '      D   vendor/composer/composer/src/Composer/DependencyResolver/RuleSet.phpX  yKAhX  q      A   vendor/composer/composer/src/Composer/DependencyResolver/Pool.php   yKAh   ?6lJ      N   vendor/composer/composer/src/Composer/DependencyResolver/MultiConflictRule.phpq  yKAhq  S8e      D   vendor/composer/composer/src/Composer/DependencyResolver/Request.php!  yKAh!  1      J   vendor/composer/composer/src/Composer/DependencyResolver/PoolOptimizer.phpM  yKAhM  	zA      M   vendor/composer/composer/src/Composer/DependencyResolver/RuleSetGenerator.php6  yKAh6  w      F   vendor/composer/composer/src/Composer/DependencyResolver/Decisions.php  yKAh  Q      H   vendor/composer/composer/src/Composer/DependencyResolver/PoolBuilder.php  yKAh  	dA"      D   vendor/composer/composer/src/Composer/DependencyResolver/Problem.php-  yKAh-  3C      L   vendor/composer/composer/src/Composer/DependencyResolver/RuleSetIterator.phpC
  yKAhC
  r      K   vendor/composer/composer/src/Composer/DependencyResolver/RuleWatchChain.php  yKAh  ]      D   vendor/composer/composer/src/Composer/Autoload/AutoloadGenerator.phpM  yKAhM  pN      >   vendor/composer/composer/src/Composer/Autoload/ClassLoader.phpg>  yKAhg>  v      D   vendor/composer/composer/src/Composer/Autoload/ClassMapGenerator.php  yKAh  I%c       A   vendor/composer/composer/src/Composer/Command/SuggestsCommand.php;  yKAh;  :&|      ?   vendor/composer/composer/src/Composer/Command/SearchCommand.php  yKAh  k^      =   vendor/composer/composer/src/Composer/Command/BumpCommand.php&  yKAh&  r      @   vendor/composer/composer/src/Composer/Command/ArchiveCommand.php*!  yKAh*!  sM      >   vendor/composer/composer/src/Composer/Command/AuditCommand.php3  yKAh3  jl      A   vendor/composer/composer/src/Composer/Command/ValidateCommand.phpm$  yKAhm$  撌r      =   vendor/composer/composer/src/Composer/Command/FundCommand.php  yKAh  {      G   vendor/composer/composer/src/Composer/Command/PackageDiscoveryTrait.phpO  yKAhO  G:      D   vendor/composer/composer/src/Composer/Command/ScriptAliasCommand.php
  yKAh
  \       F   vendor/composer/composer/src/Composer/Command/CreateProjectCommand.php^  yKAh^  4Ѥ      =   vendor/composer/composer/src/Composer/Command/BaseCommand.phpB  yKAhB  ?a      A   vendor/composer/composer/src/Composer/Command/OutdatedCommand.phpB  yKAhB  G      E   vendor/composer/composer/src/Composer/Command/DumpAutoloadCommand.php  yKAh        =   vendor/composer/composer/src/Composer/Command/HomeCommand.phpC  yKAhC  rj      B   vendor/composer/composer/src/Composer/Command/ReinstallCommand.php#  yKAh#  "       ?   vendor/composer/composer/src/Composer/Command/RemoveCommand.php;  yKAh;        =   vendor/composer/composer/src/Composer/Command/ShowCommand.php% yKAh% 	EO      @   vendor/composer/composer/src/Composer/Command/InstallCommand.php  yKAh  
q      =   vendor/composer/composer/src/Composer/Command/InitCommand.php([  yKAh([  (!#ͤ      B   vendor/composer/composer/src/Composer/Command/RunScriptCommand.php  yKAh  rm      ?   vendor/composer/composer/src/Composer/Command/ConfigCommand.phpȜ  yKAhȜ  J瑤      A   vendor/composer/composer/src/Composer/Command/LicensesCommand.php  yKAh  8$䂤      ?   vendor/composer/composer/src/Composer/Command/UpdateCommand.phpeN  yKAheN  J(      ?   vendor/composer/composer/src/Composer/Command/StatusCommand.php{   yKAh{   C      G   vendor/composer/composer/src/Composer/Command/BaseDependencyCommand.php3  yKAh3        @   vendor/composer/composer/src/Composer/Command/DependsCommand.php  yKAh  vN      B   vendor/composer/composer/src/Composer/Command/ProhibitsCommand.php  yKAh   &      J   vendor/composer/composer/src/Composer/Command/CheckPlatformReqsCommand.php  yKAh  Yj      C   vendor/composer/composer/src/Composer/Command/SelfUpdateCommand.phpi  yKAhi        @   vendor/composer/composer/src/Composer/Command/RequireCommand.phps  yKAhs  ^;      A   vendor/composer/composer/src/Composer/Command/CompletionTrait.php#  yKAh#  "i      C   vendor/composer/composer/src/Composer/Command/ClearCacheCommand.phpX
  yKAhX
  (      A   vendor/composer/composer/src/Composer/Command/DiagnoseCommand.phpF  yKAhF  Þ      ?   vendor/composer/composer/src/Composer/Command/GlobalCommand.php  yKAh  ~i      >   vendor/composer/composer/src/Composer/Command/AboutCommand.php  yKAh  
      =   vendor/composer/composer/src/Composer/Command/ExecCommand.php>  yKAh>  Ƙi      3   vendor/composer/composer/src/Composer/Installer.php  yKAh  MI      m   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/PlatformRequirementFilterInterface.php  yKAh         m   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreAllPlatformRequirementFilter.php  yKAh  u      n   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreListPlatformRequirementFilter.php  yKAh  f      q   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/IgnoreNothingPlatformRequirementFilter.php  yKAh  u      k   vendor/composer/composer/src/Composer/Filter/PlatformRequirementFilter/PlatformRequirementFilterFactory.php  yKAh  $¤      A   vendor/composer/composer/src/Composer/Installer/PackageEvents.php"  yKAh"  ]m      C   vendor/composer/composer/src/Composer/Installer/BinaryInstaller.php8  yKAh8  b>      C   vendor/composer/composer/src/Composer/Installer/PluginInstaller.phpw  yKAhw  0\      K   vendor/composer/composer/src/Composer/Installer/BinaryPresenceInterface.php  yKAh  <P      C   vendor/composer/composer/src/Composer/Installer/InstallerEvents.php  yKAh  "e      @   vendor/composer/composer/src/Composer/Installer/PackageEvent.php  yKAh  T      B   vendor/composer/composer/src/Composer/Installer/InstallerEvent.php  yKAh  r>      D   vendor/composer/composer/src/Composer/Installer/LibraryInstaller.php&,  yKAh&,        F   vendor/composer/composer/src/Composer/Installer/InstallerInterface.php1  yKAh1  K;      H   vendor/composer/composer/src/Composer/Installer/MetapackageInstaller.php  yKAh  ն٤      D   vendor/composer/composer/src/Composer/Installer/ProjectInstaller.php
  yKAh
        M   vendor/composer/composer/src/Composer/Installer/SuggestedPackagesReporter.php  yKAh  vӤ      G   vendor/composer/composer/src/Composer/Installer/InstallationManager.php`  yKAh`  @!      A   vendor/composer/composer/src/Composer/Installer/NoopInstaller.phpY  yKAhY  ^.      C   vendor/composer/composer/src/Composer/Advisory/SecurityAdvisory.php  yKAh  ݭ      J   vendor/composer/composer/src/Composer/Advisory/PartialSecurityAdvisory.php  yKAh  u      :   vendor/composer/composer/src/Composer/Advisory/Auditor.php=  yKAh=  ̶Ҥ      J   vendor/composer/composer/src/Composer/Advisory/IgnoredSecurityAdvisory.phpk  yKAhk  K`      R   vendor/composer/composer/src/Composer/Exception/IrrecoverableDownloadException.php  yKAh        B   vendor/composer/composer/src/Composer/Exception/NoSslException.php  yKAh  ;P      2   vendor/composer/composer/src/Composer/Compiler.php-  yKAh-  zq      9   vendor/composer/composer/src/Composer/Package/Package.phpD  yKAhD  i?f      6   vendor/composer/composer/src/Composer/Package/Link.php
  yKAh
  +H      J   vendor/composer/composer/src/Composer/Package/CompletePackageInterface.php  yKAh  }{+      I   vendor/composer/composer/src/Composer/Package/Archiver/ArchiveManager.php$  yKAh$        P   vendor/composer/composer/src/Composer/Package/Archiver/ArchivableFilesFinder.phpq  yKAhq  ߶q      G   vendor/composer/composer/src/Composer/Package/Archiver/PharArchiver.php  yKAh  ǁM      L   vendor/composer/composer/src/Composer/Package/Archiver/BaseExcludeFilter.php  yKAh  @ݤ      P   vendor/composer/composer/src/Composer/Package/Archiver/ArchivableFilesFilter.php  yKAh  ߵ      K   vendor/composer/composer/src/Composer/Package/Archiver/GitExcludeFilter.php  yKAh  ^      P   vendor/composer/composer/src/Composer/Package/Archiver/ComposerExcludeFilter.php  yKAh  ޣ      L   vendor/composer/composer/src/Composer/Package/Archiver/ArchiverInterface.php  yKAh  ;w      F   vendor/composer/composer/src/Composer/Package/Archiver/ZipArchiver.php  yKAh  L      F   vendor/composer/composer/src/Composer/Package/CompleteAliasPackage.php  yKAh  lN(      >   vendor/composer/composer/src/Composer/Package/AliasPackage.phpe'  yKAhe'  Ҥ      8   vendor/composer/composer/src/Composer/Package/Locker.php/X  yKAh/X        B   vendor/composer/composer/src/Composer/Package/PackageInterface.php00  yKAh00  "'      G   vendor/composer/composer/src/Composer/Package/Version/VersionBumper.phpS  yKAhS  p      I   vendor/composer/composer/src/Composer/Package/Version/StabilityFilter.php  yKAh  5      H   vendor/composer/composer/src/Composer/Package/Version/VersionGuesser.phpWH  yKAhWH  kS      I   vendor/composer/composer/src/Composer/Package/Version/VersionSelector.php0  yKAh0  
      G   vendor/composer/composer/src/Composer/Package/Version/VersionParser.php  yKAh  
?      N   vendor/composer/composer/src/Composer/Package/Loader/ValidatingArrayLoader.phpu  yKAhu  _U      P   vendor/composer/composer/src/Composer/Package/Loader/InvalidPackageException.phpo  yKAho  ,Ҥ      D   vendor/composer/composer/src/Composer/Package/Loader/ArrayLoader.phpF  yKAhF  W
      H   vendor/composer/composer/src/Composer/Package/Loader/LoaderInterface.phpj  yKAhj  7      J   vendor/composer/composer/src/Composer/Package/Loader/RootPackageLoader.phpO.  yKAhO.  pk      C   vendor/composer/composer/src/Composer/Package/Loader/JsonLoader.phpc  yKAhc  ܝ@      =   vendor/composer/composer/src/Composer/Package/BasePackage.php  yKAh  $8      C   vendor/composer/composer/src/Composer/Package/Comparer/Comparer.php  yKAh  fɋ      B   vendor/composer/composer/src/Composer/Package/RootAliasPackage.php  yKAh  r      A   vendor/composer/composer/src/Composer/Package/CompletePackage.php@  yKAh@  ew      F   vendor/composer/composer/src/Composer/Package/RootPackageInterface.php  yKAh  S      =   vendor/composer/composer/src/Composer/Package/RootPackage.phpZ  yKAhZ  k      D   vendor/composer/composer/src/Composer/Package/Dumper/ArrayDumper.php  yKAh  )=      =   vendor/composer/composer/src/Composer/Console/Application.php$  yKAh$  d      C   vendor/composer/composer/src/Composer/Console/GithubActionError.phpl  yKAhl  g`+      E   vendor/composer/composer/src/Composer/Console/Input/InputArgument.php
  yKAh
  &o      C   vendor/composer/composer/src/Composer/Console/Input/InputOption.php  yKAh  (C      E   vendor/composer/composer/src/Composer/Console/HtmlOutputFormatter.php1  yKAh1  g?Ѥ      *   vendor/composer/composer/src/bootstrap.php7  yKAh7  t      (   vendor/composer/ca-bundle/res/cacert.pemf yKAhf 7n      !   vendor/composer/ca-bundle/LICENSE  yKAh  *!^`      #   vendor/composer/ca-bundle/README.md1  yKAh1  >VuĤ      '   vendor/composer/ca-bundle/composer.json5  yKAh5  y:      *   vendor/composer/ca-bundle/src/CaBundle.phpE+  yKAhE+  &V      !   vendor/composer/autoload_psr4.php  yKAh        %   vendor/composer/autoload_classmap.php yKAh 7      "   vendor/composer/platform_check.php  yKAh        #   vendor/composer/autoload_static.php yKAh rP]      !   vendor/composer/autoload_real.php  yKAh           vendor/composer/semver/LICENSE  yKAh  Bh      #   vendor/composer/semver/CHANGELOG.mdi'  yKAhi'  [L          vendor/composer/semver/README.mdH
  yKAhH
   }Τ      $   vendor/composer/semver/composer.json  yKAh  z)      /   vendor/composer/semver/src/CompilingMatcher.php
  yKAh
  F      '   vendor/composer/semver/src/Interval.phpu  yKAhu         )   vendor/composer/semver/src/Comparator.php<
  yKAh<
  <L      (   vendor/composer/semver/src/Intervals.phpLP  yKAhLP  K.      %   vendor/composer/semver/src/Semver.phpr
  yKAhr
  Τ      ,   vendor/composer/semver/src/VersionParser.phpSU  yKAhSU  <J?F      =   vendor/composer/semver/src/Constraint/ConstraintInterface.php  yKAh  겤      9   vendor/composer/semver/src/Constraint/MultiConstraint.php#  yKAh#  o      4   vendor/composer/semver/src/Constraint/Constraint.php2  yKAh2  *      <   vendor/composer/semver/src/Constraint/MatchAllConstraint.php,  yKAh,  [j<      =   vendor/composer/semver/src/Constraint/MatchNoneConstraint.php(  yKAh(  h      /   vendor/composer/semver/src/Constraint/Bound.php
  yKAh
        "   vendor/composer/autoload_files.phpD  yKAhD  VV2      %   vendor/composer/InstalledVersions.phpC  yKAhC  Ȱ         vendor/composer/installed.phpGa  yKAhGa  /ָ         vendor/composer/pcre/LICENSE  yKAh  hg^         vendor/composer/pcre/README.md!  yKAh!  B      #   vendor/composer/pcre/extension.neon  yKAh  &&1      "   vendor/composer/pcre/composer.json  yKAh  r7      E   vendor/composer/pcre/src/PHPStan/PregMatchTypeSpecifyingExtension.php  yKAh  UJl      L   vendor/composer/pcre/src/PHPStan/PregReplaceCallbackClosureTypeExtension.php`
  yKAh`
  |~      G   vendor/composer/pcre/src/PHPStan/PregMatchParameterOutTypeExtension.php  yKAh        <   vendor/composer/pcre/src/PHPStan/InvalidRegexPatternRule.phpV  yKAhV   r      3   vendor/composer/pcre/src/PHPStan/PregMatchFlags.php		  yKAh		  wD3B      ?   vendor/composer/pcre/src/PHPStan/UnsafeStrictGroupsCallRule.php
  yKAh
  tCs      (   vendor/composer/pcre/src/MatchResult.php  yKAh  ڇҤ      "   vendor/composer/pcre/src/Regex.php  yKAh  ɤ      6   vendor/composer/pcre/src/MatchAllWithOffsetsResult.php  yKAh        3   vendor/composer/pcre/src/MatchWithOffsetsResult.php  yKAh  o      7   vendor/composer/pcre/src/MatchAllStrictGroupsResult.phpw  yKAhw  Q      9   vendor/composer/pcre/src/UnexpectedNullMatchException.php"  yKAh"  _      4   vendor/composer/pcre/src/MatchStrictGroupsResult.php  yKAh        +   vendor/composer/pcre/src/MatchAllResult.php  yKAh  	Z      *   vendor/composer/pcre/src/ReplaceResult.php  yKAh  /      !   vendor/composer/pcre/src/Preg.phpE  yKAhE  ]G      *   vendor/composer/pcre/src/PcreException.phpw  yKAhw  'v      )   vendor/composer/metadata-minifier/LICENSE  yKAh  hg^      +   vendor/composer/metadata-minifier/README.mdL  yKAhL  Mv<      3   vendor/composer/metadata-minifier/phpstan.neon.distB   yKAhB   #f      /   vendor/composer/metadata-minifier/composer.json  yKAh  D0פ      :   vendor/composer/metadata-minifier/src/MetadataMinifier.php
  yKAh
         6   vendor/composer/spdx-licenses/res/spdx-exceptions.json  yKAh  L(      4   vendor/composer/spdx-licenses/res/spdx-licenses.json! yKAh!       %   vendor/composer/spdx-licenses/LICENSE  yKAh  Bh      '   vendor/composer/spdx-licenses/README.md<  yKAh<  se      +   vendor/composer/spdx-licenses/composer.json  yKAh  Ť      2   vendor/composer/spdx-licenses/src/SpdxLicenses.php%  yKAh%  ]H
      .   vendor/phpdocumentor/reflection-common/LICENSE9  yKAh9  *2Ȑ      0   vendor/phpdocumentor/reflection-common/README.mdO  yKAhO  
һ      4   vendor/phpdocumentor/reflection-common/composer.json  yKAh  k6      6   vendor/phpdocumentor/reflection-common/src/Element.php  yKAh  7      =   vendor/phpdocumentor/reflection-common/src/ProjectFactory.phpf  yKAhf        3   vendor/phpdocumentor/reflection-common/src/File.php  yKAh  s      6   vendor/phpdocumentor/reflection-common/src/Project.php  yKAh  c=      4   vendor/phpdocumentor/reflection-common/src/Fqsen.php  yKAh  p      7   vendor/phpdocumentor/reflection-common/src/Location.php  yKAh  ;      *   vendor/phpdocumentor/type-resolver/LICENSE8  yKAh8  ʤ      2   vendor/phpdocumentor/type-resolver/phpdoc.dist.xml  yKAh  DA낤      ,   vendor/phpdocumentor/type-resolver/README.md#  yKAh#  ܵ\      0   vendor/phpdocumentor/type-resolver/composer.json  yKAh  \[      7   vendor/phpdocumentor/type-resolver/src/TypeResolver.phpc]  yKAhc]  v      ;   vendor/phpdocumentor/type-resolver/src/Types/Expression.phpF  yKAhF  PM      8   vendor/phpdocumentor/type-resolver/src/Types/Boolean.php|  yKAh|  M65      8   vendor/phpdocumentor/type-resolver/src/Types/Integer.phpx  yKAhx  jJ&      6   vendor/phpdocumentor/type-resolver/src/Types/Self_.php  yKAh  SY      6   vendor/phpdocumentor/type-resolver/src/Types/Void_.php  yKAh  Dk'٤      6   vendor/phpdocumentor/type-resolver/src/Types/Null_.php  yKAh  G      :   vendor/phpdocumentor/type-resolver/src/Types/Resource_.php  yKAh  JϤ      7   vendor/phpdocumentor/type-resolver/src/Types/Float_.phpu  yKAhu  Hդ      8   vendor/phpdocumentor/type-resolver/src/Types/Object_.php  yKAh  "]!      8   vendor/phpdocumentor/type-resolver/src/Types/String_.php  yKAh  V̤      9   vendor/phpdocumentor/type-resolver/src/Types/Nullable.php`  yKAh`  uy      :   vendor/phpdocumentor/type-resolver/src/Types/Callable_.php  yKAh  l      @   vendor/phpdocumentor/type-resolver/src/Types/InterfaceString.php  yKAh  >^      :   vendor/phpdocumentor/type-resolver/src/Types/Iterable_.phpF  yKAhF   'y      B   vendor/phpdocumentor/type-resolver/src/Types/CallableParameter.php  yKAh  /      9   vendor/phpdocumentor/type-resolver/src/Types/ArrayKey.php  yKAh  ?n)      7   vendor/phpdocumentor/type-resolver/src/Types/Never_.php  yKAh  	'      8   vendor/phpdocumentor/type-resolver/src/Types/Static_.php  yKAh  {6@      <   vendor/phpdocumentor/type-resolver/src/Types/ClassString.php_  yKAh_  g      8   vendor/phpdocumentor/type-resolver/src/Types/Parent_.php  yKAh  ip      7   vendor/phpdocumentor/type-resolver/src/Types/Scalar.php  yKAh  ؤ      8   vendor/phpdocumentor/type-resolver/src/Types/Context.php  yKAh  fYK      =   vendor/phpdocumentor/type-resolver/src/Types/AbstractList.php  yKAh  &      ;   vendor/phpdocumentor/type-resolver/src/Types/Collection.php  yKAh  䅝      =   vendor/phpdocumentor/type-resolver/src/Types/Intersection.php$  yKAh$        ?   vendor/phpdocumentor/type-resolver/src/Types/ContextFactory.php7  yKAh7  v#      ?   vendor/phpdocumentor/type-resolver/src/Types/AggregatedType.php
  yKAh
  C`      9   vendor/phpdocumentor/type-resolver/src/Types/Compound.php  yKAh        5   vendor/phpdocumentor/type-resolver/src/Types/This.phpg  yKAhg  ~+6      7   vendor/phpdocumentor/type-resolver/src/Types/Array_.php  yKAh   NK      7   vendor/phpdocumentor/type-resolver/src/Types/Mixed_.php  yKAh        /   vendor/phpdocumentor/type-resolver/src/Type.php  yKAh  q4      8   vendor/phpdocumentor/type-resolver/src/FqsenResolver.php	  yKAh	  ͢      B   vendor/phpdocumentor/type-resolver/src/PseudoTypes/StringValue.php  yKAh  FI      <   vendor/phpdocumentor/type-resolver/src/PseudoTypes/List_.php  yKAh  O      E   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyString.php}  yKAh}   i      @   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ShapeItem.php+  yKAh+  NG      C   vendor/phpdocumentor/type-resolver/src/PseudoTypes/IntegerRange.phpA  yKAhA  ֭Z$      E   vendor/phpdocumentor/type-resolver/src/PseudoTypes/CallableString.php|  yKAh|        D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ListShapeItem.php   yKAh   곤      ?   vendor/phpdocumentor/type-resolver/src/PseudoTypes/Numeric_.php(  yKAh(  ^6      =   vendor/phpdocumentor/type-resolver/src/PseudoTypes/False_.php  yKAh  /      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ObjectShapeItem.php   yKAh   IC3      B   vendor/phpdocumentor/type-resolver/src/PseudoTypes/TraitString.phpv  yKAhv  {      A   vendor/phpdocumentor/type-resolver/src/PseudoTypes/FloatValue.php  yKAh  4AY      D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NumericString.phpz  yKAhz  *      H   vendor/phpdocumentor/type-resolver/src/PseudoTypes/HtmlEscapedString.php  yKAh  y"Ѥ      C   vendor/phpdocumentor/type-resolver/src/PseudoTypes/IntegerValue.php  yKAh  R4      D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/LiteralString.phpz  yKAhz        C   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyList.php  yKAh  I      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ConstExpression.php  yKAh  oe4      A   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ArrayShape.php  yKAh  frd      N   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyLowercaseString.php  yKAh        D   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NonEmptyArray.php  yKAh  ,      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/LowercaseString.php~  yKAh~  kc      <   vendor/phpdocumentor/type-resolver/src/PseudoTypes/True_.php  yKAh  W      @   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ListShape.php3  yKAh3  p      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/NegativeInteger.phpw  yKAhw  p      E   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ArrayShapeItem.phpe  yKAhe  7      B   vendor/phpdocumentor/type-resolver/src/PseudoTypes/ObjectShape.phpM  yKAhM  *9      F   vendor/phpdocumentor/type-resolver/src/PseudoTypes/PositiveInteger.phpw  yKAhw  .      5   vendor/phpdocumentor/type-resolver/src/PseudoType.php|  yKAh|  }      0   vendor/phpdocumentor/reflection-docblock/LICENSE8  yKAh8  ʤ      2   vendor/phpdocumentor/reflection-docblock/README.md[  yKAh[  \S      6   vendor/phpdocumentor/reflection-docblock/composer.json  yKAh        @   vendor/phpdocumentor/reflection-docblock/src/DocBlockFactory.php0  yKAh0  O?&      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Serializer.phpH  yKAhH  gդ      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/ExampleFinder.phpI  yKAhI  	T      =   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tag.php  yKAh  ῤ      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/TagFactory.php
  yKAh
  ROJ      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/DescriptionFactory.php<  yKAh<  FJ      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Since.php
  yKAh
  ,      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/PropertyWrite.php  yKAh  ֻ      N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/MethodParameter.php  yKAh  K銤      C   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Link.php  yKAh  j
      I   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/InvalidTag.php  yKAh  _<j      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/BaseTag.php  yKAh  y{      C   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Var_.php  yKAh  x֤      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Param.php9  yKAh9  ֩      D   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Mixin.php  yKAh        P   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TemplateCovariant.php  yKAh  ͤ      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Method.php'  yKAh'  ʤ      H   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Formatter.php,  yKAh,  <c      C   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Uses.phpV
  yKAhV
  .Ѥ      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Return_.php  yKAh  }þ      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Formatter/PassthroughFormatter.php  yKAh  ZL      W   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Formatter/AlignFormatter.php  yKAh  e&A      Q   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TemplateImplements.php  yKAh  r      K   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/PropertyRead.php  yKAh  )r      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Property.php  yKAh  q}      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Version.php
  yKAh
  .2      B   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/See.php5  yKAh5  
      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Extends_.php,  yKAh,  gE      F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Generic.php	  yKAh	        J   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TagWithType.php	  yKAh	  _UG      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Source.php  yKAh  cM      G   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Template.phpM	  yKAhM	        J   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Implements_.php5  yKAh5  q      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Author.php	  yKAh	  8"      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Throws.php  yKAh        X   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ImplementsFactory.php  yKAh  5      N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/Factory.phpJ  yKAhJ  \Τ      Z   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PropertyReadFactory.php*  yKAh*  )܈      U   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ExtendsFactory.php  yKAh  if      S   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/StaticMethod.php%  yKAh%  cTg      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/AbstractPHPStanFactory.php  yKAh  )9      [   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PropertyWriteFactory.php.  yKAh.  k      Q   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/VarFactory.php  yKAh  $      T   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/MethodFactory.phpC
  yKAhC
  [<      V   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/TemplateFactory.phpJ  yKAhJ  !rs      `   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/TemplateImplementsFactory.php  yKAh  {׮      S   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ParamFactory.php  yKAh  j      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/MethodParameterFactory.phpN	  yKAhN	  ^E      U   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PHPStanFactory.php  yKAh  gɉ      ]   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/TemplateExtendsFactory.php  yKAh  %?      V   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/PropertyFactory.php  yKAh  dB      T   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Factory/ReturnFactory.php  yKAh  z      R   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Reference/Reference.php  yKAh  g      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Reference/Url.php  yKAh  ޛ      N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Reference/Fqsen.php*  yKAh*        N   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/TemplateExtends.php  yKAh        F   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Example.php  yKAh  c      I   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Deprecated.php  yKAh  v      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Tags/Covers.php
  yKAh
  
C      L   vendor/phpdocumentor/reflection-docblock/src/DocBlock/StandardTagFactory.php4  yKAh4  ~      E   vendor/phpdocumentor/reflection-docblock/src/DocBlock/Description.php<  yKAh<  TT|      6   vendor/phpdocumentor/reflection-docblock/src/Utils.php	  yKAh	  Ԥ      I   vendor/phpdocumentor/reflection-docblock/src/DocBlockFactoryInterface.php  yKAh  δ      9   vendor/phpdocumentor/reflection-docblock/src/DocBlock.php  yKAh  Zr      H   vendor/phpdocumentor/reflection-docblock/src/Exception/PcreException.php  yKAh  ~	g      1   vendor/paragonie/constant_time_encoding/README.md~
  yKAh~
  uLR      3   vendor/paragonie/constant_time_encoding/LICENSE.txte	  yKAhe	  |[      5   vendor/paragonie/constant_time_encoding/composer.json  yKAh  `Zo>      =   vendor/paragonie/constant_time_encoding/src/Base64UrlSafe.phpm  yKAhm  W}¤      9   vendor/paragonie/constant_time_encoding/src/Base32Hex.php9
  yKAh9
  fm      >   vendor/paragonie/constant_time_encoding/src/Base64DotSlash.php  yKAh  %o      8   vendor/paragonie/constant_time_encoding/src/Encoding.php,  yKAh,  R2~      @   vendor/paragonie/constant_time_encoding/src/EncoderInterface.php  yKAh  s:      6   vendor/paragonie/constant_time_encoding/src/Base32.php<  yKAh<  $HC      3   vendor/paragonie/constant_time_encoding/src/Hex.php  yKAh  bFǤ      E   vendor/paragonie/constant_time_encoding/src/Base64DotSlashOrdered.php
  yKAh
  ?Na      6   vendor/paragonie/constant_time_encoding/src/Binary.php
  yKAh
  ތ      7   vendor/paragonie/constant_time_encoding/src/RFC4648.php  yKAh        6   vendor/paragonie/constant_time_encoding/src/Base64.phpc$  yKAhc$  K      #   vendor/spomky-labs/cbor-php/LICENSE,  yKAh,  C      %   vendor/spomky-labs/cbor-php/README.md[+  yKAh[+        )   vendor/spomky-labs/cbor-php/composer.json'  yKAh'  -k      '   vendor/spomky-labs/cbor-php/SECURITY.md  yKAh  Ǥ      0   vendor/spomky-labs/cbor-php/src/StringStream.phpe  yKAhe  &o      :   vendor/spomky-labs/cbor-php/src/OtherObject/TrueObject.php  yKAh  b1F      ;   vendor/spomky-labs/cbor-php/src/OtherObject/BreakObject.phpX  yKAhX  &c      D   vendor/spomky-labs/cbor-php/src/OtherObject/OtherObjectInterface.phpt  yKAht  аȤ      J   vendor/spomky-labs/cbor-php/src/OtherObject/SinglePrecisionFloatObject.phpQ  yKAhQ  t      =   vendor/spomky-labs/cbor-php/src/OtherObject/GenericObject.php  yKAh  ku5      ;   vendor/spomky-labs/cbor-php/src/OtherObject/FalseObject.php  yKAh  =
      ?   vendor/spomky-labs/cbor-php/src/OtherObject/UndefinedObject.phpd  yKAhd  IM(      J   vendor/spomky-labs/cbor-php/src/OtherObject/DoublePrecisionFloatObject.php  yKAh  ]      K   vendor/spomky-labs/cbor-php/src/OtherObject/OtherObjectManagerInterface.php   yKAh   I      H   vendor/spomky-labs/cbor-php/src/OtherObject/HalfPrecisionFloatObject.phpq  yKAhq  WF       <   vendor/spomky-labs/cbor-php/src/OtherObject/SimpleObject.php	  yKAh	  :j      :   vendor/spomky-labs/cbor-php/src/OtherObject/NullObject.php  yKAh  .      B   vendor/spomky-labs/cbor-php/src/OtherObject/OtherObjectManager.php~  yKAh~  =*F      4   vendor/spomky-labs/cbor-php/src/DecoderInterface.php   yKAh   \f      4   vendor/spomky-labs/cbor-php/src/ByteStringObject.php  yKAh  Bl      D   vendor/spomky-labs/cbor-php/src/IndefiniteLengthTextStringObject.php*  yKAh*  `갤      '   vendor/spomky-labs/cbor-php/src/Tag.phpc  yKAhc  }      +   vendor/spomky-labs/cbor-php/src/Decoder.php#  yKAh#  "I      9   vendor/spomky-labs/cbor-php/src/UnsignedIntegerObject.php  yKAh  򽩜      6   vendor/spomky-labs/cbor-php/src/AbstractCBORObject.phpY  yKAhY  @z>      0   vendor/spomky-labs/cbor-php/src/Normalizable.php   yKAh   xӤ      4   vendor/spomky-labs/cbor-php/src/LengthCalculator.php|  yKAh|  N`      /   vendor/spomky-labs/cbor-php/src/OtherObject.php  yKAh  ?73      *   vendor/spomky-labs/cbor-php/src/Stream.php   yKAh   $c      4   vendor/spomky-labs/cbor-php/src/TextStringObject.php  yKAh  1aM      D   vendor/spomky-labs/cbor-php/src/IndefiniteLengthByteStringObject.php3  yKAh3  Q      >   vendor/spomky-labs/cbor-php/src/IndefiniteLengthListObject.php  yKAh  cR¤      =   vendor/spomky-labs/cbor-php/src/IndefiniteLengthMapObject.php  yKAh  y8      +   vendor/spomky-labs/cbor-php/src/MapItem.php  yKAh         )   vendor/spomky-labs/cbor-php/src/Utils.phpv  yKAhv  p#      .   vendor/spomky-labs/cbor-php/src/ListObject.php  yKAh  0S      -   vendor/spomky-labs/cbor-php/src/MapObject.phpg  yKAhg  /k      .   vendor/spomky-labs/cbor-php/src/CBORObject.php~  yKAh~  4      .   vendor/spomky-labs/cbor-php/src/Tag/UriTag.php  yKAh  )      <   vendor/spomky-labs/cbor-php/src/Tag/Base64UrlEncodingTag.php  yKAh  ܤ      =   vendor/spomky-labs/cbor-php/src/Tag/NegativeBigIntegerTag.php_  yKAh_  [ؠd      :   vendor/spomky-labs/cbor-php/src/Tag/DecimalFractionTag.php
  yKAh
        ;   vendor/spomky-labs/cbor-php/src/Tag/TagManagerInterface.php  yKAh  cG      4   vendor/spomky-labs/cbor-php/src/Tag/TagInterface.phph  yKAhh        4   vendor/spomky-labs/cbor-php/src/Tag/Base64UrlTag.php  yKAh  }       3   vendor/spomky-labs/cbor-php/src/Tag/BigFloatTag.php
  yKAh
  M@Ǥ      /   vendor/spomky-labs/cbor-php/src/Tag/CBORTag.php}  yKAh}  %Ƥ      /   vendor/spomky-labs/cbor-php/src/Tag/MimeTag.php  yKAh  <,      3   vendor/spomky-labs/cbor-php/src/Tag/DatetimeTag.php  yKAh  bʤ      7   vendor/spomky-labs/cbor-php/src/Tag/CBOREncodingTag.php  yKAh   lM      1   vendor/spomky-labs/cbor-php/src/Tag/Base64Tag.php  yKAh  |㨤      9   vendor/spomky-labs/cbor-php/src/Tag/Base16EncodingTag.php  yKAh  M9      =   vendor/spomky-labs/cbor-php/src/Tag/UnsignedBigIntegerTag.php  yKAh  |}      2   vendor/spomky-labs/cbor-php/src/Tag/TagManager.phpE  yKAhE  a      4   vendor/spomky-labs/cbor-php/src/Tag/TimestampTag.php  yKAh  qJ      2   vendor/spomky-labs/cbor-php/src/Tag/GenericTag.php  yKAh  22      9   vendor/spomky-labs/cbor-php/src/Tag/Base64EncodingTag.php  yKAh   k      9   vendor/spomky-labs/cbor-php/src/NegativeIntegerObject.php  yKAh  bx7      (   vendor/spomky-labs/pki-framework/LICENSES  yKAhS  t      *   vendor/spomky-labs/pki-framework/README.md  yKAh  7/V      .   vendor/spomky-labs/pki-framework/composer.json
  yKAh
  ;      ,   vendor/spomky-labs/pki-framework/SECURITY.mdI  yKAhI  ,)      5   vendor/spomky-labs/pki-framework/src/ASN1/Element.php<  yKAh<  9t      9   vendor/spomky-labs/pki-framework/src/ASN1/Util/BigInt.php  yKAh  `}      8   vendor/spomky-labs/pki-framework/src/ASN1/Util/Flags.php  yKAh  
      B   vendor/spomky-labs/pki-framework/src/ASN1/Component/Identifier.php  yKAh  J=      >   vendor/spomky-labs/pki-framework/src/ASN1/Component/Length.php  yKAh  ri
      @   vendor/spomky-labs/pki-framework/src/ASN1/Type/PrimitiveType.php,  yKAh,  SZe2      =   vendor/spomky-labs/pki-framework/src/ASN1/Type/BaseString.php  yKAh  M"~      F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/BMPString.php_  yKAh_  .      D   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Boolean.php9  yKAh9  p@      D   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Integer.phpa  yKAha  @n      H   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/RelativeOID.php  yKAh  lb      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/VisibleString.php  yKAh  wn      C   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Number.php  yKAh  zڡ      G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/UTF8String.php  yKAh  b      F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/BitString.php  yKAh  +      F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/IA5String.php  yKAh  c&k      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/UniversalString.php  yKAh  l0ޤ      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/GraphicString.php  yKAh  W      M   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/ObjectDescriptor.php  yKAh  Y1      A   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Real.phpQ  yKAhQ  ~^      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/PrintableString.php  yKAh  iTȘ      @   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/EOC.php  yKAh  !¤      E   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/NullType.php  yKAh  o      M   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/ObjectIdentifier.php  yKAh  z&      G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/Enumerated.php:  yKAh:  N      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/NumericString.php  yKAh  y{      H   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/OctetString.php2  yKAh2  y      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/GeneralizedTime.php7  yKAh7  l
      D   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/UTCTime.php:	  yKAh:	  3W-N      K   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/VideotexString.php  yKAh  =đ      L   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/CharacterString.php>  yKAh>         F   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/T61String.php  yKAh  _      J   vendor/spomky-labs/pki-framework/src/ASN1/Type/Primitive/GeneralString.php  yKAh  wӺ      ;   vendor/spomky-labs/pki-framework/src/ASN1/Type/TimeType.php;  yKAh;  -R
      I   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ImplicitTagging.php  yKAh  Wq      M   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ContextSpecificType.php   yKAh   X      N   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ExplicitlyTaggedType.php&  yKAh&        E   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/PrivateType.php   yKAh   4eY      I   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ApplicationType.php   yKAh   CF      N   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ImplicitlyTaggedType.php@  yKAh@        G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/DERTaggedType.php  yKAh  }LV      H   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/TaggedTypeWrap.php'  yKAh'  :      I   vendor/spomky-labs/pki-framework/src/ASN1/Type/Tagged/ExplicitTagging.php  yKAh  \      G   vendor/spomky-labs/pki-framework/src/ASN1/Type/Constructed/Sequence.php[  yKAh[  x       B   vendor/spomky-labs/pki-framework/src/ASN1/Type/Constructed/Set.php$  yKAh$  ~      P   vendor/spomky-labs/pki-framework/src/ASN1/Type/Constructed/ConstructedString.php  yKAh  2L:      B   vendor/spomky-labs/pki-framework/src/ASN1/Type/PrimitiveString.php  yKAh  @$      <   vendor/spomky-labs/pki-framework/src/ASN1/Type/Structure.phpM  yKAhM  f<      ;   vendor/spomky-labs/pki-framework/src/ASN1/Type/BaseTime.php  yKAh  CLb      B   vendor/spomky-labs/pki-framework/src/ASN1/Type/UnspecifiedType.php/?  yKAh/?  ?qФ      =   vendor/spomky-labs/pki-framework/src/ASN1/Type/TaggedType.php	  yKAh	  m      =   vendor/spomky-labs/pki-framework/src/ASN1/Type/StringType.php  yKAh  &      A   vendor/spomky-labs/pki-framework/src/ASN1/Type/UniversalClass.php  yKAh  o      5   vendor/spomky-labs/pki-framework/src/ASN1/DERData.php  yKAh  ($Ĥ      A   vendor/spomky-labs/pki-framework/src/ASN1/Feature/ElementBase.php  yKAh  }<t      @   vendor/spomky-labs/pki-framework/src/ASN1/Feature/Stringable.phps  yKAhs  FM      ?   vendor/spomky-labs/pki-framework/src/ASN1/Feature/Encodable.php   yKAh   ܴ;      G   vendor/spomky-labs/pki-framework/src/ASN1/Exception/DecodeException.php   yKAh   }Ӥ      ;   vendor/spomky-labs/pki-framework/src/CryptoEncoding/PEM.php  yKAh  |f"ˤ      A   vendor/spomky-labs/pki-framework/src/CryptoEncoding/PEMBundle.php  yKAh  La      J   vendor/spomky-labs/pki-framework/src/CryptoBridge/Crypto/OpenSSLCrypto.php  yKAh        <   vendor/spomky-labs/pki-framework/src/CryptoBridge/Crypto.php  yKAh  @      >   vendor/spomky-labs/pki-framework/src/X509/Certificate/Time.php	  yKAh	  n      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CRLDistributionPointsExtension.php
  yKAh
  X      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectDirectoryAttributesExtension.php&  yKAh&  K+Y      n   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AccessDescription/SubjectAccessDescription.phpw  yKAhw  e\      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AccessDescription/AccessDescription.php  yKAh        p   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AccessDescription/AuthorityAccessDescription.phpJ  yKAhJ  (~s      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NoRevocationAvailableExtension.php  yKAh        ^   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/PolicyConstraintsExtension.php  yKAh  v!      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AuthorityInformationAccessExtension.php
  yKAh
        e   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectInformationAccessExtension.php'
  yKAh'
   .î      ^   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/TargetInformationExtension.phpN
  yKAhN
  tc(      U   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/KeyUsageExtension.php  yKAh  W).      U   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/TargetName.php  yKAh  HA      R   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/Targets.php
  yKAh
  `%      Q   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/Target.phps  yKAhs  G]b      V   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Target/TargetGroup.php  yKAh  1*      `   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/PolicyMappings/PolicyMapping.phph  yKAhh  Ť      \   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NameConstraintsExtension.phpp  yKAhp  i      X   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/FreshestCRLExtension.phpU  yKAhU  E      T   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/UnknownExtension.php  yKAh  m      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/IssuerAlternativeNameExtension.php  yKAh  7@A^      `   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePoliciesExtension.phpx
  yKAhx
        ]   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/InhibitAnyPolicyExtension.phpf  yKAhf  UP      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/RelativeName.phpe  yKAhe  iwX      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/DistributionPoint.php  yKAh  pӿ      ^   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/FullName.php  yKAh  4      a   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/ReasonFlags.php  yKAh  dŤ      k   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/DistributionPoint/DistributionPointName.php  yKAh  TQ      c   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NameConstraints/GeneralSubtrees.php  yKAh  hL\      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/NameConstraints/GeneralSubtree.php
  yKAh
  K      ]   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/ExtendedKeyUsageExtension.php  yKAh  WL      W   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AAControlsExtension.php  yKAh  er      e   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/NoticeReference.phpa  yKAha  
      i   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/PolicyQualifierInfo.php  yKAh  Dr      i   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/UserNoticeQualifier.php	  yKAh	  4s      g   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/PolicyInformation.phpt  yKAht  ҫ       a   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/DisplayText.php6  yKAh6  Ť      b   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/CertificatePolicy/CPSQualifier.phpK  yKAhK  $vu      [   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/PolicyMappingsExtension.php  yKAh  p'i      M   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/Extension.php'  yKAh'  b      c   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/AuthorityKeyIdentifierExtension.php  yKAh  pT      c   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectAlternativeNameExtension.php  yKAh  6+      ]   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/BasicConstraintsExtension.php	  yKAh	  ?z      a   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extension/SubjectKeyIdentifierExtension.php  yKAh  )VS      E   vendor/spomky-labs/pki-framework/src/X509/Certificate/Certificate.php  yKAh  7;      J   vendor/spomky-labs/pki-framework/src/X509/Certificate/UniqueIdentifier.php  yKAh  q      J   vendor/spomky-labs/pki-framework/src/X509/Certificate/CertificateChain.php  yKAh  N8      B   vendor/spomky-labs/pki-framework/src/X509/Certificate/Validity.phpx  yKAhx  $Ҥ      K   vendor/spomky-labs/pki-framework/src/X509/Certificate/CertificateBundle.phpC  yKAhC        H   vendor/spomky-labs/pki-framework/src/X509/Certificate/TBSCertificate.php8  yKAh8  b^      D   vendor/spomky-labs/pki-framework/src/X509/Certificate/Extensions.php$  yKAh$  [      F   vendor/spomky-labs/pki-framework/src/X509/GeneralName/RegisteredID.php  yKAh  Z3      G   vendor/spomky-labs/pki-framework/src/X509/GeneralName/DirectoryName.php]  yKAh]  ^      F   vendor/spomky-labs/pki-framework/src/X509/GeneralName/EDIPartyName.php  yKAh  Noߤ      C   vendor/spomky-labs/pki-framework/src/X509/GeneralName/OtherName.php  yKAh  V$d      C   vendor/spomky-labs/pki-framework/src/X509/GeneralName/IPAddress.php  yKAh  ?U      E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/X400Address.php  yKAh  T      E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/IPv4Address.php!  yKAh!  #      F   vendor/spomky-labs/pki-framework/src/X509/GeneralName/GeneralNames.php  yKAh  \֤      S   vendor/spomky-labs/pki-framework/src/X509/GeneralName/UniformResourceIdentifier.php  yKAh  e      D   vendor/spomky-labs/pki-framework/src/X509/GeneralName/RFC822Name.php  yKAh  Mpn      E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/GeneralName.phpD
  yKAhD
        E   vendor/spomky-labs/pki-framework/src/X509/GeneralName/IPv6Address.php  yKAh   Ip      A   vendor/spomky-labs/pki-framework/src/X509/GeneralName/DNSName.php(  yKAh(  Yj      D   vendor/spomky-labs/pki-framework/src/X509/Feature/DateTimeHelper.php  yKAh  $u      c   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/PathValidationConfig.php  yKAh  U\      c   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/PathValidationResult.php\  yKAh\  c[      ]   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/ValidatorState.php)  yKAh)  0p      \   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathValidation/PathValidator.phpB  yKAhB  ~i      e   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/PathBuilding/CertificationPathBuilder.php  yKAh  h      _   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Exception/PathBuildingException.php  yKAh  v      a   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Exception/PathValidationException.phpC  yKAhC  Wb'      Q   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Policy/PolicyNode.phpT  yKAhT  Rn      Q   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/Policy/PolicyTree.php+5  yKAh+5  1ؤ      Q   vendor/spomky-labs/pki-framework/src/X509/CertificationPath/CertificationPath.php  yKAh  s      O   vendor/spomky-labs/pki-framework/src/X509/Exception/X509ValidationException.php   yKAh   ?$      i   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/AccessIdentityAttributeValue.php5  yKAh5  3c      Z   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/IetfAttrValue.php  yKAh  f#       Y   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/SvceAuthInfo.php	  yKAh	  Gh      m   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/AuthenticationInfoAttributeValue.phpN  yKAhN  ˯Ť      k   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/ChargingIdentityAttributeValue.php  yKAh  d      `   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/GroupAttributeValue.php  yKAh  vR      [   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/IetfAttrSyntax.php  yKAh        _   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attribute/RoleAttributeValue.php  yKAh  q1      M   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Attributes.php   yKAh   pr      O   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/IssuerSerial.php  yKAh  hU      I   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Holder.php  yKAh  pS      I   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/V2Form.php  yKAh  ~      [   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttributeCertificateInfo.phpK&  yKAhK&  lz      S   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/ObjectDigestInfo.php	  yKAh	  >      P   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttCertIssuer.phpB  yKAhB  y0      W   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttributeCertificate.php  yKAh        X   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/AttCertValidityPeriod.php$  yKAh$  t      Y   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Validation/ACValidator.php  yKAh        m   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Validation/Exception/ACValidationException.php
  yKAh
  K      `   vendor/spomky-labs/pki-framework/src/X509/AttributeCertificate/Validation/ACValidationConfig.php  yKAh  6      W   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/CertificationRequest.php  yKAh  `      b   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/Attribute/ExtensionRequestValue.phpD  yKAhD  
      M   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/Attributes.php  yKAh        [   vendor/spomky-labs/pki-framework/src/X509/CertificationRequest/CertificationRequestInfo.php  yKAh  X      6   vendor/spomky-labs/pki-framework/src/X501/ASN1/RDN.php  yKAh  u晤      @   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeType.php@  yKAh@  7P      R   vendor/spomky-labs/pki-framework/src/X501/ASN1/Collection/SequenceOfAttributes.php  yKAh  xDc      M   vendor/spomky-labs/pki-framework/src/X501/ASN1/Collection/SetOfAttributes.php2  yKAh2  %      Q   vendor/spomky-labs/pki-framework/src/X501/ASN1/Collection/AttributeCollection.php"  yKAh"  ,L      <   vendor/spomky-labs/pki-framework/src/X501/ASN1/Attribute.php#  yKAh#  9      S   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/LocalityNameValue.php  yKAh  `      P   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/GivenNameValue.php  yKAh  g      W   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/OrganizationNameValue.php  yKAh  09      L   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/TitleValue.php  yKAh  f2      S   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/SerialNumberValue.php  yKAh  G      P   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/AttributeValue.php  yKAh  Sg&      R   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/DescriptionValue.php  yKAh  GϤ      R   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/CountryNameValue.php  yKAh  k      Q   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/CommonNameValue.php  yKAh  40L      N   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/SurnameValue.php  yKAh  l      P   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/PseudonymValue.php  yKAh        Z   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/StateOrProvinceNameValue.php  yKAh  ˤ      ^   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/Feature/PrintableStringValue.php  yKAh  Rp      Y   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/Feature/DirectoryString.php  yKAh  W      W   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/UnknownAttributeValue.php<	  yKAh<	  %U      ]   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/OrganizationalUnitNameValue.php  yKAh  6ۺ      K   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeValue/NameValue.php  yKAh        H   vendor/spomky-labs/pki-framework/src/X501/ASN1/AttributeTypeAndValue.phpe  yKAhe  z\      7   vendor/spomky-labs/pki-framework/src/X501/ASN1/Name.phpP  yKAhP  :      9   vendor/spomky-labs/pki-framework/src/X501/DN/DNParser.phpd(  yKAhd(        G   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/MatchingRule.phpP  yKAhP  ~j2      J   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/CaseIgnoreMatch.php  yKAh   Eʤ      I   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/CaseExactMatch.php  yKAh  }      Q   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/StringPrepMatchingRule.php{  yKAh{  峿      F   vendor/spomky-labs/pki-framework/src/X501/MatchingRule/BinaryMatch.php  yKAh  	r      @   vendor/spomky-labs/pki-framework/src/X501/StringPrep/MapStep.phpn  yKAhn  T      F   vendor/spomky-labs/pki-framework/src/X501/StringPrep/NormalizeStep.php
  yKAh
  q      D   vendor/spomky-labs/pki-framework/src/X501/StringPrep/PrepareStep.php  yKAh  o*      F   vendor/spomky-labs/pki-framework/src/X501/StringPrep/TranscodeStep.phpA	  yKAhA	  B      F   vendor/spomky-labs/pki-framework/src/X501/StringPrep/CheckBidiStep.php  yKAh  tId      G   vendor/spomky-labs/pki-framework/src/X501/StringPrep/StringPreparer.php  yKAh  o<I      E   vendor/spomky-labs/pki-framework/src/X501/StringPrep/ProhibitStep.php  yKAh        [   vendor/spomky-labs/pki-framework/src/X501/StringPrep/InsignificantNonSubstringSpaceStep.php!  yKAh!  Q6|      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/Ed25519Signature.php  yKAh        M   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/Ed448Signature.php  yKAh  Pb      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/GenericSignature.phpB  yKAhB   ~      J   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/ECSignature.php  yKAh        K   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/RSASignature.phpY  yKAhY  ފ-      H   vendor/spomky-labs/pki-framework/src/CryptoTypes/Signature/Signature.php  yKAh  U(      P   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/OneAsymmetricKey.php)  yKAh)  NM@      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/Attribute/OneAsymmetricKeyAttributes.php  yKAh  H      P   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RSA/RSAPublicKey.php
  yKAh
  3:      Q   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RSA/RSAPrivateKey.phpO  yKAhO  U      W   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RSA/RSASSAPSSPrivateKey.phpj  yKAhj  f*      N   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/EC/ECPublicKey.phpm  yKAhm  Ҥ      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/EC/ECPrivateKey.php*  yKAh*  QOM2      O   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/EC/ECConversion.php  yKAh  Ғ      I   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PublicKey.php3  yKAh3  Zh      N   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PrivateKeyInfo.php  yKAh  Ln+      Y   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/RFC8410PrivateKey.phpj
  yKAhj
  "      X   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/RFC8410PublicKey.php  yKAh  ;.      ^   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/X448PublicKey.php  yKAh  O      _   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/Ed448PublicKey.php  yKAh  +/      _   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/X448PrivateKey.php  yKAh  Q      `   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve448/Ed448PrivateKey.php  yKAh  	      b   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/X25519PublicKey.php  yKAh  .)      f   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Curve25519PublicKey.php  yKAh  4I      c   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/X25519PrivateKey.php  yKAh  vV      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Curve25519PrivateKey.php3  yKAh3  D3      c   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Ed25519PublicKey.php  yKAh  ʙ      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/RFC8410/Curve25519/Ed25519PrivateKey.php  yKAh  .:      M   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PublicKeyInfo.php  yKAh  3D      J   vendor/spomky-labs/pki-framework/src/CryptoTypes/Asymmetric/PrivateKey.php0  yKAh0  Ix      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/SpecificAlgorithmIdentifier.phpW  yKAhW  y      \   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/AlgorithmIdentifier.phpp  yKAhp  %H      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA384WithRSAEncryptionAlgorithmIdentifier.php  yKAh  O+      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/MD2WithRSAEncryptionAlgorithmIdentifier.php  yKAh  Qߕޤ      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA256AlgorithmIdentifier.php  yKAh  -      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA224AlgorithmIdentifier.php  yKAh  
      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/MD5WithRSAEncryptionAlgorithmIdentifier.php  yKAh  +      y   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/RFC3279RSASignatureAlgorithmIdentifier.php  yKAh  )af      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/MD4WithRSAEncryptionAlgorithmIdentifier.php  yKAh  wl      y   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/RFC4055RSASignatureAlgorithmIdentifier.phpl  yKAhl  _esԤ      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA512AlgorithmIdentifier.php  yKAh  6f{      r   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/RSASignatureAlgorithmIdentifier.php  yKAh  |Ǥ      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA256WithRSAEncryptionAlgorithmIdentifier.php  yKAh  `%      s   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA1AlgorithmIdentifier.php  yKAh  bd      u   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECDSAWithSHA384AlgorithmIdentifier.php  yKAh  ,P      q   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/ECSignatureAlgorithmIdentifier.php  yKAh  _<      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA512WithRSAEncryptionAlgorithmIdentifier.php  yKAh        {   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA1WithRSAEncryptionAlgorithmIdentifier.php  yKAh  1      }   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Signature/SHA224WithRSAEncryptionAlgorithmIdentifier.php  yKAh  &n      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA224AlgorithmIdentifier.php  yKAh  Ф      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA224AlgorithmIdentifier.php  yKAh  1]̤      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA256AlgorithmIdentifier.php  yKAh  L      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA256AlgorithmIdentifier.php  yKAh  F      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/RFC4231HMACAlgorithmIdentifier.phps  yKAhs  TE      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA512AlgorithmIdentifier.php  yKAh  N      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA512AlgorithmIdentifier.php  yKAh  Iˤ      m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA1AlgorithmIdentifier.php  yKAh  l	d      e   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA2AlgorithmIdentifier.php  yKAh  	      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/MD5AlgorithmIdentifier.php  yKAh  :      e   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA1AlgorithmIdentifier.phpy  yKAhy        o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/HMACWithSHA384AlgorithmIdentifier.php  yKAh  /4      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Hash/SHA384AlgorithmIdentifier.php  yKAh  MaA4      i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/RC2CBCAlgorithmIdentifier.php  yKAh        m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/DESEDE3CBCAlgorithmIdentifier.phpg  yKAhg  p      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AES192CBCAlgorithmIdentifier.php  yKAh        i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AESCBCAlgorithmIdentifier.php  yKAh  qz      i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/CipherAlgorithmIdentifier.php8  yKAh8   "¤      i   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/DESCBCAlgorithmIdentifier.php  yKAh  HY      n   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/BlockCipherAlgorithmIdentifier.phpd  yKAhd  ~      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AES128CBCAlgorithmIdentifier.php|  yKAh|  Wϸ      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Cipher/AES256CBCAlgorithmIdentifier.php  yKAh  |Ĥ      r   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/ECPublicKeyAlgorithmIdentifier.php/  yKAh/  D      m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/X25519AlgorithmIdentifier.php+  yKAh+  0Ŕ      k   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/X448AlgorithmIdentifier.php#  yKAh#  oœ#      p   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RFC8410EdAlgorithmIdentifier.php  yKAh   ߎ      t   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RSAEncryptionAlgorithmIdentifier.php  yKAh  seR      l   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/Ed448AlgorithmIdentifier.php  yKAh  ְ      o   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RFC8410XAlgorithmIdentifier.php  yKAh  L~.      z   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/RSAPSSSSAEncryptionAlgorithmIdentifier.php  yKAh  Z      n   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Asymmetric/Ed25519AlgorithmIdentifier.php  yKAh         c   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/AlgorithmIdentifierFactory.php$  yKAh$  #ꨤ      m   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/SignatureAlgorithmIdentifier.php  yKAh  3!      g   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/PRFAlgorithmIdentifier.php   yKAh   !$      t   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/AsymmetricCryptoAlgorithmIdentifier.php
  yKAh
  C      h   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/HashAlgorithmIdentifier.php   yKAh   &-      n   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/EncryptionAlgorithmIdentifier.php   yKAh   bO      h   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/Feature/AlgorithmIdentifierType.phpy  yKAhy  l̤      d   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/AlgorithmIdentifierProvider.php  yKAh  k\d      c   vendor/spomky-labs/pki-framework/src/CryptoTypes/AlgorithmIdentifier/GenericAlgorithmIdentifier.php  yKAh  CI	          vendor/spomky-labs/otphp/LICENSE@  yKAh@  xi      "   vendor/spomky-labs/otphp/README.md%  yKAh%  z@      &   vendor/spomky-labs/otphp/composer.json  yKAh  ;       $   vendor/spomky-labs/otphp/SECURITY.md  yKAh  ?	m      %   vendor/spomky-labs/otphp/src/TOTP.php  yKAh  >s?      (   vendor/spomky-labs/otphp/src/Factory.php+  yKAh+  0$      -   vendor/spomky-labs/otphp/src/OTPInterface.php
  yKAh
  zr      .   vendor/spomky-labs/otphp/src/TOTPInterface.php  yKAh  *      $   vendor/spomky-labs/otphp/src/OTP.php  yKAh  B      %   vendor/spomky-labs/otphp/src/HOTP.php=
  yKAh=
  hct      .   vendor/spomky-labs/otphp/src/HOTPInterface.php=  yKAh=  ߤ      1   vendor/spomky-labs/otphp/src/FactoryInterface.phpr  yKAhr  ¤      /   vendor/spomky-labs/otphp/src/ParameterTrait.php  yKAh  da&      $   vendor/spomky-labs/otphp/src/Url.php#
  yKAh#
  >쐡      .   vendor/spomky-labs/otphp/src/InternalClock.php5  yKAh5  GƤ      $   vendor/doctrine/deprecations/LICENSE)  yKAh)  "0      &   vendor/doctrine/deprecations/README.md
  yKAh
  {      *   vendor/doctrine/deprecations/composer.json
  yKAh
        ?   vendor/doctrine/deprecations/src/PHPUnit/VerifyDeprecations.php  yKAh  jϤ      0   vendor/doctrine/deprecations/src/Deprecation.php$  yKAh$  )         vendor/firebase/php-jwt/LICENSE  yKAh  #      $   vendor/firebase/php-jwt/CHANGELOG.md(  yKAh(  D      !   vendor/firebase/php-jwt/README.md4  yKAh4  !Uk      %   vendor/firebase/php-jwt/composer.json  yKAh  ܤ      9   vendor/firebase/php-jwt/src/SignatureInvalidException.phpu   yKAhu   Ͻ      4   vendor/firebase/php-jwt/src/BeforeValidException.phpt  yKAht  u0      ,   vendor/firebase/php-jwt/src/CachedKeySet.php  yKAh   ؤ      #   vendor/firebase/php-jwt/src/Key.php  yKAh  lx+      #   vendor/firebase/php-jwt/src/JWK.phpA,  yKAhA,        @   vendor/firebase/php-jwt/src/JWTExceptionWithPayloadInterface.php  yKAh  ky      0   vendor/firebase/php-jwt/src/ExpiredException.phpp  yKAhp  7      #   vendor/firebase/php-jwt/src/JWT.php\  yKAh\  2ב         vendor/brick/math/LICENSEA  yKAhA  ݸL         vendor/brick/math/CHANGELOG.mdL  yKAhL  K/%      $   vendor/brick/math/psalm-baseline.xml	  yKAh	           vendor/brick/math/composer.jsonR  yKAhR  IG      &   vendor/brick/math/src/RoundingMode.php
  yKAh
        ;   vendor/brick/math/src/Internal/Calculator/GmpCalculator.php'
  yKAh'
  ;0      >   vendor/brick/math/src/Internal/Calculator/BcMathCalculator.php  yKAh  ,1      >   vendor/brick/math/src/Internal/Calculator/NativeCalculator.php7  yKAh7  #.      -   vendor/brick/math/src/Internal/Calculator.phpI  yKAhI  }      $   vendor/brick/math/src/BigInteger.php0  yKAh0  d2      #   vendor/brick/math/src/BigNumber.php>  yKAh>  Eä      $   vendor/brick/math/src/BigDecimal.phpV  yKAhV  M@Ƥ      1   vendor/brick/math/src/Exception/MathException.php   yKAh   E:      9   vendor/brick/math/src/Exception/NumberFormatException.php  yKAh  ojQ      ;   vendor/brick/math/src/Exception/NegativeNumberException.php  yKAh  +;      ;   vendor/brick/math/src/Exception/DivisionByZeroException.php  yKAh  Ɓj      <   vendor/brick/math/src/Exception/IntegerOverflowException.php,  yKAh,  1C>*      >   vendor/brick/math/src/Exception/RoundingNecessaryException.php  yKAh  A      %   vendor/brick/math/src/BigRational.php.  yKAh.  2h      (   vendor/justinrainbow/json-schema/LICENSE   yKAh         2   vendor/justinrainbow/json-schema/bin/validate-json  yKAh        F   vendor/justinrainbow/json-schema/dist/schema/json-schema-draft-03.json  yKAh  -aߤ      F   vendor/justinrainbow/json-schema/dist/schema/json-schema-draft-04.json  yKAh  Nߤ      *   vendor/justinrainbow/json-schema/README.mdz  yKAhz  ˱      .   vendor/justinrainbow/json-schema/composer.json  yKAh  7      ;   vendor/justinrainbow/json-schema/src/JsonSchema/Rfc3339.php  yKAh  ̤      =   vendor/justinrainbow/json-schema/src/JsonSchema/Validator.php
  yKAh
         I   vendor/justinrainbow/json-schema/src/JsonSchema/UriRetrieverInterface.php  yKAh  hJ      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/ObjectConstraint.php{  yKAh{  =6      G   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/Factory.php  yKAh  ߤ      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/NumberConstraint.php
  yKAh
  Uj      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeConstraint.php  yKAh  MY      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/BaseConstraint.php   yKAh   ֤      N   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/EnumConstraint.php  yKAh  l$М      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/StringConstraint.php  yKAh  ^      S   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/ConstraintInterface.php3  yKAh3  9¤      T   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/CollectionConstraint.php  yKAh  5q      J   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/Constraint.php  yKAh  d5      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/FormatConstraint.php.#  yKAh.#  '      \   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/TypeCheckInterface.php  yKAh  y      Y   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/StrictTypeCheck.php:  yKAh:  *9      X   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/TypeCheck/LooseTypeCheck.php  yKAh  r(      S   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/UndefinedConstraint.php<  yKAh<  U>      P   vendor/justinrainbow/json-schema/src/JsonSchema/Constraints/SchemaConstraint.php!  yKAh!        F   vendor/justinrainbow/json-schema/src/JsonSchema/Entity/JsonPointer.php4
  yKAh4
        H   vendor/justinrainbow/json-schema/src/JsonSchema/UriResolverInterface.php   yKAh   "      K   vendor/justinrainbow/json-schema/src/JsonSchema/Iterator/ObjectIterator.php
  yKAh
  hl      A   vendor/justinrainbow/json-schema/src/JsonSchema/SchemaStorage.php  yKAh  Nq      X   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/UriRetrieverInterface.php  yKAh  -,      T   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/AbstractRetriever.php  yKAh  _Ǥ      G   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/Curl.php  yKAh  x(      R   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/FileGetContents.php^
  yKAh^
        R   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/Retrievers/PredefinedArray.php
  yKAh
  /8      D   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/UriRetriever.php$  yKAh$  Aq      C   vendor/justinrainbow/json-schema/src/JsonSchema/Uri/UriResolver.php  yKAh  _9<      W   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ResourceNotFoundException.phpb  yKAhb  `      P   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ExceptionInterface.phpX   yKAhX   [      N   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/RuntimeException.phpo  yKAho  Cr      W   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSourceUriException.phpj  yKAhj  *5      V   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidArgumentException.php  yKAh  N      ^   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/UnresolvableJsonPointerException.php  yKAh  ZHe      Q   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/ValidationException.php'  yKAh'  Aj      T   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidConfigException.php_  yKAh_  P      S   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/JsonDecodingException.php  yKAh  nW      T   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSchemaException.php\  yKAh\  @S6      R   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/UriResolverException.phpX  yKAhX  Ӕ      ]   vendor/justinrainbow/json-schema/src/JsonSchema/Exception/InvalidSchemaMediaTypeException.phpe  yKAhe  U3$      J   vendor/justinrainbow/json-schema/src/JsonSchema/SchemaStorageInterface.php.  yKAh.  VԠg      1   vendor/crell/api-problem/docker/php/81/Dockerfile   yKAh   D1      1   vendor/crell/api-problem/docker/php/81/xdebug.inil   yKAhl   b0      >   vendor/crell/api-problem/docker/php/conf.d/error_reporting.ini   yKAh   lc¤      !   vendor/crell/api-problem/Makefile]  yKAh]  Zib      *   vendor/crell/api-problem/phpstan.neon.dist0   yKAh0   b      +   vendor/crell/api-problem/docker-compose.ymlb  yKAhb  Ruv      &   vendor/crell/api-problem/composer.json  yKAh  VN+      $   vendor/crell/api-problem/SECURITY.mdw	  yKAhw	  _yU      %   vendor/crell/api-problem/default-.env  yKAh  ]h	Q      4   vendor/crell/api-problem/src/JsonEncodeException.php   yKAh   ewF      .   vendor/crell/api-problem/src/HttpConverter.php6
  yKAh6
  1B      3   vendor/crell/api-problem/src/JsonParseException.phpH  yKAhH  %P(      .   vendor/crell/api-problem/src/JsonException.php  yKAh  5-      +   vendor/crell/api-problem/src/ApiProblem.phpdH  yKAhdH  'M         vendor/psr/cache/CHANGELOG.md  yKAh  -	G         vendor/psr/cache/README.md"  yKAh"  (AcӤ         vendor/psr/cache/LICENSE.txt8  yKAh8  Df         vendor/psr/cache/composer.json4  yKAh4  C      /   vendor/psr/cache/src/CacheItemPoolInterface.php  yKAh  Y      +   vendor/psr/cache/src/CacheItemInterface.php&  yKAh&  =b      1   vendor/psr/cache/src/InvalidArgumentException.php:  yKAh:  MY      '   vendor/psr/cache/src/CacheException.php   yKAh   BJ      #   vendor/psr/event-dispatcher/LICENSE(  yKAh(  }]      %   vendor/psr/event-dispatcher/README.mdE  yKAhE  S      )   vendor/psr/event-dispatcher/composer.jsonb  yKAhb  q      =   vendor/psr/event-dispatcher/src/ListenerProviderInterface.php  yKAh  bh      <   vendor/psr/event-dispatcher/src/EventDispatcherInterface.php  yKAh        ;   vendor/psr/event-dispatcher/src/StoppableEventInterface.php!  yKAh!  T>q         vendor/psr/http-message/LICENSE=  yKAh=        $   vendor/psr/http-message/CHANGELOG.md3  yKAh3  :\Y      !   vendor/psr/http-message/README.md  yKAh        %   vendor/psr/http-message/composer.json  yKAh  7      6   vendor/psr/http-message/src/ServerRequestInterface.phpH(  yKAhH(  #      ,   vendor/psr/http-message/src/UriInterface.php/2  yKAh/2  קY      /   vendor/psr/http-message/src/StreamInterface.php  yKAh        5   vendor/psr/http-message/src/UploadedFileInterface.php  yKAh  	      0   vendor/psr/http-message/src/RequestInterface.phpG  yKAhG  ir      1   vendor/psr/http-message/src/ResponseInterface.phpZ
  yKAhZ
  aG      0   vendor/psr/http-message/src/MessageInterface.php  yKAh  |C         vendor/psr/container/LICENSEy  yKAhy  Op         vendor/psr/container/README.mdB  yKAhB  g?      "   vendor/psr/container/composer.json  yKAh  nY      7   vendor/psr/container/src/NotFoundExceptionInterface.php   yKAh   B@      /   vendor/psr/container/src/ContainerInterface.php%  yKAh%  )      8   vendor/psr/container/src/ContainerExceptionInterface.php   yKAh              vendor/psr/http-client/LICENSE=  yKAh=  S      #   vendor/psr/http-client/CHANGELOG.md  yKAh  z򪌤          vendor/psr/http-client/README.md%  yKAh%  F      $   vendor/psr/http-client/composer.json  yKAh  bϤ      8   vendor/psr/http-client/src/NetworkExceptionInterface.php  yKAh  6SB      8   vendor/psr/http-client/src/RequestExceptionInterface.phph  yKAhh  *c=      .   vendor/psr/http-client/src/ClientInterface.php!  yKAh!  {0      7   vendor/psr/http-client/src/ClientExceptionInterface.php   yKAh   xz         vendor/psr/log/LICENSE=  yKAh=  pO         vendor/psr/log/README.mdB  yKAhB  '         vendor/psr/log/composer.json`  yKAh`  ],      +   vendor/psr/log/src/LoggerAwareInterface.php   yKAh   ow         vendor/psr/log/src/LogLevel.phpH  yKAhH  u      '   vendor/psr/log/src/LoggerAwareTrait.phpj  yKAhj  dz      /   vendor/psr/log/src/InvalidArgumentException.phpo   yKAho   MWd      !   vendor/psr/log/src/NullLogger.php  yKAh   <      &   vendor/psr/log/src/LoggerInterface.php
  yKAh
  c=      "   vendor/psr/log/src/LoggerTrait.php
  yKAh
  
      %   vendor/psr/log/src/AbstractLogger.php  yKAh  q         vendor/psr/clock/LICENSE8  yKAh8  l         vendor/psr/clock/CHANGELOG.md   yKAh   <         vendor/psr/clock/README.md  yKAh  GL[         vendor/psr/clock/composer.json2  yKAh2  $DCM      '   vendor/psr/clock/src/ClockInterface.php   yKAh   H%         vendor/psr/http-factory/LICENSE(  yKAh(  }]      !   vendor/psr/http-factory/README.md,  yKAh,  zwf      %   vendor/psr/http-factory/composer.json8  yKAh8        8   vendor/psr/http-factory/src/ResponseFactoryInterface.php2  yKAh2  ձ}      6   vendor/psr/http-factory/src/StreamFactoryInterface.php  yKAh  e      <   vendor/psr/http-factory/src/UploadedFileFactoryInterface.phpJ  yKAhJ  nʉ      3   vendor/psr/http-factory/src/UriFactoryInterface.phpU  yKAhU        =   vendor/psr/http-factory/src/ServerRequestFactoryInterface.php  yKAh  w9      7   vendor/psr/http-factory/src/RequestFactoryInterface.php  yKAh  4(         vendor/monolog/monolog/LICENSE'  yKAh'        #   vendor/monolog/monolog/CHANGELOG.md  yKAh  nr          vendor/monolog/monolog/README.mdA  yKAhA  o      $   vendor/monolog/monolog/composer.json3
  yKAh3
        >   vendor/monolog/monolog/src/Monolog/Handler/SendGridHandler.php  yKAh  
FϤ      @   vendor/monolog/monolog/src/Monolog/Handler/InsightOpsHandler.php  yKAh  &      :   vendor/monolog/monolog/src/Monolog/Handler/TestHandler.php  yKAh  )Bs      ;   vendor/monolog/monolog/src/Monolog/Handler/IFTTTHandler.php  yKAh  ps      H   vendor/monolog/monolog/src/Monolog/Handler/WebRequestRecognizerTrait.php  yKAh  cJ      <   vendor/monolog/monolog/src/Monolog/Handler/SocketHandler.phpY/  yKAhY/  q]      C   vendor/monolog/monolog/src/Monolog/Handler/SymfonyMailerHandler.phpJ  yKAhJ  H      :   vendor/monolog/monolog/src/Monolog/Handler/NoopHandler.php  yKAh  :      <   vendor/monolog/monolog/src/Monolog/Handler/BufferHandler.phpy  yKAhy  ,Z̤      <   vendor/monolog/monolog/src/Monolog/Handler/SyslogHandler.php  yKAh  ~      =   vendor/monolog/monolog/src/Monolog/Handler/RollbarHandler.php
  yKAh
  kVʤ      D   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossedHandler.phpz   yKAhz   U6X      >   vendor/monolog/monolog/src/Monolog/Handler/OverflowHandler.php  yKAh  8      =   vendor/monolog/monolog/src/Monolog/Handler/HandlerWrapper.phpO
  yKAhO
        Y   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ActivationStrategyInterface.php  yKAh  z.      Z   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ErrorLevelActivationStrategy.php  yKAh         \   vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed/ChannelLevelActivationStrategy.php	  yKAh	  ;Ӥ      ;   vendor/monolog/monolog/src/Monolog/Handler/GroupHandler.php  yKAh  Y      C   vendor/monolog/monolog/src/Monolog/Handler/ElasticsearchHandler.php  yKAh         >   vendor/monolog/monolog/src/Monolog/Handler/SamplingHandler.phpz  yKAhz  E^      6   vendor/monolog/monolog/src/Monolog/Handler/Handler.php  yKAh  |      >   vendor/monolog/monolog/src/Monolog/Handler/AbstractHandler.php
  yKAh
  7m      >   vendor/monolog/monolog/src/Monolog/Handler/FlowdockHandler.phpG
  yKAhG
  
B      >   vendor/monolog/monolog/src/Monolog/Handler/PushoverHandler.phpJ  yKAhJ  1      J   vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerInterface.php  yKAh  'W      H   vendor/monolog/monolog/src/Monolog/Handler/MissingExtensionException.php  yKAh   
l      D   vendor/monolog/monolog/src/Monolog/Handler/AbstractSyslogHandler.php  yKAh  
$      ?   vendor/monolog/monolog/src/Monolog/Handler/SyslogUdpHandler.php4  yKAh4        D   vendor/monolog/monolog/src/Monolog/Handler/BrowserConsoleHandler.php$  yKAh$   Aߤ      <   vendor/monolog/monolog/src/Monolog/Handler/FilterHandler.php  yKAh        9   vendor/monolog/monolog/src/Monolog/Handler/SqsHandler.php  yKAh  -
M      B   vendor/monolog/monolog/src/Monolog/Handler/RotatingFileHandler.php>  yKAh>  ^n      C   vendor/monolog/monolog/src/Monolog/Handler/FallbackGroupHandler.php  yKAh  <      B   vendor/monolog/monolog/src/Monolog/Handler/NativeMailerHandler.php  yKAh  .t      =   vendor/monolog/monolog/src/Monolog/Handler/MongoDBHandler.php	  yKAh	  nD      =   vendor/monolog/monolog/src/Monolog/Handler/ProcessHandler.phpU  yKAhU  ٤      F   vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerTrait.php  yKAh  N'x~      :   vendor/monolog/monolog/src/Monolog/Handler/GelfHandler.php  yKAh  ca      A   vendor/monolog/monolog/src/Monolog/Handler/ZendMonitorHandler.php  yKAh        @   vendor/monolog/monolog/src/Monolog/Handler/PHPConsoleHandler.phpQ0  yKAhQ0  v֤      >   vendor/monolog/monolog/src/Monolog/Handler/ErrorLogHandler.php
  yKAh
  *rʤ      @   vendor/monolog/monolog/src/Monolog/Handler/LogEntriesHandler.php  yKAh  D      >   vendor/monolog/monolog/src/Monolog/Handler/LogmaticHandler.php	  yKAh	  go      C   vendor/monolog/monolog/src/Monolog/Handler/DeduplicationHandler.phpY  yKAhY  h      =   vendor/monolog/monolog/src/Monolog/Handler/FirePHPHandler.php  yKAh        8   vendor/monolog/monolog/src/Monolog/Handler/Curl/Util.php  yKAh  A      E   vendor/monolog/monolog/src/Monolog/Handler/DoctrineCouchDBHandler.php  yKAh  O!֤      >   vendor/monolog/monolog/src/Monolog/Handler/DynamoDbHandler.php  yKAh  %Tg      J   vendor/monolog/monolog/src/Monolog/Handler/FormattableHandlerInterface.php  yKAh        A   vendor/monolog/monolog/src/Monolog/Handler/RedisPubSubHandler.php  yKAh  ޤ      :   vendor/monolog/monolog/src/Monolog/Handler/MailHandler.php  yKAh  Nv      <   vendor/monolog/monolog/src/Monolog/Handler/StreamHandler.php5   yKAh5   EW      <   vendor/monolog/monolog/src/Monolog/Handler/LogglyHandler.phpa  yKAha  Ӥ      B   vendor/monolog/monolog/src/Monolog/Handler/SlackWebhookHandler.php  yKAh  Kdﮤ      >   vendor/monolog/monolog/src/Monolog/Handler/ElasticaHandler.php  yKAh        F   vendor/monolog/monolog/src/Monolog/Handler/WhatFailureGroupHandler.php  yKAh  f      ?   vendor/monolog/monolog/src/Monolog/Handler/ChromePHPHandler.php/  yKAh/  m      @   vendor/monolog/monolog/src/Monolog/Handler/Slack/SlackRecord.php'  yKAh'        9   vendor/monolog/monolog/src/Monolog/Handler/PsrHandler.php	  yKAh	  |cU      >   vendor/monolog/monolog/src/Monolog/Handler/NewRelicHandler.php)  yKAh)  ̤      F   vendor/monolog/monolog/src/Monolog/Handler/ProcessableHandlerTrait.php  yKAh  PK      ?   vendor/monolog/monolog/src/Monolog/Handler/HandlerInterface.php
  yKAh
  2      ;   vendor/monolog/monolog/src/Monolog/Handler/SlackHandler.php  yKAh  '      ?   vendor/monolog/monolog/src/Monolog/Handler/FleepHookHandler.phpI
  yKAhI
   T      :   vendor/monolog/monolog/src/Monolog/Handler/NullHandler.php|  yKAh|  Wb      :   vendor/monolog/monolog/src/Monolog/Handler/AmqpHandler.php%  yKAh%  paĤ      A   vendor/monolog/monolog/src/Monolog/Handler/TelegramBotHandler.php$  yKAh$  39      >   vendor/monolog/monolog/src/Monolog/Handler/MandrillHandler.php
  yKAh
  \+w      H   vendor/monolog/monolog/src/Monolog/Handler/AbstractProcessingHandler.php  yKAh  cl      =   vendor/monolog/monolog/src/Monolog/Handler/CouchDBHandler.php	  yKAh	  (ٌ      ;   vendor/monolog/monolog/src/Monolog/Handler/RedisHandler.php
  yKAh
        :   vendor/monolog/monolog/src/Monolog/Handler/CubeHandler.phpF  yKAhF  !fB      B   vendor/monolog/monolog/src/Monolog/Handler/SyslogUdp/UdpSocket.php  yKAh  bH      H   vendor/monolog/monolog/src/Monolog/JsonSerializableDateTimeImmutable.php  yKAh  kܤ      -   vendor/monolog/monolog/src/Monolog/Logger.php;Y  yKAh;Y  {      C   vendor/monolog/monolog/src/Monolog/Attribute/AsMonologProcessor.php  yKAh  b      C   vendor/monolog/monolog/src/Monolog/Attribute/WithMonologChannel.php  yKAh  GL      8   vendor/monolog/monolog/src/Monolog/DateTimeImmutable.phph  yKAhh  x\G      ;   vendor/monolog/monolog/src/Monolog/Test/MonologTestCase.php@  yKAh@  (-      4   vendor/monolog/monolog/src/Monolog/Test/TestCase.php  yKAh  >7)      /   vendor/monolog/monolog/src/Monolog/Registry.php  yKAh  =      B   vendor/monolog/monolog/src/Monolog/Processor/HostnameProcessor.php  yKAh  	'1      G   vendor/monolog/monolog/src/Monolog/Processor/PsrLogMessageProcessor.phpI  yKAhI        =   vendor/monolog/monolog/src/Monolog/Processor/WebProcessor.phpU
  yKAhU
  8      I   vendor/monolog/monolog/src/Monolog/Processor/MemoryPeakUsageProcessor.php|  yKAh|  _`x      C   vendor/monolog/monolog/src/Monolog/Processor/ProcessIdProcessor.php  yKAh  +@      E   vendor/monolog/monolog/src/Monolog/Processor/LoadAverageProcessor.php\  yKAh\  s      H   vendor/monolog/monolog/src/Monolog/Processor/ClosureContextProcessor.php  yKAh  :Eg      C   vendor/monolog/monolog/src/Monolog/Processor/MercurialProcessor.php  yKAh  O      =   vendor/monolog/monolog/src/Monolog/Processor/TagProcessor.php  yKAh  G?o      =   vendor/monolog/monolog/src/Monolog/Processor/GitProcessor.php  yKAh  \@      @   vendor/monolog/monolog/src/Monolog/Processor/MemoryProcessor.php  yKAh  )      G   vendor/monolog/monolog/src/Monolog/Processor/IntrospectionProcessor.php\  yKAh\  h      =   vendor/monolog/monolog/src/Monolog/Processor/UidProcessor.php  yKAh  Hz      C   vendor/monolog/monolog/src/Monolog/Processor/ProcessorInterface.php]  yKAh]  l(      E   vendor/monolog/monolog/src/Monolog/Processor/MemoryUsageProcessor.phpi  yKAhi  3;w      :   vendor/monolog/monolog/src/Monolog/ResettableInterface.php  yKAh  Z̤      4   vendor/monolog/monolog/src/Monolog/SignalHandler.phpZ  yKAhZ  N      ,   vendor/monolog/monolog/src/Monolog/Level.php\  yKAh\  $رn      B   vendor/monolog/monolog/src/Monolog/Formatter/LogmaticFormatter.php;  yKAh;  
ؤ      B   vendor/monolog/monolog/src/Monolog/Formatter/ElasticaFormatter.php  yKAh  q*      >   vendor/monolog/monolog/src/Monolog/Formatter/LineFormatter.phph&  yKAhh&  ؃      >   vendor/monolog/monolog/src/Monolog/Formatter/JsonFormatter.phpm  yKAhm  l S      B   vendor/monolog/monolog/src/Monolog/Formatter/FlowdockFormatter.phpC	  yKAhC	  mӼ      C   vendor/monolog/monolog/src/Monolog/Formatter/FormatterInterface.php  yKAh  ̍Q      B   vendor/monolog/monolog/src/Monolog/Formatter/LogstashFormatter.phpQ
  yKAhQ
  n@      @   vendor/monolog/monolog/src/Monolog/Formatter/LogglyFormatter.php  yKAh  א      G   vendor/monolog/monolog/src/Monolog/Formatter/ElasticsearchFormatter.phpF  yKAhF  pz      @   vendor/monolog/monolog/src/Monolog/Formatter/ScalarFormatter.php  yKAh  Pa      A   vendor/monolog/monolog/src/Monolog/Formatter/MongoDBFormatter.php  yKAh  դ      C   vendor/monolog/monolog/src/Monolog/Formatter/ChromePHPFormatter.php  yKAh        A   vendor/monolog/monolog/src/Monolog/Formatter/FluentdFormatter.php  yKAh  (QG      E   vendor/monolog/monolog/src/Monolog/Formatter/GelfMessageFormatter.phpY  yKAhY  9Pi      B   vendor/monolog/monolog/src/Monolog/Formatter/WildfireFormatter.php  yKAh  :      L   vendor/monolog/monolog/src/Monolog/Formatter/GoogleCloudLoggingFormatter.php  yKAh        @   vendor/monolog/monolog/src/Monolog/Formatter/SyslogFormatter.php  yKAh  氂      D   vendor/monolog/monolog/src/Monolog/Formatter/NormalizerFormatter.php'  yKAh'  6xq      >   vendor/monolog/monolog/src/Monolog/Formatter/HtmlFormatter.php  yKAh  x       0   vendor/monolog/monolog/src/Monolog/LogRecord.php
  yKAh
  
      3   vendor/monolog/monolog/src/Monolog/ErrorHandler.php'  yKAh'  4_      ,   vendor/monolog/monolog/src/Monolog/Utils.phpr"  yKAhr"  c      !   vendor/studio24/rotate/LICENSE.md>  yKAh>  3ä      "   vendor/studio24/rotate/phpunit.xml   yKAh   gE          vendor/studio24/rotate/README.md  yKAh  ?/      $   vendor/studio24/rotate/composer.json  yKAh  WѤ      .   vendor/studio24/rotate/src/RotateException.php_   yKAh_    ;      %   vendor/studio24/rotate/src/Rotate.php#  yKAh#  j      -   vendor/studio24/rotate/src/FilenameFormat.php  yKAh  =D      -   vendor/studio24/rotate/src/RotateAbstract.php  yKAh  D      6   vendor/studio24/rotate/src/FilenameFormatException.phpg   yKAhg   ܙ      %   vendor/studio24/rotate/src/Delete.php|#  yKAh|#  ؤ      0   vendor/studio24/rotate/src/DirectoryIterator.phpk  yKAhk  mA      G   vendor/symfony/framework-bundle/DataCollector/AbstractDataCollector.php  yKAh  xϤ      E   vendor/symfony/framework-bundle/DataCollector/RouterDataCollector.phpD  yKAhD  }      U   vendor/symfony/framework-bundle/DataCollector/TemplateAwareDataCollectorInterface.phpU  yKAhU  ~suܤ      '   vendor/symfony/framework-bundle/LICENSE,  yKAh,  U      7   vendor/symfony/framework-bundle/Test/KernelTestCase.phpA  yKAhA  R      B   vendor/symfony/framework-bundle/Test/DomCrawlerAssertionsTrait.php  yKAh  3      >   vendor/symfony/framework-bundle/Test/MailerAssertionsTrait.phpe  yKAhe  }w      D   vendor/symfony/framework-bundle/Test/NotificationAssertionsTrait.php%  yKAh%  *      B   vendor/symfony/framework-bundle/Test/HttpClientAssertionsTrait.php  yKAh  ~s      B   vendor/symfony/framework-bundle/Test/BrowserKitAssertionsTrait.php!  yKAh!  탤      9   vendor/symfony/framework-bundle/Test/TestBrowserToken.php  yKAh  ¾      4   vendor/symfony/framework-bundle/Test/WebTestCase.php  yKAh  5      ?   vendor/symfony/framework-bundle/Test/WebTestAssertionsTrait.php  yKAh  *      6   vendor/symfony/framework-bundle/Test/TestContainer.phpP  yKAhP  Ԕq      ,   vendor/symfony/framework-bundle/CHANGELOG.md  yKAh  ķ      :   vendor/symfony/framework-bundle/Translation/Translator.phpR  yKAhR  
H      7   vendor/symfony/framework-bundle/Secrets/SodiumVault.phpK#  yKAhK#  ?/      7   vendor/symfony/framework-bundle/Secrets/DotenvVault.php8  yKAh8  U:      9   vendor/symfony/framework-bundle/Secrets/AbstractVault.php  yKAh  ~p      I   vendor/symfony/framework-bundle/Resources/bin/check-unused-known-tags.php  yKAh  1      A   vendor/symfony/framework-bundle/Resources/config/asset_mapper.php$  yKAh$  O)      8   vendor/symfony/framework-bundle/Resources/config/esi.php  yKAh        @   vendor/symfony/framework-bundle/Resources/config/translation.phpM   yKAhM   Tפ      ?   vendor/symfony/framework-bundle/Resources/config/serializer.phpy'  yKAhy'  PF      ?   vendor/symfony/framework-bundle/Resources/config/form_debug.php  yKAh  "      >   vendor/symfony/framework-bundle/Resources/config/validator.php  yKAh  iL6Ǥ      >   vendor/symfony/framework-bundle/Resources/config/semaphore.php  yKAh  4.      @   vendor/symfony/framework-bundle/Resources/config/annotations.php
  yKAh
  ݋\      >   vendor/symfony/framework-bundle/Resources/config/profiling.php=  yKAh=  +      ;   vendor/symfony/framework-bundle/Resources/config/mailer.php
  yKAh
  븤      F   vendor/symfony/framework-bundle/Resources/config/fragment_listener.phpw  yKAhw  Vg      F   vendor/symfony/framework-bundle/Resources/config/translation_debug.php  yKAh  $      C   vendor/symfony/framework-bundle/Resources/config/notifier_debug.php  yKAh  w0      A   vendor/symfony/framework-bundle/Resources/config/rate_limiter.php  yKAh  |s      9   vendor/symfony/framework-bundle/Resources/config/lock.php  yKAh  z      H   vendor/symfony/framework-bundle/Resources/config/identity_translator.php  yKAh  W      @   vendor/symfony/framework-bundle/Resources/config/http_client.phpx
  yKAhx
  ^?Ϥ      A   vendor/symfony/framework-bundle/Resources/config/mailer_debug.php  yKAh  `܄       =   vendor/symfony/framework-bundle/Resources/config/services.php]#  yKAh]#  k      :   vendor/symfony/framework-bundle/Resources/config/cache.php"  yKAh"  -l7      <   vendor/symfony/framework-bundle/Resources/config/session.php  yKAh  wr      F   vendor/symfony/framework-bundle/Resources/config/mailer_transports.php  yKAh  i?
      J   vendor/symfony/framework-bundle/Resources/config/translation_providers.php	  yKAh	  ?H      :   vendor/symfony/framework-bundle/Resources/config/debug.php  yKAh  L_      E   vendor/symfony/framework-bundle/Resources/config/notifier_webhook.php  yKAh  ,      F   vendor/symfony/framework-bundle/Resources/config/fragment_renderer.php	  yKAh	         =   vendor/symfony/framework-bundle/Resources/config/web_link.phpZ  yKAhZ  Oj      <   vendor/symfony/framework-bundle/Resources/config/routing.php  yKAh  A      G   vendor/symfony/framework-bundle/Resources/config/schema/symfony-1.0.xsdg  yKAhg  #`R      =   vendor/symfony/framework-bundle/Resources/config/notifier.php  yKAh  Ec      F   vendor/symfony/framework-bundle/Resources/config/http_client_debug.php  yKAh  "5$      <   vendor/symfony/framework-bundle/Resources/config/request.php  yKAh  kP?      9   vendor/symfony/framework-bundle/Resources/config/test.php  yKAh        <   vendor/symfony/framework-bundle/Resources/config/webhook.php  yKAh  P쌤      D   vendor/symfony/framework-bundle/Resources/config/validator_debug.php  yKAh  GU      C   vendor/symfony/framework-bundle/Resources/config/error_renderer.php/  yKAh/        >   vendor/symfony/framework-bundle/Resources/config/mime_type.php  yKAh  H̤      >   vendor/symfony/framework-bundle/Resources/config/messenger.php?#  yKAh?#  Y      <   vendor/symfony/framework-bundle/Resources/config/console.php3  yKAh3  uҤ      8   vendor/symfony/framework-bundle/Resources/config/uid.php=  yKAh=  S      B   vendor/symfony/framework-bundle/Resources/config/property_info.php	  yKAh	  j      >   vendor/symfony/framework-bundle/Resources/config/scheduler.php  yKAh  1@w      8   vendor/symfony/framework-bundle/Resources/config/ssi.php  yKAh  5{      8   vendor/symfony/framework-bundle/Resources/config/web.php  yKAh  k?֓      D   vendor/symfony/framework-bundle/Resources/config/messenger_debug.php  yKAh  o灤      ?   vendor/symfony/framework-bundle/Resources/config/collectors.phpq  yKAhq  %(      C   vendor/symfony/framework-bundle/Resources/config/routing/errors.xml  yKAh  >      D   vendor/symfony/framework-bundle/Resources/config/routing/webhook.xml  yKAh  Vc      C   vendor/symfony/framework-bundle/Resources/config/html_sanitizer.php  yKAh  Pդ      <   vendor/symfony/framework-bundle/Resources/config/secrets.php  yKAh  *n      9   vendor/symfony/framework-bundle/Resources/config/form.php  yKAh  m17      E   vendor/symfony/framework-bundle/Resources/config/serializer_debug.php  yKAh        C   vendor/symfony/framework-bundle/Resources/config/workflow_debug.php  yKAh  RRT      C   vendor/symfony/framework-bundle/Resources/config/mailer_webhook.php
  yKAh
  dea      >   vendor/symfony/framework-bundle/Resources/config/form_csrf.phpD  yKAhD  A3U      =   vendor/symfony/framework-bundle/Resources/config/workflow.php  yKAh  #m7Y      B   vendor/symfony/framework-bundle/Resources/config/security_csrf.php  yKAh  ~ܤ      H   vendor/symfony/framework-bundle/Resources/config/notifier_transports.php^3  yKAh^3  |      ?   vendor/symfony/framework-bundle/Resources/config/debug_prod.php  yKAh  _Q      D   vendor/symfony/framework-bundle/Resources/config/property_access.php  yKAh  Bʤ      ;   vendor/symfony/framework-bundle/Resources/config/assets.php  yKAh  v'      @   vendor/symfony/framework-bundle/Resources/config/cache_debug.php  yKAh  %]      A   vendor/symfony/framework-bundle/Resources/config/remote_event.php  yKAh  
ä      <   vendor/symfony/framework-bundle/Resources/config/process.phpc  yKAhc        1   vendor/symfony/framework-bundle/KernelBrowser.php  yKAh        D   vendor/symfony/framework-bundle/CacheWarmer/ValidatorCacheWarmer.php^
  yKAh^
  hr      H   vendor/symfony/framework-bundle/CacheWarmer/ConfigBuilderCacheWarmer.phpc  yKAhc  gp      J   vendor/symfony/framework-bundle/CacheWarmer/AbstractPhpFileCacheWarmer.php
  yKAh
  $bΤ      A   vendor/symfony/framework-bundle/CacheWarmer/RouterCacheWarmer.php  yKAh  )      G   vendor/symfony/framework-bundle/CacheWarmer/TranslationsCacheWarmer.php  yKAh  2e      E   vendor/symfony/framework-bundle/CacheWarmer/SerializerCacheWarmer.php  yKAh  ^M      K   vendor/symfony/framework-bundle/CacheWarmer/CachePoolClearerCacheWarmer.php  yKAh  ҧ      F   vendor/symfony/framework-bundle/CacheWarmer/AnnotationsCacheWarmer.php  yKAh  l      A   vendor/symfony/framework-bundle/Controller/AbstractController.phpH  yKAhH        A   vendor/symfony/framework-bundle/Controller/TemplateController.php	  yKAh	  k      A   vendor/symfony/framework-bundle/Controller/ControllerResolver.php3  yKAh3  0      A   vendor/symfony/framework-bundle/Controller/RedirectController.php  yKAh  HǤ      )   vendor/symfony/framework-bundle/README.md!  yKAh!  q      7   vendor/symfony/framework-bundle/HttpCache/HttpCache.php
  yKAh
  R      3   vendor/symfony/framework-bundle/FrameworkBundle.php3  yKAh3  ب       >   vendor/symfony/framework-bundle/Command/SecretsListCommand.php
  yKAh
  cc4      J   vendor/symfony/framework-bundle/Command/CachePoolInvalidateTagsCommand.phpK  yKAhK  ,ؤ      @   vendor/symfony/framework-bundle/Command/SecretsRemoveCommand.phpw
  yKAhw
  A      =   vendor/symfony/framework-bundle/Command/CacheClearCommand.php(  yKAh(  ~      <   vendor/symfony/framework-bundle/Command/XliffLintCommand.php  yKAh  vtc      H   vendor/symfony/framework-bundle/Command/SecretsDecryptToLocalCommand.php
  yKAh
        A   vendor/symfony/framework-bundle/Command/AbstractConfigCommand.phpi  yKAhi  VP      >   vendor/symfony/framework-bundle/Command/RouterDebugCommand.php  yKAh  s`i      D   vendor/symfony/framework-bundle/Command/TranslationUpdateCommand.php/D  yKAh/D  ͉z      F   vendor/symfony/framework-bundle/Command/ConfigDumpReferenceCommand.php8  yKAh8  !      @   vendor/symfony/framework-bundle/Command/AssetsInstallCommand.php'  yKAh'  ]3%      A   vendor/symfony/framework-bundle/Command/CachePoolPruneCommand.php  yKAh  ~T}      A   vendor/symfony/framework-bundle/Command/CachePoolClearCommand.php  yKAh  ZQ~      @   vendor/symfony/framework-bundle/Command/ContainerLintCommand.php\  yKAh\  ]6      J   vendor/symfony/framework-bundle/Command/SecretsEncryptFromLocalCommand.php1	  yKAh1	  dƃ|      B   vendor/symfony/framework-bundle/Command/DebugAutowiringCommand.php  yKAh  \      >   vendor/symfony/framework-bundle/Command/CacheWarmupCommand.php  yKAh  :5Τ      ?   vendor/symfony/framework-bundle/Command/WorkflowDumpCommand.phpD  yKAhD  &      G   vendor/symfony/framework-bundle/Command/EventDispatcherDebugCommand.php  yKAh   ّY      A   vendor/symfony/framework-bundle/Command/ContainerDebugCommand.phps<  yKAhs<  _ q      C   vendor/symfony/framework-bundle/Command/TranslationDebugCommand.phpa<  yKAha<  1g      ;   vendor/symfony/framework-bundle/Command/YamlLintCommand.phpA  yKAhA  Fs      @   vendor/symfony/framework-bundle/Command/CachePoolListCommand.php  yKAh  ;q      F   vendor/symfony/framework-bundle/Command/SecretsGenerateKeysCommand.php  yKAh  ֤      B   vendor/symfony/framework-bundle/Command/CachePoolDeleteCommand.php  yKAh  yUɤ      D   vendor/symfony/framework-bundle/Command/BuildDebugContainerTrait.php
  yKAh
  ҥ      8   vendor/symfony/framework-bundle/Command/AboutCommand.php  yKAh  n٤      >   vendor/symfony/framework-bundle/Command/RouterMatchCommand.php7  yKAh7  }S      =   vendor/symfony/framework-bundle/Command/SecretsSetCommand.php:  yKAh:        >   vendor/symfony/framework-bundle/Command/ConfigDebugCommand.php4)  yKAh4)  E^%      J   vendor/symfony/framework-bundle/Routing/RedirectableCompiledUrlMatcher.php!  yKAh!  )\      J   vendor/symfony/framework-bundle/Routing/AttributeRouteControllerLoader.php  yKAh  v1)      O   vendor/symfony/framework-bundle/Routing/Attribute/AsRoutingConditionService.php  yKAh  ny      @   vendor/symfony/framework-bundle/Routing/RouteLoaderInterface.php  yKAh  b       2   vendor/symfony/framework-bundle/Routing/Router.php  yKAh  ~Un      <   vendor/symfony/framework-bundle/Routing/DelegatingLoader.php
  yKAh
  դ      J   vendor/symfony/framework-bundle/Routing/AnnotatedRouteControllerLoader.php
  yKAh
  y,      E   vendor/symfony/framework-bundle/DependencyInjection/Configuration.phpA yKAhA ~      J   vendor/symfony/framework-bundle/DependencyInjection/FrameworkExtension.phpȃ yKAhȃ n      O   vendor/symfony/framework-bundle/DependencyInjection/VirtualRequestStackPass.php  yKAh  
w      ^   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ContainerBuilderDebugDumpPass.phpS  yKAhS  n>.      `   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TestServiceContainerRealRefPass.php	  yKAh	  j(v      c   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddExpressionLanguageProvidersPass.phpW  yKAhW  W*ͤ      O   vendor/symfony/framework-bundle/DependencyInjection/Compiler/UnusedTagsPass.phpt  yKAht  b"      R   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AssetsContextPass.php  yKAh  o      X   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ErrorLoggerCompilerPass.php  yKAh  9/      ]   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TranslationUpdateCommandPass.php  yKAh        Z   vendor/symfony/framework-bundle/DependencyInjection/Compiler/WorkflowGuardListenerPass.php#  yKAh#  ,      Z   vendor/symfony/framework-bundle/DependencyInjection/Compiler/EnableLoggerDebugModePass.php  yKAh  }V      `   vendor/symfony/framework-bundle/DependencyInjection/Compiler/TestServiceContainerWeakRefPass.php@	  yKAh@	  y`1      V   vendor/symfony/framework-bundle/DependencyInjection/Compiler/LoggingTranslatorPass.phpY  yKAhY  Nx      \   vendor/symfony/framework-bundle/DependencyInjection/Compiler/DataCollectorTranslatorPass.phpV  yKAhV  0#      _   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddAnnotationsCachedReaderPass.php  yKAh  ~Y      M   vendor/symfony/framework-bundle/DependencyInjection/Compiler/ProfilerPass.php	  yKAh	  &1      j   vendor/symfony/framework-bundle/DependencyInjection/Compiler/RemoveUnusedSessionMarshallingHandlerPass.php   yKAh   k)̤      Y   vendor/symfony/framework-bundle/DependencyInjection/Compiler/AddDebugLogProcessorPass.php  yKAh  `:W      -   vendor/symfony/framework-bundle/composer.json  yKAh  cFD
      ;   vendor/symfony/framework-bundle/Kernel/MicroKernelTrait.phpd   yKAhd   ٟO      7   vendor/symfony/framework-bundle/Console/Application.phpE   yKAhE   '23      E   vendor/symfony/framework-bundle/Console/Descriptor/TextDescriptor.phpm  yKAhm  JL      D   vendor/symfony/framework-bundle/Console/Descriptor/XmlDescriptor.phpj  yKAhj  ksnU      A   vendor/symfony/framework-bundle/Console/Descriptor/Descriptor.php6  yKAh6        E   vendor/symfony/framework-bundle/Console/Descriptor/JsonDescriptor.phpD  yKAhD  vF      I   vendor/symfony/framework-bundle/Console/Descriptor/MarkdownDescriptor.php8I  yKAh8I  h      C   vendor/symfony/framework-bundle/Console/Helper/DescriptorHelper.php  yKAh  *      I   vendor/symfony/framework-bundle/EventListener/ConsoleProfilerListener.php  yKAh  c      Q   vendor/symfony/framework-bundle/EventListener/SuggestMissingPackageSubscriber.php	  yKAh	  Su      %   vendor/symfony/monolog-bundle/LICENSE)  yKAh)  Ǥ      *   vendor/symfony/monolog-bundle/CHANGELOG.md  yKAh  :L      :   vendor/symfony/monolog-bundle/Resources/config/monolog.xml.  yKAh.   0yK      E   vendor/symfony/monolog-bundle/Resources/config/schema/monolog-1.0.xsd'  yKAh'  )X      <   vendor/symfony/monolog-bundle/SwiftMailer/MessageFactory.php  yKAh        '   vendor/symfony/monolog-bundle/README.mdY  yKAhY        /   vendor/symfony/monolog-bundle/MonologBundle.php  yKAh  @g      F   vendor/symfony/monolog-bundle/DependencyInjection/MonologExtension.phpi  yKAhi  ve      C   vendor/symfony/monolog-bundle/DependencyInjection/Configuration.php  yKAh  vr      P   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/AddProcessorsPass.php  yKAh  R      P   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/LoggerChannelPass.php  yKAh        O   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/DebugHandlerPass.php
  yKAh
  HS      Q   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/FixEmptyLoggerPass.php  yKAh  DN      Z   vendor/symfony/monolog-bundle/DependencyInjection/Compiler/AddSwiftMailerTransportPass.php  yKAh   *Q      +   vendor/symfony/monolog-bundle/composer.json  yKAh  Ǉ      %   vendor/symfony/polyfill-php73/LICENSE,  yKAh,        '   vendor/symfony/polyfill-php73/Php73.phps  yKAhs  D\      ?   vendor/symfony/polyfill-php73/Resources/stubs/JsonException.phpE  yKAhE  8S      +   vendor/symfony/polyfill-php73/bootstrap.php  yKAh  |      '   vendor/symfony/polyfill-php73/README.md/  yKAh/  m      +   vendor/symfony/polyfill-php73/composer.json  yKAh  t      C   vendor/symfony/serializer/DataCollector/SerializerDataCollector.php?  yKAh?  8      (   vendor/symfony/serializer/Serializer.phpG  yKAhG  =у      I   vendor/symfony/serializer/Mapping/ClassDiscriminatorFromClassMetadata.phpu
  yKAhu
  5      <   vendor/symfony/serializer/Mapping/ClassMetadataInterface.php3  yKAh3  闙      3   vendor/symfony/serializer/Mapping/ClassMetadata.phpV
  yKAhV
  ŏ=      <   vendor/symfony/serializer/Mapping/Loader/AttributeLoader.php+5  yKAh+5  y      7   vendor/symfony/serializer/Mapping/Loader/FileLoader.phpF  yKAhF  hդ      <   vendor/symfony/serializer/Mapping/Loader/LoaderInterface.phpY  yKAhY  
lޤ      ;   vendor/symfony/serializer/Mapping/Loader/YamlFileLoader.php  yKAh  rF      a   vendor/symfony/serializer/Mapping/Loader/schema/dic/serializer-mapping/serializer-mapping-1.0.xsd  yKAh  7      :   vendor/symfony/serializer/Mapping/Loader/XmlFileLoader.php  yKAh  W      8   vendor/symfony/serializer/Mapping/Loader/LoaderChain.php  yKAh  S*      =   vendor/symfony/serializer/Mapping/Loader/AnnotationLoader.php  yKAh  a      I   vendor/symfony/serializer/Mapping/ClassDiscriminatorResolverInterface.php  yKAh  2      @   vendor/symfony/serializer/Mapping/AttributeMetadataInterface.php  yKAh  v5      ?   vendor/symfony/serializer/Mapping/ClassDiscriminatorMapping.php  yKAh  2q      J   vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactoryCompiler.phpp  yKAhp  A
      @   vendor/symfony/serializer/Mapping/Factory/ClassResolverTrait.php+  yKAh+  u鏤      B   vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactory.php  yKAh  5      G   vendor/symfony/serializer/Mapping/Factory/CacheClassMetadataFactory.php  yKAh        J   vendor/symfony/serializer/Mapping/Factory/CompiledClassMetadataFactory.php7  yKAh7  @IP      K   vendor/symfony/serializer/Mapping/Factory/ClassMetadataFactoryInterface.php  yKAh  /      7   vendor/symfony/serializer/Mapping/AttributeMetadata.php  yKAh  j\      1   vendor/symfony/serializer/SerializerInterface.php}  yKAh}  wp      F   vendor/symfony/serializer/Context/Encoder/CsvEncoderContextBuilder.php  yKAh  H      F   vendor/symfony/serializer/Context/Encoder/XmlEncoderContextBuilder.php_  yKAh_  gdr      G   vendor/symfony/serializer/Context/Encoder/YamlEncoderContextBuilder.php  yKAh  \      G   vendor/symfony/serializer/Context/Encoder/JsonEncoderContextBuilder.php  yKAh  8      9   vendor/symfony/serializer/Context/ContextBuilderTrait.php  yKAh  W6      >   vendor/symfony/serializer/Context/SerializerContextBuilder.php  yKAh  ޵R      =   vendor/symfony/serializer/Context/ContextBuilderInterface.php  yKAh  n
      O   vendor/symfony/serializer/Context/Normalizer/ObjectNormalizerContextBuilder.php#  yKAh#  D      Q   vendor/symfony/serializer/Context/Normalizer/DateTimeNormalizerContextBuilder.php  yKAh  ,P      R   vendor/symfony/serializer/Context/Normalizer/FormErrorNormalizerContextBuilder.php  yKAh  sڤ      U   vendor/symfony/serializer/Context/Normalizer/GetSetMethodNormalizerContextBuilder.php/  yKAh/  gB      Y   vendor/symfony/serializer/Context/Normalizer/JsonSerializableNormalizerContextBuilder.php1  yKAh1  z      P   vendor/symfony/serializer/Context/Normalizer/ProblemNormalizerContextBuilder.php  yKAh  \oq      W   vendor/symfony/serializer/Context/Normalizer/AbstractObjectNormalizerContextBuilder.phpQ  yKAhQ  2      S   vendor/symfony/serializer/Context/Normalizer/BackedEnumNormalizerContextBuilder.phpg  yKAhg  S      `   vendor/symfony/serializer/Context/Normalizer/ConstraintViolationListNormalizerContextBuilder.php7  yKAh7  gO      U   vendor/symfony/serializer/Context/Normalizer/UnwrappingDenormalizerContextBuilder.php!  yKAh!  t;9      Q   vendor/symfony/serializer/Context/Normalizer/AbstractNormalizerContextBuilder.php  yKAh  r㽤      L   vendor/symfony/serializer/Context/Normalizer/UidNormalizerContextBuilder.php  yKAh  B4      Q   vendor/symfony/serializer/Context/Normalizer/PropertyNormalizerContextBuilder.php  yKAh  8      U   vendor/symfony/serializer/Context/Normalizer/DateIntervalNormalizerContextBuilder.phpB  yKAhB  Ѥ      6   vendor/symfony/serializer/Attribute/SerializedName.php  yKAh  pl      .   vendor/symfony/serializer/Attribute/Ignore.php  yKAh        /   vendor/symfony/serializer/Attribute/Context.php	  yKAh	  Oq'      8   vendor/symfony/serializer/Attribute/DiscriminatorMap.php  yKAh  Ӥ      6   vendor/symfony/serializer/Attribute/SerializedPath.php  yKAh  <      0   vendor/symfony/serializer/Attribute/MaxDepth.php  yKAh  [v      .   vendor/symfony/serializer/Attribute/Groups.php  yKAh  !x
      !   vendor/symfony/serializer/LICENSE,  yKAh,  U      &   vendor/symfony/serializer/CHANGELOG.md6<  yKAh6<  qSx      0   vendor/symfony/serializer/Encoder/CsvEncoder.php'  yKAh'  8zڤ      B   vendor/symfony/serializer/Encoder/ContextAwareDecoderInterface.php  yKAh  o׍      2   vendor/symfony/serializer/Encoder/ChainEncoder.phpg  yKAhg  A0      6   vendor/symfony/serializer/Encoder/DecoderInterface.php/  yKAh/  
      B   vendor/symfony/serializer/Encoder/ContextAwareEncoderInterface.php  yKAh  Q{N      A   vendor/symfony/serializer/Encoder/NormalizationAwareInterface.phpv  yKAhv  
/g      6   vendor/symfony/serializer/Encoder/EncoderInterface.php  yKAh  _J      2   vendor/symfony/serializer/Encoder/ChainDecoder.php  yKAh  }[      0   vendor/symfony/serializer/Encoder/JsonEncode.php  yKAh  ۤ      1   vendor/symfony/serializer/Encoder/JsonEncoder.php  yKAh  w      0   vendor/symfony/serializer/Encoder/JsonDecode.php<  yKAh<  Dh$      1   vendor/symfony/serializer/Encoder/YamlEncoder.phpq
  yKAhq
  !y]      0   vendor/symfony/serializer/Encoder/XmlEncoder.phpH  yKAhH  pbR      J   vendor/symfony/serializer/CacheWarmer/CompiledClassMetadataCacheWarmer.php7  yKAh7  Ƭc      7   vendor/symfony/serializer/Annotation/SerializedName.php[  yKAh[  PR      /   vendor/symfony/serializer/Annotation/Ignore.phpC  yKAhC  𽩤      0   vendor/symfony/serializer/Annotation/Context.php  yKAh  ;i*      9   vendor/symfony/serializer/Annotation/DiscriminatorMap.phpB  yKAhB  R?      7   vendor/symfony/serializer/Annotation/SerializedPath.php[  yKAh[  ޢ6X      1   vendor/symfony/serializer/Annotation/MaxDepth.phpI  yKAhI  BY      /   vendor/symfony/serializer/Annotation/Groups.php^  yKAh^  wLN      L   vendor/symfony/serializer/Extractor/ObjectPropertyListExtractorInterface.php^  yKAh^  $7      C   vendor/symfony/serializer/Extractor/ObjectPropertyListExtractor.php{  yKAh{  E      6   vendor/symfony/serializer/SerializerAwareInterface.php  yKAh  M      #   vendor/symfony/serializer/README.mdJ  yKAhJ  Mc%      B   vendor/symfony/serializer/NameConverter/NameConverterInterface.php  yKAh  pvEq      J   vendor/symfony/serializer/NameConverter/AdvancedNameConverterInterface.php  yKAh  6      F   vendor/symfony/serializer/NameConverter/MetadataAwareNameConverter.php  yKAh  .]      M   vendor/symfony/serializer/NameConverter/CamelCaseToSnakeCaseNameConverter.php8  yKAh8  \Ѥ      2   vendor/symfony/serializer/Command/DebugCommand.phpy  yKAhy  2 3      ;   vendor/symfony/serializer/Normalizer/DateTimeNormalizer.php  yKAh  aZ      >   vendor/symfony/serializer/Normalizer/MimeMessageNormalizer.phpD  yKAhD  Br͌      @   vendor/symfony/serializer/Normalizer/DenormalizableInterface.phpv  yKAhv        :   vendor/symfony/serializer/Normalizer/ProblemNormalizer.php  yKAh  K      I   vendor/symfony/serializer/Normalizer/CacheableSupportsMethodInterface.php"  yKAh"  Jgɤ      >   vendor/symfony/serializer/Normalizer/ObjectToPopulateTrait.php-  yKAh-  Ґ~}      <   vendor/symfony/serializer/Normalizer/FormErrorNormalizer.php	  yKAh	  cI      J   vendor/symfony/serializer/Normalizer/ContextAwareDenormalizerInterface.php7  yKAh7  #      :   vendor/symfony/serializer/Normalizer/ArrayDenormalizer.php  yKAh        A   vendor/symfony/serializer/Normalizer/AbstractObjectNormalizer.phpו  yKAhו  X      ?   vendor/symfony/serializer/Normalizer/DateTimeZoneNormalizer.php  yKAh  6Ǥ      ?   vendor/symfony/serializer/Normalizer/UnwrappingDenormalizer.php}
  yKAh}
  /)      =   vendor/symfony/serializer/Normalizer/NormalizerAwareTrait.phpk  yKAhk  #      A   vendor/symfony/serializer/Normalizer/NormalizerAwareInterface.php%  yKAh%  :]R      C   vendor/symfony/serializer/Normalizer/JsonSerializableNormalizer.php1
  yKAh1
  PC      :   vendor/symfony/serializer/Normalizer/DataUriNormalizer.php  yKAh  %      H   vendor/symfony/serializer/Normalizer/ContextAwareNormalizerInterface.php  yKAh  +      9   vendor/symfony/serializer/Normalizer/CustomNormalizer.phpB  yKAhB  O(      C   vendor/symfony/serializer/Normalizer/DenormalizerAwareInterface.php/  yKAh/  <ǖ      ?   vendor/symfony/serializer/Normalizer/DateIntervalNormalizer.php  yKAh  zԋ      ;   vendor/symfony/serializer/Normalizer/PropertyNormalizer.php   yKAh   :      9   vendor/symfony/serializer/Normalizer/ObjectNormalizer.php6'  yKAh6'  ЯOQ      ;   vendor/symfony/serializer/Normalizer/AbstractNormalizer.phpa  yKAha  Pt      ?   vendor/symfony/serializer/Normalizer/TranslatableNormalizer.php  yKAh  Z7(G      6   vendor/symfony/serializer/Normalizer/UidNormalizer.php  yKAh   ru      >   vendor/symfony/serializer/Normalizer/DenormalizerInterface.php
  yKAh
  Vi3      >   vendor/symfony/serializer/Normalizer/NormalizableInterface.php  yKAh        ?   vendor/symfony/serializer/Normalizer/GetSetMethodNormalizer.php  yKAh  58m      =   vendor/symfony/serializer/Normalizer/BackedEnumNormalizer.php,  yKAh,  g      J   vendor/symfony/serializer/Normalizer/ConstraintViolationListNormalizer.php  yKAh  o      <   vendor/symfony/serializer/Normalizer/NormalizerInterface.php  yKAh  e      ?   vendor/symfony/serializer/Normalizer/DenormalizerAwareTrait.php{  yKAh{  o      2   vendor/symfony/serializer/SerializerAwareTrait.php`  yKAh`  ĝ|      @   vendor/symfony/serializer/DependencyInjection/SerializerPass.php
  yKAh
        6   vendor/symfony/serializer/Exception/LogicException.php  yKAh  A      :   vendor/symfony/serializer/Exception/ExceptionInterface.php  yKAh  Za      L   vendor/symfony/serializer/Exception/MissingConstructorArgumentsException.php  yKAh  a      @   vendor/symfony/serializer/Exception/UnexpectedValueException.php  yKAh  rǤ      8   vendor/symfony/serializer/Exception/RuntimeException.php  yKAh  VX      E   vendor/symfony/serializer/Exception/NotNormalizableValueException.phpc  yKAhc  N͜      @   vendor/symfony/serializer/Exception/InvalidArgumentException.php  yKAh  n      B   vendor/symfony/serializer/Exception/CircularReferenceException.php  yKAh  s5      >   vendor/symfony/serializer/Exception/BadMethodCallException.php  yKAh  }
      8   vendor/symfony/serializer/Exception/MappingException.php  yKAh  Ǡۤ      <   vendor/symfony/serializer/Exception/UnsupportedException.php  yKAh         B   vendor/symfony/serializer/Exception/NotEncodableValueException.php  yKAh  \53      G   vendor/symfony/serializer/Exception/PartialDenormalizationException.phpM  yKAhM  D      B   vendor/symfony/serializer/Exception/UnsupportedFormatException.php  yKAh  G`k      @   vendor/symfony/serializer/Exception/ExtraAttributesException.php  yKAh  3ٌ      '   vendor/symfony/serializer/composer.json	  yKAh	  ɮ      4   vendor/symfony/serializer/Debug/TraceableEncoder.php'  yKAh'  hͤ      7   vendor/symfony/serializer/Debug/TraceableSerializer.php  yKAh  &Ix      7   vendor/symfony/serializer/Debug/TraceableNormalizer.phpa  yKAha  ;ݤ      *   vendor/symfony/polyfill-php80/PhpToken.php  yKAh  dF      %   vendor/symfony/polyfill-php80/LICENSE,  yKAh,  K      :   vendor/symfony/polyfill-php80/Resources/stubs/PhpToken.phpw  yKAhw  =7T8      <   vendor/symfony/polyfill-php80/Resources/stubs/ValueError.php>  yKAh>  g      ;   vendor/symfony/polyfill-php80/Resources/stubs/Attribute.php  yKAh  MK<      E   vendor/symfony/polyfill-php80/Resources/stubs/UnhandledMatchError.phpG  yKAhG  ֈ+      <   vendor/symfony/polyfill-php80/Resources/stubs/Stringable.php  yKAh  t]\ڤ      +   vendor/symfony/polyfill-php80/bootstrap.php  yKAh  .Ĥ      '   vendor/symfony/polyfill-php80/README.md  yKAh  "tF      '   vendor/symfony/polyfill-php80/Php80.php  yKAh  H      +   vendor/symfony/polyfill-php80/composer.jsonb  yKAhb  F      7   vendor/symfony/monolog-bridge/Handler/MailerHandler.php  yKAh  1d      H   vendor/symfony/monolog-bridge/Handler/CompatibilityProcessingHandler.php  yKAh        8   vendor/symfony/monolog-bridge/Handler/ConsoleHandler.php  yKAh  Ѻ	      S   vendor/symfony/monolog-bridge/Handler/FingersCrossed/HttpCodeActivationStrategy.php  yKAh  c      S   vendor/symfony/monolog-bridge/Handler/FingersCrossed/NotFoundActivationStrategy.phpT  yKAhT  s      :   vendor/symfony/monolog-bridge/Handler/ServerLogHandler.php  yKAh  \~      >   vendor/symfony/monolog-bridge/Handler/CompatibilityHandler.php  yKAh  !E      9   vendor/symfony/monolog-bridge/Handler/NotifierHandler.php	  yKAh	  %ˤ      8   vendor/symfony/monolog-bridge/Handler/FirePHPHandler.php  yKAh  J      :   vendor/symfony/monolog-bridge/Handler/ChromePhpHandler.php0  yKAh0  ݤ      F   vendor/symfony/monolog-bridge/Handler/ElasticsearchLogstashHandler.php  yKAh  I6      (   vendor/symfony/monolog-bridge/Logger.php-
  yKAh-
  y      %   vendor/symfony/monolog-bridge/LICENSE,  yKAh,  U      *   vendor/symfony/monolog-bridge/CHANGELOG.md
  yKAh
  `s      :   vendor/symfony/monolog-bridge/Processor/TokenProcessor.php<  yKAh<  ]      D   vendor/symfony/monolog-bridge/Processor/SwitchUserTokenProcessor.php  yKAh  A܊      8   vendor/symfony/monolog-bridge/Processor/WebProcessor.php  yKAh        B   vendor/symfony/monolog-bridge/Processor/CompatibilityProcessor.php!  yKAh!  6$      :   vendor/symfony/monolog-bridge/Processor/RouteProcessor.php	  yKAh	  <      C   vendor/symfony/monolog-bridge/Processor/ConsoleCommandProcessor.phpJ  yKAhJ  ZU      B   vendor/symfony/monolog-bridge/Processor/AbstractTokenProcessor.php  yKAh  dC      :   vendor/symfony/monolog-bridge/Processor/DebugProcessor.php  yKAh  c4      '   vendor/symfony/monolog-bridge/README.md  yKAh  =~      <   vendor/symfony/monolog-bridge/Formatter/ConsoleFormatter.php  yKAh  Pp      >   vendor/symfony/monolog-bridge/Formatter/VarDumperFormatter.php0  yKAh0  r~ݤ      B   vendor/symfony/monolog-bridge/Formatter/CompatibilityFormatter.php  yKAh  ˦k      :   vendor/symfony/monolog-bridge/Command/ServerLogCommand.php  yKAh        +   vendor/symfony/monolog-bridge/composer.json  yKAh  -}b      9   vendor/symfony/cache/DataCollector/CacheDataCollector.php  yKAh        "   vendor/symfony/cache/CacheItem.php  yKAh  =g      #   vendor/symfony/cache/Psr16Cache.php=  yKAh=  8`c         vendor/symfony/cache/LICENSE,  yKAh,  X      +   vendor/symfony/cache/PruneableInterface.php  yKAh  a]      !   vendor/symfony/cache/CHANGELOG.mdo  yKAho  ʗXJ      5   vendor/symfony/cache/Traits/RedisClusterNodeProxy.php  yKAh  &yF      /   vendor/symfony/cache/Traits/RelayProxyTrait.php  yKAh  R      *   vendor/symfony/cache/Traits/RedisTrait.phpBu  yKAhBu  pU      +   vendor/symfony/cache/Traits/Redis5Proxy.php׷  yKAh׷  \٤      2   vendor/symfony/cache/Traits/RedisCluster6Proxy.phps  yKAhs  Q      *   vendor/symfony/cache/Traits/ProxyTrait.php%  yKAh%  P      5   vendor/symfony/cache/Traits/FilesystemCommonTrait.php9  yKAh9        1   vendor/symfony/cache/Traits/RedisClusterProxy.php  yKAh  `"      *   vendor/symfony/cache/Traits/RedisProxy.php  yKAh  G.r      .   vendor/symfony/cache/Traits/ContractsTrait.php&  yKAh&  .M=      *   vendor/symfony/cache/Traits/RelayProxy.php  yKAh  Vz"      0   vendor/symfony/cache/Traits/Redis6ProxyTrait.php  yKAh  P      ,   vendor/symfony/cache/Traits/ValueWrapper.phpE  yKAhE  i7      2   vendor/symfony/cache/Traits/RedisCluster5Proxy.php\  yKAh\  UҤ      /   vendor/symfony/cache/Traits/FilesystemTrait.php  yKAh  7      +   vendor/symfony/cache/Traits/Redis6Proxy.php  yKAh  X      4   vendor/symfony/cache/Traits/Relay/GeosearchTrait.php'  yKAh'  7      /   vendor/symfony/cache/Traits/Relay/MoveTrait.php  yKAh  b      2   vendor/symfony/cache/Traits/Relay/PfcountTrait.php  yKAh  D      /   vendor/symfony/cache/Traits/Relay/CopyTrait.php  yKAh  ѽ      9   vendor/symfony/cache/Traits/Relay/NullableReturnTrait.phpZ  yKAhZ  *zʤ      /   vendor/symfony/cache/Traits/Relay/HsetTrait.php  yKAh  E      3   vendor/symfony/cache/Traits/Relay/GetrangeTrait.php  yKAh  XԖ      4   vendor/symfony/cache/Traits/AbstractAdapterTrait.php\0  yKAh\0  1Ť      7   vendor/symfony/cache/Traits/RedisCluster6ProxyTrait.php  yKAh  Xm      -   vendor/symfony/cache/Adapter/ProxyAdapter.php_  yKAh_  <      ,   vendor/symfony/cache/Adapter/ApcuAdapter.php?
  yKAh?
  [/      ;   vendor/symfony/cache/Adapter/CouchbaseCollectionAdapter.php  yKAh  ƫ}      1   vendor/symfony/cache/Adapter/TraceableAdapter.php  yKAh  
bJ6      +   vendor/symfony/cache/Adapter/PdoAdapter.phpA  yKAhA        -   vendor/symfony/cache/Adapter/ArrayAdapter.php,  yKAh,  ߍ       5   vendor/symfony/cache/Adapter/RedisTagAwareAdapter.php0  yKAh0  1      7   vendor/symfony/cache/Adapter/CouchbaseBucketAdapter.php  yKAh  <^      ,   vendor/symfony/cache/Adapter/NullAdapter.php  yKAh  :@      4   vendor/symfony/cache/Adapter/ParameterNormalizer.php  yKAh  +      0   vendor/symfony/cache/Adapter/TagAwareAdapter.php,  yKAh,  mX      0   vendor/symfony/cache/Adapter/PhpFilesAdapter.php(  yKAh(   &      4   vendor/symfony/cache/Adapter/DoctrineDbalAdapter.phpA  yKAhA  nƬq      9   vendor/symfony/cache/Adapter/TagAwareAdapterInterface.php	  yKAh	  ?      1   vendor/symfony/cache/Adapter/MemcachedAdapter.php4  yKAh4  l9
      -   vendor/symfony/cache/Adapter/RedisAdapter.php/  yKAh/  -U=$      1   vendor/symfony/cache/Adapter/AdapterInterface.php  yKAh  $B      :   vendor/symfony/cache/Adapter/FilesystemTagAwareAdapter.php#  yKAh#  ˤ      9   vendor/symfony/cache/Adapter/TraceableTagAwareAdapter.php  yKAh  6s:      -   vendor/symfony/cache/Adapter/Psr16Adapter.php*  yKAh*  $\      -   vendor/symfony/cache/Adapter/ChainAdapter.php]"  yKAh]"  x      2   vendor/symfony/cache/Adapter/FilesystemAdapter.php  yKAh  (Acb      0   vendor/symfony/cache/Adapter/AbstractAdapter.php2  yKAh2  @2      8   vendor/symfony/cache/Adapter/AbstractTagAwareAdapter.php1  yKAh1  ;,      0   vendor/symfony/cache/Adapter/PhpArrayAdapter.php/  yKAh/   Ť      %   vendor/symfony/cache/LockRegistry.php  yKAh  )?Ӥ      ,   vendor/symfony/cache/ResettableInterface.php  yKAh  NR         vendor/symfony/cache/README.md  yKAh  `t:      9   vendor/symfony/cache/Messenger/EarlyExpirationHandler.php7
  yKAh7
  r      9   vendor/symfony/cache/Messenger/EarlyExpirationMessage.php
  yKAh
  %      <   vendor/symfony/cache/Messenger/EarlyExpirationDispatcher.php	  yKAh	  q      5   vendor/symfony/cache/Marshaller/DefaultMarshaller.phpK  yKAhK  h&      5   vendor/symfony/cache/Marshaller/DeflateMarshaller.php  yKAh  C      7   vendor/symfony/cache/Marshaller/MarshallerInterface.php3  yKAh3  Ǚ      6   vendor/symfony/cache/Marshaller/TagAwareMarshaller.php  yKAh  t      4   vendor/symfony/cache/Marshaller/SodiumMarshaller.php`	  yKAh`	  F      :   vendor/symfony/cache/DependencyInjection/CachePoolPass.php,'  yKAh,'  VM      @   vendor/symfony/cache/DependencyInjection/CachePoolPrunerPass.php  yKAh  m}      ?   vendor/symfony/cache/DependencyInjection/CacheCollectorPass.php  yKAh  t      A   vendor/symfony/cache/DependencyInjection/CachePoolClearerPass.php  yKAh  Ł:      1   vendor/symfony/cache/Exception/LogicException.php  yKAh  9d      ;   vendor/symfony/cache/Exception/InvalidArgumentException.php  yKAh  j      1   vendor/symfony/cache/Exception/CacheException.php  yKAh  Q4      "   vendor/symfony/cache/composer.json  yKAh  Fw      -   vendor/symfony/polyfill-ctype/bootstrap80.phpr  yKAhr  F)      %   vendor/symfony/polyfill-ctype/LICENSE,  yKAh,        +   vendor/symfony/polyfill-ctype/bootstrap.php@  yKAh@  jQ9      '   vendor/symfony/polyfill-ctype/README.md^  yKAh^  lHk      '   vendor/symfony/polyfill-ctype/Ctype.php  yKAh   /      +   vendor/symfony/polyfill-ctype/composer.json  yKAh  9      %   vendor/symfony/polyfill-php81/LICENSE,  yKAh,  0      F   vendor/symfony/polyfill-php81/Resources/stubs/ReturnTypeWillChange.php  yKAh  5+      @   vendor/symfony/polyfill-php81/Resources/stubs/CURLStringFile.php  yKAh  JT      +   vendor/symfony/polyfill-php81/bootstrap.php  yKAh  <P      '   vendor/symfony/polyfill-php81/README.md  yKAh        '   vendor/symfony/polyfill-php81/Php81.php  yKAh  3E      +   vendor/symfony/polyfill-php81/composer.json  yKAh  #@      F   vendor/symfony/security-bundle/DataCollector/SecurityDataCollector.php>.  yKAh>.  n      &   vendor/symfony/security-bundle/LICENSE,  yKAh,  U      +   vendor/symfony/security-bundle/CHANGELOG.mdCD  yKAhCD  ;      ?   vendor/symfony/security-bundle/Security/LazyFirewallContext.php	  yKAh	  Ӈ      =   vendor/symfony/security-bundle/Security/UserAuthenticator.php>  yKAh>  @      ;   vendor/symfony/security-bundle/Security/FirewallContext.phpC  yKAhC  7{Ȥ      7   vendor/symfony/security-bundle/Security/FirewallMap.php;	  yKAh;	  5r\      :   vendor/symfony/security-bundle/Security/FirewallConfig.php	  yKAh	  `9p      >   vendor/symfony/security-bundle/Security/FirewallAwareTrait.php  yKAh  s      W   vendor/symfony/security-bundle/Resources/config/security_authenticator_access_token.php  yKAh  43MU      C   vendor/symfony/security-bundle/Resources/config/templating_twig.php  yKAh  @']      F   vendor/symfony/security-bundle/Resources/config/security_listeners.php  yKAh  Ne      U   vendor/symfony/security-bundle/Resources/config/security_authenticator_login_link.php	  yKAh	  +      B   vendor/symfony/security-bundle/Resources/config/security_debug.php3  yKAh3  6!H!      A   vendor/symfony/security-bundle/Resources/config/debug_console.php   yKAh         G   vendor/symfony/security-bundle/Resources/config/schema/security-1.0.xsdX  yKAhX  f#      ;   vendor/symfony/security-bundle/Resources/config/console.php  yKAh  ,      C   vendor/symfony/security-bundle/Resources/config/password_hasher.php  yKAh  J      >   vendor/symfony/security-bundle/Resources/config/collectors.php  yKAh  u|      J   vendor/symfony/security-bundle/Resources/config/security_authenticator.php  yKAh  VQ      <   vendor/symfony/security-bundle/Resources/config/security.php	.  yKAh	.  អ      V   vendor/symfony/security-bundle/Resources/config/security_authenticator_remember_me.php  yKAh  K      A   vendor/symfony/security-bundle/Resources/views/Collector/icon.svg  yKAh  0צ      K   vendor/symfony/security-bundle/Resources/views/Collector/security.html.twige  yKAhe  Y      D   vendor/symfony/security-bundle/CacheWarmer/ExpressionCacheWarmer.phpq  yKAhq  50      1   vendor/symfony/security-bundle/SecurityBundle.php  yKAh  7-X      (   vendor/symfony/security-bundle/README.md  yKAh  [A      H   vendor/symfony/security-bundle/RememberMe/DecoratedRememberMeHandler.php^  yKAh^  H:y      L   vendor/symfony/security-bundle/RememberMe/FirewallAwareRememberMeHandler.php@  yKAh@  G٤      ?   vendor/symfony/security-bundle/Command/DebugFirewallCommand.php"  yKAh"  ž&x      <   vendor/symfony/security-bundle/Routing/LogoutRouteLoader.php=  yKAh=  פ      +   vendor/symfony/security-bundle/Security.php1&  yKAh1&  ~,      J   vendor/symfony/security-bundle/LoginLink/FirewallAwareLoginLinkHandler.php	  yKAh	  ߡ      H   vendor/symfony/security-bundle/DependencyInjection/MainConfiguration.phpS9  yKAhS9  |      c   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/OidcTokenHandlerFactory.php3  yKAh3  V      k   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/OidcUserInfoTokenHandlerFactory.php
  yKAh
  ~G      f   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/ServiceTokenHandlerFactory.php  yKAh  CWߤ      h   vendor/symfony/security-bundle/DependencyInjection/Security/AccessToken/TokenHandlerFactoryInterface.php  yKAh  w(      X   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/LdapFactory.php	  yKAh	  HX      \   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/InMemoryFactory.php  yKAh  bHq      i   vendor/symfony/security-bundle/DependencyInjection/Security/UserProvider/UserProviderFactoryInterface.php  yKAh  vi      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LoginLinkFactory.phpm  yKAhm  pSʤ      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/HttpBasicLdapFactory.php  yKAh  (腊      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/JsonLoginLdapFactory.php  yKAh  Rz      Z   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AccessTokenFactory.php  yKAh  AY      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FormLoginFactory.phpv  yKAhv  zä      \   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FormLoginLdapFactory.phpK  yKAhK  pR      b   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/CustomAuthenticatorFactory.php  yKAh  Xi      Y   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/RemoteUserFactory.php  yKAh  :Pդ      e   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AuthenticatorFactoryInterface.phpG  yKAhG  3S      Y   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/RememberMeFactory.php*  yKAh*  隤      W   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/AbstractFactory.php  yKAh  p      S   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/X509Factory.php  yKAh  Vr@      a   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/SignatureAlgorithmFactory.phpf  yKAhf  P      h   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/FirewallListenerFactoryInterface.php  yKAh  }/      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/JsonLoginFactory.php  yKAh  
      n   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/StatelessAuthenticatorFactoryInterface.php	  yKAh	  9̤      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/HttpBasicFactory.php  yKAh  soF      X   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LdapFactoryTrait.phpm	  yKAhm	  盤      ^   vendor/symfony/security-bundle/DependencyInjection/Security/Factory/LoginThrottlingFactory.php  yKAh  .b      H   vendor/symfony/security-bundle/DependencyInjection/SecurityExtension.php  yKAh  =2W[      b   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddExpressionLanguageProvidersPass.php  yKAh  ߐ*7      ^   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterTokenUsageTrackingPass.php	  yKAh	  І;      W   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterLdapLocatorPass.phpW  yKAhW  9k      h   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterGlobalSecurityEventListenersPass.php 
  yKAh 
  Ǔ      Y   vendor/symfony/security-bundle/DependencyInjection/Compiler/SortFirewallListenersPass.phpO  yKAhO  դ      e   vendor/symfony/security-bundle/DependencyInjection/Compiler/ReplaceDecoratedRememberMeHandlerPass.php	  yKAh	  >y      ^   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddSessionDomainConstraintPass.php  yKAh  x      U   vendor/symfony/security-bundle/DependencyInjection/Compiler/AddSecurityVotersPass.php
  yKAh
  rҤ      V   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterEntryPointPass.php  yKAh  d%      i   vendor/symfony/security-bundle/DependencyInjection/Compiler/MakeFirewallsEventDispatcherTraceablePass.php`
  yKAh`
  U
p3      [   vendor/symfony/security-bundle/DependencyInjection/Compiler/CleanRememberMeVerifierPass.php  yKAh  "*A      X   vendor/symfony/security-bundle/DependencyInjection/Compiler/RegisterCsrfFeaturesPass.php	  yKAh	  8I      ,   vendor/symfony/security-bundle/composer.json  yKAh  ֛      B   vendor/symfony/security-bundle/Debug/TraceableFirewallListener.phpN  yKAhN  Z.      8   vendor/symfony/security-bundle/Debug/WrappedListener.php  yKAh  D      ?   vendor/symfony/security-bundle/Debug/TraceableListenerTrait.phpj  yKAhj  qU      <   vendor/symfony/security-bundle/Debug/WrappedLazyListener.php  yKAh  
9      A   vendor/symfony/security-bundle/EventListener/FirewallListener.php  yKAh  +C      =   vendor/symfony/security-bundle/EventListener/VoteListener.phpB  yKAhB  <ˊϤ      4   vendor/symfony/config/ResourceCheckerConfigCache.php~  yKAh~  p         vendor/symfony/config/LICENSE,  yKAh,  U      '   vendor/symfony/config/Util/XmlUtils.php$  yKAh$  U6      <   vendor/symfony/config/Util/Exception/XmlParsingException.php  yKAh  䢗      <   vendor/symfony/config/Util/Exception/InvalidXmlException.php4  yKAh4        "   vendor/symfony/config/CHANGELOG.mde  yKAhe  (,      .   vendor/symfony/config/ConfigCacheInterface.php  yKAh  	1      .   vendor/symfony/config/FileLocatorInterface.php  yKAh        %   vendor/symfony/config/ConfigCache.php  yKAh  S      5   vendor/symfony/config/ConfigCacheFactoryInterface.php  yKAh  ^&      %   vendor/symfony/config/FileLocator.php4
  yKAh4
  =      2   vendor/symfony/config/ResourceCheckerInterface.php  yKAh  åؤ         vendor/symfony/config/README.mdT  yKAhT        '   vendor/symfony/config/Loader/Loader.php  yKAh  IѤ      >   vendor/symfony/config/Loader/DirectoryAwareLoaderInterface.php  yKAh  j=      +   vendor/symfony/config/Loader/FileLoader.php  yKAh  bUL      2   vendor/symfony/config/Loader/ParamConfigurator.phpq  yKAhq  n݁      0   vendor/symfony/config/Loader/LoaderInterface.phpy  yKAhy  ঽ      8   vendor/symfony/config/Loader/LoaderResolverInterface.php  yKAh  G/3      /   vendor/symfony/config/Loader/LoaderResolver.phpF  yKAhF  )%%      1   vendor/symfony/config/Loader/DelegatingLoader.php  yKAh  Κ%      /   vendor/symfony/config/Loader/GlobFileLoader.php  yKAh  [      .   vendor/symfony/config/Definition/FloatNode.php  yKAh  Ť      -   vendor/symfony/config/Definition/BaseNode.php:  yKAh:  qY6      0   vendor/symfony/config/Definition/NumericNode.php)  yKAh)  	ä      :   vendor/symfony/config/Definition/ConfigurableInterface.phpo  yKAho  jש,      0   vendor/symfony/config/Definition/IntegerNode.phpV  yKAhV  (      ;   vendor/symfony/config/Definition/PrototypeNodeInterface.phpp  yKAhp  <5@      2   vendor/symfony/config/Definition/Configuration.php  yKAh  j      8   vendor/symfony/config/Definition/PrototypedArrayNode.php,  yKAh,  d#      .   vendor/symfony/config/Definition/Processor.php	  yKAh	   \      @   vendor/symfony/config/Definition/Loader/DefinitionFileLoader.php  yKAh   "      2   vendor/symfony/config/Definition/NodeInterface.phpL  yKAhL  Q      -   vendor/symfony/config/Definition/EnumNode.php
  yKAh
  |      0   vendor/symfony/config/Definition/BooleanNode.php  yKAh  
B      H   vendor/symfony/config/Definition/Configurator/DefinitionConfigurator.phpy  yKAhy  =      .   vendor/symfony/config/Definition/ArrayNode.php.  yKAh.  ͤ      /   vendor/symfony/config/Definition/ScalarNode.php}  yKAh}  GrI      ;   vendor/symfony/config/Definition/ConfigurationInterface.php  yKAh  _+      8   vendor/symfony/config/Definition/Builder/ExprBuilder.phpL  yKAhL  :^      ?   vendor/symfony/config/Definition/Builder/EnumNodeDefinition.php  yKAh  <      9   vendor/symfony/config/Definition/Builder/MergeBuilder.php  yKAh  |      B   vendor/symfony/config/Definition/Builder/NumericNodeDefinition.phpm  yKAhm  Mg      8   vendor/symfony/config/Definition/Builder/NodeBuilder.php  yKAh  |פ      C   vendor/symfony/config/Definition/Builder/VariableNodeDefinition.phpg  yKAhg  ?      @   vendor/symfony/config/Definition/Builder/ArrayNodeDefinition.php=  yKAh=  M}      B   vendor/symfony/config/Definition/Builder/BuilderAwareInterface.phpl  yKAhl  %      >   vendor/symfony/config/Definition/Builder/ValidationBuilder.php  yKAh  ]
      8   vendor/symfony/config/Definition/Builder/TreeBuilder.phpE  yKAhE  O      B   vendor/symfony/config/Definition/Builder/IntegerNodeDefinition.php  yKAh  \+F}      @   vendor/symfony/config/Definition/Builder/NodeParentInterface.php  yKAh  ʤ      A   vendor/symfony/config/Definition/Builder/NormalizationBuilder.php  yKAh  Xä      B   vendor/symfony/config/Definition/Builder/BooleanNodeDefinition.php  yKAh  YDq      J   vendor/symfony/config/Definition/Builder/ParentNodeDefinitionInterface.php  yKAh  Σ      A   vendor/symfony/config/Definition/Builder/ScalarNodeDefinition.php  yKAh  *@      @   vendor/symfony/config/Definition/Builder/FloatNodeDefinition.php  yKAh  ю      ;   vendor/symfony/config/Definition/Builder/NodeDefinition.phpf  yKAhf  3Ԥ      D   vendor/symfony/config/Definition/Exception/DuplicateKeyException.phpS  yKAhS  g      I   vendor/symfony/config/Definition/Exception/InvalidDefinitionException.php  yKAh  re      C   vendor/symfony/config/Definition/Exception/InvalidTypeException.php  yKAh  2      @   vendor/symfony/config/Definition/Exception/UnsetKeyException.php*  yKAh*  %2d      L   vendor/symfony/config/Definition/Exception/InvalidConfigurationException.php  yKAh  i      J   vendor/symfony/config/Definition/Exception/ForbiddenOverwriteException.php_  yKAh_  :      8   vendor/symfony/config/Definition/Exception/Exception.php  yKAh  RrO      1   vendor/symfony/config/Definition/VariableNode.php
  yKAh
  o      ?   vendor/symfony/config/Definition/Dumper/YamlReferenceDumper.php   yKAh   0      >   vendor/symfony/config/Definition/Dumper/XmlReferenceDumper.php'  yKAh'        @   vendor/symfony/config/Resource/SelfCheckingResourceInterface.php  yKAh  2Ф      /   vendor/symfony/config/Resource/FileResource.php  yKAh  a      :   vendor/symfony/config/Resource/ReflectionClassResource.php  yKAh  h[      >   vendor/symfony/config/Resource/SelfCheckingResourceChecker.php}  yKAh}  r      3   vendor/symfony/config/Resource/ComposerResource.php2  yKAh2  3Pu      8   vendor/symfony/config/Resource/FileExistenceResource.php  yKAh  w}      4   vendor/symfony/config/Resource/ResourceInterface.php  yKAh  8I      9   vendor/symfony/config/Resource/ClassExistenceResource.php   yKAh   T$      4   vendor/symfony/config/Resource/DirectoryResource.php
  yKAh
  C      /   vendor/symfony/config/Resource/GlobResource.phpW!  yKAhW!  ׏3      8   vendor/symfony/config/Builder/ConfigBuilderInterface.php  yKAh  {O      (   vendor/symfony/config/Builder/Method.php  yKAh  @֤      .   vendor/symfony/config/Builder/ClassBuilder.php  yKAh        *   vendor/symfony/config/Builder/Property.php,  yKAh,  _      A   vendor/symfony/config/Builder/ConfigBuilderGeneratorInterface.php  yKAh        8   vendor/symfony/config/Builder/ConfigBuilderGenerator.phpR  yKAhR  9      7   vendor/symfony/config/Exception/LoaderLoadException.php  yKAh  /z      N   vendor/symfony/config/Exception/FileLoaderImportCircularReferenceException.php[  yKAh[  `ܤ      D   vendor/symfony/config/Exception/FileLocatorFileNotFoundException.phpK  yKAhK  f      #   vendor/symfony/config/composer.json   yKAh   M      ,   vendor/symfony/config/ConfigCacheFactory.phpS  yKAhS  cġ      ;   vendor/symfony/config/ResourceCheckerConfigCacheFactory.php5  yKAh5  Yb      D   vendor/symfony/security-http/RateLimiter/DefaultLoginRateLimiter.php  yKAh  b      4   vendor/symfony/security-http/Attribute/IsGranted.php  yKAh  `A      6   vendor/symfony/security-http/Attribute/CurrentUser.php!  yKAh!  C      $   vendor/symfony/security-http/LICENSE,  yKAh,  U      5   vendor/symfony/security-http/Util/TargetPathTrait.phpb  yKAhb  6=Y      )   vendor/symfony/security-http/CHANGELOG.md  yKAh  k      ,   vendor/symfony/security-http/FirewallMap.phpf  yKAhf  r      )   vendor/symfony/security-http/Firewall.php]  yKAh]        J   vendor/symfony/security-http/AccessToken/AccessTokenExtractorInterface.phpf  yKAhf  }P      H   vendor/symfony/security-http/AccessToken/AccessTokenHandlerInterface.php  yKAh  msl      G   vendor/symfony/security-http/AccessToken/HeaderAccessTokenExtractor.php8  yKAh8  h      F   vendor/symfony/security-http/AccessToken/ChainAccessTokenExtractor.php'  yKAh'  g
      J   vendor/symfony/security-http/AccessToken/Oidc/OidcUserInfoTokenHandler.phpc	  yKAhc	        ;   vendor/symfony/security-http/AccessToken/Oidc/OidcTrait.php  yKAh  ̤      B   vendor/symfony/security-http/AccessToken/Oidc/OidcTokenHandler.php  yKAh        U   vendor/symfony/security-http/AccessToken/Oidc/Exception/InvalidSignatureException.php  yKAh  +FL      Q   vendor/symfony/security-http/AccessToken/Oidc/Exception/MissingClaimException.php  yKAh  	      E   vendor/symfony/security-http/AccessToken/FormEncodedBodyExtractor.phpm  yKAhm  }      F   vendor/symfony/security-http/AccessToken/QueryAccessTokenExtractor.php  yKAh  w      :   vendor/symfony/security-http/Logout/LogoutUrlGenerator.phpv  yKAhv  +      /   vendor/symfony/security-http/SecurityEvents.php  yKAh  7      8   vendor/symfony/security-http/Firewall/AccessListener.php
  yKAh
  8ä      9   vendor/symfony/security-http/Firewall/ContextListener.php5  yKAh5  d`ۤ      :   vendor/symfony/security-http/Firewall/AbstractListener.phpq  yKAhq        F   vendor/symfony/security-http/Firewall/AuthenticatorManagerListener.phpj  yKAhj  ʯ      ;   vendor/symfony/security-http/Firewall/ExceptionListener.phpf(  yKAhf(  ti      C   vendor/symfony/security-http/Firewall/FirewallListenerInterface.php=  yKAh=  9      9   vendor/symfony/security-http/Firewall/ChannelListener.php  yKAh  2      <   vendor/symfony/security-http/Firewall/SwitchUserListener.phpE$  yKAhE$  hް      8   vendor/symfony/security-http/Firewall/LogoutListener.php  yKAh  (3\      F   vendor/symfony/security-http/Controller/SecurityTokenValueResolver.php  yKAh  J;Y      =   vendor/symfony/security-http/Controller/UserValueResolver.php  yKAh  ؉M      &   vendor/symfony/security-http/README.md  yKAh  k      <   vendor/symfony/security-http/RememberMe/ResponseListener.php  yKAh         G   vendor/symfony/security-http/RememberMe/PersistentRememberMeHandler.php   yKAh   V      F   vendor/symfony/security-http/RememberMe/RememberMeHandlerInterface.php
  yKAh
  	~¤      =   vendor/symfony/security-http/RememberMe/RememberMeDetails.phpQ  yKAhQ  Gk<[      E   vendor/symfony/security-http/RememberMe/AbstractRememberMeHandler.phpX  yKAhX  a*      F   vendor/symfony/security-http/RememberMe/SignatureRememberMeHandler.php
  yKAh
  xo$f      M   vendor/symfony/security-http/EntryPoint/AuthenticationEntryPointInterface.php  yKAh  3i      N   vendor/symfony/security-http/EntryPoint/Exception/NotAnEntryPointException.php  yKAh  (6      *   vendor/symfony/security-http/HttpUtils.php  yKAh  e      5   vendor/symfony/security-http/FirewallMapInterface.php  yKAh  9J      L   vendor/symfony/security-http/Authenticator/Token/PostAuthenticationToken.phpT  yKAhT  H      P   vendor/symfony/security-http/Authenticator/InteractiveAuthenticatorInterface.phpj  yKAhj  9      M   vendor/symfony/security-http/Authenticator/AbstractLoginFormAuthenticator.php	  yKAh	  e      E   vendor/symfony/security-http/Authenticator/AuthenticatorInterface.phpS
  yKAhS
  v
      A   vendor/symfony/security-http/Authenticator/FallbackUserLoader.php  yKAh  ٤      D   vendor/symfony/security-http/Authenticator/AbstractAuthenticator.php  yKAh   R      E   vendor/symfony/security-http/Authenticator/HttpBasicAuthenticator.phpe  yKAhe  Z      E   vendor/symfony/security-http/Authenticator/LoginLinkAuthenticator.php?  yKAh?  !6      E   vendor/symfony/security-http/Authenticator/JsonLoginAuthenticator.php  yKAh  7$;      N   vendor/symfony/security-http/Authenticator/Passport/SelfValidatingPassport.php  yKAh  YWW      @   vendor/symfony/security-http/Authenticator/Passport/Passport.php$  yKAh$   ;!2      X   vendor/symfony/security-http/Authenticator/Passport/Credentials/CredentialsInterface.php  yKAh  P      U   vendor/symfony/security-http/Authenticator/Passport/Credentials/CustomCredentials.php  yKAh  @1      W   vendor/symfony/security-http/Authenticator/Passport/Credentials/PasswordCredentials.phpV  yKAhV  R      W   vendor/symfony/security-http/Authenticator/Passport/Badge/PreAuthenticatedUserBadge.php  yKAh  yΤ      L   vendor/symfony/security-http/Authenticator/Passport/Badge/CsrfTokenBadge.phpi  yKAhi  $      R   vendor/symfony/security-http/Authenticator/Passport/Badge/PasswordUpgradeBadge.phpV  yKAhV  Ĥ      G   vendor/symfony/security-http/Authenticator/Passport/Badge/UserBadge.php  yKAh  V5פ      M   vendor/symfony/security-http/Authenticator/Passport/Badge/RememberMeBadge.phpK  yKAhK  p"      L   vendor/symfony/security-http/Authenticator/Passport/Badge/BadgeInterface.php  yKAh  ˙Au      @   vendor/symfony/security-http/Authenticator/X509Authenticator.php	  yKAh	  }      G   vendor/symfony/security-http/Authenticator/AccessTokenAuthenticator.php  yKAh  YTS      F   vendor/symfony/security-http/Authenticator/RemoteUserAuthenticator.php  yKAh  _]z      E   vendor/symfony/security-http/Authenticator/FormLoginAuthenticator.phpS  yKAhS  eQ8      T   vendor/symfony/security-http/Authenticator/AbstractPreAuthenticatedAuthenticator.php  yKAh  hʆ`      K   vendor/symfony/security-http/Authenticator/Debug/TraceableAuthenticator.phpO  yKAhO  ӊ2      Z   vendor/symfony/security-http/Authenticator/Debug/TraceableAuthenticatorManagerListener.phpg  yKAhg        F   vendor/symfony/security-http/Authenticator/RememberMeAuthenticator.php  yKAh  Au      K   vendor/symfony/security-http/Authorization/AccessDeniedHandlerInterface.phpz  yKAhz  (      3   vendor/symfony/security-http/AccessMapInterface.phpi  yKAhi  HY%      ;   vendor/symfony/security-http/LoginLink/LoginLinkDetails.phpe  yKAhe  Z/      ;   vendor/symfony/security-http/LoginLink/LoginLinkHandler.php  yKAh        @   vendor/symfony/security-http/LoginLink/LoginLinkNotification.php
  yKAh
  ֽ      D   vendor/symfony/security-http/LoginLink/LoginLinkHandlerInterface.php  yKAh  \S      W   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkExceptionInterface.php  yKAh  HF      N   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkException.php  yKAh        \   vendor/symfony/security-http/LoginLink/Exception/InvalidLoginLinkAuthenticationException.php  yKAh  <Yķ      N   vendor/symfony/security-http/LoginLink/Exception/ExpiredLoginLinkException.phpI  yKAhI  Z      S   vendor/symfony/security-http/Authentication/DefaultAuthenticationFailureHandler.phph  yKAhh  [)-G      M   vendor/symfony/security-http/Authentication/AuthenticatorManagerInterface.php  yKAh  1      R   vendor/symfony/security-http/Authentication/CustomAuthenticationSuccessHandler.php  yKAh  W"¤      U   vendor/symfony/security-http/Authentication/AuthenticationFailureHandlerInterface.php>  yKAh>        C   vendor/symfony/security-http/Authentication/AuthenticationUtils.php	  yKAh	  ج      R   vendor/symfony/security-http/Authentication/CustomAuthenticationFailureHandler.php  yKAh  c      U   vendor/symfony/security-http/Authentication/AuthenticationSuccessHandlerInterface.phpI  yKAhI  &4Q      J   vendor/symfony/security-http/Authentication/UserAuthenticatorInterface.php  yKAh  
>      D   vendor/symfony/security-http/Authentication/AuthenticatorManager.php6  yKAh6  c
9      S   vendor/symfony/security-http/Authentication/DefaultAuthenticationSuccessHandler.php  yKAh  N"      *   vendor/symfony/security-http/AccessMap.php~  yKAh~  t<y      8   vendor/symfony/security-http/Event/LoginFailureEvent.php;
  yKAh;
  (Ϥ      8   vendor/symfony/security-http/Event/LoginSuccessEvent.php<  yKAh<  .      8   vendor/symfony/security-http/Event/LazyResponseEvent.php  yKAh  /H
      6   vendor/symfony/security-http/Event/SwitchUserEvent.php  yKAh  U      F   vendor/symfony/security-http/Event/AuthenticationTokenCreatedEvent.phpW  yKAhW  c|      9   vendor/symfony/security-http/Event/CheckPassportEvent.php  yKAh  g      <   vendor/symfony/security-http/Event/InteractiveLoginEvent.phpG  yKAhG  <KB      2   vendor/symfony/security-http/Event/LogoutEvent.php  yKAh        @   vendor/symfony/security-http/Event/TokenDeauthenticatedEvent.php  yKAh  X2      D   vendor/symfony/security-http/Impersonate/ImpersonateUrlGenerator.php%  yKAh%  ./ U      2   vendor/symfony/security-http/ParameterBagUtils.php  yKAh  [7b      *   vendor/symfony/security-http/composer.json\  yKAh\  7      :   vendor/symfony/security-http/SecurityRequestAttributes.php  yKAh  J      J   vendor/symfony/security-http/EventListener/ClearSiteDataLogoutListener.php  yKAh  jͤ      D   vendor/symfony/security-http/EventListener/SessionLogoutListener.php  yKAh  t      D   vendor/symfony/security-http/EventListener/DefaultLogoutListener.phpm  yKAhm        H   vendor/symfony/security-http/EventListener/PasswordMigratingListener.php  yKAh  £פ      A   vendor/symfony/security-http/EventListener/RememberMeListener.php  yKAh  vx.ʤ      F   vendor/symfony/security-http/EventListener/LoginThrottlingListener.php
  yKAh
  L      C   vendor/symfony/security-http/EventListener/UserProviderListener.phpf  yKAhf  6i      K   vendor/symfony/security-http/EventListener/CookieClearingLogoutListener.php  yKAh  o[      G   vendor/symfony/security-http/EventListener/CheckCredentialsListener.php  yKAh  );L      F   vendor/symfony/security-http/EventListener/SessionStrategyListener.php  yKAh  Yؤ      N   vendor/symfony/security-http/EventListener/CsrfTokenClearingLogoutListener.phpp  yKAhp  u      B   vendor/symfony/security-http/EventListener/UserCheckerListener.phpi  yKAhi  g%      I   vendor/symfony/security-http/EventListener/IsGrantedAttributeListener.php  yKAh  5D      E   vendor/symfony/security-http/EventListener/CsrfProtectionListener.php  yKAh        P   vendor/symfony/security-http/EventListener/CheckRememberMeConditionsListener.php
  yKAh
  wj      O   vendor/symfony/security-http/Session/SessionAuthenticationStrategyInterface.phpC  yKAhC  'ʤ      F   vendor/symfony/security-http/Session/SessionAuthenticationStrategy.php]  yKAh]  Q         vendor/symfony/uid/UuidV8.phpK  yKAhK  {dL      !   vendor/symfony/uid/BinaryUtil.php-  yKAh-   Ҥ         vendor/symfony/uid/NilUuid.php  yKAh  MzĤ         vendor/symfony/uid/LICENSE,  yKAh,  K         vendor/symfony/uid/NilUlid.php  yKAh  [         vendor/symfony/uid/CHANGELOG.md  yKAh        "   vendor/symfony/uid/AbstractUid.php[  yKAh[  boO         vendor/symfony/uid/Ulid.phpP  yKAhP  ݤ         vendor/symfony/uid/Uuid.php  yKAh  t0[O         vendor/symfony/uid/MaxUlid.php  yKAh  >Z         vendor/symfony/uid/MaxUuid.php  yKAh  Sw4         vendor/symfony/uid/README.md\  yKAh\        2   vendor/symfony/uid/Command/GenerateUuidCommand.php(  yKAh(  vF@      2   vendor/symfony/uid/Command/GenerateUlidCommand.php  yKAh  ->      1   vendor/symfony/uid/Command/InspectUuidCommand.php
  yKAh
  +}      1   vendor/symfony/uid/Command/InspectUlidCommand.php  yKAh  0>Ȉ         vendor/symfony/uid/UuidV1.phpV  yKAhV  ʤ         vendor/symfony/uid/UuidV3.php^  yKAh^  (L         vendor/symfony/uid/UuidV6.phpN  yKAhN  ͤ         vendor/symfony/uid/UuidV7.php  yKAh  ,aä      3   vendor/symfony/uid/Factory/TimeBasedUuidFactory.php-  yKAh-  i`mU      *   vendor/symfony/uid/Factory/UuidFactory.php>
  yKAh>
   Xw      5   vendor/symfony/uid/Factory/RandomBasedUuidFactory.php[  yKAh[  \(R      *   vendor/symfony/uid/Factory/UlidFactory.php  yKAh  )ݿ      3   vendor/symfony/uid/Factory/NameBasedUuidFactory.php  yKAh  0 A          vendor/symfony/uid/composer.json  yKAh  s	ۤ      ,   vendor/symfony/uid/TimeBasedUidInterface.php  yKAh  Q         vendor/symfony/uid/UuidV5.php^  yKAh^  A         vendor/symfony/uid/UuidV4.php  yKAh  <      <   vendor/symfony/event-dispatcher/EventDispatcherInterface.php  yKAh  a      =   vendor/symfony/event-dispatcher/Attribute/AsEventListener.php  yKAh  $      '   vendor/symfony/event-dispatcher/LICENSE,  yKAh,  U      ,   vendor/symfony/event-dispatcher/CHANGELOG.md]  yKAh]  uE~      3   vendor/symfony/event-dispatcher/EventDispatcher.php9#  yKAh9#  ή&      )   vendor/symfony/event-dispatcher/README.mdW  yKAhW  ,fB      <   vendor/symfony/event-dispatcher/EventSubscriberInterface.php  yKAh  A{)      <   vendor/symfony/event-dispatcher/ImmutableEventDispatcher.php  yKAh  w      0   vendor/symfony/event-dispatcher/GenericEvent.php
  yKAh
  d      M   vendor/symfony/event-dispatcher/DependencyInjection/RegisterListenersPass.php   yKAh   i٤      K   vendor/symfony/event-dispatcher/DependencyInjection/AddEventAliasesPass.php  yKAh  &{      -   vendor/symfony/event-dispatcher/composer.json  yKAh  R      B   vendor/symfony/event-dispatcher/Debug/TraceableEventDispatcher.php0  yKAh0  U*u      9   vendor/symfony/event-dispatcher/Debug/WrappedListener.php  yKAh  okŤ      +   vendor/symfony/var-dumper/Cloner/Cursor.phpH  yKAhH  cq      .   vendor/symfony/var-dumper/Cloner/VarCloner.php)  yKAh)  
      4   vendor/symfony/var-dumper/Cloner/ClonerInterface.php  yKAh  ze      7   vendor/symfony/var-dumper/Cloner/Internal/NoDefault.php4  yKAh4  ߞ      4   vendor/symfony/var-dumper/Cloner/DumperInterface.phpo  yKAho  k      3   vendor/symfony/var-dumper/Cloner/AbstractCloner.php]  yKAh]  $^      )   vendor/symfony/var-dumper/Cloner/Data.php5  yKAh5  G      )   vendor/symfony/var-dumper/Cloner/Stub.phpk  yKAhk  Xܤ      !   vendor/symfony/var-dumper/LICENSE,  yKAh,  .z      5   vendor/symfony/var-dumper/Test/VarDumperTestTrait.phpV
  yKAhV
  F      &   vendor/symfony/var-dumper/CHANGELOG.md	  yKAh	  "D      .   vendor/symfony/var-dumper/Caster/GmpCaster.php
  yKAh
  "       5   vendor/symfony/var-dumper/Caster/ReflectionCaster.php;  yKAh;  -,      /   vendor/symfony/var-dumper/Caster/StubCaster.php	  yKAh	  @v      2   vendor/symfony/var-dumper/Caster/SymfonyCaster.php
  yKAh
  Ҥ      .   vendor/symfony/var-dumper/Caster/FrameStub.php  yKAh  aa      7   vendor/symfony/var-dumper/Caster/ProxyManagerCaster.php#  yKAh#  DJ      .   vendor/symfony/var-dumper/Caster/FFICaster.php  yKAh  ь      /   vendor/symfony/var-dumper/Caster/DateCaster.php;  yKAh;  C7>      .   vendor/symfony/var-dumper/Caster/PdoCaster.php  yKAh  ɤ      6   vendor/symfony/var-dumper/Caster/XmlResourceCaster.php|	  yKAh|	        3   vendor/symfony/var-dumper/Caster/ResourceCaster.php  yKAh  ~      4   vendor/symfony/var-dumper/Caster/ExceptionCaster.phpmA  yKAhmA  SL      6   vendor/symfony/var-dumper/Caster/UninitializedStub.phpy  yKAhy  0:      -   vendor/symfony/var-dumper/Caster/DsCaster.phpS  yKAhS  c      -   vendor/symfony/var-dumper/Caster/LinkStub.phpH
  yKAhH
  ϼ      4   vendor/symfony/var-dumper/Caster/MemcachedCaster.php  yKAh  Y#g	      3   vendor/symfony/var-dumper/Caster/DoctrineCaster.phpG  yKAhG  55      2   vendor/symfony/var-dumper/Caster/RdKafkaCaster.php  yKAh  9#      1   vendor/symfony/var-dumper/Caster/MysqliCaster.php  yKAh        ,   vendor/symfony/var-dumper/Caster/ImgStub.php  yKAh  ͤ      .   vendor/symfony/var-dumper/Caster/ClassStub.php?  yKAh?  7V      .   vendor/symfony/var-dumper/Caster/TraceStub.php  yKAh  _      1   vendor/symfony/var-dumper/Caster/CutArrayStub.php  yKAh  QG      0   vendor/symfony/var-dumper/Caster/PgSqlCaster.phpj  yKAhj  'K4      +   vendor/symfony/var-dumper/Caster/Caster.php*  yKAh*  n      .   vendor/symfony/var-dumper/Caster/SplCaster.php]  yKAh]  4Dӻ      .   vendor/symfony/var-dumper/Caster/ConstStub.php   yKAh   3Ôk      /   vendor/symfony/var-dumper/Caster/ScalarStub.phpF  yKAhF  fA      /   vendor/symfony/var-dumper/Caster/DsPairStub.phpn  yKAhn  0
      /   vendor/symfony/var-dumper/Caster/IntlCaster.php  yKAh        0   vendor/symfony/var-dumper/Caster/RedisCaster.php  yKAh  $OP      0   vendor/symfony/var-dumper/Caster/FiberCaster.phpf  yKAhf  K      2   vendor/symfony/var-dumper/Caster/ImagineCaster.php  yKAh  |gdߤ      /   vendor/symfony/var-dumper/Caster/AmqpCaster.phpH  yKAhH        .   vendor/symfony/var-dumper/Caster/DOMCaster.phpN  yKAhN  t      /   vendor/symfony/var-dumper/Caster/UuidCaster.php  yKAh  E7      4   vendor/symfony/var-dumper/Caster/XmlReaderCaster.php  yKAh  5      -   vendor/symfony/var-dumper/Caster/ArgsStub.php	  yKAh	  O      -   vendor/symfony/var-dumper/Caster/EnumStub.php  yKAh  `"      ,   vendor/symfony/var-dumper/Caster/CutStub.php  yKAh        7   vendor/symfony/var-dumper/Resources/bin/var-dump-server  yKAh  '      :   vendor/symfony/var-dumper/Resources/css/htmlDescriptor.css  yKAh  Dva      8   vendor/symfony/var-dumper/Resources/js/htmlDescriptor.jsb  yKAhb  h|      6   vendor/symfony/var-dumper/Resources/functions/dump.phpU  yKAhU  <      /   vendor/symfony/var-dumper/Server/Connection.php
  yKAh
  xΤ      /   vendor/symfony/var-dumper/Server/DumpServer.php  yKAh  U駤      #   vendor/symfony/var-dumper/README.md_  yKAh_  Fq      7   vendor/symfony/var-dumper/Command/ServerDumpCommand.php  yKAh  S+      H   vendor/symfony/var-dumper/Command/Descriptor/DumpDescriptorInterface.php  yKAh  a*      >   vendor/symfony/var-dumper/Command/Descriptor/CliDescriptor.php
  yKAh
  d      ?   vendor/symfony/var-dumper/Command/Descriptor/HtmlDescriptor.php  yKAh  	      ?   vendor/symfony/var-dumper/Exception/ThrowingCasterException.php  yKAh  ä      1   vendor/symfony/var-dumper/Dumper/ServerDumper.php  yKAh  DZ      8   vendor/symfony/var-dumper/Dumper/DataDumperInterface.php@  yKAh@  o/      M   vendor/symfony/var-dumper/Dumper/ContextProvider/ContextProviderInterface.php(  yKAh(  EFf      K   vendor/symfony/var-dumper/Dumper/ContextProvider/RequestContextProvider.php  yKAh  oꭤ      G   vendor/symfony/var-dumper/Dumper/ContextProvider/CliContextProvider.php  yKAh  y9.L      J   vendor/symfony/var-dumper/Dumper/ContextProvider/SourceContextProvider.php  yKAh  u      3   vendor/symfony/var-dumper/Dumper/AbstractDumper.php0  yKAh0        .   vendor/symfony/var-dumper/Dumper/CliDumper.phpZ  yKAhZ  '      9   vendor/symfony/var-dumper/Dumper/ContextualizedDumper.php  yKAh  U      /   vendor/symfony/var-dumper/Dumper/HtmlDumper.php<  yKAh<   F      '   vendor/symfony/var-dumper/composer.jsonw  yKAhw  %E      '   vendor/symfony/var-dumper/VarDumper.php  yKAh  Ϥ      !   vendor/symfony/filesystem/LICENSE,  yKAh,  U      &   vendor/symfony/filesystem/CHANGELOG.md  yKAh  I      (   vendor/symfony/filesystem/Filesystem.phpt  yKAht  1      "   vendor/symfony/filesystem/Path.php
f  yKAh
f  ׀s      #   vendor/symfony/filesystem/README.md  yKAh        <   vendor/symfony/filesystem/Exception/IOExceptionInterface.php  yKAh        :   vendor/symfony/filesystem/Exception/ExceptionInterface.php  yKAh  (l`Ф      8   vendor/symfony/filesystem/Exception/RuntimeException.php  yKAh  A      3   vendor/symfony/filesystem/Exception/IOException.php  yKAh  0      @   vendor/symfony/filesystem/Exception/InvalidArgumentException.php  yKAh  $
      =   vendor/symfony/filesystem/Exception/FileNotFoundException.php  yKAh   [:      '   vendor/symfony/filesystem/composer.json{  yKAh{  zq      G   vendor/symfony/security-csrf/TokenStorage/NativeSessionTokenStorage.php
  yKAh
  .פ      A   vendor/symfony/security-csrf/TokenStorage/SessionTokenStorage.phpK  yKAhK  <_      L   vendor/symfony/security-csrf/TokenStorage/ClearableTokenStorageInterface.php3  yKAh3        C   vendor/symfony/security-csrf/TokenStorage/TokenStorageInterface.php  yKAh  7䭤      $   vendor/symfony/security-csrf/LICENSE,  yKAh,  U      )   vendor/symfony/security-csrf/CHANGELOG.md  yKAh  >*      *   vendor/symfony/security-csrf/CsrfToken.php  yKAh  3      &   vendor/symfony/security-csrf/README.md  yKAh        :   vendor/symfony/security-csrf/CsrfTokenManagerInterface.php  yKAh  yɤ      E   vendor/symfony/security-csrf/TokenGenerator/UriSafeTokenGenerator.php  yKAh  1      G   vendor/symfony/security-csrf/TokenGenerator/TokenGeneratorInterface.php  yKAh  <xx      1   vendor/symfony/security-csrf/CsrfTokenManager.php  yKAh  Zؤ      A   vendor/symfony/security-csrf/Exception/TokenNotFoundException.php  yKAh   U      *   vendor/symfony/security-csrf/composer.json  yKAh  -      ,   vendor/symfony/polyfill-uuid/bootstrap80.php  yKAh  jx      $   vendor/symfony/polyfill-uuid/LICENSE,  yKAh,        %   vendor/symfony/polyfill-uuid/Uuid.phpqB  yKAhqB  E      *   vendor/symfony/polyfill-uuid/bootstrap.php#  yKAh#  )      &   vendor/symfony/polyfill-uuid/README.md[  yKAh[  Ƥ      *   vendor/symfony/polyfill-uuid/composer.json  yKAh  {Ĥ      7   vendor/symfony/polyfill-intl-normalizer/bootstrap80.php  yKAh  ,      /   vendor/symfony/polyfill-intl-normalizer/LICENSE,  yKAh,  H      6   vendor/symfony/polyfill-intl-normalizer/Normalizer.php8$  yKAh8$  &(C      F   vendor/symfony/polyfill-intl-normalizer/Resources/stubs/Normalizer.php  yKAh  %      L   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/combiningClass.php.  yKAh.  Cb      T   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/canonicalDecomposition.phpx  yKAhx        R   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/canonicalComposition.php=  yKAh=  V{      X   vendor/symfony/polyfill-intl-normalizer/Resources/unidata/compatibilityDecomposition.php  yKAh  [
+      5   vendor/symfony/polyfill-intl-normalizer/bootstrap.php  yKAh  #p      1   vendor/symfony/polyfill-intl-normalizer/README.md  yKAh  +tK      5   vendor/symfony/polyfill-intl-normalizer/composer.jsonx  yKAhx        F   vendor/symfony/event-dispatcher-contracts/EventDispatcherInterface.php,  yKAh,  ۃf      3   vendor/symfony/event-dispatcher-contracts/Event.php  yKAh  +Vg      1   vendor/symfony/event-dispatcher-contracts/LICENSE,  yKAh,        6   vendor/symfony/event-dispatcher-contracts/CHANGELOG.md   yKAh   h{#      3   vendor/symfony/event-dispatcher-contracts/README.mdZ  yKAhZ  9{Am      7   vendor/symfony/event-dispatcher-contracts/composer.json?  yKAh?  ׿s      8   vendor/symfony/property-access/PropertyPathInterface.php  yKAh  z      7   vendor/symfony/property-access/PropertyPathIterator.php  yKAh  ax      &   vendor/symfony/property-access/LICENSE,  yKAh,  U      @   vendor/symfony/property-access/PropertyPathIteratorInterface.php  yKAh  
M      +   vendor/symfony/property-access/CHANGELOG.md
  yKAh
  <4      <   vendor/symfony/property-access/PropertyAccessorInterface.php  yKAh  {Q      /   vendor/symfony/property-access/PropertyPath.php  yKAh  cA      :   vendor/symfony/property-access/PropertyAccessorBuilder.php  yKAh  0l      (   vendor/symfony/property-access/README.md1  yKAh1  !Q      3   vendor/symfony/property-access/PropertyAccessor.phpq{  yKAhq{  UBp      1   vendor/symfony/property-access/PropertyAccess.php  yKAh        6   vendor/symfony/property-access/PropertyPathBuilder.php!  yKAh!  2{      <   vendor/symfony/property-access/Exception/AccessException.php  yKAh  KW      K   vendor/symfony/property-access/Exception/UninitializedPropertyException.php  yKAh  ,      ?   vendor/symfony/property-access/Exception/ExceptionInterface.php  yKAh  l      A   vendor/symfony/property-access/Exception/OutOfBoundsException.php  yKAh  ؤ      =   vendor/symfony/property-access/Exception/RuntimeException.php  yKAh  Cn      E   vendor/symfony/property-access/Exception/InvalidArgumentException.php  yKAh  IF[3      I   vendor/symfony/property-access/Exception/InvalidPropertyPathException.php  yKAh  zޤ      D   vendor/symfony/property-access/Exception/UnexpectedTypeException.phpy  yKAhy  bR      A   vendor/symfony/property-access/Exception/NoSuchIndexException.php  yKAh  NQp      D   vendor/symfony/property-access/Exception/NoSuchPropertyException.php  yKAh  ?      ,   vendor/symfony/property-access/composer.json~  yKAh~        %   vendor/symfony/finder/SplFileInfo.php  yKAh  9$̤      5   vendor/symfony/finder/Comparator/NumberComparator.php
  yKAh
        /   vendor/symfony/finder/Comparator/Comparator.php  yKAh  @x      3   vendor/symfony/finder/Comparator/DateComparator.php  yKAh  ~Q          vendor/symfony/finder/Finder.phpc  yKAhc  v>         vendor/symfony/finder/LICENSE,  yKAh,  U      "   vendor/symfony/finder/CHANGELOG.md
  yKAh
  3g         vendor/symfony/finder/Glob.php2  yKAh2  A         vendor/symfony/finder/README.md  yKAh  C      /   vendor/symfony/finder/Iterator/LazyIterator.php  yKAh  Wđ      ;   vendor/symfony/finder/Iterator/VcsIgnoredFilterIterator.php'  yKAh'  n!      <   vendor/symfony/finder/Iterator/FilecontentFilterIterator.php  yKAh  \v:c      =   vendor/symfony/finder/Iterator/MultiplePcreFilterIterator.php  yKAh  N      :   vendor/symfony/finder/Iterator/SizeRangeFilterIterator.phpk  yKAhk  4-      9   vendor/symfony/finder/Iterator/FilenameFilterIterator.phpn  yKAhn  MNQ      :   vendor/symfony/finder/Iterator/DateRangeFilterIterator.php  yKAh  9z֤      7   vendor/symfony/finder/Iterator/CustomFilterIterator.php  yKAh  	ʤ      =   vendor/symfony/finder/Iterator/RecursiveDirectoryIterator.phpO  yKAhO        A   vendor/symfony/finder/Iterator/ExcludeDirectoryFilterIterator.php5
  yKAh5
  `      3   vendor/symfony/finder/Iterator/SortableIterator.php3  yKAh3  뛽       ;   vendor/symfony/finder/Iterator/DepthRangeFilterIterator.phpn  yKAhn  O      9   vendor/symfony/finder/Iterator/FileTypeFilterIterator.php|  yKAh|  Aj      5   vendor/symfony/finder/Iterator/PathFilterIterator.php  yKAh  (      #   vendor/symfony/finder/Gitignore.php  yKAh  Q)      9   vendor/symfony/finder/Exception/AccessDeniedException.php  yKAh        >   vendor/symfony/finder/Exception/DirectoryNotFoundException.php  yKAh  )      #   vendor/symfony/finder/composer.json*  yKAh*  _      -   vendor/symfony/polyfill-php83/bootstrap81.php  yKAh  p$      %   vendor/symfony/polyfill-php83/LICENSE,  yKAh,  t=      B   vendor/symfony/polyfill-php83/Resources/stubs/SQLite3Exception.phpH  yKAhH  <ܐ      ;   vendor/symfony/polyfill-php83/Resources/stubs/DateError.php=  yKAh=  ˤ      :   vendor/symfony/polyfill-php83/Resources/stubs/Override.php  yKAh  NsE      ?   vendor/symfony/polyfill-php83/Resources/stubs/DateException.phpE  yKAhE        O   vendor/symfony/polyfill-php83/Resources/stubs/DateInvalidOperationException.phpY  yKAhY  Mߤ      A   vendor/symfony/polyfill-php83/Resources/stubs/DateObjectError.phpG  yKAhG  
.I      T   vendor/symfony/polyfill-php83/Resources/stubs/DateMalformedPeriodStringException.php^  yKAh^  K      N   vendor/symfony/polyfill-php83/Resources/stubs/DateMalformedStringException.phpX  yKAhX  Wߤ      @   vendor/symfony/polyfill-php83/Resources/stubs/DateRangeError.phpF  yKAhF  L;      N   vendor/symfony/polyfill-php83/Resources/stubs/DateInvalidTimeZoneException.phpX  yKAhX  g      V   vendor/symfony/polyfill-php83/Resources/stubs/DateMalformedIntervalStringException.php`  yKAh`  6      +   vendor/symfony/polyfill-php83/bootstrap.php  yKAh  {Jc      '   vendor/symfony/polyfill-php83/README.md  yKAh  }      '   vendor/symfony/polyfill-php83/Php83.php
  yKAh
  \9>      +   vendor/symfony/polyfill-php83/composer.json  yKAh  {V      >   vendor/symfony/http-kernel/DataCollector/DumpDataCollector.php%+  yKAh%+  p	q      @   vendor/symfony/http-kernel/DataCollector/MemoryDataCollector.php  yKAh  ]%      G   vendor/symfony/http-kernel/DataCollector/LateDataCollectorInterface.php/  yKAh/  D
      @   vendor/symfony/http-kernel/DataCollector/RouterDataCollector.php	  yKAh	  W}}      >   vendor/symfony/http-kernel/DataCollector/TimeDataCollector.php
  yKAh
  R       C   vendor/symfony/http-kernel/DataCollector/DataCollectorInterface.php  yKAh        A   vendor/symfony/http-kernel/DataCollector/RequestDataCollector.phpo>  yKAho>  se      >   vendor/symfony/http-kernel/DataCollector/AjaxDataCollector.phpl  yKAhl  kD      :   vendor/symfony/http-kernel/DataCollector/DataCollector.phpB  yKAhB  r      @   vendor/symfony/http-kernel/DataCollector/LoggerDataCollector.phpV)  yKAhV)  >W      @   vendor/symfony/http-kernel/DataCollector/ConfigDataCollector.php<  yKAh<        ?   vendor/symfony/http-kernel/DataCollector/EventDataCollector.phpG  yKAhG  Jݤ      C   vendor/symfony/http-kernel/DataCollector/ExceptionDataCollector.phpU  yKAhU  	      5   vendor/symfony/http-kernel/Attribute/AsController.php  yKAh  UT      @   vendor/symfony/http-kernel/Attribute/AsTargetedValueResolver.php
  yKAh
  w      .   vendor/symfony/http-kernel/Attribute/Cache.phpX
  yKAhX
  LҌ      7   vendor/symfony/http-kernel/Attribute/MapQueryString.php  yKAh  u~      7   vendor/symfony/http-kernel/Attribute/WithHttpStatus.php^  yKAh^  
      4   vendor/symfony/http-kernel/Attribute/MapDateTime.php   yKAh   j      :   vendor/symfony/http-kernel/Attribute/MapRequestPayload.php)  yKAh)  -"y      5   vendor/symfony/http-kernel/Attribute/WithLogLevel.php  yKAh  FH      6   vendor/symfony/http-kernel/Attribute/ValueResolver.php  yKAh  \      :   vendor/symfony/http-kernel/Attribute/MapQueryParameter.php\  yKAh\  %      "   vendor/symfony/http-kernel/LICENSE,  yKAh,  U      R   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactoryInterface.php  yKAh  ͞1      B   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadata.php  yKAh  S      I   vendor/symfony/http-kernel/ControllerMetadata/ArgumentMetadataFactory.php  yKAh  D{\Ǥ      '   vendor/symfony/http-kernel/CHANGELOG.mdQ  yKAhQ        1   vendor/symfony/http-kernel/Config/FileLocator.phpw  yKAhw        /   vendor/symfony/http-kernel/HttpClientKernel.php  yKAh  u*D      2   vendor/symfony/http-kernel/TerminableInterface.php  yKAh        A   vendor/symfony/http-kernel/CacheClearer/CacheClearerInterface.php*  yKAh*  雗      =   vendor/symfony/http-kernel/CacheClearer/ChainCacheClearer.phpJ  yKAhJ  7      <   vendor/symfony/http-kernel/CacheClearer/Psr6CacheClearer.php  yKAh  r2      5   vendor/symfony/http-kernel/Resources/welcome.html.php  yKAh  i      )   vendor/symfony/http-kernel/HttpKernel.php-  yKAh-  ¤      ?   vendor/symfony/http-kernel/CacheWarmer/CacheWarmerAggregate.php  yKAh  Q      6   vendor/symfony/http-kernel/CacheWarmer/CacheWarmer.php  yKAh  QĤ      <   vendor/symfony/http-kernel/CacheWarmer/WarmableInterface.php3  yKAh3  P@ˤ      ?   vendor/symfony/http-kernel/CacheWarmer/CacheWarmerInterface.php  yKAh  {w]b      ,   vendor/symfony/http-kernel/Bundle/Bundle.php  yKAh  ~o      5   vendor/symfony/http-kernel/Bundle/BundleInterface.php  yKAh  "z      4   vendor/symfony/http-kernel/Bundle/AbstractBundle.php  yKAh  |`      5   vendor/symfony/http-kernel/Bundle/BundleExtension.php	  yKAh	  Y]=      .   vendor/symfony/http-kernel/KernelInterface.php  yKAh  J:      :   vendor/symfony/http-kernel/Controller/ArgumentResolver.php  yKAh  <n      =   vendor/symfony/http-kernel/Controller/ControllerReference.php5  yKAh5  Ul      9   vendor/symfony/http-kernel/Controller/ErrorController.php>  yKAh>  B      E   vendor/symfony/http-kernel/Controller/ContainerControllerResolver.php  yKAh  f      P   vendor/symfony/http-kernel/Controller/ArgumentResolver/VariadicValueResolver.php@  yKAh@  S      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/ServiceValueResolver.php|  yKAh|  wS      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/DefaultValueResolver.php  yKAh  ^(2      V   vendor/symfony/http-kernel/Controller/ArgumentResolver/QueryParameterValueResolver.php  yKAh  g,      K   vendor/symfony/http-kernel/Controller/ArgumentResolver/UidValueResolver.php  yKAh  ybޤ      R   vendor/symfony/http-kernel/Controller/ArgumentResolver/BackedEnumValueResolver.php0  yKAh0  Ns      V   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestPayloadValueResolver.phpD"  yKAhD"  rn      P   vendor/symfony/http-kernel/Controller/ArgumentResolver/DateTimeValueResolver.php
  yKAh
  7      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestValueResolver.php  yKAh  05      O   vendor/symfony/http-kernel/Controller/ArgumentResolver/SessionValueResolver.php  yKAh  o      X   vendor/symfony/http-kernel/Controller/ArgumentResolver/RequestAttributeValueResolver.php  yKAh  q?柤      [   vendor/symfony/http-kernel/Controller/ArgumentResolver/NotTaggedControllerValueResolver.php:
  yKAh:
  <      Q   vendor/symfony/http-kernel/Controller/ArgumentResolver/TraceableValueResolver.php3  yKAh3  8?      C   vendor/symfony/http-kernel/Controller/ArgumentResolverInterface.phpt  yKAht  q/m      E   vendor/symfony/http-kernel/Controller/ControllerResolverInterface.phpy  yKAhy  5ݰʤ      C   vendor/symfony/http-kernel/Controller/TraceableArgumentResolver.php  yKAh  D      @   vendor/symfony/http-kernel/Controller/ValueResolverInterface.php  yKAh  @9      <   vendor/symfony/http-kernel/Controller/ControllerResolver.php0(  yKAh0(  7nl      E   vendor/symfony/http-kernel/Controller/TraceableControllerResolver.phpJ  yKAhJ  #@      H   vendor/symfony/http-kernel/Controller/ArgumentValueResolverInterface.php  yKAh  %      $   vendor/symfony/http-kernel/README.md  yKAh  7      E   vendor/symfony/http-kernel/Fragment/FragmentUriGeneratorInterface.php:  yKAh:  Ze      >   vendor/symfony/http-kernel/Fragment/InlineFragmentRenderer.php  yKAh  b^b      ;   vendor/symfony/http-kernel/Fragment/SsiFragmentRenderer.php%  yKAh%  	      I   vendor/symfony/http-kernel/Fragment/AbstractSurrogateFragmentRenderer.php  yKAh  ,J      A   vendor/symfony/http-kernel/Fragment/FragmentRendererInterface.php  yKAh  Ǜ<      <   vendor/symfony/http-kernel/Fragment/FragmentUriGenerator.php$  yKAh$        ;   vendor/symfony/http-kernel/Fragment/EsiFragmentRenderer.php%  yKAh%  p      @   vendor/symfony/http-kernel/Fragment/HIncludeFragmentRenderer.php/
  yKAh/
  r0      7   vendor/symfony/http-kernel/Fragment/FragmentHandler.php  yKAh  <̤      @   vendor/symfony/http-kernel/Fragment/RoutableFragmentRenderer.php+  yKAh+  rT      +   vendor/symfony/http-kernel/KernelEvents.phpd  yKAhd  Z$      ,   vendor/symfony/http-kernel/HttpCache/Esi.php
  yKAh
  
K\      2   vendor/symfony/http-kernel/HttpCache/HttpCache.phpk  yKAhk  J      .   vendor/symfony/http-kernel/HttpCache/Store.php9  yKAh9  j=      ;   vendor/symfony/http-kernel/HttpCache/SurrogateInterface.php  yKAh  r      G   vendor/symfony/http-kernel/HttpCache/ResponseCacheStrategyInterface.php:  yKAh:  )Ou      >   vendor/symfony/http-kernel/HttpCache/ResponseCacheStrategy.php!  yKAh!  t      7   vendor/symfony/http-kernel/HttpCache/StoreInterface.php  yKAh  +      ,   vendor/symfony/http-kernel/HttpCache/Ssi.phpR
  yKAhR
  Y      :   vendor/symfony/http-kernel/HttpCache/AbstractSurrogate.php  yKAh  ڄ      :   vendor/symfony/http-kernel/HttpCache/SubRequestHandler.php1  yKAh1  イ      2   vendor/symfony/http-kernel/HttpKernelInterface.php  yKAh   Z      )   vendor/symfony/http-kernel/Log/Logger.php2  yKAh2  Y8X      7   vendor/symfony/http-kernel/Log/DebugLoggerInterface.phpD  yKAhD  'V      :   vendor/symfony/http-kernel/Log/DebugLoggerConfigurator.phpH  yKAhH  ,      ;   vendor/symfony/http-kernel/Profiler/FileProfilerStorage.php(  yKAh(  |r      /   vendor/symfony/http-kernel/Profiler/Profile.phpo  yKAho   #      0   vendor/symfony/http-kernel/Profiler/Profiler.php  yKAh  27ya      @   vendor/symfony/http-kernel/Profiler/ProfilerStorageInterface.php  yKAh  0Ĥ      G   vendor/symfony/http-kernel/DependencyInjection/FragmentRendererPass.php  yKAh  P      C   vendor/symfony/http-kernel/DependencyInjection/ServicesResetter.php  yKAh  /v      R   vendor/symfony/http-kernel/DependencyInjection/RegisterLocaleAwareServicesPass.php  yKAh  2@      H   vendor/symfony/http-kernel/DependencyInjection/ResettableServicePass.php  yKAh  &ˏ      R   vendor/symfony/http-kernel/DependencyInjection/MergeExtensionConfigurationPass.php  yKAh  T
      Q   vendor/symfony/http-kernel/DependencyInjection/AddAnnotatedClassesToCachePass.php  yKAh  :      H   vendor/symfony/http-kernel/DependencyInjection/ConfigurableExtension.php  yKAh  6v      =   vendor/symfony/http-kernel/DependencyInjection/LoggerPass.php)  yKAh)  Q*      <   vendor/symfony/http-kernel/DependencyInjection/Extension.php_  yKAh_  ʍ/      V   vendor/symfony/http-kernel/DependencyInjection/ControllerArgumentValueResolverPass.phpY  yKAhY  FT      Y   vendor/symfony/http-kernel/DependencyInjection/RegisterControllerArgumentLocatorsPass.php.  yKAh.  8      \   vendor/symfony/http-kernel/DependencyInjection/RemoveEmptyControllerArgumentLocatorsPass.php
  yKAh
  5
դ      M   vendor/symfony/http-kernel/DependencyInjection/LazyLoadingFragmentHandler.php  yKAh        E   vendor/symfony/http-kernel/Exception/TooManyRequestsHttpException.php  yKAh  <      >   vendor/symfony/http-kernel/Exception/ConflictHttpException.phpc  yKAhc        6   vendor/symfony/http-kernel/Exception/HttpException.phpN  yKAhN  դ      B   vendor/symfony/http-kernel/Exception/UnauthorizedHttpException.php  yKAh  8      A   vendor/symfony/http-kernel/Exception/InvalidMetadataException.phpj  yKAhj  ;녤      D   vendor/symfony/http-kernel/Exception/LengthRequiredHttpException.phpi  yKAhi  
l      I   vendor/symfony/http-kernel/Exception/UnprocessableEntityHttpException.phpw  yKAhw  3      H   vendor/symfony/http-kernel/Exception/PreconditionFailedHttpException.phpm  yKAhm  m%      :   vendor/symfony/http-kernel/Exception/GoneHttpException.php_  yKAh_  ey      J   vendor/symfony/http-kernel/Exception/UnsupportedMediaTypeHttpException.phpo  yKAho  aM}      H   vendor/symfony/http-kernel/Exception/UnexpectedSessionUsageException.php  yKAh  Zis      <   vendor/symfony/http-kernel/Exception/LockedHttpException.phpe  yKAhe  peh      H   vendor/symfony/http-kernel/Exception/ServiceUnavailableHttpException.phpm  yKAhm  =      ?   vendor/symfony/http-kernel/Exception/HttpExceptionInterface.php}  yKAh}  ֚5      B   vendor/symfony/http-kernel/Exception/AccessDeniedHttpException.php  yKAh  6HHg      @   vendor/symfony/http-kernel/Exception/BadRequestHttpException.phpe  yKAhe  Ց      Q   vendor/symfony/http-kernel/Exception/ControllerDoesNotReturnResponseException.php  yKAh  t<
e      C   vendor/symfony/http-kernel/Exception/NotAcceptableHttpException.phph  yKAhh  (ޤ      J   vendor/symfony/http-kernel/Exception/PreconditionRequiredHttpException.php  yKAh  cԤ      >   vendor/symfony/http-kernel/Exception/NotFoundHttpException.phpj  yKAhj  Vz      F   vendor/symfony/http-kernel/Exception/MethodNotAllowedHttpException.php  yKAh  iנ      B   vendor/symfony/http-kernel/Exception/ResolverNotFoundException.php  yKAh  y	+      4   vendor/symfony/http-kernel/Event/ControllerEvent.phpj  yKAhj  w.Ƥ      3   vendor/symfony/http-kernel/Event/ExceptionEvent.php  yKAh  p-      7   vendor/symfony/http-kernel/Event/FinishRequestEvent.php  yKAh  TY      2   vendor/symfony/http-kernel/Event/ResponseEvent.php  yKAh  ,7      3   vendor/symfony/http-kernel/Event/TerminateEvent.php  yKAh  VC      =   vendor/symfony/http-kernel/Event/ControllerArgumentsEvent.php  yKAh  nT      0   vendor/symfony/http-kernel/Event/KernelEvent.php  yKAh  DBc      1   vendor/symfony/http-kernel/Event/RequestEvent.php  yKAh  ׁ      .   vendor/symfony/http-kernel/Event/ViewEvent.php  yKAh        (   vendor/symfony/http-kernel/composer.jsonm  yKAhm  -m      2   vendor/symfony/http-kernel/RebootableInterface.php<  yKAh<  pLX1      %   vendor/symfony/http-kernel/Kernel.phpw  yKAhw  ׆       (   vendor/symfony/http-kernel/UriSigner.php  yKAh  2[{      8   vendor/symfony/http-kernel/Debug/VirtualRequestStack.phpI  yKAhI  U&      =   vendor/symfony/http-kernel/Debug/ErrorHandlerConfigurator.php  yKAh  P      =   vendor/symfony/http-kernel/Debug/TraceableEventDispatcher.php  yKAh  ]`>      6   vendor/symfony/http-kernel/Debug/FileLinkFormatter.php  yKAh        0   vendor/symfony/http-kernel/HttpKernelBrowser.php  yKAh  i\      E   vendor/symfony/http-kernel/EventListener/StreamedResponseListener.php  yKAh  }>Ť      =   vendor/symfony/http-kernel/EventListener/ResponseListener.php  yKAh  PUȤ      ;   vendor/symfony/http-kernel/EventListener/LocaleListener.php  yKAh  7)<      =   vendor/symfony/http-kernel/EventListener/FragmentListener.php8  yKAh8  v      C   vendor/symfony/http-kernel/EventListener/CacheAttributeListener.php1  yKAh1  ۤ      D   vendor/symfony/http-kernel/EventListener/AbstractSessionListener.phpd0  yKAhd0  o!      D   vendor/symfony/http-kernel/EventListener/ValidateRequestListener.php  yKAh  x      K   vendor/symfony/http-kernel/EventListener/DisallowRobotsIndexingListener.phpo  yKAho  >JȤ      F   vendor/symfony/http-kernel/EventListener/AddRequestFormatsListener.php  yKAh  q       =   vendor/symfony/http-kernel/EventListener/ProfilerListener.php<  yKAh<  <3W      >   vendor/symfony/http-kernel/EventListener/SurrogateListener.phpU  yKAhU  M      B   vendor/symfony/http-kernel/EventListener/DebugHandlersListener.php  yKAh  n      @   vendor/symfony/http-kernel/EventListener/LocaleAwareListener.php	  yKAh	        9   vendor/symfony/http-kernel/EventListener/DumpListener.php%  yKAh%  ۤ      :   vendor/symfony/http-kernel/EventListener/ErrorListener.php!  yKAh!  	O      <   vendor/symfony/http-kernel/EventListener/SessionListener.php  yKAh        ;   vendor/symfony/http-kernel/EventListener/RouterListener.php  yKAh  G]9         vendor/symfony/yaml/LICENSE,  yKAh,  U         vendor/symfony/yaml/Parser.php  yKAh  i          vendor/symfony/yaml/CHANGELOG.md  yKAh  Ĥ         vendor/symfony/yaml/Escaper.php  yKAh  
      +   vendor/symfony/yaml/Resources/bin/yaml-lint  yKAh  3VԈ         vendor/symfony/yaml/README.md  yKAh  ـT      !   vendor/symfony/yaml/Unescaper.phpK  yKAhK   脱         vendor/symfony/yaml/Dumper.php  yKAh  h         vendor/symfony/yaml/Inline.php  yKAh  Xwt         vendor/symfony/yaml/Yaml.php  yKAh  LϽ      +   vendor/symfony/yaml/Command/LintCommand.php'  yKAh'  te      /   vendor/symfony/yaml/Exception/DumpException.php  yKAh  ?<̤      4   vendor/symfony/yaml/Exception/ExceptionInterface.php  yKAh  ,P      2   vendor/symfony/yaml/Exception/RuntimeException.php  yKAh  #OU      0   vendor/symfony/yaml/Exception/ParseException.php  yKAh  mFB      '   vendor/symfony/yaml/Tag/TaggedValue.php  yKAh  s$      !   vendor/symfony/yaml/composer.json  yKAh   Zܦ      )   vendor/symfony/string/CodePointString.phpN  yKAhN  J         vendor/symfony/string/LICENSE,  yKAh,  զ_Ϥ      "   vendor/symfony/string/CHANGELOG.mdz  yKAhz  ub      (   vendor/symfony/string/AbstractString.phpI  yKAhI  k      -   vendor/symfony/string/Resources/functions.phpc  yKAhc  Ȥ      <   vendor/symfony/string/Resources/data/wcswidth_table_zero.phpF  yKAhF  MI      <   vendor/symfony/string/Resources/data/wcswidth_table_wide.phpk  yKAhk  /      3   vendor/symfony/string/Inflector/FrenchInflector.php  yKAh  Q      6   vendor/symfony/string/Inflector/InflectorInterface.phpR  yKAhR  _      4   vendor/symfony/string/Inflector/EnglishInflector.phpC  yKAhC  'X<         vendor/symfony/string/README.md+  yKAh+  L      /   vendor/symfony/string/AbstractUnicodeString.phpxc  yKAhxc  7q      $   vendor/symfony/string/LazyString.php  yKAh        $   vendor/symfony/string/ByteString.phpv9  yKAhv9  }      '   vendor/symfony/string/UnicodeString.php1  yKAh1        6   vendor/symfony/string/Exception/ExceptionInterface.php_  yKAh_  :      4   vendor/symfony/string/Exception/RuntimeException.php~  yKAh~  )Ʉ      <   vendor/symfony/string/Exception/InvalidArgumentException.php  yKAh  B;8      #   vendor/symfony/string/composer.json  yKAh  #      2   vendor/symfony/string/Slugger/SluggerInterface.php  yKAh        .   vendor/symfony/string/Slugger/AsciiSlugger.php  yKAh  [=M      4   vendor/symfony/security-core/Role/SwitchUserRole.php  yKAh  'v      <   vendor/symfony/security-core/Role/RoleHierarchyInterface.php]  yKAh]  Բ'      *   vendor/symfony/security-core/Role/Role.php  yKAh  i֜      3   vendor/symfony/security-core/Role/RoleHierarchy.php  yKAh  UՈ      C   vendor/symfony/security-core/Validator/Constraints/UserPassword.php"  yKAh"  <0      L   vendor/symfony/security-core/Validator/Constraints/UserPasswordValidator.php~
  yKAh~
  ^      $   vendor/symfony/security-core/LICENSE,  yKAh,  U      D   vendor/symfony/security-core/Test/AccessDecisionStrategyTestCase.php	  yKAh	  A      B   vendor/symfony/security-core/Signature/ExpiredSignatureStorage.php  yKAh  `5      N   vendor/symfony/security-core/Signature/Exception/InvalidSignatureException.php  yKAh  [.ܤ      N   vendor/symfony/security-core/Signature/Exception/ExpiredSignatureException.php  yKAh  (:      :   vendor/symfony/security-core/Signature/SignatureHasher.php  yKAh  d5A      )   vendor/symfony/security-core/CHANGELOG.md  yKAh  &      C   vendor/symfony/security-core/Resources/translations/security.sq.xlfS  yKAhS  B&^      C   vendor/symfony/security-core/Resources/translations/security.ru.xlf  yKAh  m      C   vendor/symfony/security-core/Resources/translations/security.hy.xlf  yKAh  B      C   vendor/symfony/security-core/Resources/translations/security.fr.xlfU  yKAhU  $      C   vendor/symfony/security-core/Resources/translations/security.fa.xlf  yKAh  IѤ      C   vendor/symfony/security-core/Resources/translations/security.pl.xlf  yKAh  u      C   vendor/symfony/security-core/Resources/translations/security.sv.xlf  yKAh  cn      C   vendor/symfony/security-core/Resources/translations/security.el.xlf8  yKAh8  yva      H   vendor/symfony/security-core/Resources/translations/security.sr_Cyrl.xlf  yKAh        C   vendor/symfony/security-core/Resources/translations/security.en.xlfl  yKAhl  gBZ      C   vendor/symfony/security-core/Resources/translations/security.ja.xlf  yKAh  H      F   vendor/symfony/security-core/Resources/translations/security.pt_BR.xlf  yKAh  iH!      C   vendor/symfony/security-core/Resources/translations/security.no.xlf  yKAh  ~RҤ      C   vendor/symfony/security-core/Resources/translations/security.vi.xlf,  yKAh,  a      C   vendor/symfony/security-core/Resources/translations/security.ur.xlf  yKAh  g      C   vendor/symfony/security-core/Resources/translations/security.nn.xlf  yKAh  l      C   vendor/symfony/security-core/Resources/translations/security.nl.xlf  yKAh  "֤      C   vendor/symfony/security-core/Resources/translations/security.cy.xlfv  yKAhv  FŤ      C   vendor/symfony/security-core/Resources/translations/security.af.xlf  yKAh  ojo      C   vendor/symfony/security-core/Resources/translations/security.lv.xlfc  yKAhc  @ۤ      C   vendor/symfony/security-core/Resources/translations/security.ar.xlf  yKAh  OD      C   vendor/symfony/security-core/Resources/translations/security.lb.xlf)  yKAh)  z7      C   vendor/symfony/security-core/Resources/translations/security.tr.xlf  yKAh  0˵      C   vendor/symfony/security-core/Resources/translations/security.lt.xlfv  yKAhv  @Ȥ      F   vendor/symfony/security-core/Resources/translations/security.zh_CN.xlf  yKAh  D      C   vendor/symfony/security-core/Resources/translations/security.ca.xlf  yKAh  
      C   vendor/symfony/security-core/Resources/translations/security.be.xlfX  yKAhX  \ä      C   vendor/symfony/security-core/Resources/translations/security.th.xlf  yKAh  x=ݤ      C   vendor/symfony/security-core/Resources/translations/security.uz.xlfl  yKAhl  M      C   vendor/symfony/security-core/Resources/translations/security.mk.xlf  yKAh  ڞ      C   vendor/symfony/security-core/Resources/translations/security.bs.xlf  yKAh  %}o      C   vendor/symfony/security-core/Resources/translations/security.bg.xlf  yKAh  d캤      H   vendor/symfony/security-core/Resources/translations/security.sr_Latn.xlf6  yKAh6  dξ      C   vendor/symfony/security-core/Resources/translations/security.uk.xlf  yKAh  6V      F   vendor/symfony/security-core/Resources/translations/security.zh_TW.xlf  yKAh  Ȉf      C   vendor/symfony/security-core/Resources/translations/security.cs.xlf  yKAh  S0k3      C   vendor/symfony/security-core/Resources/translations/security.tl.xlfW  yKAhW        C   vendor/symfony/security-core/Resources/translations/security.my.xlf  yKAh  [v      C   vendor/symfony/security-core/Resources/translations/security.nb.xlf  yKAh  ~RҤ      C   vendor/symfony/security-core/Resources/translations/security.mn.xlf  yKAh  އ      C   vendor/symfony/security-core/Resources/translations/security.az.xlf^  yKAh^  9      C   vendor/symfony/security-core/Resources/translations/security.eu.xlf  yKAh  bs`      C   vendor/symfony/security-core/Resources/translations/security.he.xlfh  yKAhh  u      C   vendor/symfony/security-core/Resources/translations/security.hr.xlf[  yKAh[        C   vendor/symfony/security-core/Resources/translations/security.pt.xlf  yKAh  5>      C   vendor/symfony/security-core/Resources/translations/security.et.xlf  yKAh  s      C   vendor/symfony/security-core/Resources/translations/security.de.xlfV  yKAhV  :      C   vendor/symfony/security-core/Resources/translations/security.sl.xlf  yKAh  A      C   vendor/symfony/security-core/Resources/translations/security.it.xlf  yKAh  a      C   vendor/symfony/security-core/Resources/translations/security.gl.xlf8  yKAh8  Ϗ      C   vendor/symfony/security-core/Resources/translations/security.es.xlfQ  yKAhQ  cP)      C   vendor/symfony/security-core/Resources/translations/security.hu.xlf:  yKAh:  KY      C   vendor/symfony/security-core/Resources/translations/security.da.xlf  yKAh  mm      C   vendor/symfony/security-core/Resources/translations/security.fi.xlf  yKAh   T      C   vendor/symfony/security-core/Resources/translations/security.id.xlf  yKAh  x"      C   vendor/symfony/security-core/Resources/translations/security.sk.xlf  yKAh  ^P      C   vendor/symfony/security-core/Resources/translations/security.ro.xlfy  yKAhy  Aze      J   vendor/symfony/security-core/User/AttributesBasedUserProviderInterface.phpN  yKAhN  u      .   vendor/symfony/security-core/User/OidcUser.php  yKAh        9   vendor/symfony/security-core/User/InMemoryUserChecker.php  yKAh  l      3   vendor/symfony/security-core/User/UserInterface.php<  yKAh<  l      ;   vendor/symfony/security-core/User/UserProviderInterface.phpI	  yKAhI	  ̤      9   vendor/symfony/security-core/User/MissingUserProvider.php  yKAh  E      6   vendor/symfony/security-core/User/ChainUserChecker.phpd  yKAhd  OϤ      N   vendor/symfony/security-core/User/LegacyPasswordAuthenticatedUserInterface.php1  yKAh1  ,      ?   vendor/symfony/security-core/User/PasswordUpgraderInterface.php  yKAh  }m      2   vendor/symfony/security-core/User/InMemoryUser.phpX  yKAhX  H      :   vendor/symfony/security-core/User/InMemoryUserProvider.php  yKAh  ,aR      8   vendor/symfony/security-core/User/EquatableInterface.phpm  yKAhm  C      H   vendor/symfony/security-core/User/PasswordAuthenticatedUserInterface.php  yKAh  hΤ      :   vendor/symfony/security-core/User/UserCheckerInterface.phpb  yKAhb  P      7   vendor/symfony/security-core/User/ChainUserProvider.php	  yKAh	         &   vendor/symfony/security-core/README.md  yKAh  {u!      L   vendor/symfony/security-core/Authorization/AuthorizationCheckerInterface.php2  yKAh2  O      I   vendor/symfony/security-core/Authorization/ExpressionLanguageProvider.phpV  yKAhV  @)5      M   vendor/symfony/security-core/Authorization/TraceableAccessDecisionManager.php
  yKAh
  T(      D   vendor/symfony/security-core/Authorization/AccessDecisionManager.phpl  yKAhl  0ո      M   vendor/symfony/security-core/Authorization/AccessDecisionManagerInterface.php}  yKAh}  ,t      C   vendor/symfony/security-core/Authorization/Voter/VoterInterface.php  yKAh  ])      L   vendor/symfony/security-core/Authorization/Voter/CacheableVoterInterface.php~  yKAh~  9      D   vendor/symfony/security-core/Authorization/Voter/ExpressionVoter.php3
  yKAh3
        G   vendor/symfony/security-core/Authorization/Voter/RoleHierarchyVoter.phpl  yKAhl  H??      C   vendor/symfony/security-core/Authorization/Voter/TraceableVoter.php)  yKAh)  'J      :   vendor/symfony/security-core/Authorization/Voter/Voter.phpf  yKAhf  5~      >   vendor/symfony/security-core/Authorization/Voter/RoleVoter.php  yKAh  Pj^      G   vendor/symfony/security-core/Authorization/Voter/AuthenticatedVoter.phpC  yKAhC  A      A   vendor/symfony/security-core/Authorization/ExpressionLanguage.php  yKAh  8Cy      C   vendor/symfony/security-core/Authorization/AuthorizationChecker.php  yKAh  w      H   vendor/symfony/security-core/Authorization/Strategy/PriorityStrategy.php  yKAh   7^      I   vendor/symfony/security-core/Authorization/Strategy/UnanimousStrategy.php/  yKAh/        K   vendor/symfony/security-core/Authorization/Strategy/AffirmativeStrategy.php  yKAh  
م      I   vendor/symfony/security-core/Authorization/Strategy/ConsensusStrategy.php  yKAh  դ      W   vendor/symfony/security-core/Authorization/Strategy/AccessDecisionStrategyInterface.php]  yKAh]  pf      )   vendor/symfony/security-core/Security.php
	  yKAh
	        @   vendor/symfony/security-core/Exception/AccessDeniedException.phpZ  yKAhZ  pth      D   vendor/symfony/security-core/Exception/InvalidCsrfTokenException.php}  yKAh}  O      :   vendor/symfony/security-core/Exception/LogoutException.php  yKAh  y'פ      9   vendor/symfony/security-core/Exception/LogicException.php  yKAh  $2      @   vendor/symfony/security-core/Exception/LazyResponseException.php  yKAh  .'      S   vendor/symfony/security-core/Exception/CustomUserMessageAuthenticationException.php	  yKAh	  qHV      =   vendor/symfony/security-core/Exception/ExceptionInterface.php  yKAh  ^      B   vendor/symfony/security-core/Exception/BadCredentialsException.php  yKAh  h	      ;   vendor/symfony/security-core/Exception/RuntimeException.php  yKAh  >
      <   vendor/symfony/security-core/Exception/DisabledException.phpv  yKAhv  Ϥֽ      A   vendor/symfony/security-core/Exception/TokenNotFoundException.php  yKAh  (      D   vendor/symfony/security-core/Exception/ProviderNotFoundException.php  yKAh  R      F   vendor/symfony/security-core/Exception/SessionUnavailableException.phpz  yKAhz  {Y      C   vendor/symfony/security-core/Exception/InvalidArgumentException.php  yKAh  W.      B   vendor/symfony/security-core/Exception/AccountExpiredException.php  yKAh  O
      I   vendor/symfony/security-core/Exception/AuthenticationExpiredException.phpG  yKAhG  %.D      V   vendor/symfony/security-core/Exception/TooManyLoginAttemptsAuthenticationException.php}  yKAh}  j      ?   vendor/symfony/security-core/Exception/CookieTheftException.php  yKAh  m	      I   vendor/symfony/security-core/Exception/AuthenticationServiceException.php  yKAh  t%      C   vendor/symfony/security-core/Exception/UnsupportedUserException.phpJ  yKAhJ  jۤ      A   vendor/symfony/security-core/Exception/AccountStatusException.php  yKAh  c%      R   vendor/symfony/security-core/Exception/CustomUserMessageAccountStatusException.php  yKAh  *
      N   vendor/symfony/security-core/Exception/InsufficientAuthenticationException.php&  yKAh&  [d      :   vendor/symfony/security-core/Exception/LockedException.phpl  yKAhl  0믤      B   vendor/symfony/security-core/Exception/AuthenticationException.php+  yKAh+  l      @   vendor/symfony/security-core/Exception/UserNotFoundException.php@  yKAh@  򼓤      U   vendor/symfony/security-core/Exception/AuthenticationCredentialsNotFoundException.php  yKAh  bb      F   vendor/symfony/security-core/Exception/CredentialsExpiredException.php  yKAh  8h      C   vendor/symfony/security-core/Authentication/Token/AbstractToken.phpb  yKAhb  ߤ7	      ?   vendor/symfony/security-core/Authentication/Token/NullToken.php   yKAh   iƤ      W   vendor/symfony/security-core/Authentication/Token/Storage/UsageTrackingTokenStorage.php	  yKAh	  l	      J   vendor/symfony/security-core/Authentication/Token/Storage/TokenStorage.php4  yKAh4  g      S   vendor/symfony/security-core/Authentication/Token/Storage/TokenStorageInterface.php  yKAh  %N      E   vendor/symfony/security-core/Authentication/Token/RememberMeToken.php  yKAh  
5Lq      E   vendor/symfony/security-core/Authentication/Token/SwitchUserToken.phpm  yKAhm  8      K   vendor/symfony/security-core/Authentication/Token/PreAuthenticatedToken.php  yKAh  .      D   vendor/symfony/security-core/Authentication/Token/TokenInterface.php1	  yKAh1	  =N*ݤ      K   vendor/symfony/security-core/Authentication/Token/UsernamePasswordToken.php  yKAh  z      T   vendor/symfony/security-core/Authentication/AuthenticationTrustResolverInterface.php`  yKAh`  J      K   vendor/symfony/security-core/Authentication/AuthenticationTrustResolver.phpw  yKAhw  4
      S   vendor/symfony/security-core/Authentication/RememberMe/PersistentTokenInterface.php  yKAh        P   vendor/symfony/security-core/Authentication/RememberMe/InMemoryTokenProvider.php'  yKAh'  =      M   vendor/symfony/security-core/Authentication/RememberMe/CacheTokenVerifier.php	  yKAh	  -Lu      J   vendor/symfony/security-core/Authentication/RememberMe/PersistentToken.php  yKAh  Ij       Q   vendor/symfony/security-core/Authentication/RememberMe/TokenVerifierInterface.php  yKAh  Ҥ      Q   vendor/symfony/security-core/Authentication/RememberMe/TokenProviderInterface.php  yKAh  ܪ      A   vendor/symfony/security-core/Event/AuthenticationSuccessEvent.phpu  yKAhu        :   vendor/symfony/security-core/Event/AuthenticationEvent.php  yKAh  :7x      0   vendor/symfony/security-core/Event/VoteEvent.php-  yKAh-        *   vendor/symfony/security-core/composer.json  yKAh  x4      5   vendor/symfony/security-core/AuthenticationEvents.php  yKAh  "a䚤      ,   vendor/symfony/deprecation-contracts/LICENSE,  yKAh,  K      1   vendor/symfony/deprecation-contracts/CHANGELOG.md   yKAh   h{#      1   vendor/symfony/deprecation-contracts/function.php  yKAh  Oݤ      .   vendor/symfony/deprecation-contracts/README.md  yKAh  X      2   vendor/symfony/deprecation-contracts/composer.jsonS  yKAhS  No      (   vendor/symfony/routing/CompiledRoute.php6  yKAh6  k栤      *   vendor/symfony/routing/Attribute/Route.php  yKAh  MT|         vendor/symfony/routing/LICENSE,  yKAh,  U      (   vendor/symfony/routing/RouteCompiler.php8  yKAh8  u      #   vendor/symfony/routing/CHANGELOG.md6  yKAh6  V^      )   vendor/symfony/routing/RequestContext.php`  yKAh`  )-ͤ      +   vendor/symfony/routing/Annotation/Route.php  yKAh  m\      :   vendor/symfony/routing/Matcher/RequestMatcherInterface.php+  yKAh+  <      =   vendor/symfony/routing/Matcher/ExpressionLanguageProvider.php  yKAh  ~      -   vendor/symfony/routing/Matcher/UrlMatcher.php'  yKAh'  #Ф      B   vendor/symfony/routing/Matcher/RedirectableUrlMatcherInterface.phpo  yKAho  0
H      6   vendor/symfony/routing/Matcher/UrlMatcherInterface.php  yKAh  P-2Ȥ      5   vendor/symfony/routing/Matcher/CompiledUrlMatcher.php  yKAh  *g      6   vendor/symfony/routing/Matcher/TraceableUrlMatcher.phpJ  yKAhJ  @      B   vendor/symfony/routing/Matcher/Dumper/CompiledUrlMatcherDumper.phpJ  yKAhJ   3I      7   vendor/symfony/routing/Matcher/Dumper/MatcherDumper.php  yKAh  \Pܤ      @   vendor/symfony/routing/Matcher/Dumper/MatcherDumperInterface.phpg  yKAhg  xI{$      A   vendor/symfony/routing/Matcher/Dumper/CompiledUrlMatcherTrait.php  yKAh  kR      @   vendor/symfony/routing/Matcher/Dumper/StaticPrefixCollection.php  yKAh  ˥      9   vendor/symfony/routing/Matcher/RedirectableUrlMatcher.php<  yKAh<  ðKʤ          vendor/symfony/routing/README.md  yKAh  rɤ      9   vendor/symfony/routing/Generator/CompiledUrlGenerator.php
  yKAh
  XA~      1   vendor/symfony/routing/Generator/UrlGenerator.php;  yKAh;  Yn'      F   vendor/symfony/routing/Generator/ConfigurableRequirementsInterface.php  yKAh  dfФ      :   vendor/symfony/routing/Generator/UrlGeneratorInterface.php
  yKAh
  Y3
8      D   vendor/symfony/routing/Generator/Dumper/GeneratorDumperInterface.phpi  yKAhi  fE      F   vendor/symfony/routing/Generator/Dumper/CompiledUrlGeneratorDumper.php  yKAh        ;   vendor/symfony/routing/Generator/Dumper/GeneratorDumper.php$  yKAh$  αh      *   vendor/symfony/routing/RouteCollection.phpO+  yKAhO+  u      6   vendor/symfony/routing/Requirement/EnumRequirement.php  yKAh        2   vendor/symfony/routing/Requirement/Requirement.phpR  yKAhR  1$      7   vendor/symfony/routing/RequestContextAwareInterface.php6  yKAh6  t      7   vendor/symfony/routing/Loader/AnnotationClassLoader.php  yKAh  tD0      :   vendor/symfony/routing/Loader/AttributeDirectoryLoader.php  yKAh  Tst      5   vendor/symfony/routing/Loader/AttributeFileLoader.php  yKAh  MKI      0   vendor/symfony/routing/Loader/YamlFileLoader.php/  yKAh/  14%      6   vendor/symfony/routing/Loader/AnnotationFileLoader.php  yKAh        <   vendor/symfony/routing/Loader/schema/routing/routing-1.0.xsd9  yKAh9  *#      /   vendor/symfony/routing/Loader/PhpFileLoader.php  yKAh  @      5   vendor/symfony/routing/Loader/Psr4DirectoryLoader.php  yKAh  *>      /   vendor/symfony/routing/Loader/XmlFileLoader.phpF  yKAhF  =k      .   vendor/symfony/routing/Loader/ObjectLoader.phpq  yKAhq  !v|      ?   vendor/symfony/routing/Loader/Configurator/Traits/HostTrait.php!  yKAh!        A   vendor/symfony/routing/Loader/Configurator/Traits/PrefixTrait.php
  yKAh
  (      I   vendor/symfony/routing/Loader/Configurator/Traits/LocalizedRouteTrait.php3
  yKAh3
  }2       @   vendor/symfony/routing/Loader/Configurator/Traits/RouteTrait.php9  yKAh9  ,s      >   vendor/symfony/routing/Loader/Configurator/Traits/AddTrait.phpS  yKAhS  Ӥ      @   vendor/symfony/routing/Loader/Configurator/RouteConfigurator.php  yKAh  {      E   vendor/symfony/routing/Loader/Configurator/CollectionConfigurator.php  yKAh  ֠P      @   vendor/symfony/routing/Loader/Configurator/AliasConfigurator.php  yKAh        B   vendor/symfony/routing/Loader/Configurator/RoutingConfigurator.php  yKAh  a      A   vendor/symfony/routing/Loader/Configurator/ImportConfigurator.php  yKAh  O      6   vendor/symfony/routing/Loader/AttributeClassLoader.php>  yKAh>  K      1   vendor/symfony/routing/Loader/ContainerLoader.php  yKAh  :      1   vendor/symfony/routing/Loader/DirectoryLoader.php  yKAh  ]/      0   vendor/symfony/routing/Loader/GlobFileLoader.php  yKAh  .]      /   vendor/symfony/routing/Loader/ClosureLoader.php  yKAh  
       ;   vendor/symfony/routing/Loader/AnnotationDirectoryLoader.php  yKAh  7
h          vendor/symfony/routing/Route.php/  yKAh/  _      *   vendor/symfony/routing/RouterInterface.php"  yKAh"  WF      !   vendor/symfony/routing/Router.phpt/  yKAht/  -X      1   vendor/symfony/routing/RouteCompilerInterface.php  yKAh  T          vendor/symfony/routing/Alias.php	  yKAh	  ä      Q   vendor/symfony/routing/DependencyInjection/AddExpressionLanguageProvidersPass.php  yKAh  Tw      B   vendor/symfony/routing/DependencyInjection/RoutingResolverPass.php"  yKAh"  K˶      >   vendor/symfony/routing/Exception/ResourceNotFoundException.php2  yKAh2  FL"1      7   vendor/symfony/routing/Exception/ExceptionInterface.php  yKAh  &      ;   vendor/symfony/routing/Exception/RouteNotFoundException.php  yKAh  	C      5   vendor/symfony/routing/Exception/RuntimeException.php  yKAh  $>G      H   vendor/symfony/routing/Exception/MissingMandatoryParametersException.phpC  yKAhC  jYKФ      =   vendor/symfony/routing/Exception/InvalidArgumentException.php  yKAh  ֤      >   vendor/symfony/routing/Exception/MethodNotAllowedException.phpp  yKAhp  .ִ      =   vendor/symfony/routing/Exception/NoConfigurationException.php  yKAh  r      D   vendor/symfony/routing/Exception/RouteCircularReferenceException.php>  yKAh>  \T      >   vendor/symfony/routing/Exception/InvalidParameterException.php  yKAh  !N      $   vendor/symfony/routing/composer.jsony  yKAhy  P      ?   vendor/symfony/service-contracts/ServiceSubscriberInterface.php
  yKAh
  }uP      ?   vendor/symfony/service-contracts/ServiceCollectionInterface.php  yKAh  }V      @   vendor/symfony/service-contracts/Attribute/SubscribedService.php  yKAh  i      7   vendor/symfony/service-contracts/Attribute/Required.php  yKAh  `e      (   vendor/symfony/service-contracts/LICENSE,  yKAh,        @   vendor/symfony/service-contracts/Test/ServiceLocatorTestCase.phpI  yKAhI  RisY      <   vendor/symfony/service-contracts/Test/ServiceLocatorTest.php  yKAh  ]1C      -   vendor/symfony/service-contracts/CHANGELOG.md   yKAh   h{#      *   vendor/symfony/service-contracts/README.mdJ  yKAhJ  Г      3   vendor/symfony/service-contracts/ResetInterface.php  yKAh  B4      =   vendor/symfony/service-contracts/ServiceProviderInterface.php  yKAh  B쯇      ;   vendor/symfony/service-contracts/ServiceSubscriberTrait.php(
  yKAh(
        B   vendor/symfony/service-contracts/ServiceMethodsSubscriberTrait.php>  yKAh>  ۳N      8   vendor/symfony/service-contracts/ServiceLocatorTrait.phpG  yKAhG  m:      .   vendor/symfony/service-contracts/composer.json  yKAh  0_      9   vendor/symfony/property-info/PhpStan/NameScopeFactory.php  yKAh  r      2   vendor/symfony/property-info/PhpStan/NameScope.php  yKAh  d)ݤ      ?   vendor/symfony/property-info/PropertyInfoExtractorInterface.php  yKAh  U-R      %   vendor/symfony/property-info/Type.php  yKAh  1ɤ      $   vendor/symfony/property-info/LICENSE,  yKAh,  H      6   vendor/symfony/property-info/Util/PhpDocTypeHelper.php  yKAh  0Ƥ      7   vendor/symfony/property-info/Util/PhpStanTypeHelper.php#  yKAh#  >       )   vendor/symfony/property-info/CHANGELOG.md  yKAh  .      ;   vendor/symfony/property-info/PropertyInfoCacheExtractor.phpE  yKAhE  ؍      D   vendor/symfony/property-info/PropertyWriteInfoExtractorInterface.php  yKAh  xBy\      A   vendor/symfony/property-info/PropertyAccessExtractorInterface.php  yKAh  2$C      ?   vendor/symfony/property-info/PropertyTypeExtractorInterface.phpQ  yKAhQ        1   vendor/symfony/property-info/PropertyReadInfo.php  yKAh  
      ;   vendor/symfony/property-info/Extractor/PhpStanExtractor.php.  yKAh.  G      >   vendor/symfony/property-info/Extractor/SerializerExtractor.php  yKAh        ?   vendor/symfony/property-info/Extractor/ConstructorExtractor.php  yKAh  -U      T   vendor/symfony/property-info/Extractor/ConstructorArgumentTypeExtractorInterface.php  yKAh  jv\      >   vendor/symfony/property-info/Extractor/ReflectionExtractor.php  yKAh        :   vendor/symfony/property-info/Extractor/PhpDocExtractor.php&0  yKAh&0  dd      F   vendor/symfony/property-info/PropertyDescriptionExtractorInterface.php   yKAh   
8      2   vendor/symfony/property-info/PropertyWriteInfo.php  yKAh  C      &   vendor/symfony/property-info/README.md  yKAh  '7      C   vendor/symfony/property-info/PropertyReadInfoExtractorInterface.php  yKAh  :|`դ      H   vendor/symfony/property-info/PropertyInitializableExtractorInterface.php  yKAh  OW      6   vendor/symfony/property-info/PropertyInfoExtractor.php  yKAh  yh      ?   vendor/symfony/property-info/PropertyListExtractorInterface.php  yKAh  J$      P   vendor/symfony/property-info/DependencyInjection/PropertyInfoConstructorPass.phpY  yKAhY  [c      E   vendor/symfony/property-info/DependencyInjection/PropertyInfoPass.php)  yKAh)         *   vendor/symfony/property-info/composer.json  yKAh  j      3   vendor/symfony/http-foundation/StreamedResponse.php  yKAh  <      :   vendor/symfony/http-foundation/RequestMatcherInterface.php|  yKAh|  3Q      5   vendor/symfony/http-foundation/BinaryFileResponse.php2  yKAh2  y      +   vendor/symfony/http-foundation/InputBag.php7  yKAh7  sĤ      I   vendor/symfony/http-foundation/RateLimiter/AbstractRequestRateLimiter.php	  yKAh	  -3      J   vendor/symfony/http-foundation/RateLimiter/RequestRateLimiterInterface.php
  yKAh
  ¤      R   vendor/symfony/http-foundation/RateLimiter/PeekableRequestRateLimiterInterface.php  yKAh  U      &   vendor/symfony/http-foundation/LICENSE,  yKAh,  U      J   vendor/symfony/http-foundation/Test/Constraint/ResponseCookieValueSame.phpL  yKAhL  f_      D   vendor/symfony/http-foundation/Test/Constraint/ResponseHasCookie.phpJ  yKAhJ  Z^      M   vendor/symfony/http-foundation/Test/Constraint/ResponseHeaderLocationSame.php  yKAh  U      I   vendor/symfony/http-foundation/Test/Constraint/ResponseStatusCodeSame.php  yKAh  I[x`      G   vendor/symfony/http-foundation/Test/Constraint/ResponseIsSuccessful.php.  yKAh.  P      J   vendor/symfony/http-foundation/Test/Constraint/ResponseIsUnprocessable.phpE  yKAhE  K¤      G   vendor/symfony/http-foundation/Test/Constraint/ResponseIsRedirected.php,  yKAh,        D   vendor/symfony/http-foundation/Test/Constraint/ResponseHasHeader.php<  yKAh<  &      L   vendor/symfony/http-foundation/Test/Constraint/RequestAttributeValueSame.php  yKAh  '`7      E   vendor/symfony/http-foundation/Test/Constraint/ResponseFormatSame.php  yKAh  ^)      E   vendor/symfony/http-foundation/Test/Constraint/ResponseHeaderSame.php  yKAh  <پJ      ,   vendor/symfony/http-foundation/ServerBag.php  yKAh        +   vendor/symfony/http-foundation/CHANGELOG.mduL  yKAhuL  M      ,   vendor/symfony/http-foundation/File/File.php  yKAh  ޯԤ      .   vendor/symfony/http-foundation/File/Stream.php  yKAh  x      4   vendor/symfony/http-foundation/File/UploadedFile.php^'  yKAh^'  b[      G   vendor/symfony/http-foundation/File/Exception/AccessDeniedException.phpi  yKAhi  Y      A   vendor/symfony/http-foundation/File/Exception/NoFileException.php  yKAh  -A      F   vendor/symfony/http-foundation/File/Exception/IniSizeFileException.php  yKAh  I      J   vendor/symfony/http-foundation/File/Exception/CannotWriteFileException.php  yKAh  :ݤ      H   vendor/symfony/http-foundation/File/Exception/ExtensionFileException.php  yKAh  )      ?   vendor/symfony/http-foundation/File/Exception/FileException.php  yKAh  j2      A   vendor/symfony/http-foundation/File/Exception/UploadException.php  yKAh  S      I   vendor/symfony/http-foundation/File/Exception/UnexpectedTypeException.php9  yKAh9  d-      G   vendor/symfony/http-foundation/File/Exception/FormSizeFileException.php  yKAh  m;      G   vendor/symfony/http-foundation/File/Exception/FileNotFoundException.phpY  yKAhY  {WɈ      F   vendor/symfony/http-foundation/File/Exception/PartialFileException.php  yKAh  *      G   vendor/symfony/http-foundation/File/Exception/NoTmpDirFileException.php  yKAh  n      +   vendor/symfony/http-foundation/Response.php  yKAh  u      )   vendor/symfony/http-foundation/Cookie.phpJ/  yKAhJ/  "f      /   vendor/symfony/http-foundation/AcceptHeader.php{
  yKAh{
  G      1   vendor/symfony/http-foundation/RequestMatcher.php  yKAh  յnҤ      4   vendor/symfony/http-foundation/ResponseHeaderBag.php  yKAh  4֭      .   vendor/symfony/http-foundation/HeaderUtils.php$  yKAh$  4      F   vendor/symfony/http-foundation/RequestMatcher/MethodRequestMatcher.php>  yKAh>        D   vendor/symfony/http-foundation/RequestMatcher/PathRequestMatcher.phpd  yKAhd  w|      F   vendor/symfony/http-foundation/RequestMatcher/IsJsonRequestMatcher.php  yKAh  TK      D   vendor/symfony/http-foundation/RequestMatcher/PortRequestMatcher.php  yKAh  2      D   vendor/symfony/http-foundation/RequestMatcher/HostRequestMatcher.phpR  yKAhR  s      J   vendor/symfony/http-foundation/RequestMatcher/AttributesRequestMatcher.php  yKAh  d      J   vendor/symfony/http-foundation/RequestMatcher/ExpressionRequestMatcher.php  yKAh  Q̤      F   vendor/symfony/http-foundation/RequestMatcher/SchemeRequestMatcher.php,  yKAh,  s>M      C   vendor/symfony/http-foundation/RequestMatcher/IpsRequestMatcher.php2  yKAh2  ti      /   vendor/symfony/http-foundation/RequestStack.php  yKAh   J      3   vendor/symfony/http-foundation/RedirectResponse.php9
  yKAh9
  V      /   vendor/symfony/http-foundation/JsonResponse.phpj  yKAhj  OP/      (   vendor/symfony/http-foundation/README.md  yKAh  &      *   vendor/symfony/http-foundation/Request.php yKAh BFF      ;   vendor/symfony/http-foundation/ExpressionRequestMatcher.php  yKAh  |*      /   vendor/symfony/http-foundation/ParameterBag.php  yKAh  6      *   vendor/symfony/http-foundation/IpUtils.php   yKAh   Rz^      3   vendor/symfony/http-foundation/AcceptHeaderItem.php  yKAh  :6      7   vendor/symfony/http-foundation/StreamedJsonResponse.php  yKAh  ؕSҤ      ,   vendor/symfony/http-foundation/UrlHelper.phpq  yKAhq  `Kl      6   vendor/symfony/http-foundation/ChainRequestMatcher.phpx  yKAhx  X!      ,   vendor/symfony/http-foundation/HeaderBag.php  yKAh  ZdL      *   vendor/symfony/http-foundation/FileBag.php  yKAh  "4Ϥ      H   vendor/symfony/http-foundation/Exception/ConflictingHeadersException.php  yKAh  ,Ň      E   vendor/symfony/http-foundation/Exception/UnexpectedValueException.phpx  yKAhx   ȕ      F   vendor/symfony/http-foundation/Exception/RequestExceptionInterface.php  yKAh  R      @   vendor/symfony/http-foundation/Exception/BadRequestException.php  yKAh  Uڤ      I   vendor/symfony/http-foundation/Exception/SuspiciousOperationException.php  yKAh  '      :   vendor/symfony/http-foundation/Exception/JsonException.php  yKAh        E   vendor/symfony/http-foundation/Exception/SessionNotFoundException.phpY  yKAhY  1      ,   vendor/symfony/http-foundation/composer.jsonv  yKAhv  ^D      ,   vendor/symfony/http-foundation/UriSigner.php!
  yKAh!
         J   vendor/symfony/http-foundation/Session/Attribute/AttributeBagInterface.php  yKAh  Gf=      A   vendor/symfony/http-foundation/Session/Attribute/AttributeBag.php
  yKAh
        H   vendor/symfony/http-foundation/Session/FlashBagAwareSessionInterface.php4  yKAh4        B   vendor/symfony/http-foundation/Session/SessionFactoryInterface.php  yKAh  f*      2   vendor/symfony/http-foundation/Session/Session.php  yKAh  <)      7   vendor/symfony/http-foundation/Session/SessionUtils.php  yKAh  '      M   vendor/symfony/http-foundation/Session/Storage/Handler/NullSessionHandler.php  yKAh  r@      Q   vendor/symfony/http-foundation/Session/Storage/Handler/AbstractSessionHandler.php  yKAh  դ      P   vendor/symfony/http-foundation/Session/Storage/Handler/SessionHandlerFactory.php)  yKAh)  o      L   vendor/symfony/http-foundation/Session/Storage/Handler/PdoSessionHandler.php  yKAh  AS      T   vendor/symfony/http-foundation/Session/Storage/Handler/MarshallingSessionHandler.php~  yKAh~  |%      S   vendor/symfony/http-foundation/Session/Storage/Handler/NativeFileSessionHandler.php  yKAh  wb      R   vendor/symfony/http-foundation/Session/Storage/Handler/MigratingSessionHandler.php  yKAh  Dt|      M   vendor/symfony/http-foundation/Session/Storage/Handler/IdentityMarshaller.php  yKAh  Gҭq      P   vendor/symfony/http-foundation/Session/Storage/Handler/MongoDbSessionHandler.phpG  yKAhG  $      N   vendor/symfony/http-foundation/Session/Storage/Handler/RedisSessionHandler.php  yKAh  G      O   vendor/symfony/http-foundation/Session/Storage/Handler/StrictSessionHandler.php	  yKAh	  mI      R   vendor/symfony/http-foundation/Session/Storage/Handler/MemcachedSessionHandler.php  yKAh  oڤ      G   vendor/symfony/http-foundation/Session/Storage/NativeSessionStorage.php7  yKAh7  w`      J   vendor/symfony/http-foundation/Session/Storage/SessionStorageInterface.php/  yKAh/  {      P   vendor/symfony/http-foundation/Session/Storage/MockFileSessionStorageFactory.php  yKAh  YPZ      L   vendor/symfony/http-foundation/Session/Storage/Proxy/SessionHandlerProxy.phpB	  yKAhB	        F   vendor/symfony/http-foundation/Session/Storage/Proxy/AbstractProxy.php  yKAh  <      N   vendor/symfony/http-foundation/Session/Storage/NativeSessionStorageFactory.php!  yKAh!  	      J   vendor/symfony/http-foundation/Session/Storage/PhpBridgeSessionStorage.php  yKAh  f      Q   vendor/symfony/http-foundation/Session/Storage/SessionStorageFactoryInterface.phpw  yKAhw  ]n      I   vendor/symfony/http-foundation/Session/Storage/MockFileSessionStorage.php  yKAh  *8      Q   vendor/symfony/http-foundation/Session/Storage/PhpBridgeSessionStorageFactory.php  yKAh  ɤ      >   vendor/symfony/http-foundation/Session/Storage/MetadataBag.php
  yKAh
        J   vendor/symfony/http-foundation/Session/Storage/MockArraySessionStorage.php	  yKAh	  Q3U      ;   vendor/symfony/http-foundation/Session/SessionInterface.php  yKAh  OY>      C   vendor/symfony/http-foundation/Session/Flash/AutoExpireFlashBag.php  yKAh  Ԗޤ      B   vendor/symfony/http-foundation/Session/Flash/FlashBagInterface.php  yKAh  u1Ф      9   vendor/symfony/http-foundation/Session/Flash/FlashBag.php	  yKAh	  vɅ      9   vendor/symfony/http-foundation/Session/SessionFactory.phpG  yKAhG  
      :   vendor/symfony/http-foundation/Session/SessionBagProxy.php  yKAh  
      >   vendor/symfony/http-foundation/Session/SessionBagInterface.phpW  yKAhW  #9      ,   vendor/symfony/var-exporter/Instantiator.php	  yKAh	  
      +   vendor/symfony/var-exporter/ProxyHelper.phpJ^  yKAhJ^  :w      #   vendor/symfony/var-exporter/LICENSE,  yKAh,        (   vendor/symfony/var-exporter/CHANGELOG.md  yKAh  t?      (   vendor/symfony/var-exporter/Hydrator.php  yKAh  Lф      8   vendor/symfony/var-exporter/Internal/LazyObjectState.php(  yKAh(  P      ;   vendor/symfony/var-exporter/Internal/LazyObjectRegistry.phpT  yKAhT  x      /   vendor/symfony/var-exporter/Internal/Values.php  yKAh  `ǿ      8   vendor/symfony/var-exporter/Internal/LazyObjectTrait.php)  yKAh)  ;ޣ      1   vendor/symfony/var-exporter/Internal/Hydrator.php(.  yKAh(.  L\-      1   vendor/symfony/var-exporter/Internal/Registry.php@  yKAh@  #      2   vendor/symfony/var-exporter/Internal/Reference.php
  yKAh
  #Jn      1   vendor/symfony/var-exporter/Internal/Exporter.phpUB  yKAhUB  EG      .   vendor/symfony/var-exporter/LazyGhostTrait.php;  yKAh;  Y      %   vendor/symfony/var-exporter/README.md-  yKAh-  "      .   vendor/symfony/var-exporter/LazyProxyTrait.php2  yKAh2  jˤ      +   vendor/symfony/var-exporter/VarExporter.phpR  yKAhR  eH      3   vendor/symfony/var-exporter/LazyObjectInterface.phpa  yKAha  @#      8   vendor/symfony/var-exporter/Exception/LogicException.php  yKAh  -ʤ      <   vendor/symfony/var-exporter/Exception/ExceptionInterface.phpd  yKAhd        @   vendor/symfony/var-exporter/Exception/ClassNotFoundException.php1  yKAh1  w w      F   vendor/symfony/var-exporter/Exception/NotInstantiableTypeException.php>  yKAh>  }      )   vendor/symfony/var-exporter/composer.jsonr  yKAhr  ~j      E   vendor/symfony/error-handler/ErrorEnhancer/ErrorEnhancerInterface.php	  yKAh	  ޺      I   vendor/symfony/error-handler/ErrorEnhancer/ClassNotFoundErrorEnhancer.phpR  yKAhR        M   vendor/symfony/error-handler/ErrorEnhancer/UndefinedFunctionErrorEnhancer.php*  yKAh*  ^z      K   vendor/symfony/error-handler/ErrorEnhancer/UndefinedMethodErrorEnhancer.php  yKAh  1'      $   vendor/symfony/error-handler/LICENSE,  yKAh,  զ_Ϥ      )   vendor/symfony/error-handler/CHANGELOG.md  yKAh  D9      B   vendor/symfony/error-handler/Resources/bin/patch-type-declarations
  yKAh
  d"m      M   vendor/symfony/error-handler/Resources/bin/extract-tentative-return-types.php   yKAh   mE      ?   vendor/symfony/error-handler/Resources/views/exception.html.php/  yKAh/        <   vendor/symfony/error-handler/Resources/views/traces.html.php
  yKAh
  n       A   vendor/symfony/error-handler/Resources/views/traces_text.html.php  yKAh  j+2      :   vendor/symfony/error-handler/Resources/views/logs.html.php)	  yKAh)	  _&      ;   vendor/symfony/error-handler/Resources/views/trace.html.php`  yKAh`  39      ;   vendor/symfony/error-handler/Resources/views/error.html.phpd  yKAhd  x      D   vendor/symfony/error-handler/Resources/views/exception_full.html.php  yKAh  Eޤ      ?   vendor/symfony/error-handler/Resources/assets/css/exception.css	B  yKAh	B  R      D   vendor/symfony/error-handler/Resources/assets/css/exception_full.css
  yKAh
  *bc      ;   vendor/symfony/error-handler/Resources/assets/css/error.css  yKAh  %7      J   vendor/symfony/error-handler/Resources/assets/images/icon-minus-square.svgQ  yKAhQ  p      B   vendor/symfony/error-handler/Resources/assets/images/icon-book.svg  yKAh        E   vendor/symfony/error-handler/Resources/assets/images/icon-support.svgz  yKAhz  S̤      F   vendor/symfony/error-handler/Resources/assets/images/chevron-right.svg  yKAh        J   vendor/symfony/error-handler/Resources/assets/images/symfony-ghost.svg.php   yKAh   9꒤      I   vendor/symfony/error-handler/Resources/assets/images/icon-plus-square.svg  yKAh  U      E   vendor/symfony/error-handler/Resources/assets/images/symfony-logo.svg  yKAh  %0ɤ      B   vendor/symfony/error-handler/Resources/assets/images/icon-copy.svg	  yKAh	  "Ȗ      G   vendor/symfony/error-handler/Resources/assets/images/favicon.png.base64  yKAh  "i^      K   vendor/symfony/error-handler/Resources/assets/images/icon-plus-square-o.svg  yKAh  -      L   vendor/symfony/error-handler/Resources/assets/images/icon-minus-square-o.svg  yKAh  s0      =   vendor/symfony/error-handler/Resources/assets/js/exception.js4  yKAh4  C#      8   vendor/symfony/error-handler/Internal/TentativeTypes.php  yKAh        &   vendor/symfony/error-handler/Debug.phpH  yKAhH  s
ߤ      F   vendor/symfony/error-handler/ErrorRenderer/SerializerErrorRenderer.php
  yKAh
  <      ?   vendor/symfony/error-handler/ErrorRenderer/CliErrorRenderer.php  yKAh  
+2      E   vendor/symfony/error-handler/ErrorRenderer/ErrorRendererInterface.php  yKAh  sۤ      @   vendor/symfony/error-handler/ErrorRenderer/HtmlErrorRenderer.php'^  yKAh'^  ZO      @   vendor/symfony/error-handler/ErrorRenderer/FileLinkFormatter.phpP  yKAhP  Y      &   vendor/symfony/error-handler/README.md=  yKAh=  \      1   vendor/symfony/error-handler/DebugClassLoader.php  yKAh  m_ˤ      0   vendor/symfony/error-handler/BufferingLogger.phpA  yKAhA  Z      -   vendor/symfony/error-handler/ErrorHandler.phpuk  yKAhuk  w)      /   vendor/symfony/error-handler/ThrowableUtils.php{  yKAh{  -F      7   vendor/symfony/error-handler/Error/OutOfMemoryError.php[  yKAh[  N      ;   vendor/symfony/error-handler/Error/UndefinedMethodError.php  yKAh  V[      1   vendor/symfony/error-handler/Error/FatalError.php
  yKAh
  Ff      =   vendor/symfony/error-handler/Error/UndefinedFunctionError.php  yKAh  lnB      9   vendor/symfony/error-handler/Error/ClassNotFoundError.php  yKAh  Ep      ;   vendor/symfony/error-handler/Exception/FlattenException.phpI.  yKAhI.  ޱњ      ?   vendor/symfony/error-handler/Exception/SilencedErrorContext.phpr  yKAhr  +      *   vendor/symfony/error-handler/composer.json  yKAh  ny&      4   vendor/symfony/cache-contracts/CallbackInterface.php]  yKAh]  oW$      0   vendor/symfony/cache-contracts/ItemInterface.php6  yKAh6  #
      &   vendor/symfony/cache-contracts/LICENSE,  yKAh,        +   vendor/symfony/cache-contracts/CHANGELOG.md   yKAh   h{#      1   vendor/symfony/cache-contracts/CacheInterface.php2	  yKAh2	  5      :   vendor/symfony/cache-contracts/NamespacedPoolInterface.php  yKAh  N      (   vendor/symfony/cache-contracts/README.mdF  yKAhF  _      -   vendor/symfony/cache-contracts/CacheTrait.php	  yKAh	  iW      9   vendor/symfony/cache-contracts/TagAwareCacheInterface.php  yKAh  1swc      ,   vendor/symfony/cache-contracts/composer.json  yKAh  /      7   vendor/symfony/dependency-injection/EnvVarProcessor.php2  yKAh2  sF      ;   vendor/symfony/dependency-injection/ContainerAwareTrait.phpO  yKAhO  4rS      B   vendor/symfony/dependency-injection/ExpressionLanguageProvider.php\  yKAh\  lD      1   vendor/symfony/dependency-injection/Container.php6  yKAh6  S      8   vendor/symfony/dependency-injection/ReverseContainer.php	  yKAh	  4)Ȥ      0   vendor/symfony/dependency-injection/Variable.php  yKAh  hp      P   vendor/symfony/dependency-injection/Extension/ConfigurableExtensionInterface.php#  yKAh#  ᅋ~      D   vendor/symfony/dependency-injection/Extension/ExtensionInterface.php`  yKAh`  ^
N      C   vendor/symfony/dependency-injection/Extension/AbstractExtension.php  yKAh  W$      @   vendor/symfony/dependency-injection/Extension/ExtensionTrait.php  yKAh  V      ;   vendor/symfony/dependency-injection/Extension/Extension.php  yKAh  0B      K   vendor/symfony/dependency-injection/Extension/PrependExtensionInterface.phpS  yKAhS  NC6      Q   vendor/symfony/dependency-injection/Extension/ConfigurationExtensionInterface.phpS  yKAhS  )      ?   vendor/symfony/dependency-injection/Attribute/Autoconfigure.php  yKAh  ZӤ      B   vendor/symfony/dependency-injection/Attribute/AutowireIterator.php  yKAh  o      =   vendor/symfony/dependency-injection/Attribute/AsDecorator.phpo  yKAho  Y|      H   vendor/symfony/dependency-injection/Attribute/AutowireServiceClosure.php  yKAh  ^#5      >   vendor/symfony/dependency-injection/Attribute/AsTaggedItem.php  yKAh  k      8   vendor/symfony/dependency-injection/Attribute/Target.php  yKAh  A      6   vendor/symfony/dependency-injection/Attribute/When.php  yKAh  Xˤ      C   vendor/symfony/dependency-injection/Attribute/AutowireDecorated.php  yKAh  +h      @   vendor/symfony/dependency-injection/Attribute/TaggedIterator.php  yKAh  u      A   vendor/symfony/dependency-injection/Attribute/AutowireLocator.phpe
  yKAhe
        B   vendor/symfony/dependency-injection/Attribute/AutowireCallable.phpT  yKAhT  鼎`      :   vendor/symfony/dependency-injection/Attribute/Autowire.php]
  yKAh]
  sO      B   vendor/symfony/dependency-injection/Attribute/AutoconfigureTag.php  yKAh  	       ?   vendor/symfony/dependency-injection/Attribute/TaggedLocator.php  yKAh  鱞      >   vendor/symfony/dependency-injection/Attribute/MapDecorated.phpb  yKAhb  \      9   vendor/symfony/dependency-injection/Attribute/Exclude.php  yKAh  a)      9   vendor/symfony/dependency-injection/Attribute/AsAlias.php  yKAh        +   vendor/symfony/dependency-injection/LICENSE,  yKAh,  U      0   vendor/symfony/dependency-injection/CHANGELOG.mdhI  yKAhhI  Z[      Q   vendor/symfony/dependency-injection/Config/ContainerParametersResourceChecker.php)  yKAh)  }~      J   vendor/symfony/dependency-injection/Config/ContainerParametersResource.php  yKAh  5      J   vendor/symfony/dependency-injection/Argument/ReferenceSetArgumentTrait.php	  yKAh	  /      A   vendor/symfony/dependency-injection/Argument/AbstractArgument.php  yKAh  1i      D   vendor/symfony/dependency-injection/Argument/RewindableGenerator.php  yKAh  s      G   vendor/symfony/dependency-injection/Argument/ServiceLocatorArgument.php  yKAh  /c=      >   vendor/symfony/dependency-injection/Argument/BoundArgument.php  yKAh  >))      A   vendor/symfony/dependency-injection/Argument/IteratorArgument.php6  yKAh6  2Ҥ      <   vendor/symfony/dependency-injection/Argument/LazyClosure.php_
  yKAh_
  a5Ѥ      G   vendor/symfony/dependency-injection/Argument/TaggedIteratorArgument.phpu
  yKAhu
        B   vendor/symfony/dependency-injection/Argument/ArgumentInterface.phpN  yKAhN        ?   vendor/symfony/dependency-injection/Argument/ServiceLocator.php#  yKAh#  ěs@      G   vendor/symfony/dependency-injection/Argument/ServiceClosureArgument.php*  yKAh*  k      8   vendor/symfony/dependency-injection/ContainerBuilder.php  yKAh  AcZ      7   vendor/symfony/dependency-injection/ChildDefinition.phpp
  yKAhp
  /o      1   vendor/symfony/dependency-injection/Reference.php  yKAh  ͯ      J   vendor/symfony/dependency-injection/ParameterBag/ParameterBagInterface.php	  yKAh	  U]      O   vendor/symfony/dependency-injection/ParameterBag/EnvPlaceholderParameterBag.php  yKAh  !      A   vendor/symfony/dependency-injection/ParameterBag/ParameterBag.php$  yKAh$  AҤ      J   vendor/symfony/dependency-injection/ParameterBag/ContainerBagInterface.php  yKAh        A   vendor/symfony/dependency-injection/ParameterBag/ContainerBag.php  yKAh  #O      G   vendor/symfony/dependency-injection/ParameterBag/FrozenParameterBag.php  yKAh  0P      2   vendor/symfony/dependency-injection/Definition.phpP  yKAhP  D      @   vendor/symfony/dependency-injection/EnvVarProcessorInterface.php  yKAh  90      -   vendor/symfony/dependency-injection/README.mdC  yKAhC  <      :   vendor/symfony/dependency-injection/ContainerInterface.phpd	  yKAhd	  ʤ      9   vendor/symfony/dependency-injection/Loader/FileLoader.php<  yKAh<  (٤      =   vendor/symfony/dependency-injection/Loader/YamlFileLoader.php
  yKAh
  Qd2      O   vendor/symfony/dependency-injection/Loader/schema/dic/services/services-1.0.xsdB  yKAhB  o      <   vendor/symfony/dependency-injection/Loader/PhpFileLoader.php!  yKAh!  g      <   vendor/symfony/dependency-injection/Loader/XmlFileLoader.php  yKAh  Bd      <   vendor/symfony/dependency-injection/Loader/IniFileLoader.php  yKAh  j}      P   vendor/symfony/dependency-injection/Loader/Configurator/ServicesConfigurator.php4  yKAh4  g      P   vendor/symfony/dependency-injection/Loader/Configurator/DefaultsConfigurator.php9	  yKAh9	  Ca      Q   vendor/symfony/dependency-injection/Loader/Configurator/ReferenceConfigurator.php  yKAh  w      T   vendor/symfony/dependency-injection/Loader/Configurator/FromCallableConfigurator.php  yKAh  6n      M   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ClassTrait.php1  yKAh1  D      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/CallTrait.phpN  yKAhN  X_^      Q   vendor/symfony/dependency-injection/Loader/Configurator/Traits/SyntheticTrait.php  yKAh  .      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/PropertyTrait.phpl  yKAhl  
s_      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ArgumentTrait.php  yKAh  
      T   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ConfiguratorTrait.php  yKAh  M      N   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ParentTrait.php  yKAh  (      O   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FactoryTrait.phpd  yKAhd  'D      K   vendor/symfony/dependency-injection/Loader/Configurator/Traits/TagTrait.php  yKAh  p       N   vendor/symfony/dependency-injection/Loader/Configurator/Traits/PublicTrait.php  yKAh        P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/DecorateTrait.php{  yKAh{  2Ѥ      U   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AutoconfigureTrait.phpE  yKAhE  ^7      T   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FromCallableTrait.php	  yKAh	  \      Q   vendor/symfony/dependency-injection/Loader/Configurator/Traits/DeprecateTrait.phpb  yKAhb  *'Ѥ      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/BindTrait.php[  yKAh[  Bf      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/LazyTrait.phpD  yKAhD  5R      L   vendor/symfony/dependency-injection/Loader/Configurator/Traits/FileTrait.phpG  yKAhG  F8      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AbstractTrait.php  yKAh  ge      M   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ShareTrait.phpL  yKAhL  b      P   vendor/symfony/dependency-injection/Loader/Configurator/Traits/AutowireTrait.phpM  yKAhM  P      S   vendor/symfony/dependency-injection/Loader/Configurator/Traits/ConstructorTrait.phpU  yKAhU  86$      P   vendor/symfony/dependency-injection/Loader/Configurator/AbstractConfigurator.php  yKAh  ԏ)      X   vendor/symfony/dependency-injection/Loader/Configurator/ClosureReferenceConfigurator.php  yKAh  #y      K   vendor/symfony/dependency-injection/Loader/Configurator/EnvConfigurator.phpj  yKAhj        W   vendor/symfony/dependency-injection/Loader/Configurator/AbstractServiceConfigurator.php  yKAh  fۤ      R   vendor/symfony/dependency-injection/Loader/Configurator/InstanceofConfigurator.php  yKAh  !R      Q   vendor/symfony/dependency-injection/Loader/Configurator/ContainerConfigurator.php  yKAh  4      M   vendor/symfony/dependency-injection/Loader/Configurator/AliasConfigurator.php  yKAh  RF,b      U   vendor/symfony/dependency-injection/Loader/Configurator/InlineServiceConfigurator.phpR  yKAhR  <      Q   vendor/symfony/dependency-injection/Loader/Configurator/PrototypeConfigurator.php
  yKAh
  o      R   vendor/symfony/dependency-injection/Loader/Configurator/ParametersConfigurator.php  yKAh  "      O   vendor/symfony/dependency-injection/Loader/Configurator/ServiceConfigurator.php  yKAh  A[_v      >   vendor/symfony/dependency-injection/Loader/DirectoryLoader.php2  yKAh2  	      =   vendor/symfony/dependency-injection/Loader/GlobFileLoader.php`  yKAh`        <   vendor/symfony/dependency-injection/Loader/ClosureLoader.php  yKAh  5      =   vendor/symfony/dependency-injection/LazyProxy/ProxyHelper.php  yKAh  Ğ}      K   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/DumperInterface.php  yKAh  5=      M   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/LazyServiceDumper.php  yKAh  p<      F   vendor/symfony/dependency-injection/LazyProxy/PhpDumper/NullDumper.php  yKAh  vOΤ      V   vendor/symfony/dependency-injection/LazyProxy/Instantiator/LazyServiceInstantiator.php  yKAh  (d      V   vendor/symfony/dependency-injection/LazyProxy/Instantiator/RealServiceInstantiator.phpd  yKAhd  翓      T   vendor/symfony/dependency-injection/LazyProxy/Instantiator/InstantiatorInterface.php~  yKAh~  0ND      :   vendor/symfony/dependency-injection/ExpressionLanguage.phpb  yKAhb  !UO      6   vendor/symfony/dependency-injection/ServiceLocator.php  yKAh  9x"D      6   vendor/symfony/dependency-injection/TypedReference.php3  yKAh3  adt      -   vendor/symfony/dependency-injection/Alias.php  yKAh  nZԤ      U   vendor/symfony/dependency-injection/Exception/ParameterCircularReferenceException.php  yKAh  t9      @   vendor/symfony/dependency-injection/Exception/LogicException.php  yKAh  }|Ȥ      F   vendor/symfony/dependency-injection/Exception/EnvNotFoundException.php  yKAh  &      L   vendor/symfony/dependency-injection/Exception/ParameterNotFoundException.php"  yKAh"  
      D   vendor/symfony/dependency-injection/Exception/ExceptionInterface.php~  yKAh~        F   vendor/symfony/dependency-injection/Exception/OutOfBoundsException.php  yKAh  On      S   vendor/symfony/dependency-injection/Exception/ServiceCircularReferenceException.php_  yKAh_  Ke&      J   vendor/symfony/dependency-injection/Exception/ServiceNotFoundException.php  yKAh  Ф      B   vendor/symfony/dependency-injection/Exception/RuntimeException.php	  yKAh	  
      J   vendor/symfony/dependency-injection/Exception/InvalidArgumentException.php'  yKAh'        H   vendor/symfony/dependency-injection/Exception/BadMethodCallException.php  yKAh  ,w      K   vendor/symfony/dependency-injection/Exception/AutowiringFailedException.php  yKAh  M      O   vendor/symfony/dependency-injection/Exception/InvalidParameterTypeException.php0  yKAh0  I      G   vendor/symfony/dependency-injection/Exception/EnvParameterException.php  yKAh  =&)      @   vendor/symfony/dependency-injection/TaggedContainerInterface.php  yKAh  J.      1   vendor/symfony/dependency-injection/Parameter.phpf  yKAhf  sD      E   vendor/symfony/dependency-injection/Compiler/DecoratorServicePass.php  yKAh  'f      M   vendor/symfony/dependency-injection/Compiler/ResolveInvalidReferencesPass.php  yKAh  ]      L   vendor/symfony/dependency-injection/Compiler/ValidateEnvPlaceholdersPass.php  yKAh        M   vendor/symfony/dependency-injection/Compiler/RegisterEnvVarProcessorsPass.php@  yKAh@  p脤      T   vendor/symfony/dependency-injection/Compiler/RegisterAutoconfigureAttributesPass.php  yKAh        L   vendor/symfony/dependency-injection/Compiler/CheckDefinitionValidityPass.php!  yKAh!  gPK      ;   vendor/symfony/dependency-injection/Compiler/PassConfig.phpm  yKAhm  1&      F   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraph.php
  yKAh
  j      E   vendor/symfony/dependency-injection/Compiler/ResolveNoPreloadPass.phpK  yKAhK  7ɤ      J   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraphNode.php  yKAh        J   vendor/symfony/dependency-injection/Compiler/CheckTypeDeclarationsPass.php1  yKAh1  W       M   vendor/symfony/dependency-injection/Compiler/InlineServiceDefinitionsPass.php  yKAh        H   vendor/symfony/dependency-injection/Compiler/ResolveFactoryClassPass.php   yKAh   %d      D   vendor/symfony/dependency-injection/Compiler/ResolveBindingsPass.php$*  yKAh$*  
B      H   vendor/symfony/dependency-injection/Compiler/AutowireAsDecoratorPass.php  yKAh  3      K   vendor/symfony/dependency-injection/Compiler/PriorityTaggedServiceTrait.php  yKAh  v3      M   vendor/symfony/dependency-injection/Compiler/RegisterReverseContainerPass.php  yKAh  QY      F   vendor/symfony/dependency-injection/Compiler/AbstractRecursivePass.php8*  yKAh8*  c3      R   vendor/symfony/dependency-injection/Compiler/AliasDeprecatedPublicServicesPass.php  yKAh  Hl      R   vendor/symfony/dependency-injection/Compiler/ResolveInstanceofConditionalsPass.php8  yKAh8  y      O   vendor/symfony/dependency-injection/Compiler/ResolveReferencesToAliasesPass.php  yKAh  cW      K   vendor/symfony/dependency-injection/Compiler/CheckArgumentsValidityPass.php3  yKAh3  췤      O   vendor/symfony/dependency-injection/Compiler/AttributeAutoconfigurationPass.php  yKAh  1x      O   vendor/symfony/dependency-injection/Compiler/AutowireRequiredPropertiesPass.php-
  yKAh-
  zh      J   vendor/symfony/dependency-injection/Compiler/ResolveNamedArgumentsPass.php'  yKAh'  $      I   vendor/symfony/dependency-injection/Compiler/RemovePrivateAliasesPass.php  yKAh  XB      P   vendor/symfony/dependency-injection/Compiler/MergeExtensionConfigurationPass.php!  yKAh!  ?      J   vendor/symfony/dependency-injection/Compiler/ServiceReferenceGraphEdge.phpi  yKAhi  ^n      M   vendor/symfony/dependency-injection/Compiler/DefinitionErrorExceptionPass.php
  yKAh
  B      L   vendor/symfony/dependency-injection/Compiler/RemoveUnusedDefinitionsPass.php  yKAh  xp      =   vendor/symfony/dependency-injection/Compiler/AutowirePass.php8{  yKAh8{  an+      F   vendor/symfony/dependency-injection/Compiler/ServiceLocatorTagPass.php  yKAh  J      R   vendor/symfony/dependency-injection/Compiler/ResolveTaggedIteratorArgumentPass.phpq  yKAhq  ?      K   vendor/symfony/dependency-injection/Compiler/ResolveEnvPlaceholdersPass.php  yKAh  ]      L   vendor/symfony/dependency-injection/Compiler/CheckCircularReferencesPass.php  yKAh  gG      ]   vendor/symfony/dependency-injection/Compiler/CheckExceptionOnInvalidReferenceBehaviorPass.php  yKAh  Lפ      J   vendor/symfony/dependency-injection/Compiler/RemoveBuildParametersPass.php  yKAh  vg      E   vendor/symfony/dependency-injection/Compiler/AutoAliasServicePass.php  yKAh  zp
      Q   vendor/symfony/dependency-injection/Compiler/ResolveParameterPlaceHoldersPass.php  yKAh  F0      A   vendor/symfony/dependency-injection/Compiler/ResolveClassPass.php]  yKAh]  v`      N   vendor/symfony/dependency-injection/Compiler/RemoveAbstractDefinitionsPass.php  yKAh  Q      K   vendor/symfony/dependency-injection/Compiler/CheckReferenceValidityPass.php6  yKAh6  YB      O   vendor/symfony/dependency-injection/Compiler/RegisterServiceSubscribersPass.php  yKAh  a%      C   vendor/symfony/dependency-injection/Compiler/ResolveHotPathPass.php<	  yKAh<	  sY[      J   vendor/symfony/dependency-injection/Compiler/ResolveDecoratorStackPass.php  yKAh  lD      N   vendor/symfony/dependency-injection/Compiler/ResolveServiceSubscribersPass.php  yKAh  ٭v      F   vendor/symfony/dependency-injection/Compiler/CompilerPassInterface.php  yKAh  &      S   vendor/symfony/dependency-injection/Compiler/ReplaceAliasByActualDefinitionPass.phpa  yKAha  p6      L   vendor/symfony/dependency-injection/Compiler/ResolveChildDefinitionsPass.php&  yKAh&  W      9   vendor/symfony/dependency-injection/Compiler/Compiler.php
  yKAh
  ˤ      F   vendor/symfony/dependency-injection/Compiler/ExtensionCompilerPass.php  yKAh        M   vendor/symfony/dependency-injection/Compiler/AnalyzeServiceReferencesPass.php  yKAh  ^0      L   vendor/symfony/dependency-injection/Compiler/AutowireRequiredMethodsPass.php  yKAh  `#{      =   vendor/symfony/dependency-injection/Dumper/GraphvizDumper.php#  yKAh#  sO      9   vendor/symfony/dependency-injection/Dumper/YamlDumper.php"8  yKAh"8  Oˤ      8   vendor/symfony/dependency-injection/Dumper/Preloader.php  yKAh  v{      8   vendor/symfony/dependency-injection/Dumper/XmlDumper.phpH  yKAhH  ]߸      >   vendor/symfony/dependency-injection/Dumper/DumperInterface.phpV  yKAhV  s#      5   vendor/symfony/dependency-injection/Dumper/Dumper.php  yKAh  U;a      8   vendor/symfony/dependency-injection/Dumper/PhpDumper.php yKAh 6      1   vendor/symfony/dependency-injection/composer.json  yKAh  X~      =   vendor/symfony/dependency-injection/EnvVarLoaderInterface.php  yKAh  bkr      ?   vendor/symfony/dependency-injection/ContainerAwareInterface.php  yKAh  =>         vendor/symfony/clock/LICENSE,  yKAh,  t=      1   vendor/symfony/clock/Test/ClockSensitiveTrait.php  yKAh  I      !   vendor/symfony/clock/CHANGELOG.md  yKAh  CJ      &   vendor/symfony/clock/Resources/now.php  yKAh  5䏤      (   vendor/symfony/clock/ClockAwareTrait.php  yKAh  3         vendor/symfony/clock/README.md  yKAh  I      "   vendor/symfony/clock/MockClock.php  yKAh  $i         vendor/symfony/clock/Clock.phpS	  yKAhS	  *R'      '   vendor/symfony/clock/MonotonicClock.php
  yKAh
  }Z      '   vendor/symfony/clock/ClockInterface.phpL  yKAhL  z֚&      "   vendor/symfony/clock/DatePoint.php  yKAh  Ф      "   vendor/symfony/clock/composer.json  yKAh  GPҤ      $   vendor/symfony/clock/NativeClock.php/  yKAh/  ur+      :   vendor/symfony/password-hasher/PasswordHasherInterface.php  yKAh  -<      >   vendor/symfony/password-hasher/Hasher/SodiumPasswordHasher.php  yKAh  ^~      B   vendor/symfony/password-hasher/Hasher/CheckPasswordLengthTrait.php  yKAh  B+.      <   vendor/symfony/password-hasher/Hasher/UserPasswordHasher.phpK  yKAhK  r,Ф      >   vendor/symfony/password-hasher/Hasher/Pbkdf2PasswordHasher.php  yKAh  S8      F   vendor/symfony/password-hasher/Hasher/PasswordHasherAwareInterface.php  yKAh  ϡ*      >   vendor/symfony/password-hasher/Hasher/NativePasswordHasher.php  yKAh  Q      E   vendor/symfony/password-hasher/Hasher/MessageDigestPasswordHasher.php 
  yKAh 
  r6k      E   vendor/symfony/password-hasher/Hasher/UserPasswordHasherInterface.phpr  yKAhr  4Τ      A   vendor/symfony/password-hasher/Hasher/PlaintextPasswordHasher.php[	  yKAh[	        H   vendor/symfony/password-hasher/Hasher/PasswordHasherFactoryInterface.php  yKAh  @      A   vendor/symfony/password-hasher/Hasher/MigratingPasswordHasher.php  yKAh  rG      ?   vendor/symfony/password-hasher/Hasher/PasswordHasherFactory.php&!  yKAh&!  FA      &   vendor/symfony/password-hasher/LICENSE,  yKAh,  U      +   vendor/symfony/password-hasher/CHANGELOG.md   yKAh   ڰ      @   vendor/symfony/password-hasher/LegacyPasswordHasherInterface.php  yKAh  t      (   vendor/symfony/password-hasher/README.md  yKAh  !      B   vendor/symfony/password-hasher/Command/UserPasswordHashCommand.php'  yKAh'  8      ;   vendor/symfony/password-hasher/Exception/LogicException.php  yKAh  A      ?   vendor/symfony/password-hasher/Exception/ExceptionInterface.php  yKAh  EWL      E   vendor/symfony/password-hasher/Exception/InvalidPasswordException.php  yKAh  L      ,   vendor/symfony/password-hasher/composer.json  yKAh           vendor/symfony/process/LICENSE,  yKAh,  U      +   vendor/symfony/process/ExecutableFinder.php
  yKAh
  wt      #   vendor/symfony/process/CHANGELOG.md  yKAh   %8          vendor/symfony/process/README.md  yKAh  \3$Ϥ      *   vendor/symfony/process/Pipes/UnixPipes.php  yKAh  6      -   vendor/symfony/process/Pipes/WindowsPipes.php  yKAh  Q      .   vendor/symfony/process/Pipes/AbstractPipes.php  yKAh  e      /   vendor/symfony/process/Pipes/PipesInterface.php  yKAh        &   vendor/symfony/process/InputStream.php	  yKAh	  6ee      6   vendor/symfony/process/Messenger/RunProcessContext.php|  yKAh|  ɔ      6   vendor/symfony/process/Messenger/RunProcessMessage.php  yKAh  2$      =   vendor/symfony/process/Messenger/RunProcessMessageHandler.php%  yKAh%  0      %   vendor/symfony/process/PhpProcess.php	  yKAh	  3x      (   vendor/symfony/process/PhpSubprocess.php  yKAh  :1      .   vendor/symfony/process/PhpExecutableFinder.php%	  yKAh%	  ޏx      =   vendor/symfony/process/Exception/ProcessSignaledException.php  yKAh  -n_      3   vendor/symfony/process/Exception/LogicException.php  yKAh  iUQ      7   vendor/symfony/process/Exception/ExceptionInterface.php  yKAh  
j%W      ;   vendor/symfony/process/Exception/ProcessFailedException.phpp  yKAhp   ۋ      5   vendor/symfony/process/Exception/RuntimeException.php  yKAh  P      =   vendor/symfony/process/Exception/ProcessTimedOutException.php  yKAh  8^Q      =   vendor/symfony/process/Exception/InvalidArgumentException.php  yKAh  ڴ      >   vendor/symfony/process/Exception/RunProcessFailedException.php  yKAh  ؤ      $   vendor/symfony/process/composer.json  yKAh  S.t      '   vendor/symfony/process/ProcessUtils.php  yKAh  a鍤      "   vendor/symfony/process/Process.php  yKAh  8      =   vendor/symfony/console/DataCollector/CommandDataCollector.php  yKAh  &      (   vendor/symfony/console/ConsoleEvents.php  yKAh  .
      !   vendor/symfony/console/Cursor.php  yKAh  \Fä      &   vendor/symfony/console/Application.php  yKAh  !(      /   vendor/symfony/console/Logger/ConsoleLogger.phpY  yKAhY  Ġ      .   vendor/symfony/console/Attribute/AsCommand.phpJ  yKAhJ  c         vendor/symfony/console/LICENSE,  yKAh,  U      #   vendor/symfony/console/CHANGELOG.md)  yKAh)   b_e      9   vendor/symfony/console/Input/StreamableInputInterface.php  yKAh  3y-      +   vendor/symfony/console/Input/ArrayInput.phpH  yKAhH  ůx      *   vendor/symfony/console/Input/ArgvInput.php0  yKAh0  #      .   vendor/symfony/console/Input/InputArgument.php:  yKAh:  ț      4   vendor/symfony/console/Input/InputAwareInterface.phpc  yKAhc  Q      ,   vendor/symfony/console/Input/InputOption.php!  yKAh!  !1g=      0   vendor/symfony/console/Input/InputDefinition.phpU.  yKAhU.  )ͤ      ,   vendor/symfony/console/Input/StringInput.php
  yKAh
  G      &   vendor/symfony/console/Input/Input.phpl  yKAhl  ;      /   vendor/symfony/console/Input/InputInterface.php|  yKAh|  kx'      #   vendor/symfony/console/Terminal.php  yKAh  `HN      2   vendor/symfony/console/CI/GithubActionReporter.php+  yKAh+  @      0   vendor/symfony/console/Resources/completion.bash  yKAh  %}      4   vendor/symfony/console/Resources/bin/hiddeninput.exe $  yKAh $  v      /   vendor/symfony/console/Resources/completion.zsh  yKAh  ʤ      0   vendor/symfony/console/Resources/completion.fish  yKAh  Keդ      5   vendor/symfony/console/Output/TrimmedBufferOutput.phpY  yKAhY  G>d      8   vendor/symfony/console/Output/ConsoleOutputInterface.php=  yKAh=  B:      0   vendor/symfony/console/Output/BufferedOutput.phpQ  yKAhQ  *AS      1   vendor/symfony/console/Output/OutputInterface.php6  yKAh6  j8q      /   vendor/symfony/console/Output/AnsiColorMode.php
  yKAh
  oi+      (   vendor/symfony/console/Output/Output.php  yKAh  \Τ      6   vendor/symfony/console/Output/ConsoleSectionOutput.php9!  yKAh9!         /   vendor/symfony/console/Output/ConsoleOutput.php  yKAh  :*      ,   vendor/symfony/console/Output/NullOutput.phpO  yKAhO  p       .   vendor/symfony/console/Output/StreamOutput.php  yKAh  +%ؤ      A   vendor/symfony/console/Completion/Output/FishCompletionOutput.php  yKAh  `      A   vendor/symfony/console/Completion/Output/BashCompletionOutput.php	  yKAh	  Q2      F   vendor/symfony/console/Completion/Output/CompletionOutputInterface.php  yKAh  :]      @   vendor/symfony/console/Completion/Output/ZshCompletionOutput.php1  yKAh1        0   vendor/symfony/console/Completion/Suggestion.php7  yKAh7  /)	Ϥ      ;   vendor/symfony/console/Completion/CompletionSuggestions.php^  yKAh^  lx      5   vendor/symfony/console/Completion/CompletionInput.php   yKAh   jfO      ,   vendor/symfony/console/Style/OutputStyle.php  yKAh  Vy      -   vendor/symfony/console/Style/SymfonyStyle.php;  yKAh;  
&ˤ      /   vendor/symfony/console/Style/StyleInterface.php
  yKAh
  .      2   vendor/symfony/console/Question/ChoiceQuestion.php1  yKAh1  JY      ,   vendor/symfony/console/Question/Question.php>  yKAh>  o[դ      8   vendor/symfony/console/Question/ConfirmationQuestion.php,  yKAh,  %          vendor/symfony/console/README.md  yKAh  Æf      9   vendor/symfony/console/Formatter/OutputFormatterStyle.php  yKAh  yM      B   vendor/symfony/console/Formatter/OutputFormatterStyleInterface.php  yKAh  ǡ      =   vendor/symfony/console/Formatter/NullOutputFormatterStyle.phpl  yKAhl        =   vendor/symfony/console/Formatter/OutputFormatterInterface.php"  yKAh"  7V6_      4   vendor/symfony/console/Formatter/OutputFormatter.phpM   yKAhM   =b      8   vendor/symfony/console/Formatter/NullOutputFormatter.php  yKAh  B[      F   vendor/symfony/console/Formatter/WrappableOutputFormatterInterface.php  yKAh  *
      >   vendor/symfony/console/Formatter/OutputFormatterStyleStack.php?
  yKAh?
  :;      6   vendor/symfony/console/Messenger/RunCommandMessage.php  yKAh  
M      6   vendor/symfony/console/Messenger/RunCommandContext.php  yKAh  !B      =   vendor/symfony/console/Messenger/RunCommandMessageHandler.php  yKAh  yzo          vendor/symfony/console/Color.php(  yKAh(  -      8   vendor/symfony/console/SignalRegistry/SignalRegistry.php  yKAh  G,eͤ      3   vendor/symfony/console/SignalRegistry/SignalMap.php  yKAh  N+QѤ      3   vendor/symfony/console/SingleCommandApplication.php>  yKAh>  OA      ?   vendor/symfony/console/CommandLoader/CommandLoaderInterface.phpV  yKAhV  X2      ?   vendor/symfony/console/CommandLoader/ContainerCommandLoader.php  yKAh  ƒ      =   vendor/symfony/console/CommandLoader/FactoryCommandLoader.phpK  yKAhK  <      4   vendor/symfony/console/Descriptor/TextDescriptor.php0  yKAh0  f      <   vendor/symfony/console/Descriptor/ApplicationDescription.php(  yKAh(  #1      3   vendor/symfony/console/Descriptor/XmlDescriptor.php&  yKAh&  ,Eb      9   vendor/symfony/console/Descriptor/DescriptorInterface.phpm  yKAhm  B      0   vendor/symfony/console/Descriptor/Descriptor.php
  yKAh
  j      @   vendor/symfony/console/Descriptor/ReStructuredTextDescriptor.php')  yKAh')  Ǿ4      4   vendor/symfony/console/Descriptor/JsonDescriptor.php%  yKAh%  
֤      8   vendor/symfony/console/Descriptor/MarkdownDescriptor.php  yKAh  4Qj      /   vendor/symfony/console/Tester/CommandTester.phpL	  yKAhL	  5Ykؤ      -   vendor/symfony/console/Tester/TesterTrait.phpr  yKAhr  Ƥ      3   vendor/symfony/console/Tester/ApplicationTester.php
  yKAh
  Z3      9   vendor/symfony/console/Tester/CommandCompletionTester.phpD  yKAhD  T      @   vendor/symfony/console/Tester/Constraint/CommandIsSuccessful.php+  yKAh+  1      3   vendor/symfony/console/Command/TraceableCommand.php](  yKAh](         .   vendor/symfony/console/Command/LazyCommand.php  yKAh  oͤ      0   vendor/symfony/console/Command/LockableTrait.php3  yKAh3        .   vendor/symfony/console/Command/HelpCommand.php	  yKAh	  6_3      2   vendor/symfony/console/Command/CompleteCommand.php#  yKAh#  sJ!      .   vendor/symfony/console/Command/ListCommand.php	  yKAh	  e\{      8   vendor/symfony/console/Command/DumpCompletionCommand.php  yKAh  +CQ      =   vendor/symfony/console/Command/SignalableCommandInterface.phpE  yKAhE  bO      *   vendor/symfony/console/Command/Command.php!Z  yKAh!Z  a 啤      ,   vendor/symfony/console/Helper/TableStyle.php!1  yKAh!1  'p,      +   vendor/symfony/console/Helper/TableRows.php[  yKAh[  {m֤      7   vendor/symfony/console/Helper/SymfonyQuestionHelper.php)
  yKAh)
  7N      1   vendor/symfony/console/Helper/HelperInterface.phpV  yKAhV  ̊      +   vendor/symfony/console/Helper/TableCell.php  yKAh  e9S      /   vendor/symfony/console/Helper/ProcessHelper.php  yKAh  e      0   vendor/symfony/console/Helper/TableSeparator.php!  yKAh!  n2      /   vendor/symfony/console/Helper/OutputWrapper.php  yKAh  lؤ      1   vendor/symfony/console/Helper/FormatterHelper.php  yKAh  0ɤ      0   vendor/symfony/console/Helper/TableCellStyle.php)  yKAh)  KӘ      -   vendor/symfony/console/Helper/ProgressBar.phpKN  yKAhKN  F@{      6   vendor/symfony/console/Helper/DebugFormatterHelper.php

  yKAh

  &      +   vendor/symfony/console/Helper/HelperSet.phpc  yKAhc  V.      (   vendor/symfony/console/Helper/Dumper.phpz  yKAhz  `      2   vendor/symfony/console/Helper/InputAwareHelper.php  yKAh  pc      0   vendor/symfony/console/Helper/QuestionHelper.phpXL  yKAhXL  ʱbܤ      (   vendor/symfony/console/Helper/Helper.php  yKAh  +u      '   vendor/symfony/console/Helper/Table.php6{  yKAh6{  De      3   vendor/symfony/console/Helper/ProgressIndicator.php  yKAh  bN&      2   vendor/symfony/console/Helper/DescriptorHelper.phpd
  yKAhd
        D   vendor/symfony/console/DependencyInjection/AddConsoleCommandPass.php  yKAh  4      3   vendor/symfony/console/Exception/LogicException.php  yKAh  5      ;   vendor/symfony/console/Exception/InvalidOptionException.php  yKAh  %:      >   vendor/symfony/console/Exception/RunCommandFailedException.php>  yKAh>  ~      7   vendor/symfony/console/Exception/ExceptionInterface.php  yKAh  oOȤ      5   vendor/symfony/console/Exception/RuntimeException.php  yKAh        ?   vendor/symfony/console/Exception/NamespaceNotFoundException.php  yKAh  xD      =   vendor/symfony/console/Exception/InvalidArgumentException.php  yKAh  x
Τ      :   vendor/symfony/console/Exception/MissingInputException.php  yKAh  L      =   vendor/symfony/console/Exception/CommandNotFoundException.php  yKAh  ͆Ť      6   vendor/symfony/console/Event/ConsoleTerminateEvent.php  yKAh  [5Ť      2   vendor/symfony/console/Event/ConsoleErrorEvent.php  yKAh  z      4   vendor/symfony/console/Event/ConsoleCommandEvent.php>  yKAh>  y      -   vendor/symfony/console/Event/ConsoleEvent.php  yKAh  8(M      3   vendor/symfony/console/Event/ConsoleSignalEvent.php  yKAh  =|Ѯ      $   vendor/symfony/console/composer.jsonH  yKAhH  +      +   vendor/symfony/console/Debug/CliRequest.phpq  yKAhq  ekX      6   vendor/symfony/console/EventListener/ErrorListener.php  yKAh  h
      0   vendor/symfony/polyfill-mbstring/bootstrap80.php'  yKAh'  	~
      (   vendor/symfony/polyfill-mbstring/LICENSE,  yKAh,  H      B   vendor/symfony/polyfill-mbstring/Resources/unidata/caseFolding.php  yKAh  ]SC      @   vendor/symfony/polyfill-mbstring/Resources/unidata/lowerCase.phpU  yKAhU  D׎      F   vendor/symfony/polyfill-mbstring/Resources/unidata/titleCaseRegexp.php  yKAh  oቤ      @   vendor/symfony/polyfill-mbstring/Resources/unidata/upperCase.phpO[  yKAhO[  (      -   vendor/symfony/polyfill-mbstring/Mbstring.php  yKAh        .   vendor/symfony/polyfill-mbstring/bootstrap.php!  yKAh!  d      *   vendor/symfony/polyfill-mbstring/README.mdr  yKAhr  A`      .   vendor/symfony/polyfill-mbstring/composer.jsonR  yKAhR  `P
      5   vendor/symfony/polyfill-intl-grapheme/bootstrap80.phpg
  yKAhg
  E{      -   vendor/symfony/polyfill-intl-grapheme/LICENSE,  yKAh,  H      2   vendor/symfony/polyfill-intl-grapheme/Grapheme.php&  yKAh&  8      3   vendor/symfony/polyfill-intl-grapheme/bootstrap.php  yKAh        /   vendor/symfony/polyfill-intl-grapheme/README.mdK  yKAhK  C>      3   vendor/symfony/polyfill-intl-grapheme/composer.json   yKAh   +          vendor/ramsey/collection/LICENSE7  yKAh7  ŸԤ      "   vendor/ramsey/collection/README.md  yKAh  3 Ӥ      &   vendor/ramsey/collection/composer.json|  yKAh|   v֤      $   vendor/ramsey/collection/SECURITY.md  yKAh        1   vendor/ramsey/collection/src/DoubleEndedQueue.php  yKAh  e      ,   vendor/ramsey/collection/src/AbstractSet.php  yKAh  <!      /   vendor/ramsey/collection/src/QueueInterface.php  yKAh  *      3   vendor/ramsey/collection/src/AbstractCollection.phpa+  yKAha+  d?      .   vendor/ramsey/collection/src/AbstractArray.php  yKAh  z P      &   vendor/ramsey/collection/src/Queue.php3  yKAh3  D      $   vendor/ramsey/collection/src/Set.php0  yKAh0  H      :   vendor/ramsey/collection/src/DoubleEndedQueueInterface.php(  yKAh(  6'&      6   vendor/ramsey/collection/src/Map/TypedMapInterface.php2  yKAh2  z      5   vendor/ramsey/collection/src/Map/AbstractTypedMap.phpc  yKAhc  cͤ      1   vendor/ramsey/collection/src/Map/MapInterface.php  yKAh  OA      -   vendor/ramsey/collection/src/Map/TypedMap.php
  yKAh
  >)      8   vendor/ramsey/collection/src/Map/AssociativeArrayMap.php0  yKAh0  PǤ      6   vendor/ramsey/collection/src/Map/NamedParameterMap.php   yKAh   `@Q      0   vendor/ramsey/collection/src/Map/AbstractMap.php  yKAh  I?      -   vendor/ramsey/collection/src/GenericArray.php  yKAh        /   vendor/ramsey/collection/src/ArrayInterface.php'  yKAh'  5a      %   vendor/ramsey/collection/src/Sort.php{  yKAh{  Ȥ      +   vendor/ramsey/collection/src/Collection.php	  yKAh	  0       4   vendor/ramsey/collection/src/CollectionInterface.php$  yKAh$  űʤ      H   vendor/ramsey/collection/src/Exception/UnsupportedOperationException.phpL  yKAhL  ff      ?   vendor/ramsey/collection/src/Exception/OutOfBoundsException.phpw  yKAhw        >   vendor/ramsey/collection/src/Exception/CollectionException.php  yKAh  Ĵ@      C   vendor/ramsey/collection/src/Exception/InvalidArgumentException.phps  yKAhs  ڤ      A   vendor/ramsey/collection/src/Exception/NoSuchElementException.phpD  yKAhD  	Ln      B   vendor/ramsey/collection/src/Exception/InvalidPropertyOrMethod.php  yKAh        F   vendor/ramsey/collection/src/Exception/CollectionMismatchException.phpM  yKAhM  \ć      8   vendor/ramsey/collection/src/Tool/ValueToStringTrait.php	  yKAh	  ;5      /   vendor/ramsey/collection/src/Tool/TypeTrait.phpD  yKAhD  e      9   vendor/ramsey/collection/src/Tool/ValueExtractorTrait.php  yKAh  q          vendor/ramsey/uuid/LICENSE7  yKAh7  <[         vendor/ramsey/uuid/README.md.  yKAh.            vendor/ramsey/uuid/composer.json  yKAh  }      $   vendor/ramsey/uuid/src/functions.phpg  yKAhg  M9      5   vendor/ramsey/uuid/src/Validator/GenericValidator.php  yKAh  *=      7   vendor/ramsey/uuid/src/Validator/ValidatorInterface.php  yKAh  5%Ф      >   vendor/ramsey/uuid/src/Converter/Time/GenericTimeConverter.phpk
  yKAhk
  Q+      ;   vendor/ramsey/uuid/src/Converter/Time/UnixTimeConverter.php	  yKAh	  gV      :   vendor/ramsey/uuid/src/Converter/Time/PhpTimeConverter.phpr  yKAhr  t      ?   vendor/ramsey/uuid/src/Converter/Time/DegradedTimeConverter.phpv  yKAhv  
פ      @   vendor/ramsey/uuid/src/Converter/Time/BigNumberTimeConverter.phpu  yKAhu  Ϫ24      C   vendor/ramsey/uuid/src/Converter/Number/DegradedNumberConverter.php}  yKAh}  Y{      >   vendor/ramsey/uuid/src/Converter/Number/BigNumberConverter.php  yKAh  ª9      B   vendor/ramsey/uuid/src/Converter/Number/GenericNumberConverter.php  yKAh  qH      ;   vendor/ramsey/uuid/src/Converter/TimeConverterInterface.php  yKAh  J      =   vendor/ramsey/uuid/src/Converter/NumberConverterInterface.php  yKAh  kL      5   vendor/ramsey/uuid/src/DeprecatedUuidMethodsTrait.php3  yKAh3  h      8   vendor/ramsey/uuid/src/Codec/TimestampFirstCombCodec.php  yKAh  єd      1   vendor/ramsey/uuid/src/Codec/OrderedTimeCodec.php
  yKAh
  I      /   vendor/ramsey/uuid/src/Codec/CodecInterface.php  yKAh        0   vendor/ramsey/uuid/src/Codec/GuidStringCodec.php  yKAh  3Ye      ,   vendor/ramsey/uuid/src/Codec/StringCodec.php  yKAh  9      7   vendor/ramsey/uuid/src/Codec/TimestampLastCombCodec.php  yKAh  e8         vendor/ramsey/uuid/src/Uuid.phpzZ  yKAhzZ  ק<      @   vendor/ramsey/uuid/src/Provider/DceSecurityProviderInterface.php  yKAh  jf      A   vendor/ramsey/uuid/src/Provider/Dce/SystemDceSecurityProvider.php0  yKAh0  M_=      9   vendor/ramsey/uuid/src/Provider/NodeProviderInterface.php  yKAh  	"      ;   vendor/ramsey/uuid/src/Provider/Time/SystemTimeProvider.php   yKAh   a      :   vendor/ramsey/uuid/src/Provider/Time/FixedTimeProvider.php  yKAh  eˤ      9   vendor/ramsey/uuid/src/Provider/TimeProviderInterface.phpS  yKAhS  m+      ;   vendor/ramsey/uuid/src/Provider/Node/RandomNodeProvider.phpo  yKAho  L_      =   vendor/ramsey/uuid/src/Provider/Node/FallbackNodeProvider.phpw  yKAhw        ;   vendor/ramsey/uuid/src/Provider/Node/SystemNodeProvider.php  yKAh  r犤      ?   vendor/ramsey/uuid/src/Provider/Node/NodeProviderCollection.phpE  yKAhE  7      ;   vendor/ramsey/uuid/src/Provider/Node/StaticNodeProvider.php4  yKAh4  ]q      %   vendor/ramsey/uuid/src/FeatureSet.php2  yKAh2  rI|Ф      2   vendor/ramsey/uuid/src/Rfc4122/FieldsInterface.php  yKAh  B^      )   vendor/ramsey/uuid/src/Rfc4122/UuidV8.php	  yKAh	  RE      ,   vendor/ramsey/uuid/src/Rfc4122/Validator.php  yKAh  ^l[      +   vendor/ramsey/uuid/src/Rfc4122/MaxTrait.php/  yKAh/  t       /   vendor/ramsey/uuid/src/Rfc4122/VersionTrait.php  yKAh  ޥd      +   vendor/ramsey/uuid/src/Rfc4122/NilTrait.php/  yKAh/  \ve      )   vendor/ramsey/uuid/src/Rfc4122/Fields.php  yKAh  ݀ͤ      *   vendor/ramsey/uuid/src/Rfc4122/NilUuid.php  yKAh        *   vendor/ramsey/uuid/src/Rfc4122/MaxUuid.php  yKAh  oޤ      0   vendor/ramsey/uuid/src/Rfc4122/UuidInterface.php  yKAh  :J}      ,   vendor/ramsey/uuid/src/Rfc4122/TimeTrait.phpA  yKAhA  P*      /   vendor/ramsey/uuid/src/Rfc4122/VariantTrait.php!  yKAh!        .   vendor/ramsey/uuid/src/Rfc4122/UuidBuilder.php1  yKAh1  ʞĤ      )   vendor/ramsey/uuid/src/Rfc4122/UuidV1.php  yKAh  )]ߤ      )   vendor/ramsey/uuid/src/Rfc4122/UuidV3.php>  yKAh>  H<      )   vendor/ramsey/uuid/src/Rfc4122/UuidV2.php  yKAh  O      )   vendor/ramsey/uuid/src/Rfc4122/UuidV6.php  yKAh  e`      )   vendor/ramsey/uuid/src/Rfc4122/UuidV7.php  yKAh  gE      )   vendor/ramsey/uuid/src/Rfc4122/UuidV5.phpC  yKAhC  X      )   vendor/ramsey/uuid/src/Rfc4122/UuidV4.php  yKAh        (   vendor/ramsey/uuid/src/UuidInterface.phpS  yKAhS  te<Ҥ      ,   vendor/ramsey/uuid/src/Math/RoundingMode.php1  yKAh1  {k3      3   vendor/ramsey/uuid/src/Math/CalculatorInterface.php  yKAh  E)      3   vendor/ramsey/uuid/src/Math/BrickMathCalculator.php  yKAh  ~      /   vendor/ramsey/uuid/src/UuidFactoryInterface.phpd  yKAhd  ڤ      9   vendor/ramsey/uuid/src/Generator/RandomBytesGenerator.phpU  yKAhU  7      9   vendor/ramsey/uuid/src/Generator/NameGeneratorFactory.php  yKAh  zݤ      6   vendor/ramsey/uuid/src/Generator/UnixTimeGenerator.php  yKAh  =      ;   vendor/ramsey/uuid/src/Generator/NameGeneratorInterface.php&  yKAh&  R      ;   vendor/ramsey/uuid/src/Generator/RandomGeneratorFactory.php  yKAh  ,q      9   vendor/ramsey/uuid/src/Generator/DceSecurityGenerator.php  yKAh  P~f      B   vendor/ramsey/uuid/src/Generator/DceSecurityGeneratorInterface.php  yKAh  8      9   vendor/ramsey/uuid/src/Generator/TimeGeneratorFactory.phpx  yKAhx  76i      9   vendor/ramsey/uuid/src/Generator/DefaultNameGenerator.php8  yKAh8  G4o      9   vendor/ramsey/uuid/src/Generator/DefaultTimeGenerator.php  yKAh  YO      5   vendor/ramsey/uuid/src/Generator/RandomLibAdapter.php7  yKAh7  ю      ;   vendor/ramsey/uuid/src/Generator/TimeGeneratorInterface.php  yKAh  CkO      2   vendor/ramsey/uuid/src/Generator/CombGenerator.phpZ
  yKAhZ
        =   vendor/ramsey/uuid/src/Generator/RandomGeneratorInterface.php  yKAh  Il      <   vendor/ramsey/uuid/src/Generator/PeclUuidRandomGenerator.php<  yKAh<  18      :   vendor/ramsey/uuid/src/Generator/PeclUuidNameGenerator.php	  yKAh	  P\̤      :   vendor/ramsey/uuid/src/Generator/PeclUuidTimeGenerator.php{  yKAh{  Ҥ      &   vendor/ramsey/uuid/src/BinaryUtils.php  yKAh  Y{      &   vendor/ramsey/uuid/src/UuidFactory.php0;  yKAh0;  3      '   vendor/ramsey/uuid/src/Type/Integer.php#  yKAh#  M       $   vendor/ramsey/uuid/src/Type/Time.php  yKAh  V      +   vendor/ramsey/uuid/src/Type/Hexadecimal.php  yKAh  ޮ~C      /   vendor/ramsey/uuid/src/Type/NumberInterface.php  yKAh  B1      -   vendor/ramsey/uuid/src/Type/TypeInterface.php  yKAh  w<      '   vendor/ramsey/uuid/src/Type/Decimal.php  yKAh        $   vendor/ramsey/uuid/src/Guid/Guid.php		  yKAh		  M      &   vendor/ramsey/uuid/src/Guid/Fields.php   yKAh   8mF      +   vendor/ramsey/uuid/src/Guid/GuidBuilder.phpe  yKAhe  tˤ      2   vendor/ramsey/uuid/src/Lazy/LazyUuidFromString.php5  yKAh5  F      '   vendor/ramsey/uuid/src/DegradedUuid.php[  yKAh[  ?^      1   vendor/ramsey/uuid/src/Fields/FieldsInterface.php  yKAh  )=      9   vendor/ramsey/uuid/src/Fields/SerializableFieldsTrait.phpz  yKAhz  P	      2   vendor/ramsey/uuid/src/DeprecatedUuidInterface.php  yKAh  >      6   vendor/ramsey/uuid/src/Builder/DegradedUuidBuilder.phpJ  yKAhJ  #Y      7   vendor/ramsey/uuid/src/Builder/UuidBuilderInterface.php  yKAh  	JB      4   vendor/ramsey/uuid/src/Builder/BuilderCollection.php	  yKAh	  =      2   vendor/ramsey/uuid/src/Builder/FallbackBuilder.php[  yKAh[  (=      5   vendor/ramsey/uuid/src/Builder/DefaultUuidBuilder.phpU  yKAhU  "      :   vendor/ramsey/uuid/src/Exception/RandomSourceException.php  yKAh        2   vendor/ramsey/uuid/src/Exception/NodeException.php`  yKAh`  ]      6   vendor/ramsey/uuid/src/Exception/DateTimeException.phpa  yKAha  \      8   vendor/ramsey/uuid/src/Exception/TimeSourceException.phpQ  yKAhQ        B   vendor/ramsey/uuid/src/Exception/UnsupportedOperationException.phpV  yKAhV  JN      :   vendor/ramsey/uuid/src/Exception/InvalidBytesException.php_  yKAh_  /٤      9   vendor/ramsey/uuid/src/Exception/DceSecurityException.phpm  yKAhm  IC      2   vendor/ramsey/uuid/src/Exception/NameException.phpc  yKAhc  sOS      =   vendor/ramsey/uuid/src/Exception/InvalidArgumentException.phpi  yKAhi  v'ä      =   vendor/ramsey/uuid/src/Exception/BuilderNotFoundException.phpQ  yKAhQ  @c      ?   vendor/ramsey/uuid/src/Exception/UnableToBuildUuidException.phpO  yKAhO  Ro      ;   vendor/ramsey/uuid/src/Exception/UuidExceptionInterface.php  yKAh  K;Ҥ      ?   vendor/ramsey/uuid/src/Exception/InvalidUuidStringException.php  yKAh  <1i      -   vendor/ramsey/uuid/src/Nonstandard/Fields.php2
  yKAh2
        +   vendor/ramsey/uuid/src/Nonstandard/Uuid.php  yKAh  $R      2   vendor/ramsey/uuid/src/Nonstandard/UuidBuilder.php  yKAh  w,      -   vendor/ramsey/uuid/src/Nonstandard/UuidV6.php
  yKAh
  !b         vendor/webmozart/assert/LICENSE<  yKAh<  t}      $   vendor/webmozart/assert/CHANGELOG.md  yKAh        !   vendor/webmozart/assert/README.md>  yKAh>  |Ϥ      %   vendor/webmozart/assert/composer.json  yKAh  3p      %   vendor/webmozart/assert/src/Mixin.php5 yKAh5 9(      8   vendor/webmozart/assert/src/InvalidArgumentException.phpi  yKAhi  {Lä      &   vendor/webmozart/assert/src/Assert.php  yKAh  =         vendor/react/promise/LICENSEg  yKAhg  F      !   vendor/react/promise/CHANGELOG.md9  yKAh9  OT:         vendor/react/promise/README.mdQY  yKAhQY  1      "   vendor/react/promise/composer.json  yKAh  NjB      -   vendor/react/promise/src/PromiseInterface.php  yKAh  MFx8      &   vendor/react/promise/src/functions.php1-  yKAh1-  t      .   vendor/react/promise/src/functions_include.php   yKAh   dx\      $   vendor/react/promise/src/Promise.php(  yKAh(  s;6      %   vendor/react/promise/src/Deferred.php0  yKAh0        5   vendor/react/promise/src/Internal/RejectedPromise.php
  yKAh
  |      6   vendor/react/promise/src/Internal/FulfilledPromise.php3	  yKAh3	  *      7   vendor/react/promise/src/Internal/CancellationQueue.php  yKAh  r2      6   vendor/react/promise/src/Exception/LengthException.php^   yKAh^   ?q      9   vendor/react/promise/src/Exception/CompositeException.phpa  yKAha  '         vendor/sebastian/diff/LICENSE  yKAh  ܡ7      "   vendor/sebastian/diff/ChangeLog.md  yKAh  A         vendor/sebastian/diff/README.mdx   yKAhx   Z      #   vendor/sebastian/diff/composer.json  yKAh  H      !   vendor/sebastian/diff/SECURITY.mdu  yKAhu  KJ      "   vendor/sebastian/diff/src/Diff.php^  yKAh^  D1Ѥ      $   vendor/sebastian/diff/src/Parser.php  yKAh  թ      M   vendor/sebastian/diff/src/TimeEfficientLongestCommonSubsequenceCalculator.php5	  yKAh5	  0OԤ      :   vendor/sebastian/diff/src/Output/DiffOnlyOutputBuilder.php  yKAh        ?   vendor/sebastian/diff/src/Output/DiffOutputBuilderInterface.php  yKAh        =   vendor/sebastian/diff/src/Output/UnifiedDiffOutputBuilder.php  yKAh        C   vendor/sebastian/diff/src/Output/StrictUnifiedDiffOutputBuilder.phpm(  yKAhm(  ˌ      ?   vendor/sebastian/diff/src/Output/AbstractChunkOutputBuilder.php  yKAh  J5|      @   vendor/sebastian/diff/src/LongestCommonSubsequenceCalculator.php  yKAh  !J9      #   vendor/sebastian/diff/src/Chunk.php	  yKAh	  8      $   vendor/sebastian/diff/src/Differ.php  yKAh  ԕL      "   vendor/sebastian/diff/src/Line.php  yKAh  >      >   vendor/sebastian/diff/src/Exception/ConfigurationException.php)  yKAh)  2ܤ      @   vendor/sebastian/diff/src/Exception/InvalidArgumentException.php  yKAh  +U/ܤ      1   vendor/sebastian/diff/src/Exception/Exception.phpq  yKAhq  Z      O   vendor/sebastian/diff/src/MemoryEfficientLongestCommonSubsequenceCalculator.php+
  yKAh+
  ٤      3   vendor/terminal42/composer-lock-validator/README.md  yKAh  z      7   vendor/terminal42/composer-lock-validator/composer.json#  yKAh#  B      ;   vendor/terminal42/composer-lock-validator/src/Validator.php  yKAh  ,      E   vendor/terminal42/composer-lock-validator/src/ValidationException.php  yKAh  I<      <?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

require __DIR__ . '/../vendor/autoload.php';
if (\false === \in_array(\PHP_SAPI, array('cli', 'phpdbg', 'embed'), \true)) {
    echo \PHP_EOL . 'The application may only be invoked from a command line, got "' . \PHP_SAPI . '"' . \PHP_EOL;
    exit(1);
}
if ((\false === isset($_SERVER['BOX_REQUIREMENT_CHECKER']) || \true === (bool) $_SERVER['BOX_REQUIREMENT_CHECKER']) && \false === Checker::checkRequirements()) {
    exit(1);
}
<?php

return array (
  0 => 
  array (
    'type' => 'php',
    'condition' => '^8.1',
    'message' => 'The application requires the version "^8.1" or greater.',
    'helpMessage' => 'The application requires the version "^8.1" or greater.',
  ),
  1 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The application requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "json".',
  ),
  2 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The package "ramsey/uuid" requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The package "ramsey/uuid" requires the extension "json".',
  ),
  3 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The package "web-auth/cose-lib" requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/cose-lib" requires the extension "json".',
  ),
  4 => 
  array (
    'type' => 'extension',
    'condition' => 'json',
    'message' => 'The package "web-auth/webauthn-lib" requires the extension "json". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/webauthn-lib" requires the extension "json".',
  ),
  5 => 
  array (
    'type' => 'extension',
    'condition' => 'session',
    'message' => 'The application requires the extension "session". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "session".',
  ),
  6 => 
  array (
    'type' => 'extension',
    'condition' => 'zip',
    'message' => 'The application requires the extension "zip". Enable it or install a polyfill.',
    'helpMessage' => 'The application requires the extension "zip".',
  ),
  7 => 
  array (
    'type' => 'extension',
    'condition' => 'openssl',
    'message' => 'The package "composer/ca-bundle" requires the extension "openssl". Enable it or install a polyfill.',
    'helpMessage' => 'The package "composer/ca-bundle" requires the extension "openssl".',
  ),
  8 => 
  array (
    'type' => 'extension',
    'condition' => 'openssl',
    'message' => 'The package "web-auth/cose-lib" requires the extension "openssl". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/cose-lib" requires the extension "openssl".',
  ),
  9 => 
  array (
    'type' => 'extension',
    'condition' => 'openssl',
    'message' => 'The package "web-auth/webauthn-lib" requires the extension "openssl". Enable it or install a polyfill.',
    'helpMessage' => 'The package "web-auth/webauthn-lib" requires the extension "openssl".',
  ),
  10 => 
  array (
    'type' => 'extension',
    'condition' => 'pcre',
    'message' => 'The package "composer/ca-bundle" requires the extension "pcre". Enable it or install a polyfill.',
    'helpMessage' => 'The package "composer/ca-bundle" requires the extension "pcre".',
  ),
  11 => 
  array (
    'type' => 'extension',
    'condition' => 'filter',
    'message' => 'The package "phpdocumentor/reflection-docblock" requires the extension "filter". Enable it or install a polyfill.',
    'helpMessage' => 'The package "phpdocumentor/reflection-docblock" requires the extension "filter".',
  ),
  12 => 
  array (
    'type' => 'extension',
    'condition' => 'xml',
    'message' => 'The package "symfony/framework-bundle" requires the extension "xml". Enable it or install a polyfill.',
    'helpMessage' => 'The package "symfony/framework-bundle" requires the extension "xml".',
  ),
  13 => 
  array (
    'type' => 'extension',
    'condition' => 'xml',
    'message' => 'The package "symfony/security-bundle" requires the extension "xml". Enable it or install a polyfill.',
    'helpMessage' => 'The package "symfony/security-bundle" requires the extension "xml".',
  ),
  14 => 
  array (
    'type' => 'extension',
    'condition' => 'iconv',
    'message' => 'The package "symfony/polyfill-mbstring" requires the extension "iconv". Enable it or install a polyfill.',
    'helpMessage' => 'The package "symfony/polyfill-mbstring" requires the extension "iconv".',
  ),
);<?php

// autoload.php @generated by Composer

require_once __DIR__ . '/composer/autoload_real.php';

return ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893::getLoader();
<?php

// autoload_namespaces.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
);

Copyright (c) Nils Adermann, Jordi Boggiano

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is furnished
to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

<?php

/*
 * This file is part of Composer.
 *
 * (c) Nils Adermann <naderman@naderman.de>
 *     Jordi Boggiano <j.boggiano@seld.be>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Composer\Autoload;

/**
 * ClassLoader implements a PSR-0, PSR-4 and classmap class loader.
 *
 *     $loader = new \Composer\Autoload\ClassLoader();
 *
 *     // register classes with namespaces
 *     $loader->add('Symfony\Component', __DIR__.'/component');
 *     $loader->add('Symfony',           __DIR__.'/framework');
 *
 *     // activate the autoloader
 *     $loader->register();
 *
 *     // to enable searching the include path (eg. for PEAR packages)
 *     $loader->setUseIncludePath(true);
 *
 * In this example, if you try to use a class in the Symfony\Component
 * namespace or one of its children (Symfony\Component\Console for instance),
 * the autoloader will first look for the class under the component/
 * directory, and it will then fallback to the framework/ directory if not
 * found before giving up.
 *
 * This class is loosely based on the Symfony UniversalClassLoader.
 *
 * @author Fabien Potencier <fabien@symfony.com>
 * @author Jordi Boggiano <j.boggiano@seld.be>
 * @see    https://www.php-fig.org/psr/psr-0/
 * @see    https://www.php-fig.org/psr/psr-4/
 */
class ClassLoader
{
    /** @var ?string */
    private $vendorDir;

    // PSR-4
    /**
     * @var array[]
     * @psalm-var array<string, array<string, int>>
     */
    private $prefixLengthsPsr4 = array();
    /**
     * @var array[]
     * @psalm-var array<string, array<int, string>>
     */
    private $prefixDirsPsr4 = array();
    /**
     * @var array[]
     * @psalm-var array<string, string>
     */
    private $fallbackDirsPsr4 = array();

    // PSR-0
    /**
     * @var array[]
     * @psalm-var array<string, array<string, string[]>>
     */
    private $prefixesPsr0 = array();
    /**
     * @var array[]
     * @psalm-var array<string, string>
     */
    private $fallbackDirsPsr0 = array();

    /** @var bool */
    private $useIncludePath = false;

    /**
     * @var string[]
     * @psalm-var array<string, string>
     */
    private $classMap = array();

    /** @var bool */
    private $classMapAuthoritative = false;

    /**
     * @var bool[]
     * @psalm-var array<string, bool>
     */
    private $missingClasses = array();

    /** @var ?string */
    private $apcuPrefix;

    /**
     * @var self[]
     */
    private static $registeredLoaders = array();

    /**
     * @param ?string $vendorDir
     */
    public function __construct($vendorDir = null)
    {
        $this->vendorDir = $vendorDir;
    }

    /**
     * @return string[]
     */
    public function getPrefixes()
    {
        if (!empty($this->prefixesPsr0)) {
            return call_user_func_array('array_merge', array_values($this->prefixesPsr0));
        }

        return array();
    }

    /**
     * @return array[]
     * @psalm-return array<string, array<int, string>>
     */
    public function getPrefixesPsr4()
    {
        return $this->prefixDirsPsr4;
    }

    /**
     * @return array[]
     * @psalm-return array<string, string>
     */
    public function getFallbackDirs()
    {
        return $this->fallbackDirsPsr0;
    }

    /**
     * @return array[]
     * @psalm-return array<string, string>
     */
    public function getFallbackDirsPsr4()
    {
        return $this->fallbackDirsPsr4;
    }

    /**
     * @return string[] Array of classname => path
     * @psalm-return array<string, string>
     */
    public function getClassMap()
    {
        return $this->classMap;
    }

    /**
     * @param string[] $classMap Class to filename map
     * @psalm-param array<string, string> $classMap
     *
     * @return void
     */
    public function addClassMap(array $classMap)
    {
        if ($this->classMap) {
            $this->classMap = array_merge($this->classMap, $classMap);
        } else {
            $this->classMap = $classMap;
        }
    }

    /**
     * Registers a set of PSR-0 directories for a given prefix, either
     * appending or prepending to the ones previously set for this prefix.
     *
     * @param string          $prefix  The prefix
     * @param string[]|string $paths   The PSR-0 root directories
     * @param bool            $prepend Whether to prepend the directories
     *
     * @return void
     */
    public function add($prefix, $paths, $prepend = false)
    {
        if (!$prefix) {
            if ($prepend) {
                $this->fallbackDirsPsr0 = array_merge(
                    (array) $paths,
                    $this->fallbackDirsPsr0
                );
            } else {
                $this->fallbackDirsPsr0 = array_merge(
                    $this->fallbackDirsPsr0,
                    (array) $paths
                );
            }

            return;
        }

        $first = $prefix[0];
        if (!isset($this->prefixesPsr0[$first][$prefix])) {
            $this->prefixesPsr0[$first][$prefix] = (array) $paths;

            return;
        }
        if ($prepend) {
            $this->prefixesPsr0[$first][$prefix] = array_merge(
                (array) $paths,
                $this->prefixesPsr0[$first][$prefix]
            );
        } else {
            $this->prefixesPsr0[$first][$prefix] = array_merge(
                $this->prefixesPsr0[$first][$prefix],
                (array) $paths
            );
        }
    }

    /**
     * Registers a set of PSR-4 directories for a given namespace, either
     * appending or prepending to the ones previously set for this namespace.
     *
     * @param string          $prefix  The prefix/namespace, with trailing '\\'
     * @param string[]|string $paths   The PSR-4 base directories
     * @param bool            $prepend Whether to prepend the directories
     *
     * @throws \InvalidArgumentException
     *
     * @return void
     */
    public function addPsr4($prefix, $paths, $prepend = false)
    {
        if (!$prefix) {
            // Register directories for the root namespace.
            if ($prepend) {
                $this->fallbackDirsPsr4 = array_merge(
                    (array) $paths,
                    $this->fallbackDirsPsr4
                );
            } else {
                $this->fallbackDirsPsr4 = array_merge(
                    $this->fallbackDirsPsr4,
                    (array) $paths
                );
            }
        } elseif (!isset($this->prefixDirsPsr4[$prefix])) {
            // Register directories for a new namespace.
            $length = strlen($prefix);
            if ('\\' !== $prefix[$length - 1]) {
                throw new \InvalidArgumentException("A non-empty PSR-4 prefix must end with a namespace separator.");
            }
            $this->prefixLengthsPsr4[$prefix[0]][$prefix] = $length;
            $this->prefixDirsPsr4[$prefix] = (array) $paths;
        } elseif ($prepend) {
            // Prepend directories for an already registered namespace.
            $this->prefixDirsPsr4[$prefix] = array_merge(
                (array) $paths,
                $this->prefixDirsPsr4[$prefix]
            );
        } else {
            // Append directories for an already registered namespace.
            $this->prefixDirsPsr4[$prefix] = array_merge(
                $this->prefixDirsPsr4[$prefix],
                (array) $paths
            );
        }
    }

    /**
     * Registers a set of PSR-0 directories for a given prefix,
     * replacing any others previously set for this prefix.
     *
     * @param string          $prefix The prefix
     * @param string[]|string $paths  The PSR-0 base directories
     *
     * @return void
     */
    public function set($prefix, $paths)
    {
        if (!$prefix) {
            $this->fallbackDirsPsr0 = (array) $paths;
        } else {
            $this->prefixesPsr0[$prefix[0]][$prefix] = (array) $paths;
        }
    }

    /**
     * Registers a set of PSR-4 directories for a given namespace,
     * replacing any others previously set for this namespace.
     *
     * @param string          $prefix The prefix/namespace, with trailing '\\'
     * @param string[]|string $paths  The PSR-4 base directories
     *
     * @throws \InvalidArgumentException
     *
     * @return void
     */
    public function setPsr4($prefix, $paths)
    {
        if (!$prefix) {
            $this->fallbackDirsPsr4 = (array) $paths;
        } else {
            $length = strlen($prefix);
            if ('\\' !== $prefix[$length - 1]) {
                throw new \InvalidArgumentException("A non-empty PSR-4 prefix must end with a namespace separator.");
            }
            $this->prefixLengthsPsr4[$prefix[0]][$prefix] = $length;
            $this->prefixDirsPsr4[$prefix] = (array) $paths;
        }
    }

    /**
     * Turns on searching the include path for class files.
     *
     * @param bool $useIncludePath
     *
     * @return void
     */
    public function setUseIncludePath($useIncludePath)
    {
        $this->useIncludePath = $useIncludePath;
    }

    /**
     * Can be used to check if the autoloader uses the include path to check
     * for classes.
     *
     * @return bool
     */
    public function getUseIncludePath()
    {
        return $this->useIncludePath;
    }

    /**
     * Turns off searching the prefix and fallback directories for classes
     * that have not been registered with the class map.
     *
     * @param bool $classMapAuthoritative
     *
     * @return void
     */
    public function setClassMapAuthoritative($classMapAuthoritative)
    {
        $this->classMapAuthoritative = $classMapAuthoritative;
    }

    /**
     * Should class lookup fail if not found in the current class map?
     *
     * @return bool
     */
    public function isClassMapAuthoritative()
    {
        return $this->classMapAuthoritative;
    }

    /**
     * APCu prefix to use to cache found/not-found classes, if the extension is enabled.
     *
     * @param string|null $apcuPrefix
     *
     * @return void
     */
    public function setApcuPrefix($apcuPrefix)
    {
        $this->apcuPrefix = function_exists('apcu_fetch') && filter_var(ini_get('apc.enabled'), FILTER_VALIDATE_BOOLEAN) ? $apcuPrefix : null;
    }

    /**
     * The APCu prefix in use, or null if APCu caching is not enabled.
     *
     * @return string|null
     */
    public function getApcuPrefix()
    {
        return $this->apcuPrefix;
    }

    /**
     * Registers this instance as an autoloader.
     *
     * @param bool $prepend Whether to prepend the autoloader or not
     *
     * @return void
     */
    public function register($prepend = false)
    {
        spl_autoload_register(array($this, 'loadClass'), true, $prepend);

        if (null === $this->vendorDir) {
            return;
        }

        if ($prepend) {
            self::$registeredLoaders = array($this->vendorDir => $this) + self::$registeredLoaders;
        } else {
            unset(self::$registeredLoaders[$this->vendorDir]);
            self::$registeredLoaders[$this->vendorDir] = $this;
        }
    }

    /**
     * Unregisters this instance as an autoloader.
     *
     * @return void
     */
    public function unregister()
    {
        spl_autoload_unregister(array($this, 'loadClass'));

        if (null !== $this->vendorDir) {
            unset(self::$registeredLoaders[$this->vendorDir]);
        }
    }

    /**
     * Loads the given class or interface.
     *
     * @param  string    $class The name of the class
     * @return true|null True if loaded, null otherwise
     */
    public function loadClass($class)
    {
        if ($file = $this->findFile($class)) {
            includeFile($file);

            return true;
        }

        return null;
    }

    /**
     * Finds the path to the file where the class is defined.
     *
     * @param string $class The name of the class
     *
     * @return string|false The path if found, false otherwise
     */
    public function findFile($class)
    {
        // class map lookup
        if (isset($this->classMap[$class])) {
            return $this->classMap[$class];
        }
        if ($this->classMapAuthoritative || isset($this->missingClasses[$class])) {
            return false;
        }
        if (null !== $this->apcuPrefix) {
            $file = apcu_fetch($this->apcuPrefix.$class, $hit);
            if ($hit) {
                return $file;
            }
        }

        $file = $this->findFileWithExtension($class, '.php');

        // Search for Hack files if we are running on HHVM
        if (false === $file && defined('HHVM_VERSION')) {
            $file = $this->findFileWithExtension($class, '.hh');
        }

        if (null !== $this->apcuPrefix) {
            apcu_add($this->apcuPrefix.$class, $file);
        }

        if (false === $file) {
            // Remember that this class does not exist.
            $this->missingClasses[$class] = true;
        }

        return $file;
    }

    /**
     * Returns the currently registered loaders indexed by their corresponding vendor directories.
     *
     * @return self[]
     */
    public static function getRegisteredLoaders()
    {
        return self::$registeredLoaders;
    }

    /**
     * @param  string       $class
     * @param  string       $ext
     * @return string|false
     */
    private function findFileWithExtension($class, $ext)
    {
        // PSR-4 lookup
        $logicalPathPsr4 = strtr($class, '\\', DIRECTORY_SEPARATOR) . $ext;

        $first = $class[0];
        if (isset($this->prefixLengthsPsr4[$first])) {
            $subPath = $class;
            while (false !== $lastPos = strrpos($subPath, '\\')) {
                $subPath = substr($subPath, 0, $lastPos);
                $search = $subPath . '\\';
                if (isset($this->prefixDirsPsr4[$search])) {
                    $pathEnd = DIRECTORY_SEPARATOR . substr($logicalPathPsr4, $lastPos + 1);
                    foreach ($this->prefixDirsPsr4[$search] as $dir) {
                        if (file_exists($file = $dir . $pathEnd)) {
                            return $file;
                        }
                    }
                }
            }
        }

        // PSR-4 fallback dirs
        foreach ($this->fallbackDirsPsr4 as $dir) {
            if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr4)) {
                return $file;
            }
        }

        // PSR-0 lookup
        if (false !== $pos = strrpos($class, '\\')) {
            // namespaced class name
            $logicalPathPsr0 = substr($logicalPathPsr4, 0, $pos + 1)
                . strtr(substr($logicalPathPsr4, $pos + 1), '_', DIRECTORY_SEPARATOR);
        } else {
            // PEAR-like class name
            $logicalPathPsr0 = strtr($class, '_', DIRECTORY_SEPARATOR) . $ext;
        }

        if (isset($this->prefixesPsr0[$first])) {
            foreach ($this->prefixesPsr0[$first] as $prefix => $dirs) {
                if (0 === strpos($class, $prefix)) {
                    foreach ($dirs as $dir) {
                        if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr0)) {
                            return $file;
                        }
                    }
                }
            }
        }

        // PSR-0 fallback dirs
        foreach ($this->fallbackDirsPsr0 as $dir) {
            if (file_exists($file = $dir . DIRECTORY_SEPARATOR . $logicalPathPsr0)) {
                return $file;
            }
        }

        // PSR-0 include paths.
        if ($this->useIncludePath && $file = stream_resolve_include_path($logicalPathPsr0)) {
            return $file;
        }

        return false;
    }
}

/**
 * Scope isolated include.
 *
 * Prevents access to $this/self from included files.
 *
 * @param  string $file
 * @return void
 * @private
 */
function includeFile($file)
{
    include $file;
}
<?php

// autoload_psr4.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
    'HumbugBox3150\\KevinGH\\RequirementChecker\\' => array($baseDir . '/src'),
    'HumbugBox3150\\Composer\\Semver\\' => array($vendorDir . '/composer/semver/src'),
);
<?php

// autoload_classmap.php @generated by Composer

$vendorDir = dirname(dirname(__FILE__));
$baseDir = dirname($vendorDir);

return array(
    'Composer\\InstalledVersions' => $vendorDir . '/composer/InstalledVersions.php',
    'HumbugBox3150\\Composer\\Semver\\Comparator' => $vendorDir . '/composer/semver/src/Comparator.php',
    'HumbugBox3150\\Composer\\Semver\\CompilingMatcher' => $vendorDir . '/composer/semver/src/CompilingMatcher.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\Bound' => $vendorDir . '/composer/semver/src/Constraint/Bound.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\Constraint' => $vendorDir . '/composer/semver/src/Constraint/Constraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\ConstraintInterface' => $vendorDir . '/composer/semver/src/Constraint/ConstraintInterface.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchAllConstraint' => $vendorDir . '/composer/semver/src/Constraint/MatchAllConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchNoneConstraint' => $vendorDir . '/composer/semver/src/Constraint/MatchNoneConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Constraint\\MultiConstraint' => $vendorDir . '/composer/semver/src/Constraint/MultiConstraint.php',
    'HumbugBox3150\\Composer\\Semver\\Interval' => $vendorDir . '/composer/semver/src/Interval.php',
    'HumbugBox3150\\Composer\\Semver\\Intervals' => $vendorDir . '/composer/semver/src/Intervals.php',
    'HumbugBox3150\\Composer\\Semver\\Semver' => $vendorDir . '/composer/semver/src/Semver.php',
    'HumbugBox3150\\Composer\\Semver\\VersionParser' => $vendorDir . '/composer/semver/src/VersionParser.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Checker' => $baseDir . '/src/Checker.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IO' => $baseDir . '/src/IO.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsExtensionFulfilled' => $baseDir . '/src/IsExtensionFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsFulfilled' => $baseDir . '/src/IsFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\IsPhpVersionFulfilled' => $baseDir . '/src/IsPhpVersionFulfilled.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Printer' => $baseDir . '/src/Printer.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Requirement' => $baseDir . '/src/Requirement.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\RequirementCollection' => $baseDir . '/src/RequirementCollection.php',
    'HumbugBox3150\\KevinGH\\RequirementChecker\\Terminal' => $baseDir . '/src/Terminal.php',
);
<?php

// autoload_static.php @generated by Composer

namespace Composer\Autoload;

class ComposerStaticInit7b1918d23e69dc64db20ca1f98396893
{
    public static $prefixLengthsPsr4 = array (
        'H' => 
        array (
            'HumbugBox3150\\KevinGH\\RequirementChecker\\' => 41,
            'HumbugBox3150\\Composer\\Semver\\' => 30,
        ),
    );

    public static $prefixDirsPsr4 = array (
        'HumbugBox3150\\KevinGH\\RequirementChecker\\' => 
        array (
            0 => __DIR__ . '/../..' . '/src',
        ),
        'HumbugBox3150\\Composer\\Semver\\' => 
        array (
            0 => __DIR__ . '/..' . '/composer/semver/src',
        ),
    );

    public static $classMap = array (
        'Composer\\InstalledVersions' => __DIR__ . '/..' . '/composer/InstalledVersions.php',
        'HumbugBox3150\\Composer\\Semver\\Comparator' => __DIR__ . '/..' . '/composer/semver/src/Comparator.php',
        'HumbugBox3150\\Composer\\Semver\\CompilingMatcher' => __DIR__ . '/..' . '/composer/semver/src/CompilingMatcher.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\Bound' => __DIR__ . '/..' . '/composer/semver/src/Constraint/Bound.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\Constraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/Constraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\ConstraintInterface' => __DIR__ . '/..' . '/composer/semver/src/Constraint/ConstraintInterface.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchAllConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MatchAllConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MatchNoneConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MatchNoneConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Constraint\\MultiConstraint' => __DIR__ . '/..' . '/composer/semver/src/Constraint/MultiConstraint.php',
        'HumbugBox3150\\Composer\\Semver\\Interval' => __DIR__ . '/..' . '/composer/semver/src/Interval.php',
        'HumbugBox3150\\Composer\\Semver\\Intervals' => __DIR__ . '/..' . '/composer/semver/src/Intervals.php',
        'HumbugBox3150\\Composer\\Semver\\Semver' => __DIR__ . '/..' . '/composer/semver/src/Semver.php',
        'HumbugBox3150\\Composer\\Semver\\VersionParser' => __DIR__ . '/..' . '/composer/semver/src/VersionParser.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Checker' => __DIR__ . '/../..' . '/src/Checker.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IO' => __DIR__ . '/../..' . '/src/IO.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsExtensionFulfilled' => __DIR__ . '/../..' . '/src/IsExtensionFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsFulfilled' => __DIR__ . '/../..' . '/src/IsFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\IsPhpVersionFulfilled' => __DIR__ . '/../..' . '/src/IsPhpVersionFulfilled.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Printer' => __DIR__ . '/../..' . '/src/Printer.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Requirement' => __DIR__ . '/../..' . '/src/Requirement.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\RequirementCollection' => __DIR__ . '/../..' . '/src/RequirementCollection.php',
        'HumbugBox3150\\KevinGH\\RequirementChecker\\Terminal' => __DIR__ . '/../..' . '/src/Terminal.php',
    );

    public static function getInitializer(ClassLoader $loader)
    {
        return \Closure::bind(function () use ($loader) {
            $loader->prefixLengthsPsr4 = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$prefixLengthsPsr4;
            $loader->prefixDirsPsr4 = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$prefixDirsPsr4;
            $loader->classMap = ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::$classMap;

        }, null, ClassLoader::class);
    }
}
<?php

// autoload_real.php @generated by Composer

class ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893
{
    private static $loader;

    public static function loadClassLoader($class)
    {
        if ('Composer\Autoload\ClassLoader' === $class) {
            require __DIR__ . '/ClassLoader.php';
        }
    }

    /**
     * @return \Composer\Autoload\ClassLoader
     */
    public static function getLoader()
    {
        if (null !== self::$loader) {
            return self::$loader;
        }

        spl_autoload_register(array('ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893', 'loadClassLoader'), true, true);
        self::$loader = $loader = new \Composer\Autoload\ClassLoader(\dirname(\dirname(__FILE__)));
        spl_autoload_unregister(array('ComposerAutoloaderInit7b1918d23e69dc64db20ca1f98396893', 'loadClassLoader'));

        $useStaticLoader = PHP_VERSION_ID >= 50600 && !defined('HHVM_VERSION') && (!function_exists('zend_loader_file_encoded') || !zend_loader_file_encoded());
        if ($useStaticLoader) {
            require __DIR__ . '/autoload_static.php';

            call_user_func(\Composer\Autoload\ComposerStaticInit7b1918d23e69dc64db20ca1f98396893::getInitializer($loader));
        } else {
            $classMap = require __DIR__ . '/autoload_classmap.php';
            if ($classMap) {
                $loader->addClassMap($classMap);
            }
        }

        $loader->setClassMapAuthoritative(true);
        $loader->register(true);

        return $loader;
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class Comparator
{
    public static function greaterThan($version1, $version2)
    {
        return self::compare($version1, '>', $version2);
    }
    public static function greaterThanOrEqualTo($version1, $version2)
    {
        return self::compare($version1, '>=', $version2);
    }
    public static function lessThan($version1, $version2)
    {
        return self::compare($version1, '<', $version2);
    }
    public static function lessThanOrEqualTo($version1, $version2)
    {
        return self::compare($version1, '<=', $version2);
    }
    public static function equalTo($version1, $version2)
    {
        return self::compare($version1, '==', $version2);
    }
    public static function notEqualTo($version1, $version2)
    {
        return self::compare($version1, '!=', $version2);
    }
    public static function compare($version1, $operator, $version2)
    {
        $constraint = new Constraint($operator, $version2);
        return $constraint->matchSpecific(new Constraint('==', $version1), \true);
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class Semver
{
    const SORT_ASC = 1;
    const SORT_DESC = -1;
    private static $versionParser;
    public static function satisfies($version, $constraints)
    {
        if (null === self::$versionParser) {
            self::$versionParser = new VersionParser();
        }
        $versionParser = self::$versionParser;
        $provider = new Constraint('==', $versionParser->normalize($version));
        $parsedConstraints = $versionParser->parseConstraints($constraints);
        return $parsedConstraints->matches($provider);
    }
    public static function satisfiedBy(array $versions, $constraints)
    {
        $versions = \array_filter($versions, function ($version) use($constraints) {
            return Semver::satisfies($version, $constraints);
        });
        return \array_values($versions);
    }
    public static function sort(array $versions)
    {
        return self::usort($versions, self::SORT_ASC);
    }
    public static function rsort(array $versions)
    {
        return self::usort($versions, self::SORT_DESC);
    }
    private static function usort(array $versions, $direction)
    {
        if (null === self::$versionParser) {
            self::$versionParser = new VersionParser();
        }
        $versionParser = self::$versionParser;
        $normalized = array();
        foreach ($versions as $key => $version) {
            $normalizedVersion = $versionParser->normalize($version);
            $normalizedVersion = $versionParser->normalizeDefaultBranch($normalizedVersion);
            $normalized[] = array($normalizedVersion, $key);
        }
        \usort($normalized, function (array $left, array $right) use($direction) {
            if ($left[0] === $right[0]) {
                return 0;
            }
            if (Comparator::lessThan($left[0], $right[0])) {
                return -$direction;
            }
            return $direction;
        });
        $sorted = array();
        foreach ($normalized as $item) {
            $sorted[] = $versions[$item[1]];
        }
        return $sorted;
    }
}
<?php

namespace HumbugBox3150\Composer\Semver;

use HumbugBox3150\Composer\Semver\Constraint\ConstraintInterface;
use HumbugBox3150\Composer\Semver\Constraint\MatchAllConstraint;
use HumbugBox3150\Composer\Semver\Constraint\MultiConstraint;
use HumbugBox3150\Composer\Semver\Constraint\Constraint;
class VersionParser
{
    private static $modifierRegex = '[._-]?(?:(stable|beta|b|RC|alpha|a|patch|pl|p)((?:[.-]?\\d+)*+)?)?([.-]?dev)?';
    private static $stabilitiesRegex = 'stable|RC|beta|alpha|dev';
    public static function parseStability($version)
    {
        $version = \preg_replace('{#.+$}i', '', $version);
        if (\strpos($version, 'dev-') === 0 || '-dev' === \substr($version, -4)) {
            return 'dev';
        }
        \preg_match('{' . self::$modifierRegex . '(?:\\+.*)?$}i', \strtolower($version), $match);
        if (!empty($match[3])) {
            return 'dev';
        }
        if (!empty($match[1])) {
            if ('beta' === $match[1] || 'b' === $match[1]) {
                return 'beta';
            }
            if ('alpha' === $match[1] || 'a' === $match[1]) {
                return 'alpha';
            }
            if ('rc' === $match[1]) {
                return 'RC';
            }
        }
        return 'stable';
    }
    public static function normalizeStability($stability)
    {
        $stability = \strtolower($stability);
        return $stability === 'rc' ? 'RC' : $stability;
    }
    public function normalize($version, $fullVersion = null)
    {
        $version = \trim($version);
        $origVersion = $version;
        if (null === $fullVersion) {
            $fullVersion = $version;
        }
        if (\preg_match('{^([^,\\s]++) ++as ++([^,\\s]++)$}', $version, $match)) {
            $version = $match[1];
        }
        if (\preg_match('{@(?:' . self::$stabilitiesRegex . ')$}i', $version, $match)) {
            $version = \substr($version, 0, \strlen($version) - \strlen($match[0]));
        }
        if (\in_array($version, array('master', 'trunk', 'default'), \true)) {
            $version = 'dev-' . $version;
        }
        if (\stripos($version, 'dev-') === 0) {
            return 'dev-' . \substr($version, 4);
        }
        if (\preg_match('{^([^,\\s+]++)\\+[^\\s]++$}', $version, $match)) {
            $version = $match[1];
        }
        if (\preg_match('{^v?(\\d{1,5})(\\.\\d++)?(\\.\\d++)?(\\.\\d++)?' . self::$modifierRegex . '$}i', $version, $matches)) {
            $version = $matches[1] . (!empty($matches[2]) ? $matches[2] : '.0') . (!empty($matches[3]) ? $matches[3] : '.0') . (!empty($matches[4]) ? $matches[4] : '.0');
            $index = 5;
        } elseif (\preg_match('{^v?(\\d{4}(?:[.:-]?\\d{2}){1,6}(?:[.:-]?\\d{1,3})?)' . self::$modifierRegex . '$}i', $version, $matches)) {
            $version = \preg_replace('{\\D}', '.', $matches[1]);
            $index = 2;
        }
        if (isset($index)) {
            if (!empty($matches[$index])) {
                if ('stable' === $matches[$index]) {
                    return $version;
                }
                $version .= '-' . $this->expandStability($matches[$index]) . (!empty($matches[$index + 1]) ? \ltrim($matches[$index + 1], '.-') : '');
            }
            if (!empty($matches[$index + 2])) {
                $version .= '-dev';
            }
            return $version;
        }
        if (\preg_match('{(.*?)[.-]?dev$}i', $version, $match)) {
            try {
                $normalized = $this->normalizeBranch($match[1]);
                if (\strpos($normalized, 'dev-') === \false) {
                    return $normalized;
                }
            } catch (\Exception $e) {
            }
        }
        $extraMessage = '';
        if (\preg_match('{ +as +' . \preg_quote($version) . '(?:@(?:' . self::$stabilitiesRegex . '))?$}', $fullVersion)) {
            $extraMessage = ' in "' . $fullVersion . '", the alias must be an exact version';
        } elseif (\preg_match('{^' . \preg_quote($version) . '(?:@(?:' . self::$stabilitiesRegex . '))? +as +}', $fullVersion)) {
            $extraMessage = ' in "' . $fullVersion . '", the alias source must be an exact version, if it is a branch name you should prefix it with dev-';
        }
        throw new \UnexpectedValueException('Invalid version string "' . $origVersion . '"' . $extraMessage);
    }
    public function parseNumericAliasPrefix($branch)
    {
        if (\preg_match('{^(?P<version>(\\d++\\.)*\\d++)(?:\\.x)?-dev$}i', $branch, $matches)) {
            return $matches['version'] . '.';
        }
        return \false;
    }
    public function normalizeBranch($name)
    {
        $name = \trim($name);
        if (\preg_match('{^v?(\\d++)(\\.(?:\\d++|[xX*]))?(\\.(?:\\d++|[xX*]))?(\\.(?:\\d++|[xX*]))?$}i', $name, $matches)) {
            $version = '';
            for ($i = 1; $i < 5; ++$i) {
                $version .= isset($matches[$i]) ? \str_replace(array('*', 'X'), 'x', $matches[$i]) : '.x';
            }
            return \str_replace('x', '9999999', $version) . '-dev';
        }
        return 'dev-' . $name;
    }
    public function normalizeDefaultBranch($name)
    {
        if ($name === 'dev-master' || $name === 'dev-default' || $name === 'dev-trunk') {
            return '9999999-dev';
        }
        return $name;
    }
    public function parseConstraints($constraints)
    {
        $prettyConstraint = $constraints;
        $orConstraints = \preg_split('{\\s*\\|\\|?\\s*}', \trim($constraints));
        $orGroups = array();
        foreach ($orConstraints as $constraints) {
            $andConstraints = \preg_split('{(?<!^|as|[=>< ,]) *(?<!-)[, ](?!-) *(?!,|as|$)}', $constraints);
            if (\count($andConstraints) > 1) {
                $constraintObjects = array();
                foreach ($andConstraints as $constraint) {
                    foreach ($this->parseConstraint($constraint) as $parsedConstraint) {
                        $constraintObjects[] = $parsedConstraint;
                    }
                }
            } else {
                $constraintObjects = $this->parseConstraint($andConstraints[0]);
            }
            if (1 === \count($constraintObjects)) {
                $constraint = $constraintObjects[0];
            } else {
                $constraint = new MultiConstraint($constraintObjects);
            }
            $orGroups[] = $constraint;
        }
        $constraint = MultiConstraint::create($orGroups, \false);
        $constraint->setPrettyString($prettyConstraint);
        return $constraint;
    }
    private function parseConstraint($constraint)
    {
        if (\preg_match('{^([^,\\s]++) ++as ++([^,\\s]++)$}', $constraint, $match)) {
            $constraint = $match[1];
        }
        if (\preg_match('{^([^,\\s]*?)@(' . self::$stabilitiesRegex . ')$}i', $constraint, $match)) {
            $constraint = '' !== $match[1] ? $match[1] : '*';
            if ($match[2] !== 'stable') {
                $stabilityModifier = $match[2];
            }
        }
        if (\preg_match('{^(dev-[^,\\s@]+?|[^,\\s@]+?\\.x-dev)#.+$}i', $constraint, $match)) {
            $constraint = $match[1];
        }
        if (\preg_match('{^(v)?[xX*](\\.[xX*])*$}i', $constraint, $match)) {
            if (!empty($match[1]) || !empty($match[2])) {
                return array(new Constraint('>=', '0.0.0.0-dev'));
            }
            return array(new MatchAllConstraint());
        }
        $versionRegex = 'v?(\\d++)(?:\\.(\\d++|[xX*]))?(?:\\.(\\d++|[xX*]))?(?:\\.(\\d++|[xX*]))?' . self::$modifierRegex . '(?:\\+[^\\s]+)?';
        if (\preg_match('{^~>?' . $versionRegex . '$}i', $constraint, $matches)) {
            if (\strpos($constraint, '~>') === 0) {
                throw new \UnexpectedValueException('Could not parse version constraint ' . $constraint . ': ' . 'Invalid operator "~>", you probably meant to use the "~" operator');
            }
            if (isset($matches[4]) && '' !== $matches[4] && null !== $matches[4]) {
                $position = 4;
            } elseif (isset($matches[3]) && '' !== $matches[3] && null !== $matches[3]) {
                $position = 3;
            } elseif (isset($matches[2]) && '' !== $matches[2] && null !== $matches[2]) {
                $position = 2;
            } else {
                $position = 1;
            }
            for ($i = $position; $i >= 0; $i--) {
                if ($matches[$i] === 'x' || $matches[$i] === 'X' || $matches[$i] === '*') {
                    $matches[$i] = '9999999';
                }
            }
            $stabilitySuffix = '';
            if (empty($matches[5]) && empty($matches[7])) {
                $stabilitySuffix .= '-dev';
            }
            $lowVersion = $this->normalize(\substr($constraint . $stabilitySuffix, 1));
            $lowerBound = new Constraint('>=', $lowVersion);
            $highPosition = \max(1, $position - 1);
            $highVersion = $this->manipulateVersionString($matches, $highPosition, 1) . '-dev';
            $upperBound = new Constraint('<', $highVersion);
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^\\^' . $versionRegex . '($)}i', $constraint, $matches)) {
            if ('0' !== $matches[1] || '' === $matches[2] || null === $matches[2]) {
                $position = 1;
            } elseif ('0' !== $matches[2] || '' === $matches[3] || null === $matches[3]) {
                $position = 2;
            } else {
                $position = 3;
            }
            if ($position === 2 && ($matches[2] === 'x' || $matches[2] === 'X' || $matches[2] === '*')) {
                $position = 1;
            }
            $stabilitySuffix = '';
            if (empty($matches[5]) && empty($matches[7])) {
                $stabilitySuffix .= '-dev';
            }
            $lowVersion = $this->normalize(\substr($constraint . $stabilitySuffix, 1));
            $lowerBound = new Constraint('>=', $lowVersion);
            $highVersion = $this->manipulateVersionString($matches, $position, 1) . '-dev';
            $upperBound = new Constraint('<', $highVersion);
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^v?(\\d++)(?:\\.(\\d++))?(?:\\.(\\d++))?(?:\\.[xX*])++$}', $constraint, $matches)) {
            if (isset($matches[3]) && '' !== $matches[3] && null !== $matches[3]) {
                $position = 3;
            } elseif (isset($matches[2]) && '' !== $matches[2] && null !== $matches[2]) {
                $position = 2;
            } else {
                $position = 1;
            }
            $lowVersion = $this->manipulateVersionString($matches, $position) . '-dev';
            $highVersion = $this->manipulateVersionString($matches, $position, 1) . '-dev';
            if ($lowVersion === '0.0.0.0-dev') {
                return array(new Constraint('<', $highVersion));
            }
            return array(new Constraint('>=', $lowVersion), new Constraint('<', $highVersion));
        }
        if (\preg_match('{^(?P<from>' . $versionRegex . ') +- +(?P<to>' . $versionRegex . ')($)}i', $constraint, $matches)) {
            $lowStabilitySuffix = '';
            if (empty($matches[6]) && empty($matches[8])) {
                $lowStabilitySuffix = '-dev';
            }
            $lowVersion = $this->normalize($matches['from']);
            $lowerBound = new Constraint('>=', $lowVersion . $lowStabilitySuffix);
            $empty = function ($x) {
                return $x === 0 || $x === '0' ? \false : empty($x);
            };
            if (!$empty($matches[11]) && !$empty($matches[12]) || !empty($matches[14]) || !empty($matches[16])) {
                $highVersion = $this->normalize($matches['to']);
                $upperBound = new Constraint('<=', $highVersion);
            } else {
                $highMatch = array('', $matches[10], $matches[11], $matches[12], $matches[13]);
                $this->normalize($matches['to']);
                $highVersion = $this->manipulateVersionString($highMatch, $empty($matches[11]) ? 1 : 2, 1) . '-dev';
                $upperBound = new Constraint('<', $highVersion);
            }
            return array($lowerBound, $upperBound);
        }
        if (\preg_match('{^(<>|!=|>=?|<=?|==?)?\\s*(.*)}', $constraint, $matches)) {
            try {
                try {
                    $version = $this->normalize($matches[2]);
                } catch (\UnexpectedValueException $e) {
                    if (\substr($matches[2], -4) === '-dev') {
                        $version = $this->normalize('dev-' . \substr($matches[2], 0, -4));
                    } else {
                        throw $e;
                    }
                }
                $op = $matches[1] ?: '=';
                if ($op !== '==' && $op !== '=' && !empty($stabilityModifier) && self::parseStability($version) === 'stable') {
                    $version .= '-' . $stabilityModifier;
                } elseif ('<' === $op || '>=' === $op) {
                    if (!\preg_match('/-' . self::$modifierRegex . '$/', \strtolower($matches[2]))) {
                        if (\strpos($matches[2], 'dev-') !== 0) {
                            $version .= '-dev';
                        }
                    }
                }
                return array(new Constraint($matches[1] ?: '=', $version));
            } catch (\Exception $e) {
            }
        }
        $message = 'Could not parse version constraint ' . $constraint;
        if (isset($e)) {
            $message .= ': ' . $e->getMessage();
        }
        throw new \UnexpectedValueException($message);
    }
    private function manipulateVersionString($matches, $position, $increment = 0, $pad = '0')
    {
        for ($i = 4; $i > 0; --$i) {
            if ($i > $position) {
                $matches[$i] = $pad;
            } elseif ($i === $position && $increment) {
                $matches[$i] += $increment;
                if ($matches[$i] < 0) {
                    $matches[$i] = $pad;
                    --$position;
                    if ($i === 1) {
                        return null;
                    }
                }
            }
        }
        return $matches[1] . '.' . $matches[2] . '.' . $matches[3] . '.' . $matches[4];
    }
    private function expandStability($stability)
    {
        $stability = \strtolower($stability);
        switch ($stability) {
            case 'a':
                return 'alpha';
            case 'b':
                return 'beta';
            case 'p':
            case 'pl':
                return 'patch';
            case 'rc':
                return 'RC';
            default:
                return $stability;
        }
    }
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

interface ConstraintInterface
{
    public function matches(ConstraintInterface $provider);
    public function compile($operator);
    public function getUpperBound();
    public function getLowerBound();
    public function getPrettyString();
    public function setPrettyString($prettyString);
    public function __toString();
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

class MultiConstraint implements ConstraintInterface
{
    protected $constraints;
    protected $prettyString;
    protected $string;
    protected $conjunctive;
    protected $lowerBound;
    protected $upperBound;
    public function __construct(array $constraints, $conjunctive = \true)
    {
        if (\count($constraints) < 2) {
            throw new \InvalidArgumentException('Must provide at least two constraints for a MultiConstraint. Use ' . 'the regular Constraint class for one constraint only or MatchAllConstraint for none. You may use ' . 'MultiConstraint::create() which optimizes and handles those cases automatically.');
        }
        $this->constraints = $constraints;
        $this->conjunctive = $conjunctive;
    }
    public function getConstraints()
    {
        return $this->constraints;
    }
    public function isConjunctive()
    {
        return $this->conjunctive;
    }
    public function isDisjunctive()
    {
        return !$this->conjunctive;
    }
    public function compile($otherOperator)
    {
        $parts = array();
        foreach ($this->constraints as $constraint) {
            $code = $constraint->compile($otherOperator);
            if ($code === 'true') {
                if (!$this->conjunctive) {
                    return 'true';
                }
            } elseif ($code === 'false') {
                if ($this->conjunctive) {
                    return 'false';
                }
            } else {
                $parts[] = '(' . $code . ')';
            }
        }
        if (!$parts) {
            return $this->conjunctive ? 'true' : 'false';
        }
        return $this->conjunctive ? \implode('&&', $parts) : \implode('||', $parts);
    }
    public function matches(ConstraintInterface $provider)
    {
        if (\false === $this->conjunctive) {
            foreach ($this->constraints as $constraint) {
                if ($provider->matches($constraint)) {
                    return \true;
                }
            }
            return \false;
        }
        foreach ($this->constraints as $constraint) {
            if (!$provider->matches($constraint)) {
                return \false;
            }
        }
        return \true;
    }
    public function setPrettyString($prettyString)
    {
        $this->prettyString = $prettyString;
    }
    public function getPrettyString()
    {
        if ($this->prettyString) {
            return $this->prettyString;
        }
        return (string) $this;
    }
    public function __toString()
    {
        if ($this->string !== null) {
            return $this->string;
        }
        $constraints = array();
        foreach ($this->constraints as $constraint) {
            $constraints[] = (string) $constraint;
        }
        return $this->string = '[' . \implode($this->conjunctive ? ' ' : ' || ', $constraints) . ']';
    }
    public function getLowerBound()
    {
        $this->extractBounds();
        return $this->lowerBound;
    }
    public function getUpperBound()
    {
        $this->extractBounds();
        return $this->upperBound;
    }
    public static function create(array $constraints, $conjunctive = \true)
    {
        if (0 === \count($constraints)) {
            return new MatchAllConstraint();
        }
        if (1 === \count($constraints)) {
            return $constraints[0];
        }
        $optimized = self::optimizeConstraints($constraints, $conjunctive);
        if ($optimized !== null) {
            list($constraints, $conjunctive) = $optimized;
            if (\count($constraints) === 1) {
                return $constraints[0];
            }
        }
        return new self($constraints, $conjunctive);
    }
    private static function optimizeConstraints(array $constraints, $conjunctive)
    {
        if (!$conjunctive) {
            $left = $constraints[0];
            $mergedConstraints = array();
            $optimized = \false;
            for ($i = 1, $l = \count($constraints); $i < $l; $i++) {
                $right = $constraints[$i];
                if ($left instanceof MultiConstraint && $left->conjunctive && $right instanceof MultiConstraint && $right->conjunctive && ($left0 = (string) $left->constraints[0]) && $left0[0] === '>' && $left0[1] === '=' && ($left1 = (string) $left->constraints[1]) && $left1[0] === '<' && ($right0 = (string) $right->constraints[0]) && $right0[0] === '>' && $right0[1] === '=' && ($right1 = (string) $right->constraints[1]) && $right1[0] === '<' && \substr($left1, 2) === \substr($right0, 3)) {
                    $optimized = \true;
                    $left = new MultiConstraint(\array_merge(array($left->constraints[0], $right->constraints[1]), \array_slice($left->constraints, 2), \array_slice($right->constraints, 2)), \true);
                } else {
                    $mergedConstraints[] = $left;
                    $left = $right;
                }
            }
            if ($optimized) {
                $mergedConstraints[] = $left;
                return array($mergedConstraints, \false);
            }
        }
        return null;
    }
    private function extractBounds()
    {
        if (null !== $this->lowerBound) {
            return;
        }
        foreach ($this->constraints as $constraint) {
            if (null === $this->lowerBound && null === $this->upperBound) {
                $this->lowerBound = $constraint->getLowerBound();
                $this->upperBound = $constraint->getUpperBound();
                continue;
            }
            if ($constraint->getLowerBound()->compareTo($this->lowerBound, $this->isConjunctive() ? '>' : '<')) {
                $this->lowerBound = $constraint->getLowerBound();
            }
            if ($constraint->getUpperBound()->compareTo($this->upperBound, $this->isConjunctive() ? '<' : '>')) {
                $this->upperBound = $constraint->getUpperBound();
            }
        }
    }
}
<?php

namespace HumbugBox3150\Composer\Semver\Constraint;

class Constraint implements ConstraintInterface
{
    const OP_EQ = 0;
    const OP_LT = 1;
    const OP_LE = 2;
    const OP_GT = 3;
    const OP_GE = 4;
    const OP_NE = 5;
    /**
    @phpstan-var
    */
    private static $transOpStr = array('=' => self::OP_EQ, '==' => self::OP_EQ, '<' => self::OP_LT, '<=' => self::OP_LE, '>' => self::OP_GT, '>=' => self::OP_GE, '<>' => self::OP_NE, '!=' => self::OP_NE);
    /**
    @phpstan-var
    */
    private static $transOpInt = array(self::OP_EQ => '==', self::OP_LT => '<', self::OP_LE => '<=', self::OP_GT => '>', self::OP_GE => '>=', self::OP_NE => '!=');
    /**
    @phpstan-var
    */
    protected $operator;
    protected $version;
    protected $prettyString;
    protected $lowerBound;
    protected $upperBound;
    public function __construct($operator, $version)
    {
        if (!isset(self::$transOpStr[$operator])) {
            throw new \InvalidArgumentException(\sprintf('Invalid operator "%s" given, expected one of: %s', $operator, \implode(', ', self::getSupportedOperators())));
        }
        $this->operator = self::$transOpStr[$operator];
        $this->version = $version;
    }
    public function getVersion()
    {
        return $this->version;
    }
    public function getOperator()
    {
        return self::$transOpInt[$this->operator];
    }
    public function matches(ConstraintInterface $provider)
    {
        if ($provider instanceof self) {
            return $this->matchSpecific($provider);
        }
        return $provider->matches($this);
    }
    public function setPrettyString($prettyString)
    {
        $this->prettyString = $prettyString;
    }
    public function getPrettyString()
    {
        if ($this->prettyString) {
            return $this->prettyString;
        }
        return $this->__toString();
    }
    public static function getSupportedOperators()
    {
        return \array_keys(self::$transOpStr);
    }
    /**
    @phpstan-return
    */
    public static function getOperatorConstant($operator)
    {
        return self::$transOpStr[$operator];
    }
    public function versionCompare($a, $b, $operator, $compareBranches = \false)
    {
        if (!isset(self::$transOpStr[$operator])) {
            throw new \InvalidArgumentException(\sprintf('Invalid operator "%s" given, expected one of: %s', $operator, \implode(', ', self::getSupportedOperators())));
        }
        $aIsBranch = 'dev-' === \substr($a, 0, 4);
        $bIsBranch = 'dev-' === \substr($b, 0, 4);
        if ($operator === '!=' && ($aIsBranch || $bIsBranch)) {
            return $a !== $b;
        }
        if ($aIsBranch && $bIsBranch) {
            return $operator === '==' && $a === $b;
        }
        if (!$compareBranches && ($aIsBranch || $bIsBranch)) {
            return \false;
        }
        return \version_compare($a, $b, $operator);
    }
    public function compile($otherOperator)
    {
        if ($this->version[0] === 'd' && 'dev-' === \substr($this->version, 0, 4)) {
            if (self::OP_EQ === $this->operator) {
                if (self::OP_EQ === $otherOperator) {
                    return \sprintf('$b && $v === %s', \var_export($this->version, \true));
                }
                if (self::OP_NE === $otherOperator) {
                    return \sprintf('!$b || $v !== %s', \var_export($this->version, \true));
                }
                return 'false';
            }
            if (self::OP_NE === $this->operator) {
                if (self::OP_EQ === $otherOperator) {
                    return \sprintf('!$b || $v !== %s', \var_export($this->version, \true));
                }
                if (self::OP_NE === $otherOperator) {
                    return 'true';
                }
                return '!$b';
            }
            return 'false';
        }
        if (self::OP_EQ === $this->operator) {
            if (self::OP_EQ === $otherOperator) {
                return \sprintf('\\version_compare($v, %s, \'==\')', \var_export($this->version, \true));
            }
            if (self::OP_NE === $otherOperator) {
                return \sprintf('$b || \\version_compare($v, %s, \'!=\')', \var_export($this->version, \true));
            }
            return \sprintf('!$b && \\version_compare(%s, $v, \'%s\')', \var_export($this->version, \true), self::$transOpInt[$otherOperator]);
        }
        if (self::OP_NE === $this->operator) {
            if (self::OP_EQ === $otherOperator) {
                return \sprintf('$b || (!$b && \\version_compare($v, %s, \'!=\'))', \var_export($this->version, \true));
            }
            if (self::OP_NE === $otherOperator) {
                return 'true';
            }
            return '!$b';
        }
        if (self::OP_LT === $this->operator || self::OP_LE === $this->operator) {
            if (self::OP_LT === $otherOperator || self::OP_LE === $otherOperator) {
                return '!$b';
            }
        } elseif (self::OP_GT === $this->operator || self::OP_GE === $this->operator) {
            if (self::OP_GT === $otherOperator || self::OP_GE === $otherOperator) {
                return '!$b';
            }
        }
        if (self::OP_NE === $otherOperator) {
            return 'true';
        }
        $codeComparison = \sprintf('\\version_compare($v, %s, \'%s\')', \var_export($this->version, \true), self::$transOpInt[$this->operator]);
        if ($this->operator === self::OP_LE) {
            if ($otherOperator === self::OP_GT) {
                return \sprintf('!$b && \\version_compare($v, %s, \'!=\') && ', \var_export($this->version, \true)) . $codeComparison;
            }
        } elseif ($this->operator === self::OP_GE) {
            if ($otherOperator === self::OP_LT) {
                return \sprintf('!$b && \\version_compare($v, %s, \'!=\') && ', \var_export($this->version, \true)) . $codeComparison;
            }
        }
        return \sprintf('!$b && %s', $codeComparison);
    }
    public function matchSpecific(Constraint $provider, $compareBranches = \false)
    {
        $noEqualOp = \str_replace('=', '', self::$transOpInt[$this->operator]);
        $providerNoEqualOp = \str_replace('=', '', self::$transOpInt[$provider->operator]);
        $isEqualOp = self::OP_EQ === $this->operator;
        $isNonEqualOp = self::OP_NE === $this->operator;
        $isProviderEqualOp = self::OP_EQ === $provider->operator;
        $isProviderNonEqualOp = self::OP_NE === $provider->operator;
        if ($isNonEqualOp || $isProviderNonEqualOp) {
            if ($isNonEqualOp && !$isProviderNonEqualOp && !$isProviderEqualOp && 'dev-' === \substr($provider->version, 0, 4)) {
                return \false;
            }
            if ($isProviderNonEqualOp && !$isNonEqualOp && !$isEqualOp && 'dev-' === \substr($this->version, 0, 4)) {
                return \false;
            }
            if (!$isEqualOp && !$isProviderEqualOp) {
                return \true;
            }
            return $this->versionCompare($provider->version, $this->version, '!=', $compareBranches);
        }
        if ($this->operator !== self::OP_EQ && $noEqualOp === $providerNoEqualOp) {
            if ('dev-' === \substr($this->version, 0, 4) || 'dev-' === \substr($provider->version, 0, 4)) {
                return \false;
            }
            return \true;
        }
        $version1 = $isEqualOp ? $this->version : $provider->version;
        $version2 = $isEqualOp ? $provider->version : $this->version;
        $operator = $isEqualOp ? $provider->operator : $this->operator;
        if ($this->versionCompare($version1, $version2, self::$transOpInt[$operator], $compareBranches)) {
            return !(self::$transOpInt[$provider->operator] === $providerNoEqualOp && self::$transOpInt[$this->operator] !== $noEqualOp && \version_compare($provider->version, $this->version, '=='));
        }
        return \false;
    }
    public function __toString()
    {
        return self::$transOpInt[$this->operator] . ' ' . $this->version;
    }
    public function getLowerBound()
    {
        $this->extractBounds();
        return $this->lowerBound;
    }
    public function getUpperBound()
    {
        $this->extractBounds();
        return $this->upperBound;
    }
    private function extractBounds()
    {
        if (null !== $this->lowerBound) {
            return;
        }
        if (\strpos($this->version, 'dev-') === 0) {
            $this->lowerBound = Bound::zero();
            $this->upperBound = Bound::positiveInfinity();
            return;
        }
        switch ($this->operator) {
            case self::OP_EQ:
                $this->lowerBound = new Bound($this->version, \true);
                $this->upperBound = new Bound($this->version, \true);
                break;
            case self::OP_LT:
                $this->lowerBound = Bound::zero();
                $this->upperBound = new Bound($this->version, \false);
                break;
            case self::OP_LE:
                $this->lowerBound = Bound::zero();
                $this->upperBound = new Bound($this->version, \true);
                break;
            case self::OP_GT:
                $this->lowerBound = new Bound($this->version, \false);
                $this->upperBound = Bound::positiveInfinity();
                break;
            case self::OP_GE:
                $this->lowerBound = new Bound($this->version, \true);
                $this->upperBound = Bound::positiveInfinity();
                break;
            case self::OP_NE:
                $this->lowerBound = Bound::zero();
                $this->upperBound = Bound::positiveInfinity();
                break;
        }
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

class Terminal
{
    private static $width;
    private static $height;
    private static $stty;
    public function getWidth()
    {
        $width = \getenv('COLUMNS');
        if (\false !== $width) {
            return (int) \trim($width);
        }
        if (null === self::$width) {
            self::initDimensions();
        }
        return self::$width ?: 80;
    }
    public function getHeight()
    {
        $height = \getenv('LINES');
        if (\false !== $height) {
            return (int) \trim($height);
        }
        if (null === self::$height) {
            self::initDimensions();
        }
        return self::$height ?: 50;
    }
    public static function hasSttyAvailable()
    {
        if (null !== self::$stty) {
            return self::$stty;
        }
        if (!\function_exists('exec')) {
            return \false;
        }
        \exec('stty 2>&1', $output, $exitcode);
        return self::$stty = 0 === $exitcode;
    }
    private static function initDimensions()
    {
        if ('\\' === \DIRECTORY_SEPARATOR) {
            if (\preg_match('/^(\\d+)x(\\d+)(?: \\((\\d+)x(\\d+)\\))?$/', \trim(\getenv('ANSICON')), $matches)) {
                self::$width = (int) $matches[1];
                self::$height = isset($matches[4]) ? (int) $matches[4] : (int) $matches[2];
            } elseif (!self::hasVt100Support() && self::hasSttyAvailable()) {
                self::initDimensionsUsingStty();
            } elseif (null !== ($dimensions = self::getConsoleMode())) {
                self::$width = (int) $dimensions[0];
                self::$height = (int) $dimensions[1];
            }
        } else {
            self::initDimensionsUsingStty();
        }
    }
    private static function hasVt100Support()
    {
        return \function_exists('sapi_windows_vt100_support') && \sapi_windows_vt100_support(\fopen('php://stdout', 'wb'));
    }
    private static function initDimensionsUsingStty()
    {
        if ($sttyString = self::getSttyColumns()) {
            if (\preg_match('/rows.(\\d+);.columns.(\\d+);/i', $sttyString, $matches)) {
                self::$width = (int) $matches[2];
                self::$height = (int) $matches[1];
            } elseif (\preg_match('/;.(\\d+).rows;.(\\d+).columns/i', $sttyString, $matches)) {
                self::$width = (int) $matches[2];
                self::$height = (int) $matches[1];
            }
        }
    }
    private static function getConsoleMode()
    {
        $info = self::readFromProcess('mode CON');
        if (null === $info || !\preg_match('/--------+\\r?\\n.+?(\\d+)\\r?\\n.+?(\\d+)\\r?\\n/', $info, $matches)) {
            return null;
        }
        return array((int) $matches[2], (int) $matches[1]);
    }
    private static function getSttyColumns()
    {
        return self::readFromProcess('stty -a | grep columns');
    }
    private static function readFromProcess($command)
    {
        if (!\function_exists('proc_open')) {
            return null;
        }
        $descriptorspec = array(1 => array('pipe', 'w'), 2 => array('pipe', 'w'));
        $process = \proc_open($command, $descriptorspec, $pipes, null, null, array('suppress_errors' => \true));
        if (!\is_resource($process)) {
            return null;
        }
        $info = \stream_get_contents($pipes[1]);
        \fclose($pipes[1]);
        \fclose($pipes[2]);
        \proc_close($process);
        return $info;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class IO
{
    const VERBOSITY_QUIET = 16;
    const VERBOSITY_NORMAL = 32;
    const VERBOSITY_VERBOSE = 64;
    const VERBOSITY_VERY_VERBOSE = 128;
    const VERBOSITY_DEBUG = 256;
    private $interactive;
    private $verbosity = self::VERBOSITY_NORMAL;
    private $colorSupport;
    private $options;
    public function __construct()
    {
        $this->options = \implode(' ', $_SERVER['argv']);
        $shellVerbosity = $this->configureVerbosity();
        $this->interactive = $this->checkInteractivity($shellVerbosity);
        $this->colorSupport = $this->checkColorSupport();
    }
    public function isInteractive()
    {
        return $this->interactive;
    }
    public function getVerbosity()
    {
        return $this->verbosity;
    }
    public function hasColorSupport()
    {
        return $this->colorSupport;
    }
    public function hasParameter($values)
    {
        $values = (array) $values;
        foreach ($values as $value) {
            $regexp = \sprintf('/\\s%s\\b/', \str_replace(' ', '\\s+', \preg_quote($value, '/')));
            if (1 === \preg_match($regexp, $this->options)) {
                return \true;
            }
        }
        return \false;
    }
    private function checkInteractivity($shellVerbosity)
    {
        if (-1 === $shellVerbosity) {
            return \false;
        }
        if (\true === $this->hasParameter(array('--no-interaction', '-n'))) {
            return \false;
        }
        if (\function_exists('posix_isatty') && !@\posix_isatty(\STDOUT) && \false === \getenv('SHELL_INTERACTIVE')) {
            return \false;
        }
        return \true;
    }
    private function configureVerbosity()
    {
        switch ($shellVerbosity = (int) \getenv('SHELL_VERBOSITY')) {
            case -1:
                $this->verbosity = self::VERBOSITY_QUIET;
                break;
            case 1:
                $this->verbosity = self::VERBOSITY_VERBOSE;
                break;
            case 2:
                $this->verbosity = self::VERBOSITY_VERY_VERBOSE;
                break;
            case 3:
                $this->verbosity = self::VERBOSITY_DEBUG;
                break;
            default:
                $shellVerbosity = 0;
                break;
        }
        if ($this->hasParameter(array('--quiet', '-q'))) {
            $this->verbosity = self::VERBOSITY_QUIET;
            $shellVerbosity = -1;
        } elseif ($this->hasParameter(array('-vvv', '--verbose=3', '--verbose 3'))) {
            $this->verbosity = self::VERBOSITY_DEBUG;
            $shellVerbosity = 3;
        } elseif ($this->hasParameter(array('-vv', '--verbose=2', '--verbose 2'))) {
            $this->verbosity = self::VERBOSITY_VERY_VERBOSE;
            $shellVerbosity = 2;
        } elseif ($this->hasParameter(array('-v', '--verbose=1', '--verbose 1', '--verbose'))) {
            $this->verbosity = self::VERBOSITY_VERBOSE;
            $shellVerbosity = 1;
        }
        return $shellVerbosity;
    }
    private function checkColorSupport()
    {
        if ($this->hasParameter(array('--ansi'))) {
            return \true;
        }
        if ($this->hasParameter(array('--no-ansi'))) {
            return \false;
        }
        if (\DIRECTORY_SEPARATOR === '\\') {
            return \function_exists('sapi_windows_vt100_support') && \sapi_windows_vt100_support(\STDOUT) || \false !== \getenv('ANSICON') || 'ON' === \getenv('ConEmuANSI') || 'xterm' === \getenv('TERM');
        }
        if (\function_exists('stream_isatty')) {
            return \stream_isatty(\STDOUT);
        }
        if (\function_exists('posix_isatty')) {
            return \posix_isatty(\STDOUT);
        }
        $stat = \fstat(\STDOUT);
        return $stat ? 020000 === ($stat['mode'] & 0170000) : \false;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class IsExtensionFulfilled implements IsFulfilled
{
    private $requiredExtension;
    public function __construct($requiredExtension)
    {
        $this->requiredExtension = $requiredExtension;
    }
    public function __invoke()
    {
        return \extension_loaded($this->requiredExtension);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Checker
{
    private static $requirementsConfig;
    public static function checkRequirements()
    {
        $requirements = self::retrieveRequirements();
        $checkPassed = $requirements->evaluateRequirements();
        $io = new IO();
        self::printCheck($checkPassed, new Printer($io->getVerbosity(), $io->hasColorSupport()), $requirements);
        return $checkPassed;
    }
    public static function printCheck($checkPassed, Printer $printer, RequirementCollection $requirements)
    {
        if (\false === $checkPassed && IO::VERBOSITY_VERY_VERBOSE > $printer->getVerbosity()) {
            $printer->setVerbosity(IO::VERBOSITY_VERY_VERBOSE);
        }
        $verbosity = IO::VERBOSITY_VERY_VERBOSE;
        $iniPath = $requirements->getPhpIniPath();
        $printer->title('Box Requirements Checker', $verbosity);
        $printer->printv('> Using PHP ', $verbosity);
        $printer->printvln(\PHP_VERSION, $verbosity, 'green');
        $printer->printvln('> PHP is using the following php.ini file:', $verbosity);
        if ($iniPath) {
            $printer->printvln('  ' . $iniPath, $verbosity, 'green');
        } else {
            $printer->printvln('  WARNING: No configuration file (php.ini) used by PHP!', $verbosity, 'yellow');
        }
        $printer->printvln('', $verbosity);
        if (\count($requirements) > 0) {
            $printer->printvln('> Checking Box requirements:', $verbosity);
            $printer->printv('  ', $verbosity);
        } else {
            $printer->printvln('> No requirements found.', $verbosity);
        }
        $errorMessages = array();
        foreach ($requirements->getRequirements() as $requirement) {
            if ($errorMessage = $printer->getRequirementErrorMessage($requirement)) {
                if (IO::VERBOSITY_DEBUG === $printer->getVerbosity()) {
                    $printer->printvln('✘ ' . $requirement->getTestMessage(), IO::VERBOSITY_DEBUG, 'red');
                    $printer->printv('  ', IO::VERBOSITY_DEBUG);
                    $errorMessages[] = $errorMessage;
                } else {
                    $printer->printv('E', $verbosity, 'red');
                    $errorMessages[] = $errorMessage;
                }
                continue;
            }
            if (IO::VERBOSITY_DEBUG === $printer->getVerbosity()) {
                $printer->printvln('✔ ' . $requirement->getHelpText(), IO::VERBOSITY_DEBUG, 'green');
                $printer->printv('  ', IO::VERBOSITY_DEBUG);
            } else {
                $printer->printv('.', $verbosity, 'green');
            }
        }
        if (IO::VERBOSITY_DEBUG !== $printer->getVerbosity() && \count($requirements) > 0) {
            $printer->printvln('', $verbosity);
        }
        if ($requirements->evaluateRequirements()) {
            $printer->block('OK', 'Your system is ready to run the application.', $verbosity, 'success');
        } else {
            $printer->block('ERROR', 'Your system is not ready to run the application.', $verbosity, 'error');
            $printer->title('Fix the following mandatory requirements:', $verbosity, 'red');
            foreach ($errorMessages as $errorMessage) {
                $printer->printv(' * ' . $errorMessage, $verbosity);
            }
        }
        $printer->printvln('', $verbosity);
    }
    private static function retrieveRequirements()
    {
        if (null === self::$requirementsConfig) {
            self::$requirementsConfig = __DIR__ . '/../.requirements.php';
        }
        $config = (require self::$requirementsConfig);
        $requirements = new RequirementCollection();
        foreach ($config as $constraint) {
            $requirements->addRequirement('php' === $constraint['type'] ? new IsPhpVersionFulfilled($constraint['condition']) : new IsExtensionFulfilled($constraint['condition']), $constraint['message'], $constraint['helpMessage']);
        }
        return $requirements;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

use HumbugBox3150\Composer\Semver\Semver;
final class IsPhpVersionFulfilled implements IsFulfilled
{
    private $requiredPhpVersion;
    public function __construct($requiredPhpVersion)
    {
        $this->requiredPhpVersion = $requiredPhpVersion;
    }
    public function __invoke()
    {
        return Semver::satisfies(\sprintf('%d.%d.%d', \PHP_MAJOR_VERSION, \PHP_MINOR_VERSION, \PHP_RELEASE_VERSION), $this->requiredPhpVersion);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

use ArrayIterator;
use Countable;
use IteratorAggregate;
use ReturnTypeWillChange;
use Traversable;
final class RequirementCollection implements IteratorAggregate, Countable
{
    private $requirements = array();
    #[\ReturnTypeWillChange]
    public function getIterator()
    {
        return new ArrayIterator($this->requirements);
    }
    #[\ReturnTypeWillChange]
    public function count()
    {
        return \count($this->requirements);
    }
    public function add(Requirement $requirement)
    {
        $this->requirements[] = $requirement;
    }
    public function addRequirement($checkIsFulfilled, $testMessage, $helpText)
    {
        $this->add(new Requirement($checkIsFulfilled, $testMessage, $helpText));
    }
    public function getRequirements()
    {
        return $this->requirements;
    }
    public function getPhpIniPath()
    {
        return \get_cfg_var('cfg_file_path');
    }
    public function evaluateRequirements()
    {
        return \array_reduce($this->requirements, function ($checkPassed, Requirement $requirement) {
            return $checkPassed && $requirement->isFulfilled();
        }, \true);
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Printer
{
    private $styles = array('reset' => "\x1b[0m", 'red' => "\x1b[31m", 'green' => "\x1b[32m", 'yellow' => "\x1b[33m", 'title' => "\x1b[33m", 'error' => "\x1b[37;41m", 'success' => "\x1b[30;42m");
    private $verbosity;
    private $supportColors;
    private $width;
    public function __construct($verbosity, $supportColors, $width = null)
    {
        if (null === $width) {
            $terminal = new Terminal();
            $width = $terminal->getWidth();
        }
        $this->verbosity = $verbosity;
        $this->supportColors = $supportColors;
        $this->width = $width ?: 80;
    }
    public function getVerbosity()
    {
        return $this->verbosity;
    }
    public function setVerbosity($verbosity)
    {
        $this->verbosity = $verbosity;
    }
    public function title($title, $verbosity, $style = null)
    {
        if (null === $style) {
            $style = 'title';
        }
        $this->printvln('', $verbosity, $style);
        $this->printvln($title, $verbosity, $style);
        $this->printvln(\str_repeat('=', \min(\strlen($title), $this->width)), $verbosity, $style);
        $this->printvln('', $verbosity, $style);
    }
    public function getRequirementErrorMessage(Requirement $requirement)
    {
        if ($requirement->isFulfilled()) {
            return null;
        }
        $errorMessage = \wordwrap($requirement->getTestMessage(), $this->width - 3, \PHP_EOL . '   ') . \PHP_EOL;
        return $errorMessage;
    }
    public function block($title, $message, $verbosity, $style = null)
    {
        $prefix = ' [' . $title . '] ';
        $lineLength = $this->width - \strlen($prefix) - 1;
        if ($lineLength < 0) {
            $lineLength = 0;
        }
        $message = $prefix . \trim($message);
        $lines = array();
        $remainingMessage = $message;
        $wrapped = \wordwrap($remainingMessage, $lineLength, '¬');
        $wrapped = \explode('¬', $wrapped);
        do {
            $line = \array_shift($wrapped);
            if ($lines && $lineLength > 0) {
                $line = \str_repeat(' ', \strlen($prefix)) . \ltrim($line);
            }
            $lines[] = \str_pad($line, $this->width, ' ', \STR_PAD_RIGHT);
        } while (\count($wrapped));
        $this->printvln('', $verbosity);
        $this->printvln(\str_repeat(' ', $this->width), $verbosity, $style);
        foreach ($lines as $line) {
            $this->printvln($line, $verbosity, $style);
        }
        $this->printv(\str_repeat(' ', $this->width), $verbosity, $style);
        $this->printvln('', $verbosity);
    }
    public function printvln($message, $verbosity, $style = null)
    {
        $this->printv($message, $verbosity, $style);
        $this->printv(\PHP_EOL, $verbosity, null);
    }
    public function printv($message, $verbosity, $style = null)
    {
        if ($verbosity > $this->verbosity) {
            return;
        }
        $message = \wordwrap($message, $this->width);
        $message = \sprintf('%s%s%s', $this->supportColors && isset($this->styles[$style]) ? $this->styles[$style] : '', $message, $this->supportColors ? $this->styles['reset'] : '');
        echo $message;
    }
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

interface IsFulfilled
{
    public function __invoke();
}
<?php

namespace HumbugBox3150\KevinGH\RequirementChecker;

final class Requirement
{
    private $checkIsFulfilled;
    private $fulfilled;
    private $testMessage;
    private $helpText;
    public function __construct($checkIsFulfilled, $testMessage, $helpText)
    {
        $this->checkIsFulfilled = $checkIsFulfilled;
        $this->testMessage = $testMessage;
        $this->helpText = $helpText;
    }
    public function isFulfilled()
    {
        if (null === $this->fulfilled) {
            $this->fulfilled = $this->checkIsFulfilled->__invoke();
        }
        return (bool) $this->fulfilled;
    }
    public function getIsFullfilledChecker()
    {
        return $this->checkIsFulfilled;
    }
    public function getTestMessage()
    {
        return $this->testMessage;
    }
    public function getHelpText()
    {
        return $this->helpText;
    }
}
                   GNU LESSER GENERAL PUBLIC LICENSE
                       Version 3, 29 June 2007

 Copyright (C) 2007 Free Software Foundation, Inc. <http://fsf.org/>
 Everyone is permitted to copy and distribute verbatim copies
 of this license document, but changing it is not allowed.


  This version of the GNU Lesser General Public License incorporates
the terms and conditions of version 3 of the GNU General Public
License, supplemented by the additional permissions listed below.

  0. Additional Definitions.

  As used herein, "this License" refers to version 3 of the GNU Lesser
General Public License, and the "GNU GPL" refers to version 3 of the GNU
General Public License.

  "The Library" refers to a covered work governed by this License,
other than an Application or a Combined Work as defined below.

  An "Application" is any work that makes use of an interface provided
by the Library, but which is not otherwise based on the Library.
Defining a subclass of a class defined by the Library is deemed a mode
of using an interface provided by the Library.

  A "Combined Work" is a work produced by combining or linking an
Application with the Library.  The particular version of the Library
with which the Combined Work was made is also called the "Linked
Version".

  The "Minimal Corresponding Source" for a Combined Work means the
Corresponding Source for the Combined Work, excluding any source code
for portions of the Combined Work that, considered in isolation, are
based on the Application, and not on the Linked Version.

  The "Corresponding Application Code" for a Combined Work means the
object code and/or source code for the Application, including any data
and utility programs needed for reproducing the Combined Work from the
Application, but excluding the System Libraries of the Combined Work.

  1. Exception to Section 3 of the GNU GPL.

  You may convey a covered work under sections 3 and 4 of this License
without being bound by section 3 of the GNU GPL.

  2. Conveying Modified Versions.

  If you modify a copy of the Library, and, in your modifications, a
facility refers to a function or data to be supplied by an Application
that uses the facility (other than as an argument passed when the
facility is invoked), then you may convey a copy of the modified
version:

   a) under this License, provided that you make a good faith effort to
   ensure that, in the event an Application does not supply the
   function or data, the facility still operates, and performs
   whatever part of its purpose remains meaningful, or

   b) under the GNU GPL, with none of the additional permissions of
   this License applicable to that copy.

  3. Object Code Incorporating Material from Library Header Files.

  The object code form of an Application may incorporate material from
a header file that is part of the Library.  You may convey such object
code under terms of your choice, provided that, if the incorporated
material is not limited to numerical parameters, data structure
layouts and accessors, or small macros, inline functions and templates
(ten or fewer lines in length), you do both of the following:

   a) Give prominent notice with each copy of the object code that the
   Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the object code with a copy of the GNU GPL and this license
   document.

  4. Combined Works.

  You may convey a Combined Work under terms of your choice that,
taken together, effectively do not restrict modification of the
portions of the Library contained in the Combined Work and reverse
engineering for debugging such modifications, if you also do each of
the following:

   a) Give prominent notice with each copy of the Combined Work that
   the Library is used in it and that the Library and its use are
   covered by this License.

   b) Accompany the Combined Work with a copy of the GNU GPL and this license
   document.

   c) For a Combined Work that displays copyright notices during
   execution, include the copyright notice for the Library among
   these notices, as well as a reference directing the user to the
   copies of the GNU GPL and this license document.

   d) Do one of the following:

       0) Convey the Minimal Corresponding Source under the terms of this
       License, and the Corresponding Application Code in a form
       suitable for, and under terms that permit, the user to
       recombine or relink the Application with a modified version of
       the Linked Version to produce a modified Combined Work, in the
       manner specified by section 6 of the GNU GPL for conveying
       Corresponding Source.

       1) Use a suitable shared library mechanism for linking with the
       Library.  A suitable mechanism is one that (a) uses at run time
       a copy of the Library already present on the user's computer
       system, and (b) will operate properly with a modified version
       of the Library that is interface-compatible with the Linked
       Version.

   e) Provide Installation Information, but only if you would otherwise
   be required to provide such information under section 6 of the
   GNU GPL, and only to the extent that such information is
   necessary to install and execute a modified version of the
   Combined Work produced by recombining or relinking the
   Application with a modified version of the Linked Version. (If
   you use option 4d0, the Installation Information must accompany
   the Minimal Corresponding Source and Corresponding Application
   Code. If you use option 4d1, you must provide the Installation
   Information in the manner specified by section 6 of the GNU GPL
   for conveying Corresponding Source.)

  5. Combined Libraries.

  You may place library facilities that are a work based on the
Library side by side in a single library together with other library
facilities that are not Applications and are not covered by this
License, and convey such a combined library under terms of your
choice, if you do both of the following:

   a) Accompany the combined library with a copy of the same work based
   on the Library, uncombined with any other library facilities,
   conveyed under the terms of this License.

   b) Give prominent notice with the combined library that part of it
   is a work based on the Library, and explaining where to find the
   accompanying uncombined form of the same work.

  6. Revised Versions of the GNU Lesser General Public License.

  The Free Software Foundation may publish revised and/or new versions
of the GNU Lesser General Public License from time to time. Such new
versions will be similar in spirit to the present version, but may
differ in detail to address new problems or concerns.

  Each version is given a distinguishing version number. If the
Library as you received it specifies that a certain numbered version
of the GNU Lesser General Public License "or any later version"
applies to it, you have the option of following the terms and
conditions either of that published version or of any later version
published by the Free Software Foundation. If the Library as you
received it does not specify a version number of the GNU Lesser
General Public License, you may choose any version of the GNU Lesser
General Public License ever published by the Free Software Foundation.

  If the Library as you received it specifies that a proxy can decide
whether future versions of the GNU Lesser General Public License shall
apply, that proxy's public statement of acceptance of any version is
permanent authorization for you to choose that version for the
Library.
<!doctype html><html lang="en"><head><meta charset="utf-8"><title>Contao Manager</title><meta http-equiv="X-UA-Compatible" content="IE=edge"><meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1"/><meta name="description" content=""><meta name="robots" content="noindex,follow"><meta http-equiv="Content-Security-Policy" content="img-src 'self' data: blob: contao.github.io extensions.contao.org; object-src 'none'"/><link rel="icon" type="image/x-icon" href="assets/favicon.ico"><link rel="icon" type="image/png" sizes="16x16" href="assets/favicon-16x16.png"><link rel="icon" type="image/png" sizes="32x32" href="assets/favicon-32x32.png"><link rel="icon" type="image/png" sizes="48x48" href="assets/favicon-48x48.png"><link rel="manifest" href="assets/manifest.webmanifest"><meta name="mobile-web-app-capable" content="yes"><meta name="theme-color" content="#ffffff"><meta name="application-name" content="Contao Manager"><link rel="apple-touch-icon" sizes="57x57" href="assets/apple-touch-icon-57x57.png"><link rel="apple-touch-icon" sizes="60x60" href="assets/apple-touch-icon-60x60.png"><link rel="apple-touch-icon" sizes="72x72" href="assets/apple-touch-icon-72x72.png"><link rel="apple-touch-icon" sizes="76x76" href="assets/apple-touch-icon-76x76.png"><link rel="apple-touch-icon" sizes="114x114" href="assets/apple-touch-icon-114x114.png"><link rel="apple-touch-icon" sizes="120x120" href="assets/apple-touch-icon-120x120.png"><link rel="apple-touch-icon" sizes="144x144" href="assets/apple-touch-icon-144x144.png"><link rel="apple-touch-icon" sizes="152x152" href="assets/apple-touch-icon-152x152.png"><link rel="apple-touch-icon" sizes="167x167" href="assets/apple-touch-icon-167x167.png"><link rel="apple-touch-icon" sizes="180x180" href="assets/apple-touch-icon-180x180.png"><link rel="apple-touch-icon" sizes="1024x1024" href="assets/apple-touch-icon-1024x1024.png"><meta name="apple-mobile-web-app-capable" content="yes"><meta name="apple-mobile-web-app-status-bar-style" content="black-translucent"><meta name="apple-mobile-web-app-title" content="Contao Manager"><link rel="apple-touch-startup-image" media="(device-width: 320px) and (device-height: 568px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-640x1136.png"><link rel="apple-touch-startup-image" media="(device-width: 320px) and (device-height: 568px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1136x640.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 667px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-750x1334.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 667px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1334x750.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1125x2436.png"><link rel="apple-touch-startup-image" media="(device-width: 375px) and (device-height: 812px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2436x1125.png"><link rel="apple-touch-startup-image" media="(device-width: 390px) and (device-height: 844px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1170x2532.png"><link rel="apple-touch-startup-image" media="(device-width: 390px) and (device-height: 844px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2532x1170.png"><link rel="apple-touch-startup-image" media="(device-width: 393px) and (device-height: 852px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1179x2556.png"><link rel="apple-touch-startup-image" media="(device-width: 393px) and (device-height: 852px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2556x1179.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-828x1792.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-1792x828.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1242x2688.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 896px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2688x1242.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 736px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1242x2208.png"><link rel="apple-touch-startup-image" media="(device-width: 414px) and (device-height: 736px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2208x1242.png"><link rel="apple-touch-startup-image" media="(device-width: 428px) and (device-height: 926px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1284x2778.png"><link rel="apple-touch-startup-image" media="(device-width: 428px) and (device-height: 926px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2778x1284.png"><link rel="apple-touch-startup-image" media="(device-width: 430px) and (device-height: 932px) and (-webkit-device-pixel-ratio: 3) and (orientation: portrait)" href="assets/apple-touch-startup-image-1290x2796.png"><link rel="apple-touch-startup-image" media="(device-width: 430px) and (device-height: 932px) and (-webkit-device-pixel-ratio: 3) and (orientation: landscape)" href="assets/apple-touch-startup-image-2796x1290.png"><link rel="apple-touch-startup-image" media="(device-width: 744px) and (device-height: 1133px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1488x2266.png"><link rel="apple-touch-startup-image" media="(device-width: 744px) and (device-height: 1133px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2266x1488.png"><link rel="apple-touch-startup-image" media="(device-width: 768px) and (device-height: 1024px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1536x2048.png"><link rel="apple-touch-startup-image" media="(device-width: 768px) and (device-height: 1024px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2048x1536.png"><link rel="apple-touch-startup-image" media="(device-width: 810px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1620x2160.png"><link rel="apple-touch-startup-image" media="(device-width: 810px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2160x1620.png"><link rel="apple-touch-startup-image" media="(device-width: 820px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1640x2160.png"><link rel="apple-touch-startup-image" media="(device-width: 820px) and (device-height: 1080px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2160x1640.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1194px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1668x2388.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1194px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2388x1668.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1112px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-1668x2224.png"><link rel="apple-touch-startup-image" media="(device-width: 834px) and (device-height: 1112px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2224x1668.png"><link rel="apple-touch-startup-image" media="(device-width: 1024px) and (device-height: 1366px) and (-webkit-device-pixel-ratio: 2) and (orientation: portrait)" href="assets/apple-touch-startup-image-2048x2732.png"><link rel="apple-touch-startup-image" media="(device-width: 1024px) and (device-height: 1366px) and (-webkit-device-pixel-ratio: 2) and (orientation: landscape)" href="assets/apple-touch-startup-image-2732x2048.png"><meta name="msapplication-TileColor" content="#ffffff"><meta name="msapplication-TileImage" content="assets/mstile-144x144.png"><meta name="msapplication-config" content="assets/browserconfig.xml"><link rel="yandex-tableau-widget" href="assets/yandex-browser-manifest.json"><script defer="defer" src="js/chunk-vendors.65173aa8.js"></script><script defer="defer" src="js/app.6d458114.js"></script><link href="css/chunk-vendors.4e650cae.css" rel="stylesheet"><link href="css/app.78aea309.css" rel="stylesheet"></head><body><noscript><strong>We're sorry but the Contao Manager does not work without JavaScript enabled. Please enable it to continue.</strong></noscript></body></html><?php

declare(strict_types=1);

/*
 * This file is part of Contao Manager.
 *
 * (c) Contao Association
 *
 * @license LGPL-3.0-or-later
 */

use Contao\ManagerApi\ApiKernel;
use Contao\ManagerApi\HttpKernel\ApiProblemResponse;
use Symfony\Component\HttpFoundation\Request;

require __DIR__.'/../vendor/autoload.php';

try {
    // @phpstan-ignore identical.alwaysFalse
    $kernel = new ApiKernel('@symfony_env@' === 'prod' ? 'prod' : 'dev');

    $request = Request::createFromGlobals();
    $response = $kernel->handle($request);
    $response->send();
    $kernel->terminate($request, $response);
} catch (Throwable $throwable) {
    ApiProblemResponse::createFromException($throwable, '@symfony_env@' !== 'prod')->send();
}
.view-recovery__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0 10px;text-align:center}.view-recovery__icon{background:var(--contao);border-radius:10px;padding:10px}.view-recovery__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-recovery__content{margin:0 30px 50px}@media(min-width:960px){.view-recovery__content{margin-left:50px;margin-right:50px}}.view-recovery__description{font-weight:600;max-width:600px;margin:0 auto;text-align:center}.view-recovery__console{margin:30px 0 60px}.view-recovery__option{margin:50px 0 0;padding:20px 20px 30px;background:var(--table-odd-bg);text-align:center}.view-recovery__option h3{position:relative;top:-40px;margin-bottom:-25px;font-size:2em;font-weight:300}.view-recovery__option button{margin-top:1.5em}.view-recovery__failed{margin:10px 0;color:var(--btn-alert);font-weight:600}.boot-check{padding:10px}.boot-check:after{display:table;clear:both;content:""}.boot-check__icon{float:left}.boot-check__icon .sk-circle{width:34px;height:34px;margin:3px}.boot-check__icon svg{display:block;width:40px;height:40px}.boot-check__icon--success svg{fill:var(--btn-primary)}.boot-check__icon--info svg,.boot-check__icon--warning svg{fill:var(--btn-warning)}.boot-check__icon--error svg{fill:var(--btn-alert)}.boot-check__label{margin-left:50px}.boot-check__description,.boot-check__detail,.boot-check__title{margin:0;line-height:inherit;overflow:hidden;text-overflow:ellipsis}.boot-check__detail{margin-top:5px;font-size:12px}.boot-check__action{margin-left:50px}.boot-check__action button{margin:15px 0 10px;height:33px;line-height:33px}@media(min-width:960px){.boot-check__label{float:left;width:540px;margin-left:10px}.boot-check__action{float:right;margin:0 0 0 10px;width:140px;text-align:center}.boot-check__action button{margin:3px 0}.boot-check__action a[target=_blank]{display:inline-block;margin:10px 0;padding-left:20px;background:var(--svg--link-blank) left center no-repeat;background-size:16px 16px}}.view-boot__header{margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.view-boot__icon{background:var(--contao);border-radius:10px;padding:10px}.view-boot__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-boot__description{margin:0;font-weight:600}.view-boot__loading{width:30px;margin:0 auto 40px}.view-boot__loading .sk-circle{width:30px;height:30px}.view-boot__checks{margin:0 16px 50px}.view-boot__checks .boot-check:nth-child(odd){border-radius:var(--border-radius);background:var(--table-odd-bg)}.view-boot__summary{margin:50px 0 0}.view-boot__summary--error svg{width:100%;height:40px;fill:var(--btn-alert)}.view-boot__issue{max-width:60%;margin:10px auto;text-align:center;color:var(--btn-alert);line-height:1.2em}.view-boot__safeMode{margin:2em auto 0}.view-boot__continue,.view-boot__safeMode{clear:both;display:block!important;width:220px!important}.view-boot__continue{margin:0 auto}@media(min-width:960px){.view-boot__checks{margin:0 80px 50px}}body.nav-active{overflow:hidden!important}#app{transition:transform .4s cubic-bezier(.55,0,.1,1)}.nav-active #app{overflow-y:visible;transform:translateX(-280px)}.nav-active #app .navigation__group--main{visibility:visible}@media(min-width:1024px){.nav-active #app{transform:none}}.navigation__toggle{display:block;float:right;position:relative;margin:5px 15px;padding:0;width:30px;height:30px;background:none;border:none;cursor:pointer;z-index:20}.navigation__toggle span,.navigation__toggle span:after,.navigation__toggle span:before{content:"";display:block;width:100%;height:4px;background:var(--text);border-radius:4px;position:absolute}.navigation__toggle span{transition-duration:75ms;transition-timing-function:cubic-bezier(.215,.61,.355,1);top:50%;margin-top:-2px}.navigation__toggle span:before{top:-10px;transition:top 75ms ease .12s,opacity 75ms ease}.navigation__toggle span:after{bottom:-10px;transition:bottom 75ms ease .12s,transform 75ms cubic-bezier(.55,.055,.675,.19)}.nav-active .navigation__toggle span{transform:rotate(45deg);transition-delay:.12s;transition-timing-function:cubic-bezier(.215,.61,.355,1)}.nav-active .navigation__toggle span:before{top:0;opacity:0;transition:top 75ms ease,opacity 75ms ease .12s}.nav-active .navigation__toggle span:after{transition:bottom 75ms ease,transform 75ms cubic-bezier(.215,.61,.355,1) .12s;bottom:0;transform:rotate(-90deg)}.navigation__group,.navigation__item{list-style-type:none;margin:0;padding:0}.navigation__group--main{position:fixed;top:0;bottom:0;right:-280px;width:280px;visibility:hidden;padding:20px;overflow-y:auto;overflow-scrolling:touch;background:var(--header-main-bg);border-left:1px solid var(--header-bdr);z-index:10}.navigation__item a,.navigation__item button{display:block;margin:0;padding:12px 10px;font-size:16px;color:var(--text);white-space:pre;background:none;border:none}.navigation__item a:hover,.navigation__item button:hover{text-decoration:none}.navigation__item a[href]:hover,.navigation__item button[href]:hover{color:var(--link)}.navigation__item--main>a,.navigation__item--main>button{text-transform:uppercase}.navigation__item--sub>a{margin-left:15px}.navigation__item--icon svg{display:none}.navigation__item-badge{position:relative;top:-2px;margin-left:8px;padding:2px 5px;font-size:10px;color:var(--clr-btn);font-weight:600;background:var(--contao);border-radius:40%}@media(min-width:1024px){.navigation__toggle{display:none}.navigation__group--main{display:flex;visibility:visible;position:inherit;inset:auto;width:auto;padding:0;overflow:visible;background:none;border:none;box-shadow:none;transform:none;transition:none}.navigation__group--sub{position:absolute;left:50%;min-width:180px;margin-top:-3px;text-align:center;background:var(--form-bg);border-top:3px solid var(--link);border-radius:5px;transform:translateX(-50%);z-index:100;box-shadow:0 0 2px var(--shadow);transition:opacity var(--am-close-transition-duration) ease}.navigation__group--sub:before{position:absolute;left:50%;top:-7px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:0 3.5px 4px 3.5px;border-color:transparent transparent var(--link) transparent;content:""}.navigation__group--sub.hide{display:none!important}.navigation__group--sub.transitioning{display:block!important;opacity:0}.navigation__group--sub.show{display:block!important;opacity:1;transition:opacity var(--am-open-transition-duration) ease}.navigation__group--right{left:auto;right:7px;transform:translateX(0)}.navigation__group--right:before{left:auto;right:18px}.navigation__item{position:relative;padding:0 8px}.navigation__item.router-link-active>a,.navigation__item:hover>a{color:var(--link)!important;border-bottom:3px solid var(--link)}.navigation__item:hover>.navigation__group--sub{display:block}.navigation__item--sub{display:block;margin:calc(var(--border-radius)/2) 0;padding:0 2px;border-radius:var(--border-radius)}.navigation__item--sub a{margin:0;border:none!important}.navigation__item--sub.router-link-active,.navigation__item--sub:hover{background:var(--focus)}.navigation__item--sub.router-link-active a,.navigation__item--sub:hover a{color:var(--text)!important}.navigation__item--icon>button{padding-top:7px}.navigation__item--icon>button svg{display:inline;position:relative;top:4px;width:22px;height:22px;fill:var(--text)}.navigation__item--icon>button:hover svg{fill:var(--link)}.navigation__item--icon>button span{display:none}.navigation:hover li>a{border:none}.navigation:hover li:hover>a{border-bottom:3px solid var(--link)}.navigation:hover li:hover>a svg{fill:var(--link)}}.logout-warning{text-align:center}.logout-warning__countdown{margin:20px 0;font:600 4em/1.6 SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:var(--btn-warning)}.fragment-footer{width:280px;margin:10px auto 0;padding:15px 0 25px;font-size:12px;text-align:center;border-top:1px solid var(--footer-bdr)}.fragment-footer--main{width:auto;margin-top:52px!important;padding:20px 0}.fragment-footer--boxed{border-color:var(--footer-fragment-bdr)}.fragment-footer__product{font-weight:300}.fragment-footer__links{margin:5px 0 0;padding:0;list-style-type:none}.fragment-footer__links li{display:inline-block}.fragment-footer__links li:not(:first-child):before{content:"|";padding:0 10px 0 8px}.fragment-footer__links a{display:inline!important;color:var(--link-footer)}.fragment-footer__settings{margin-top:10px;display:flex;flex-flow:column;justify-content:center;gap:10px}@media(min-width:960px){.fragment-footer{display:grid;grid-auto-flow:column;grid-auto-columns:minmax(0,1fr);gap:16px;align-content:center}.fragment-footer--boxed .fragment-footer__product,.fragment-footer--main .fragment-footer__product{margin-right:auto}.fragment-footer--boxed .fragment-footer__links,.fragment-footer--main .fragment-footer__links{order:15;margin:0 0 0 auto}.fragment-footer--boxed .fragment-footer__settings,.fragment-footer--main .fragment-footer__settings{flex-flow:row;margin-top:0}.fragment-footer--boxed{width:840px}}.layout-main{overflow:hidden;min-height:100vh}.layout-main__header{display:flex;justify-content:space-between;height:56px;padding:8px;background:var(--header-main-bg)}.layout-main__header--margin{margin-bottom:30px}.layout-main__badge-title{background:var(--border);color:var(--text);padding:2px 5px;position:relative;top:-5px;border-radius:8px;font-size:.75rem;font-weight:600;line-height:1;display:-webkit-box;-webkit-line-clamp:1;line-clamp:1;-webkit-box-orient:vertical;word-break:break-word;overflow:hidden;text-overflow:ellipsis}.layout-main__subheader{margin:0 0 45px;padding:20px 0;background:var(--header-bg);border-bottom:1px solid var(--header-bdr)}.layout-main__subheader-inside{display:flex;justify-content:center;align-items:center;flex-direction:column}.layout-main__news{width:320px;height:50px;margin-bottom:20px}.layout-main__news a,.layout-main__news img{display:block}.layout-main .search-bar{width:100%;margin:0}.layout-main__logo{display:inline;color:var(--text);text-decoration:none;font-weight:100;font-size:27px;line-height:40px}.layout-main__logo img{float:left;margin:0 10px 0 12px}@media(min-width:1024px){.layout-main__logo img{margin-left:0}}.layout-main footer,.layout-main__content,.layout-main__subheader-inside{position:relative;margin:0 20px}.layout-main__has-badge-title{display:flex;justify-content:space-between}.layout-main__has-badge-title .layout-main__logo{display:flex}.layout-main__has-badge-title .layout-main__title{display:flex;flex-wrap:wrap;align-items:center;line-height:1;column-gap:10px;row-gap:5px}@media(max-width:600px){.layout-main__badge-title{max-width:220px}}@media(min-width:700px){.layout-main__subheader-inside{flex-direction:row}.layout-main__news{margin:0 20px 0 0}}@media(min-width:1024px){.layout-main__has-badge-title .navigation__group--main{display:flex}.layout-main footer,.layout-main__content,.layout-main__subheader-inside{max-width:960px;margin:0 auto}}@media(min-width:1200px){.layout-main footer,.layout-main__content,.layout-main__subheader-inside{max-width:1180px}}.confirm-button{position:relative}.confirm-button__icon{display:none;position:absolute;opacity:0;z-index:100}.confirm-button__icon--confirm{display:block;animation:confirm_button .5s ease-out 0s}.confirm-button__icon svg{fill:var(--btn-primary);width:100%;height:100%}@keyframes confirm_button{0%{opacity:1;height:10px;width:10px;left:calc(50% - 5px);top:calc(50% - 5px)}to{opacity:0;height:150px;width:150px;left:calc(50% - 75px);top:calc(50% - 75px)}}.package-tools{position:relative;clear:both;text-align:center}@media(min-width:800px){.package-tools{margin-bottom:40px}}.package-tools__button.widget-button{margin-bottom:10px}@media(min-width:800px){.package-tools{display:flex;justify-content:center;align-items:center}.package-tools__button.widget-button{width:auto;margin:0 15px;padding:0 15px}}.package-actions{position:fixed;left:0;right:0;bottom:0;max-height:0;background:#000;background:rgba(0,0,0,.8);color:#fff;transition:max-height .4s ease;z-index:100}.package-actions--active{max-height:200px}.package-actions__inner{display:flex;flex-wrap:wrap;justify-content:flex-end;align-items:center;margin:0;padding:12px;text-align:right}@media(min-width:1024px){.package-actions__inner{max-width:976px;margin:0 auto;padding-left:0;padding-right:0}}@media(min-width:1200px){.package-actions__inner{max-width:1196px}}.package-actions__text{flex-grow:1;display:initial;margin:0 8px;font-weight:600}.package-actions__button{display:block;padding:0 15px!important;margin:8px}.package-actions__button--dryRun{width:auto!important;flex-grow:1}@media(min-width:600px){.package-actions__button{width:auto!important}.package-actions__button--dryRun{flex-grow:0}}.package-actions__button-group{display:block;width:100%;margin:8px}.package-actions__button-group>.button-group__primary{padding:0 15px!important}@media(min-width:600px){.package-actions__button-group{width:auto!important}}.package{position:relative;margin-bottom:20px;background:var(--tiles-bg);border:1px solid var(--tiles-bdr);border-radius:14px}.package.is--hint{border-color:var(--btn-alert)}.package--contao:not(:last-child){margin-bottom:5em}.package__hint{position:relative;background:var(--hint-bg);padding:8px 16px;font-weight:400;font-size:12px;line-height:1.8;border-radius:14px 14px 0 0;z-index:1}.package__hint p a{display:inline-block;padding-right:10px}.package__hint p a:first-child{margin-left:10px}.package__hint p a:not(:first-child):before{padding-right:10px;content:"|"}.package__hint-close{float:right;padding-left:18px;color:var(--hint-link);background:url(../img/close.8b27dbcb.svg) 0 no-repeat;background-size:14px 14px}.package__inside{position:relative;padding:16px}.package__inside:after{display:table;clear:both;content:""}.package__badge{display:inline-block;margin-bottom:.5em;padding:2px 5px;color:#fff;font-size:12px;font-weight:600;background:var(--btn-alert);border-radius:var(--border-radius);cursor:help}.package__icon{border-radius:6px;height:60px;width:60px;background:#f7f7f7;margin:0 auto 10px;position:absolute;right:16px}.package__icon>figure{display:flex;align-items:center;justify-content:center;height:100%}.package__icon img,.package__icon svg{border-radius:4px;width:50px;height:50px;max-height:100%;object-fit:contain}.package__details{min-height:96px}.package__about{margin-bottom:20px}.package__headline{position:relative;margin-bottom:.2em;line-height:1;overflow-wrap:break-word;margin-right:70px}.package__headline em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.package__title{display:block;margin-right:10px}.package__description{display:-webkit-box;overflow:hidden;-webkit-line-clamp:2;-webkit-box-orient:vertical;margin-bottom:1em;margin-right:70px}.package__description em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.package__additional{margin-top:-5px}.package .package__release{text-align:right;margin-bottom:5px}.package__version--additional{margin-bottom:5px}.package__version--additional strong{margin-right:10px}.package__version--release{display:none}.package__version--release time{display:block}.package__version--missing{padding:4px 8px;background:var(--btn-alert);border-radius:var(--border-radius);color:#fff;font-weight:700}.package__version-update{display:inline-block;margin:0 0 2px;padding:1px 8px;color:#fff;border-radius:var(--border-radius)}.package__version-update--available{background:var(--btn-primary)}.package__version-update--error{background:var(--btn-alert)}.package__version-update--none{background:var(--border)}.package__version-latest{float:right;position:relative;right:-7px;width:24px;height:20px;background:var(--btn-primary) url(../img/button-update.ad79c617.svg) center center/20px 20px no-repeat}.package__actions{display:flex;flex-flow:column;gap:5px}.package__actions .button-group button{margin-bottom:0!important}@media(min-width:600px){.package__description,.package__title{margin-right:0}.package__hint{padding-left:52px;background:rgba(var(--hint-rgb),.9) url(../img/hint.ba2ac97e.svg) 12px 5px no-repeat;background-size:28px 28px}.package__inside{display:flex;align-items:stretch;padding:0}.package__headline--badge{display:flex;gap:6px;align-items:flex-start}.package__headline{margin:0 0 8px}.package__badge{order:1;margin:0 0 0 2px}.package__icon{width:130px;height:auto;min-height:130px;margin:0;border-radius:12px 0 0 12px;position:revert;right:revert}.package__icon img,.package__icon svg{width:110px;height:110px}.is--hint .package__icon{border-top-left-radius:0}.package--contao{overflow:hidden}.package--contao .package__icon{border-radius:0}.package__details{padding:16px;height:100%;min-height:90px;max-width:calc(100% - 130px);flex:1}.package.is--hint .package__icon{border-top-left-radius:0}}@media(min-width:680px){.package .package__release{display:block;float:left;width:33%}.package__actions{float:right;width:64%;flex-flow:row;gap:4%;text-align:right}.package__actions>*{flex:1}}@media(min-width:1024px){.package__version--additional{display:none}.package__version--release{display:block;margin-top:15px;text-align:center}.package__version-update{display:block;margin:2px 0 0}.package__about{float:left;width:396px;margin-bottom:0}.package .package__release{width:180px;margin-left:20px;margin-bottom:0}.package__actions{flex-flow:column;gap:10px;width:180px;margin-left:20px}.package__details{display:flex;align-self:center;align-items:flex-start}}@media(min-width:1200px){.package__about{width:616px}}.progress-bar{position:relative;width:100%;height:30px;background:var(--clr-btn);border:2px solid var(--btn-warning);color:#000;font-weight:600;text-align:center;line-height:26px}.progress-bar__bar{position:absolute;overflow:hidden;left:0;right:0;top:0;bottom:0;background:var(--btn-warning)}.progress-bar__bar span{display:block;color:var(--clr-btn);text-align:center}.feature-package{display:flex;flex-wrap:wrap;padding:6px 16px;border-top:1px solid var(--border--light)}.feature-package__name{font-weight:600;white-space:nowrap}.feature-package__name:after{content:": "}.feature-package__text{flex-grow:1;display:-webkit-box;overflow:hidden;-webkit-line-clamp:1;line-clamp:1;-webkit-box-orient:vertical;margin-right:.5em;padding:4px 0;line-height:20px}.feature-package__text--hint{display:inline;-webkit-line-clamp:none;line-clamp:none}.feature-package__badge{margin-left:5px;padding:2px 8px;background:var(--btn-alert);border-radius:var(--border-radius);font-size:12px;font-weight:600;line-height:19px;color:#fff;cursor:help}.feature-package__hint{line-height:1.2;padding:2px 5px;background:var(--hint-bg);font-size:12px}.feature-package__actions{flex-grow:1;display:flex;justify-content:flex-end;margin:0 -4px 0 0}.feature-package__actions>*{margin:0 4px}.feature-package__restore{padding-left:18px;font-size:12px;color:var(--hint-link);background:url(../img/close.8b27dbcb.svg) 0 no-repeat;background-size:14px 14px;border:none;cursor:pointer}.feature-package__restore:hover{text-decoration:underline}@media(min-width:800px){.feature-package{flex-wrap:nowrap}}@media(min-width:1024px){.feature-package__hint{padding:8px 10px 8px 36px;background:var(--hint-bg) url(../img/hint.ba2ac97e.svg) 10px 5px no-repeat;background-size:20px 20px}.feature-package__actions{margin:0 -4px 0 0}}.package-constraint input[type=text][data-v-45700166]{margin-right:2px;background:#fff;border:2px solid var(--btn-warning);color:var(--black);font-weight:600;text-align:center;border-top-right-radius:0;border-bottom-right-radius:0}.package-constraint input[type=text][data-v-45700166]::placeholder{color:#fff;-webkit-text-fill-color:#fff;opacity:1}.package-constraint input[type=text][data-v-45700166]:disabled{color:var(--clr-btn);opacity:1;background:var(--btn-warning);-webkit-text-fill-color:var(--clr-btn)}.package-constraint input[type=text].disabled[data-v-45700166]{background:var(--border);border-color:var(--border)}.package-constraint input[type=text].error[data-v-45700166]{animation:input-error .15s linear 3}.package-constraint>input[type=text][data-v-45700166],.package-constraint>input[type=text][data-v-45700166]:disabled{float:left;width:calc(100% - 32px)}.package-constraint button[data-v-45700166]{position:relative;width:30px;background:var(--btn-warning);line-height:20px;text-indent:-999em;border-top-left-radius:0;border-bottom-left-radius:0}.package-constraint button[data-v-45700166]:hover{background:var(--btn-warning-active);border-color:var(--btn-warning-active)}.package-constraint button[data-v-45700166]:before{position:absolute;left:50%;top:50%;margin:-10px 0 0 -10px}.package-constraint button.rotate[data-v-45700166]:before{animation:release-validating-45700166 2s linear infinite}@keyframes release-validating-45700166{to{transform:rotate(1turn)}}@media(min-width:1024px){.package-constraint button[data-v-45700166],.package-constraint input[type=text][data-v-45700166]{height:30px}}.button-group{display:flex;gap:1px;position:relative}.button-group__primary.widget-button{flex-grow:1;border-top-right-radius:0;border-bottom-right-radius:0}.button-group__more.widget-button{flex-shrink:0;width:38px;padding:7px;border-top-left-radius:0;border-bottom-left-radius:0}.button-group__more.widget-button svg{width:24px;height:24px}.button-group__group{position:absolute;top:39px;width:100%;padding-top:3px;z-index:100}.button-group__group:focus{outline:none}.button-group__group .widget-button{margin-top:1px}.button-group__group .link-menu{margin-top:3px}.button-group__group--top{top:auto;bottom:39px}.button-group__group--top .link-menu{margin-top:0;margin-bottom:3px}.composer-package__stats{display:inline-block;margin-right:15px;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.composer-package__stats--license{padding-left:0}.composer-package__stats--versions{display:inline-flex;flex-wrap:wrap;gap:5px;list-style:none;margin:0 15px 0 0;padding:0}.composer-package__stats--version{padding:3px 5px;line-height:1;border:1px solid var(--border);border-radius:4px}.composer-package__stats--funding{width:16px;background-image:url(../img/funding.cf78a0a0.svg);background-size:16px 16px;background-repeat:no-repeat;text-decoration:none!important}.package-uploads__overlay{top:0;bottom:0;right:0;left:0;position:fixed;z-index:9999;opacity:.6;text-align:center;background:#000}.package-uploads__overlay div{margin:-.5em 0 0;position:absolute;top:50%;left:0;right:0;transform:translateY(-50%);font-size:40px;color:#fff;padding:0}.cloud-status{margin-left:8px;position:relative}.cloud-status__button{margin-left:0;margin-right:0;padding-left:8px;cursor:help!important}.cloud-status__popup{position:absolute;text-align:center;left:0;bottom:54px;margin:0;padding:0 0 15px;outline:none;background:var(--form-bg);color:var(--text);border-bottom:3px solid var(--contao);border-radius:5px;box-shadow:0 0 2px var(--shadow);z-index:100}.cloud-status__popup:after{position:absolute;left:38px;bottom:-6px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:4px 3.5px 0 3.5px;border-color:var(--contao) transparent transparent transparent;content:""}.cloud-status__popup--error{color:var(--clr-btn);background-color:var(--btn-alert);border-color:var(--btn-alert)}.cloud-status__popup--error:after{left:27px;border-color:var(--btn-alert) transparent transparent transparent}.cloud-status__headline{padding:15px 20px 0;font-size:16px;white-space:pre}.cloud-status__version{margin:0 0 8px;font-size:12px}.cloud-status__link{display:inline-block;margin:15px 10px 0}.cloud-status__error{padding:8px 20px 8px;hyphens:auto}.cloud-status table{width:100%;margin-top:12px;text-align:left;border-spacing:0;border-collapse:collapse}.cloud-status th{padding:3px 5px 3px 20px}.cloud-status td{padding:3px 20px 3px 0}.cloud-status tr:nth-child(odd){background:var(--table-odd-bg)}.package-list{position:relative}.package-list__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.package-list__status .sk-circle{width:100px;height:100px;margin:0 auto 40px}.package-list__headline{font-size:18px;font-weight:300;margin:30px 0 10px}.animate-blur-in,.animate-blur-out,.layout-boxed{display:table;width:100%;height:100%}.layout-boxed__cell{display:table-cell;overflow:hidden;vertical-align:middle;padding:10px}.layout-boxed__container{position:relative;max-width:380px;margin:0 auto;background:var(--popup-bg);border-radius:8px}@media(min-width:960px){.layout-boxed__container{margin-top:20px;margin-bottom:20px}.layout-boxed__container--wide{max-width:940px}}.widget-checkbox input{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.widget-checkbox label{position:relative;display:block;padding-left:25px;text-align:left}.widget-checkbox label:before{content:"";position:absolute;left:0;width:20px;height:20px;background:url(../img/widget-checkbox--off.73856538.svg) 0 0 no-repeat;background-size:20px 20px}.widget-checkbox input:checked+label:before{background-image:url(../img/widget-checkbox--on.8b830157.svg)}.widget-checkbox input:focus-visible+label{outline:5px auto Highlight;outline:5px auto -webkit-focus-ring-color}.widget-checkbox input:disabled+label{opacity:.5}.widget-checkbox .widget__description{padding-left:25px}.widget-checkbox .widget__description--disabled{opacity:.5}.user-scope__label{margin:0;padding:0}.user-scope__item{padding:5px 0 0}.user-scope__item--required label{opacity:1!important}.user-scope__item--required label:before{opacity:.5}.view-oauth__header{max-width:280px;margin:0 auto 40px;padding-top:40px;text-align:center}.view-oauth__icon{background:var(--contao);border-radius:10px;padding:10px}.view-oauth__product{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-oauth__form{position:relative;max-width:280px;margin:0 auto 60px;text-align:center}.view-oauth__form input,.view-oauth__form select{margin:5px 0 10px}.view-oauth__description{margin-top:.5em;margin-bottom:.5em}.view-oauth__client{margin:1em 0;font-size:32px}.view-oauth__scopes{text-align:left}.view-oauth__warning{color:var(--btn-alert);margin-top:2em;margin-bottom:2em}.view-oauth__button{margin-top:1em}.view-oauth__button .sk-circle{color:#fff;text-align:center}.message-overlay{position:relative}.message-overlay__blur{opacity:.75;filter:blur(2px);transition:opacity .5s,filter .5s}.message-overlay__overlay{position:absolute;display:flex;justify-content:center;align-items:center;left:0;right:0;top:0;bottom:0}.message-overlay__message{padding:10px;font-size:2em;font-weight:400;text-align:center}.maintenance{margin-bottom:14px;background:var(--tiles-bg);border-radius:var(--border-radius)}.maintenance__inside{padding:10px 20px 20px}@media(min-width:1024px){.maintenance__inside{display:grid;grid-template:auto/90px auto 300px;column-gap:20px;padding:25px 20px}}.maintenance__image{display:none}.maintenance__image img{width:100%;border-radius:var(--border-radius);overflow:hidden;aspect-ratio:1;object-fit:contain}@media(min-width:1024px){.maintenance__image{display:flex;align-items:center}}.maintenance__about{margin-bottom:20px}@media(min-width:1024px){.maintenance__about{margin-bottom:0}}.maintenance__about h1{position:relative;margin-bottom:5px;display:flex;flex-wrap:wrap;column-gap:.5em;align-items:baseline}.maintenance__about p{margin:0 0 1em;display:inline}.maintenance__error,.maintenance__warning{position:relative;top:-2px;padding:4px 8px;font-size:14px;line-height:1em;font-weight:300;background:var(--btn-warning);color:var(--clr-btn);border-radius:var(--border-radius)}.maintenance__error{background:var(--btn-alert)}.maintenance__actions{display:flex;flex-direction:column;row-gap:10px;column-gap:20px}@media(min-width:600px){.maintenance__actions{flex-direction:row-reverse}}@media(min-width:1024px){.maintenance__actions{flex-direction:column;margin-left:20px}}.maintenance__actions>.button-group,.maintenance__actions>button{width:100%}@media(min-width:600px){.maintenance__actions>.button-group,.maintenance__actions>button{width:calc(50% - 10px)}}@media(min-width:1024px){.maintenance__actions>.button-group,.maintenance__actions>button{width:100%}}.maintenance__loader{width:50px;margin:0 auto}.maintenance__loader .sk-circle{width:50px;height:50px}.log-viewer__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.log-viewer__status--empty{padding-top:140px;background:url(../img/warning.9a7cd776.svg) top no-repeat;background-size:100px 100px}.log-viewer__status--loader .sk-circle{width:100px;height:100px;margin:0 auto 40px}.log-viewer__status button{margin-top:2em}.log-viewer__loading{width:30px;margin:40px auto}.log-viewer__loading .sk-circle{width:30px;height:30px}.log-viewer__filters{display:flex;justify-content:space-between;flex-wrap:wrap;gap:20px}.log-viewer__filters>div{display:flex;align-items:flex-end;gap:20px}.log-viewer__filters a{flex-shrink:0}.log-viewer__file{flex-shrink:1;display:flex;align-items:flex-end}.log-viewer__file select{border-right:none;border-top-right-radius:0;border-bottom-right-radius:0}.log-viewer__file button{border-top-left-radius:0;border-bottom-left-radius:0}.log-viewer__list{margin-top:2em;padding-bottom:1px;background:var(--form-bg);border-radius:var(--border-radius)}@media(min-width:600px){.log-viewer__list{overflow-y:scroll;max-height:calc(100vh - 300px)}}.log-viewer__line{position:relative;padding:10px 0;border-bottom:1px solid var(--border--light)}@media(min-width:600px){.log-viewer__line{display:flex}}.log-viewer__line:hover{background:var(--focus)}.log-viewer__line:last-child{border-bottom:none}.log-viewer__line--header{display:none}@media(min-width:600px){.log-viewer__line--header{display:flex;position:sticky;top:0;z-index:1;font-weight:600;background:var(--log-header-bg)!important;color:#fff;border-top-left-radius:2px;border-top-right-radius:2px;border-bottom-color:var(--border)}}.log-viewer__line--alert:before,.log-viewer__line--critical:before,.log-viewer__line--emergency:before,.log-viewer__line--error:before,.log-viewer__line--warning:before{content:"";position:absolute;left:0;top:-1px;bottom:-1px;width:4px;background:var(--btn-alert)}.log-viewer__line--warning:before{background:var(--btn-warning)}.log-viewer__line--raw{padding:5px 10px;background:#24292e;border-bottom:none;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:#f6f8fa;font-size:.8em;line-height:1.5;white-space:pre-wrap}.log-viewer__line--raw:hover{background:#2f363d}.log-viewer__more{display:flex;justify-content:center;padding:20px}.log-viewer__content,.log-viewer__meta{padding:10px 20px}.log-viewer__content--header,.log-viewer__meta--header{padding:0 20px!important}.log-viewer__meta{padding-bottom:0;flex-shrink:0;font-style:italic}.log-viewer__meta--header{font-style:normal}@media(min-width:600px){.log-viewer__meta{width:220px;padding-bottom:10px}}.log-viewer__content{flex-grow:1}.log-viewer__datetime{display:block}@media(min-width:600px){.log-viewer__datetime{margin-bottom:1em}}.log-viewer__badge{display:inline-block;margin-right:10px;padding:1px 4px;background:var(--border);border-radius:var(--border-radius);font-size:.9em;font-weight:400;text-transform:lowercase}.log-viewer__badge--desktop{display:none}@media(min-width:600px){.log-viewer__badge--desktop{display:inline-block}.log-viewer__badge--mobile{display:none}}.log-viewer__badge--channel{padding-top:0;padding-bottom:0;border:1px solid var(--border);background:var(--white)}.log-viewer__badge--level-warning{background:var(--btn-warning);color:#fff}.log-viewer__badge--level-alert,.log-viewer__badge--level-critical,.log-viewer__badge--level-emergency,.log-viewer__badge--level-error{background:var(--btn-alert);color:#fff}.log-viewer__message span:nth-child(2n){font-weight:600;color:var(--black)}.log-viewer__details{display:flex;align-items:center;margin-top:1em}.log-viewer__toggle{margin-right:10px;padding:0;border:none;background:none;color:var(--link);text-decoration:none;cursor:pointer}.log-viewer__toggle:hover{text-decoration:underline}.log-viewer__json{margin:10px 0 0}.invite-user__check{text-align:center}.invite-user__check svg{width:60px;height:60px;fill:var(--btn-primary)}.invite-user__check,.invite-user__text{margin-bottom:1em}.invite-user__url{display:block;margin-top:2em}.invite-user__help{display:block;margin-top:1em;font-size:12px}.invite-user__clipboard{margin:1em 0}.widget-text input::-webkit-inner-spin-button,.widget-text input::-webkit-outer-spin-button{display:none}.widget-text input[type=number]{appearance:textfield!important}.widget-text--password input{padding-right:40px!important}.widget__password-toggle{position:absolute;right:8px;bottom:2px;padding:0;margin:0;background:none;border:none;cursor:pointer}.widget__password-toggle--hidden svg{fill:var(--btn-primary)}.widget__password-toggle--visible svg{fill:var(--btn)}.setup-totp__qr{margin:2em;text-align:center}.setup-totp__qr svg{width:200px;height:200px}.setup-totp__uri{display:block;margin:1em 0;word-break:break-all}.setup-totp .sk-circle{margin:20px auto}.disable-totp__text{margin-bottom:1em}.change-password .widget{margin:1em 0 0}.user-manager__loading{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.user-manager__loading .sk-circle{width:100px;height:100px;margin:0 auto 40px}.user-manager__list{display:grid;grid-template:1fr/1fr;gap:20px}@media(min-width:600px){.user-manager__list{grid-template:1fr/repeat(2,1fr)}}@media(min-width:800px){.user-manager__list{grid-template:1fr/repeat(3,1fr)}}@media(min-width:1200px){.user-manager__list{grid-template:1fr/repeat(4,1fr)}}.user-manager__item{position:relative;overflow:hidden;display:flex;flex-direction:column;padding:16px;background:var(--tiles-bg);border:1px solid 1px solid var(--tiles-bdr);border-radius:14px}.user-manager__ribbon{position:absolute;top:18px;right:-22px;width:100px;font-size:12px;color:#fff;font-weight:600;line-height:1.5;text-align:center;background:var(--btn-info);transform-origin:center center;transform:rotate(45deg)}.user-manager__ribbon--hint{cursor:help}.user-manager__ribbon--primary{background:var(--btn-primary)}.user-manager__ribbon--warning{background:var(--btn-warning)}.user-manager__ribbon--alert{background:var(--btn-alert)}.user-manager__new{margin-top:60px;text-align:center}.user-manager__spacer{flex-grow:1;min-height:1em}.user-manager__username{font-size:18px;font-weight:600}.user-manager__scope{margin-top:1em}.user-manager .widget-button{margin-top:5px}.view-error{position:fixed;left:0;right:0;top:0;bottom:0;padding:10px;color:#e8e8e8;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;font-size:13px;line-height:1.2;background-color:rgba(0,0,0,.851);background-position:0 0;background-repeat:repeat;z-index:9998}.view-error,.view-error__close{display:flex;justify-content:center;align-items:center}.view-error__close{position:absolute;top:15px;right:10px;width:35px;height:35px;background:none;border:none;cursor:pointer;z-index:10}.view-error__close:hover{border:1px solid #fff}.view-error__content{display:flex;flex-direction:column;align-items:center;max-width:800px;max-height:100vh;line-height:1.5;text-align:center}.view-error__icon{display:block;height:100px;margin:2em 0;fill:#fff}.view-error__status{margin-bottom:1em;padding:2px 4px;background-color:#e36049;border-radius:var(--border-radius)}.view-error__headline{margin:0;font-size:1em;line-height:1.5}.view-error__status a{color:#e8e8e8;text-decoration:underline}.view-error__details{display:block;margin-top:2em;white-space:pre-line}.view-error__debug{align-self:flex-start;max-height:60vh;overflow-y:auto;margin-top:2em;text-align:left;white-space:pre-line}.view-error__actions{margin:4em 0;text-align:center}.view-error__link{margin:10px;padding:10px 20px;border:1px solid #fff;border-radius:4px;color:#fff}.button-menu{position:relative}.button-menu__primary.widget-button{float:left;width:calc(100% - 39px);border-top-right-radius:0;border-bottom-right-radius:0}.button-menu__more.widget-button{float:right;width:38px;padding:7px;border-top-left-radius:0;border-bottom-left-radius:0}.button-menu__more.widget-button svg{width:24px;height:24px}.button-menu__menu{display:flex;flex-direction:column;position:absolute;top:38px;right:0;width:auto;z-index:100;background:var(--form-bg);border-radius:var(--border-radius)}.button-menu__menu:before{content:"";position:absolute;top:-5px;right:15px;width:0;height:0;border-right:none;border-bottom:none;border-left:5px solid transparent;border-right:5px solid transparent;border-bottom:5px solid var(--form-bg)}.button-menu__menu:focus{outline:none}.button-menu__menu button{padding:8px 16px;background:none;border:none;text-align:left;white-space:nowrap;border-bottom:1px solid var(--border);cursor:pointer}.button-menu__menu button:hover{color:var(--text);background:var(--focus)}.button-menu__menu button:first-child{border-top-left-radius:2px;border-top-right-radius:2px}.button-menu__menu button:last-child{border-bottom:none;border-bottom-left-radius:2px;border-bottom-right-radius:2px}.button-menu__menu .link-menu{margin-top:3px}.console-operation{position:relative;padding:0 16px;text-align:left;font-size:12px;color:#959da5}.console-operation__summary{margin-left:13px;padding:8px;box-sizing:border-box}.console-operation__summary--console{margin-left:0}.console-operation summary{cursor:pointer}.console-operation__status{display:inline-block;position:relative;box-sizing:border-box;padding-right:8px;width:24px;height:18px;text-align:center;vertical-align:middle}.console-operation__icon{position:absolute;left:0;top:0}.console-operation__icon--skipped{fill:#666b71}.console-operation__icon--pending{fill:#dbab0a}.console-operation__icon--active{fill:#dbab0a;animation:console-active 1s linear infinite}@keyframes console-active{0%{transform:rotate(0deg)}50%{transform:rotate(180deg)}to{transform:rotate(359deg)}}.console-operation__icon--success{fill:var(--btn-primary)}.console-operation__icon--error{fill:var(--btn-alert)}.console-operation__label{display:inline-block;overflow:hidden;max-width:750px;vertical-align:top}.console-operation__title{display:inline;margin:0;color:#fff}.console-operation__title--disabled{text-decoration:line-through}.console-operation__description{display:inline;margin:0 0 0 10px}.console-operation__console{position:relative;overflow-y:auto;max-height:280px}.console-operation__lines{padding:8px 0 16px;font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace;color:#f6f8fa;line-height:1.5;white-space:pre-wrap;word-break:break-word;overflow-wrap:break-word}.console-operation__line{display:flex}.console-operation__line:hover{background-color:#2f363d}.console-operation__line-number{display:inline-block;overflow:hidden;width:48px;min-width:48px;color:#959da5;text-align:right;text-overflow:ellipsis;white-space:nowrap;vertical-align:middle;user-select:none}.console-operation__line-content{display:inline-block;margin-left:16px;vertical-align:middle}.console-operation__scroll{position:sticky;left:0;right:0;display:flex;justify-content:center;align-items:flex-end;width:100%;height:30px;padding:0;border:none;cursor:pointer}.console-operation__scroll svg{fill:#fff;width:16px;height:16px}.console-operation__scroll--top{top:0;background:linear-gradient(#24292e,rgba(36,41,46,.502) 50%)}.console-operation__scroll--top svg{transform:rotate(180deg)}.console-operation__scroll--bottom{bottom:0;background:linear-gradient(rgba(36,41,46,.502),#24292e 50%)}.console-operation__scroll--bottom svg{transform:rotate(0deg)}.console{background:#24292e;border-radius:8px}.console__header{display:flex;flex-wrap:nowrap;justify-content:space-between;align-items:center;padding:12px 12px 12px 24px;border-bottom:1px solid #444d56}.console__headline{margin:0;font-size:inherit;line-height:1.5;color:#fff}.console__description{color:#959da5;font-size:12px}.console__actions{display:flex;flex-wrap:nowrap;align-items:center}.console__action,.console__action>button{height:30px!important;line-height:30px!important;width:auto!important;min-width:0;margin:0 2px;padding:0 5px!important;border:none!important}.console__action:hover,.console__action>button:hover{background-color:#2f363d!important}.console__action--active,.console__action>button--active{background-color:#586069!important}.console__operations{padding:20px 0}.view-task__header{margin-left:auto;margin-right:auto;padding:40px 20px;text-align:center}.view-task__icon{background:var(--contao);border-radius:10px;padding:10px}.view-task__headline{margin-top:15px;font-size:36px;font-weight:100;line-height:1}.view-task__description{margin:0;font-weight:600}.view-task__actions{display:flex;flex-direction:column;justify-content:center;align-items:center;margin-top:2em}@media(min-width:960px){.view-task__actions{flex-direction:row}}.view-task .widget-button{width:280px;height:35px;margin:5px;padding:0 30px;line-height:35px}@media(min-width:960px){.view-task .widget-button{width:auto}}.view-task__main{margin:0 50px 50px}.view-task__loading{width:30px;margin:40px auto}.view-task__loading .sk-circle{width:30px;height:30px}.view-task__sponsor{margin:-30px 50px 50px;text-align:center}@media(min-width:960px){.view-task__sponsor br{display:none}}.view-task__donate{position:relative;top:5px;margin-left:.5em;line-height:0}:root{--text:#535353;--link:#f47c00;--placeholder:#a9a9a9;--body-bg:#ebe6db;--link-footer:#2a7887;--tiles-bg:#fff;--tiles-bdr:#ddd3bc;--popup-hl-bg:#f47c00;--popup-bg:#fff;--popup-header:#fff;--popup-overlay-bg:hsla(41,29%,89%,.35);--tab-content:#f8f9fb;--highlight-bg:#ff0;--highlight-color:#535353;--shadow:#ccbfa2;--contao:#f47c00;--badge-bg:var(--contao);--ad-shadow:0 1px 5px 1px rgba(0,0,0,.2);--black:#000;--funding:#ea4aaa;--funding-rgb:234,74,170;--form-bg:#fff;--border:#ccc;--border--light:#e9eef1;--focus:#f9f9f9;--clr-btn:#fff;--btn:#737373;--btn-active:#666;--btn-primary:#31a64b;--btn-primary-active:#2b9242;--btn-warning:#db8c41;--btn-warning-active:#d77f2c;--btn-alert:#db5041;--btn-alert-active:#d73c2c;--btn-info:#6a8ca6;--btn-info-active:#5c7f9a;--btn-funding:#ea4aaa;--btn-funding-active:#e7339f;--btn-disabled:#ccc;--hint-bg:#e8c8bc;--hint-rgb:232,200,188;--hint-link:#bd2e20;--header-bg:#e5dfcf;--header-bdr:#dcd8cc;--footer-bdr:#bbb;--svg--link-blank:url(../img/link-blank.eb57b3fa.svg);--svg--private:url(../img/private.a1c65662.svg);--svg--updated:url(../img/updated.3b47bebb.svg);--svg--downloads:url(../img/downloads.c1db2a9e.svg);--svg--favers:url(../img/favers.056e2836.svg);--svg--language:url(../img/language.582b2920.svg);--svg--color-scheme:url(../img/color_scheme.d527d153.svg)}html[data-color-scheme=dark]{color-scheme:dark;--text:#ddd;--link:#f47c00;--body-bg:#0f0f11;--tiles-bg:#212227;--tiles-bdr:#303236;--popup-hl-bg:#292c32;--popup-bg:#1b1d21;--popup-overlay-bg:rgba(0,0,0,.35);--tab-content:#212227;--highlight-bg:#f47c00;--highlight-color:#fff;--shadow:transparent;--badge-bg:var(--border--light);--ad-shadow:none;--btn:#3c3f4c;--btn-active:#25272f;--black:#fff;--form-bg:#151619;--border:#44464b;--border--light:#2e2e34;--focus:#1e2024;--btn-info:#25455f;--btn-info-active:#253846;--btn-disabled:#151517;--opacity-disabled:0.5;--hint-rgb:57,9,20;--header-bg:#1b1d21;--header-bdr:#1b1d21;--footer-bdr:#414448;--svg--link-blank:url(../img/link-blank--dark.07eeaee6.svg);--svg--private:url(../img/private--dark.41b90022.svg);--svg--updated:url(../img/updated--dark.c21fdd5b.svg);--svg--downloads:url(../img/downloads--dark.034bf7a3.svg);--svg--favers:url(../img/favers--dark.4765f7d4.svg);--svg--language:url(../img/language--dark.a24e849e.svg);--svg--color-scheme:url(../img/color_scheme--dark.ef0f0aed.svg)}html[data-color-scheme=dark] #contao-network{background:#292c32!important;color:#ddd!important}html{box-sizing:border-box}*,:after,:before{box-sizing:inherit}#app,body,html{height:100%}blockquote,body,figure,form,p{margin:0;padding:0}article,aside,figcaption,figure,footer,header,main,nav,section{display:block}body,div,fieldset,form,h1,h2,h3,h4,h5,h6,html,p{text-size-adjust:none}body{background:var(--body-bg);overflow-y:hidden}#app{overflow-y:scroll}fieldset{border:none;margin:0;padding:0}legend{-webkit-padding-start:0;-webkit-padding-end:0}figure{line-height:0}body,button,input,textarea{font:300 14px/1.4 -apple-system,system-ui,Segoe UI,Roboto,Oxygen-Sans,Ubuntu,Cantarell,Helvetica Neue,sans-serif;color:var(--text)}strong{font-weight:600}code{font-family:SFMono-Regular,Menlo,Monaco,Consolas,Liberation Mono,Courier New,monospace}input,select,textarea{font-size:99%}input:disabled,select:disabled,textarea:disabled{color:var(--text);-webkit-text-fill-color:var(--text);cursor:text}input::-ms-clear,input::-ms-reveal,select::-ms-clear,select::-ms-reveal,textarea::-ms-clear,textarea::-ms-reveal{display:none}input::placeholder,select::placeholder,textarea::placeholder{color:var(--placeholder);-webkit-text-fill-color:var(--placeholder)}.invisible{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.clearfix{*zoom:1}.clearfix:after,.clearfix:before{display:table;content:"";line-height:0}.clearfix:after{clear:both}h1,h2,h3,h4,h5,h6{font-size:inherit;line-height:inherit;font-weight:600;margin:0}a{color:var(--link);text-decoration:none}a:hover{text-decoration:underline}h1{font-size:18px;line-height:30px;margin-bottom:10px}@keyframes input-error{0%{left:0}25%{left:-5px}75%{left:5px}to{left:0}}.widget{position:relative}.widget__error{display:none;position:absolute;left:0;right:0;margin:0;padding:4px 10px;color:var(--clr-btn);background:var(--btn-alert);border-radius:2px;transform:translateY(6px);z-index:10;white-space:pre-line}.widget__error:after,.widget__error:before{bottom:100%;left:30px;border:solid transparent;content:" ";height:0;width:0;position:absolute;pointer-events:none}.widget__error:after{border-bottom-color:var(--btn-alert);border-width:3px;margin-left:-3px}.widget__error:before{border-bottom-color:var(--btn-alert);border-width:5px;margin-left:-5px}input:focus+*+.widget__error,input:focus+.widget__error,input:hover+*+.widget__error,input:hover+.widget__error,select:hover+.widget__error{display:block}.widget__description{margin-top:2px;font-size:12px}input:not([type=checkbox]):not([type=radio]),select{position:relative;width:100%;height:38px;padding:0 20px;background:var(--form-bg);border:1px solid var(--border);border-radius:6px;color:var(--text);appearance:none}input:not([type=checkbox]):not([type=radio]):focus,select:focus{outline:none;background-color:var(--focus)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:placeholder-shown):valid,.widget--validate select:not(:placeholder-shown):valid{border-color:var(--btn-primary)}.widget--validate input:not([type=checkbox]):not([type=radio]):not(:placeholder-shown):invalid,.widget--validate select:not(:placeholder-shown):invalid{border-color:var(--btn-alert)}.widget--error input:not([type=checkbox]):not([type=radio]),.widget--error select{border-color:var(--btn-alert);animation:input-error .15s linear 3}select{padding-right:30px}.widget-select:after{position:absolute;right:12px;bottom:16px;width:0;height:0;border-left:6px solid transparent;border-right:6px solid transparent;border-top:6px solid var(--border);content:"";pointer-events:none}.widget-button{display:inline-block;width:100%;height:38px;padding:0;border:none;background-color:var(--btn);color:var(--clr-btn);font-weight:600;line-height:38px;text-decoration:none;text-align:center;white-space:nowrap;cursor:pointer;border-radius:5px}.widget-button:active,.widget-button:hover{background-color:var(--btn-active)}.widget-button--inline{width:auto!important;min-width:100px;padding:0 20px}.widget-button--transparent{background:transparent}.widget-button--small{height:28px;width:auto!important;min-width:0;padding:0 15px;font-size:13px;line-height:28px;font-weight:300}.widget-button--small:before,.widget-button--small>:before{top:3px!important;width:15px!important;height:15px!important;margin-right:6px!important;background-size:15px 15px!important}.widget-button--primary{--btn:var(--btn-primary);--btn-active:var(--btn-primary-active)}.widget-button--warning{--btn:var(--btn-warning);--btn-active:var(--btn-warning-active)}.widget-button--alert{--btn:var(--btn-alert);--btn-active:var(--btn-alert-active)}.widget-button--info{--btn:var(--btn-info);--btn-active:var(--btn-info-active)}.widget-button--funding{--btn:var(--btn-funding);--btn-active:var(--btn-funding-active)}.widget-button:empty{min-width:auto;padding:0 10px}.widget-button:empty:before{margin-right:0!important}.widget-button:hover{text-decoration:none}.widget-button.disabled,.widget-button:disabled{background-color:var(--btn-disabled)!important;border-color:var(--btn-disabled)!important;cursor:not-allowed;opacity:var(--opacity-disabled,1)}.widget-button.disabled{pointer-events:none}.widget-button--anchor{height:auto;background:none!important;line-height:inherit;font-weight:inherit;color:var(--link);text-decoration:none;cursor:pointer}.widget-button--anchor:hover{text-decoration:underline!important}.widget-button--anchor.disabled,.widget-button--anchor:disabled{background:none!important}label{padding:0}.widget--required label:after{margin-left:2px;content:"*";color:var(--btn-alert)}input:-webkit-autofill,select:-webkit-autofill{-webkit-text-fill-color:var(--text);-webkit-box-shadow:inset 0 0 0 1000px hsla(0,0%,100%,0);transition:background-color 5000s ease-in-out 0s}.widget-button--details:before{background-image:url(../img/button-details.8ce780e9.svg)}.widget-button--link:before{background-image:url(../img/button-link.dd42e161.svg)}.widget-button--search:before{background-image:url(../img/button-search.44ce1d4b.svg)}.widget-button--add:before,.widget-button--check:before,.widget-button--clipboard:before,.widget-button--cloud-off:before,.widget-button--cloud:before,.widget-button--console:before,.widget-button--database:before,.widget-button--details:before,.widget-button--download:before,.widget-button--edit:before,.widget-button--gear:before,.widget-button--hide:before,.widget-button--link:before,.widget-button--lock:before,.widget-button--maintenance:before,.widget-button--more:before,.widget-button--passkey:before,.widget-button--power:before,.widget-button--run:before,.widget-button--save:before,.widget-button--search:before,.widget-button--show:before,.widget-button--trash:before,.widget-button--unlock:before,.widget-button--update:before,.widget-button--upload:before{position:relative;display:inline-block;top:5px;width:20px;height:20px;margin-right:8px;background-position:50%;background-repeat:no-repeat;background-size:18px 18px;content:""}.widget-button--add:empty:before,.widget-button--check:empty:before,.widget-button--clipboard:empty:before,.widget-button--cloud-off:empty:before,.widget-button--cloud:empty:before,.widget-button--console:empty:before,.widget-button--database:empty:before,.widget-button--details:empty:before,.widget-button--download:empty:before,.widget-button--edit:empty:before,.widget-button--gear:empty:before,.widget-button--hide:empty:before,.widget-button--link:empty:before,.widget-button--lock:empty:before,.widget-button--maintenance:empty:before,.widget-button--more:empty:before,.widget-button--passkey:empty:before,.widget-button--power:empty:before,.widget-button--run:empty:before,.widget-button--save:empty:before,.widget-button--search:empty:before,.widget-button--show:empty:before,.widget-button--trash:empty:before,.widget-button--unlock:empty:before,.widget-button--update:empty:before,.widget-button--upload:empty:before{margin-right:0!important}.animate-initializing{animation:initializing 1s linear infinite}@keyframes initializing{0%{opacity:.5}50%{opacity:1}to{opacity:.5}}.animate-blur-in{z-index:-1;opacity:.5;filter:blur(4px);transition:opacity .35s,filter .5s}.animate-blur-out{opacity:1;transition:opacity .35s}.animate-fade-enter-active,.animate-fade-leave-active{transition-duration:.2s;transition-property:opacity;transition-timing-function:ease}.animate-fade-enter,.animate-fade-leave-active{opacity:0}.animate-flip-enter-active,.animate-flip-leave-active{transform-style:preserve-3d;backface-visibility:hidden;transition-duration:.5s;transition-property:transform,opacity}.animate-flip-leave-active{transform:perspective(600px) rotateY(0deg);opacity:1}.animate-flip-leave-to{transform:perspective(600px) rotateY(90deg);transition-timing-function:ease-in;opacity:0}.animate-flip-enter-active{transform:perspective(400px) rotateY(270deg);opacity:0}.animate-flip-enter-to{transform:perspective(400px) rotateY(1turn);transition-timing-function:ease-out;opacity:1}:root{--header-main-bg:#fff;--footer-fragment-bdr:#eee;--table-odd-bg:#f5f9fa;--border-radius:6px;--log-header-bg:var(--shadow)}html[data-color-scheme=dark]{--header-main-bg:#292c32;--footer-fragment-bdr:var(--footer-bdr);--table-odd-bg:var(--tiles-bg);--link-footer:#fff;--hint-bg:#151619;--hint-rgb:21,22,25;--log-header-bg:var(--btn)}html[data-color-scheme=dark] .vjs-tree-node:hover{background-color:#2b3439}.color-scheme--light,html[data-color-scheme=dark] .color-scheme--dark{display:initial}.color-scheme--dark,html[data-color-scheme=dark] .color-scheme--light{display:none}.app-hint{position:absolute;top:0;left:0;right:0;height:27px;padding:4px 8px;background:var(--btn-info);color:#fff;text-align:center;z-index:100}.app-hint--warning{background:var(--btn-warning)}.app-hint--alert{background:var(--btn-alert)}.app-hint__description{display:none}@media(min-width:600px){.app-hint__description{display:inline}}.app-hint__link{margin:0;padding:0;background:none;border:none;color:#fff;text-decoration:underline;cursor:pointer}.app-hint+div{padding-top:25px}.view-init{display:table;width:100%;height:100%}.view-init__cell{display:table-cell;font-size:1.5em;text-align:center;vertical-align:middle}.widget-button--add:before{background-image:url(../img/button-add.759df12e.svg)}.widget-button--check:before{background-image:url(../img/button-check.7a3b5ada.svg)}.widget-button--clipboard:before{background-image:url(../img/button-clipboard.9ef63d39.svg)}.widget-button--cloud:before{background-image:url(../img/button-cloud.bc42f267.svg)}.widget-button--cloud-off:before{background-image:url(../img/button-cloud-off.dd8ba18e.svg)}.widget-button--console:before{background-image:url(../img/button-console.05dcdfc4.svg)}.widget-button--database:before{background-image:url(../img/button-database.5282fc7e.svg)}.widget-button--download:before{background-image:url(../img/button-download.e1ba6f25.svg)}.widget-button--edit:before{background-image:url(../img/button-edit.40a4be06.svg)}.widget-button--gear:before{background-image:url(../img/button-gear.a2dc1f09.svg)}.widget-button--hide:before{background-image:url(../img/button-hide.d23f6533.svg)}.widget-button--lock:before{background-image:url(../img/button-lock.98988f08.svg)}.widget-button--maintenance:before{background-image:url(../img/button-maintenance.93830369.svg)}.widget-button--more:before{background-image:url(../img/button-more.e3eb2622.svg)}.widget-button--passkey:before{background-image:url(../img/button-passkey.3806f98a.svg)}.widget-button--power:before{background-image:url(../img/button-power.298a8072.svg)}.widget-button--run:before{background-image:url(../img/button-run.b6310c5a.svg)}.widget-button--save:before{background-image:url(../img/button-save.3b5224de.svg)}.widget-button--show:before{background-image:url(../img/button-show.2336e1d9.svg)}.widget-button--trash:before{background-image:url(../img/button-trash.855f57fa.svg)}.widget-button--unlock:before{background-image:url(../img/button-unlock.51b76e07.svg)}.widget-button--update:before{background-image:url(../img/button-update.ad79c617.svg)}.widget-button--upload:before{background-image:url(../img/button-upload.ca8e9cfc.svg)}.view-login__header{max-width:280px;margin:0 auto 60px;padding-top:40px;text-align:center}.view-login__product{margin-top:15px;font-size:38px;font-weight:100;line-height:1}.view-login__form{position:relative;max-width:280px;margin:0 auto 60px}.view-login__form input{padding-right:30px;margin:5px 0 10px}.view-login__locked{max-width:290px;margin:-20px auto 60px;padding:20px;background:var(--btn-alert);color:#fff;text-align:center}.view-login__locked strong{white-space:pre}.view-login__headline{margin-bottom:0}.view-login__description{margin-top:.5em;margin-bottom:20px}.view-login label{position:absolute;text-indent:-999em;pointer-events:none}.view-login label[for=ctrl_username]{top:0;bottom:0;margin:auto;right:13px;width:16px;height:16px;background:url(../img/person.00d78897.svg) 0 0 no-repeat;background-size:16px 16px;z-index:10}.view-login label[for=ctrl_password]{top:0;bottom:0;margin:auto;right:12px;width:16px;height:16px;background:url(../img/lock.3c42a55f.svg) 0 0 no-repeat;background-size:14px 14px;z-index:10}.view-login__password input,.view-login__user input{margin:0}.view-login__user input{border-radius:var(--border-radius) var(--border-radius) 0 0!important}.view-login__password{margin-top:-1px;margin-bottom:10px}.view-login__password input{border-radius:0 0 var(--border-radius) var(--border-radius)!important}.view-login .widget-text--password button{opacity:0}.view-login__link{display:block;margin-top:2em;font-size:12px;text-align:center}.view-login__button{margin:3px 0}.view-login__button .sk-circle{color:#fff;text-align:center}.view-login__or{display:grid;gap:15px;grid-template-columns:1fr auto 1fr;padding:12px}.view-login__or:after,.view-login__or:before{align-self:center;border-top:1px solid var(--border);content:""}.view-login .fragment-footer{display:block}.widget-radio-button legend{margin-bottom:2px}.widget-radio-button>div{position:relative;margin:.25em 0}.widget-radio-button input{border:0;clip:rect(0 0 0 0);height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;width:1px}.widget-radio-button label{display:block;padding-left:25px;background:url(../img/widget-radio--off.4e93f443.svg) 0 -1px no-repeat;background-size:20px 20px}.widget-radio-button input:checked+label{background-image:url(../img/widget-radio--on.181461b6.svg)}.widget-radio-button input:focus-visible+label{outline:5px auto Highlight;outline:5px auto -webkit-focus-ring-color}.widget-radio-button input:disabled+label{opacity:.5}.setup__directories{margin-top:2em}.setup__directories>dt{margin-top:1em;font-weight:600}.setup__directories>dd{margin:0;word-break:break-all}.setup__directories>dd span{background-color:var(--highlight-bg);color:var(--highlight-color);font-weight:400}.link-more{position:relative;display:inline-block}p:empty+.link-more{margin-left:0}.link-more button{width:auto;height:auto;padding:0 0 5px;background:transparent;color:var(--link);font-size:13px;font-weight:300;line-height:inherit;border:none;cursor:pointer}.link-more button:hover{text-decoration:underline}.link-more__menu{outline:none}.link-more ul{transform:translateX(-50%)}.package-link{display:flex;column-gap:8px;justify-content:space-between;width:100%;padding-bottom:4px;margin-bottom:4px;border-bottom:1px solid var(--border--light)}.package-link:last-child{padding-bottom:0;margin-bottom:0;border-bottom:none}.package-link__details{padding:5px 0;line-height:18px}.package-link__name{display:inline;font-weight:600}.package-link__name:after{content:": "}.package-link__text{display:inline}.package-link__actions{display:flex;margin-left:20px;margin:0 -4px}.package-link__actions>*{margin:0 4px}.package-link--limit .package-link__details{display:flex}.package-link--limit .package-link__name{white-space:nowrap}.package-link--limit .package-link__text{display:-webkit-box;overflow:hidden;line-clamp:1;-webkit-line-clamp:1;-webkit-box-orient:vertical;padding:0 10px 0 5px}.package-funding[data-v-5a8fd14b]{padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--funding-rgb),.025) url(../img/funding.cf78a0a0.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid rgba(var(--funding-rgb),.5);border-radius:6px}.package-funding>div[data-v-5a8fd14b]{overflow:hidden}.package-funding span[data-v-5a8fd14b]{margin-right:15px}.package-funding a[data-v-5a8fd14b]{position:relative;display:inline-block;margin:0 20px 0 0;padding-left:16px;color:var(--funding);background:url(../img/link-funding.b25cd92d.svg) 0 50% no-repeat;background-size:13px 13px}.package-funding a[data-v-5a8fd14b]:before{content:"|";position:absolute;left:-12px}.package-funding a[data-v-5a8fd14b]:nth-child(2):before{content:none}.package-popup{position:fixed;display:flex;flex-direction:column;justify-content:flex-start;width:100%;max-width:none;height:100%;background:var(--popup-bg);z-index:10;opacity:1}.package-popup>*{flex-basis:auto;flex-grow:1}.package-popup__loader{display:flex;flex-direction:column;align-items:center;justify-content:center;padding:50px 0}.package-popup__loader p{margin:1em}.package-popup__headline{position:relative;flex-grow:0;flex-shrink:1;padding:7px 30px 6px;background:var(--popup-hl-bg);color:#fff;font-size:18px;font-weight:300;line-height:1.5;text-align:center}.package-popup__button{display:block;float:right;position:absolute;top:0;margin:4px 0;padding:4px;background:none;border:1px solid transparent;border-radius:5px;cursor:pointer}.package-popup__button--previous{left:4px}.package-popup__button--close{right:4px}.package-popup__button svg{display:block;width:22px;height:22px}.package-popup__button:hover{background-color:#db6f00}.package-popup__summary{flex-grow:0;padding:25px 35px}@media(min-width:600px){.package-popup__summary{display:flex}}.package-popup__logo{border-radius:6px;float:right;height:60px;width:60px;margin-left:1em;background:#f7f7f7}@media(min-width:600px){.package-popup__logo{display:block;float:left;width:110px;height:110px;margin:-10px 16px 0 -10px}}.package-popup__icon{display:flex;align-items:center;justify-content:center;height:100%}.package-popup__icon--fallback{display:none}.package-popup__icon img{width:50px;height:50px;max-height:100%;object-fit:contain}@media(min-width:600px){.package-popup__icon img{width:90px;height:90px}}.package-popup__text{display:flex;flex-direction:column;flex-grow:1}@media(min-width:600px){.package-popup__text{width:200px}}.package-popup__title{margin:0;line-height:1.4;overflow-wrap:break-word}.package-popup__authors{flex-grow:1;font-size:13px;margin-bottom:.5em}.package-popup__author{display:inline-block;margin-right:2px}.package-popup__author:after{color:var(--text);content:", "}.package-popup__author:last-child:after{content:none}.package-popup__stats{display:inline-block;margin-right:15px;margin-top:.5em;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.package-popup__stats--private{padding-left:20px;background-image:var(--svg--private);background-size:15px 15px}.package-popup__stats--updated{background-image:var(--svg--updated)}.package-popup__stats--downloads{background-image:var(--svg--downloads)}.package-popup__stats--favers{background-image:var(--svg--favers)}.package-popup__actions{display:flex;flex-direction:column;gap:10px;margin-top:1em}@media(min-width:600px){.package-popup__actions{justify-content:space-between;margin:0 0 0 25px;width:200px}}.package-popup__installed{margin-top:1em}.package-popup__abandoned{margin:0 0 20px;padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--hint-rgb),.3) url(../img/hint.ba2ac97e.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid var(--hint-link);border-radius:6px}.package-popup__funding{margin:0 0 20px}.package-popup__tabs{position:relative;flex-grow:revert}.package-popup__tabs:after,.package-popup__tabs:before{content:"";display:block;position:absolute;top:0;bottom:1px;width:7px;background:linear-gradient(-90deg,transparent 0,var(--popup-bg) 50%);z-index:1;pointer-events:none}.package-popup__tabs:after{background:linear-gradient(90deg,transparent 0,var(--popup-bg) 50%);right:0}.package-popup__tabs-list{flex-shrink:0;flex-grow:0;display:flex;column-gap:4px;height:40px;min-width:100%;overflow-x:auto;scrollbar-width:none;overflow-y:hidden;margin:0;padding:0 7px;list-style-type:none}.package-popup__tabs-list:after{content:"";position:absolute;inset:auto 0 0;height:1px;background:var(--border--light);z-index:-1}.package-popup__tab{position:relative;top:1px;flex-grow:1;padding:0;height:39px;line-height:39px;text-align:center;border:1px solid var(--border--light);border-top-left-radius:6px;border-top-right-radius:6px}.package-popup__tab--active{background:var(--tab-content);border-bottom:1px solid var(--tab-content)}.package-popup__tab button{display:flex;justify-content:center;align-items:center;width:100%;height:100%;margin:0;padding:0 10px;border:none;background:transparent;cursor:pointer}.package-popup__tab button:disabled{color:var(--border)!important;cursor:not-allowed}.package-popup__pill{position:relative;top:-2px;display:inline-block;margin-left:5px;padding:2px 5px;font-size:10px;font-weight:400;background:var(--border--light);border-radius:40%}.package-popup__pill--highlight{color:var(--clr-btn);background:var(--btn-primary)}.package-popup__tabcontent{position:relative;padding:25px 35px;overflow-y:auto;background:var(--tab-content);outline:0}@media(min-width:960px)and (min-height:700px){.package-popup__tabcontent{height:450px}}.package-popup__description{margin:1em 0;white-space:pre-wrap}@media(min-width:960px){.package-popup{position:relative;display:block;top:0;left:50%;width:750px;margin-left:-375px;height:auto;border-radius:8px;transform:none}.package-popup__headline{border-radius:8px 8px 0 0}.package-popup__tabcontent{border-radius:0 0 8px 8px}}@media(min-width:960px)and (min-height:700px){.package-popup{position:absolute;top:50%;transform:translateY(-50%)}}.package-popup__installed strong{margin-right:5px}@media(min-width:600px){.package-popup__installed{display:flex;flex-direction:column;justify-content:flex-end;text-align:center}.package-popup__installed strong{display:block;margin:0}}.package-popup__update{background:var(--btn-primary) url(../img/button-update.ad79c617.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__incompatible,.package-popup__update{margin:0 0 20px;padding:10px 20px 10px 50px;color:var(--clr-btn);border-radius:var(--border-radius)}.package-popup__incompatible{background:var(--contao) url(../img/button-incompatible.3eb2b686.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__funding+.package-popup__update{margin-top:-10px}.theme-details__constraint{flex-grow:1}.file-tree{margin:0;padding:0;list-style:none}.file-tree__folder{position:relative;padding-left:20px}.file-tree__folder:before{content:"";position:absolute;left:10px;top:6px;width:0;height:0;border-top:5px solid transparent;border-bottom:5px solid transparent;border-left:5px solid var(--text);transition:transform .1s ease-in-out}.file-tree__folder--open:before{transform:rotate(90deg)}.file-tree__file{padding-left:20px}.file-tree button{background:none;border:none;font-weight:400;cursor:pointer}.setup__versions{margin:0;padding:0 0 0 15px}.setup__version{margin:.5em 0;text-align:left}.setup__version--warning{color:var(--btn-alert)}.setup__releaseplan{margin-top:1.5em}.setup__fielddesc--version{margin-bottom:-1em!important}.setup__core-features{margin:5px 0 0 5px;font-size:12px}.setup__theme-image{max-width:100%;height:auto;border:1px solid var(--border)}.setup__theme p{margin:1em 0}.setup__themes{padding:0 14px}.setup__themes-results{display:grid;gap:14px}@media(min-width:1024px){.setup__themes-results{grid-template-columns:repeat(2,1fr)}.setup__themes-results-item{flex-basis:calc(50% - 16px);margin-left:8px;margin-right:8px}}.setup__themes-item{border:1px solid var(--tiles-bdr)}.setup__themes-more{margin-top:20px;text-align:center}.setup__theme-search{margin:20px 0 0;text-align:center}.setup__theme-search--empty{padding-top:60px;background:url(../img/sad.c7de6e95.svg) top no-repeat;background-size:50px 50px}.setup__theme-search--offline{padding-top:60px;background:url(../img/offline.0c23d1ce.svg) top no-repeat;background-size:50px 50px}.setup__theme-search--loader .sk-circle{width:50px;height:50px;margin:0 auto 20px}.setup__theme-search button{margin-top:2em}.setup__fielddesc--warning{padding:10px 10px 10px 40px;background:var(--hint-bg) url(../img/hint.ba2ac97e.svg) 10px 10px no-repeat}.setup__tabs{margin:1em 0}.setup__tab-controls{display:flex}.setup__tab-control{flex-grow:1;padding:4px 10px;border:none;border-top:1px solid var(--border);border-left:1px solid var(--border);background:none;cursor:pointer}.setup__tab-control:last-child{border-right:1px solid var(--border)}.setup__tab-control--active{border-color:var(--btn);background:var(--btn);color:#fff}.setup__tab{border:1px solid var(--border)}.setup__tab--files{white-space:pre;overflow:scroll;height:200px}.setup__requires{width:100%;border-collapse:collapse}.setup__requires td,.setup__requires th{margin:0;padding:3px 10px;text-align:start;vertical-align:top}.setup__requires th{background:var(--btn);color:#fff}.setup__requires td{border-bottom:1px solid var(--border)}.setup__requires tr:last-child td{border-bottom:none}.setup__requires tr:nth-child(odd) td{background:var(--table-odd-bg)}.setup__theme-upload{padding:0 50px;text-align:center}@media(min-width:960px){.setup__theme-upload{padding:0 150px}}.setup__or{position:relative;overflow:hidden;margin:1em 0;text-align:center}.setup__or:before{content:"";position:absolute;top:.8em;left:0;right:0;display:block;height:1px;background:var(--border);z-index:1}.setup__or span{position:relative;padding:0 10px;background:var(--popup-bg);z-index:2}.view-setup{padding-top:40px}.view-setup footer{margin-top:40px}.view-setup__steps{padding:0 0 50px 0}.view-setup__steps ul{display:flex;margin:0;padding:0;list-style-type:none}.view-setup__steps li{display:flex;justify-content:center;align-items:center;flex-grow:1;position:relative;height:6px;margin:0;padding:0}.view-setup__steps li:before{content:"";position:absolute;left:-50%;right:50%;background:var(--border);height:5px}.view-setup__steps li:after{content:"";position:absolute;top:-18px;left:50%;margin-left:-21px;width:42px;height:42px;color:#fff;text-indent:0;text-align:center;line-height:35px;background:var(--border);border-radius:50%;z-index:1}.view-setup__steps li:first-child:before{content:none}.view-setup__steps li.active:after,.view-setup__steps li.active:before{background:var(--contao)}.view-setup__steps button{display:flex;justify-content:center;align-items:center;background:transparent;border:none;z-index:10;cursor:pointer}.view-setup__steps button:disabled{cursor:default}.view-setup__steps svg{fill:#fff}.view-setup__main{text-align:center}.view-setup__party{font-size:64px}.view-setup__headline{margin:10px 0 20px;padding:15px 0;font-size:42px;font-weight:100}.view-setup__description{max-width:500px;margin:1em 25px}.view-setup__start.widget-button{height:50px;margin:30px 10px 0;padding:0 50px;font-size:1.2em;line-height:50px}.view-setup__continue.widget-button{width:80%!important;margin:10px 0 0}.view-setup__funding{width:80%;margin:50px auto 0;padding:20px 25px;border:2px solid var(--funding);border-radius:var(--border-radius);background:rgba(var(--funding-rgb),.025);font-weight:400}.view-setup__funding figure{margin-bottom:1em}.view-setup__funding p{margin:0 0 .5em 0}.view-setup__funding-link{margin:1em 0 0}@media(min-width:960px){.view-setup{padding-top:80px}.view-setup footer{margin-top:80px}.view-setup__steps{padding-bottom:80px}.view-setup__headline{margin:20px 0 40px;font-size:64px}.view-setup__continue.widget-button{width:auto!important;margin:25px 10px 0;padding:0 20px}.view-setup__description{max-width:550px;margin:1em auto;font-size:1.2em}.view-setup__funding{display:flex;margin:60px auto -20px;text-align:left}.view-setup__funding figure{margin-right:25px}}.setup__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.setup__header .widget-button{margin-top:1em}.setup__icon{background:var(--contao);border-radius:10px;padding:10px}.setup__headline{margin-top:20px;margin-bottom:25px;font-size:36px;font-weight:100;line-height:1}.setup__description,.setup__warning{margin:1em 0;text-align:justify}.setup__warning{color:var(--btn-alert);font-weight:600}.setup__form{position:relative;max-width:280px;margin:0 auto 50px;opacity:1}.setup__form svg.setup__check{display:block;width:80px;height:80px;margin:0 auto 2em;fill:var(--btn-primary)}.setup__form .widget-select,.setup__form .widget-text{margin-top:10px}.setup__form .widget-select label,.setup__form .widget-text label{display:block;margin-bottom:5px;font-weight:400}.setup__form .widget-checkbox{margin-top:20px;font-weight:400}.setup__form .widget-radio-button{margin-top:20px}.setup__fields{margin-bottom:2em}.setup__fields--center{text-align:center}.setup__fields .button-group .widget-button{margin-bottom:1px}.setup__fieldtitle{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.setup__fielddesc{margin-bottom:1em;text-align:left}.setup__fielddesc code{word-break:break-word}.setup__actions{display:flex;flex-wrap:wrap;gap:10px}.setup__actions--center{justify-content:center}.setup__actions .button-group,.setup__actions .widget-button{flex-grow:1}.setup__actions .button-group--inline,.setup__actions .widget-button--inline{flex-grow:0}@media(min-width:960px){.setup{padding-top:100px}.setup__header{float:left;width:470px;max-width:none;padding:0 60px 50px}.setup__form{float:left;width:370px;max-width:none;margin:0 50px 50px}.setup__form .widget-select label,.setup__form .widget-text label{display:block;float:left;width:120px;padding-top:10px;font-weight:400}.setup__form .widget-select input,.setup__form .widget-select select,.setup__form .widget-text input,.setup__form .widget-text select{width:250px!important}}.config-check__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.config-check__icon{background:var(--contao);border-radius:10px;padding:10px}.config-check__headline{margin-top:20px;margin-bottom:25px;font-size:36px;font-weight:100;line-height:1}.config-check__description{text-align:justify}.config-check__form{position:relative;max-width:280px;margin:0 auto 50px}.config-check__form .widget-select,.config-check__form .widget-text{margin-top:20px}.config-check__form .widget-select label,.config-check__form .widget-text label{display:block;margin-bottom:5px;font-weight:400}.config-check__fields{margin-bottom:2em}.config-check__fieldtitle{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.config-check__fielddesc{margin-bottom:1em}.config-check__issues{margin-bottom:1em;color:var(--btn-alert)}.config-check__issues p{font-weight:600}.config-check__issues ul{margin:0;padding:0}.config-check__issues li{margin:.5em 0 0 25px;padding:0}.config-check .widget-button{margin-bottom:.5em}@media(min-width:960px){.config-check{padding-top:100px}.config-check__header{float:left;width:470px;max-width:none;padding:0 60px 100px}.config-check__form{float:left;width:370px;max-width:none;margin:20px 50px 0;padding-bottom:100px}.config-check__form .widget-select label,.config-check__form .widget-text label{display:block;float:left;width:120px;padding-top:10px;font-weight:400}}.database-migration__header{margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.database-migration__icon{background:var(--contao);border-radius:10px;padding:10px}.database-migration__headline{margin-top:.5em;margin-bottom:.5em;font-size:36px;font-weight:100;line-height:1}.database-migration__description{margin:0 50px;font-weight:600}.database-migration__actions{display:flex;flex-direction:column;justify-content:center;align-items:center;margin-top:2em;padding:0 50px}@media(min-width:960px){.database-migration__actions{flex-direction:row}}.database-migration .widget-button{width:280px;height:35px;margin:5px;padding:0 30px;line-height:35px}@media(min-width:960px){.database-migration .widget-button{width:auto}}.database-migration__main{margin:0 50px 50px;background:#24292e}.database-migration__loading{width:30px;margin:40px auto}.database-migration__loading .sk-circle{width:30px;height:30px}.link-more{position:relative;display:inline-block}p:empty+.link-more{margin-left:0}.link-more button{width:auto;height:auto;padding:0 0 5px;background:transparent;color:var(--link);font-size:13px;font-weight:300;line-height:inherit;border:none;cursor:pointer}.link-more button:hover{text-decoration:underline}.link-more__menu{outline:none}.link-more ul{transform:translateX(-50%)}.package-link{display:flex;column-gap:8px;justify-content:space-between;width:100%;padding-bottom:4px;margin-bottom:4px;border-bottom:1px solid var(--border--light)}.package-link:last-child{padding-bottom:0;margin-bottom:0;border-bottom:none}.package-link__details{padding:5px 0;line-height:18px}.package-link__name{display:inline;font-weight:600}.package-link__name:after{content:": "}.package-link__text{display:inline}.package-link__actions{display:flex;margin-left:20px;margin:0 -4px}.package-link__actions>*{margin:0 4px}.package-link--limit .package-link__details{display:flex}.package-link--limit .package-link__name{white-space:nowrap}.package-link--limit .package-link__text{display:-webkit-box;overflow:hidden;line-clamp:1;-webkit-line-clamp:1;-webkit-box-orient:vertical;padding:0 10px 0 5px}.package-funding[data-v-5a8fd14b]{padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--funding-rgb),.025) url(../img/funding.cf78a0a0.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid rgba(var(--funding-rgb),.5);border-radius:6px}.package-funding>div[data-v-5a8fd14b]{overflow:hidden}.package-funding span[data-v-5a8fd14b]{margin-right:15px}.package-funding a[data-v-5a8fd14b]{position:relative;display:inline-block;margin:0 20px 0 0;padding-left:16px;color:var(--funding);background:url(../img/link-funding.b25cd92d.svg) 0 50% no-repeat;background-size:13px 13px}.package-funding a[data-v-5a8fd14b]:before{content:"|";position:absolute;left:-12px}.package-funding a[data-v-5a8fd14b]:nth-child(2):before{content:none}.package-popup{position:fixed;display:flex;flex-direction:column;justify-content:flex-start;width:100%;max-width:none;height:100%;background:var(--popup-bg);z-index:10;opacity:1}.package-popup>*{flex-basis:auto;flex-grow:1}.package-popup__loader{display:flex;flex-direction:column;align-items:center;justify-content:center;padding:50px 0}.package-popup__loader p{margin:1em}.package-popup__headline{position:relative;flex-grow:0;flex-shrink:1;padding:7px 30px 6px;background:var(--popup-hl-bg);color:#fff;font-size:18px;font-weight:300;line-height:1.5;text-align:center}.package-popup__button{display:block;float:right;position:absolute;top:0;margin:4px 0;padding:4px;background:none;border:1px solid transparent;border-radius:5px;cursor:pointer}.package-popup__button--previous{left:4px}.package-popup__button--close{right:4px}.package-popup__button svg{display:block;width:22px;height:22px}.package-popup__button:hover{background-color:#db6f00}.package-popup__summary{flex-grow:0;padding:25px 35px}@media(min-width:600px){.package-popup__summary{display:flex}}.package-popup__logo{border-radius:6px;float:right;height:60px;width:60px;margin-left:1em;background:#f7f7f7}@media(min-width:600px){.package-popup__logo{display:block;float:left;width:110px;height:110px;margin:-10px 16px 0 -10px}}.package-popup__icon{display:flex;align-items:center;justify-content:center;height:100%}.package-popup__icon--fallback{display:none}.package-popup__icon img{width:50px;height:50px;max-height:100%;object-fit:contain}@media(min-width:600px){.package-popup__icon img{width:90px;height:90px}}.package-popup__text{display:flex;flex-direction:column;flex-grow:1}@media(min-width:600px){.package-popup__text{width:200px}}.package-popup__title{margin:0;line-height:1.4;overflow-wrap:break-word}.package-popup__authors{flex-grow:1;font-size:13px;margin-bottom:.5em}.package-popup__author{display:inline-block;margin-right:2px}.package-popup__author:after{color:var(--text);content:", "}.package-popup__author:last-child:after{content:none}.package-popup__stats{display:inline-block;margin-right:15px;margin-top:.5em;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.package-popup__stats--private{padding-left:20px;background-image:var(--svg--private);background-size:15px 15px}.package-popup__stats--updated{background-image:var(--svg--updated)}.package-popup__stats--downloads{background-image:var(--svg--downloads)}.package-popup__stats--favers{background-image:var(--svg--favers)}.package-popup__actions{display:flex;flex-direction:column;gap:10px;margin-top:1em}@media(min-width:600px){.package-popup__actions{justify-content:space-between;margin:0 0 0 25px;width:200px}}.package-popup__installed{margin-top:1em}.package-popup__abandoned{margin:0 0 20px;padding:10px 20px 10px 50px;font-weight:400;font-size:12px;line-height:1.8;background:rgba(var(--hint-rgb),.3) url(../img/hint.ba2ac97e.svg) 15px 50% no-repeat;background-size:23px 23px;border:1px solid var(--hint-link);border-radius:6px}.package-popup__funding{margin:0 0 20px}.package-popup__tabs{position:relative;flex-grow:revert}.package-popup__tabs:after,.package-popup__tabs:before{content:"";display:block;position:absolute;top:0;bottom:1px;width:7px;background:linear-gradient(-90deg,transparent 0,var(--popup-bg) 50%);z-index:1;pointer-events:none}.package-popup__tabs:after{background:linear-gradient(90deg,transparent 0,var(--popup-bg) 50%);right:0}.package-popup__tabs-list{flex-shrink:0;flex-grow:0;display:flex;column-gap:4px;height:40px;min-width:100%;overflow-x:auto;scrollbar-width:none;overflow-y:hidden;margin:0;padding:0 7px;list-style-type:none}.package-popup__tabs-list:after{content:"";position:absolute;inset:auto 0 0;height:1px;background:var(--border--light);z-index:-1}.package-popup__tab{position:relative;top:1px;flex-grow:1;padding:0;height:39px;line-height:39px;text-align:center;border:1px solid var(--border--light);border-top-left-radius:6px;border-top-right-radius:6px}.package-popup__tab--active{background:var(--tab-content);border-bottom:1px solid var(--tab-content)}.package-popup__tab button{display:flex;justify-content:center;align-items:center;width:100%;height:100%;margin:0;padding:0 10px;border:none;background:transparent;cursor:pointer}.package-popup__tab button:disabled{color:var(--border)!important;cursor:not-allowed}.package-popup__pill{position:relative;top:-2px;display:inline-block;margin-left:5px;padding:2px 5px;font-size:10px;font-weight:400;background:var(--border--light);border-radius:40%}.package-popup__pill--highlight{color:var(--clr-btn);background:var(--btn-primary)}.package-popup__tabcontent{position:relative;padding:25px 35px;overflow-y:auto;background:var(--tab-content);outline:0}@media(min-width:960px)and (min-height:700px){.package-popup__tabcontent{height:450px}}.package-popup__description{margin:1em 0;white-space:pre-wrap}@media(min-width:960px){.package-popup{position:relative;display:block;top:0;left:50%;width:750px;margin-left:-375px;height:auto;border-radius:8px;transform:none}.package-popup__headline{border-radius:8px 8px 0 0}.package-popup__tabcontent{border-radius:0 0 8px 8px}}@media(min-width:960px)and (min-height:700px){.package-popup{position:absolute;top:50%;transform:translateY(-50%)}}.package-popup__installed strong{margin-right:5px}@media(min-width:600px){.package-popup__installed{display:flex;flex-direction:column;justify-content:flex-end;text-align:center}.package-popup__installed strong{display:block;margin:0}}.package-popup__update{background:var(--btn-primary) url(../img/button-update.ad79c617.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__incompatible,.package-popup__update{margin:0 0 20px;padding:10px 20px 10px 50px;color:var(--clr-btn);border-radius:var(--border-radius)}.package-popup__incompatible{background:var(--contao) url(../img/button-incompatible.3eb2b686.svg) 15px 50% no-repeat;background-size:23px 23px}.package-popup__funding+.package-popup__update{margin-top:-10px}.view-account__header{max-width:280px;margin-left:auto;margin-right:auto;padding:40px 0;text-align:center}.view-account__product{margin-top:15px;margin-bottom:40px;font-weight:600}.view-account__product strong{display:block;margin-bottom:10px;font-size:54px;font-weight:100;line-height:1}.view-account__headline{margin-bottom:.5em;font-size:18px;font-weight:600;line-height:30px}.view-account__description{margin-bottom:1em;text-align:justify}.view-account__form,.view-account__totp{position:relative;max-width:280px;margin:0 auto}.view-account__form .widget-button,.view-account__totp .widget-button{margin-top:1.5em}.view-account__form .widget-text{margin-top:10px}.view-account__form .widget-text label{display:block;padding-bottom:5px}.view-account__contribute{max-width:280px;margin:60px auto 0;font-size:12px;text-align:center}.view-account__contribute br{display:none}@media(min-width:960px){.view-account{display:flex;flex-flow:row wrap;align-items:center;padding-top:50px}.view-account__form,.view-account__header,.view-account__totp{padding:50px;width:50%;max-width:none}.view-account__form .widget-text label{float:left;width:120px;padding-top:10px;font-weight:400}.view-account__form input[type=password],.view-account__form input[type=text],.view-account__form select{width:250px!important}.view-account__form .button-group,.view-account__form .widget-button--anchor{width:250px;margin-left:120px}.view-account__contribute{max-width:840px}.view-account__contribute br{display:block}}.popup-overlay{position:fixed;inset:0;z-index:1000;background:var(--popup-overlay-bg)}@media(min-width:960px){.popup-overlay{padding:20px 0;overflow-y:auto}}.popup-overlay__popup{position:fixed;display:block;top:50%;left:50%;width:500px;max-width:90%;background:var(--popup-bg);z-index:10;opacity:1;transform:translate(-50%,-50%);border-radius:var(--border-radius);overflow:hidden}.popup-overlay__headline{position:relative;margin-bottom:0;padding:7px 30px 6px;background:var(--popup-hl-bg);font-size:18px;color:#fff;font-weight:300;line-height:1.5em;text-align:center}.popup-overlay__headline--primary{background-color:var(--btn-primary)}.popup-overlay__headline--alert{background-color:var(--btn-alert)}.popup-overlay__content{padding:2em 20px}.popup-overlay__actions{display:flex;justify-content:center;gap:10px;flex-wrap:wrap;padding:0 20px 2em}.popup-overlay__actions .widget-button{width:auto;height:35px;padding:0 30px;line-height:35px}@media(min-width:550px){.popup-overlay__actions,.popup-overlay__content{padding-left:40px;padding-right:40px}}.loader__item{float:left;width:16px;height:16px;margin-right:1px;background-color:var(--contao);animation:loading 1.4s ease-in-out infinite both}.loader__item--20{animation-delay:-.64s}.loader__item--40{animation-delay:-.48s}.loader__item--60{animation-delay:-.32s}.loader__item--80{animation-delay:-.16s}@keyframes loading{0%,90%,to{opacity:0}20%{opacity:1}}.loader__text{float:left;width:40px}.sk-circle{width:25px;height:25px;position:relative}.sk-circle .sk-child{width:100%;height:100%;position:absolute;left:0;top:0}.sk-circle .sk-child:before{content:"";display:block;margin:0 auto;width:15%;height:15%;background-color:var(--text);border-radius:100%;animation:sk-circleBounceDelay 1.2s ease-in-out infinite both}.sk-circle .sk-circle2{transform:rotate(30deg)}.sk-circle .sk-circle3{transform:rotate(60deg)}.sk-circle .sk-circle4{transform:rotate(90deg)}.sk-circle .sk-circle5{transform:rotate(120deg)}.sk-circle .sk-circle6{transform:rotate(150deg)}.sk-circle .sk-circle7{transform:rotate(180deg)}.sk-circle .sk-circle8{transform:rotate(210deg)}.sk-circle .sk-circle9{transform:rotate(240deg)}.sk-circle .sk-circle10{transform:rotate(270deg)}.sk-circle .sk-circle11{transform:rotate(300deg)}.sk-circle .sk-circle12{transform:rotate(330deg)}.sk-circle .sk-circle2:before{animation-delay:-1.1s}.sk-circle .sk-circle3:before{animation-delay:-1s}.sk-circle .sk-circle4:before{animation-delay:-.9s}.sk-circle .sk-circle5:before{animation-delay:-.8s}.sk-circle .sk-circle6:before{animation-delay:-.7s}.sk-circle .sk-circle7:before{animation-delay:-.6s}.sk-circle .sk-circle8:before{animation-delay:-.5s}.sk-circle .sk-circle9:before{animation-delay:-.4s}.sk-circle .sk-circle10:before{animation-delay:-.3s}.sk-circle .sk-circle11:before{animation-delay:-.2s}.sk-circle .sk-circle12:before{animation-delay:-.1s}@keyframes sk-circleBounceDelay{0%,80%,to{transform:scale(0)}40%{transform:scale(1)}}.widget-button .loader{width:25px;margin:0 auto}.widget-button .sk-circle .sk-child:before{background-color:#fff}.loading-button{position:relative}.loading-button>.loader{position:absolute;left:calc(50% - 12.5px);top:calc(50% - 12.5px)}.loading-button>.loading{visibility:hidden}.link-menu{position:absolute;display:grid;grid-template:1fr/1fr;left:50%;gap:2px;margin:0;padding:2px;text-align:center;list-style-type:none;white-space:nowrap;background:var(--form-bg);border-top:3px solid var(--text);border-radius:5px;z-index:100;box-shadow:0 0 1px var(--shadow);outline:none}.link-menu:before{position:absolute;left:50%;top:-7px;width:0;height:0;margin-left:-4px;border-style:solid;border-width:0 3.5px 4px 3.5px;border-color:transparent transparent var(--text) transparent;content:""}.link-menu--align-left{left:0;right:auto}.link-menu--align-left:before{left:17px;right:auto}.link-menu--align-right{left:auto;right:0}.link-menu--align-right:before{left:auto;right:17px}.link-menu--valign-top{bottom:0;border-top:none;border-bottom:3px solid var(--text);box-shadow:0 0 2px var(--shadow)}.link-menu--valign-top:before{top:auto;bottom:-7px;border-width:4px 3.5px 0 3.5px;border-color:var(--text) transparent transparent transparent}.link-menu--contao{border-color:var(--contao)}.link-menu--contao:before{border-bottom-color:var(--contao)}.link-menu--contao.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--contao)}.link-menu--primary{border-color:var(--btn-primary)}.link-menu--primary:before{border-bottom-color:var(--btn-primary)}.link-menu--primary.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-primary)}.link-menu--warning{border-color:var(--btn-warning)}.link-menu--warning:before{border-bottom-color:var(--btn-warning)}.link-menu--warning.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-warning)}.link-menu--alert{border-color:var(--btn-alert)}.link-menu--alert:before{border-bottom-color:var(--btn-alert)}.link-menu--alert.link-menu--valign-top:before{border-bottom-color:transparent;border-top-color:var(--btn-alert)}.link-menu__item{margin:0;padding:0;display:block}.link-menu__action{display:block;width:100%;border-radius:5px;padding:8px 16px;color:var(--text);font-size:inherit;text-align:center;background:none;border:none;cursor:pointer}.link-menu__action:hover{color:var(--text);background:var(--focus);text-decoration:none}.link-menu__action--active{font-weight:600;background:var(--focus)}.footer-languages{position:relative;display:inline-block}.footer-languages__toggle{width:auto;height:auto;padding:0 0 0 25px;background:transparent;color:var(--text);font-size:12px;font-weight:300;line-height:20px;background:var(--svg--language) left center no-repeat;background-size:20px 20px;border:none;cursor:pointer}.footer-languages__toggle:hover{color:var(--black)}.footer-languages__menu{display:grid;grid-template:auto/1fr 1fr;bottom:25px;white-space:nowrap;transform:translateX(-50%)}.footer-languages__menu button{margin:0;padding:6px;text-align:left;font-size:inherit}.theme-switch{position:relative;display:inline-block}.theme-switch button{width:auto;height:auto;padding:0 0 0 24px;background:transparent;color:var(--text);font-size:12px;font-weight:300;line-height:20px;background:var(--svg--color-scheme) left center no-repeat;background-size:20px 20px;border:none;cursor:pointer}.theme-switch button:hover{color:var(--black)}.package-logo--fallback[data-v-9c1c5f6c]{display:flex;justify-content:center;align-items:center}svg[data-v-9c1c5f6c]{width:80px;height:80px;fill:#ccc}.discover-package{display:flex;flex-direction:column;position:relative;overflow:hidden;background:var(--tiles-bg);border:1px solid var(--tiles-bdr);border-radius:14px}.discover-package.is--hint{border-color:var(--border--light)}.discover-package.is--hint .discover-package__inside>*{opacity:.65}.discover-package__hint{position:relative;background:var(--border--light);padding:8px 16px;font-weight:400;font-size:12px;line-height:1.2;z-index:1}.discover-package__hint p a{display:inline-block;padding-right:10px}.discover-package__hint p a:first-child{margin-left:10px}.discover-package__hint p a:not(:first-child):before{padding-right:10px;content:"|"}.discover-package__inside{flex-grow:1;padding:16px}.discover-package__abandoned{display:inline-block;margin-bottom:1em;padding:2px 5px;color:#fff;font-size:12px;font-weight:600;background:var(--btn-alert);cursor:help;z-index:10}@media(min-width:600px){.discover-package__abandoned{position:absolute;top:20px;left:-25px;padding:2px 30px;border-top:1px solid var(--btn-alert-active);transform:rotate(-45deg)}}.discover-package__icon{border-radius:6px;height:60px;width:60px;background:#f7f7f7;margin:0 auto 10px;position:absolute;right:16px}.discover-package__icon>figure{display:flex;align-items:center;justify-content:center;height:100%;max-height:140px}.discover-package__icon img,.discover-package__icon svg{border-radius:4px;width:50px;height:50px;max-height:100%;object-fit:contain}.discover-package__details{display:flex;flex-direction:column;justify-content:space-between;min-height:96px}.discover-package__headline{margin-bottom:.2em;line-height:1;overflow-wrap:break-word;margin-right:70px}.discover-package__headline em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.discover-package__versions{display:flex;flex-wrap:wrap;gap:5px;list-style:none;margin:5px 0;padding:0}.discover-package__version{display:inline-flex;justify-content:center;padding:3px 5px;border-radius:4px;line-height:1;min-width:40px;font-size:13px;color:#fff;background:var(--badge-bg);pointer-events:none}.discover-package__description{display:-webkit-box;overflow:hidden;-webkit-line-clamp:2;-webkit-box-orient:vertical;margin-bottom:1em;margin-right:70px}.discover-package__description em{background-color:var(--highlight-bg);color:var(--highlight-color);font-style:normal}.discover-package__more{display:flex;flex-flow:row wrap;align-items:flex-end;flex-grow:1;gap:4px;line-height:28px}.discover-package__counts{flex-grow:1;justify-content:flex-start}.discover-package__count{display:inline-block;margin-right:15px;padding-left:18px;font-size:13px;background-position:0 50%;background-repeat:no-repeat;background-size:13px 13px}.discover-package__count--private{background-image:var(--svg--private)}.discover-package__count--updated{background-image:var(--svg--updated)}.discover-package__count--downloads{background-image:var(--svg--downloads)}.discover-package__count--favers{background-image:var(--svg--favers)}.discover-package__actions{flex-grow:1;display:flex;justify-content:flex-end;gap:8px}@media(max-width:599.98px){.discover-package__headline-container{display:flex;flex-direction:column-reverse}}@media(min-width:600px){.discover-package__inside{text-align:initial;display:flex;padding:0}.discover-package__icon{width:130px;height:100%;min-height:130px;margin:0;border-radius:0;position:revert;right:revert}.discover-package__icon img{width:100px;height:100px}.discover-package__icon svg{width:90px;height:90px}.discover-package__details{padding:16px;height:100%;min-height:90px;max-width:calc(100% - 130px);flex:1}.discover-package__versions{float:right;margin:-3px 0 0 16px}.discover-package__description,.discover-package__headline{margin-right:0}.discover-package__more{flex-direction:row}.discover-package__actions{justify-content:end}}.vueperslide{white-space:normal;background-size:cover;flex-shrink:0;display:block;width:100%;position:relative}.vueperslide--clone-1{position:absolute;top:0;bottom:0;right:100%}.vueperslides--rtl .vueperslide--clone-1{right:auto;left:100%}.vueperslide[href]{-webkit-user-drag:none}.vueperslide__image{background-size:cover}.vueperslide__image,.vueperslide__loader{position:absolute;top:0;left:0;right:0;bottom:0}.vueperslide__loader{display:flex;flex-direction:column;align-items:center;justify-content:center}.vueperslide__content-wrapper:not(.vueperslide__content-wrapper--outside-top):not(.vueperslide__content-wrapper--outside-bottom){height:100%;margin:auto}.vueperslides--fade .vueperslide{position:absolute;top:0;left:0;right:0;bottom:0;opacity:0;transition:opacity ease-in-out;transition-duration:inherit}.vueperslides--fade .vueperslide--active,.vueperslides--fade .vueperslide--visible{z-index:1;opacity:1}.vueperslides--slide-image-inside .vueperslide{overflow:hidden}.vueperslides--3d .vueperslide{position:absolute;z-index:-1;height:100%}.vueperslides--3d .vueperslide--active,.vueperslides--3d .vueperslide--next-slide,.vueperslides--3d .vueperslide--previous-slide{z-index:0}.vueperslides--3d .vueperslide--active{z-index:1}.vueperslides--3d .vueperslide[face=front]{transform:rotateY(90deg) translate(-50%) rotateY(-90deg)}.vueperslides--3d .vueperslide[face=right]{transform:rotateY(90deg) translate(50%);transform-origin:100% 0}.vueperslides--3d .vueperslide[face=back]{transform:rotateY(270deg) translate(-50%) rotateY(-90deg)}.vueperslides--3d .vueperslide[face=left]{transform:rotateY(270deg) translate(-50%);transform-origin:0 0}.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:after,.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:before{content:"";position:absolute;bottom:100%;left:-1em;right:-1em;height:2em;box-shadow:0 0 20px #00000040;z-index:2}.vueperslides:not(.no-shadow):not(.vueperslides--3d) .vueperslides__parallax-wrapper:after{top:100%;bottom:auto}.vueperslides__arrows{color:#fff}.vueperslides__arrows--outside{color:currentColor}.vueperslides__arrow{top:50%;background-color:transparent;border:none;opacity:.7}.vueperslides--rtl .vueperslides__arrow--next,.vueperslides__arrow--prev{right:auto;left:.5em}.vueperslides--rtl .vueperslides__arrow--prev,.vueperslides__arrow--next{left:auto;right:.5em}.vueperslides__arrow:hover{opacity:1}.vueperslides--rtl .vueperslides__arrows--outside .vueperslides__arrow--next,.vueperslides__arrows--outside .vueperslides__arrow--prev{right:auto;left:-3.5em}.vueperslides--rtl .vueperslides__arrows--outside .vueperslides__arrow--prev,.vueperslides__arrows--outside .vueperslides__arrow--next{left:auto;right:-3.5em}.vueperslides__paused{top:.7em;right:.7em;opacity:0;text-shadow:0 0 3px rgba(0,0,0,.4);z-index:1}.vueperslides:hover .vueperslides__paused{opacity:1}.vueperslides__bullets:not(.vueperslides__bullets--outside){color:#fff}.vueperslides__bullet{margin:1.5em .6em;padding:0;border:none;background:none}.vueperslides__bullet .default{width:12px;height:12px;border-radius:12px;border:1px solid currentColor;background-color:transparent;box-shadow:0 0 1px #00000080,0 0 3px #0000004d;transition:.4s ease-in-out;box-sizing:border-box}.vueperslides__bullet .default span{display:none}.vueperslides__bullet--active .default{border-width:6px}.vueperslide,.vueperslide__image{background-position:50%}.vueperslide__video{outline:none}.vueperslide--no-pointer-events:before{content:"";position:absolute;top:0;bottom:0;left:0;right:0}.vueperslide__content-wrapper:not(.vueperslide__content-wrapper--outside-top):not(.vueperslide__content-wrapper--outside-bottom){display:flex;flex:1 1 auto;flex-direction:column;align-items:center;justify-content:center;text-align:center}.vueperslide--has-image-inside .vueperslide__content-wrapper,.vueperslide--has-video .vueperslide__content-wrapper,.vueperslide__content-wrapper.parallax-fixed-content{position:absolute;z-index:2;top:0;bottom:0;left:0;right:0;display:flex;flex-direction:column;justify-content:center;align-items:center;pointer-events:none}.vueperslides{position:relative}.vueperslides--fixed-height .vueperslide,.vueperslides--fixed-height .vueperslides__inner,.vueperslides--fixed-height .vueperslides__parallax-wrapper{height:inherit}.vueperslides--fixed-height .vueperslides__parallax-wrapper{padding-bottom:0!important}.vueperslides--fixed-height.vueperslides--bullets-outside{margin-bottom:4em}.vueperslides__inner{position:relative;-webkit-user-select:none;-moz-user-select:none;user-select:none}.vueperslides__parallax-wrapper{position:relative;overflow:hidden}.vueperslides--3d .vueperslides__parallax-wrapper{overflow:visible}.vueperslides__track{position:absolute;top:0;height:100%;left:0;right:0;overflow:hidden;z-index:1}.vueperslides--parallax .vueperslides__track{height:200%;transform:translateY(0)}.vueperslides--touchable .vueperslides__track{cursor:ew-resize;cursor:grab}.vueperslides--touchable .vueperslides__track--dragging,.vueperslides--touchable .vueperslides__track--mousedown{cursor:grabbing}.vueperslides--3d .vueperslides__track{overflow:visible;perspective:100em}.vueperslides__track-inner{white-space:nowrap;transition:transform .5s ease-in-out;height:100%;display:flex}.vueperslides--no-animation .vueperslides__track-inner{transition-duration:0s!important}.vueperslides--fade .vueperslides__track-inner{white-space:normal;transition:none}.vueperslides--3d .vueperslides__track-inner{transform-style:preserve-3d}.vueperslides__track--mousedown .vueperslides__track-inner{transition:transform .25s ease-in-out!important}.vueperslides__track--dragging .vueperslides__track-inner{transition:none}.vueperslides__arrow{position:absolute;font-size:inherit;color:inherit;text-align:center;transform:translateY(-50%);transition:.3s ease-in-out;cursor:pointer;-webkit-user-select:none;-moz-user-select:none;user-select:none;outline:none;z-index:2;line-height:1}.vueperslides__arrow svg{vertical-align:middle;stroke:currentColor;fill:none;width:3.5em;padding:1em;stroke-width:1;transition:.3s ease-in-out;box-sizing:border-box}.vueperslides__arrow svg:hover{stroke-width:1.3}.vueperslides__paused{position:absolute;transition:.3s ease-in-out}.vueperslides__bullets{display:flex;justify-content:center;position:absolute;bottom:0;left:0;right:0}.vueperslides__bullets--outside{position:relative}.vueperslides__bullet,.vueperslides__bullets button{cursor:pointer;-webkit-user-select:none;-moz-user-select:none;user-select:none;outline:none;z-index:2;display:flex;justify-content:center;align-items:center;color:inherit}.vueperslides__bullet::-moz-focus-inner,.vueperslides__bullets button::-moz-focus-inner{border:0}.vueperslides__fractions{position:absolute;top:.8em;left:.5em;z-index:2;padding:.2em 1em;border:1px solid hsla(0,0%,100%,.5);border-radius:2em;background:#fff3;color:#fff}.vueperslides__progress{position:absolute;top:0;left:0;right:0;z-index:2;height:6px;color:#000000b3}.vueperslides__progress>*{position:absolute;top:0;bottom:0;left:0;background:currentColor;transition:.3s ease-in-out}@media(min-width:1200px){.ads{margin:59px 0 69px}}.ads .link{padding-top:5px;text-align:right}.ads .link a{padding-left:16px;font-size:.8em;color:inherit;background:var(--svg--link-blank) left center no-repeat;background-size:13px 13px}.ads .container{position:relative;background:var(--popup-bg);box-shadow:var(--ad-shadow);border-radius:14px;overflow:hidden}.ads .container a,.ads .container img{display:block}.ads .container img{width:100%;aspect-ratio:2}.vueperslides__arrow:focus-visible{outline:5px auto Highlight!important;outline:5px auto -webkit-focus-ring-color!important}.package-sorting{margin:20px 0 15px;text-align:right}.package-sorting__label{display:inline-block;text-transform:uppercase}.package-sorting__label:after{content:":"}.package-sorting__group{position:relative;display:inline-flex;flex-direction:column;margin:0;padding:0 15px 0 0;list-style-type:none;text-align:left}.package-sorting__group:after{content:"";position:absolute;top:.8em;right:0;width:0;height:0;border-left:5px solid transparent;border-right:5px solid transparent;border-top:5px solid #777}.package-sorting__item{display:none;margin:0 0 0 10px;padding:3px 0;border-bottom:2px solid transparent}.package-sorting__item:hover{color:var(--link)}.package-sorting__item--open{display:inline}.package-sorting__item--active{display:inline;color:var(--link);border-bottom:2px solid var(--link)}.package-sorting__item button{margin:0;padding:0;background:none;border:none;text-transform:uppercase;cursor:pointer}@media(min-width:600px){.package-sorting__group{flex-direction:row;justify-content:flex-end;padding:0}.package-sorting__group:after{content:none}.package-sorting__item{display:inline}}.search-bar{position:relative}.search-bar__input{height:50px!important;padding-right:45px!important;border-radius:50px!important}.search-bar__button{position:absolute;top:5px;right:5px;display:flex;align-items:center;width:38px;height:40px;margin:0;padding:7px;line-height:36px;border:none;border-radius:0 50px 50px 0;background:none}.package-search{position:relative}.package-search__input{max-width:400px;margin:0 20px}@media(min-width:1024px){.package-search__input{margin-right:0}}.package-search__headline{font-size:18px;font-weight:300;margin:30px 0 10px}.package-search__results{display:grid;gap:20px;margin-bottom:20px}@media(min-width:1024px){.package-search__results{grid-template-columns:repeat(2,1fr)}}.package-search__status{margin:100px 0;text-align:center;font-size:20px;line-height:1.5em}.package-search__status--empty{padding-top:140px;background:url(../img/sad.c7de6e95.svg) top no-repeat;background-size:100px 100px}.package-search__status--offline{padding-top:140px;background:url(../img/offline.0c23d1ce.svg) top no-repeat;background-size:100px 100px}.package-search__status--loader .sk-circle{width:100px;height:100px;margin:0 auto 40px}.package-search__status button{margin-top:2em}.package-search__explain{font-size:16px}.package-search__more{margin:10px 0 30px;text-align:center}.package-search__more-button{display:inline-block;margin:0 auto;padding:0;text-transform:uppercase;background:none;border:none;cursor:pointer}.package-search__more-button:hover{text-decoration:underline}.package-search__algolia{display:block;width:200px;margin:50px auto 0}.vjs-tree-brackets{cursor:pointer}.vjs-tree-brackets:hover{color:#1890ff}.vjs-check-controller{position:absolute;left:0}.vjs-check-controller.is-checked .vjs-check-controller-inner{background-color:#1890ff;border-color:#0076e4}.vjs-check-controller.is-checked .vjs-check-controller-inner.is-checkbox:after{-webkit-transform:rotate(45deg) scaleY(1);transform:rotate(45deg) scaleY(1)}.vjs-check-controller.is-checked .vjs-check-controller-inner.is-radio:after{-webkit-transform:translate(-50%,-50%) scale(1);transform:translate(-50%,-50%) scale(1)}.vjs-check-controller .vjs-check-controller-inner{display:inline-block;position:relative;border:1px solid #bfcbd9;border-radius:2px;vertical-align:middle;-webkit-box-sizing:border-box;box-sizing:border-box;width:16px;height:16px;background-color:#fff;z-index:1;cursor:pointer;-webkit-transition:border-color .25s cubic-bezier(.71,-.46,.29,1.46),background-color .25s cubic-bezier(.71,-.46,.29,1.46);transition:border-color .25s cubic-bezier(.71,-.46,.29,1.46),background-color .25s cubic-bezier(.71,-.46,.29,1.46)}.vjs-check-controller .vjs-check-controller-inner:after{-webkit-box-sizing:content-box;box-sizing:content-box;content:"";border:2px solid #fff;border-left:0;border-top:0;height:8px;left:4px;position:absolute;top:1px;-webkit-transform:rotate(45deg) scaleY(0);transform:rotate(45deg) scaleY(0);width:4px;-webkit-transition:-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;transition:transform .15s cubic-bezier(.71,-.46,.88,.6) .05s,-webkit-transform .15s cubic-bezier(.71,-.46,.88,.6) .05s;-webkit-transform-origin:center;transform-origin:center}.vjs-check-controller .vjs-check-controller-inner.is-radio{border-radius:100%}.vjs-check-controller .vjs-check-controller-inner.is-radio:after{border-radius:100%;height:4px;background-color:#fff;left:50%;top:50%}.vjs-check-controller .vjs-check-controller-original{opacity:0;outline:none;position:absolute;z-index:-1;top:0;left:0;right:0;bottom:0;margin:0}.vjs-carets{position:absolute;right:0;cursor:pointer}.vjs-carets svg{-webkit-transition:-webkit-transform .3s;transition:-webkit-transform .3s;transition:transform .3s;transition:transform .3s,-webkit-transform .3s}.vjs-carets:hover{color:#1890ff}.vjs-carets-close{-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.vjs-tree-node{display:-webkit-box;display:-ms-flexbox;display:flex;position:relative;line-height:20px}.vjs-tree-node.has-carets{padding-left:15px}.vjs-tree-node.has-carets.has-selector,.vjs-tree-node.has-selector{padding-left:30px}.vjs-tree-node.is-highlight,.vjs-tree-node:hover{background-color:#e6f7ff}.vjs-tree-node .vjs-indent{display:-webkit-box;display:-ms-flexbox;display:flex;position:relative}.vjs-tree-node .vjs-indent-unit{width:1em}.vjs-tree-node .vjs-indent-unit.has-line{border-left:1px dashed #bfcbd9}.vjs-tree-node.dark.is-highlight,.vjs-tree-node.dark:hover{background-color:#2e4558}.vjs-node-index{position:absolute;right:100%;margin-right:4px;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.vjs-colon{white-space:pre}.vjs-comment{color:#bfcbd9}.vjs-value{word-break:break-word}.vjs-value-null,.vjs-value-undefined{color:#d55fde}.vjs-value-boolean,.vjs-value-number{color:#1d8ce0}.vjs-value-string{color:#13ce66}.vjs-tree{font-family:Monaco,Menlo,Consolas,Bitstream Vera Sans Mono,monospace;font-size:14px;text-align:left}.vjs-tree.is-virtual{overflow:auto}.vjs-tree.is-virtual .vjs-tree-node{white-space:nowrap}[data-notivue=promise-resolve],[data-notivue=success]{--nv-bg:var(--nv-success-bg);--nv-fg:var(--nv-success-fg);--nv-accent:var(--nv-success-accent,var(--nv-global-accent));--nv-border:var(--nv-success-border)}[data-notivue=error],[data-notivue=promise-reject]{--nv-bg:var(--nv-error-bg);--nv-fg:var(--nv-error-fg);--nv-accent:var(--nv-error-accent,var(--nv-global-accent));--nv-border:var(--nv-error-border)}[data-notivue=warning]{--nv-bg:var(--nv-warning-bg);--nv-fg:var(--nv-warning-fg);--nv-accent:var(--nv-warning-accent,var(--nv-global-accent));--nv-border:var(--nv-warning-border)}[data-notivue=info]{--nv-bg:var(--nv-info-bg);--nv-fg:var(--nv-info-fg);--nv-accent:var(--nv-info-accent,var(--nv-global-accent));--nv-border:var(--nv-info-border)}[data-notivue=promise]{--nv-bg:var(--nv-promise-bg);--nv-fg:var(--nv-promise-fg);--nv-accent:var(--nv-promise-accent,var(--nv-global-accent));--nv-border:var(--nv-promise-border)}.Notivue__notification{--tip-width:calc(var(--tip-width-fx, 1)*var(--nv-tip-width, 0px));box-sizing:border-box;position:relative;width:var(--nv-min-width,auto);max-width:var(--nv-width,100%);background-color:var(--nv-bg,var(--nv-global-bg));display:flex;align-items:var(--nv-y-align);border-radius:var(--nv-radius,0);border:var(--nv-border-width,0) solid var(--nv-border,var(--nv-global-border));box-shadow:var(--nv-shadow,0 0 transparent),inset var(--tip-width) 0 0 var(--nv-accent)}.Notivue__notification *{box-sizing:border-box;touch-action:manipulation}.Notivue__notification[data-notivue-has-title=true]{align-items:var(--nv-y-align-has-title,var(--nv-y-align))}.Notivue__icon{display:flex;justify-content:center;align-items:center;overflow:visible;min-width:var(--nv-icon-size);width:var(--nv-icon-size);height:var(--nv-icon-size);margin:var(--nv-spacing) 0 var(--nv-spacing) var(--nv-spacing);color:var(--nv-accent)}.Notivue__content{--nv-content-space:calc(var(--nv-spacing) + var(--nv-spacing)*0.15);display:flex;flex-direction:column;flex-grow:1;text-align:inherit;padding:var(--nv-content-space)}.Notivue__content-title{line-height:1.15;font-weight:700;color:var(--nv-fg,var(--nv-global-fg));font-size:var(--nv-title-size);margin:0 0 .33em;padding:0}.Notivue__transition-enter-active{--dur-easing:.5s cubic-bezier(.16,1,.3,1);transition:opacity var(--dur-easing),transform var(--dur-easing)}@media (prefers-reduced-motion:reduce){.Notivue__transition-enter-active{transition:none}}.Notivue__transition-enter-from{opacity:0;transform:scale(.8)}.Notivue__transition-enter-to{opacity:1;transform:scale(1)}.Notivue__transition-leave-active{transition:opacity 0ms ease}.Notivue__transition-leave-from,.Notivue__transition-leave-to{opacity:0}.Notivue__content-message{max-height:250px;overflow:auto;line-height:1.375;margin:0;padding:0;white-space:pre-line}.Notivue__close,.Notivue__content-message{color:var(--nv-fg,var(--nv-global-fg));font-size:var(--nv-message-size)}.Notivue__close{position:relative;cursor:pointer;padding:calc(var(--nv-spacing)/2);margin:var(--nv-spacing) var(--nv-spacing) var(--nv-spacing) 0;font-weight:700;border:none;background:none;line-height:1;-webkit-tap-highlight-color:rgba(0,0,0,0)}.Notivue__close:after{content:"";position:absolute;top:0;right:0;bottom:0;left:0;width:100%;height:100%;background-color:var(--nv-fg,var(--nv-global-fg));opacity:0;border-radius:calc(var(--nv-radius)/2);transition:opacity .1s ease-out}@media (hover:hover){.Notivue__close:hover{opacity:1}.Notivue__close:hover:after{opacity:.1}.Notivue__close:hover .Notivue__close-icon{opacity:1}}.Notivue__close-icon{width:var(--nv-icon-size);height:var(--nv-icon-size);display:flex;color:var(--nv-fg,var(--nv-global-fg));pointer-events:none;opacity:.65}.Notivue__spinner{transform-origin:center;animation:Notivue__spinner-kf .75s linear infinite}@keyframes Notivue__spinner-kf{to{transform:rotate(1turn)}}@media (prefers-reduced-motion:reduce){.Notivue__duplicate,.Notivue__spinner{animation:none}}[dir=rtl] .Notivue__notification{--tip-width-fx:-1}[dir=rtl] .Notivue__icon{margin:var(--nv-spacing) var(--nv-spacing) var(--nv-spacing) 0}[dir=rtl] .Notivue__content-message{font-size:calc(var(--nv-message-size) + .1em)}[dir=rtl] .Notivue__content-title{font-size:calc(var(--nv-title-size) + .1em)}[dir=rtl] .Notivue__close{margin:var(--nv-spacing) 0 var(--nv-spacing) var(--nv-spacing)}.Notivue__duplicate{animation:Notivue__duplicate-kf .3s cubic-bezier(.16,1,.3,1) forwards}@keyframes Notivue__duplicate-kf{0%{transform:scale(1);opacity:1}50%{transform:scale(1.035);opacity:.8}to{transform:scale(1);opacity:1}}[data-notivue-align=top] .Notivue__enter,[data-notivue-align=top] .Notivue__leave{--notivue-ty:-200%}[data-notivue-align=bottom] .Notivue__enter,[data-notivue-align=bottom] .Notivue__leave{--notivue-ty:200%}.Notivue__enter{animation:Notivue__enter-kf .35s cubic-bezier(.5,1,.25,1)}.Notivue__leave{animation:Notivue__leave-kf .35s ease}.Notivue__clearAll{animation:Notivue__clearAll-kf .5s cubic-bezier(.22,1,.36,1)}@keyframes Notivue__enter-kf{0%{transform:translate3d(0,var(--notivue-ty),0) scale(.25);opacity:0}to{transform:translateZ(0) scale(1);opacity:1}}@keyframes Notivue__leave-kf{0%{transform:translateZ(0) scale(1);opacity:.7}to{transform:translate3d(0,var(--notivue-ty),0) scale(0);opacity:0}}@keyframes Notivue__clearAll-kf{0%{opacity:1}to{opacity:0}}"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[523],{523:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao Erweiterungen","ui.app.loading":"Lade Erweiterungsliste …","ui.app.language":"Sprache für den Contao Manager wechseln","ui.app.colorDark":"Dunkles Design","ui.app.colorDarkTitle":"Farbschema auf dunkel umstellen","ui.app.colorLight":"Helles Design","ui.app.colorLightTitle":"Farbschema auf hell umstellen","ui.discover.advertisement":"Anzeigen in der Erweiterungsliste","ui.discover.loading":"Laden …","ui.discover.offline":"Konnte keine Ergebnisse laden.","ui.discover.offlineExplain":"Prüfe deine Internet-Verbindung und deaktiviere alle JavaScript-Blocker.","ui.discover.offlineButton":"Erneut versuchen","ui.discover.searchPlaceholder":"{count} Erweiterungen durchsuchen …","ui.discover.empty":"Keine Ergebnisse für {query}","ui.discover.more":"Mehr Resultate","ui.discover.sortBy":"Sortieren nach","ui.discover.sortReleased":"Veröffentlicht","ui.discover.sortReleasedTitle":"Ergebnisse nach der Veröffentlichung sortieren","ui.discover.sortLatest":"Aktualisiert","ui.discover.sortLatestTitle":"Ergebnisse nach der letzten Aktualisierung sortieren","ui.discover.sortDownloads":"Downloads","ui.discover.sortDownloadsTitle":"Ergebnisse nach Anzahl Downloads sortieren","ui.discover.sortFavers":"Bewertung","ui.discover.sortFaversTitle":"Ergebnisse nach Bewertung sortieren","ui.discover.detailsButton":"Details","ui.discover.latestPackages":"Neuste und aktualisierte Erweiterungen","ui.discover.faversPackages":"Bestbewertete Erweiterungen","ui.discover.downloadsPackages":"Meistgeladene Erweiterungen","ui.discover.exactHit":"Exakte Übereinstimmung der Suchanfrage","ui.discover.results":"Weitere Suchergebnisse","ui.package.homepage":"Projektwebseite","ui.package.private":"Privates Paket","ui.package.privateTitle":"Private Pakete sind nur vom jeweiligen Hersteller verfügbar (z.B. als ZIP-Download). Besuche die Webseite für weitere Informationen.","ui.package.abandoned":"verwaist","ui.package.abandonedText":"Diese Erweiterung ist verwaist und wird nicht mehr gepflegt.","ui.package.abandonedReplace":"Diese Erweiterung ist verwaist und wird nicht mehr gepflegt. Der Autor empfiehlt stattdessen das Paket {replacement} zu verwenden.","ui.package.contaoVersion":"Verfügbar für Contao","ui.package-details.previous":"Details der vorherigen Erweiterung","ui.package-details.close":"Details der Erweiterung schließen","ui.package-details.loading":"Laden …","ui.package-details.tabDescription":"Beschreibung","ui.package-details.tabRequire":"Abhängigkeiten","ui.package-details.tabFeatures":"Funktionen","ui.package-details.tabSuggest":"Empfehlungen","ui.package-details.tabConflict":"Konflikte","ui.package-details.tabDependents":"Abhängige","ui.package-details.linkRequires":"benötigt","ui.package-details.linkReplaces":"ersetzt","ui.package-details.linkProvides":"liefert","ui.package-details.linkConflicts":"inkompatibel mit","ui.package-details.funding":"Weiterentwicklung finanzieren!","ui.package-details.contaoVersions":"Unterstützte Contao-Version(en)","ui.package-details.latest":"Neuste Version","ui.package-details.released":"veröffentlicht am","ui.package-details.license":"Lizenz(en)","ui.package-details.authors":"von","ui.package-details.more":"Mehr","ui.package-details.packagist":"Paketdetails","ui.package-details.metadata":"Metadaten bearbeiten","ui.package-details.support_docs":"Dokumentation","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Support-Forum","ui.package-details.support_issues":"Fehler melden","ui.package-details.support_source":"Quellcode","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Support E-Mail","ui.package-details.support_rss":"RSS-Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[28],{4028:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! 不安全连接 !!","ui.app.httpsDescription":"没有HTTPS情况下，机密数据将会未加密传输。","ui.app.httpsLink":"更多信息","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Safe Mode enabled !!","ui.app.safeModeDescription":"Some features of the Contao Manager are not available.","ui.app.safeModeExit":"Exit Safe Mode","ui.app.loading":"加载 Contao 管理器 …","ui.app.apiError":"意外的API状态","ui.app.configSecurity1":"安全警报 !!! 检测到未受保护的配置目录","ui.app.configSecurity2":"Contao管理器检测到其配置文件可以公开访问。目录受到保护之前会禁止所有操作，否则攻击者可以访问安装的敏感数据。\\n\\n为了修复这个问题，请确保阻止访问服务器上的\\"contao-manager\\"目录。要了解如何执行此操作，请参阅您的网络服务器手册或联系您的托管服务提供商。","ui.account.welcome":"欢迎","ui.account.intro1":"Welcome to the Contao Manager, a universal tool to install and manage Contao Open Source CMS. If you are new to it, please {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} to get started","ui.account.introManual":"read the manual","ui.account.intro2":"If you encounter any problems, check {ourGithubIssues} and feel free to create new one for anything that has not been reported yet.","ui.account.introIssues":"our GitHub issues","ui.account.headline":"用户账户","ui.account.description":"为了管理安装，请为Contao管理器创建一个账号。请注意该账号和Contao后台和前端没有关联。","ui.account.username":"用户名","ui.account.password":"密码","ui.account.passwordPlaceholder":"最少8个字符","ui.account.passwordLength":"请输入最少8个字符","ui.account.submit":"创建账号","ui.account.contribute1":"Contao and the Contao Manager are sponsored by the non-profit Contao Association.","ui.account.contribute2":"Please consider contributing to open source by {donate}.","ui.account.contributeDonate":"making a donation","ui.login.headline":"登录","ui.login.description":"登录来管理安装。","ui.login.username":"用户名","ui.login.password":"密码","ui.login.forgotPassword":"忘记密码","ui.login.button":"登录","ui.login.locked":"Access has been denied because the Contao Manager is locked. To unlock, delete the {lockFile} file in your Contao root directory.","ui.logout.headline":"会话超时","ui.logout.warning":"超过25分钟没有活动。安全原因您的会话将很快被终止。","ui.logout.expired":"由于超过30分钟没有活动，您的会话已自动终止。","ui.logout.renew":"保持登入","ui.logout.logout":"注销","ui.logout.login":"返回登录","ui.oauth.error":"无效的OAuth尝试。检查请求参数。","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Remote Authentication","ui.oauth.description":"以下应用程序或者服务正在请求对您的Contao Manager实例远程访问。","ui.oauth.domain":"Before allowing access, make sure you know this URL and trust its owner!","ui.oauth.allow":"允许访问","ui.oauth.deny":"拒绝访问","ui.boot.headline":"系统检查","ui.boot.description":"请稍等，正在分析您的服务器 …","ui.boot.issue1":"监测到安装问题","ui.boot.issue2":"Your installation has issues that have to be fixed before the Contao Manager can be used.","ui.boot.run":"运行Contao管理器","ui.boot.safeMode":"安全模式下运行","ui.recovery.headline":"系统恢复","ui.recovery.description":"The Contao Manager detected files that look like Contao, but the Command Line Interface does not work as expected.","ui.recovery.console":"Console Output","ui.recovery.repairOptions":"Please choose an option to repair your installation.","ui.recovery.repairHeadline":"自动修复","ui.recovery.repairDescription":"尝试通过重建应用缓存并重新安装Composer包来自动修复安装。","ui.recovery.repairWarning":"此过程可能会删除vendor中文件的任何修改!","ui.recovery.repairFailed":"自动修复没有成功。请尝试安全模式手动修复安装。","ui.recovery.repairButton":"运行系统修复","ui.recovery.safeModeHeadline":"安全模式","ui.recovery.safeModeDescription":"安全模式下运行Contao管理器允许管理包并运行某些维护任务，但依赖于正在运行的Contao安装的功能将不可用。","ui.recovery.safeModeButton":"安全模式下运行","ui.server.pending":"等待 …","ui.server.running":"分析中 …","ui.server.error":"由于服务器的意外响应，检查失败。","ui.server.details":"详情","ui.server.prerequisite":"由于缺少必要的条件，检查已取消。","ui.server.selfUpdate.title":"Contao管理器更新","ui.server.selfUpdate.update":"新的Contao管理器版本 {latest} .","ui.server.selfUpdate.manualUpdate":"新版本的Contao管理器 {latest} 可用。服务器不支持自动更新，请从{download}下载新版本。","ui.server.selfUpdate.latest":"正在使用最新版本 {current}。","ui.server.selfUpdate.dev":"开发版不支持自动更新。","ui.server.selfUpdate.unsupported":"有新版本，但您的PHP版本不支持。","ui.server.selfUpdate.button":"运行自更新","ui.server.selfUpdate.continue":"继续","ui.server.config.title":"服务器配置","ui.server.config.setup":"配置","ui.server.config.change":"更改","ui.server.config.save":"保存","ui.server.config.cancel":"取消","ui.server.config.customOption":"其他 …","ui.server.config.description":"To correctly run background tasks, the Contao Manager needs to know where to find the PHP command line binary and how to run commands separated from the web process.","ui.server.config.formTitle":"服务器配置","ui.server.config.formText":"请输入PHP二进制文件位置。确认二进制文件和服务器web进程是相同的PHP版本。","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud 允许安装Composer依赖即使服务器无法提供足够的内存。您的包信息将被传输到由Contao Association运营的云服务器。","ui.server.config.cloud":"使用Composer Resolver Cloud","ui.server.config.cli":"PHP二进制","ui.server.config.stateErrorCli":"服务器中没有发现有效的PHP二进制文件。","ui.server.config.stateErrorCloud":"不支持Composer Resolver Cloud。","ui.server.config.stateSuccess":"PHP 二进制文件在 {php_cli}.","ui.server.php_web.title":"PHP Web 进程","ui.server.php_web.below7":"发现 PHP 版本 {version}。请尽快切换到PHP 7!","ui.server.php_web.success":"发现PHP版本 {version}, 没有发现已知问题。","ui.server.php_cli.title":"PHP命令行接口","ui.server.php_cli.success":"发现PHP版本 {version}, 没有发现已知问题。","ui.server.composer.title":"Composer环境","ui.server.composer.success":"没有发现已知问题","ui.server.composer.install":"没有安装Composer依赖。","ui.server.composer.button":"Install","ui.server.contao.title":"Contao 安装","ui.server.contao.setup":"安装","ui.server.contao.check":"Check database","ui.server.contao.empty":"没有发现安装Contao。","ui.server.contao.old":"Contao版本 {version}不兼容Contao Manager，请手动更新当前安装的系统。","ui.server.contao.found":"发现Contao {version} (API 版本 {api}).","ui.server.contao.connectionError":"Unable to connect to the database server.","ui.server.contao.connectionProblem":"Database problem found.","ui.server.contao.missingUser":"Admin account not found.","ui.setup.continue":"继续","ui.setup.manager":"运行Contao管理器","ui.setup.cancel":"取消","ui.setup.welcome":"欢迎","ui.setup.welcome1":"This wizard will take you through the necessary steps to set up your Contao Open Source CMS installation.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"community support","ui.setup.start":"Get started","ui.setup.complete":"Congratulations!","ui.setup.complete1":"Contao {version} has been installed successfully.","ui.setup.complete2":"To finish the setup process, please open the install tool to configure the database connection and create a back end user.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Open the Install Tool","ui.setup.login":"Login to Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Learn more","ui.setup.document-root.headline":"Webserver Setup","ui.setup.document-root.warning":"To install Contao through the Contao Manager, you have to fix the document root on the web server.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"If you don\'t know how to configure your document root, please read the Contao documentation or contact your hosting provider.","ui.setup.document-root.documentation":"Read the Documentation","ui.setup.document-root.conflictsTitle":"Installation directory not empty","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.setup.document-root.check":"Check again","ui.setup.document-root.create":"Create directories","ui.setup.document-root.change":"Change directories","ui.setup.document-root.formTitle":"Directory Setup","ui.setup.document-root.formText1":"The Contao Manager can automatically create a new directory structure on the server.","ui.setup.document-root.formText2":"You will need to manually configure the new document root (e.g. through a hosting admin panel).","ui.setup.document-root.autoconfig":"I understand that I have to change my server configuration. Not configuring the document root will break the Contao Manager and expose configuration files (including account details and passwords)!","ui.setup.document-root.directory":"New Directory","ui.setup.document-root.currentRoot":"Current Document Root","ui.setup.document-root.newRoot":"New Document Root","ui.setup.document-root.finish":"Setup Directories","ui.setup.document-root.publicDir":"Use {dir} for public files (for Contao {version})","ui.setup.document-root.directoryInvalid":"Please enter a valid directory name.","ui.setup.document-root.directoryExists":"The target directory already exists. Please enter a different name.","ui.setup.document-root.confirmation":"The Contao Manager has successfully created the necessary directory for your Contao installation. You now have to configure the document root on your web server. Do not reload this page until then.","ui.setup.document-root.reload":"Reload Page","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Application files will be installed to {dir}.","ui.setup.document-root.installingPublicDir":"Public files will be installed to {dir}.","ui.setup.document-root.installedProjectDir":"Application files are installed in {dir}.","ui.setup.document-root.installedPublicDir":"Public files are installed in {dir}.","ui.setup.create-project.headline":"Contao 安装","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"最新","ui.setup.create-project.ltsTitle":"长期支持","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.requiresDocroot":"The document root must be \\"{folder}\\".","ui.setup.create-project.releaseplan":"See the {contaoReleasePlan} for detailed information.","ui.setup.create-project.releaseplanLink":"Contao Release Plan","ui.setup.create-project.formTitle":"Select a distribution","ui.setup.create-project.formText":"Please choose which version should be installed.","ui.setup.create-project.version":"版本","ui.setup.create-project.coreOnly":"初始化安装","ui.setup.create-project.coreOnlyNo":"全部安装 (新闻, 日历, 等.)","ui.setup.create-project.coreOnlyYes":"最小化安装 (仅核心)","ui.setup.create-project.coreOnlyFeatures":"What\'s the difference?","ui.setup.create-project.noUpdate":"跳过安装 (仅限专家!)","ui.setup.create-project.install":"Install","ui.setup.database-connection.headline":"Database Connection","ui.setup.database-connection.description":"Contao requires a MySQL database (or a compatible fork like MariaDB) to store pages, content, users and other relational data. Connection parameters are stored in the {env} file in the project root of your Contao installation.","ui.setup.database-connection.formTitle":"Connection Parameters","ui.setup.database-connection.formText":"Enter a database URL or fill in the username, password, server and database fields separately.","ui.setup.database-connection.url":"Database URL","ui.setup.database-connection.validUrl":"Database URL is invalid or connection to server failed.","ui.setup.database-connection.or":"or","ui.setup.database-connection.user":"用户名","ui.setup.database-connection.password":"密码","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Database Name","ui.setup.database-connection.serverVersion":"Server Version","ui.setup.database-connection.oldVersion":"Older MySQL or MariaDB","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server} {version}.","ui.setup.database-connection.error":"Error connecting to the database.","ui.setup.database-connection.problem":"Contao has detected a problem with your database server.","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Your database schema is up to date.","ui.setup.database-connection.check":"Check database","ui.setup.database-connection.save":"保存","ui.setup.database-connection.change":"Change credentials","ui.setup.backend-user.success":"An admin account for the Contao back end was found in your database. Use the Contao back end to add more users.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Backend Account","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"创建账号","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"用户名","ui.setup.backend-user.name":"Name","ui.setup.backend-user.email":"E-mail address","ui.setup.backend-user.emailInvalid":"Please enter a valid e-mail address","ui.setup.backend-user.password":"密码","ui.setup.backend-user.passwordPlaceholder":"最少8个字符","ui.setup.backend-user.passwordLength":"请输入最少8个字符","ui.setup.backend-user.create":"Add account","ui.task.headline":"Background Task","ui.task.loading":"Loading details …","ui.task.created":"Loading details …","ui.task.active":"Please wait while the Contao Manager is running task operations in the background.","ui.task.complete":"All operations are completed successfully. Check the console output for details.","ui.task.aborting":"Please wait while the background operations are being cancelled.","ui.task.stopped":"Some background operations were cancelled. Please check the console output.","ui.task.error":"A background operation stopped unexpectedly. Please check the console output.","ui.task.failed":"The Contao Manager failed to start a background task!","ui.task.failedDescription1":"Something went wrong while trying to execute operations in the background.","ui.task.failedDescription2":"If this happens again, your server might not be supported.","ui.task.reportProblem":"报告问题","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"更新数据库","ui.task.buttonClose":"关闭","ui.task.buttonConfirm":"确认 & 关闭","ui.task.buttonCancel":"取消","ui.task.confirmCancel":"确认取消此任务? 将会使Contao安装处于损坏状态!","ui.task.autoclose":"Close task details on success","ui.console.toggle":"显示/隐藏命令行输出","ui.console.showLog":"Show full console log","ui.console.copyLog":"Copy log to clipboard","ui.migrate.headline":"Database Updates","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Please wait, we are checking your database …","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Execute","ui.migrate.close":"关闭","ui.migrate.confirm":"确认 & 关闭","ui.migrate.cancel":"取消","ui.migrate.continue":"继续","ui.migrate.setup":"安装","ui.migrate.skip":"Skip","ui.migrate.retry":"Check again","ui.migrate.retryAll":"Check all","ui.migrate.withDeletes":"Execute all database changes including DROP queries.","ui.migrate.migrationTitle":"Database Migrations","ui.migrate.schemaTitle":"Schema Updates","ui.migrate.problemTitle":"Database Problems","ui.migrate.warningTitle":"Database Warnings","ui.migrate.addTable":"Add table {table}","ui.migrate.dropTable":"Drop table {table}","ui.migrate.addField":"Add field {table}.{field}","ui.migrate.changeField":"Change field {table}.{field}","ui.migrate.dropField":"Drop field {table}.{field}","ui.migrate.createIndex":"Create index \\"{name}\\" on {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" on {table}","ui.widget.mandatory":"该字段不能为空。","ui.widget.blankOption":"请选择 …","ui.widget.showPassword":"Show password","ui.widget.hidePassword":"Hide password","ui.error.title":"HTTP request for \\"{method} {url}\\" failed.","ui.error.server500":"Looks like an unexpected error happened on your server. Please check the log files of your web server (Apache/Nginx) and the Contao Manager logs at \\"contao-manager/logs\\".","ui.error.response":"The server returned a response with status code {status}.","ui.error.moreLink":"更多信息","ui.error.support":"Contao Support","ui.footer.help":"帮助","ui.footer.reportProblem":"报告问题","ui.navigation.discover":"发现","ui.navigation.packages":"包","ui.navigation.tools":"工具","ui.navigation.installTool":"安装工具","ui.navigation.backend":"Contao 后台","ui.navigation.debug":"Contao调试模式","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"PHP信息","ui.navigation.phpinfoLoading":"Loading PHP Information…","ui.navigation.maintenance":"维护","ui.navigation.rebuildCache":"重建缓存","ui.navigation.systemCheck":"系统检查","ui.navigation.advanced":"高级","ui.navigation.logout":"注销","ui.maintenance.databaseMigration.title":"Database Migrations","ui.maintenance.databaseMigration.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.databaseMigration.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.databaseMigration.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.databaseMigration.error":"Database problem found.","ui.maintenance.databaseMigration.warning":"Database warnings found.","ui.maintenance.databaseMigration.button":"Check database","ui.maintenance.databaseMigration.migrationOnly":"Check migrations only","ui.maintenance.databaseMigration.schemaOnly":"Check schema only","ui.maintenance.databaseMigration.installTool":"Open Install Tool","ui.maintenance.rebuildCache.title":"应用缓存","ui.maintenance.rebuildCache.description":"修改任何配置文件后，必须重建应用程序缓存。","ui.maintenance.rebuildCache.rebuildProd":"重建生产环境缓存","ui.maintenance.rebuildCache.rebuildDev":"重建开发环境缓存","ui.maintenance.rebuildCache.clearProd":"清除生产环境缓存","ui.maintenance.rebuildCache.clearDev":"清除开发环境缓存","ui.maintenance.installTool.title":"Contao安装工具","ui.maintenance.installTool.description":"连续输入3次错误密码会自动锁定Contao安装工具。","ui.maintenance.installTool.unlock":"解锁安装工具","ui.maintenance.installTool.lock":"锁定安装工具","ui.maintenance.dumpAutoload.title":"Composer类加载器","ui.maintenance.dumpAutoload.description":"Composer的自动加载器负责PHP类加载。添加自定义命名空间到根下的composer.json后必须转储自动加载器。","ui.maintenance.dumpAutoload.button":"打印Autoloader","ui.maintenance.composerInstall.title":"Composer依赖","ui.maintenance.composerInstall.description":"Composer dependencies are located in the {vendor} folder in your application root. Reinstalling the dependencies can be necessary after manipulation or manually uploading the {composerLock} file.","ui.maintenance.composerInstall.button":"运行安装器","ui.maintenance.composerInstall.update":"运行Composer更新","ui.maintenance.composerCache.title":"Composer缓存","ui.maintenance.composerCache.description":"Composer缓存下载的软件包以提高性能。 如果您遇到文件损坏等问题，请尝试删除Composer缓存以强制进行新的下载。","ui.maintenance.composerCache.button":"清楚缓存","ui.maintenance.maintenanceMode.title":"Maintenance Mode","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Enable","ui.maintenance.maintenanceMode.disable":"Disable","ui.maintenance.debugMode.title":"调试模式","ui.maintenance.debugMode.description":"Activate the debug mode by setting a user and password for the {appDevPhp} entry point.","ui.maintenance.debugMode.descriptionJwt":"通过对于当前域名设置调试cookie来激活调试模式。","ui.maintenance.debugMode.activate":"激活","ui.maintenance.debugMode.deactivate":"未激活","ui.maintenance.debugMode.credentials":"证书","ui.maintenance.debugMode.user":"请输入用于调试模式的用户名。","ui.maintenance.debugMode.password":"请输入用于调试模式的密码。","ui.maintenance.opcodeCache.title":"Opcode缓存","ui.maintenance.opcodeCache.description":"Opcode在Web进程上缓存PHP文件以加快执行速度。 如果文件在更改后无法识别，则在某些情况下必须将其删除。","ui.maintenance.opcodeCache.button":"清除缓存","ui.maintenance.safeMode":"安装模式下无效","ui.maintenance.unsupported":"您的Contao版本不支持","ui.packages.updateButton":"更新包","ui.packages.searchButton":"搜索包","ui.packages.searchPlaceholder":"搜索包","ui.packages.uploadOverlay":"拖拽文件上传","ui.packages.uploadButton":"上传包","ui.packages.uploadMessage":"You have one unconfirmed upload. | You have {count} unconfirmed uploads.","ui.packages.uploadApply":"确认上传","ui.packages.uploadReset":"删除上传","ui.packages.uploadIncomplete":"此文件未完全上传。 请将其删除，然后重试。","ui.packages.uploadDuplicate":"此文件似乎多次上传。 请删除重复项。","ui.packages.uploadInstalled":"此文件已安装。请移除重复项。","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"You have one unconfirmed change. | You have {count} unconfirmed changes.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"应用更改","ui.packages.changesApplyAll":"Update all packages","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"重置更改","ui.packages.changesReview":"预览更改","ui.packagelist.loading":"加载 …","ui.packagelist.uploads":"上传","ui.packagelist.added":"新包","ui.packagelist.installed":"已安装的包","ui.package.hintRevert":"恢复更改","ui.package.hintNoupdate":"不要更新","ui.package.hintConstraint":"应用更改时，此包将会带约束 {constraint} 安装。","ui.package.hintConstraintBest":"应用更改时，此包将会安装最佳版本。","ui.package.hintConstraintChange":"应用更改时，此包的约束将从\\"{from}\\"更改为\\"{to}\\"。","ui.package.hintConstraintUpdate":"应用更改后此包会被更新","ui.package.hintAdded":"应用更改后此包会被安装","ui.package.hintRemoved":"应用更改时，该程序包将被移除。","ui.package.requiredTitle":"手动添加","ui.package.requiredText":"composer.json中需要此包，但是没有安装","ui.package.removedTitle":"手动移除","ui.package.removedText":"此包已从composer.json移除。","ui.package.installed":"当前已安装:","ui.package.version":"版本 {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"编辑","ui.package.uploadConstraint":"此约束由上传的包定义。","ui.package.updateButton":"更新","ui.package.removeButton":"移除","ui.package.installButton":"添加包","ui.package.installButtonShort":"添加","ui.package.detailsButton":"详情","ui.package.latestConstraint":"最新版","ui.package.update":"Update available","ui.package.updateLatest":"最新版","ui.package.updateAvailable":"{version} available","ui.package.updateUnknown":"unknown version","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"版本 {version}","ui.cloudStatus.waitingTime":"等待时间","ui.cloudStatus.jobs":"当前工作","ui.cloudStatus.workers":"工作者","ui.cloudStatus.approx":"{minutes} 分钟","ui.cloudStatus.none":"无","ui.cloudStatus.short":"ca. {minutes} 分钟","ui.cloudStatus.long":"ca. {minutes} 分钟 {seconds} 秒","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Cloud Status","ui.cloudStatus.refresh":"Refresh Cloud Status","ui.log-viewer.loading":"加载 …","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Reload","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Channel","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Level","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Time","ui.log-viewer.messageHeader":"Message","ui.log-viewer.showContext":"Show Context","ui.log-viewer.hideContext":"Hide Context","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[60],{60:function(e,t,r){function n(e){const t=new Uint8Array(e);let r="";for(const o of t)r+=String.fromCharCode(o);const n=btoa(r);return n.replace(/\+/g,"-").replace(/\//g,"_").replace(/=/g,"")}function o(e){const t=e.replace(/-/g,"+").replace(/_/g,"/"),r=(4-t.length%4)%4,n=t.padEnd(t.length+r,"="),o=atob(n),i=new ArrayBuffer(o.length),a=new Uint8Array(i);for(let s=0;s<o.length;s++)a[s]=o.charCodeAt(s);return i}function i(){return a.stubThis(void 0!==globalThis?.PublicKeyCredential&&"function"===typeof globalThis.PublicKeyCredential)}r.d(t,{zZ:function(){return i},ZF:function(){return w},HS:function(){return m},Ct:function(){return R}});const a={stubThis:e=>e};function s(e){const{id:t}=e;return{...e,id:o(t),transports:e.transports}}function c(e){return"localhost"===e||/^([a-z0-9]+(-[a-z0-9]+)*\.)+[a-z]{2,}$/i.test(e)}class l extends Error{constructor({message:e,code:t,cause:r,name:n}){super(e,{cause:r}),Object.defineProperty(this,"code",{enumerable:!0,configurable:!0,writable:!0,value:void 0}),this.name=n??r.name,this.code=t}}function u({error:e,options:t}){const{publicKey:r}=t;if(!r)throw Error("options was missing required publicKey property");if("AbortError"===e.name){if(t.signal instanceof AbortSignal)return new l({message:"Registration ceremony was sent an abort signal",code:"ERROR_CEREMONY_ABORTED",cause:e})}else if("ConstraintError"===e.name){if(!0===r.authenticatorSelection?.requireResidentKey)return new l({message:"Discoverable credentials were required but no available authenticator supported it",code:"ERROR_AUTHENTICATOR_MISSING_DISCOVERABLE_CREDENTIAL_SUPPORT",cause:e});if("conditional"===t.mediation&&"required"===r.authenticatorSelection?.userVerification)return new l({message:"User verification was required during automatic registration but it could not be performed",code:"ERROR_AUTO_REGISTER_USER_VERIFICATION_FAILURE",cause:e});if("required"===r.authenticatorSelection?.userVerification)return new l({message:"User verification was required but no available authenticator supported it",code:"ERROR_AUTHENTICATOR_MISSING_USER_VERIFICATION_SUPPORT",cause:e})}else{if("InvalidStateError"===e.name)return new l({message:"The authenticator was previously registered",code:"ERROR_AUTHENTICATOR_PREVIOUSLY_REGISTERED",cause:e});if("NotAllowedError"===e.name)return new l({message:e.message,code:"ERROR_PASSTHROUGH_SEE_CAUSE_PROPERTY",cause:e});if("NotSupportedError"===e.name){const t=r.pubKeyCredParams.filter((e=>"public-key"===e.type));return 0===t.length?new l({message:'No entry in pubKeyCredParams was of type "public-key"',code:"ERROR_MALFORMED_PUBKEYCREDPARAMS",cause:e}):new l({message:"No available authenticator supported any of the specified pubKeyCredParams algorithms",code:"ERROR_AUTHENTICATOR_NO_SUPPORTED_PUBKEYCREDPARAMS_ALG",cause:e})}if("SecurityError"===e.name){const t=globalThis.location.hostname;if(!c(t))return new l({message:`${globalThis.location.hostname} is an invalid domain`,code:"ERROR_INVALID_DOMAIN",cause:e});if(r.rp.id!==t)return new l({message:`The RP ID "${r.rp.id}" is invalid for this domain`,code:"ERROR_INVALID_RP_ID",cause:e})}else if("TypeError"===e.name){if(r.user.id.byteLength<1||r.user.id.byteLength>64)return new l({message:"User ID was not between 1 and 64 characters",code:"ERROR_INVALID_USER_ID_LENGTH",cause:e})}else if("UnknownError"===e.name)return new l({message:"The authenticator was unable to process the specified options, or could not create a new credential",code:"ERROR_AUTHENTICATOR_GENERAL_ERROR",cause:e})}return e}class d{constructor(){Object.defineProperty(this,"controller",{enumerable:!0,configurable:!0,writable:!0,value:void 0})}createNewAbortSignal(){if(this.controller){const e=new Error("Cancelling existing WebAuthn API call for new one");e.name="AbortError",this.controller.abort(e)}const e=new AbortController;return this.controller=e,e.signal}cancelCeremony(){if(this.controller){const e=new Error("Manually cancelling existing WebAuthn API call");e.name="AbortError",this.controller.abort(e),this.controller=void 0}}}const h=new d,p=["cross-platform","platform"];function f(e){if(e&&!(p.indexOf(e)<0))return e}async function R(e){!e.optionsJSON&&e.challenge&&(console.warn("startRegistration() was not called correctly. It will try to continue with the provided options, but this call should be refactored to use the expected call structure instead. See https://simplewebauthn.dev/docs/packages/browser#typeerror-cannot-read-properties-of-undefined-reading-challenge for more information."),e={optionsJSON:e});const{optionsJSON:t,useAutoRegister:r=!1}=e;if(!i())throw new Error("WebAuthn is not supported in this browser");const a={...t,challenge:o(t.challenge),user:{...t.user,id:o(t.user.id)},excludeCredentials:t.excludeCredentials?.map(s)},c={};let l;r&&(c.mediation="conditional"),c.publicKey=a,c.signal=h.createNewAbortSignal();try{l=await navigator.credentials.create(c)}catch(y){throw u({error:y,options:c})}if(!l)throw new Error("Registration was not completed");const{id:d,rawId:p,response:R,type:w}=l;let b,E,m,A;if("function"===typeof R.getTransports&&(b=R.getTransports()),"function"===typeof R.getPublicKeyAlgorithm)try{E=R.getPublicKeyAlgorithm()}catch(_){g("getPublicKeyAlgorithm()",_)}if("function"===typeof R.getPublicKey)try{const e=R.getPublicKey();null!==e&&(m=n(e))}catch(_){g("getPublicKey()",_)}if("function"===typeof R.getAuthenticatorData)try{A=n(R.getAuthenticatorData())}catch(_){g("getAuthenticatorData()",_)}return{id:d,rawId:n(p),response:{attestationObject:n(R.attestationObject),clientDataJSON:n(R.clientDataJSON),transports:b,publicKeyAlgorithm:E,publicKey:m,authenticatorData:A},type:w,clientExtensionResults:l.getClientExtensionResults(),authenticatorAttachment:f(l.authenticatorAttachment)}}function g(e,t){console.warn(`The browser extension that intercepted this WebAuthn API call incorrectly implemented ${e}. You should report this error to them.\n`,t)}function w(){if(!i())return b.stubThis(new Promise((e=>e(!1))));const e=globalThis.PublicKeyCredential;return void 0===e?.isConditionalMediationAvailable?b.stubThis(new Promise((e=>e(!1)))):b.stubThis(e.isConditionalMediationAvailable())}const b={stubThis:e=>e};function E({error:e,options:t}){const{publicKey:r}=t;if(!r)throw Error("options was missing required publicKey property");if("AbortError"===e.name){if(t.signal instanceof AbortSignal)return new l({message:"Authentication ceremony was sent an abort signal",code:"ERROR_CEREMONY_ABORTED",cause:e})}else{if("NotAllowedError"===e.name)return new l({message:e.message,code:"ERROR_PASSTHROUGH_SEE_CAUSE_PROPERTY",cause:e});if("SecurityError"===e.name){const t=globalThis.location.hostname;if(!c(t))return new l({message:`${globalThis.location.hostname} is an invalid domain`,code:"ERROR_INVALID_DOMAIN",cause:e});if(r.rpId!==t)return new l({message:`The RP ID "${r.rpId}" is invalid for this domain`,code:"ERROR_INVALID_RP_ID",cause:e})}else if("UnknownError"===e.name)return new l({message:"The authenticator was unable to process the specified options, or could not create a new assertion signature",code:"ERROR_AUTHENTICATOR_GENERAL_ERROR",cause:e})}return e}async function m(e){!e.optionsJSON&&e.challenge&&(console.warn("startAuthentication() was not called correctly. It will try to continue with the provided options, but this call should be refactored to use the expected call structure instead. See https://simplewebauthn.dev/docs/packages/browser#typeerror-cannot-read-properties-of-undefined-reading-challenge for more information."),e={optionsJSON:e});const{optionsJSON:t,useBrowserAutofill:r=!1,verifyBrowserAutofillInput:a=!0}=e;if(!i())throw new Error("WebAuthn is not supported in this browser");let c;0!==t.allowCredentials?.length&&(c=t.allowCredentials?.map(s));const l={...t,challenge:o(t.challenge),allowCredentials:c},u={};if(r){if(!await w())throw Error("Browser does not support WebAuthn autofill");const e=document.querySelectorAll("input[autocomplete$='webauthn']");if(e.length<1&&a)throw Error('No <input> with "webauthn" as the only or last value in its `autocomplete` attribute was detected');u.mediation="conditional",l.allowCredentials=[]}let d;u.publicKey=l,u.signal=h.createNewAbortSignal();try{d=await navigator.credentials.get(u)}catch(A){throw E({error:A,options:u})}if(!d)throw new Error("Authentication was not completed");const{id:p,rawId:R,response:g,type:b}=d;let m;return g.userHandle&&(m=n(g.userHandle)),{id:p,rawId:n(R),response:{authenticatorData:n(g.authenticatorData),clientDataJSON:n(g.clientDataJSON),signature:n(g.signature),userHandle:m},type:b,clientExtensionResults:d.getClientExtensionResults(),authenticatorAttachment:f(d.authenticatorAttachment)}}}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[477],{6477:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Unsichere Verbindung !!","ui.app.httpsDescription":"Ohne HTTPS werden deine vertraulichen Daten unverschlüsselt übertragen.","ui.app.httpsLink":"Weitere Informationen","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Abgesicherter Modus !!","ui.app.safeModeDescription":"Einige Funktionen des Contao Managers sind nicht verfügbar.","ui.app.safeModeExit":"Beenden","ui.app.limitedHeadline":"Remote-Anmeldung","ui.app.limitedDescription":"Du hast eingeschränkte Berechtigungen wegen automatischer Anmeldung.","ui.app.limitedLogout":"Neu anmelden","ui.app.totpHeadline":"Sicherheitshinweis","ui.app.totpDescription":"Konfiguriere jetzt die Zwei-Faktor-Anmeldung, um dein Konto sicherer zu machen.","ui.app.totpSetup":"Einrichtung","ui.app.loading":"Contao Manager wird geladen …","ui.app.apiError":"Unerwarteter API-Status","ui.app.configSecurity1":"SICHERHEITSWARNUNG !!! Das Konfigurationsverzeichnis ist ungeschützt","ui.app.configSecurity2":"Der Contao Manager hat erkannt, dass seine Konfigurationsdateien öffentlich erreichbar sind. Du musst diese Dateien schützen, bevor der Manager verwendet werden kann, da ein Angreifer sonst auf sensible Daten zugreifen könnte.\\n\\nUm dieses Problem zu beheben, schütze das Verzeichnis \\"contao-manager\\" auf deinem Server. Bei Fragen lies das Handbuch deines Webservers oder wende dich an deinen Hosting-Anbieter.","ui.account.welcome":"Willkommen","ui.account.intro1":"Willkommen zum Contao Manager, einem universellen Werkzeug, um das Contao Open Source CMS zu installieren, zu konfigurieren und zu warten. Wenn du den Manager zum ersten Mal einsetzt, {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} bevor du beginnst","ui.account.introManual":"lies die Dokumentation","ui.account.intro2":"Sollten Probleme auftreten, dann prüfe {ourGithubIssues}. Falls für dein Anliegen noch kein Ticket existiert, kannst du gern ein Neues erstellen.","ui.account.introIssues":"die Tickets auf GitHub","ui.account.headline":"Benutzerkonto","ui.account.description":"Erstelle ein Benutzerkonto, um deine Installation zu verwalten. Beachte, dass dieses Konto in keinem Zusammenhang mit dem Contao Backend oder Frontend steht.","ui.account.username":"Benutzername","ui.account.password":"Passwort","ui.account.passwordPlaceholder":"min. 8 Zeichen","ui.account.passwordLength":"Bitte gib mindestens 8 Zeichen ein.","ui.account.loginInvalid":"Beim erstellen des Konto ist ein Fehler aufgetreten. Bitte versuche einen anderen Benutzernamen.","ui.account.submit":"Benutzerkonto erstellen","ui.account.usePassword":"Mit Passwort anmelden","ui.account.usePasskey":"Mit Passkey anmelden","ui.account.totpHeadline":"Zwei-Faktor Anmeldung","ui.account.totpDescription":"Bitte aktivieren die Zwei-Faktor-Anmeldung, welche dein Konto sicherer macht. Zusätzlich zu deinem Benutzernamen und Passwort musst du einen Sicherheitscode eingeben, welcher von einer Zwei-Faktor-App wie 1Password, Authy, Google Authenticator, Microsoft Authenticator, LassPass Authenticator oder einer beliebigen anderen TOTP-App erzeugt wird.","ui.account.totpSetup":"Jetzt einrichten","ui.account.totpSkip":"Später einrichten","ui.account.login":"Einladung ablehnen","ui.account.contribute1":"Contao und der Contao Manager werden durch die Contao Association gefördert.","ui.account.contribute2":"{donate} und leiste deinen Beitrag zu Open Source!","ui.account.contributeDonate":"Mach eine Spende","ui.login.headline":"Anmeldung","ui.login.description":"Melde dich an, um deine Installation zu verwalten.","ui.login.username":"Benutzername","ui.login.password":"Passwort","ui.login.totpHeadline":"Zwei-Faktor Anmeldung","ui.login.totpDescription":"Bitte gibt den Sicherheitscode ein, um die Anmeldung abzuschliessen.","ui.login.totp":"Sicherheitscode","ui.login.forgotPassword":"Passwort vergessen?","ui.login.button":"Anmelden","ui.login.passkey":"Mit Passkey anmelden","ui.login.cancel":"Abbrechen","ui.login.or":"oder","ui.login.locked":"Der Zugriff wurde verweigert, da der Contao Manager gesperrt ist. Zum Entsperren lösche die Datei {lockFile} in deinem Contao Hauptverzeichnis.","ui.logout.headline":"Session-Timeout","ui.logout.warning":"Du warst mehr als 25 Minuten inaktiv. Aus Sicherheitsgründen wird deine Sitzung in Kürze beendet.","ui.logout.expired":"Deine Sitzung wurde automatisch beendet, da du mehr als 30 Minuten inaktiv warst.","ui.logout.renew":"Angemeldet bleiben","ui.logout.logout":"Abmelden","ui.logout.login":"Zurück zum Login","ui.oauth.error":"Ungültiger OAuth-Versuch. Bitte überprüfe die Request-Parameter.","ui.oauth.https":"Die Rückleitungs-URL MUSS eine sichere Verbindung (https:) nutzen, um die Übertragung der Anmeldedaten im Klartext zu verhindern.","ui.oauth.headline":"Remote-Anmeldung","ui.oauth.description":"Die folgende Anwendung oder der folgende Dienst fordert den Fernzugriff auf deine Contao Manager-Instanz an.","ui.oauth.domain":"Bevor du diesen Zugriff erlaubst, stelle sicher, dass du die URL kennst und ihr vertraust!","ui.oauth.outOfScope":"Du hast leider nicht genügend Berechtigungen um diesen Zugriff zu gewähren.","ui.oauth.allow":"Zugriff erlauben","ui.oauth.deny":"Zugriff verweigern","ui.oauth.switchUser":"Benutzer wechseln","ui.scope.admin":"Admin-Zugriff inkl. Benutzerverwaltung","ui.scope.install":"Pakete installieren und Contao-Konfiguration ändern","ui.scope.update":"Pakete aktualisieren und Wartungsaufgaben ausführen","ui.scope.read":"Pakete und Konfiguration sehen","ui.boot.headline":"Systemprüfung","ui.boot.description":"Bitte warten, dein Server wird überprüft …","ui.boot.issue1":"Installationsprobleme erkannt","ui.boot.issue2":"Du musst die Installationsprobleme beheben, bevor der Contao Manager verwendet werden kann.","ui.boot.run":"Contao Manager starten","ui.boot.safeMode":"Abgesicherten Modus starten","ui.recovery.headline":"Systemwiederherstellung","ui.recovery.description":"Es wurden Dateien erkannt, die nach einer Contao-Installation aussehen, aber die Kommandozeile scheint nicht korrekt zu funktionieren.","ui.recovery.console":"Konsolenausgabe","ui.recovery.repairOptions":"Wähle eine Option, um das System zu reparieren.","ui.recovery.repairHeadline":"Automatische Reparatur","ui.recovery.repairDescription":"Versucht eine automatische Systemreparatur, indem der Cache neu aufgebaut und die Composer-Pakete neu installiert werden.","ui.recovery.repairWarning":"Manuelle Änderungen an den vendor-Dateien können dabei verloren gehen!","ui.recovery.repairFailed":"Die automatische Reparatur ist fehlgeschlagen. Versuche den abgesicherten Modus, um die Installation von Hand zu reparieren.","ui.recovery.repairButton":"Reparatur ausführen","ui.recovery.safeModeHeadline":"Abgesicherter Modus","ui.recovery.safeModeDescription":"Der abgesicherte Modus erlaubt die Paketverwaltung und gewisse Wartungsaufgaben, aber Funktionen, welche ein funktionierendes Contao benötigen, sind nicht verfügbar.","ui.recovery.safeModeButton":"Abgesicherten Modus starten","ui.server.pending":"Warten …","ui.server.running":"Analysiere …","ui.server.error":"Die Prüfung ist aufgrund einer unerwarteten Server-Antwort fehlgeschlagen.","ui.server.details":"Details","ui.server.prerequisite":"Prüfung aufgrund fehlender Abhängigkeiten abgebrochen.","ui.server.selfUpdate.title":"Updates für den Contao Manager","ui.server.selfUpdate.update":"Die neue Version {latest} des Contao Managers ist verfügbar.","ui.server.selfUpdate.manualUpdate":"Eine neue Version {latest} des Contao Manager ist verfügbar. Dein Server unterstützt keine automatischen Updates, bitte lade die neue Version von {download} herunter.","ui.server.selfUpdate.latest":"Du verwendest die aktuelle Version {current}.","ui.server.selfUpdate.dev":"Entwicklungs-Versionen können nicht automatisch aktualisiert werden.","ui.server.selfUpdate.unsupported":"Eine neue Version ist verfügbar, aber diese funktioniert nicht mit deiner PHP-Version.","ui.server.selfUpdate.button":"Aktualisieren","ui.server.selfUpdate.continue":"Weiter","ui.server.config.title":"Serverkonfiguration","ui.server.config.setup":"Konfigurieren","ui.server.config.change":"Ändern","ui.server.config.save":"Speichern","ui.server.config.cancel":"Abbrechen","ui.server.config.customOption":"Andere …","ui.server.config.description":"Der Contao Manager benötigt den Pfad zum PHP-Binary und weitere Server-Informationen, um Hintergrund-Prozesse korrekt auszuführen.","ui.server.config.formTitle":"Serverkonfiguration","ui.server.config.formText":"Bitte gib den Pfad zu deinem PHP-Binary ein. Das Binary muss dieselbe PHP-Version sein wie der Webprozess.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Die Composer Resolver Cloud erlaubt die Installation von Composer-Abhängigkeiten, selbst wenn der lokale Server nicht über genug Arbeitsspeicher verfügt. Beachte, dass deine Paketinformationen an einen Cloud-Dienst der Contao Association übermittelt werden.","ui.server.config.cloud":"Die Composer Resolver Cloud verwenden","ui.server.config.cli":"PHP-Binary","ui.server.config.stateErrorCli":"Es wurde kein valides PHP-Programm auf dem Server gefunden.","ui.server.config.stateErrorCloud":"Die Composer Resolver Cloud wird nicht unterstützt.","ui.server.config.stateSuccess":"PHP-Binary in {php_cli}.","ui.server.php_web.title":"PHP-Webprozess","ui.server.php_web.below7":"PHP Version {version} gefunden. Bitte wechsle baldmöglichst auf PHP 7!","ui.server.php_web.success":"PHP Version {version}, keine bekannten Probleme gefunden.","ui.server.php_cli.title":"PHP Kommandozeilen-Programm","ui.server.php_cli.success":"PHP Version {version}, keine bekannten Probleme gefunden.","ui.server.composer.title":"Composer-Umgebung","ui.server.composer.success":"Keine bekannten Probleme gefunden.","ui.server.composer.install":"Composer-Abhängigkeiten sind nicht installiert.","ui.server.composer.button":"Installieren","ui.server.contao.title":"Contao-Installation","ui.server.contao.setup":"Einrichtung","ui.server.contao.check":"Datenbank prüfen","ui.server.contao.empty":"Es wurde keine Contao-Installation gefunden.","ui.server.contao.old":"Contao {version} ist nicht kompatibel mit dem Contao Manager; bitte aktualisiere deine Installation manuell.","ui.server.contao.found":"Contao {version} (API-Version {api}) gefunden.","ui.server.contao.connectionError":"Verbindung zum Datenbank-Server fehlgeschlagen.","ui.server.contao.connectionProblem":"Datenbank-Problem gefunden.","ui.server.contao.missingUser":"Administratorkonto nicht gefunden.","ui.setup.continue":"Weiter","ui.setup.manager":"Contao Manager starten","ui.setup.cancel":"Abbrechen","ui.setup.welcome":"Willkommen","ui.setup.welcome1":"Dieser Assistent führt dich durch die Installation und Einrichtung deines Contao Open Source CMS.","ui.setup.welcome2":"Solltest du Fragen haben, findest du die Dokumentation, das Forum, den Slack Kanal und weiteres auf der {support}-Seite.","ui.setup.support":"Contao-Support","ui.setup.start":"Los geht\'s","ui.setup.complete":"Geschafft!","ui.setup.complete1":"Contao {version} wurde erfolgreich installiert.","ui.setup.complete2":"Um die Installation fertig zu stellen, öffne bitte das Install-Tool um die Datenbank zu verbinden und ein Backend-Konto hinzuzufügen.","ui.setup.complete3":"Du kannst nun deine Webseite im Contao Backend einrichten. Willst du Erweiterungen installieren, fahre mit dem Contao Manager fort.","ui.setup.installTool":"Install-Tool öffnen","ui.setup.login":"Contao Login","ui.setup.funding":"Ohne seine Community wäre Contao nicht das, was es heute ist. Wenn du professionell Webseiten mit Contao erstellst, sind wir auf deine Unterstützung angewiesen. Mit einer Investition in das Projekt sicherst du die Entwicklung für die Zukunft, damit dein Unternehmen weiterhin von Contao profitieren kann.","ui.setup.fundingLink":"Weitere Informationen","ui.setup.document-root.headline":"Webserver-Einrichtung","ui.setup.document-root.warning":"Um Contao über den Contao Manager zu installieren, muss das Wurzelverzeichnis des Webservers angepasst werden.","ui.setup.document-root.description1":"Contao verwendet einen Unterordner für öffentliche Dateien, die Systemdaten werden im übergeordneten Ordner installiert. Contao kann nicht installiert werden, wenn die Struktur nicht stimmt oder die Ordner nicht leer sind.","ui.setup.document-root.description2":"Falls du nicht weisst, wie dein Wurzelverzeichnis konfiguriert werden kann, lies die Contao Dokumentation oder kontaktiere deinen Hosting-Anbieter.","ui.setup.document-root.documentation":"Dokumentation lesen","ui.setup.document-root.conflictsTitle":"Installationsverzeichnis nicht leer","ui.setup.document-root.conflictsDirectory":"Das Wurzelverzeichnis deiner zukünftigen Contao-Installation ist nicht leer, es wurden {count} Datei(en) gefunden, die bei der Installation überschrieben werden könnten. Es wird empfohlen Contao in ein leeres Verzeichnis zu installieren, aber du kannst auch die Dateien löschen und erneut prüfen lassen, wenn du sicher bist, dass diese nicht benötigt werden.","ui.setup.document-root.ignoreConflicts":"Ich will Contao in ein nicht-leeres Verzeichnis installieren. Ich verstehe, dass dadurch bestehende Dateien auf meinem Server möglicherweise überschrieben werden.","ui.setup.document-root.check":"Erneut prüfen","ui.setup.document-root.create":"Verzeichnisse erstellen","ui.setup.document-root.change":"Verzeichnisse ändern","ui.setup.document-root.formTitle":"Verzeichnisstruktur einrichten","ui.setup.document-root.formText1":"Der Contao Manager kann automatisch eine neue Verzeichnisstruktur auf dem Server einrichten.","ui.setup.document-root.formText2":"Du musst das Wurzelverzeichnis danach manuell umkonfigurieren (z. B. über die Hosting-Administration).","ui.setup.document-root.autoconfig":"Ich habe verstanden, dass meine Server-Konfiguration geändert werden muss. Wenn ich dies nicht tue, funktioniert der Contao Manager nicht mehr und meine Konfigurationsdateien (inklusive Benutzer & Passwörter) werden öffentlich erreichbar!","ui.setup.document-root.directory":"Neuer Ordner","ui.setup.document-root.currentRoot":"Aktuelles Wurzelverzeichnis","ui.setup.document-root.newRoot":"Neues Wurzelverzeichnis","ui.setup.document-root.finish":"Ordner erstellen","ui.setup.document-root.publicDir":"{dir} für öffentliche Dateien nutzen (Contao {version})","ui.setup.document-root.directoryInvalid":"Bitte gib einen gültigen Ordnernamen ein.","ui.setup.document-root.directoryExists":"Das Zielverzeichnis ist bereits vorhanden. Bitte gibt einen anderen Namen ein.","ui.setup.document-root.confirmation":"Der Contao Manager hat die benötigten Verzeichnisse erfolgreich angelegt. Nun musst du dein Wurzelverzeichnis anpassen. Lade die Seite nicht neu, bis dies erledigt ist.","ui.setup.document-root.reload":"Neu laden","ui.setup.document-root.success":"Die Verzeichnisstruktur auf deinem Server ist korrekt eingerichtet!","ui.setup.document-root.installingProjectDir":"Systemdateien werden nach {dir} installiert.","ui.setup.document-root.installingPublicDir":"Öffentliche Dateien werden nach {dir} installiert.","ui.setup.document-root.installedProjectDir":"Systemdateien sind in {dir} installiert.","ui.setup.document-root.installedPublicDir":"Öffentliche Dateien sind in {dir} installiert.","ui.setup.create-project.headline":"Contao-Installation","ui.setup.create-project.description":"Die Contao-Entwicklung folgt dem Prinzip von {semver}, eine neue Minor-Version wird alle sechs Monate veröffentlicht. Die aktuell unterstützten Versionen sind:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Neuste","ui.setup.create-project.ltsTitle":"Langzeit-Support","ui.setup.create-project.latestQ1":"Unsere neuste Version mit den meisten Funktionen, wird bis Februar {year} unterstützt.","ui.setup.create-project.latestQ3":"Unsere neuste Version mit den meisten Funktionen, wird bis August {year} unterstützt.","ui.setup.create-project.ltsText":"Unsere aktuelle LTS-Version mit Fokus auf Stabilität. Bietet einen verlängerten Supportzeitraum bis Februar {year}.","ui.setup.create-project.pltsText":"Die vorherige LTS-Version, hat einen verlängerten Supportzeitraum bis Februar {year}","ui.setup.create-project.requiresPHP":"Benötigt mindestens PHP {version}, du hast PHP {current}.","ui.setup.create-project.releaseplan":"Weitere Details findest du im {contaoReleasePlan}.","ui.setup.create-project.releaseplanLink":"Contao Release-Plan","ui.setup.create-project.installed":"Contao {version} wurde erfolgreich auf dem Server installiert. Fahre weiter, um die Datenbank einzurichten, oder gehe zum Contao Manager um eine andere Version zu installieren.","ui.setup.create-project.formTitle":"Wähle eine Distribution","ui.setup.create-project.formText":"Bitte wähle die zu installierende Version.","ui.setup.create-project.version":"Version","ui.setup.create-project.demo":"Beispiel-Webseite installieren","ui.setup.create-project.demoDescription":"Die Beispiel-Webseite von Contao hilft dir dabei, dich mit dem System und seinen Hauptfunktionen vertraut zu machen. Weitere Themes findest du im {store}.","ui.setup.create-project.coreOnly":"Minimale Installation (nur Core)","ui.setup.create-project.noUpdate":"Installation überspringen (Expertenmodus!)","ui.setup.create-project.theme":"Theme für Contao","ui.setup.create-project.themeInstall":"Um ein Theme für Contao zu installieren, benutze die Sucheingabe oder lade eine Theme-Datei (.cto/.zip) hoch, die den Contao Manager unterstützt.","ui.setup.create-project.themeBuy":"Besuche auch den {store}.","ui.setup.create-project.themeStore":"Contao Themes-Store","ui.setup.create-project.themeUpload":"Theme-Datei (.cto/.zip) hochladen","ui.setup.create-project.themeInvalid":"Die hochgeladene Datei ist kein Theme für Contao oder unterstützt die Installation im Contao Manager nicht.","ui.setup.create-project.themeWarning":"Der Contao Manager kann nicht beurteilen, ob dieses Theme mit deinem Server kompatibel ist. Wende dich bei Fragen bitte direkt an den Theme-Hersteller.","ui.setup.create-project.themeTitle":"Theme-Details überprüfen","ui.setup.create-project.themeDetails":"Die nachfolgenden Abhängigkeiten und Dateien werden mit diesem Theme installiert.","ui.setup.create-project.themeRequire":"{count} Abhängigkeit | {count} Abhängigkeiten","ui.setup.create-project.themeFiles":"{count} Datei | {count} Dateien","ui.setup.create-project.theme.or":"oder suche öffentliche Themes","ui.setup.create-project.theme.search":"Themes durchsuchen","ui.setup.create-project.theme.more":"Weitere Themes","ui.setup.create-project.theme.empty":"Keine Theme für {query} gefunden","ui.setup.create-project.theme.uploaded":"Die Theme-Datei wurde erfolgreich hochgeladen.","ui.setup.create-project.theme.packageName":"Paketname","ui.setup.create-project.theme.version":"Version","ui.setup.create-project.theme.authors":"Autor(en)","ui.setup.create-project.theme.upload":"{name} ({size}) wird hochgeladen","ui.setup.create-project.install":"Installieren","ui.setup.create-project.cancel":"Abbrechen","ui.setup.database-connection.headline":"Datenbank-Verbindung","ui.setup.database-connection.description":"Contao benötigt eine MySQL Datenbank (oder ein kompatibler Fork wie MariaDB), um Seiten, Inhalte und andere Daten zu speichern. Die Verbindungsdaten werden in der Datei {env} im Systemverzeichnis von Contao gespeichert werden.","ui.setup.database-connection.formTitle":"Verbindungs-Parameter","ui.setup.database-connection.formText":"Gib eine Datenbank-URL ein, oder fülle die Felder für Benutzername, Passwort, Server und Datenbank separat aus.","ui.setup.database-connection.url":"Datenbank-URL","ui.setup.database-connection.validUrl":"Datenbank-URL ungültig oder Verbindung zum Server fehlgeschlagen.","ui.setup.database-connection.or":"oder","ui.setup.database-connection.user":"Benutzername","ui.setup.database-connection.password":"Passwort","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Datenbankname","ui.setup.database-connection.connected":"Erfolgreich verbunden mit Datenbank {database} auf {server}.","ui.setup.database-connection.error":"Fehler beim Verbinden mit der Datenbank.","ui.setup.database-connection.problem":"Contao hat ein Problem mit dem Datenbank-Server gefunden.","ui.setup.database-connection.schemaTitle":"Datenbank-Schema","ui.setup.database-connection.migration":"Es gibt eine ausstehende Migration. | Es gibt {count} ausstehende Migrationen.","ui.setup.database-connection.schema":"Es gibt eine ausstehende Schema-Änderung. | Es gibt {count} ausstehende Schema-Änderungen.","ui.setup.database-connection.noChanges":"Dein Datenbank-Schema ist aktuell.","ui.setup.database-connection.check":"Datenbank prüfen","ui.setup.database-connection.skip":"Überspringen","ui.setup.database-connection.save":"Speichern","ui.setup.database-connection.change":"Zugangsdaten ändern","ui.setup.database-connection.restoreTitle":"Datenbank-Import","ui.setup.database-connection.restoreText":"Das soeben installierte Theme enthält ein Datenbank-Backup. Du kannst diese Theme-Daten in die Datenbank importieren oder diesen Schritt überspringen und mit einem leeren Contao beginnen. | Das soeben installierte Theme enthält mehrere Datenbank-Backups. Wähle eine Backup-Datei für den Import oder überspringe diesen Schritt, um mit einem leeren Contao zu beginnen.","ui.setup.database-connection.backup":"Datenbank vor dem Import sichern","ui.setup.database-connection.backupWarning":"Alle Daten in der Datenbank werden beim Import überschrieben! Erstelle zuerst ein Backup, falls die Datenbank nicht leer ist.","ui.setup.database-connection.restore":"Theme importieren","ui.setup.database-connection.restoreOption":"Backup vom {date} ({size})","ui.setup.database-connection.restored":"Die Theme-Datenbank wurde erfolgreich importiert. Fahre fort, um das Datenbank-Schema zu überprüfen.","ui.setup.backend-user.success":"Es ist bereits ein Benutzerkonto in der Datenbank vorhanden. Weitere Konten können über das Backend hinzugefügt werden.","ui.setup.backend-user.error":"Die Benutzerliste konnte nicht gelesen werden. Weitere Details findest du in der Konsolen-Ausgabe.","ui.setup.backend-user.headline":"Backend-Konto","ui.setup.backend-user.description":"Um deine Webseite zu verwalten, benötigst du mindestens ein Administratorkonto für das Contao Backend. Beachte, dass dieses Konto nicht mit dem Contao Manager zusammenhängt.","ui.setup.backend-user.formTitle":"Benutzerkonto erstellen","ui.setup.backend-user.formText":"Bitte gib die Details für das neue Backend-Konto ein.","ui.setup.backend-user.username":"Benutzername","ui.setup.backend-user.name":"Name","ui.setup.backend-user.email":"E-Mail-Adresse","ui.setup.backend-user.emailInvalid":"Bitte gib eine gültige E-Mail-Adresse ein","ui.setup.backend-user.password":"Passwort","ui.setup.backend-user.passwordPlaceholder":"min. 8 Zeichen","ui.setup.backend-user.passwordLength":"Bitte gib mindestens 8 Zeichen ein.","ui.setup.backend-user.create":"Konto hinzufügen","ui.task.headline":"Hintergrund-Prozess","ui.task.loading":"Lade Details …","ui.task.created":"Lade Details …","ui.task.active":"Bitte warte, während der Contao Manager die nötigen Operationen im Hintergrund ausführt.","ui.task.complete":"Alle Operationen erfolgreich abgeschlossen. Weitere Details findest du in der Konsolen-Ausgabe.","ui.task.paused":"Ein Hintergrund-Prozess wurde unerwartet beendet. Bitte prüfe die Konsolen-Ausgabe.","ui.task.aborting":"Bitte warte, während der Hintergrund-Prozess abgebrochen wird.","ui.task.stopped":"Einige Operationen wurden abgebrochen. Bitte prüfe die Konsolen-Ausgabe.","ui.task.error":"Ein Hintergrund-Prozess wurde unerwartet beendet. Bitte prüfe die Konsolen-Ausgabe.","ui.task.failed":"Der Contao Manager konnte den Hintergrund-Prozess nicht starten.","ui.task.failedDescription1":"Die Ausführung der Aufgabe ist fehlgeschlagen.","ui.task.failedDescription2":"Sollte dies wiederholt geschehen, wird dein Server möglicherweise nicht unterstützt.","ui.task.reportProblem":"Probleme melden","ui.task.pausedDescription":"Klick auf \\"Weiter\\", um den Fehler zu ignorieren und die verbleibenden Aufgaben auszuführen.","ui.task.sponsor":"Composer Cloud gesponsert von {sponsor}","ui.task.buttonAudit":"Datenbank aktualisieren","ui.task.buttonClose":"Schließen","ui.task.buttonConfirm":"Bestätigen & Schließen","ui.task.buttonContinue":"Weiter","ui.task.buttonCancel":"Abbrechen","ui.task.confirmCancel":"Möchtest du diesen Prozess wirklich abbrechen? Deine Contao-Installation könnte in einem defekten Zustand zurückbleiben!","ui.task.autoclose":"Fenster bei Erfolg schließen","ui.console.toggle":"Konsolenausgabe anzeigen/verstecken","ui.console.showLog":"Vollständige Konsole anzeigen","ui.console.copyLog":"Konsole in Zwischenablage kopieren","ui.migrate.headline":"Datenbank-Änderungen","ui.migrate.migrationsOnly":"(nur Migrationen)","ui.migrate.schemaOnly":"(nur Schema)","ui.migrate.loading":"Bitte warten, die Datenbank wird überprüft …","ui.migrate.empty":"Keine ausstehenden Migrationen oder Schema-Änderungen gefunden. Deine Datenbank ist auf dem aktuellsten Stand.","ui.migrate.emptyMigrations":"Keine ausstehenden Migrationen gefunden. Bitte prüfe auch die Schema-Änderungen.","ui.migrate.emptySchema":"Keine ausstehenden Schema-Änderungen gefunden. Bitte prüfe auch die Migrationen.","ui.migrate.pending":"Die Datenbank ist nicht aktuell. Bitte prüfe die untenstehende Konsolenausgabe und führe die Änderungen aus.","ui.migrate.previousChanges":"Eine vorherige Datenbankmigration wurde nicht bestätigt.\\nBitte prüfen die untenstehende Konsolenausgabe und klicke weiter, um die nächsten Änderungen zu sehen.","ui.migrate.previousComplete":"Eine vorherige Datenbankmigration wurde nicht bestätigt, bitte prüfe die untenstehende Konsolenausgabe.\\nEs gibt keine weiteren ausstehenden Änderungen.","ui.migrate.appliedChanges":"Die Datenbankänderungen wurden übernommen.\\nBitte prüfe die untenstehende Konsolenausgabe, dann klicke weiter, um die nächsten Änderungen zu sehen.","ui.migrate.appliedComplete":"Die Datenbankänderungen wurden übernommen.\\nEs gibt keine weiteren Migrationen oder Schema-Änderungen. Deine Datenbank ist auf dem aktuellen Stand.","ui.migrate.problem":"Contao hat ein Problem mit dem Datenbank-Server gefunden.\\nBitte prüfe die Konsolen-Ausgabe unten, um zu sehen was angepasst werden muss. | Contao hat Probleme mit dem Datenbank-Server gefunden.\\nBitte prüfe die Konsolen-Ausgabe unten, um zu sehen was angepasst werden muss.","ui.migrate.warning":"Contao hat eine Fehlkonfiguration des Datenbank-Servers gefunden.\\nDie unten stehenden Warnungen sollten für optimalen Betrieb und Datensicherheit behoben werden.","ui.migrate.error":"Die Änderungen konnten nicht angewendet werden. Möglicherweise wurde die Datenbank geändert, bitte prüfe nochmals und versuche es erneut.","ui.migrate.execute":"Ausführen","ui.migrate.close":"Schließen","ui.migrate.confirm":"Bestätigen & Schließen","ui.migrate.cancel":"Abbrechen","ui.migrate.continue":"Weiter","ui.migrate.setup":"Einrichtung","ui.migrate.skip":"Überspringen","ui.migrate.retry":"Erneut prüfen","ui.migrate.retryAll":"Alles überprüfen","ui.migrate.withDeletes":"Alle Änderungen inklusive Löschungen anwenden.","ui.migrate.migrationTitle":"Datenbank-Migrationen","ui.migrate.schemaTitle":"Schema-Änderungen","ui.migrate.problemTitle":"Datenbank-Probleme","ui.migrate.warningTitle":"Datenbank-Warnungen","ui.migrate.addTable":"Tabelle {table} hinzufügen","ui.migrate.dropTable":"Tabelle {table} löschen","ui.migrate.addField":"Feld {table}.{field} hinzufügen","ui.migrate.changeField":"Feld {table}.{field} ändern","ui.migrate.dropField":"Feld {table}.{field} löschen","ui.migrate.createIndex":"Index \\"{name}\\" zu {table} hinzufügen","ui.migrate.dropIndex":"Index \\"{name}\\" aus {table} löschen","ui.widget.mandatory":"Dieses Feld darf nicht leer sein.","ui.widget.blankOption":"Bitte wählen …","ui.widget.showPassword":"Passwort anzeigen","ui.widget.hidePassword":"Passwort ausblenden","ui.error.title":"HTTP-Anfrage für \\"{method} {url}\\" fehlgeschlagen.","ui.error.server500":"Es scheint ein unbekannter Fehler aufgetreten zu sein. Prüfe die Log-Dateien deines Webservers (Apache/Nginx) und des Contao Managers im Ordner \\"contao-manager/logs\\".","ui.error.response":"Der Server hat eine Antwort mit Status-Code {status} gesendet.","ui.error.moreLink":"Weitere Informationen","ui.error.support":"Contao Support","ui.error.permission":"Du hast keine Berechtigung für diese Funktion.","ui.footer.help":"Hilfe","ui.footer.reportProblem":"Probleme melden","ui.navigation.discover":"Entdecken","ui.navigation.packages":"Pakete","ui.navigation.tools":"Tools","ui.navigation.installTool":"Installtool","ui.navigation.backend":"Contao-Backend","ui.navigation.debug":"Contao-Debug-Modus","ui.navigation.logViewer":"System-Log","ui.navigation.phpinfo":"PHP-Informationen","ui.navigation.phpinfoLoading":"Lade PHP-Informationen…","ui.navigation.maintenance":"Systemwartung","ui.navigation.rebuildCache":"Cache erneuern","ui.navigation.users":"Konten","ui.navigation.systemCheck":"Systemprüfung","ui.navigation.advanced":"Fortgeschritten","ui.navigation.logout":"Abmelden","ui.maintenance.database.title":"Datenbank-Migrationen und -Backups","ui.maintenance.database.description":"Datenbankmigrationen stellen konsistente Daten und Tabellenschemas sicher.","ui.maintenance.database.migrations":"Eine ausstehende Datenbank-Migration | {count} ausstehende Datenbank-Migrationen","ui.maintenance.database.schemaUpdates":"Eine ausstehende Schema-Änderung | {count} ausstehende Schema-Änderungen","ui.maintenance.database.error":"Datenbank-Problem gefunden.","ui.maintenance.database.warning":"Datenbank-Warnung gefunden.","ui.maintenance.database.button":"Datenbank prüfen","ui.maintenance.database.migrationOnly":"Nur Migrationen prüfen","ui.maintenance.database.schemaOnly":"Nur Schema prüfen","ui.maintenance.database.installTool":"Install-Tool öffnen","ui.maintenance.database.createBackup":"Backup erstellen","ui.maintenance.database.backupUnsupported":"Datenbank-Backups werden von deiner Contao-Version nicht unterstützt.","ui.maintenance.database.backupList":"Du hast ein Datenbank-Backup, erstellt am {date}. | Du hast {count} Datenbank-Backups, das neuste wurde am {date} erstellt.","ui.maintenance.database.backupEmpty":"Du hast noch keine Datenbank-Backups.","ui.maintenance.rebuildCache.title":"Anwendungs-Cache","ui.maintenance.rebuildCache.description":"Nach dem Ändern einer der Konfigurationsdateien muss der Anwendungs-Cache neu aufgebaut werden.","ui.maintenance.rebuildCache.rebuildProd":"Prod.-Cache erneuern","ui.maintenance.rebuildCache.rebuildDev":"Dev.-Cache erneuern","ui.maintenance.rebuildCache.clearProd":"Prod.-Cache leeren","ui.maintenance.rebuildCache.clearDev":"Dev.-Cache leeren","ui.maintenance.installTool.title":"Contao-Installtool","ui.maintenance.installTool.description":"Das Contao-Installtool wird automatisch gesperrt, wenn das Passwort drei Mal falsch eingegeben wird.","ui.maintenance.installTool.unlock":"Installtool entsperren","ui.maintenance.installTool.lock":"Installtool sperren","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"Der Composer-Autoloader ist für das Laden der PHP-Klassen verantwortlich. Der Autoloader muss nach dem Hinzufügen von eigenen Namespaces in die composer.json neu geschrieben werden.","ui.maintenance.dumpAutoload.button":"Datei aktualisieren","ui.maintenance.composerInstall.title":"Composer-Abhängigkeiten","ui.maintenance.composerInstall.description":"Composer-Abhängigkeiten befinden sich im Ordner {vendor} im Hauptverzeichnis deiner Anwendung. Eine Neuinstallation der Abhängigkeiten kann nach der Bearbeitung oder dem manuellen Hochladen der Datei {composerLock} notwendig sein.","ui.maintenance.composerInstall.button":"Installer ausführen","ui.maintenance.composerInstall.update":"Composer Update ausführen","ui.maintenance.composerCache.title":"Composer-Cache","ui.maintenance.composerCache.description":"Composer speichert heruntergeladene Pakete im Cache, um die Performance zu verbessern. Wenn Du z. B. Probleme mit korrupten Dateien hast, kannst du den Composer-Cache leeren, um einen neuen Download zu erzwingen.","ui.maintenance.composerCache.button":"Cache leeren","ui.maintenance.maintenanceMode.title":"Wartungsmodus","ui.maintenance.maintenanceMode.description":"Im Wartungsmodus zeigt Contao das \\"503 Dienst nicht verfügbar\\"-Template anstelle der Webseite an.","ui.maintenance.maintenanceMode.enable":"Aktivieren","ui.maintenance.maintenanceMode.disable":"Deaktivieren","ui.maintenance.debugMode.title":"Debug-Modus","ui.maintenance.debugMode.description":"Aktiviere den Debug-Modus, indem du einen Benutzer und ein Passwort für den Einstiegspunkt {appDevPhp} festlegen.","ui.maintenance.debugMode.descriptionJwt":"Aktiviert den Debug-Modus, indem für die aktuelle Domain ein entsprechendes Cookie gesetzt wird.","ui.maintenance.debugMode.activate":"Aktivieren","ui.maintenance.debugMode.deactivate":"Deaktivieren","ui.maintenance.debugMode.credentials":"Anmeldedaten","ui.maintenance.debugMode.user":"Bitte gib einen Benutzernamen für den Debug-Modus ein.","ui.maintenance.debugMode.password":"Bitte gib ein Passwort für den Debug-Modus ein.","ui.maintenance.opcodeCache.title":"Opcode-Cache","ui.maintenance.opcodeCache.description":"Der Opcode-Cache speichert PHP-Dateien im Webprozess für eine schnellere Ausführung. Er muss unter Umständen gelöscht werden, wenn Dateien nach dem Ändern nicht erkannt werden.","ui.maintenance.opcodeCache.button":"Cache leeren","ui.maintenance.safeMode":"Deaktiviert im abgesicherten Modus","ui.maintenance.unsupported":"Von deiner Contao-Version nicht unterstützt","ui.packages.updateButton":"Pakete aktualisieren","ui.packages.searchButton":"Pakete suchen","ui.packages.searchPlaceholder":"Pakete suchen …","ui.packages.uploadOverlay":"Lege Dateien hier ab, um sie hochzuladen","ui.packages.uploadButton":"Pakete hochladen","ui.packages.uploadMessage":"Du hast einen unbestätigten Upload. | Du hast {count} unbestätigte Uploads.","ui.packages.uploadApply":"Uploads bestätigen","ui.packages.uploadReset":"Uploads löschen","ui.packages.uploadIncomplete":"Diese Datei wurde nicht vollständig hochgeladen. Bitte entferne sie und versuchen es noch einmal.","ui.packages.uploadDuplicate":"Diese Datei scheint mehrfach hochgeladen worden zu sein. Bitte entferne die Duplikate.","ui.packages.uploadInstalled":"Diese Datei ist bereits installiert. Bitte entferne die Duplikate.","ui.packages.uploadUnsupported":"Uploads werden in deiner Installation nicht unterstützt. Stelle sicher, dass die PHP ZIP-Erweiterung installiert ist und aktualisiere die Abhängigkeiten.","ui.packages.changesMessage":"Du hast eine unbestätigte Änderung. | Du hast {count} unbestätigte Änderungen.","ui.packages.changesDryrun":"Testlauf","ui.packages.changesApply":"Änderungen anwenden","ui.packages.changesApplyAll":"Alle Pakete aktualisieren","ui.packages.changesDryrunAll":"Testlauf mit allen Paketen","ui.packages.changesReset":"Änderungen verwerfen","ui.packages.changesReview":"Änderungen prüfen","ui.packagelist.loading":"Laden …","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"Neue Pakete","ui.packagelist.installed":"Installierte Pakete","ui.package.hintRevert":"Änderung verwerfen","ui.package.hintNoupdate":"Nicht aktualisieren","ui.package.hintConstraint":"Dieses Paket wird mit der Versionsbedingung {constraint} installiert, wenn du die Änderungen anwendest.","ui.package.hintConstraintBest":"Dieses Paket wird in der besten verfügbaren Version installiert, wenn du die Änderungen anwendest.","ui.package.hintConstraintChange":"Die Versionsbedingung dieses Pakets wird von \\"{from}\\" in \\"{to}\\" geändert, wenn du die Änderungen anwendest.","ui.package.hintConstraintUpdate":"Dieses Paket wird aktualisiert, wenn du die Änderungen anwendest.","ui.package.hintAdded":"Dieses Paket wird installiert, wenn du die Änderungen anwendest.","ui.package.hintRemoved":"Dieses Paket wird entfernt, wenn du die Änderungen anwendest.","ui.package.requiredTitle":"manuell hinzugefügt","ui.package.requiredText":"Dieses Paket wurde in der composer.json hinzugefügt, ist aber nicht installiert.","ui.package.removedTitle":"manuell entfernt","ui.package.removedText":"Dieses Paket wurde aus der composer.json entfernt.","ui.package.installed":"Aktuell installiert:","ui.package.version":"Version {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Stern | {count} Sterne","ui.package.editConstraint":"Bearbeiten","ui.package.uploadConstraint":"Diese Versionsbedingung wird von dem hochgeladenen Paket definiert.","ui.package.updateButton":"Aktualisieren","ui.package.removeButton":"Entfernen","ui.package.installButton":"Paket hinzufügen","ui.package.installButtonShort":"Hinzufügen","ui.package.detailsButton":"Details","ui.package.latestConstraint":"neuste Version","ui.package.update":"Update verfügbar","ui.package.updateLatest":"neuste Version","ui.package.updateAvailable":"{version} verfügbar","ui.package.updateUnknown":"unbekannte Version","ui.package.updateConstraint":"Es ist eine neuere Version ausserhalb der Versionsbedingung verfügbar.","ui.package.incompatible":"{package} funktioniert nicht mit Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Version {version}","ui.cloudStatus.waitingTime":"Wartezeit","ui.cloudStatus.jobs":"Aktive Aufgaben","ui.cloudStatus.workers":"Server","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"keine","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} sek","ui.cloudStatus.error":"Status der Composer Resolver Cloud konnte nicht abgerufen werden. Möglicherweise gibt es ein Wartungsfenster oder Systemprobleme.","ui.cloudStatus.button":"Cloud-Status","ui.cloudStatus.refresh":"Cloud-Status aktualisieren","ui.log-viewer.loading":"Laden …","ui.log-viewer.empty":"Auf dem Server sind keine Logdateien vorhanden.","ui.log-viewer.reload":"Neu laden","ui.log-viewer.file":"Logdatei","ui.log-viewer.channel":"Kanal","ui.log-viewer.channelTitle":"Kanal in welcher die Nachricht geschrieben wurde.","ui.log-viewer.level":"Stufe","ui.log-viewer.levelTitle":"Wichtigkeit der Log-Nachricht.","ui.log-viewer.timeHeader":"Uhrzeit","ui.log-viewer.messageHeader":"Nachricht","ui.log-viewer.showContext":"Kontext anzeigen","ui.log-viewer.hideContext":"Kontext ausblenden","ui.log-viewer.showExtra":"Extras anzeigen","ui.log-viewer.hideExtra":"Extras ausblenden","ui.log-viewer.more":"Mehr laden …","ui.log-viewer.download":"Herunterladen","ui.log-viewer.downloadTitle":"Datei \\"{file}\\" herunterladen","ui.log-viewer.prodEnvironment":"Produktivumgebung","ui.log-viewer.devEnvironment":"Entwicklungsumgebung (Debug Modus)","ui.user-manager.loading":"Lade Benutzer:innen …","ui.user-manager.changePassword":"Passwort ändern","ui.user-manager.setupTotp":"Zwei-Faktor konfigurieren","ui.user-manager.disableTotp":"Zwei-Faktor deaktivieren","ui.user-manager.invite":"Benutzer:in einladen","ui.user-manager.delete":"Löschen","ui.user-manager.deleteConfirm":"Möchtest du das Konto von \\"{username}\\" wirklich löschen?","ui.user-manager.deleted":"Das Konto für {username} wurde gelöscht.","ui.user-manager.passwordHeadline":"Passwort ändern","ui.user-manager.passwordText":"Um dein Passwort zu ändern, gibt dein bestehendes und ein neues Passwort in den entsprechenden Feldern ein.","ui.user-manager.currentPassword":"Aktuelles Passwort","ui.user-manager.newPassword":"Neues Passwort","ui.user-manager.passwordPlaceholder":"min. 8 Zeichen","ui.user-manager.submitPassword":"Absenden","ui.user-manager.passwordChanged":"Dein Passwort wurde erfolgreich geändert.","ui.user-manager.passwordError":"Dieses Passwort stimmt nicht.","ui.user-manager.inviteHeadline":"Benutzer:in einladen","ui.user-manager.inviteText":"Falls du mehrere Logins zum Contao Manager benötigst, kannst du hier einen Einladungs-Link erstellen. Teile diesen Link mit jemandem oder benutze ihn auf einem anderen Gerät, um ein neues Konto mit den entsprechenden Berechtigungen zu erstellen.","ui.user-manager.inviteSuccess1":"Ein Einladungs-Link wurde erstellt. Mit der untenstehenden URL kann ein neues Konto für diesen Contao Manager erstellt werden. Die Einladung läuft ab am {expires} (eine Woche ab jetzt).","ui.user-manager.inviteSuccess2":"Kopiere den Link in deine Zwischenablage. Er funktioniert nur einmal, und du kannst ihn nach dem Schliessen dieses Fensterns nicht mehr sehen.","ui.user-manager.createInvitation":"Einladungs-Link erstellen","ui.user-manager.clipboard":"In Zwischenablage kopieren","ui.user-manager.permissions":"Mehr über Berechtigungen","ui.user-manager.cancel":"Abbrechen","ui.user-manager.close":"Schließen","ui.user-manager.you":"Du","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"Dieses Konto ist duch Zwei-Faktor-Anmeldung abgesichert.","ui.user-manager.2faDisabled":"Dieses Konto ist unsicher, da keine Zwei-Faktor-Anmeldung konfiguriert wurde.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"Dieses Konto ist durch einen Passkey abgesichert.","ui.totp.headline":"Zwei-Faktor Anmeldung","ui.totp.setupQr":"Scanne den QR-Code mit deiner 2FA/TOTP-Applikation.","ui.totp.setupCode":"Falls du den QR-Code nicht scannen kannst, gibt folgenden Schlüssel ein:","ui.totp.codeLabel":"Sicherheitscode","ui.totp.codeDescription":"Bitte gibt den Sicherheitscode ein, welcher von deiner 2FA/TOTP-Applikation generiert wurde.","ui.totp.disableText":"Gib den Sicherheitscode ein, um die Zwei-Faktor-Anmeldung zu deaktivieren.","ui.totp.invalid":"Der Sicherheitscode ist ungültig.","ui.totp.enable":"Aktivieren","ui.totp.disable":"Deaktivieren","ui.totp.cancel":"Abbrechen","ui.totp.enabled":"Die Zwei-Faktor-Anmeldung wurde erfolgreich aktiviert.","ui.totp.disabled":"Die Zwei-Faktor-Anmeldung wurde erfolgreich deaktiviert.","ui.totp.setup":"Zwei-Faktor-Anmeldung konfigurieren","ui.totp.skip":"Zwei-Faktor-Anmeldung überspringen"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[553],{5553:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Insecure Connection !!","ui.app.httpsDescription":"Without HTTPS your confidential data will be transferred unencrypted.","ui.app.httpsLink":"More Info","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Safe Mode enabled !!","ui.app.safeModeDescription":"Some features of the Contao Manager are not available.","ui.app.safeModeExit":"Exit Safe Mode","ui.app.limitedHeadline":"Remote Authentication","ui.app.limitedDescription":"You have limited permissions due to passwordless login.","ui.app.limitedLogout":"Re-authenticate","ui.app.totpHeadline":"Security Notice","ui.app.totpDescription":"Configure two-factor authentication now to secure your account.","ui.app.totpSetup":"Setup","ui.app.loading":"Loading Contao Manager …","ui.app.apiError":"Unexpected API status","ui.app.configSecurity1":"SECURITY ALERT !!! Unprotected config directory detected","ui.app.configSecurity2":"The Contao Manager has detected that its config files are publicly accessible. All operations are disabled until the directory is secured, otherwise an attacker could access sensitive data of your installation.\\n\\nTo fix this issue, make sure to prevent access to the \\"contao-manager\\" directory on your server. To learn how to do this, please refer to the manual of your webserver or contact your hosting provider.","ui.account.welcome":"Welcome","ui.account.intro1":"Welcome to the Contao Manager, a universal tool to install and manage Contao Open Source CMS. If you are new to it, please {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} to get started","ui.account.introManual":"read the manual","ui.account.intro2":"If you encounter any problems, check {ourGithubIssues} and feel free to create new one for anything that has not been reported yet.","ui.account.introIssues":"our GitHub issues","ui.account.headline":"User Account","ui.account.description":"To manage your installation, please create an account for the Contao Manager. Be aware that this account is not related to the Contao back end or front end.","ui.account.username":"Username","ui.account.password":"Password","ui.account.passwordPlaceholder":"min. 8 characters","ui.account.passwordLength":"Please enter at least 8 characters.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Create Account","ui.account.usePassword":"Use password for login","ui.account.usePasskey":"Use Passkey for login","ui.account.totpHeadline":"Two-factor authentication","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Configure now","ui.account.totpSkip":"Configure later","ui.account.login":"Decline Invitation","ui.account.contribute1":"Contao and the Contao Manager are sponsored by the non-profit Contao Association.","ui.account.contribute2":"Please consider contributing to open source by {donate}.","ui.account.contributeDonate":"making a donation","ui.login.headline":"Sign In","ui.login.description":"Login to manage your installation.","ui.login.username":"Username","ui.login.password":"Password","ui.login.totpHeadline":"Two-factor authentication","ui.login.totpDescription":"Please enter your verification code to complete the login process.","ui.login.totp":"Verification code","ui.login.forgotPassword":"Forgot your password?","ui.login.button":"Sign In","ui.login.passkey":"Sign In with Passkey","ui.login.cancel":"Cancel","ui.login.or":"or","ui.login.locked":"Access has been denied because the Contao Manager is locked. To unlock, delete the {lockFile} file in your Contao root directory.","ui.logout.headline":"Session Timeout","ui.logout.warning":"Your have been inactive for more than 25 minutes. For security reasons your session will be terminated shortly.","ui.logout.expired":"Your session was automatically terminated because you have been inactive for more than 30 minutes.","ui.logout.renew":"Keep Logged In","ui.logout.logout":"Logout","ui.logout.login":"Back To Login","ui.oauth.error":"Invalid OAuth attempt. Check the request parameters.","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Remote Authentication","ui.oauth.description":"The following application or service is requesting remote access to your Contao Manager instance.","ui.oauth.domain":"Before allowing access, make sure you know this URL and trust its owner!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Allow Access","ui.oauth.deny":"Deny Access","ui.oauth.switchUser":"Switch User","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"System Check","ui.boot.description":"Please wait, we are analyzing your server …","ui.boot.issue1":"Installation Issues Detected","ui.boot.issue2":"Your installation has issues that have to be fixed before the Contao Manager can be used.","ui.boot.run":"Launch Contao Manager","ui.boot.safeMode":"Launch in Safe Mode","ui.recovery.headline":"System Recovery","ui.recovery.description":"The Contao Manager detected files that look like Contao, but the Command Line Interface does not work as expected.","ui.recovery.console":"Console Output","ui.recovery.repairOptions":"Please choose an option to repair your installation.","ui.recovery.repairHeadline":"Automatic Repair","ui.recovery.repairDescription":"Attempts to automatically repair the installation by rebuilding the application cache and re-installing the Composer packages.","ui.recovery.repairWarning":"Any modifications to the vendor files might be deleted in the process!","ui.recovery.repairFailed":"Automatic repair was not successful. Try the Safe Mode to manually repair the installation.","ui.recovery.repairButton":"Run System Repair","ui.recovery.safeModeHeadline":"Safe Mode","ui.recovery.safeModeDescription":"Launching the Contao Manager in Safe Mode allows to manage packages and run certain maintenance tasks, but features that rely on a working Contao installation will not be available.","ui.recovery.safeModeButton":"Launch in Safe Mode","ui.server.pending":"Waiting …","ui.server.running":"Analyzing …","ui.server.error":"Check failed due to an unexpected response from the server.","ui.server.details":"Details","ui.server.prerequisite":"Check cancelled due to a missing prerequisite.","ui.server.selfUpdate.title":"Updates of Contao Manager","ui.server.selfUpdate.update":"A new Contao Manager version {latest} is available.","ui.server.selfUpdate.manualUpdate":"A new Contao Manager version {latest} is available. Your server does not support automatic updates, please download the new version from {download}.","ui.server.selfUpdate.latest":"You are using the latest version {current}.","ui.server.selfUpdate.dev":"Development builds do not support automatic updates.","ui.server.selfUpdate.unsupported":"A new version is available but it does not support your PHP version.","ui.server.selfUpdate.button":"Run Self-Update","ui.server.selfUpdate.continue":"Continue","ui.server.config.title":"Server Configuration","ui.server.config.setup":"Configure","ui.server.config.change":"Change","ui.server.config.save":"Save","ui.server.config.cancel":"Cancel","ui.server.config.customOption":"Other …","ui.server.config.description":"To correctly run background tasks, the Contao Manager needs to know where to find the PHP command line binary and how to run commands separated from the web process.","ui.server.config.formTitle":"Server Configuration","ui.server.config.formText":"Please enter the path to your PHP binary. Make sure the binary is the same PHP version as your web process.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"The Composer Resolver Cloud allows to install Composer dependencies even if your server does not provide enough local memory. Please be aware that your package information will be transmitted to a cloud server operated by the Contao Association.","ui.server.config.cloud":"Use the Composer Resolver Cloud","ui.server.config.cli":"PHP Binary","ui.server.config.stateErrorCli":"No valid PHP binary was found on the server.","ui.server.config.stateErrorCloud":"The Composer Resolver Cloud is not supported.","ui.server.config.stateSuccess":"PHP binary at {php_cli}.","ui.server.php_web.title":"PHP Web Process","ui.server.php_web.below7":"Found PHP version {version}. Please switch to PHP 7 as soon as possible!","ui.server.php_web.success":"Found PHP version {version}, no known issues found.","ui.server.php_cli.title":"PHP Command Line Interface","ui.server.php_cli.success":"Found PHP version {version}, no known issues found.","ui.server.composer.title":"Composer Environment","ui.server.composer.success":"No known issues found.","ui.server.composer.install":"Composer dependencies are not installed.","ui.server.composer.button":"Install","ui.server.contao.title":"Contao Installation","ui.server.contao.setup":"Setup","ui.server.contao.check":"Check database","ui.server.contao.empty":"No Contao installation has been found.","ui.server.contao.old":"Contao version {version} is not compatible with the Contao Manager, please update your installation manually.","ui.server.contao.found":"Found Contao {version} (API version {api}).","ui.server.contao.connectionError":"Unable to connect to the database server.","ui.server.contao.connectionProblem":"Database problem found.","ui.server.contao.missingUser":"Admin account not found.","ui.setup.continue":"Continue","ui.setup.manager":"Launch Contao Manager","ui.setup.cancel":"Cancel","ui.setup.welcome":"Welcome","ui.setup.welcome1":"This wizard will take you through the necessary steps to set up your Contao Open Source CMS installation.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"community support","ui.setup.start":"Get started","ui.setup.complete":"Congratulations!","ui.setup.complete1":"Contao {version} has been installed successfully.","ui.setup.complete2":"To finish the setup process, please open the install tool to configure the database connection and create a back end user.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Open the Install Tool","ui.setup.login":"Login to Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Learn more","ui.setup.document-root.headline":"Webserver Setup","ui.setup.document-root.warning":"To install Contao through the Contao Manager, you have to fix the document root on the web server.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"If you don\'t know how to configure your document root, please read the Contao documentation or contact your hosting provider.","ui.setup.document-root.documentation":"Read the Documentation","ui.setup.document-root.conflictsTitle":"Installation directory not empty","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.setup.document-root.check":"Check again","ui.setup.document-root.create":"Create directories","ui.setup.document-root.change":"Change directories","ui.setup.document-root.formTitle":"Directory Setup","ui.setup.document-root.formText1":"The Contao Manager can automatically create a new directory structure on the server.","ui.setup.document-root.formText2":"You will need to manually configure the new document root (e.g. through a hosting admin panel).","ui.setup.document-root.autoconfig":"I understand that I have to change my server configuration. Not configuring the document root will break the Contao Manager and expose configuration files (including account details and passwords)!","ui.setup.document-root.directory":"New Directory","ui.setup.document-root.currentRoot":"Current Document Root","ui.setup.document-root.newRoot":"New Document Root","ui.setup.document-root.finish":"Setup Directories","ui.setup.document-root.publicDir":"Use {dir} for public files (for Contao {version})","ui.setup.document-root.directoryInvalid":"Please enter a valid directory name.","ui.setup.document-root.directoryExists":"The target directory already exists. Please enter a different name.","ui.setup.document-root.confirmation":"The Contao Manager has successfully created the necessary directory for your Contao installation. You now have to configure the document root on your web server. Do not reload this page until then.","ui.setup.document-root.reload":"Reload Page","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Application files will be installed to {dir}.","ui.setup.document-root.installingPublicDir":"Public files will be installed to {dir}.","ui.setup.document-root.installedProjectDir":"Application files are installed in {dir}.","ui.setup.document-root.installedPublicDir":"Public files are installed in {dir}.","ui.setup.create-project.headline":"Contao Installation","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Latest","ui.setup.create-project.ltsTitle":"Long Term Support","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.releaseplan":"See the {contaoReleasePlan} for detailed information.","ui.setup.create-project.releaseplanLink":"Contao Release Plan","ui.setup.create-project.installed":"Contao {version} is successfully installed on the server. Continue to set up your database or launch the Contao Manager to install a different version.","ui.setup.create-project.formTitle":"Select a distribution","ui.setup.create-project.formText":"Please choose which version should be installed.","ui.setup.create-project.version":"Version","ui.setup.create-project.demo":"Install the Contao demo website","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.","ui.setup.create-project.coreOnly":"Minimal Installation (Core only)","ui.setup.create-project.noUpdate":"Skip Installation (Expert Only!)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"To install a Contao theme, use the search input or upload a theme file (.cto/.zip) that supports installation through the Contao Manager.","ui.setup.create-project.themeBuy":"Make sure to visit the official {store}.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Upload theme file (.cto/.zip)","ui.setup.create-project.themeInvalid":"The uploaded file is not a Contao theme or does not support the Contao Manager.","ui.setup.create-project.themeWarning":"The Contao Manager cannot tell whether this theme is compatible with your server. Please check with the theme vendor if you have any questions.","ui.setup.create-project.themeTitle":"Review theme details","ui.setup.create-project.themeDetails":"The following dependencies and files will be installed with this theme.","ui.setup.create-project.themeRequire":"{count} Dependencies | {count} Dependencies","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"or search public themes","ui.setup.create-project.theme.search":"Search themes","ui.setup.create-project.theme.more":"More themes","ui.setup.create-project.theme.empty":"No themes matching {query}","ui.setup.create-project.theme.uploaded":"The theme file was uploaded successfully.","ui.setup.create-project.theme.packageName":"Package name","ui.setup.create-project.theme.version":"Version","ui.setup.create-project.theme.authors":"Author(s)","ui.setup.create-project.theme.upload":"Uploading {name} ({size})","ui.setup.create-project.install":"Install","ui.setup.create-project.cancel":"Cancel","ui.setup.database-connection.headline":"Database Connection","ui.setup.database-connection.description":"Contao requires a MySQL database (or a compatible fork like MariaDB) to store pages, content, users and other relational data. Connection parameters are stored in the {env} file in the project root of your Contao installation.","ui.setup.database-connection.formTitle":"Connection Parameters","ui.setup.database-connection.formText":"Enter a database URL or fill in the username, password, server and database fields separately.","ui.setup.database-connection.url":"Database URL","ui.setup.database-connection.validUrl":"Database URL is invalid or connection to server failed.","ui.setup.database-connection.or":"or","ui.setup.database-connection.user":"Username","ui.setup.database-connection.password":"Password","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Database Name","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server}.","ui.setup.database-connection.error":"Error connecting to the database.","ui.setup.database-connection.problem":"Contao has detected a problem with your database server.","ui.setup.database-connection.schemaTitle":"Database Schema","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Your database schema is up to date.","ui.setup.database-connection.check":"Check database","ui.setup.database-connection.skip":"Skip","ui.setup.database-connection.save":"Save","ui.setup.database-connection.change":"Change credentials","ui.setup.database-connection.restoreTitle":"Database Import","ui.setup.database-connection.restoreText":"The theme you just installed contains a database backup. Restore the database to import theme data or skip this step to start with a blank Contao installation. | The theme you just installed contains multiple database backups. Select a backup file to import theme data or skip this step to start with a blank Contao installation.","ui.setup.database-connection.backup":"Backup current database before import","ui.setup.database-connection.backupWarning":"All data in database will be overwritten on import! Create a backup first if the database is not empty.","ui.setup.database-connection.restore":"Import theme database","ui.setup.database-connection.restoreOption":"Backup from {date} ({size})","ui.setup.database-connection.restored":"Your theme database was successfully imported. Continue to validate your database schema.","ui.setup.backend-user.success":"An admin account for the Contao back end was found in your database. Use the Contao back end to add more users.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Backend Account","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"Create Account","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"Username","ui.setup.backend-user.name":"Name","ui.setup.backend-user.email":"E-mail address","ui.setup.backend-user.emailInvalid":"Please enter a valid e-mail address","ui.setup.backend-user.password":"Password","ui.setup.backend-user.passwordPlaceholder":"min. 8 characters","ui.setup.backend-user.passwordLength":"Please enter at least 8 characters.","ui.setup.backend-user.create":"Add account","ui.task.headline":"Background Task","ui.task.loading":"Loading details …","ui.task.created":"Loading details …","ui.task.active":"Please wait while the Contao Manager is running task operations in the background.","ui.task.complete":"All operations are completed successfully. Check the console output for details.","ui.task.paused":"A background operation stopped unexpectedly. Please check the console output.","ui.task.aborting":"Please wait while the background operations are being cancelled.","ui.task.stopped":"Some background operations were cancelled. Please check the console output.","ui.task.error":"A background operation stopped unexpectedly. Please check the console output.","ui.task.failed":"The Contao Manager failed to start a background task!","ui.task.failedDescription1":"Something went wrong while trying to execute operations in the background.","ui.task.failedDescription2":"If this happens again, your server might not be supported.","ui.task.reportProblem":"Report a Problem","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"Update Database","ui.task.buttonClose":"Close","ui.task.buttonConfirm":"Confirm & Close","ui.task.buttonContinue":"Continue","ui.task.buttonCancel":"Cancel","ui.task.confirmCancel":"Are you sure to cancel this task? This might leave your Contao installation in a broken state!","ui.task.autoclose":"Close task details on success","ui.console.toggle":"Show/Hide Console Output","ui.console.showLog":"Show full console log","ui.console.copyLog":"Copy log to clipboard","ui.migrate.headline":"Database Updates","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Please wait, we are checking your database …","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Execute","ui.migrate.close":"Close","ui.migrate.confirm":"Confirm & Close","ui.migrate.cancel":"Cancel","ui.migrate.continue":"Continue","ui.migrate.setup":"Setup","ui.migrate.skip":"Skip","ui.migrate.retry":"Check again","ui.migrate.retryAll":"Check all","ui.migrate.withDeletes":"Execute all database changes including DROP queries.","ui.migrate.migrationTitle":"Database Migrations","ui.migrate.schemaTitle":"Schema Updates","ui.migrate.problemTitle":"Database Problems","ui.migrate.warningTitle":"Database Warnings","ui.migrate.addTable":"Add table {table}","ui.migrate.dropTable":"Drop table {table}","ui.migrate.addField":"Add field {table}.{field}","ui.migrate.changeField":"Change field {table}.{field}","ui.migrate.dropField":"Drop field {table}.{field}","ui.migrate.createIndex":"Create index \\"{name}\\" on {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" on {table}","ui.widget.mandatory":"This field must not be empty.","ui.widget.blankOption":"Please select …","ui.widget.showPassword":"Show password","ui.widget.hidePassword":"Hide password","ui.error.title":"HTTP request for \\"{method} {url}\\" failed.","ui.error.server500":"Looks like an unexpected error happened on your server. Please check the log files of your web server (Apache/Nginx) and the Contao Manager logs at \\"contao-manager/logs\\".","ui.error.response":"The server returned a response with status code {status}.","ui.error.moreLink":"More Information","ui.error.support":"Contao Support","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Help","ui.footer.reportProblem":"Report a Problem","ui.navigation.discover":"Discover","ui.navigation.packages":"Packages","ui.navigation.tools":"Tools","ui.navigation.installTool":"Install Tool","ui.navigation.backend":"Contao Backend","ui.navigation.debug":"Contao Debug Mode","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"PHP Information","ui.navigation.phpinfoLoading":"Loading PHP Information…","ui.navigation.maintenance":"Maintenance","ui.navigation.rebuildCache":"Rebuild Cache","ui.navigation.users":"Accounts","ui.navigation.systemCheck":"System Check","ui.navigation.advanced":"Advanced","ui.navigation.logout":"Logout","ui.maintenance.database.title":"Database Migrations and Backups","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.database.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.database.error":"Database problem found.","ui.maintenance.database.warning":"Database warnings found.","ui.maintenance.database.button":"Check database","ui.maintenance.database.migrationOnly":"Check migrations only","ui.maintenance.database.schemaOnly":"Check schema only","ui.maintenance.database.installTool":"Open Install Tool","ui.maintenance.database.createBackup":"Create Backup","ui.maintenance.database.backupUnsupported":"Database backups are not supported by your Contao version.","ui.maintenance.database.backupList":"You have one database backup, created on {date}. | You have {count} database backups, the latest one was created on {date}.","ui.maintenance.database.backupEmpty":"You currently have no database backups.","ui.maintenance.rebuildCache.title":"Application Cache","ui.maintenance.rebuildCache.description":"Rebuilding the application cache is required after modifying any of the configuration files.","ui.maintenance.rebuildCache.rebuildProd":"Rebuild Production Cache","ui.maintenance.rebuildCache.rebuildDev":"Rebuild Development Cache","ui.maintenance.rebuildCache.clearProd":"Clear Production Cache","ui.maintenance.rebuildCache.clearDev":"Clear Development Cache","ui.maintenance.installTool.title":"Contao Install Tool","ui.maintenance.installTool.description":"The Contao Install Tool is automatically locked if you enter a wrong password three times in a row.","ui.maintenance.installTool.unlock":"Unlock Install Tool","ui.maintenance.installTool.lock":"Lock Install Tool","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"The Composer autoloader is responsible for PHP class loading. The autoloader must be dumped after adding custom namespaces to the root composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Composer Dependencies","ui.maintenance.composerInstall.description":"Composer dependencies are located in the {vendor} folder in your application root. Reinstalling the dependencies can be necessary after manipulation or manually uploading the {composerLock} file.","ui.maintenance.composerInstall.button":"Run Installer","ui.maintenance.composerInstall.update":"Run Composer Update","ui.maintenance.composerCache.title":"Composer Cache","ui.maintenance.composerCache.description":"Composer caches downloaded packages for improved performance. If you have issues like broken files, try to delete the Composer cache to force a new download.","ui.maintenance.composerCache.button":"Clear Cache","ui.maintenance.maintenanceMode.title":"Maintenance Mode","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Enable","ui.maintenance.maintenanceMode.disable":"Disable","ui.maintenance.debugMode.title":"Debug Mode","ui.maintenance.debugMode.description":"Activate the debug mode by setting a user and password for the {appDevPhp} entry point.","ui.maintenance.debugMode.descriptionJwt":"Activate the debug mode by setting the debug cookie for the current domain.","ui.maintenance.debugMode.activate":"Activate","ui.maintenance.debugMode.deactivate":"Deactivate","ui.maintenance.debugMode.credentials":"Credentials","ui.maintenance.debugMode.user":"Please enter a username for the debug mode.","ui.maintenance.debugMode.password":"Please enter a password for the debug mode.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode caches PHP files on the web process for faster execution. It must be deleted under certain circumstances if files are not recognized after changing.","ui.maintenance.opcodeCache.button":"Truncate Cache","ui.maintenance.safeMode":"Not available in Safe Mode","ui.maintenance.unsupported":"Not supported by your Contao version","ui.packages.updateButton":"Update Packages","ui.packages.searchButton":"Search Packages","ui.packages.searchPlaceholder":"Search Packages …","ui.packages.uploadOverlay":"Drag & drop files to upload","ui.packages.uploadButton":"Upload Packages","ui.packages.uploadMessage":"You have one unconfirmed upload. | You have {count} unconfirmed uploads.","ui.packages.uploadApply":"Confirm Uploads","ui.packages.uploadReset":"Delete Uploads","ui.packages.uploadIncomplete":"This file was not uploaded completely. Please remove it and try again.","ui.packages.uploadDuplicate":"This file seems to be uploaded multiple times. Please remove the duplicates.","ui.packages.uploadInstalled":"This file is already installed. Please remove the duplicates.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"You have one unconfirmed change. | You have {count} unconfirmed changes.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Apply Changes","ui.packages.changesApplyAll":"Update all packages","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"Reset Changes","ui.packages.changesReview":"Review Changes","ui.packagelist.loading":"Loading …","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"New packages","ui.packagelist.installed":"Installed packages","ui.package.hintRevert":"Revert Changes","ui.package.hintNoupdate":"Do not update","ui.package.hintConstraint":"This package will be installed with constraint {constraint} when you apply the changes.","ui.package.hintConstraintBest":"This package will be installed in the best available version when you apply the changes.","ui.package.hintConstraintChange":"The constraint for this package will be changed from \\"{from}\\" to \\"{to}\\" when you apply the changes.","ui.package.hintConstraintUpdate":"This package will be updated when you apply the changes.","ui.package.hintAdded":"This package will be installed when you apply the changes.","ui.package.hintRemoved":"This package will be removed when you apply the changes.","ui.package.requiredTitle":"manually added","ui.package.requiredText":"This package is required in your composer.json but not installed.","ui.package.removedTitle":"manually removed","ui.package.removedText":"This package was removed from your composer.json.","ui.package.installed":"Currently installed:","ui.package.version":"Version {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"Edit","ui.package.uploadConstraint":"This constraint is defined by the uploaded package.","ui.package.updateButton":"Update","ui.package.removeButton":"Remove","ui.package.installButton":"Add Package","ui.package.installButtonShort":"Add","ui.package.detailsButton":"Details","ui.package.latestConstraint":"latest version","ui.package.update":"Update available","ui.package.updateLatest":"latest version","ui.package.updateAvailable":"{version} available","ui.package.updateUnknown":"unknown version","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Version {version}","ui.cloudStatus.waitingTime":"Waiting Time","ui.cloudStatus.jobs":"Current Jobs","ui.cloudStatus.workers":"Workers","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"none","ui.cloudStatus.short":"ca. {minutes} min","ui.cloudStatus.long":"ca. {minutes} min {seconds} sec","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Cloud Status","ui.cloudStatus.refresh":"Refresh Cloud Status","ui.log-viewer.loading":"Loading …","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Reload","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Channel","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Level","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Time","ui.log-viewer.messageHeader":"Message","ui.log-viewer.showContext":"Show Context","ui.log-viewer.hideContext":"Hide Context","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Change Password","ui.user-manager.setupTotp":"Setup Two-Factor Authentication","ui.user-manager.disableTotp":"Disable Two-Factor Authentication","ui.user-manager.invite":"Invite User","ui.user-manager.delete":"Delete","ui.user-manager.deleteConfirm":"Do you really want to delete user \\"{username}\\"?","ui.user-manager.deleted":"User {username} deleted successfully","ui.user-manager.passwordHeadline":"Change Password","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Current password","ui.user-manager.newPassword":"New password","ui.user-manager.passwordPlaceholder":"min. 8 characters","ui.user-manager.submitPassword":"Submit","ui.user-manager.passwordChanged":"Your password has been changed successfully.","ui.user-manager.passwordError":"This password is incorrect.","ui.user-manager.inviteHeadline":"Invite User","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Create Invitation Link","ui.user-manager.clipboard":"Copy to clipboard","ui.user-manager.permissions":"Learn about permissions","ui.user-manager.cancel":"Cancel","ui.user-manager.close":"Close","ui.user-manager.you":"You","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Two-Factor Authentication","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verification code","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"The verification code is invalid.","ui.totp.enable":"Enable","ui.totp.disable":"Disable","ui.totp.cancel":"Cancel","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Setup Two-Factor Authentication","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[551],{2551:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! この接続は安全ではありません !!","ui.app.httpsDescription":"HTTPSでないと秘密のデータも暗号化しないで送信してしまいます。","ui.app.httpsLink":"詳細な情報","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! セーフモードが有効です !!","ui.app.safeModeDescription":"Contao Managerの一部の機能は利用できません。","ui.app.safeModeExit":"セーフモードを終了","ui.app.limitedHeadline":"リモート認証","ui.app.limitedDescription":"パスワードなしのログインのため限れた権限になっています。","ui.app.limitedLogout":"再認証","ui.app.totpHeadline":"セキュリティの注意","ui.app.totpDescription":"すぐに2ファクタ認証を構成してアカウントを安全にします。","ui.app.totpSetup":"セットアップ","ui.app.loading":"Contao Managerを読み込み中…","ui.app.apiError":"予期しないAPIの状態","ui.app.configSecurity1":"セキュリティ警告!!!  保護していない設定ディレクトリを検出","ui.app.configSecurity2":"Contao Managerは設定ファイルが公開してアクセスできる状態を検出しました。ディレクトリを安全な状態にするまで、すべての操作は動作しません、そうしないとインストールに含まれている極秘データを攻撃者がアクセスできる可能性があるためです。\\n\\nこれを修正するには\\"contao-manager\\"のディレクトリへのアクセスを禁止してください。この方法を学ぶには、ウェブサーバーのマニュアルを参照するかホスティング提供者に連絡してください。","ui.account.welcome":"ようこそ","ui.account.intro1":"Contao Managerにようこそ。Contao ManagerはContaoオープンソースCMSのインストールと管理を行う多才なツールです。Contao Managerを初めて利用する場合は{readTheManualToGetStarted}","ui.account.introGetStarted":"最初に{readTheManual} ","ui.account.introManual":"マニュアルを読んでください","ui.account.intro2":"何か問題があった場合は、{ourGithubIssues} を確認して、まだ報告されていない新しいどの様な問題は自由に新しいIssueを作成してください。","ui.account.introIssues":"GitHubのIssue","ui.account.headline":"ユーザーアカウント","ui.account.description":"インストールしたContaoを管理するには新しいアカウントを作成してください。このアカウントはContaoのバックエンドやフロントエンドとはまったく関係ないことに注意してください。","ui.account.username":"ユーザー名","ui.account.password":"パスワード","ui.account.passwordPlaceholder":"最小で8文字","ui.account.passwordLength":"少なくとも8文字を入力してください。","ui.account.loginInvalid":"アカウントの作成でエラーとなりました。異なるユーザー名で試してください。","ui.account.submit":"アカウントを作成","ui.account.usePassword":"ログインにパスワードを使用","ui.account.usePasskey":"パスキーをログインに使用","ui.account.totpHeadline":"2ファクター認証","ui.account.totpDescription":"2ファクター認証を有効にしてセキュリティレベルを高めてください。ユーザー名とパスワードに加えて、1Password、Authy、Google Authenticator、LastPass Authenticatorや他のTOTP(Time-based One-Time Password)アプリの確認コードの入力が必要となります。","ui.account.totpSetup":"すぐに設定","ui.account.totpSkip":"後で設定","ui.account.login":"申し出を拒否","ui.account.contribute1":"ContaoとContao Managerは非営利のContao Associationが支援しています。","ui.account.contribute2":"{donate}でオープンソースに貢献することをご検討ください。","ui.account.contributeDonate":"寄付をする","ui.login.headline":"サインイン","ui.login.description":"インストールを管理するにはログインします。","ui.login.username":"ユーザー名","ui.login.password":"パスワード","ui.login.totpHeadline":"2ファクター認証","ui.login.totpDescription":"確認コードを入力してログイン処理を完了してください。","ui.login.totp":"確認コード","ui.login.forgotPassword":"パスワードを忘れましたか?","ui.login.button":"サインイン","ui.login.passkey":"パスキーでサインイン","ui.login.cancel":"取り止め","ui.login.or":"または","ui.login.locked":"Contao Managerはロック状態のためアクセスを拒否しました。ロックを解除するには、Contaoのルートディレクトリにあるファイル: {lockFile}を削除してください。","ui.logout.headline":"セッションタイムアウト","ui.logout.warning":"25分以上アクセスがありません。セキュリティ上の理由から、セッションを間もなく終了します。","ui.logout.expired":"30分以上アクセスがなかったため自動的にセッションを終了しました。","ui.logout.renew":"ログインを維持","ui.logout.logout":"ログアウト","ui.logout.login":"ログイン画面に戻る","ui.oauth.error":"不正なOAuthの試みです。リクエストのパラメーターを確認してください。","ui.oauth.https":"平文で認証トークンが転送されることを防ぐため、リダイレクトのURIは安全なプロトコル(https:)を*使用*しなければなりません。","ui.oauth.headline":"リモート認証","ui.oauth.description":"以下のアプリケーションやサービスが、このContao Managerへのリモートアクセスを要求しています。","ui.oauth.domain":"アクセスを許可する前に、このURLのことを知っていて所有者を信頼できることを確認してください!","ui.oauth.outOfScope":"残念ですが、このアクセスを許可するのに十分な権限がありません。","ui.oauth.allow":"アクセスを許可","ui.oauth.deny":"アクセスを拒否","ui.oauth.switchUser":"ユーザーを切り替え","ui.scope.admin":"ユーザー管理を含んだ管理者アクセス","ui.scope.install":"新しいパッケージのインストールとContaoの構成の変更","ui.scope.update":"パッケージの更新と保守の作業の実行","ui.scope.read":"パッケージと構成の読み取り","ui.boot.headline":"システム検査","ui.boot.description":"しばらくお待ちください、サーバーを解析中です...","ui.boot.issue1":"インストール上の問題を検出","ui.boot.issue2":"Contao Managerを使用できるようにする前に修正しなければならない問題があります。","ui.boot.run":"Contao Managerを開始","ui.boot.safeMode":"セーフモードで開始","ui.recovery.headline":"システム回復","ui.recovery.description":"Contao ManagerはContaoと思われるファイルを検出しましたが、コマンド行のインターフェイスは期待した様に動作しませんでした。","ui.recovery.console":"コンソール出力","ui.recovery.repairOptions":"インストールしたContaoを修正する方法を選択してください。","ui.recovery.repairHeadline":"自動修復","ui.recovery.repairDescription":"アプリケーションキャッシュの再構築とComposerパッケージを再インストールすることで、自動的にインストールの修復を試みます。","ui.recovery.repairWarning":"この処理でベンダーのファイルに行った変更は取り消されるかもしれません!","ui.recovery.repairFailed":"自動修復できませんでした。セーフモードで手作業でインストールを修復してみてください。","ui.recovery.repairButton":"システム修復を実行","ui.recovery.safeModeHeadline":"セーフモード","ui.recovery.safeModeDescription":"Contao Managerをセーフモードで開始するとパッケージの管理と特定の保守のタスクを実行できます。しかし、インストールしたContaoの動作に依存した機能は利用できません。","ui.recovery.safeModeButton":"セーフモードで開始","ui.server.pending":"待機中...","ui.server.running":"解析中…","ui.server.error":"サーバーからの予期しない応答のため検査に失敗しました。","ui.server.details":"詳細","ui.server.prerequisite":"前提条件を満たせていないため検査を取り止めました。","ui.server.selfUpdate.title":"Contao Managerを更新","ui.server.selfUpdate.update":"新しいContao Managerのバージョン {latest} を利用できます。","ui.server.selfUpdate.manualUpdate":"新しいContao Managerバージョン{latest}を利用できます。使用しているサーバーは自動的な更新をサポートしていません、新しいバージョンを {download} からダウンロードしてください。","ui.server.selfUpdate.latest":"最新のバージョン: {current}を使用しています。","ui.server.selfUpdate.dev":"開発版は自動的な更新をサポートしていません。","ui.server.selfUpdate.unsupported":"新しいバージョンを利用できますが、使用しているPHPのバージョンをサポートしていません。","ui.server.selfUpdate.button":"自己更新を実行","ui.server.selfUpdate.continue":"続ける","ui.server.config.title":"サーバーの構成","ui.server.config.setup":"構成","ui.server.config.change":"変更","ui.server.config.save":"保存","ui.server.config.cancel":"取り止め","ui.server.config.customOption":"その他…","ui.server.config.description":"バックグラウンドのタスクを正しく実行するため、Contao ManagerはPHPのコマンド行の実行ファイルがある場所と、ウェブのプロセスから切り離してコマンドを実行する方法を知る必要があります。","ui.server.config.formTitle":"サーバーの構成","ui.server.config.formText":"PHPの実行ファイルのパスを入力してください。Webのプロセスと同じバージョンのPHPであることを忘れずに確認してください。","ui.server.config.cloudTitle":"Composerリゾルバークラウド","ui.server.config.cloudText":"Composerリゾルバークラウドによって、サーバーが十分なローカルのメモリを提供しない場合でもComposerの依存関係のインストールが可能になります。パッケージの情報がContao Associationが運用するクラウドに送信されることに注意してください。","ui.server.config.cloud":"Composerリゾルバークラウドを使用","ui.server.config.cli":"PHPの実行ファイル","ui.server.config.stateErrorCli":"有効なPHPの実行ファイルをサーバー上に見つけられませんでした。","ui.server.config.stateErrorCloud":"Composerリゾルバークラウドをサポートしていません。","ui.server.config.stateSuccess":"PHPの実行ファイルは{php_cli}です。","ui.server.php_web.title":"PHPのWebプロセス","ui.server.php_web.below7":"PHPのバージョン {version} を検出しました。可能な限りPHP 7に切り替えてください!","ui.server.php_web.success":"PHPのバージョン {version} を検出しました、既知の問題はありませんでした。","ui.server.php_cli.title":"PHPコマンド行インターフェイス","ui.server.php_cli.success":"PHPのバージョン {version} を検出しました、既知の問題はありませんでした。","ui.server.composer.title":"Composer環境","ui.server.composer.success":"既知の問題はありませんでした。","ui.server.composer.install":"Composerの依存関係はインストールしていません。","ui.server.composer.button":"インストール","ui.server.contao.title":"Contaoのインストール","ui.server.contao.setup":"セットアップ","ui.server.contao.check":"データベースを検査","ui.server.contao.empty":"インストールしているContaoは見つかりませんでした。","ui.server.contao.old":"Contaoのバージョン{version}はContao Managerと互換性がありません。インストールしているContaoを手作業で更新してください。","ui.server.contao.found":"Contao {version} (APIバージョン {api})を検出しました。","ui.server.contao.connectionError":"データベースサーバーに接続できません。","ui.server.contao.connectionProblem":"データベースの問題が見つかりました。","ui.server.contao.missingUser":"管理者のアカウントがありません。","ui.setup.continue":"続ける","ui.setup.manager":"Contao Managerを開始","ui.setup.cancel":"取り止め","ui.setup.welcome":"ようこそ","ui.setup.welcome1":"このウィザードはContaoオープンソースCMSを設定するのに必要な段階を案内します。","ui.setup.welcome2":"もし質問がありましたらドキュメント、フォーラム、Slackのチャンネル、さらに多くの情報を{support}のページから探してください。","ui.setup.support":"コミュニティサポート","ui.setup.start":"始める","ui.setup.complete":"おめでとうございます!","ui.setup.complete1":"Contao {version}をうまくインストールしました。","ui.setup.complete2":"設定の処理を終えるには、インストールツールを開いて、データベース接続を構成し、バックエンドのユーザーを作成してください。","ui.setup.complete3":"Contaoのバックエンドでウェブサイトを作成できるようになりました。追加の機能拡張が必要な場合は、Contao Managerを続けてください。","ui.setup.installTool":"インストールツールを開く","ui.setup.login":"Contaoにログイン","ui.setup.funding":"フリーソフトウェアの「フリー」は「言論の自由」の自由であって、「無料のビール」の「無料」ではありません。Contaoのようなオープンソースのプロジェクトは一人の個人や1つの会社では集められない資金を必要とします。\\nContaoでウェブサイトを構築したり、構築したウェブサイトを販売される場合は、ビジネスが依存する製品に金銭的に貢献されることを期待しています。","ui.setup.fundingLink":"さらに学ぶ","ui.setup.document-root.headline":"Webサーバーの設定","ui.setup.document-root.warning":"Contao ManagerからContaoをインストールするには、Webサーバーのドキュメントルートを修正しなければなりません。","ui.setup.document-root.description1":"Contaoは公開するファイルに別のフォルダーを使用し、その親のフォルダーにアプリケーションのファイルをインストールします。フォルダーの構造が正しくないか、またはフォルダーが空でない場合はContaoをインストールできません。","ui.setup.document-root.description2":"ドキュメントルートを構成する方法を知らない場合は、Contaoのドキュメントを読むかホスティングサービスの提供者に連絡してください。","ui.setup.document-root.documentation":"ドキュメントを読む","ui.setup.document-root.conflictsTitle":"インストール先のディレクトリが空ではありません","ui.setup.document-root.conflictsDirectory":"Contaoをインストールしようとしているルートのディレクトリが空ではありません、インストールの処理で{count}個のファイルを上書きするかもしれません。Contaoのために空のディレクトリ構造の作成を推奨しますが、以下のファイルを使用していないことが確かな場合は、これらを削除して再検査することもできます。","ui.setup.document-root.ignoreConflicts":"空でないディレクトリにContaoをインストールしようとしています。Web領域の既存のファイルを上書きする可能性を理解しています。","ui.setup.document-root.check":"再検査","ui.setup.document-root.create":"ディレクトリを作成","ui.setup.document-root.change":"ディレクトリを変更","ui.setup.document-root.formTitle":"ディレクトリ設定","ui.setup.document-root.formText1":"Contao Managerはサーバー上に新しいディレクトリ構成を自動的に作成できます。","ui.setup.document-root.formText2":"手作業で(例えば、ホスティングの管理パネルから)新しいドキュメントルートを構成する必要があります。","ui.setup.document-root.autoconfig":"サーバーの構成を変更しなければならないことを理解しました。ドキュメントルートを構成しないとContao Managerは壊れ、(アカウントの詳細とパスワードを含んだ)構成ファイルを剥き出しの状態にしてしまいます。","ui.setup.document-root.directory":"新しいディレクトリ","ui.setup.document-root.currentRoot":"現在のドキュメントルート","ui.setup.document-root.newRoot":"新しいドキュメントルート","ui.setup.document-root.finish":"ディレクトリの設定","ui.setup.document-root.publicDir":"{dir}を(Contao {version}の)公開ファイルの場所として使用","ui.setup.document-root.directoryInvalid":"有効なディレクトリの名前を入力してください。","ui.setup.document-root.directoryExists":"目的のディレクトリは既に存在します。異なる名前を入力してください。","ui.setup.document-root.confirmation":"Contao ManagerはContaoのインストールに必要なディレクトリを作成しました。次にウェブサーバーのドキュメントルートを構成しなければなりません。このページをそれまで再読み込みしないでください。","ui.setup.document-root.reload":"ページを再読み込み","ui.setup.document-root.success":"ウェブサーバーにディレクトリ構造を正しく設定できました!","ui.setup.document-root.installingProjectDir":"{dir}にアプリケーションのファイルをインストールします。","ui.setup.document-root.installingPublicDir":"{dir}に公開するファイルをインストールします。","ui.setup.document-root.installedProjectDir":"{dir}にアプリケーションのファイルをインストールしました。","ui.setup.document-root.installedPublicDir":"{dir}に公開するファイルをインストールしました。","ui.setup.create-project.headline":"Contaoのインストール","ui.setup.create-project.description":"Contaoの開発は{semver}の概念にしたがっていて、新しいマイナーバージョンを6か月毎にリリースします。現在サポートしているリリース:","ui.setup.create-project.semver":"セマンティックバージョニング","ui.setup.create-project.latestTitle":"最新","ui.setup.create-project.ltsTitle":"長期サポート版","ui.setup.create-project.latestQ1":"最新のバージョン、もっとも多くの機能を提供して{year}年2月までサポートします。","ui.setup.create-project.latestQ3":"最新のバージョン、もっとも多くの昨日を提供して{year}年8月までサポートします。","ui.setup.create-project.ltsText":"現在のLTSバージョン、安定性を重視する場合に選んでください。さらに{year}年2月までの長期サポートを提供します。","ui.setup.create-project.pltsText":"以前のLTSバージョン、さらに{year}年2月までの長期サポートを提供します。","ui.setup.create-project.requiresPHP":"少なくともPHP {version}が必要です、現在はPHP {current}です。","ui.setup.create-project.releaseplan":"詳細な情報は{contaoReleasePlan}を参照してください。","ui.setup.create-project.releaseplanLink":"Contaoのリリース計画","ui.setup.create-project.installed":"サーバーにContao {version}のインストールに成功しました。データベースの設定を続けるか、異なるバージョンをインストールするにはContao Managerを起動してください。","ui.setup.create-project.formTitle":"配布の選択","ui.setup.create-project.formText":"インストールするバージョンを選択してください。","ui.setup.create-project.version":"バージョン","ui.setup.create-project.demo":"Contaoのデモ版のWebサイトをインストール","ui.setup.create-project.demoDescription":"デモ版のWebサイトはContaoと、その基本的な特徴を知る助けとなります。テーマはさらに{store}で入手できます。","ui.setup.create-project.coreOnly":"最小のインストール(コアだけ)","ui.setup.create-project.noUpdate":"インストールを省く(専門家だけ!)","ui.setup.create-project.theme":"Contaoのテーマ","ui.setup.create-project.themeInstall":"Contaoのテーマをインストールするには、検索入力を使用するか、Contao Managerからのインストールをサポートしたテーマのファイル(.ctoまたは.zip)をアップロードしてください。","ui.setup.create-project.themeBuy":"必ず公式の{store}にアクセスしてください。","ui.setup.create-project.themeStore":"Contaoのテーマのストア","ui.setup.create-project.themeUpload":"テーマのファイル(.cto/.zip)をアップロード","ui.setup.create-project.themeInvalid":"アップロードしたファイルはContaoのテーマではないか、Contao Managerをサポートしていません。","ui.setup.create-project.themeWarning":"このテーマがサーバーと互換性があるかどうか、COntao Managerは判断できません。何か疑問がある場合はテーマのベンダーに相談してください。","ui.setup.create-project.themeTitle":"テーマの詳細を調査","ui.setup.create-project.themeDetails":"このテーマは以下の依存関係とファイルもインストールします。","ui.setup.create-project.themeRequire":"{count} 依存関係 | {count} 依存関係","ui.setup.create-project.themeFiles":"{count} ファイル | {count} ファイル","ui.setup.create-project.theme.or":"または公開テーマを検索","ui.setup.create-project.theme.search":"テーマを検索","ui.setup.create-project.theme.more":"さらにテーマ","ui.setup.create-project.theme.empty":"{query}に一致するテーマがありません。","ui.setup.create-project.theme.uploaded":"テーマのファイルのアップロードに成功しました。","ui.setup.create-project.theme.packageName":"パッケージ名","ui.setup.create-project.theme.version":"バージョン","ui.setup.create-project.theme.authors":"作成者","ui.setup.create-project.theme.upload":"{name} ({size})をアップロード中","ui.setup.create-project.install":"インストール","ui.setup.create-project.cancel":"取り止め","ui.setup.database-connection.headline":"データベース接続","ui.setup.database-connection.description":"Contaoはページ、コンテント、ユーザー、他の関係のあるデータを保管するためにMySQLデータベース(またはMariaDBの様な互換性のある分岐)を必要とします。接続のパラメーターは、Contaoをインストールしたプロジェクトのルートにある{env}ファイルに保存します。","ui.setup.database-connection.formTitle":"接続パラメーター","ui.setup.database-connection.formText":"データベースのURLを入力するか、ユーザー名、パスワード、サーバー、データベースの欄を別々に入力してください。","ui.setup.database-connection.url":"データベースのURL","ui.setup.database-connection.validUrl":"データベースのURLが正しくないか、サーバーへの接続に失敗しました。","ui.setup.database-connection.or":"または","ui.setup.database-connection.user":"ユーザー名","ui.setup.database-connection.password":"パスワード","ui.setup.database-connection.server":"サーバー(:ポート)","ui.setup.database-connection.database":"データベース名","ui.setup.database-connection.connected":"{server}のデータベース{database}に接続しました。","ui.setup.database-connection.error":"データベースの接続のエラーです。","ui.setup.database-connection.problem":"Contaoはデータベースサーバーの問題を検出しました。","ui.setup.database-connection.schemaTitle":"データベーススキーマ","ui.setup.database-connection.migration":"未解決の移行が1件あります。 | 未解決の移行が{count}件あります。","ui.setup.database-connection.schema":"未解決のスキーマの更新が1件あります。 | 未解決のスキーマの更新が{count}件あります。","ui.setup.database-connection.noChanges":"データベースのスキーマは最新です。","ui.setup.database-connection.check":"データベースを検査","ui.setup.database-connection.skip":"飛ばす","ui.setup.database-connection.save":"保存","ui.setup.database-connection.change":"認証情報を変更","ui.setup.database-connection.restoreTitle":"データベースをインポート","ui.setup.database-connection.restoreText":"先ほどインストールしたテーマはデータベースのバックアップを含んでいます。データベースを復元してテーマのデータを取り込むか、空のContaoのインストールから始める場合はこの段階を飛ばしてください。 | 先ほどインストールしたテーマは複数のデータベースのバックアップを含んでいます。バックアップのファイルを選択してテーマのデータをインポートするか、空のContaoのインストールから始める場合はこの段階を飛ばしてください。","ui.setup.database-connection.backup":"インポート前に現在のデータベースをバックアップ","ui.setup.database-connection.backupWarning":"データベースのすべてのデータを上書きします。データベースが空でない場合は最初にバックアップを作成してください。","ui.setup.database-connection.restore":"テーマのデータベースをインポート","ui.setup.database-connection.restoreOption":"{date} ({size})からバックアップ","ui.setup.database-connection.restored":"テーマのデータベースのインポートに成功しました。データベースのスキーマの検証に進んでください。","ui.setup.backend-user.success":"データベースにContaoのバックエンドの管理者のアカウントがあります。さらにユーザーを追加するにはContaoのバックエンドを使用してください。","ui.setup.backend-user.error":"ユーザーのリストを取り出せません。詳細はコンソールの出力を確認してください。","ui.setup.backend-user.headline":"バックエンドのアカウント","ui.setup.backend-user.description":"ウェブサイトを管理するには、少なくともContaoのバックエンドの管理者のアカウントが1つ必要です。このアカウントはContao Managerと無関係なことに注意してください。","ui.setup.backend-user.formTitle":"アカウントを作成","ui.setup.backend-user.formText":"新しいバックエンドのアカウントの詳細を入力してください。","ui.setup.backend-user.username":"ユーザー名","ui.setup.backend-user.name":"名前","ui.setup.backend-user.email":"電子メールアドレス","ui.setup.backend-user.emailInvalid":"有効な電子メールアドレスを入力してください。","ui.setup.backend-user.password":"パスワード","ui.setup.backend-user.passwordPlaceholder":"最小で8文字","ui.setup.backend-user.passwordLength":"少なくとも8文字を入力してください。","ui.setup.backend-user.create":"アカウントを追加","ui.task.headline":"バックグランドのタスク","ui.task.loading":"詳細を読み込み中...","ui.task.created":"詳細を読み込み中...","ui.task.active":"Contao Managerがバックグラウンドでタスクの処理を実行を開始するまで、しばらくお待ちください。","ui.task.complete":"すべての処理を正常に完了しました。詳細はコンソールの出力を確認してください。","ui.task.paused":"バックグラウンドの処理が予期せず停止しました。コンソールの出力を確認してください。","ui.task.aborting":"バックグラウンドの処理を取り消すまで、しばらくお待ちください。","ui.task.stopped":"バックグラウンドの処理の一部を取り消しました。コンソールの出力を確認してください。","ui.task.error":"バックグラウンドの処理が予期せず停止しました。コンソールの出力を確認してください。","ui.task.failed":"Contao Managerはバックグラウンドのタスクを開始できませんでした!","ui.task.failedDescription1":"バックグラウンドで処理を実行しようとするときに何か問題がありました。","ui.task.failedDescription2":"これが再度起きる場合は、サーバーはサポートされていないかもしれません。","ui.task.reportProblem":"問題を報告","ui.task.pausedDescription":"エラーを無視して残る作業を実行したい場合は「続ける」をクリックしてください。","ui.task.sponsor":"{sponsor}が後援のComposer Cloud","ui.task.buttonAudit":"データベースを更新","ui.task.buttonClose":"閉じる","ui.task.buttonConfirm":"確認して閉じる","ui.task.buttonContinue":"続ける","ui.task.buttonCancel":"取り止め","ui.task.confirmCancel":"このタスクを本当に取り止めて良いですか?  取り止めるとContaoのインストールを壊れた状態のままにするかもしれません。","ui.task.autoclose":"正常に終了したときにタスクの詳細を閉じる","ui.console.toggle":"コンソールの出力を表示・非表示","ui.console.showLog":"完全なコンソールのログを表示","ui.console.copyLog":"ログをクリップボードにコピー","ui.migrate.headline":"データベースの更新","ui.migrate.migrationsOnly":"(移行だけ)","ui.migrate.schemaOnly":"(スキーマだけ)","ui.migrate.loading":"しばらくお待ちください、データベースを検査中です...","ui.migrate.empty":"未解決な移行やスキーマの更新はありません。データベースは最新です。","ui.migrate.emptyMigrations":"未解決な移行はありません。スキーマの更新も忘れずにしてください。","ui.migrate.emptySchema":"未解決なスキーマの更新はありません。移行の確認も忘れずにしてください。","ui.migrate.pending":"データベースが最新ではありません。以下のコンソール出力を再確認して変更を実行してください。","ui.migrate.previousChanges":"以前のデータベース移行を確認できませんでした。\\n以下のコンソール出力を再確認して、次の変更の確認に進んでください。","ui.migrate.previousComplete":"以前のデータベース移行を確認できませんでしたので、以下のコンソール出力を再確認してください。\\nこれ以上の未解決な変更はありません。","ui.migrate.appliedChanges":"データベースの更新を適用しました。\\n以下のコンソール出力を再確認して、次の変更の確認に進んでください。","ui.migrate.appliedComplete":"データベースの更新を適用しました。\\n未確認の移行やスキーマの更新はありません。データベースは最新の状態です。","ui.migrate.problem":"Contaoはデータベースサーバーの問題を検出しました。\\n下のコンソール出力を再確認して修正しなければならない事項を調査してください!","ui.migrate.warning":"Contaoはデータベースサーバーの誤った設定を検出しました。\\n一時的に警告は無視できますが、最適な性能とデータの一貫性のためには修正しなければなりません。","ui.migrate.error":"変更を適用できませんでした。データベースは変更されているかもしれません、再確認して再実行してください。","ui.migrate.execute":"実行","ui.migrate.close":"閉じる","ui.migrate.confirm":"確認して閉じる","ui.migrate.cancel":"取り止め","ui.migrate.continue":"続ける","ui.migrate.setup":"セットアップ","ui.migrate.skip":"飛ばす","ui.migrate.retry":"再検査","ui.migrate.retryAll":"すべて検査","ui.migrate.withDeletes":"DROPの処理を含む、すべてのデータベースの変更を実行します。","ui.migrate.migrationTitle":"データベースの移行","ui.migrate.schemaTitle":"スキーマの更新","ui.migrate.problemTitle":"データベースの問題","ui.migrate.warningTitle":"データベースの警告","ui.migrate.addTable":"テーブルを追加","ui.migrate.dropTable":"テーブルを削除","ui.migrate.addField":"項目{table}.{field}を追加","ui.migrate.changeField":"項目{table}.{field}を変更","ui.migrate.dropField":"項目{table}.{field}を削除","ui.migrate.createIndex":"{table}にインデックス\\"{name}\\"を作成","ui.migrate.dropIndex":"{table}のインデックス\\"{name}\\"を削除","ui.widget.mandatory":"この欄の入力は必須です。","ui.widget.blankOption":"選択してください…","ui.widget.showPassword":"パスワードを表示","ui.widget.hidePassword":"パスワードを非表示","ui.error.title":"\\"{method} {url}\\"というHTTPの要求に失敗しました。","ui.error.server500":"予期しないエラーがサーバーで発生したようです。Webサーバー(Apache/Nginx)のログファイルと、Contao Managerの\\"contao-manager/logs\\"へのログを確認してください。","ui.error.response":"サーバーは{status}という応答コードを返しました。","ui.error.moreLink":"詳細な情報","ui.error.support":"Contaoサポート","ui.error.permission":"この機能を使用する権限がありません。","ui.footer.help":"ヘルプ","ui.footer.reportProblem":"問題を報告","ui.navigation.discover":"発見","ui.navigation.packages":"パッケージ","ui.navigation.tools":"ツール","ui.navigation.installTool":"インストールツール","ui.navigation.backend":"Contaoのバックエンド","ui.navigation.debug":"Contaoのデバッグモード","ui.navigation.logViewer":"ログ表示","ui.navigation.phpinfo":"PHPの情報","ui.navigation.phpinfoLoading":"PHPの情報を読み込み中...","ui.navigation.maintenance":"保守","ui.navigation.rebuildCache":"キャッシュを再作成","ui.navigation.users":"アカウント","ui.navigation.systemCheck":"システム検査","ui.navigation.advanced":"詳細","ui.navigation.logout":"ログアウト","ui.maintenance.database.title":"データベースの移行とバックアップ","ui.maintenance.database.description":"データベースの移行はデータとテーブルのスキーマの一貫性を確保します。","ui.maintenance.database.migrations":"未解決のデータベース移行が1件 | 未解決のデータベース移行が{count}件","ui.maintenance.database.schemaUpdates":"未解決のスキーマの更新が1件 | 未解決のスキーマの更新が{count}件","ui.maintenance.database.error":"データベースの問題が見つかりました。","ui.maintenance.database.warning":"データベースの警告が見つかりました。","ui.maintenance.database.button":"データベースを検査","ui.maintenance.database.migrationOnly":"移行だけを検査","ui.maintenance.database.schemaOnly":"スキーマだけを検査","ui.maintenance.database.installTool":"インストールツールを開く","ui.maintenance.database.createBackup":"バックアップを作成","ui.maintenance.database.backupUnsupported":"このContaoのバージョンではデータベースのバックアップをサポートしていません。","ui.maintenance.database.backupList":"データベースのバックアップが1個あって、{date}に作成されています。 | データベースのバックアップが{count}個あって、最新のものは{date}に作成されています。","ui.maintenance.database.backupEmpty":"現在データベースのバックアップはありません。","ui.maintenance.rebuildCache.title":"アプリケーションキャッシュ","ui.maintenance.rebuildCache.description":"構成ファイルのいずれかを修正した後はアプリケーションキャッシュの再構築が必要です。","ui.maintenance.rebuildCache.rebuildProd":"実稼働用のキャッシュを再構築","ui.maintenance.rebuildCache.rebuildDev":"開発用のキャッシュを再構築","ui.maintenance.rebuildCache.clearProd":"実稼働用のキャッシュを消去","ui.maintenance.rebuildCache.clearDev":"開発用のキャッシュを消去","ui.maintenance.installTool.title":"Contaoインストールツール","ui.maintenance.installTool.description":"連続して3回誤ったパスワードを入力すると、Contaoのインストールツールは自動的にロック状態となります。","ui.maintenance.installTool.unlock":"インストールツールのロックを解除","ui.maintenance.installTool.lock":"インストールツールをロック","ui.maintenance.dumpAutoload.title":"Composerクラスローダー","ui.maintenance.dumpAutoload.description":"ComposerのオートローダーがPHPのクラスの読み込み担当します。rootのcomposer.jsonに独自のネームスペースを追加した後は、オートローダーを書き出さなければなりません。","ui.maintenance.dumpAutoload.button":"オートローダーを書き出し","ui.maintenance.composerInstall.title":"Composerの依存関係","ui.maintenance.composerInstall.description":"Composerの依存関係はアプリケーションのルートの{vendor}フォルダーに配置されています。{composerLock}ファイルを操作や手動でアップロードした後は依存関係の再インストールが必要な場合があります。","ui.maintenance.composerInstall.button":"インストーラーを実行","ui.maintenance.composerInstall.update":"Composerで更新を実行","ui.maintenance.composerCache.title":"Composerキャッシュ","ui.maintenance.composerCache.description":"Composerは性能向上のためにダウンロードしたパッケージをキャッシュします。壊れたファイルのような問題がある場合は、Composerキャッシュを削除して強制的に新しいダウンロードを行ってみてください。","ui.maintenance.composerCache.button":"キャッシュを消去","ui.maintenance.maintenanceMode.title":"保守モード","ui.maintenance.maintenanceMode.description":"Contaoを保守モードにするとウェブサイトでは\\"503 Service Unavailable\\"のテンプレートを表示します。","ui.maintenance.maintenanceMode.enable":"有効","ui.maintenance.maintenanceMode.disable":"無効","ui.maintenance.debugMode.title":"デバッグモード","ui.maintenance.debugMode.description":"{appDevPhp}のエントリーポイントにユーザーとパスワードを設定してデバッグモードを有効にします。","ui.maintenance.debugMode.descriptionJwt":"現在のドメインにデバッグ用のクッキーを設定してデバッグモードを有効にします。","ui.maintenance.debugMode.activate":"有効化","ui.maintenance.debugMode.deactivate":"無効化","ui.maintenance.debugMode.credentials":"認証情報","ui.maintenance.debugMode.user":"デバッグモードのユーザー名を入力してください。","ui.maintenance.debugMode.password":"デバッグモードのパスワードを入力してください。","ui.maintenance.opcodeCache.title":"Opcodeキャッシュ","ui.maintenance.opcodeCache.description":"Opcodeは高速な実行のためにPHPのファイルをウェブプロセス常にキャッシュします。変更後にファイルの変化を認識していないといった、特定の状況では削除しなければなりません。","ui.maintenance.opcodeCache.button":"キャッシュを切り詰め","ui.maintenance.safeMode":"セーフモードでは利用不可","ui.maintenance.unsupported":"このContaoのバージョンでは非サポート","ui.packages.updateButton":"パッケージを更新","ui.packages.searchButton":"パッケージを検索","ui.packages.searchPlaceholder":"パッケージを検索中…","ui.packages.uploadOverlay":"アップロードするファイルをドラッグアンドドロップ","ui.packages.uploadButton":"パッケージをアップロード","ui.packages.uploadMessage":"未確認の1個のアップロードがあります。 | 未確認の{count}個のアップロードがあります。","ui.packages.uploadApply":"アップロードを実行","ui.packages.uploadReset":"アップロードを削除","ui.packages.uploadIncomplete":"このファイルは完全にアップロードできていません。一旦削除削除してもう一度アップロードしてください。","ui.packages.uploadDuplicate":"このファイルを複数回アップロードした様です。重複しているファイルを削除してください。","ui.packages.uploadInstalled":"このファイルを既にインストールしています。重複しているファイルを削除してください。","ui.packages.uploadUnsupported":"インストールしたContaoはアップロードをサポートしていません。PHPのzip拡張のインストールと依存関係の更新を確認してください。","ui.packages.changesMessage":"未確認の1個の変更があります。 | 未確認の{count}個の変更があります。","ui.packages.changesDryrun":"変更を試行","ui.packages.changesApply":"変更を適用","ui.packages.changesApplyAll":"すべてのパッケージを更新","ui.packages.changesDryrunAll":"すべてのパッケージの変更を試行","ui.packages.changesReset":"変更をリセット","ui.packages.changesReview":"変更を見直し","ui.packagelist.loading":"読み込み中...","ui.packagelist.uploads":"アップロード","ui.packagelist.added":"新しいパッケージ","ui.packagelist.installed":"インストール済みのパッケージ","ui.package.hintRevert":"変更を取り消す","ui.package.hintNoupdate":"更新しない","ui.package.hintConstraint":"この変更を適用すると、このパッケージを{constraint}の制約によりインストールします。","ui.package.hintConstraintBest":"変更を適用すると、このパッケージの利用できる一番良いバージョンをインストールします。","ui.package.hintConstraintChange":"変更を適用すると、このパッケージへの制約は\\"{from}\\"から\\"{to}\\"に変更します。","ui.package.hintConstraintUpdate":"変更を適用すると、このパッケージを更新します。","ui.package.hintAdded":"変更を適用すると、このパッケージをインストールします。","ui.package.hintRemoved":"変更を適用すると、このパッケージを削除します。","ui.package.requiredTitle":"手作業で追加済み","ui.package.requiredText":"このパッケージはcomposer.jsonで必要としていますが、インストールされていません。","ui.package.removedTitle":"手作業で削除済み","ui.package.removedText":"このパッケージはcomposer.jsonから削除されています。","ui.package.installed":"インストール済み:","ui.package.version":"バージョン{version}","ui.package.additionalDownloads":"{count}個のダウンロード | {count}個のダウンロード","ui.package.additionalStars":"{count}のスター | {count}のスター","ui.package.editConstraint":"編集","ui.package.uploadConstraint":"この定数はアップロードしたパッケージで定義されています。","ui.package.updateButton":"更新","ui.package.removeButton":"削除","ui.package.installButton":"パッケージを追加","ui.package.installButtonShort":"追加","ui.package.detailsButton":"詳細","ui.package.latestConstraint":"最新のバージョン","ui.package.update":"更新を利用可能","ui.package.updateLatest":"最新のバージョン","ui.package.updateAvailable":"バージョン{version}を利用可能","ui.package.updateUnknown":"不明なバージョン","ui.package.updateConstraint":"バージョンの制約外に利用できる新しいバージョンがあります。","ui.package.incompatible":"{package}はContao {constraint}では動作しません。","ui.cloudStatus.headline":"Composerリゾルバークラウド","ui.cloudStatus.version":"バージョン{version}","ui.cloudStatus.waitingTime":"待ち時間","ui.cloudStatus.jobs":"現在のジョブ","ui.cloudStatus.workers":"ワーカー","ui.cloudStatus.approx":"{minutes}分","ui.cloudStatus.none":"なし","ui.cloudStatus.short":"ca. {minutes}分","ui.cloudStatus.long":"ca. {minutes}分{seconds}秒","ui.cloudStatus.error":"Composerリゾルバークラウドの状態を取得できません。保守または技術的な問題のため停止しているかもしれません。","ui.cloudStatus.button":"クラウドの状態","ui.cloudStatus.refresh":"クラウドの状態を更新","ui.log-viewer.loading":"読み込み中...","ui.log-viewer.empty":"サーバーにログファイルはありません。","ui.log-viewer.reload":"際読み込み","ui.log-viewer.file":"ログファイル","ui.log-viewer.channel":"チャネル","ui.log-viewer.channelTitle":"このメッセージを記録する先のチャネルです。","ui.log-viewer.level":"レベル","ui.log-viewer.levelTitle":"ログメッセージの深刻さです。","ui.log-viewer.timeHeader":"時刻","ui.log-viewer.messageHeader":"メッセージ","ui.log-viewer.showContext":"コンテキストを表示","ui.log-viewer.hideContext":"コンテキストを非表示","ui.log-viewer.showExtra":"追加を表示","ui.log-viewer.hideExtra":"追加を非表示","ui.log-viewer.more":" さらに読み込む...","ui.log-viewer.download":"ダウンロード","ui.log-viewer.downloadTitle":"\\"{file}\\"をダウンロード","ui.log-viewer.prodEnvironment":"実運用環境","ui.log-viewer.devEnvironment":"開発環境(デバッグモード)","ui.user-manager.loading":"ユーザーを読み込み中...","ui.user-manager.changePassword":"パスワードを変更","ui.user-manager.setupTotp":"2ファクター認証を設定","ui.user-manager.disableTotp":"2ファクター認証を無効","ui.user-manager.invite":"ユーザーを招待","ui.user-manager.delete":"削除","ui.user-manager.deleteConfirm":"ほんとうにユーザー: \\"{username}\\"を削除しますか?","ui.user-manager.deleted":"ユーザー: {username}を削除しました。","ui.user-manager.passwordHeadline":"パスワードを変更","ui.user-manager.passwordText":"パスワードを変更するには、現在のパスワードと新しいパスワードをそれぞれの欄に入力してください。","ui.user-manager.currentPassword":"現在のパスワード","ui.user-manager.newPassword":"新しいパスワード","ui.user-manager.passwordPlaceholder":"最小で8文字","ui.user-manager.submitPassword":"送信","ui.user-manager.passwordChanged":"パスワードを変更しました。","ui.user-manager.passwordError":"このパスワードは間違っています。","ui.user-manager.inviteHeadline":"ユーザーを招待","ui.user-manager.inviteText":"Contao Managerに複数のログイン情報が必要な場合、ここで招待のリンクを作成できます。このリンクを誰か、または他の機器で使用して、指定した権限の新しいアカウントを作成してください。","ui.user-manager.inviteSuccess1":"新しい招待のリンクを作成しました。以下のURLを使用して、このContao Managerの新しいユーザーを作成できます。この招待は(今から1週間後の){expires}に期限が切れます。","ui.user-manager.inviteSuccess2":"リンクをクリップボードにコピーしてください。一度だけ動作し、このダイアログを閉じた後に再び見ることはできません。","ui.user-manager.createInvitation":"招待のリンクを作成","ui.user-manager.clipboard":"クリップボードにコピー","ui.user-manager.permissions":"権限について学ぶ","ui.user-manager.cancel":"取り止め","ui.user-manager.close":"閉じる","ui.user-manager.you":"あなた","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"このアカウントは2ファクター認証により安全です。","ui.user-manager.2faDisabled":"このアカウントはに2ファクター認証が設定されていないため安全ではありません。","ui.user-manager.passkey":"パスキー","ui.user-manager.passkeyTitle":"このアカウントはパスキーにより安全です。","ui.totp.headline":"2ファクター認証","ui.totp.setupQr":"2FA/TOTPアプリでQRコードを読み取ってください。","ui.totp.setupCode":"QRコードを読み取れない場合は、このキーを代わりに入力してください: ","ui.totp.codeLabel":"確認コード","ui.totp.codeDescription":"2FA/TOTPアプリが生成した確認コードを入力してください。","ui.totp.disableText":"2ファクター認証を無効にするには確認コードを入力してください。","ui.totp.invalid":"確認コードが無効です。","ui.totp.enable":"有効","ui.totp.disable":"無効","ui.totp.cancel":"取り止め","ui.totp.enabled":"2ファクター認証を有効にしました。","ui.totp.disabled":"2ファクター認証を無効にしました。","ui.totp.setup":"2ファクター認証を設定","ui.totp.skip":"2ファクター認証を飛ばす"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[194],{194:function(a){a.exports=JSON.parse('{"ui.app.title":"Contao paplašinājumi","ui.app.loading":"Ielādē paplašinājumu sarakstu ...","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Reklāma paplašinājumu sarakstā","ui.discover.loading":"Ielādē ...","ui.discover.offline":"Nevarēja iegūt nekādus rezultātus.","ui.discover.offlineExplain":"Pārbaudiet savu interneta savienojumu un atspējojiet JavaScript bloķētājus savā pārlūkprogrammā.","ui.discover.offlineButton":"Mēģini vēlreiz","ui.discover.searchPlaceholder":"Meklēt {count} paplašinājumos ...","ui.discover.empty":"Nav rezultātu {query}","ui.discover.more":"Vairāk rezultātu","ui.discover.sortBy":"Kārtot pēc","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"Atjaunināts","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"Lejupielādes","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"Vērtējums","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"Sīkāka informācija","ui.discover.latestPackages":"Jaunākie un atjauninātie paplašinājumi","ui.discover.faversPackages":"Visaugstāk novērtētie paplašinājumi","ui.discover.downloadsPackages":"Visvairāk lejupielādētie paplašinājumi","ui.discover.exactHit":"Exact query match","ui.discover.results":"More search results","ui.package.homepage":"Projekta mājaslapa","ui.package.private":"Privāta pakotne","ui.package.privateTitle":"Privātās pakotnes ir pieejamas tikai pie pārdevēja (piem., kā ZIP lejupielādes). Lūdzu, apmeklējiet vietni, lai iegūtu papildinformāciju.","ui.package.abandoned":"pamests","ui.package.abandonedText":"Šī pakotne ir pamesta un vairs netiek uzturēta.","ui.package.abandonedReplace":"Šī pakotne ir pamesta un vairs netiek uzturēta. Autors iesaka tās vietā izmantot pakotni {replacement}.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"Iepriekšējā paplašinājuma informācija","ui.package-details.close":"Aizvērt paplašinājuma informāciju","ui.package-details.loading":"Ielādē ...","ui.package-details.tabDescription":"Apraksts","ui.package-details.tabRequire":"Prasības","ui.package-details.tabFeatures":"Iespējas","ui.package-details.tabSuggest":"Ieteikumi","ui.package-details.tabConflict":"Konflikti","ui.package-details.tabDependents":"Atkarīgie","ui.package-details.linkRequires":"nepieciešams","ui.package-details.linkReplaces":"aizstāj","ui.package-details.linkProvides":"nodrošina","ui.package-details.linkConflicts":"konflikti","ui.package-details.funding":"Finansējiet paketes uzturēšanu!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"Jaunākā versija","ui.package-details.released":"izlaists","ui.package-details.license":"Licence(s)","ui.package-details.authors":"no","ui.package-details.more":"Vairāk","ui.package-details.packagist":"Pakotnes informācija","ui.package-details.metadata":"Rediģēt metadatus","ui.package-details.support_docs":"Dokumentācija","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Atbalsta forums","ui.package-details.support_issues":"Problēmas / Kļūdu ziņojums","ui.package-details.support_source":"Avota kods","ui.package-details.support_irc":"IRC / Tērzēšana","ui.package-details.support_email":"Atbalsta e-pasts","ui.package-details.support_rss":"RSS barotne"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[638],{3638:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Niebezpieczne połączenie !!","ui.app.httpsDescription":"Bez HTTPS twoje poufne dane będą wysyłane bez szyfrowania.","ui.app.httpsLink":"Więcej informacji","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Bezpieczny Tryb włączony !!","ui.app.safeModeDescription":"Niektóre funkcje Contao Manager nie są dostępne.","ui.app.safeModeExit":"Wyłącz Bezpieczny Tryb","ui.app.limitedHeadline":"Zdalne Poświadczenie","ui.app.limitedDescription":"You have limited permissions due to passwordless login.","ui.app.limitedLogout":"Re-authenticate","ui.app.totpHeadline":"Security Notice","ui.app.totpDescription":"Configure two-factor authentication now to secure your account.","ui.app.totpSetup":"Instalacja","ui.app.loading":"Ładowanie Contao Manager …","ui.app.apiError":"Nieoczekiwany status API","ui.app.configSecurity1":"ALERT BEZPIECZEŃSTWA !!! Wykryto niezabezpieczony folder konfiguracji","ui.app.configSecurity2":"Contao Manager wykrył, że pliki konfiguracji są dostępne publicznie. Wszystkie operacje zostały zablokowane do czasu, aż folder zostanie zabezpieczony. W przeciwnym wypadku atakujący mógłby uzyskać dostęp do wrażliwych danych twojej instalacji.\\n\\nAby naprawić ten problem, zabezpiecz dostęp do katalogu \\"contao-manager\\" na serwerze. Jeśli nie wiesz jak to zrobić, odwołaj się dokumentacji twojego serwera lub skontaktuj z dostawcą usług.","ui.account.welcome":"Witaj","ui.account.intro1":"Witaj w Contao Manager, uniwersalnym narzędziu do instalacji i zarządzania Contao Open Source CMS. Jeśli jesteś tu nowy, proszę {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual}, żeby zacząć","ui.account.introManual":"przeczytaj instrukcję","ui.account.intro2":"Jeśli masz jakiekolwiek problemy, sprawdź {ourGithubIssues} i utwórz nowe zgłoszenie na dowolny temat, który nie był jeszcze raportowany.","ui.account.introIssues":"naszą listę problemów na GitHub","ui.account.headline":"Konto użytkownika","ui.account.description":"Aby zarządzać twoją instalacją, utwórz konto w Contao Manager. Uwaga – to konto nie jest powiązane z kontem w backendzie ani frontendzie Contao!","ui.account.username":"Nazwa użytkownika","ui.account.password":"Hasło","ui.account.passwordPlaceholder":"min 8 znaków","ui.account.passwordLength":"Wprowadź przynajmniej 8 znaków.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Utwórz konto","ui.account.usePassword":"Use password for login","ui.account.usePasskey":"Use Passkey for login","ui.account.totpHeadline":"Two-factor authentication","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Configure now","ui.account.totpSkip":"Configure later","ui.account.login":"Decline Invitation","ui.account.contribute1":"Contao i Contao Manager są sponsorowane przez charytatywną organizację Contao Association.","ui.account.contribute2":"Rozważ uczestnictwo w projektach open source poprzez {donate}.","ui.account.contributeDonate":"przekazanie darowizny","ui.login.headline":"Zaloguj się","ui.login.description":"Zaloguj się, aby zarządzać instalacją.","ui.login.username":"Nazwa użytkownika","ui.login.password":"Hasło","ui.login.totpHeadline":"Two-factor authentication","ui.login.totpDescription":"Please enter your verification code to complete the login process.","ui.login.totp":"Verification code","ui.login.forgotPassword":"Zapomniałeś hasła?","ui.login.button":"Zaloguj się","ui.login.passkey":"Sign In with Passkey","ui.login.cancel":"Anuluj","ui.login.or":"lub","ui.login.locked":"Odmówiono dostępu, ponieważ Contao Manager jest zablokowany. Aby odblokować, usuń plik {lockFile} w folderze głównym instalacji Contao.","ui.logout.headline":"Limit czasu sesji","ui.logout.warning":"Byłeś nieaktywny przez więcej niż 25 minut. Z powodu bezpieczeństwa twoja sesja zostanie wkrótce zakończona.","ui.logout.expired":"Twoja sesja została zakończona, ponieważ byłeś nieaktywny przez więcej niż 30 minut.","ui.logout.renew":"Nie wylogowuj się","ui.logout.logout":"Wyloguj","ui.logout.login":"Powrót do logowania","ui.oauth.error":"Nieudana próba OAuth. Sprawdź parametry żądania.","ui.oauth.https":"URI przekierowania MUSI używać bezpiecznego protokołu (https:), aby nie przesyłać tokena poświadczenia otwartym tekstem.","ui.oauth.headline":"Zdalne Poświadczenie","ui.oauth.description":"Następująca aplikacja lub usługa żąda zdalnego dostępu do twojej instancji Contao Manager.","ui.oauth.domain":"Zanim zezwolisz na dostęp, upewnij się, że znasz ten adres URL i ufasz jego właścicielowi!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Zezwól na dostęp","ui.oauth.deny":"Odmów dostępu","ui.oauth.switchUser":"Switch User","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"Sprawdzenie Systemu","ui.boot.description":"Proszę czekać, analizujemy twój serwer …","ui.boot.issue1":"Wykryto nieprawidłowości instalacji","ui.boot.issue2":"Twoja instalacja zawiera błędy, które muszą być rozwiązane, zanim zaczniesz używać Contao Manager.","ui.boot.run":"Otwórz Contao Manager","ui.boot.safeMode":"Uruchom w Bezpiecznym Trybie","ui.recovery.headline":"Odzyskiwanie Systemu","ui.recovery.description":"Contao Manager wykrył pliki, które wyglądają jak z Contao, ale interfejs linii komend (CLI) nie działa tak jak powinien.","ui.recovery.console":"Wyjście Konsolie","ui.recovery.repairOptions":"Wybierz opcję naprawy twojej instalacji.","ui.recovery.repairHeadline":"Automatyczna Naprawa","ui.recovery.repairDescription":"Próba automatycznego naprawienia instalacji poprzez przebudowanie pamięci cache aplikacji i ponownej instalacji pakietów Composera.","ui.recovery.repairWarning":"Jakakolwiek modyfikacja plików vendor może zostać skasowana podczas tego procesu!","ui.recovery.repairFailed":"Automatyczna naprawa nie zakończyła się sukcesem. Spróbuj Bezpiecznego Trybu w celu naprawy instalacji.","ui.recovery.repairButton":"Uruchom naprawę systemu","ui.recovery.safeModeHeadline":"Bezpieczny Tryb","ui.recovery.safeModeDescription":"Uruchamianie Contao Managera w Bezpiecznym Trybie pozwala na zarządzanie pakietami i wykonywanie określonych czynności konserwacyjnych, ale funkcje, które wymagają działającego Contao będą niedostępne.","ui.recovery.safeModeButton":"Uruchom w Bezpiecznym Trybie","ui.server.pending":"Czekam …","ui.server.running":"Analizuję …","ui.server.error":"Sprawdzenie nie powiodło się z powodu niespodziewanej odpowiedzi serwera.","ui.server.details":"Szczegóły","ui.server.prerequisite":"Sprawdzenie anulowane z powodu brakującego warunku wstępnego.","ui.server.selfUpdate.title":"Aktualizacje Contao Managera","ui.server.selfUpdate.update":"Nowa wersja Contao Managera {latest} jest dostępna.","ui.server.selfUpdate.manualUpdate":"Nowa wersja Contao Managera {latest} jest dostępna. Twój serwer nie wspiera automatycznych aktualizacji, nową wersję możesz pobrać z {download}.","ui.server.selfUpdate.latest":"Używasz najnowszej wersji {current}.","ui.server.selfUpdate.dev":"Buildy deweloperskie nie wspierają automatycznych aktualizacji.","ui.server.selfUpdate.unsupported":"Nowa wersja jest dostępna, ale nie wspiera ona twojej wersji PHP.","ui.server.selfUpdate.button":"Uruchom Aktualizację","ui.server.selfUpdate.continue":"Kontynuuj","ui.server.config.title":"Konfiguracja Serwera","ui.server.config.setup":"Konfiguruj","ui.server.config.change":"Zmień","ui.server.config.save":"Zapisz","ui.server.config.cancel":"Anuluj","ui.server.config.customOption":"Inne …","ui.server.config.description":"Aby zadania w tle poprawnie działały, Contao Manager musi wiedzieć, gdzie znaleźć wykonywalny plik PHP linii komend i jak uruchamiać działania niezależnie od procesów serwera www.","ui.server.config.formTitle":"Konfiguracja Serwera","ui.server.config.formText":"Wprowadź ścieżkę do PHP binary. Upewnij się, że wersja PHP binary jest taka sama jak w procesie web.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud pozwala na instalowanie pakietów Composera nawet jeśli twój serwer nie posiada wystarczającej ilości pamięci. Informacja o twoich pakietach będzie przesłana na serwer operowany przez Contao Association.","ui.server.config.cloud":"Użyj Composer Resolver Cloud","ui.server.config.cli":"Plik binarny PHP","ui.server.config.stateErrorCli":"Nie znaleziono poprawnego pliku binarnego PHP na serwerze.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud jest niewspierany.","ui.server.config.stateSuccess":"Plik binarny PHP pod {php_cli}.","ui.server.php_web.title":"PHP Web Process","ui.server.php_web.below7":"Znaleziono wersję PHP {version}. Zaktualizuj ją do PHP 7 tak szybko, jak to możliwe!","ui.server.php_web.success":"Znaleziono wersję PHP {version}, brak nieprawidłowości.","ui.server.php_cli.title":"PHP Command Line Interface","ui.server.php_cli.success":"Znaleziono wersję PHP {version}, brak nieprawidłowości.","ui.server.composer.title":"Środowisko Composera","ui.server.composer.success":"Brak nieprawidłowości.","ui.server.composer.install":"Pakiety Composera nie są zainstalowane.","ui.server.composer.button":"Instalacja","ui.server.contao.title":"Instalacja Contao","ui.server.contao.setup":"Instalacja","ui.server.contao.check":"Sprawdź bazę danych","ui.server.contao.empty":"Nie znaleziono instalacji Contao.","ui.server.contao.old":"Wersja Contao {version} jest niekompatybilna z Contao Manager, aktualizuj swoją instalację ręcznie.","ui.server.contao.found":"Znaleziono Contao {version} (wersja API {api}).","ui.server.contao.connectionError":"Brak połączenia z serwerem bazy danych.","ui.server.contao.connectionProblem":"Problem z bazą danych został znaleziony.","ui.server.contao.missingUser":"Nie znaleziono konta administratora.","ui.setup.continue":"Kontynuuj","ui.setup.manager":"Otwórz Contao Manager","ui.setup.cancel":"Anuluj","ui.setup.welcome":"Witaj","ui.setup.welcome1":"Ten kreator przeprowadzi Cię przez niezbędne kroki, aby skonfigurować instalację Contao Open Source CMS.","ui.setup.welcome2":"Jeśli masz jakieś pytania, odwiedź dokumentację, fora, kanał Slack i więcej na stronie {support}.","ui.setup.support":"wsparcie społeczności","ui.setup.start":"Rozpocznij","ui.setup.complete":"Gratulacje!","ui.setup.complete1":"Contao {version} zostało zainstalowane pomyślnie.","ui.setup.complete2":"Aby zakończyć proces konfiguracji, otwórz narzędzie instalacyjne, aby skonfigurować połączenie z bazą danych i utworzyć użytkownika.","ui.setup.complete3":"Możesz teraz rozpocząć tworzenie swojej strony internetowej w Contao. Jeśli potrzebujesz dodatkowych rozszerzeń, przejdź dalej do Contao Manager.","ui.setup.installTool":"Otwórz instalator","ui.setup.login":"Zaloguj się do Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Dowiedz się więcej","ui.setup.document-root.headline":"Konfiguracja serwera www","ui.setup.document-root.warning":"Aby zainstalować Contao przez Contao Manager, musisz poprawić ustawienie katalogu głównego - document root - w konfiguracji serwera www.","ui.setup.document-root.description1":"Contao używa osobnego folderu dla plików publicznych, a pliki aplikacji są instalowane w folderze nadrzędnym. Contao nie może być zainstalowany, jeśli struktura folderów nie jest poprawna lub foldery nie są puste.","ui.setup.document-root.description2":"Jeśli wiesz, jak skonfigurować katalog główny - document root, zapoznaj się z dokumentacją Contao lub skontaktuj się z administratorem serwera.","ui.setup.document-root.documentation":"Przeczytaj Dokumentację","ui.setup.document-root.conflictsTitle":"Katalog instalacyjny nie jest pusty","ui.setup.document-root.conflictsDirectory":"Katalog główny Twojej przyszłej instalacji Contao nie jest pusty, znaleźliśmy {count} plik(i), które mogą zostać nadpisane przez proces instalacji. Zaleca się utworzenie pustej struktury katalogów dla Contao, ale możesz również usunąć następujące pliki i sprawdzić ponownie, jeśli jesteś pewien, że są one nieużywane.","ui.setup.document-root.ignoreConflicts":"Chcę zainstalować Contao w katalogu, który nie jest pusty. Rozumiem, że może to spowodować nadpisanie wszelkich istniejących plików na mojej przestrzeni dyskowej.","ui.setup.document-root.check":"Sprawdź ponownie","ui.setup.document-root.create":"Utwórz katalogi","ui.setup.document-root.change":"Zmień katalogi","ui.setup.document-root.formTitle":"Konfiguracja Katalogu","ui.setup.document-root.formText1":"Contao Manager może automatycznie utworzyć nową strukturę katalogów na serwerze.","ui.setup.document-root.formText2":"Będziesz musiał ręcznie skonfigurować nowy katalog główny - document root (np. przez panel administracyjny serwera).","ui.setup.document-root.autoconfig":"Rozumiem, że muszę zmienić konfigurację mojego serwera. Niepoprawne ustawienie katalogu głównego może uniemożliwić działanie Contao Manager i uwidocznić publicznie pliki konfiguracyjne (włącznie ze szczegółami konta i hasłami)!","ui.setup.document-root.directory":"Nowy Katalog","ui.setup.document-root.currentRoot":"Aktualny Katalog Główny","ui.setup.document-root.newRoot":"Nowy Katalog Główny","ui.setup.document-root.finish":"Ustawienia Katalogów","ui.setup.document-root.publicDir":"Użyj {dir} dla plików publicznych (dla Contao {version})","ui.setup.document-root.directoryInvalid":"Wprowadź prawidłową nazwę katalogu.","ui.setup.document-root.directoryExists":"Docelowy katalog już istnieje. Podaj inną nazwę.","ui.setup.document-root.confirmation":"Contao Manager utworzył potrzebne katalogi dla twojej instalacji Contao. Teraz powinieneś skonfigurować główny katalog serwera www - document root. Nie przeładowuj wcześniej tej strony.","ui.setup.document-root.reload":"Przeładuj Stronę","ui.setup.document-root.success":"Struktura katalogów na Twoim serwerze jest ustawiona prawidłowo!","ui.setup.document-root.installingProjectDir":"Pliki aplikacji zostaną zainstalowane w {dir}.","ui.setup.document-root.installingPublicDir":"Pliki publiczne zostaną zainstalowane do {dir}.","ui.setup.document-root.installedProjectDir":"Pliki aplikacji są zainstalowane w {dir}.","ui.setup.document-root.installedPublicDir":"Pliki publiczne są instalowane w {dir}.","ui.setup.create-project.headline":"Instalacja Contao","ui.setup.create-project.description":"Rozwój Contao odbywa się zgodnie z zasadą {semver}, co pół roku wydawana jest nowa wersja minor. Obecnie wspierane wydania to:","ui.setup.create-project.semver":"Wersjonowanie semantyczne","ui.setup.create-project.latestTitle":"Najnowsza","ui.setup.create-project.ltsTitle":"Long Term Support","ui.setup.create-project.latestQ1":"Nasza najnowsza wersja, oferuje najwięcej funkcji ze wsparciem do lutego {year}.","ui.setup.create-project.latestQ3":"Nasza najnowsza wersja oferuje najwięcej funkcji z wsparciem do sierpnia {year}.","ui.setup.create-project.ltsText":"Nasza aktualna wersja LTS, jeśli stawiasz na stabilność. Oferuje długoterminowe wsparcie do lutego {year}.","ui.setup.create-project.pltsText":"Poprzednia wersja LTS, nadal posiada długoterminowe wsparcie do lutego {year}.","ui.setup.create-project.requiresPHP":"Wymaga co najmniej PHP {version}, ty masz PHP {current}.","ui.setup.create-project.releaseplan":"Zobacz {contaoReleasePlan}, aby uzyskać szczegółowe informacje.","ui.setup.create-project.releaseplanLink":"Plan Rozwoju Contao","ui.setup.create-project.installed":"Contao {version} zostało pomyślnie zainstalowane na serwerze. Kontynuuj konfigurację bazy danych lub uruchom Contao Manager, aby zainstalować inną wersję.","ui.setup.create-project.formTitle":"Wybierz dystrybucję","ui.setup.create-project.formText":"Wybierz, która wersja ma być zainstalowana.","ui.setup.create-project.version":"Wersja","ui.setup.create-project.demo":"Zainstaluj witrynę demonstracyjną Contao","ui.setup.create-project.demoDescription":"Strona demonstracyjna pomaga Ci zapoznać się z Contao i wszystkimi jego podstawowymi funkcjami. Więcej motywów można znaleźć w {store}.","ui.setup.create-project.coreOnly":"Minimalna Instalacja (tylko Core)","ui.setup.create-project.noUpdate":"Pomiń Instalację (tylko dla ekspertów!)","ui.setup.create-project.theme":"Motyw Contao","ui.setup.create-project.themeInstall":"Aby zainstalować motyw Contao, użyj pola wyszukiwania lub załaduj plik motywu (.cto/.zip), który obsługuje instalację za pośrednictwem menedżera Contao.","ui.setup.create-project.themeBuy":"Upewnij się, że odwiedzisz oficjalny {sklep}.","ui.setup.create-project.themeStore":"Sklep z motywami Contao","ui.setup.create-project.themeUpload":"Prześlij plik motywu (.cto/.zip)","ui.setup.create-project.themeInvalid":"Przesłany plik nie jest motywem Contao lub nie obsługuje Contao Managera.","ui.setup.create-project.themeWarning":"Contao Manager nie może stwierdzić, czy ten motyw jest kompatybilny z Twoim serwerem. Prosimy skontaktować się z dostawcą motywu, jeśli masz jakiekolwiek pytania.","ui.setup.create-project.themeTitle":"Przejrzyj szczegóły motywu","ui.setup.create-project.themeDetails":"Następujące zależności i pliki zostaną zainstalowane wraz z tym motywem.","ui.setup.create-project.themeRequire":"{count} Zależności | {count} Zależności","ui.setup.create-project.themeFiles":"{count} Plik | {count} Pliki","ui.setup.create-project.theme.or":"lub wyszukaj publiczne motywy","ui.setup.create-project.theme.search":"Wyszukiwanie motywów","ui.setup.create-project.theme.more":"Więcej motywów","ui.setup.create-project.theme.empty":"Brak motywów pasujących do {query}","ui.setup.create-project.theme.uploaded":"Plik motywu został pomyślnie przesłany.","ui.setup.create-project.theme.packageName":"Nazwa pakietu","ui.setup.create-project.theme.version":"Wersja","ui.setup.create-project.theme.authors":"Autor(zy)","ui.setup.create-project.theme.upload":"Uploading {name} ({size})","ui.setup.create-project.install":"Instalacja","ui.setup.create-project.cancel":"Anuluj","ui.setup.database-connection.headline":"Połączenie z bazą danych","ui.setup.database-connection.description":"Contao wymaga bazy danych MySQL (lub kompatybilnego forka jak MariaDB) do przechowywania stron, treści, użytkowników i innych danych relacyjnych. Parametry połączenia są przechowywane w pliku {env} w katalogu głównym twojej instalacji Contao.","ui.setup.database-connection.formTitle":"Parametry połączenia","ui.setup.database-connection.formText":"Podaj adres URL bazy danych lub wypełnij osobno pola nazwa użytkownika, hasło, serwer i baza danych.","ui.setup.database-connection.url":"URL bazy danych","ui.setup.database-connection.validUrl":"URL bazy danych jest nieprawidłowy lub połączenie z serwerem nie powiodło się.","ui.setup.database-connection.or":"lub","ui.setup.database-connection.user":"Nazwa użytkownika","ui.setup.database-connection.password":"Hasło","ui.setup.database-connection.server":"Serwer (:Port)","ui.setup.database-connection.database":"Nazwa bazy danych","ui.setup.database-connection.connected":"Pomyślnie połączono z bazą danych {database} na {server}.","ui.setup.database-connection.error":"Błąd połączenia z bazą danych.","ui.setup.database-connection.problem":"Contao wykrył problem z serwerem bazy danych.","ui.setup.database-connection.schemaTitle":"Schemat bazy danych","ui.setup.database-connection.migration":"Jest jedna oczekująca migracja. | Jest {count} oczekujących migracji.","ui.setup.database-connection.schema":"Istnieje jedna oczekująca aktualizacja schematu. | Istnieje {count} oczekujących aktualizacji schematu.","ui.setup.database-connection.noChanges":"Schemat Twojej bazy danych jest aktualny.","ui.setup.database-connection.check":"Sprawdź bazę danych","ui.setup.database-connection.skip":"Pomiń","ui.setup.database-connection.save":"Zapisz","ui.setup.database-connection.change":"Zmień dane dostępowe","ui.setup.database-connection.restoreTitle":"Import bazy danych","ui.setup.database-connection.restoreText":"Temat, który właśnie zainstalowałeś, zawiera kopię zapasową bazy danych. Przywróć bazę danych, aby zaimportować dane motywu, lub pomini ten krok, aby rozpocząć instalację Contao od nowa. | Temat, który właśnie zainstalowałeś, zawiera wiele kopii zapasowych bazy danych. Wybierz plik kopii zapasowej do zaimportowania danych motywu lub pomiń ten krok, aby rozpocząć instalację Contao od nowa.","ui.setup.database-connection.backup":"Zrób kopię zapasową bieżącej bazy danych przed importem","ui.setup.database-connection.backupWarning":"Wszystkie dane w bazie danych zostaną nadpisane podczas importu! Jeśli baza danych nie jest pusta, utwórz najpierw kopię zapasową.","ui.setup.database-connection.restore":"Importuj bazę danych motywu","ui.setup.database-connection.restoreOption":"Kopia zapasowa z {date} ({size})","ui.setup.database-connection.restored":"Twoja baza danych motywu została pomyślnie zaimportowana. Kontynuuj walidację schematu bazy danych.","ui.setup.backend-user.success":"W Twojej bazie danych znaleziono konto administratora Contao. Użyj Contao, aby dodać więcej użytkowników.","ui.setup.backend-user.error":"Nie można pobrać listy użytkowników. Sprawdź wynik konsoli w celu uzyskania szczegółów.","ui.setup.backend-user.headline":"Konto użytkownika","ui.setup.backend-user.description":"Aby zarządzać swoją stroną internetową, musisz mieć co najmniej jedno konto administratora w Contao. Należy pamiętać, że to konto nie jest powiązane z Contao Manager.","ui.setup.backend-user.formTitle":"Utwórz konto","ui.setup.backend-user.formText":"Proszę wprowadzić dane dla nowego konta backend.","ui.setup.backend-user.username":"Nazwa użytkownika","ui.setup.backend-user.name":"Nazwa","ui.setup.backend-user.email":"Adres e-mail","ui.setup.backend-user.emailInvalid":"Wprowadź prawidłowy adres e-mail","ui.setup.backend-user.password":"Hasło","ui.setup.backend-user.passwordPlaceholder":"min 8 znaków","ui.setup.backend-user.passwordLength":"Wprowadź przynajmniej 8 znaków.","ui.setup.backend-user.create":"Dodaj konto","ui.task.headline":"Zadanie w Tle","ui.task.loading":"Ładowanie szczegółów ...","ui.task.created":"Ładowanie szczegółów ...","ui.task.active":"Czekaj, dopóki trwa wykonywanie zadań w tle przez Contao Manager.","ui.task.complete":"Wszystkie operacje wykonane poprawnie. Sprawdź szczegóły w treści konsoli.","ui.task.paused":"Operacja w tle niespodziewanie przestała pracować. Sprawdź szczegóły w konsoli.","ui.task.aborting":"Czekaj, dopóki trwa anulowanie operacji w tle.","ui.task.stopped":"Niektóre operacje w tle zostały anulowane. Zobacz szczegóły w konsoli.","ui.task.error":"Operacja w tle niespodziewanie przestała pracować. Sprawdź szczegóły w konsoli.","ui.task.failed":"Contao Manager nie mógł uruchomić zadania w tle!","ui.task.failedDescription1":"Coś poszło źle podczas próby wykonania operacji w tle.","ui.task.failedDescription2":"Jeśli sytuacja się powtórzy, być może twój serwer nie ma wsparcia.","ui.task.reportProblem":"Zgłoś problem","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud sponsorowane przez {sponsor}","ui.task.buttonAudit":"Aktualizacja Bazy Danych","ui.task.buttonClose":"Zamknij","ui.task.buttonConfirm":"Potwierdź i zamknij","ui.task.buttonContinue":"Kontynuuj","ui.task.buttonCancel":"Anuluj","ui.task.confirmCancel":"Czy na pewno chcesz anulować to zadanie? To może pozostawić twoją instalację w nieznanym stanie.","ui.task.autoclose":"Zamknij szczegóły zadania, gdy udane","ui.console.toggle":"Pokaż/Ukryj Konsolę","ui.console.showLog":"Pokaż pełny dziennik konsoli","ui.console.copyLog":"Skopiuj dziennik do schowka","ui.migrate.headline":"Aktualizacje bazy danych","ui.migrate.migrationsOnly":"(tylko migracje)","ui.migrate.schemaOnly":"(tylko struktura)","ui.migrate.loading":"Proszę czekać, sprawdzamy twoją bazę danych …","ui.migrate.empty":"Nie znaleziono żadnych oczekujących migracji ani aktualizacji schematów. Twoja baza danych jest aktualna.","ui.migrate.emptyMigrations":"Nie znaleziono żadnych oczekujących migracji. Upewnij się, że sprawdziłeś również aktualizacje schematu.","ui.migrate.emptySchema":"Nie znaleziono oczekujących aktualizacji schematu. Upewnij się, że sprawdzisz również migracje.","ui.migrate.pending":"Twoja baza danych nie jest aktualna. Proszę przejrzyj poniższe wyjście konsoli i wykonaj zmiany.","ui.migrate.previousChanges":"Poprzednia migracja bazy danych nie została potwierdzona.\\nProszę przejrzeć poniższe wyniki konsoli, a następnie kontynuować, aby zobaczyć kolejne zmiany.","ui.migrate.previousComplete":"Poprzednia migracja bazy danych nie została potwierdzona, proszę sprawdzić poniższe wyniki konsoli.\\nNie ma więcej oczekujących zmian.","ui.migrate.appliedChanges":"Aktualizacje bazy danych zostały zastosowane.\\nProszę przejrzeć poniższe wyjście konsoli, a następnie kontynuować, aby zobaczyć kolejne zmiany.","ui.migrate.appliedComplete":"Baza danych została zaktualizowana.\\nNie ma więcej oczekujących migracji ani aktualizacji schematu. Twoja baza danych jest aktualna.","ui.migrate.problem":"Contao wykrył problem z serwerem bazy danych.\\nProszę przejrzyj poniżej wynik konsoli, aby dowiedzieć się, co należy naprawić. | Contao wykrył problemy z serwerem bazy danych.\\nProszę przejrzyj poniżej wynik konsoli, aby dowiedzieć się, co należy naprawić.","ui.migrate.warning":"Contao wykrył błędną konfigurację serwera bazy danych.\\nOstrzeżenia można tymczasowo pominąć, ale należy je naprawić dla optymalnej wydajności i integralności danych.","ui.migrate.error":"Zmiany nie mogły zostać zastosowane. Twoja baza danych mogła zostać zmieniona, sprawdź ponownie, aby ponowić próbę.","ui.migrate.execute":"Wykonaj","ui.migrate.close":"Zamknij","ui.migrate.confirm":"Potwierdź i zamknij","ui.migrate.cancel":"Anuluj","ui.migrate.continue":"Kontynuuj","ui.migrate.setup":"Instalacja","ui.migrate.skip":"Pomiń","ui.migrate.retry":"Sprawdź ponownie","ui.migrate.retryAll":"Sprawdź wszystkie","ui.migrate.withDeletes":"Wykonaj wszystkie zmiany w bazie danych, włączając zapytania DROP.","ui.migrate.migrationTitle":"Migracje baz danych","ui.migrate.schemaTitle":"Aktualizacje schematu","ui.migrate.problemTitle":"Problemy z bazą danych","ui.migrate.warningTitle":"Ostrzeżenia bazy danych","ui.migrate.addTable":"Dodaj tabelę {table}","ui.migrate.dropTable":"Usuń tabelę {table}","ui.migrate.addField":"Dodaj pole {table}.{field}","ui.migrate.changeField":"Zmień pole {table}.{field}","ui.migrate.dropField":"Usuń pole {table}.{field}","ui.migrate.createIndex":"Utwórz indeks \\"{name}\\" w {table}","ui.migrate.dropIndex":"Usuń indeks \\"{name}\\" w {table}","ui.widget.mandatory":"To pole nie może być puste.","ui.widget.blankOption":"Proszę wybrać …","ui.widget.showPassword":"Pokaż hasło","ui.widget.hidePassword":"Ukryj hasło","ui.error.title":"Żądanie HTTP dla \\"{method}{url}\\" nie powiodło się.","ui.error.server500":"Wygląda na to, że wystąpił nieoczekiwany błąd na twoim serwerze. Sprawdź dziennik zdarzeń serwera www (Apache/Nginx) oraz dziennik Contao Manager w \\"contao-manager/logs\\".","ui.error.response":"Serwer zwrócił odpowiedź z kodem {status}.","ui.error.moreLink":"Więcej informacji","ui.error.support":"Wsparcie Contao","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Pomoc","ui.footer.reportProblem":"Zgłoś problem","ui.navigation.discover":"Odkrywaj","ui.navigation.packages":"Pakiety","ui.navigation.tools":"Narzędzia","ui.navigation.installTool":"Instalator","ui.navigation.backend":"Contao Backend","ui.navigation.debug":"Contao Tryb Debug","ui.navigation.logViewer":"Czytnik logów","ui.navigation.phpinfo":"Informacja PHP","ui.navigation.phpinfoLoading":"Ładowanie informacji PHP…","ui.navigation.maintenance":"Konserwacja","ui.navigation.rebuildCache":"Przebuduj cache","ui.navigation.users":"Accounts","ui.navigation.systemCheck":"Sprawdzenie Systemu","ui.navigation.advanced":"Zaawansowane","ui.navigation.logout":"Wyloguj","ui.maintenance.database.title":"Bazy danych Migracje i Kopie Zapasowe","ui.maintenance.database.description":"Migracje baz danych zapewniają spójność danych i schematów tabel.","ui.maintenance.database.migrations":"Jedna oczekująca migracja bazy danych | {count} oczekujących migracji bazy danych","ui.maintenance.database.schemaUpdates":"Jedna oczekująca aktualizacja schematu | {count} oczekujące aktualizacje schematu","ui.maintenance.database.error":"Problem z bazą danych został znaleziony.","ui.maintenance.database.warning":"Wykryto ostrzeżenia w bazie danych.","ui.maintenance.database.button":"Sprawdź bazę danych","ui.maintenance.database.migrationOnly":"Sprawdź tylko migracje","ui.maintenance.database.schemaOnly":"Sprawdź tylko strukturę","ui.maintenance.database.installTool":"Otwórz instalator","ui.maintenance.database.createBackup":"Utwórz kopię zapasową","ui.maintenance.database.backupUnsupported":"Kopie zapasowe bazy danych nie są obsługiwane przez Twoją wersję Contao.","ui.maintenance.database.backupList":"Masz jedno kopię zapasową bazy danych, utworzoną {date}. | Masz {count} kopii zapasowych bazy danych, najnowsza została utworzona {date}.","ui.maintenance.database.backupEmpty":"Nie masz obecnie żadnych kopii zapasowych bazy danych.","ui.maintenance.rebuildCache.title":"Cache Aplikacji","ui.maintenance.rebuildCache.description":"Przebudowanie cache\'u aplikacji jest wymagane po jakichkolwiek modyfikacjach plików konfiguracyjnych.","ui.maintenance.rebuildCache.rebuildProd":"Przebuduj Cache Production","ui.maintenance.rebuildCache.rebuildDev":"Przebuduj Cache Development","ui.maintenance.rebuildCache.clearProd":"Wyczyść Cache Production","ui.maintenance.rebuildCache.clearDev":"Wyczyść Cache Development","ui.maintenance.installTool.title":"Instalator Contao","ui.maintenance.installTool.description":"Instalator Contao jest automatycznie blokowany jeśli wprowadzisz błędne hasło trzy razy z rzędu.","ui.maintenance.installTool.unlock":"Odblokuj instalator","ui.maintenance.installTool.lock":"Zablokuj instalator","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"Autoloader Composera jest odpowiedzialny za ładowanie klas PHP. Autoloader musi być odświeżony po dodaniu własnych namespace\'ów do pliku composer.json.","ui.maintenance.dumpAutoload.button":"Odśwież Autoloader","ui.maintenance.composerInstall.title":"Pakiety Composera","ui.maintenance.composerInstall.description":"Zależności Composer\'a są umieszczone w folderze {vendor} w głównym katalogu aplikacji. Przeinstalowanie zależności może być konieczne po zmianach lub ręcznym wgraniu pliku {composerLock}.","ui.maintenance.composerInstall.button":"Uruchom Instalator","ui.maintenance.composerInstall.update":"Uruchom Composer Update","ui.maintenance.composerCache.title":"Cache Composera","ui.maintenance.composerCache.description":"Composer cache\'uje pobrane pakiety w celu lepszej wydajności. Jeśli masz problemy z zepsutymi plikami, spróbuj usunąć cache Composera, aby wymusić nowe pobranie plików.","ui.maintenance.composerCache.button":"Wyczyść Cache","ui.maintenance.maintenanceMode.title":"Tryb konserwacji","ui.maintenance.maintenanceMode.description":"Przełączenie Contao w tryb konserwacji spowoduje wyświetlenie szablonu \\"503 Service Unavailable\\" dla strony internetowej.","ui.maintenance.maintenanceMode.enable":"Włącz","ui.maintenance.maintenanceMode.disable":"Wyłącz","ui.maintenance.debugMode.title":"Tryb Debug","ui.maintenance.debugMode.description":"Aktywuj tryb diagnostyczny podając nazwę użytkownika i hasło do {appDevPhp} punktu dostępowego.","ui.maintenance.debugMode.descriptionJwt":"Aktywuj tryb debug poprzez ustawienie ciasteczka debug dla obecnej domeny.","ui.maintenance.debugMode.activate":"Aktywuj","ui.maintenance.debugMode.deactivate":"Deaktywuj","ui.maintenance.debugMode.credentials":"Uwierzytelnianie","ui.maintenance.debugMode.user":"Proszę wprowadzić nazwę użytkownika dla trybu debug.","ui.maintenance.debugMode.password":"Proszę wprowadzić hasło dla trybu debug.","ui.maintenance.opcodeCache.title":"Cache Opcode","ui.maintenance.opcodeCache.description":"Opcode cache\'uje pliki PHP procesu web w celu szybszego ich wykonywania. Cache musi zostać usunięty w pewnych okolicznościach, jeśli pliki nie są rozpoznawane po ich zmianie.","ui.maintenance.opcodeCache.button":"Wyczyść Cache","ui.maintenance.safeMode":"Niedostępne w Bezpiecznym Trybie","ui.maintenance.unsupported":"Niewspierane przez twoją wersję Contao","ui.packages.updateButton":"Zaktualizuj pakiety","ui.packages.searchButton":"Szukaj Pakietów","ui.packages.searchPlaceholder":"Szukaj pakietów …","ui.packages.uploadOverlay":"Przeciągnij i upuść pliki","ui.packages.uploadButton":"Wgraj pakiety","ui.packages.uploadMessage":"Masz jedną niepotwierdzoną wysyłkę. | Masz {count} niepotwierdzonych wysyłek.","ui.packages.uploadApply":"Potwierdź pliki","ui.packages.uploadReset":"Usuń pliki","ui.packages.uploadIncomplete":"Ten plik nie został wgrany całkowicie. Usuń go i spróbuj ponownie.","ui.packages.uploadDuplicate":"Ten plik wygląda na wgrany kilka razy. Usuń duplikaty.","ui.packages.uploadInstalled":"Ten plik jest już zainstalowany. Usuń duplikaty.","ui.packages.uploadUnsupported":"Przesyłki nie są obsługiwane w Twojej instalacji. Upewnij się, że rozszerzenie PHP ZIP jest zainstalowane i zaktualizuj swoje zależności.","ui.packages.changesMessage":"Masz jedną niepotwierdzoną zmianę. | Masz {count} niepotwierdzonych zmian.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Zapisz zmiany","ui.packages.changesApplyAll":"Zaktualizuj wszystkie pakiety","ui.packages.changesDryrunAll":"Próbnie zaktualizuj wszystkie pakiety","ui.packages.changesReset":"Zresetuj zmiany","ui.packages.changesReview":"Zapisz Zmiany","ui.packagelist.loading":"Ładowanie …","ui.packagelist.uploads":"Wgrane pliki","ui.packagelist.added":"Nowe pakiety","ui.packagelist.installed":"Zainstalowane pakiety","ui.package.hintRevert":"Cofnij zmiany","ui.package.hintNoupdate":"Nie aktualizuj","ui.package.hintConstraint":"Ten pakiet zostanie zainstalowany z wymogiem {constraint} kiedy zapiszesz zmiany.","ui.package.hintConstraintBest":"Ten pakiet zostanie zainstalowany w najlepszej możliwej wersji kiedy zapiszesz zmiany.","ui.package.hintConstraintChange":"Wymóg dla tego pakietu zostanie zmieniony z \\"{from}\\" do \\"{to}\\" kiedy zapiszesz zmiany.","ui.package.hintConstraintUpdate":"Ten pakiet zostanie zaktualizowany, kiedy zapiszesz zmiany.","ui.package.hintAdded":"Ten pakiet zostanie zainstalowana, kiedy zapiszesz zmiany.","ui.package.hintRemoved":"Ten pakiet zostanie usunięty kiedy zapiszesz zmiany.","ui.package.requiredTitle":"dodane ręcznie","ui.package.requiredText":"Ten pakiet jest jako wymagany w pliku composer.json, ale nie jest zainstalowany.","ui.package.removedTitle":"usunięte ręcznie","ui.package.removedText":"Ten pakiet został usunięty z twojego composer.json.","ui.package.installed":"Obecnie zainstalowane:","ui.package.version":"Wersja {version}","ui.package.additionalDownloads":"{count} Pobranie | {count} Pobrania","ui.package.additionalStars":"{count} Gwiazdka | {count} Gwiazdki","ui.package.editConstraint":"Edytuj","ui.package.uploadConstraint":"To ograniczenie zdefiniowane jest przez przesłany pakiet.","ui.package.updateButton":"Aktualizuj","ui.package.removeButton":"Usuń","ui.package.installButton":"Dodaj Pakiet","ui.package.installButtonShort":"Dodaj","ui.package.detailsButton":"Szczegóły","ui.package.latestConstraint":"ostatnia wersja","ui.package.update":"Dostępna aktualizacja","ui.package.updateLatest":"ostatnia wersja","ui.package.updateAvailable":"{version} dostępna","ui.package.updateUnknown":"nieznana wersja","ui.package.updateConstraint":"Dostępna jest nowsza wersja spoza ograniczenia wersji Twojego oprogramowania.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Wersja {version}","ui.cloudStatus.waitingTime":"Czas Oczekiwania","ui.cloudStatus.jobs":"Aktualne Zadania","ui.cloudStatus.workers":"Workers","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"żaden","ui.cloudStatus.short":"ok. {minutes} min","ui.cloudStatus.long":"ok. {minutes} min {seconds} sek","ui.cloudStatus.error":"Nie udało się uzyskać stanu Composer Resolver Cloud. Może być w trakcie serwisowania lub ma awarię.","ui.cloudStatus.button":"Status Chmury","ui.cloudStatus.refresh":"Odśwież Status Chmury","ui.log-viewer.loading":"Ładowanie …","ui.log-viewer.empty":"Nie ma plików dziennika na Twoim serwerze.","ui.log-viewer.reload":"Odśwież","ui.log-viewer.file":"Plik logów","ui.log-viewer.channel":"Kanał","ui.log-viewer.channelTitle":"Kanał, do którego została zapisana ta wiadomość.","ui.log-viewer.level":"Poziom","ui.log-viewer.levelTitle":"Ważność wiadomości log.","ui.log-viewer.timeHeader":"Czas","ui.log-viewer.messageHeader":"Wiadomość","ui.log-viewer.showContext":"Pokaż kontekst","ui.log-viewer.hideContext":"Ukryj kontekst","ui.log-viewer.showExtra":"Pokaż Dodatkowe","ui.log-viewer.hideExtra":"Ukryj Dodatkowe","ui.log-viewer.more":"Wczytaj więcej ...","ui.log-viewer.download":"Pobierz","ui.log-viewer.downloadTitle":"Pobierz plik \\"{file}\\"","ui.log-viewer.prodEnvironment":"Środowisko produkcyjne","ui.log-viewer.devEnvironment":"Środowisko deweloperskie (tryb debugowania)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Change Password","ui.user-manager.setupTotp":"Setup Two-Factor Authentication","ui.user-manager.disableTotp":"Disable Two-Factor Authentication","ui.user-manager.invite":"Invite User","ui.user-manager.delete":"Delete","ui.user-manager.deleteConfirm":"Do you really want to delete user \\"{username}\\"?","ui.user-manager.deleted":"User {username} deleted successfully","ui.user-manager.passwordHeadline":"Change Password","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Current password","ui.user-manager.newPassword":"New password","ui.user-manager.passwordPlaceholder":"min 8 znaków","ui.user-manager.submitPassword":"Submit","ui.user-manager.passwordChanged":"Your password has been changed successfully.","ui.user-manager.passwordError":"This password is incorrect.","ui.user-manager.inviteHeadline":"Invite User","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Create Invitation Link","ui.user-manager.clipboard":"Copy to clipboard","ui.user-manager.permissions":"Learn about permissions","ui.user-manager.cancel":"Anuluj","ui.user-manager.close":"Zamknij","ui.user-manager.you":"You","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Two-Factor Authentication","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verification code","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"The verification code is invalid.","ui.totp.enable":"Włącz","ui.totp.disable":"Wyłącz","ui.totp.cancel":"Anuluj","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Setup Two-Factor Authentication","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[851],{6851:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Connessione non sicura !!","ui.app.httpsDescription":"Senza protocollo HTTPS i tuoi dati riservati saranno trasferiti in chiaro.","ui.app.httpsLink":"Maggiori informazioni","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Safe Mode abilitato!!","ui.app.safeModeDescription":"Alcune funzionalità di Contao Manager non sono disponibili.","ui.app.safeModeExit":"Esci da Safe Mode","ui.app.limitedHeadline":"Autenticazione remota","ui.app.limitedDescription":"You have limited permissions due to passwordless login.","ui.app.limitedLogout":"Re-authenticate","ui.app.totpHeadline":"Security Notice","ui.app.totpDescription":"Configure two-factor authentication now to secure your account.","ui.app.totpSetup":"Setup","ui.app.loading":"Caricamento Contao Manager ....","ui.app.apiError":"Stato API inaspettato","ui.app.configSecurity1":"ALLARME DI SICUREZZA! La cartella di configurazione non è protetta","ui.app.configSecurity2":"Contao Manager ha rilevato che i tuoi file di configurazione sono accessibili al pubblico. Tutte le operazioni sono disabilitate fino a quando la cartella non viene protetta e messa in sicurezza, altrimenti un malintenzionato potrebbe accedere ai dati sensibili della tua installazione.\\n\\nPer risolvere questo problema, assicurati di impedire l\'accesso alla cartella \\"contao-manager\\" sul tuo server. Per sapere come farlo, fai riferimento al manuale del tuo webserver o contatta il tuo fornitore di hosting.","ui.account.welcome":"Benvenuto","ui.account.intro1":"Benvenuto in Contao Manager, uno strumento universale per installare e gestire CMS Open Source di Contao 4. Se sei nuovo, per favore {leggiTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} per iniziare","ui.account.introManual":"leggi il manuale","ui.account.intro2":"In caso di problemi, controlla {ourGithubIssues}. Nel caso sentiti libero di creare un nuovo problema per tutto ciò che non è stato ancora segnalato.","ui.account.introIssues":"segnalazioni in GitHub","ui.account.headline":"Account utente","ui.account.description":"Per gestire l\'installazione, crea un account specifico per Contao Manager. Tieni presente che questo account non è correlato al back end o al front end di Contao.","ui.account.username":"Nome utente","ui.account.password":"Password","ui.account.passwordPlaceholder":"min. 8 caratteri","ui.account.passwordLength":"Inserisci almeno 8 caratteri.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Crea account","ui.account.usePassword":"Use password for login","ui.account.usePasskey":"Use Passkey for login","ui.account.totpHeadline":"Two-factor authentication","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Configure now","ui.account.totpSkip":"Configure later","ui.account.login":"Decline Invitation","ui.account.contribute1":"Contao e il Contao Manager sono sponsorizzati dalla Contao Association senza scopo di lucro.","ui.account.contribute2":"Si prega di considerare di contribuire all\'open source con {donate}.","ui.account.contributeDonate":"Fare una donazione","ui.login.headline":"Registrati","ui.login.description":"Accedi per gestire la tua installazione","ui.login.username":"Nome utente","ui.login.password":"Password","ui.login.totpHeadline":"Two-factor authentication","ui.login.totpDescription":"Please enter your verification code to complete the login process.","ui.login.totp":"Verification code","ui.login.forgotPassword":"Password dimenticata?","ui.login.button":"Registrati","ui.login.passkey":"Sign In with Passkey","ui.login.cancel":"Annulla","ui.login.or":"oppure","ui.login.locked":"L\'accesso è stato negato perché il Contao Manager è bloccato. Per sbloccare, cancella il file {lockFile} nella directory principale di Contao.","ui.logout.headline":"Timeout sessione","ui.logout.warning":"Sei stato inattivo per più di 25 minuti. Per motivi di sicurezza, la sessione verrà chiusa a breve.","ui.logout.expired":"La sessione è stata chiusa automaticamente perché sei stato inattivo per più di 30 minuti.","ui.logout.renew":"Mantieni il login","ui.logout.logout":"Logout","ui.logout.login":"Torna al login","ui.oauth.error":"Tentativo di OAuth non valido. Controllare i parametri della richiesta.","ui.oauth.https":"L\'URI di reindirizzamento DEVE usare un protocollo sicuro (https:) per evitare che il token di autenticazione sia trasmesso in chiaro.","ui.oauth.headline":"Autenticazione remota","ui.oauth.description":"La seguente applicazione o servizio richiede l\'accesso remoto all\'istanza di Contao Manager.","ui.oauth.domain":"Prima di permettere l\'accesso, assicurati di conoscere questo URL e di fidarti del suo proprietario!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Consenti accesso","ui.oauth.deny":"Accesso negato","ui.oauth.switchUser":"Switch User","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"Verifica del sistema","ui.boot.description":"Per favore attendi, stiamo analizzando il tuo server...","ui.boot.issue1":"Problemi di installazione rilevati","ui.boot.issue2":"L\'installazione presenta problemi che devono essere risolti prima di poter utilizzare Contao Manager.","ui.boot.run":"Avvia Contao Manager","ui.boot.safeMode":"Avvio in modalità sicura","ui.recovery.headline":"Sistema di recupero","ui.recovery.description":"Contao Manager ha rilevato file che assomigliano a Contao, ma l\'interfaccia della riga di comando non funziona come previsto.","ui.recovery.console":"Uscita console","ui.recovery.repairOptions":"Scegliere un\'opzione per riparare l\'installazione.","ui.recovery.repairHeadline":"Riparazione automatica","ui.recovery.repairDescription":"Tentativi di riparare automaticamente l\'installazione ricostruendo la cache dell\'applicazione e reinstallando i pacchetti Composer.","ui.recovery.repairWarning":"Qualsiasi modifica ai file del fornitore potrebbe essere cancellata durante il processo!","ui.recovery.repairFailed":"La riparazione automatica non ha avuto successo. Provare la modalità provvisoria per riparare manualmente l\'installazione.","ui.recovery.repairButton":"Esegui la riparazione del sistema","ui.recovery.safeModeHeadline":"Modalità Sicura","ui.recovery.safeModeDescription":"L\'avvio di Contao Manager in modalità provvisoria consente di gestire i pacchetti ed eseguire alcune operazioni di manutenzione, ma le funzioni che si basano su un\'installazione di Contao funzionante non saranno disponibili.","ui.recovery.safeModeButton":"Avvio in modalità sicura","ui.server.pending":"In attesa ...","ui.server.running":"Analizzando ...","ui.server.error":"Verifica non riuscita a causa di una risposta imprevista dal server.","ui.server.details":"Dettagli","ui.server.prerequisite":"Verifica annullata a causa di un prerequisito mancante.","ui.server.selfUpdate.title":"Aggiornamenti di Contao Manager","ui.server.selfUpdate.update":"È disponibile una nuova versione, la {latest} di Contao Manager.","ui.server.selfUpdate.manualUpdate":"È disponibile una nuova versione di Contao Manager {latest}. Il tuo server non supporta gli aggiornamenti automatici, scarica la nuova versione da {download}.","ui.server.selfUpdate.latest":"Stai usando l\'ultima versione disponibile {current}.","ui.server.selfUpdate.dev":"Il build di sviluppo non supportano gli aggiornamenti automatici.","ui.server.selfUpdate.unsupported":"Una nuova versione è disponibile ma non supporta la versione di PHP.","ui.server.selfUpdate.button":"Eseguire l\'auto-aggiornamento","ui.server.selfUpdate.continue":"Continuare","ui.server.config.title":"Configurazione del server","ui.server.config.setup":"Configura","ui.server.config.change":"Cambiamento","ui.server.config.save":"Salva","ui.server.config.cancel":"Annulla","ui.server.config.customOption":"Altri ...","ui.server.config.description":"Per eseguire correttamente le attività in background, Contao Manager deve sapere dove trovare il binario della riga di comando PHP e come eseguire i comandi separati dal processo web.","ui.server.config.formTitle":"Configurazione del server","ui.server.config.formText":"Inserisci il percorso del file binario PHP. Assicurati che il file binario PHP sia la stessa versione del processo del web server.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud consente di installare le dipendenze di Composer anche se il server non fornisce memoria locale sufficiente. Si noti che le informazioni del pacchetto verranno trasmesse a un server cloud gestito dalla Contao Association.","ui.server.config.cloud":"Utilizza Composer Resolver Cloud","ui.server.config.cli":"PHP binario","ui.server.config.stateErrorCli":"Nessun binario PHP valido è stato trovato sul server.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud  non è supportato.","ui.server.config.stateSuccess":"Binario PHP in {php_cli}.","ui.server.php_web.title":"Processo Web PHP","ui.server.php_web.below7":"Trovata la versione di PHP {version}. Si prega di passare a PHP 7 il più presto possibile!","ui.server.php_web.success":"Trovata la versione di PHP {version}, non sono stati trovati problemi noti.","ui.server.php_cli.title":"Interfaccia a riga di comando PHP","ui.server.php_cli.success":"Trovata la versione di PHP {version}, non sono stati trovati problemi noti.","ui.server.composer.title":"Ambiente Composer","ui.server.composer.success":"Non sono stati trovati problemi noti.","ui.server.composer.install":"Le dipendenze del Composer non sono installate.","ui.server.composer.button":"Installa","ui.server.contao.title":"Installazione Contao","ui.server.contao.setup":"Setup","ui.server.contao.check":"Verifica il database","ui.server.contao.empty":"Non è stata trovata alcuna installazione di Contao.","ui.server.contao.old":"La versione {version} di Contao non è compatibile con Contao Manager, aggiorna manualmente l\'installazione.","ui.server.contao.found":"Trovato Contao {version} (versione API {api}).","ui.server.contao.connectionError":"Impossibile connettersi al server del database.","ui.server.contao.connectionProblem":"È stato trovato problema con il database.","ui.server.contao.missingUser":"Account amministratore non trovato.","ui.setup.continue":"Continuare","ui.setup.manager":"Avvia Contao Manager","ui.setup.cancel":"Annulla","ui.setup.welcome":"Benvenuto","ui.setup.welcome1":"Questa procedura guidata ti guiderà attraverso i passaggi necessari per configurare l\'installazione del tuo Contao CMS Open Source.","ui.setup.welcome2":"In caso di domande, puoi consultare la documentazione, forum, un canale Slack e altro nella pagina {support}.","ui.setup.support":"Supporto dalla comunità","ui.setup.start":"Iniziamo","ui.setup.complete":"Congratulazioni!","ui.setup.complete1":"Contao {version} è stato installato correttamente.","ui.setup.complete2":"Per completare il processo d\'installazione, apri lo strumento di installazione per configurare la connessione al database e creare un utente back-end.","ui.setup.complete3":"Ora puoi iniziare a creare il tuo sito web nel back-end di Contao. Se hai bisogno di ulteriori estensioni, vai su Contao Manager.","ui.setup.installTool":"Apri l\'Install Tool","ui.setup.login":"Effettua il login in Contao","ui.setup.funding":"Il software libero è \\"libero\\" come in \\"libertà di parola\\", non come in \\"birra gratis\\". Un progetto Open Source come Contao richiede somme di denaro che non possono essere raccolte da una singola persona o azienda.\\nSe hai un sito web o vendi siti web realizzati con Contao, ci piacerebbe vederti contribuire finanziariamente al prodotto su cui fa affidamento la tua attività.","ui.setup.fundingLink":"Scopri di più","ui.setup.document-root.headline":"Setup Webserver ","ui.setup.document-root.warning":"Per installare Contao tramite Contao Manager, è necessario correggere la document root sul server Web.","ui.setup.document-root.description1":"Contao utilizza una cartella separata per i file pubblici, i file dell\'applicazione vengono installati nella sua cartella principale. Contao non può essere installato se la struttura delle cartelle non è corretta o le cartelle non sono vuote.","ui.setup.document-root.description2":"Se non sai come configurare la document root, leggi la documentazione Contao o contatta il tuo provider di hosting.","ui.setup.document-root.documentation":"Leggi la documentazione","ui.setup.document-root.conflictsTitle":"La directory di installazione non è vuota","ui.setup.document-root.conflictsDirectory":"La directory principale della tua futura installazione di Contao non è vuota, abbiamo trovato {count} files che potrebbero essere sovrascritti dal processo di installazione. Si consiglia di creare una struttura di directory vuota per Contao, ma puoi anche rimuovere i seguenti file e ricontrollare se sei sicuro che non siano utilizzati.","ui.setup.document-root.ignoreConflicts":"Voglio installare Contao nella directory non vuota. Capisco che questo potrebbe sovrascrivere qualsiasi file esistente sul mio spazio web.","ui.setup.document-root.check":"Controlla nuovamente","ui.setup.document-root.create":"Creare elenchi","ui.setup.document-root.change":"Cambia directory","ui.setup.document-root.formTitle":"Setup cartella","ui.setup.document-root.formText1":"Contao Manager può creare automaticamente una nuova struttura di directory sul server.","ui.setup.document-root.formText2":"Dovrai configurare manualmente la nuova root document (ad es. Tramite un pannello di amministrazione di hosting).","ui.setup.document-root.autoconfig":"Comprendo che devo modificare la configurazione del mio server. La mancata configurazione della document root  interromperà Contao Manager ed esporrà i file di configurazione (inclusi i dettagli dell\'account e le password)!","ui.setup.document-root.directory":"Nuova directory","ui.setup.document-root.currentRoot":"Document root corrente","ui.setup.document-root.newRoot":"Nuova document root","ui.setup.document-root.finish":"Cartella di installazione","ui.setup.document-root.publicDir":"Usare {dir} per i file pubblici (per Contao {versione})","ui.setup.document-root.directoryInvalid":"Inserisci un nome di directory valido.","ui.setup.document-root.directoryExists":"La cartella di destinazione esiste già. Per favore, inserisci un nome diverso.","ui.setup.document-root.confirmation":"Contao Manager ha creato correttamente la cartella necessaria per l\'installazione di Contao. Ora devi configurare la radice del documento sul tuo server web. Non ricaricare questa pagina fino ad allora.","ui.setup.document-root.reload":"Ricarica pagina","ui.setup.document-root.success":"La struttura delle directory sul tuo server web è impostata correttamente!","ui.setup.document-root.installingProjectDir":"I file dell\'applicazione verranno installati in {dir}.","ui.setup.document-root.installingPublicDir":"I file pubblici verranno installati in {dir}.","ui.setup.document-root.installedProjectDir":"I file dell\'applicazione vengono installati in {dir}.","ui.setup.document-root.installedPublicDir":"I file pubblici vengono installati in {dir}.","ui.setup.create-project.headline":"Installazione Contao","ui.setup.create-project.description":"Lo sviluppo di Contao segue il principio di {semver}, una nuova versione minore viene rilasciata ogni sei mesi. Le versioni attualmente supportate sono:","ui.setup.create-project.semver":"Versione semantica","ui.setup.create-project.latestTitle":"Più recente","ui.setup.create-project.ltsTitle":"Long Term Support","ui.setup.create-project.latestQ1":"La nostra ultima versione offre la maggior parte delle funzionalità con supporto fino a febbraio {anno}.","ui.setup.create-project.latestQ3":"La nostra ultima versione offre la maggior parte delle funzionalità con supporto fino ad agosto {year}.","ui.setup.create-project.ltsText":"La nostra attuale versione LTS, è focalizzata al mantenimento della stabilità. Offre supporto a lungo termine fino a febbraio {year}.","ui.setup.create-project.pltsText":"La precedente versione LTS ha ancora il supporto a lungo termine fino a febbraio {year}.","ui.setup.create-project.requiresPHP":"Richiede almeno PHP {version}, tu hai PHP {current}.","ui.setup.create-project.releaseplan":"Vedi {contaoReleasePlan} per informazioni dettagliate.","ui.setup.create-project.releaseplanLink":"Piano di rilascio Contao","ui.setup.create-project.installed":"Contao  {version}  è stato installato correttamente sul server. Continua a configurare il tuo database o avvia Contao Manager per installare una versione diversa.","ui.setup.create-project.formTitle":"Seleziona una distribuzione","ui.setup.create-project.formText":"Scegliere quale versione deve essere installata.","ui.setup.create-project.version":"Versione","ui.setup.create-project.demo":"Installa il sito Web demo di Contao","ui.setup.create-project.demoDescription":"Il sito Web demo ti aiuta a familiarizzare con Contao e tutte le sue funzionalità principali. Altri temi possono essere trovati in {store}.","ui.setup.create-project.coreOnly":"Installazione minima (solo core)","ui.setup.create-project.noUpdate":"Salta l\'installazione (soltanto per esperti!)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"Per installare un tema Contao, utilizza l\'input di ricerca o carica un file del tema (.cto/.zip) che supporti l\'installazione tramite Contao Manager.","ui.setup.create-project.themeBuy":"Assicurati di visitare lo {store} ufficiale.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Upload theme file (.cto/.zip)","ui.setup.create-project.themeInvalid":"Il file caricato non è un tema Contao o non supporta Contao Manager.","ui.setup.create-project.themeWarning":"Contao Manager non è in grado di stabilire se questo tema è compatibile con il tuo server. Per eventuali domande, contatta il fornitore del tema.","ui.setup.create-project.themeTitle":"Esamina i dettagli del tema","ui.setup.create-project.themeDetails":"Con questo tema verranno installati le seguenti dipendenze e file.","ui.setup.create-project.themeRequire":"{count} Dipendenze | {count} Dipendenze","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"oppure cerca dei temi pubblici","ui.setup.create-project.theme.search":"Cerca un tema","ui.setup.create-project.theme.more":"Più temi","ui.setup.create-project.theme.empty":"Nessun tema corrispondente {query}","ui.setup.create-project.theme.uploaded":"Il file del tema è stato caricato correttamente.","ui.setup.create-project.theme.packageName":"Nome Package","ui.setup.create-project.theme.version":"Versione","ui.setup.create-project.theme.authors":"Autore/i","ui.setup.create-project.theme.upload":"Uploading {name} ({size})","ui.setup.create-project.install":"Installa","ui.setup.create-project.cancel":"Annulla","ui.setup.database-connection.headline":"Connessione al database","ui.setup.database-connection.description":"Contao richiede un database MySQL (o un fork compatibile come MariaDB) per memorizzare pagine, contenuti, utenti e altri dati relazionali. I parametri di connessione sono memorizzati nel file {env} nella radice del progetto dell\'installazione di Contao.","ui.setup.database-connection.formTitle":"Parametri connessione","ui.setup.database-connection.formText":"Immettere l\'URL di un database o compilare separatamente i campi nome utente, password, server e database.","ui.setup.database-connection.url":"URL Database","ui.setup.database-connection.validUrl":"URL Database non valido o connessione al server fallita.","ui.setup.database-connection.or":"oppure","ui.setup.database-connection.user":"Nome utente","ui.setup.database-connection.password":"Password","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Nome del database","ui.setup.database-connection.connected":"Connessione riuscita al database {database} sul {server}.","ui.setup.database-connection.error":"Errore di connessione al database","ui.setup.database-connection.problem":"Contao ha rilevato un problema con il database server.","ui.setup.database-connection.schemaTitle":"Schema Database ","ui.setup.database-connection.migration":"C\'è una migrazione in sospeso. | Ci sono {count} migrazioni in sospeso.","ui.setup.database-connection.schema":"È presente un aggiornamento dello schema in sospeso. | Ci sono {count} aggiornamenti dello schema in sospeso.","ui.setup.database-connection.noChanges":"Lo schema del database è aggiornato.","ui.setup.database-connection.check":"Verifica il database","ui.setup.database-connection.skip":"Salta","ui.setup.database-connection.save":"Salva","ui.setup.database-connection.change":"Modifica le credenziali","ui.setup.database-connection.restoreTitle":"Importazione del database","ui.setup.database-connection.restoreText":"Il tema che hai appena installato contiene un backup del database. Ripristina il database per importare i dati del tema o salta questo passaggio per iniziare con un\'installazione vuota di Contao. | Il tema che hai appena installato contiene più backup di database. Seleziona un file di backup per importare i dati del tema o salta questo passaggio per iniziare con un\'installazione vuota di Contao.","ui.setup.database-connection.backup":"Eseguire il backup del database corrente prima dell\'importazione","ui.setup.database-connection.backupWarning":"Tutti i dati nel database verranno sovrascritti durante l\'importazione! Creare prima un backup se il database non è vuoto.","ui.setup.database-connection.restore":"Importa il database dei temi","ui.setup.database-connection.restoreOption":"Backup del {date} ({size})","ui.setup.database-connection.restored":"Il database del tuo tema è stato importato con successo. Continua con la convalida dello schema del database.","ui.setup.backend-user.success":"Nel tuo database è stato trovato un account amministratore per il back-end Contao. Usa il back-end Contao per aggiungere più utenti.","ui.setup.backend-user.error":"Impossibile recuperare l\'elenco degli utenti. Controlla l\'output della console per i dettagli.","ui.setup.backend-user.headline":"Utente di backend ","ui.setup.backend-user.description":"Per gestire il tuo sito web, devi avere almeno un account amministratore per il back-end di Contao. Tieni presente che questo account non è correlato a Contao Manager.","ui.setup.backend-user.formTitle":"Crea account","ui.setup.backend-user.formText":"Inserisci i dettagli per il nuovo account back-end.","ui.setup.backend-user.username":"Nome utente","ui.setup.backend-user.name":"Nome","ui.setup.backend-user.email":"Indirizzo e-mail","ui.setup.backend-user.emailInvalid":"Inserisci un indirizzo email valido","ui.setup.backend-user.password":"Password","ui.setup.backend-user.passwordPlaceholder":"min. 8 caratteri","ui.setup.backend-user.passwordLength":"Inserisci almeno 8 caratteri.","ui.setup.backend-user.create":"Aggiungi account","ui.task.headline":"Task in background ","ui.task.loading":"Caricamento dettagli…","ui.task.created":"Caricamento dettagli…","ui.task.active":"Attendere che Contao Manager esegua operazioni in background.","ui.task.complete":"Tutte le operazioni sono state completate correttamente. Controllare l\'output della console per i dettagli.","ui.task.paused":"Un\'operazione in background si è interrotta inaspettatamente. Controlla l\'output della console.","ui.task.aborting":"Attendi mentre le operazioni in background vengono annullate.","ui.task.stopped":"Alcune operazioni in background sono state annullate. Controlla l\'output della console.","ui.task.error":"Un\'operazione in background si è interrotta inaspettatamente. Controlla l\'output della console.","ui.task.failed":"Il Contao Manager non è riuscito ad avviare un\'attività in background!","ui.task.failedDescription1":"Qualcosa è andato storto durante il tentativo di eseguire operazioni in background.","ui.task.failedDescription2":"In questo caso, il tuo server potrebbe non essere supportato.","ui.task.reportProblem":"Segnala un problema","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud sponsorizzato da {sponsor}","ui.task.buttonAudit":"Aggiorna il database","ui.task.buttonClose":"Chiudi","ui.task.buttonConfirm":"Conferma e chiudi","ui.task.buttonContinue":"Continuare","ui.task.buttonCancel":"Annulla","ui.task.confirmCancel":"Sei sicuro di annullare questo compito? Questo potrebbe lasciare l\'installazione di Contao in uno stato danneggiato!","ui.task.autoclose":"Chiudi i dettagli dell\'attività in caso di successo","ui.console.toggle":"Visualizza/nasconde l\'uscita console","ui.console.showLog":"Mostra il registro completo della console","ui.console.copyLog":"Copia il registro negli appunti","ui.migrate.headline":"Aggiornamenti del database","ui.migrate.migrationsOnly":"(solo migrazioni)","ui.migrate.schemaOnly":"(solo schema)","ui.migrate.loading":"Attendi, stiamo controllando il database...","ui.migrate.empty":"Non è stato trovato nessuna migrazione in sospeso o aggiornamento dello schema. Il tuo database è aggiornato.","ui.migrate.emptyMigrations":"Non è stata trovata nessuna migrazione in sospeso. Controlla anche gli aggiornamenti dello schema.","ui.migrate.emptySchema":"Non è stato trovato nessun aggiornamento dello schema in sospeso. Assicurati di controllare anche le migrazioni.","ui.migrate.pending":"Il tuo database non è aggiornato. Si prega di rivedere l\'output della console di seguito ed eseguire le modifiche.","ui.migrate.previousChanges":"Una precedente migrazione del database non è stata confermata.\\nRivedi l\'output della console di seguito, quindi continua per vedere le modifiche successive.","ui.migrate.previousComplete":"Una precedente migrazione del database non è stata confermata, controlla l\'output della console di seguito.\\nNon ci sono più modifiche in sospeso.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Gli aggiornamenti del database sono stati applicati.\\nNon ci sono più migrazioni in sospeso o aggiornamenti dello schema. Il tuo database è aggiornato.","ui.migrate.problem":"Contao ha rilevato un problema con il database server.\\nSi prega di rivedere l\'output della console di seguito per scoprire cosa deve essere risolto. | Contao ha rilevato problemi con il database server.\\nSi prega di rivedere l\'output della console di seguito per scoprire cosa deve essere risolto.","ui.migrate.warning":"Contao ha rilevato una configurazione errata del database server.\\nGli avvisi possono essere ignorati temporaneamente, ma dovrebbero essere corretti per prestazioni e integrità dei dati ottimali.","ui.migrate.error":"Impossibile applicare le modifiche. Il tuo database potrebbe essere stato modificato, controlla di nuovo per riprovare.","ui.migrate.execute":"Esegui","ui.migrate.close":"Chiudi","ui.migrate.confirm":"Conferma e chiudi","ui.migrate.cancel":"Annulla","ui.migrate.continue":"Continuare","ui.migrate.setup":"Setup","ui.migrate.skip":"Salta","ui.migrate.retry":"Controlla nuovamente","ui.migrate.retryAll":"Seleziona tutto","ui.migrate.withDeletes":"Esegui tutte le modifiche al database comprese le query DROP.","ui.migrate.migrationTitle":"Migrazioni del database","ui.migrate.schemaTitle":"Aggiornamenti dello schema","ui.migrate.problemTitle":"Problemi al database","ui.migrate.warningTitle":"Avvisi sul database","ui.migrate.addTable":"Aggiungi tabella {table}","ui.migrate.dropTable":"Drop table {table}","ui.migrate.addField":"Aggiungi campo {table}.{field}","ui.migrate.changeField":"Cambia campo  {table}.{field}","ui.migrate.dropField":"Elimina campo {table}.{field}","ui.migrate.createIndex":"Crea indice \\"{name}\\" in {table}","ui.migrate.dropIndex":"Drop index \\"{name}\\" in {table}","ui.widget.mandatory":"Questo campo non deve essere vuoto.","ui.widget.blankOption":"Selezionare ...","ui.widget.showPassword":"Mostra password","ui.widget.hidePassword":"Nascondi password","ui.error.title":"Richiesta HTTP per \\"{metodo} {url}\\" fallita.","ui.error.server500":"Sembra che si sia verificato un errore imprevisto sul server. Controllare i file di log del proprio server web (Apache/Nginx) e i log di Contao Manager in \\"contao-manager/logs\\".","ui.error.response":"Il server ha restituito una risposta con il codice di stato {status}.","ui.error.moreLink":"Maggiori informazioni","ui.error.support":"Supporto Contao ","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Supporto","ui.footer.reportProblem":"Segnala un problema","ui.navigation.discover":"Scopri","ui.navigation.packages":"Pacchetti","ui.navigation.tools":"Strumenti","ui.navigation.installTool":"Strumento di installazione","ui.navigation.backend":"Contao Backend","ui.navigation.debug":"Modalità Debug Contao","ui.navigation.logViewer":"Log Viewer","ui.navigation.phpinfo":"Informazioni PHP","ui.navigation.phpinfoLoading":"Caricamento informazioni PHP","ui.navigation.maintenance":"Manutenzione","ui.navigation.rebuildCache":"Ricostruisci la cache","ui.navigation.users":"Accounts","ui.navigation.systemCheck":"Verifica del sistema","ui.navigation.advanced":"Avanzato","ui.navigation.logout":"Logout","ui.maintenance.database.title":"Database Migrations e Backups","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"Una migrazione del database in sospeso | {count} migrazioni database in sospeso","ui.maintenance.database.schemaUpdates":"Un aggiornamento dello schema in sospeso | {count} aggiornamenti dello schema in attesa","ui.maintenance.database.error":"È stato trovato problema con il database.","ui.maintenance.database.warning":"Sono stati trovati degli avvisi del database","ui.maintenance.database.button":"Verifica il database","ui.maintenance.database.migrationOnly":"Controlla solo le migrazioni","ui.maintenance.database.schemaOnly":"Controlla solo lo schema","ui.maintenance.database.installTool":"Apri l\'Install Tool","ui.maintenance.database.createBackup":"Creare il backup","ui.maintenance.database.backupUnsupported":"I backup del database non sono supportati dalla tua versione di Contao.","ui.maintenance.database.backupList":"Hai un backup del database, creato il {date}. | Hai {count} backup del database, l\'ultimo è stato creato il {date}.","ui.maintenance.database.backupEmpty":"Al momento non hai backup del database.","ui.maintenance.rebuildCache.title":"Cache applicazione ","ui.maintenance.rebuildCache.description":"La ricostruzione della cache dell\'applicazione è necessaria dopo aver modificato uno qualsiasi dei file di configurazione.","ui.maintenance.rebuildCache.rebuildProd":"Ricostruire la cache di produzione","ui.maintenance.rebuildCache.rebuildDev":"Ricostruire la cache di sviluppo","ui.maintenance.rebuildCache.clearProd":"Cancella cache di produzione","ui.maintenance.rebuildCache.clearDev":"Cancella cache di sviluppo","ui.maintenance.installTool.title":"Contao Install Tool","ui.maintenance.installTool.description":"Lo strumento di installazione Contao viene bloccato automaticamente se si immette una password errata per tre volte di seguito.","ui.maintenance.installTool.unlock":"Sblocca Install Tool","ui.maintenance.installTool.lock":"Blocca Install Tool","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"Il Composer autoloader è responsabile del caricamento della classe PHP. L\'autoloader deve essere scaricato solo dopo aver aggiunto i namespaces personalizzati nella root del composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Dipendenze Composer","ui.maintenance.composerInstall.description":"Le dipendenze del Composer si trovano nella cartella {vendor} nella radice dell\'applicazione. La reinstallazione delle dipendenze può essere necessaria dopo la modifica o il caricamento manuale del file {composerLock}.","ui.maintenance.composerInstall.button":"Esegui Installer","ui.maintenance.composerInstall.update":"Esegui l\'aggiornamento Composer","ui.maintenance.composerCache.title":"Composer Cache","ui.maintenance.composerCache.description":"Composer mette in cache i pacchetti scaricati per migliorare le prestazioni. Se hai problemi con i file rotti, prova a cancellare la cache del Composer per forzare un nuovo download.","ui.maintenance.composerCache.button":"Cancella cache","ui.maintenance.maintenanceMode.title":"Modalità di manutenzione","ui.maintenance.maintenanceMode.description":"Mettendo Contao in modalità manutenzione, verrà visualizzato un modello \\"503 Service Unavailable\\" per il sito web.","ui.maintenance.maintenanceMode.enable":"Attiva","ui.maintenance.maintenanceMode.disable":"Disattiva","ui.maintenance.debugMode.title":"Debug Mode","ui.maintenance.debugMode.description":"Attiva la modalità debug impostando un utente e una password per il punto di ingresso {appDevPhp}.","ui.maintenance.debugMode.descriptionJwt":"Attiva la modalità debug impostando il cookie di debug per il dominio corrente.","ui.maintenance.debugMode.activate":"Attivare","ui.maintenance.debugMode.deactivate":"Disattiva","ui.maintenance.debugMode.credentials":"Credenziali","ui.maintenance.debugMode.user":"Inserisci un nome utente per la modalità di debug.","ui.maintenance.debugMode.password":"Inserisci una password per la modalità di debug.","ui.maintenance.opcodeCache.title":"Cache Opcode","ui.maintenance.opcodeCache.description":"Opcode mette in cache i file PHP sul processo web per un\'esecuzione più veloce. Deve essere cancellato in determinate circostanze se i file non vengono riconosciuti dopo la modifica.","ui.maintenance.opcodeCache.button":"Troncare la cache","ui.maintenance.safeMode":"Non disponibile in modalità Safe Mode","ui.maintenance.unsupported":"Non supportato dalla tua versione di Contao","ui.packages.updateButton":"Aggiorna pacchetti","ui.packages.searchButton":"Cerca pacchetti","ui.packages.searchPlaceholder":"Cerca pacchetti...","ui.packages.uploadOverlay":"Drag & drop files per caricarli","ui.packages.uploadButton":"Carica pacchetti","ui.packages.uploadMessage":"Hai una modifica non confermata. | Hai {count} modifiche non confermate.","ui.packages.uploadApply":"Conferma uploads","ui.packages.uploadReset":"Elimina Uploads","ui.packages.uploadIncomplete":"Questo file non è stato caricato completamente. Rimuovilo e riprova.","ui.packages.uploadDuplicate":"Questo file sembra essere caricato più volte. Rimuovi i duplicati.","ui.packages.uploadInstalled":"Questo file è già installato. Rimuovi i duplicati.","ui.packages.uploadUnsupported":"I caricamenti non sono supportati nella tua installazione. Assicurati che l\'estensione PHP ZIP sia installata e aggiorna le dipendenze.","ui.packages.changesMessage":"Hai una modifica non confermata. | Hai {count} modifiche non confermate.","ui.packages.changesDryrun":"Esecuzione a prova","ui.packages.changesApply":"Applicare le modifiche","ui.packages.changesApplyAll":"Aggiornare tutti i pacchetti","ui.packages.changesDryrunAll":"Esecuzione a prova di tutti i pacchetti","ui.packages.changesReset":"Ripristina modifiche","ui.packages.changesReview":"Revisione dei cambiamenti","ui.packagelist.loading":"Caricamento in corso ...","ui.packagelist.uploads":"Uploads","ui.packagelist.added":"Pacchetti nuovi","ui.packagelist.installed":"Pacchetti installati","ui.package.hintRevert":"Ripristina le modifiche","ui.package.hintNoupdate":"Non aggiornare","ui.package.hintConstraint":"Questo pacchetto sarà installato con vincolo {constraint} quando si applicano le modifiche.","ui.package.hintConstraintBest":"Questo pacchetto sarà installato nella migliore versione disponibile quando si applicano le modifiche.","ui.package.hintConstraintChange":"Il vincolo per questo pacchetto sarà cambiato da \\"{from}\\" a \\"{to}\\" quando si applicano le modifiche.","ui.package.hintConstraintUpdate":"Questo pacchetto sarà aggiornato quando si applicano le modifiche.","ui.package.hintAdded":"Questo pacchetto sarà aggiornato quando si applicano le modifiche.","ui.package.hintRemoved":"Questo pacchetto verrà rimosso quando si applicano le modifiche. ","ui.package.requiredTitle":"aggiunto manualmente","ui.package.requiredText":"Questo pacchetto è richiesto nel tuo composer.json ma non è installato.","ui.package.removedTitle":"rimosso manualmente","ui.package.removedText":"Questo pacchetto è stato rimosso dal tuo composer.json.","ui.package.installed":"Attualmente installato:","ui.package.version":"Versione {version}","ui.package.additionalDownloads":"{count} Download | {count} Downloads","ui.package.additionalStars":"{count} Stella | {count} Stelle","ui.package.editConstraint":"Modifica","ui.package.uploadConstraint":"Questo vincolo è definito dal pacchetto caricato.","ui.package.updateButton":"Aggiorna","ui.package.removeButton":"Rimuovi","ui.package.installButton":"Aggiungi pacchetto","ui.package.installButtonShort":"Aggiungi","ui.package.detailsButton":"Dettagli","ui.package.latestConstraint":"ultima versione","ui.package.update":"Aggiornamento disponibile","ui.package.updateLatest":"ultima versione","ui.package.updateAvailable":"{versione} disponibile","ui.package.updateUnknown":"versione sconosciuta","ui.package.updateConstraint":"È disponibile una versione più recente al di fuori del vincolo di versione.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Versione {version}","ui.cloudStatus.waitingTime":"Tempo di attesa","ui.cloudStatus.jobs":"Lavori correnti","ui.cloudStatus.workers":"Lavoratori","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"nessuna","ui.cloudStatus.short":"circa {minutes} min","ui.cloudStatus.long":"circa {minutes} min {seconds} sec","ui.cloudStatus.error":"Impossibile ottenere lo stato del Composer Resolver Cloud. Potrebbe essere inattivo per problemi di manutenzione o di esercizio.","ui.cloudStatus.button":"Stato Cloud","ui.cloudStatus.refresh":"Aggiorna lo stato del cloud","ui.log-viewer.loading":"Caricamento in corso ...","ui.log-viewer.empty":"Non ci sono file di registro sul tuo server.","ui.log-viewer.reload":"Ricarica","ui.log-viewer.file":"Log file","ui.log-viewer.channel":"Canale","ui.log-viewer.channelTitle":"Il canale su cui è stato registrato questo messaggio.","ui.log-viewer.level":"Livello","ui.log-viewer.levelTitle":"Gravità del messaggio di log.","ui.log-viewer.timeHeader":"Tempo","ui.log-viewer.messageHeader":"Messaggio","ui.log-viewer.showContext":"Mostra contesto","ui.log-viewer.hideContext":"Nascondi contesto","ui.log-viewer.showExtra":"Mostra extra","ui.log-viewer.hideExtra":"Nascondi extra","ui.log-viewer.more":"Carica di più…","ui.log-viewer.download":"Download","ui.log-viewer.downloadTitle":"Download file \\"{file}\\"","ui.log-viewer.prodEnvironment":"Ambiente di produzione","ui.log-viewer.devEnvironment":"Ambiente di sviluppo (Modalità Debug)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Change Password","ui.user-manager.setupTotp":"Setup Two-Factor Authentication","ui.user-manager.disableTotp":"Disable Two-Factor Authentication","ui.user-manager.invite":"Invite User","ui.user-manager.delete":"Delete","ui.user-manager.deleteConfirm":"Do you really want to delete user \\"{username}\\"?","ui.user-manager.deleted":"User {username} deleted successfully","ui.user-manager.passwordHeadline":"Change Password","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Current password","ui.user-manager.newPassword":"New password","ui.user-manager.passwordPlaceholder":"min. 8 caratteri","ui.user-manager.submitPassword":"Submit","ui.user-manager.passwordChanged":"Your password has been changed successfully.","ui.user-manager.passwordError":"This password is incorrect.","ui.user-manager.inviteHeadline":"Invite User","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Create Invitation Link","ui.user-manager.clipboard":"Copy to clipboard","ui.user-manager.permissions":"Learn about permissions","ui.user-manager.cancel":"Annulla","ui.user-manager.close":"Chiudi","ui.user-manager.you":"You","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Two-Factor Authentication","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verification code","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"The verification code is invalid.","ui.totp.enable":"Attiva","ui.totp.disable":"Disattiva","ui.totp.cancel":"Annulla","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Setup Two-Factor Authentication","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[120],{8120:function(e){e.exports=JSON.parse('{"ui.app.title":"Extensions Contao","ui.app.loading":"Chargement de la liste des extensions…","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Publicité dans la liste des extensions","ui.discover.loading":"Chargement…","ui.discover.offline":"Impossible de récupérer des résultats.","ui.discover.offlineExplain":"Vérifiez votre connexion Internet et désactivez les bloqueurs JavaScript dans votre navigateur.","ui.discover.offlineButton":"Réessayer","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"Pas de résultats pour {query}","ui.discover.more":"Plus de résulats","ui.discover.sortBy":"Trier par","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"Mis à jour","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"Téléchargements","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"Note","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"Détails","ui.discover.latestPackages":"Extensions les plus récentes et mises à jour","ui.discover.faversPackages":"Extensions les mieux notées","ui.discover.downloadsPackages":"Extensions les plus téléchargées","ui.discover.exactHit":"Exact query match","ui.discover.results":"More search results","ui.package.homepage":"Site web du projet","ui.package.private":"Package privé","ui.package.privateTitle":"Les packages privés ne sont disponibles que chez le fournisseur (par exemple sous forme de téléchargement ZIP). Veuillez visiter le site Web pour plus d\'informations","ui.package.abandoned":"abandonné","ui.package.abandonedText":"Ce package est abandonné et n\'est plus maintenu.","ui.package.abandonedReplace":"Ce package est abandonné et n\'est plus maintenu. L\'auteur suggère d\'utiliser le package {replacement} à la place.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"Extension précédente","ui.package-details.close":"Fermer les détails","ui.package-details.loading":"Chargement…","ui.package-details.tabDescription":"Description","ui.package-details.tabRequire":"Prérequis","ui.package-details.tabFeatures":"Fonctionnalités","ui.package-details.tabSuggest":"Suggestions","ui.package-details.tabConflict":"Conflits","ui.package-details.tabDependents":"Dépendants","ui.package-details.linkRequires":"nécessite","ui.package-details.linkReplaces":"remplaces","ui.package-details.linkProvides":"fournis","ui.package-details.linkConflicts":"conflits","ui.package-details.funding":"Fund package maintenance!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"Dernière version","ui.package-details.released":"Publié le","ui.package-details.license":"License(s)","ui.package-details.authors":"de","ui.package-details.more":"Plus","ui.package-details.packagist":"Détails du Package","ui.package-details.metadata":"Editer les Metadata","ui.package-details.support_docs":"Documentation","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Support","ui.package-details.support_issues":"Issues / Bug Report","ui.package-details.support_source":"Code source","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Support E-Mail","ui.package-details.support_rss":"RSS Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[540],{4540:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!!  Nezabezpečené připojení !!","ui.app.httpsDescription":"Bez HTTPS budou citlivá data přenášena nezabezpečeně.","ui.app.httpsLink":"Více informací","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Je zapnutý bezpečnostní režim !!","ui.app.safeModeDescription":"Některé funkce nejsou k dispozici ve Správci Contaa.","ui.app.safeModeExit":"Ukončit bezpečnostní režim","ui.app.limitedHeadline":"Smazat autorizaci","ui.app.limitedDescription":"Máte omezená přístupová práva kvůli přihlášení bez hesla.","ui.app.limitedLogout":"Opětovné ověření","ui.app.totpHeadline":"Bezpečnostní poznámka","ui.app.totpDescription":"Nastavte si dvoufaktorové ověření pro vyšší zabezpečení vašeho účtu. ","ui.app.totpSetup":"Nastavení","ui.app.loading":"Nahrávání Správce Contaa","ui.app.apiError":"Nečekaný status API","ui.app.configSecurity1":"BEZPEČNOSTNÍ UPOZORNĚNÍ!!! Byla objevená nechráněná konfigurační složka ","ui.app.configSecurity2":"Správce Contaa zjistil, že jsou veřejně dostupné jeho konfigurační soubory. Všechny operace byly pozastavené, dokud nebude daná složka chráněná, jinak může dojít k útoku na choulostivá data Vaší instalace.\\n\\nPro opravení této potíže zajistěte omezený přístup ke složce \\"contao-manager\\" na Vašem serveru. Jak to lze provést, se dozvíte od Vašeho hostingového poskytovatele nebo v příručce ke správě serveru.","ui.account.welcome":"Vítejte","ui.account.intro1":"Vítejte ve Správci Contaa, univerzálním nástroji k instalaci a správě Contaa Open Source CMS. Pokud jste tu poprvé, přečtěte si prosím návod {readTheManualToGetStarted}.","ui.account.introGetStarted":"Začínáme {readTheManual}.","ui.account.introManual":"přečíst návod","ui.account.intro2":"Pokud si všimnete jakýchkoli nesrovnalostí, podívejte se na seznam nahlášených chyb  {ourGithubIssues}  a případně nahlaste novou, kterou ještě nikdo nenahlásil. ","ui.account.introIssues":"Chyby na GitHubu","ui.account.headline":"Uživatelský účet","ui.account.description":"Abyste mohli spravovat instalaci, vytvořte prosím uživatelský účet. Uvědomte si prosím, že tento účet není stejný pro přihlášení do Contaa. ","ui.account.username":"Uživatelské jméno","ui.account.password":"Heslo","ui.account.passwordPlaceholder":"min. 8 znaků","ui.account.passwordLength":"Zadejte prosím nejméně 8 znaků.","ui.account.loginInvalid":"Došlo k chybě při vytváření účtu. Zkuste jiné úživatelské jméno. ","ui.account.submit":"Vytvořit účet","ui.account.usePassword":"Použít heslo pro příhlášení","ui.account.usePasskey":"Použít passkey pro přihlášení","ui.account.totpHeadline":"Dvoufaktorové ověření","ui.account.totpDescription":"Aktivujte prosím dvoufaktorové ověření, které přidá vašemu uživatelskému účtu další bezpečnostní úroveň. To znamená, že budete muset navíc zadat ověřovací kód generovaný dvoufaktorovými aplikacemi jako 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator nebo jakoukoli jinou  TOTP aplilkací.","ui.account.totpSetup":"Nastavit nyní","ui.account.totpSkip":"Nastavit později","ui.account.login":"Odmítnout pozvání","ui.account.contribute1":"Contao a Správce Contaa je podporovaný neziskovou Contao Association.","ui.account.contribute2":"Prosím zvažte, zda se chcete stát členem a spolupracovníkem tohoto open source projektu {becomingAMember}.","ui.account.contributeDonate":"Staňte se dárcem","ui.login.headline":"Přihlásit se","ui.login.description":"Přihlaste se, abyste mohli spravovat Vaši instalaci.","ui.login.username":"Uživatelské jméno","ui.login.password":"Heslo","ui.login.totpHeadline":"Dvoufaktorové ověření","ui.login.totpDescription":"Zadejte prosím doufaktorový kód, abyste dokončili přihlášení.","ui.login.totp":"Ověřovací kód","ui.login.forgotPassword":"Zapomněli jste heslo?","ui.login.button":"Přihlásit se","ui.login.passkey":"Přihlásit se pomocí passkey","ui.login.cancel":"Zrušit","ui.login.or":"nebo","ui.login.locked":"Přístup byl zamítnut, protože je Správce Contaa uzamčen. Pro odemknutí smažte soubor {lockFile} na Vašem serveru v kořenové složce Contaa.","ui.logout.headline":"Vypršení sezení","ui.logout.warning":"Byli jste neaktivní po dobu 25 minut. Z bezpečnostních důvodů bude Vaše sezení zakrátko ukončené. ","ui.logout.expired":"Vaše sezení bylo automaticky ukončeno, protože jste byli neaktivní více než 30 minut.","ui.logout.renew":"Zůstat přihlášený/á","ui.logout.logout":"Odhlásit","ui.logout.login":"Zpátky k přihlášení","ui.oauth.error":"Neplatný pokus o ověření totožnosti. Zkontrolujte požadované parametry.","ui.oauth.https":"Přeposílací URL musí používat zabezpečený protokol (https), aby nedošlo k přenosu autorizačního kódu v čirém textu.","ui.oauth.headline":"Smazat autorizaci","ui.oauth.description":"Následující aplikace nebo servis požadují vzdálený přístup k Vašemu Správci Contaa. ","ui.oauth.domain":"Ještě než povolíte přístup, ujistěte se, že znáte tuto URL a důvěřujete jejímu majiteli!","ui.oauth.outOfScope":"Bohužel nemáte potřebné přihlašovací práva, abyste se mohl(a) přihlásit.","ui.oauth.allow":"Povolit přístup","ui.oauth.deny":"Odmítnout přístup","ui.oauth.switchUser":"Přejít na jiného uživatele","ui.scope.admin":"Přístup správce včetně správy uživatelů","ui.scope.install":"Nainstalovat nové balíčky a změnit konfiguraci Contaa","ui.scope.update":"Aktualizovat balíčky a provést úkoly údržby","ui.scope.read":"Načíst balíčky a nastavení","ui.boot.headline":"Kontrola systému","ui.boot.description":"Prosím počkejte, analyzujeme Váš server...","ui.boot.issue1":"Byly zjištěny chyby","ui.boot.issue2":"Vaše instalace obsahuje několik chyb a je ji třeba opravit, než se bude moct použít Správce Contaa.","ui.boot.run":"Spustit Správce Contaa","ui.boot.safeMode":"Spustit v Bezpečnostním módu","ui.recovery.headline":"Záchrana systému","ui.recovery.description":"Správce Contaa našel soubory, které vypadají jako soubory Contaa, ale Příkazový řádek nepracuje tak, jak by měl.","ui.recovery.console":"Výstup konzoly","ui.recovery.repairOptions":"Vyberte prosím jednu z možností pro zotavení Vaší instalace.","ui.recovery.repairHeadline":"Automatická oprava","ui.recovery.repairDescription":"Bude provedené automatické opravení instalace tím, že se přestaví meziúložiště a přeinstalují se balíčky závislé na Composeru.","ui.recovery.repairWarning":"Veškeré úpravy provedené na souborech ve složce vendor budou ztraceny!","ui.recovery.repairFailed":"Automatická oprava neproběhla úspěšně. Pro opravení instalace se pokuste se použít Bezpečnostní mód.","ui.recovery.repairButton":"Spustit opravu systému","ui.recovery.safeModeHeadline":"Bezpečnostní mód","ui.recovery.safeModeDescription":"Spuštěním Správce Contaa v Bezpečnostním módu lze spravovat balíčky a spouštět základní příkazy/úlohy, nejsou ovšem dostupné funkce závislé na instalaci Contaa.","ui.recovery.safeModeButton":"Spustit v Bezpečnostním módu","ui.server.pending":"Čekám…","ui.server.running":"Analyzování…","ui.server.error":"Kontrola selhala kvůli neočekávané odezvě ze strany serveru.","ui.server.details":"Podrobnosti","ui.server.prerequisite":"Kontrola zrušena kvůli chybějící podmínce.","ui.server.selfUpdate.title":"Aktualizace Správce Contaa","ui.server.selfUpdate.update":"Je k dispozici nová verze Správce Contaa {latest}.","ui.server.selfUpdate.manualUpdate":"Je dostupná nová verze Správce Contaa {latest}. Váš server nepodporuje automatické instalace. Stáhněte si proto prosím novou verzi {download}.","ui.server.selfUpdate.latest":"Používáte poslední verzi {current}.","ui.server.selfUpdate.dev":"Vývojové verze nepodporují automatické aktualizace.","ui.server.selfUpdate.unsupported":"Je dostupná novější verze, ale ta nepodporuje Vaši verzi PHP.","ui.server.selfUpdate.button":"Spustit automatické aktualizace","ui.server.selfUpdate.continue":"Pokračovat","ui.server.config.title":"Nastavení serveru","ui.server.config.setup":"Nastavit","ui.server.config.change":"Změnit","ui.server.config.save":"Uložit","ui.server.config.cancel":"Zrušit","ui.server.config.customOption":"Jíné…","ui.server.config.description":"Pro správný běh úloh na pozadí potřebuje Správce Contaa vědět, kde může najít binární příkazový řádek PHP a jak spouštět příkazy odděleně od webové stránky. ","ui.server.config.formTitle":"Nastavení serveru","ui.server.config.formText":"Zadejte prosím cestu k binární PHP. Ujistěte se, že je binární soubor stejný jako Vámi používaná verze PHP. ","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud umožňuje nainstalovat na Composeru závislých rozšířeních, i když Váš server nemá dostatek paměti. Mějte na paměti, že informaci o Vaši balíčcích budou odeslané na cloudový server vlastněný Asociací Contaa.","ui.server.config.cloud":"Použít Composer Resolver Cloud","ui.server.config.cli":"Binární PHP","ui.server.config.stateErrorCli":"Na Vašem serveru nebyla nalezena žádná platná binární PHP.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud není podporován.","ui.server.config.stateSuccess":"Binární PHP na {php_cli}.","ui.server.php_web.title":"Webový proces PHP","ui.server.php_web.below7":"Byla nalezena následující verze PHP {version}. Prosím přejděte co nejdříve na PHP 7. ","ui.server.php_web.success":"Byla nalezena následující verze PHP {version}, nejsou známé žádné chyby.","ui.server.php_cli.title":"Rozhraní příkazového řádku PHP","ui.server.php_cli.success":"Byla nalezena následující verze PHP {version}, nejsou známé žádné chyby.","ui.server.composer.title":"Prostředí Composeru","ui.server.composer.success":"Nebyly nalezeny žádné chyby.","ui.server.composer.install":"Věci závislé na Composorovi nejsou nainstalované.","ui.server.composer.button":"Nainstalovat","ui.server.contao.title":"Instalace Contaa","ui.server.contao.setup":"Nastavení","ui.server.contao.check":"Zkontrolovat databázi","ui.server.contao.empty":"Nebyla nalezena žádná instalace Contaa.","ui.server.contao.old":"Verze Contaa {version} není kompatabilní se Správcem Contaa. Zaktualizujte prosím Vaši instalaci manuálně.","ui.server.contao.found":"Nalezeno Contao {version} (verze API {api})","ui.server.contao.connectionError":"Nepodařilo se připojit k serveru databáze.","ui.server.contao.connectionProblem":"Nalezen problém s databází.","ui.server.contao.missingUser":"Nebyl nalezen žádný administrační účet.","ui.setup.continue":"Pokračovat","ui.setup.manager":"Spustit Správce Contaa","ui.setup.cancel":"Zrušit","ui.setup.welcome":"Vítejte","ui.setup.welcome1":"Tento průvodce Vás provede důležitými kroky pro nastavení instalace CMS Contao.","ui.setup.welcome2":"Pokud máte jakýkoli dotaz, prohlédněte si prosím dokumentaci, fóra, kanál Slacku nebo se obraťte na stránku {podpory}.  ","ui.setup.support":"podpora komunity","ui.setup.start":"Začít","ui.setup.complete":"Blahopřejeme!","ui.setup.complete1":"Úspěšně byla nainstalována {version} Contaa.","ui.setup.complete2":"Pro ukončení tohoto procesu otevřete prosím instalační nástroj, abyste nastavili připojení k databázi a vytvořili účet administrátora.","ui.setup.complete3":"Nyní můžete začít vytvářet Vaši webovou stránku v backendu Contaa. Potřebujete-li dodatečná rozšíření, vraťte se do Správce Contaa.","ui.setup.installTool":"Otevřít instalační nástroj","ui.setup.login":"Přihlásit se do Contaa","ui.setup.funding":"Volný software je \\"volný\\" jako \\"volný projev\\", ale ne jako \\"pivo zdarma\\". Open source projekt jako Contaa vyžaduje řadu peněz a nedá se ho uskutečnit bez jediné osoby nebo firmy. \\nPokud máte vytvořenou webovou stránku pomocí Contaa nebo je prodáváte, potěšilo by nás, kdybyste nás finančně podpořili poměrně k Vašemu obchodu.","ui.setup.fundingLink":"Dozvědět se víc","ui.setup.document-root.headline":"Nastavení webového serveru","ui.setup.document-root.warning":"Abyste mohli nainstalovat Contao prostřednictvím Správce Contaa, musíte opravit kořenový dokument na webovém serveru.","ui.setup.document-root.description1":"Contao používá zvláštní složku pro veřejné soubory. Aplikační soubory jsou nainstalované v rodičovské složce. Contao právě nelze nainstalovat, protože Vaše složková struktura není správná nebo složky nejsou prázdné.","ui.setup.document-root.description2":"Pokud nevíte, jak nastavit kořenový dokument, přečtěte si prosím dokumentaci Contaa nebo se obraťte na svého poskytovatele webových služeb.","ui.setup.document-root.documentation":"Přečíst si dokumentaci","ui.setup.document-root.conflictsTitle":"Instalační složka není prázdná","ui.setup.document-root.conflictsDirectory":"Kořenová složka Vaší budoucí instalace Contaa není prázdná. Našli jsem následující počet souborů {count}, které se musí přepsat během instalace. Doporučujeme vytvořit prázdnou složku pro instalaci Contaa, nebo můžete také smazat veškeré věci, které se právě nachází ve vybrané složce, pokud jste si jistí, že je již nepotřebujete. ","ui.setup.document-root.ignoreConflicts":"Chci nainstalova Contao do nevyprázděné složky. Souhlasím s tím, že budou dané soubory přepsány. ","ui.setup.document-root.check":"Znovu zkontrolovat","ui.setup.document-root.create":"Vytvořit složky","ui.setup.document-root.change":"Změnit složky","ui.setup.document-root.formTitle":"Nastavení adresáře","ui.setup.document-root.formText1":"Správce Contaa může automaticky vytvořit novou adresářovou strukturu na tomto webovém serveru.","ui.setup.document-root.formText2":"Budete muset nastavit nový kořenový dokument (např. pomocí správního panelu ve Vašem účtu webových služeb).","ui.setup.document-root.autoconfig":"Rozumím tomu, že musím změnit nastavení serveru. Pokud se tak nestane, může dojít k poruše Správce Contaa a poničení souborů nastavení (včetně podrobností k účtu a heslu)!","ui.setup.document-root.directory":"Nový adresář","ui.setup.document-root.currentRoot":"Současný kořenový dokument","ui.setup.document-root.newRoot":"Nový kořenový dokument","ui.setup.document-root.finish":"Nastavení adresářů","ui.setup.document-root.publicDir":"Použijte {dir} pro veřejné soubory (pro Contao {version})","ui.setup.document-root.directoryInvalid":"Zadejte prosím platný název adresáře","ui.setup.document-root.directoryExists":"Cílový adresář již existuje. Zadejte prosím jiný název.","ui.setup.document-root.confirmation":"Správce Contaa úspěšně vytvořil potřebný adresář pro instalaci Contaa. Nyní musíte nastavit kořenový dokument na svém webovém serveru. Nenačítejte tuto stránku do té doby.","ui.setup.document-root.reload":"Načíst stránku znovu","ui.setup.document-root.success":"Struktura složek je nastavená na Vašem serveru správně!","ui.setup.document-root.installingProjectDir":"Aplikační soubory se nainstalují do {dir}.","ui.setup.document-root.installingPublicDir":"Veřejné soubory se nainstalují do {dir}.","ui.setup.document-root.installedProjectDir":"Aplikační soubory jsou nainstalované v {dir}.","ui.setup.document-root.installedPublicDir":"Veřejné soubory jsou nainstalované v {dir}.","ui.setup.create-project.headline":"Instalace Contaa","ui.setup.create-project.description":"Vývoj Contaa se drží principů {semver}, nová menší verze vychází každých šest měsíců. Současná verze, která se udržuje, je:","ui.setup.create-project.semver":"Sémantické číslování verzí","ui.setup.create-project.latestTitle":"Poslední","ui.setup.create-project.ltsTitle":"Několikaletá podpora - Long Term Support","ui.setup.create-project.latestQ1":"Naše poslední verze nabízí nejnovější funkce s podporou do února {year}.","ui.setup.create-project.latestQ3":"Naše poslední verze nabízí nejnovější funkce s podporou do srpna {year}.","ui.setup.create-project.ltsText":"Naše současná verze LTS, chcete-li se zaměřit na stabilitu. Nabízí dlouhodobou podporu do února {year}.","ui.setup.create-project.pltsText":"Naše předešlá verze LTS má podporu do února {year}.","ui.setup.create-project.requiresPHP":"Vyžaduje přinejmenším PHP {version}, používáte PHP {current}.","ui.setup.create-project.releaseplan":"Více informací: {contaoReleasePlan} ","ui.setup.create-project.releaseplanLink":"Plán vydávání nových verzí Contaa","ui.setup.create-project.installed":"Contao {version} je úspěšně nainstalována na vašem serveru. Pokračujte, abyste nastavili vaši databázi nebo spustili Správce Contaa pro nainstalování jiné verze.","ui.setup.create-project.formTitle":"Vyberte distribuci","ui.setup.create-project.formText":"Vyberte prosím verzi, kterou chcete nainstalovat.","ui.setup.create-project.version":"Verze","ui.setup.create-project.demo":"Nainstalovat demoverzi Contaa","ui.setup.create-project.demoDescription":"Demoverze vám pomůže se seznámit s Contaa a pochopit jeho základní fukce. Více předloh můžete najít v {store}.","ui.setup.create-project.coreOnly":"Minimální instalace (pouze jádro)","ui.setup.create-project.noUpdate":"Přeskočit instalaci (pouze pro pokročilé!)","ui.setup.create-project.theme":"Předloha Contaa","ui.setup.create-project.themeInstall":"Abyste nainstalovali předlohu Contaa, použijte vyhledávací políčko nebo načtete soubor (.cto/.zip), který podporuje instalace pomocí Správce Contaa.","ui.setup.create-project.themeBuy":"Podívejte se na další předlohy v obchodě {store}.","ui.setup.create-project.themeStore":"Obchod předloh Contaa","ui.setup.create-project.themeUpload":"Načíst soubor předlohy (.cto/.zip)","ui.setup.create-project.themeInvalid":"Načtený soubor není předloha Contaa nebo ho Správce Contaa nepodporuje.","ui.setup.create-project.themeWarning":"Správce Contaa nemůže říct, jestli je tato předloha kompatibilní s vaším serverem. Podívejte se prosím na informace předlohy pro získání dalších informací.","ui.setup.create-project.themeTitle":"Podívat se na hodnocení předlohy","ui.setup.create-project.themeDetails":"Následující závislosti a soubory se nainstalují spolu s vybranou předlohou.","ui.setup.create-project.themeRequire":"{count} závilostí | {count} závislostí","ui.setup.create-project.themeFiles":"{count} soubor | {count} souborů","ui.setup.create-project.theme.or":"nebo prohledejte veřejně dostupné předlohy","ui.setup.create-project.theme.search":"Prohledat předlohy","ui.setup.create-project.theme.more":"Více předloh","ui.setup.create-project.theme.empty":"Nenalezeny žádné předlohy pro {query}","ui.setup.create-project.theme.uploaded":"Soubory předlohy byly úspěšně nahrány.","ui.setup.create-project.theme.packageName":"Název balíčku","ui.setup.create-project.theme.version":"Verze","ui.setup.create-project.theme.authors":"Autor/Autoři","ui.setup.create-project.theme.upload":"Uploading {name} ({size})","ui.setup.create-project.install":"Nainstalovat","ui.setup.create-project.cancel":"Zrušit","ui.setup.database-connection.headline":"Připojení k databázi","ui.setup.database-connection.description":"Contao vyžaduje přinejmenším jednu databázi MySQL (nebo kompatibilní druh jako MariaDB) pro ukládání stránek, obsahu, uživatelů a příslušných dat. Přihlašovací údaje jsou uložené v souboru {env} v kořenové složce instalace Contaa.","ui.setup.database-connection.formTitle":"Připojovací údaje","ui.setup.database-connection.formText":"Zadejte prosím cestu k databázi nebo vyplňte zvlášť uživatelské jméno, heslo, server a pole databáze.","ui.setup.database-connection.url":"Cesta k databázi","ui.setup.database-connection.validUrl":"Cesta k databázi je neplatná nebo selhalo spojit se se serverem.","ui.setup.database-connection.or":"nebo","ui.setup.database-connection.user":"Uživatelské jméno","ui.setup.database-connection.password":"Heslo","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Jméno databáze","ui.setup.database-connection.connected":"Došlo k úspěšnému připojení k {database} na {server}.","ui.setup.database-connection.error":"Při připojení k databázi došlo k chybě.","ui.setup.database-connection.problem":"Contao zjistil problém s Vaší serverovou databází.","ui.setup.database-connection.schemaTitle":"Databázové schéma","ui.setup.database-connection.migration":"Existuje jedna nedokončená migrace. | Existují následující nedokončené migrace: {count}.","ui.setup.database-connection.schema":"Existuje jedna nedokončená schematická aktualizace. | Existují následující nedokončené schematické aktualizace: {count}.","ui.setup.database-connection.noChanges":"Vaše databáze je aktuální. ","ui.setup.database-connection.check":"Zkontrolovat databázi","ui.setup.database-connection.skip":"Přeskočit","ui.setup.database-connection.save":"Uložit","ui.setup.database-connection.change":"Změnit pověření","ui.setup.database-connection.restoreTitle":"Import databáze","ui.setup.database-connection.restoreText":"Předlohu, kterou jste právě nainstalovali, obsahuje již připravenou databázi s definovaným obsahem. Pokud ji chcete nahrát a začít tak používat Contao s již definovaným obsahem, nahrajte danou databázi, nebo přeskočte tento krok. |  Předlohu, kterou jste právě nainstalovali, obsahuje několik připravených databází s již definovaným obsahem. Pokud je chcete nahrát a začít tak používat Contao s již definovaným obsahem, nahrajte dané databázi, nebo přeskočte tento krok","ui.setup.database-connection.backup":"Uložit současnou databázi před importem.","ui.setup.database-connection.backupWarning":"Veškerá data budou v databázi přepsána! Ponejprv si uložte současnou databázi, pokud již není prázdná.","ui.setup.database-connection.restore":"Importovat předlohu databáze","ui.setup.database-connection.restoreOption":"Uložená databáze {date} ({size})","ui.setup.database-connection.restored":"Vaše databáze byla úspěšně importovaná. Pokračujte prosím, abyste provedli aktualizaci schématu databáze.","ui.setup.backend-user.success":"Ve vaší databázi byl nalezen jeden administrátorský účet pro backend Contaa. Pokud si přejete přidat další účty, přihlašte se do backendu Contaa a vytvořte je v sekci Uživatelé.","ui.setup.backend-user.error":"Nebylo možné najít jakýkoli seznam uživatelů. Zkontrolujete prosím výstup příkazového řádku.","ui.setup.backend-user.headline":"Účet backendu","ui.setup.backend-user.description":"Abyste mohli spravovat Vaši webovou stránku, musíte vytvořit alespoň jeden administrativní účet. Uvědomte si prosím, že tento účet není stejný pro přihlášení do Správce Contaa. ","ui.setup.backend-user.formTitle":"Vytvořit účet","ui.setup.backend-user.formText":"Zadejte prosím údaje pro nový účet backendu.","ui.setup.backend-user.username":"Uživatelské jméno","ui.setup.backend-user.name":"Jméno","ui.setup.backend-user.email":"Mailová adresa","ui.setup.backend-user.emailInvalid":"Zadejte prosím platnou mailovou adresu","ui.setup.backend-user.password":"Heslo","ui.setup.backend-user.passwordPlaceholder":"min. 8 znaků","ui.setup.backend-user.passwordLength":"Zadejte prosím nejméně 8 znaků.","ui.setup.backend-user.create":"Přidat účet","ui.task.headline":"Úloha na pozadí","ui.task.loading":"Načítání podrobností...","ui.task.created":"Načítání podrobností...","ui.task.active":"Počkejte prosím, zatímco Spráce Contaa na pozadí vyřizuje operační úlohy.","ui.task.complete":"Všechny operace byly úspěšně provedené. Další podrobnosti získáte v protokolu konzoly.","ui.task.paused":"Příkaz na pozadí byl znenadání zastaven. Zkontrolujte prosím protokol konzoly.","ui.task.aborting":"Počkejte prosím, zatímco se na pozadí zastavují operace.","ui.task.stopped":"Některé z operačních úloh byly zrušené. Zkontrolujte prosím protokol konzoly.","ui.task.error":"Příkaz na pozadí byl znenadání zastaven. Zkontrolujte prosím protokol konzoly.","ui.task.failed":"Správci Contaa se nepodařilo spustit úlohu!","ui.task.failedDescription1":"Něco se pokazilo, zatímco probíhaly úlohy na pozadí.","ui.task.failedDescription2":"Pokud se to bude opakovat, nejspíš není Váš server podporovaný.","ui.task.reportProblem":"Oznámit problém","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Cloud Composeru spozorován: {sponsor}","ui.task.buttonAudit":"Zaktualizovat dabázi","ui.task.buttonClose":"Zavřít","ui.task.buttonConfirm":"Potvrdit a zavřít","ui.task.buttonContinue":"Pokračovat","ui.task.buttonCancel":"Zrušit","ui.task.confirmCancel":"Jste si jistí, že chcete zrušit tuto úlohu? To může zanechat instalaci Contaa v špatném stavu!","ui.task.autoclose":"Zavřít podrobnosti o úloze po úspěšném dokončení","ui.console.toggle":"Zobrazit/skrýt výstup příkazového řádku","ui.console.showLog":"Zobrazit celý protokol konzoly","ui.console.copyLog":"Zkopírovat protokol do schránky.","ui.migrate.headline":"Aktualizace databáze","ui.migrate.migrationsOnly":"(pouze migrace)","ui.migrate.schemaOnly":"(pouze schémata)","ui.migrate.loading":"Prosím počkejte, analyzujeme Vaši databázi...","ui.migrate.empty":"Nebyl nalezené žádné aktualizace pro migraci nebo schémata. Vaši databáze je aktuální.","ui.migrate.emptyMigrations":"Nebyla nalezené žádné nedokončené migrace. Ujistěte se prosím, zda není potřeba také zaktualizovat schémata.","ui.migrate.emptySchema":"Nebyla nalezené žádné nedokončené schémata. Ujistěte se prosím, zda není potřeba také zaktualizovat migrace.","ui.migrate.pending":"Vaše databáze není aktuální. Prohlídněte si prosím níže konzolu a zaktualizujte Vaši databázi.","ui.migrate.previousChanges":"Předešlá migrace nebyla potvrzená.\\nProhlédněte si prosím níže výsledky v konzole a pak proveďte potřebné změny.","ui.migrate.previousComplete":"Předešlá migrace nebyla potvrzená. Prohlédněte si prosím níže výsledky v konzole.\\nExistuje několik nedokončených změn.","ui.migrate.appliedChanges":"Databáze byla zaktualizovaná. \\nProhlédněte si prosím níže výsledky v konzole, pak pokračujte dalšími kroky, abyste provedli další změny. ","ui.migrate.appliedComplete":"Databáze byla zaktualizovaná. \\nNeexistují žádné další nedokončené migrace nebo schémata. Vaše databáze je aktuální. ","ui.migrate.problem":"Contao zjistil problém s Vaším databázovým serverem. \\nProhlédněte si prosím níže výsledky v konzole, abyste se dozvěděli více o tom, co je potřeba opravit.  | Contao zjistil problém s Vaším databázovým serverem. \\nProhlédněte si prosím níže výsledky v konzole, abyste se dozvěděli více o tom, co je potřeba opravit. ","ui.migrate.warning":"Contao zjistil nesprávné nastavení Vašeho databázového serveru. \\nVarování lze dočasně přeskočit, měly by se ale opravit, aby docházelo k dobrému výkonu a zacházení s daty. ","ui.migrate.error":"Změny nelze provést. Vaše databáze se možná změnila. Zkontrolujte to prosím ještě jednou a proveďte daný krok ještě jednou.","ui.migrate.execute":"Provést","ui.migrate.close":"Zavřít","ui.migrate.confirm":"Potvrdit a zavřít","ui.migrate.cancel":"Zrušit","ui.migrate.continue":"Pokračovat","ui.migrate.setup":"Nastavení","ui.migrate.skip":"Přeskočit","ui.migrate.retry":"Znovu zkontrolovat","ui.migrate.retryAll":"Vybrat vše","ui.migrate.withDeletes":"Provést všechny změny databáze včetně příkazu ke smazání. ","ui.migrate.migrationTitle":"Migrace databáze","ui.migrate.schemaTitle":"Schématická aktualizace","ui.migrate.problemTitle":"Problémy databáze","ui.migrate.warningTitle":"Varování databáze","ui.migrate.addTable":"Přidat tabulku {table}","ui.migrate.dropTable":"Odstranit tabulku {table}","ui.migrate.addField":"Přidat pole {table}. {field}","ui.migrate.changeField":"Změnit pole {table}.{field}","ui.migrate.dropField":"Odstranit pole {table}.{field}","ui.migrate.createIndex":"Vytvořit index \\"{name}\\" v {table}","ui.migrate.dropIndex":"Odstranit index \\"{name}\\" v {table}","ui.widget.mandatory":"Toto pole nesmí být prázdné.","ui.widget.blankOption":"Vyberte prosím…","ui.widget.showPassword":"Zobrazit heslo","ui.widget.hidePassword":"Skrýt heslo","ui.error.title":"Požadavek HTTP pro \\"{method} {url}\\" selhal.","ui.error.server500":"Vypadá to, že došlo k nečekané chybě na Vašem webovém serveru. Zkontrolujte prosím protokolové soubory na serveru (Apache/Nginx) a protokol Správce Contaa v \\"contao-manager/logs\\".","ui.error.response":"Server odpověděl statusovým kódem {status}.","ui.error.moreLink":"Více informací","ui.error.support":"Podpora Contaa","ui.error.permission":"Nemáte povolení pro použití této funkce.","ui.footer.help":"Nápověda","ui.footer.reportProblem":"Oznámit problém","ui.navigation.discover":"Prohlédnout","ui.navigation.packages":"Balíčky","ui.navigation.tools":"Nástroje","ui.navigation.installTool":"Instalační nástroj","ui.navigation.backend":"Backend Contaa","ui.navigation.debug":"Debugový mód Contaa","ui.navigation.logViewer":"Prohlížeč protokolu","ui.navigation.phpinfo":"Informace o PHP","ui.navigation.phpinfoLoading":"Načítání informací o PHP…","ui.navigation.maintenance":"Údržba","ui.navigation.rebuildCache":"Přetvoření meziúložiště","ui.navigation.users":"Účty","ui.navigation.systemCheck":"Kontrola systému","ui.navigation.advanced":"Rozšířené","ui.navigation.logout":"Odhlásit","ui.maintenance.database.title":"Migrace databáze","ui.maintenance.database.description":"Migrace databáze zajišťuje konzistentní data a tabulková schémata.","ui.maintenance.database.migrations":"Jedna nedokončená migrace databáze | Počet nedokončených migrací databáze {count} ","ui.maintenance.database.schemaUpdates":"Jedna nedokončená schématická aktualizace | Počet nedokončených schematických aktualizací {count} ","ui.maintenance.database.error":"Nalezen problém s databází.","ui.maintenance.database.warning":"Byly nalezená varování databáze.","ui.maintenance.database.button":"Zkontrolovat databázi","ui.maintenance.database.migrationOnly":"Vybrat pouze migrace","ui.maintenance.database.schemaOnly":"Vybrat pouze schémata","ui.maintenance.database.installTool":"Otevřít instalační nástroj","ui.maintenance.database.createBackup":"Vytvořit uložení databáze","ui.maintenance.database.backupUnsupported":"Ukládání databází není vaší verzí Contaa podporováno.","ui.maintenance.database.backupList":"Máte pouze jednou uloženou vaší databázi, a sice {date}. | Počet uložených databází {count}. Naposledy byla uložená {date}.","ui.maintenance.database.backupEmpty":"Momentálně nemáte žádné uložené databáze.","ui.maintenance.rebuildCache.title":"Meziúložiště aplikace","ui.maintenance.rebuildCache.description":"Přetvoření meziúložiště aplikace je nutné provést po každé změně konfiguračních souborů. ","ui.maintenance.rebuildCache.rebuildProd":"Přetvořit produktivní meziúložiště ","ui.maintenance.rebuildCache.rebuildDev":"Přetvořit vývojářské meziúložiště ","ui.maintenance.rebuildCache.clearProd":"Vyprázdnit produktivní meziúložiště ","ui.maintenance.rebuildCache.clearDev":"Vyprázdnit vývojářské meziúložiště ","ui.maintenance.installTool.title":"Instalační nástroj Contaa","ui.maintenance.installTool.description":"Instalační nástroj Contaa se automaticky uzamkne, pokud nesprávně zadáte heslo třikrát po sobě. ","ui.maintenance.installTool.unlock":"Odemknout Instalační nástroj","ui.maintenance.installTool.lock":"Uzamknout Instalační nástroj","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"Composer autoloader je zodpovědný za načítání tříd PHP. Autoloader musí být spuštěný po přidání vlastních namespace do kořenové composer.json.","ui.maintenance.dumpAutoload.button":"Spustit Autoloadera","ui.maintenance.composerInstall.title":"Na Compseru závislá rozšíření","ui.maintenance.composerInstall.description":"Na Composeru závislá rozšíření se nachází ve složce {vendor} Vaší instalace. Přeinstalování těchto závislostí může být důležité po manipulaci nebo manuálnímu přenosu souboru {composerLock}.","ui.maintenance.composerInstall.button":"Spustit instalátor","ui.maintenance.composerInstall.update":"Spustit aktualizaci Composeru","ui.maintenance.composerCache.title":"Meziúložiště Composeru","ui.maintenance.composerCache.description":"Meziúložiště Composeru stáhla balíčky, aby zlepšily výkonost. Pokud máte potíže jako poničené soubory, pokuste se smazat meziúložiště Composeru, abyste vyvolali nové stáhnutí. ","ui.maintenance.composerCache.button":"Smazat meziúložiště","ui.maintenance.maintenanceMode.title":"Mód údržby","ui.maintenance.maintenanceMode.description":"Když se spustí mód údržby, zobrazí se předloha pro \\"503 service Unavailable\\".","ui.maintenance.maintenanceMode.enable":"Aktivovat","ui.maintenance.maintenanceMode.disable":"Deaktivovat","ui.maintenance.debugMode.title":"Vývojářský mód","ui.maintenance.debugMode.description":"Aktivujte vývojářský mód zadáním uživatele a hesla pro {appDevPhp}.","ui.maintenance.debugMode.descriptionJwt":"Aktivujte vývojářský mód nastavením vývojářské cookie pro danou doménu.","ui.maintenance.debugMode.activate":"Aktivovat","ui.maintenance.debugMode.deactivate":"Deaktivovat","ui.maintenance.debugMode.credentials":"Uživatelské informace","ui.maintenance.debugMode.user":"Zadejte prosím uživatelské jméno pro vývojářský mód.","ui.maintenance.debugMode.password":"Zadejte prosím heslo pro uživatele vývojářského módu.","ui.maintenance.opcodeCache.title":"Operační kód mezinúložiště","ui.maintenance.opcodeCache.description":"Operační kód meziúložiště souborů PHP dokáže rychleji zpracovat data. Musí být smazán za určitých podmínek, pokud se nepodařilo rozpoznat soubory po jejich změně.","ui.maintenance.opcodeCache.button":"Zkrátit meziúložiště","ui.maintenance.safeMode":"Není to dostupné v Bezpečnostním módu","ui.maintenance.unsupported":"Nepodporované Vaší verzí Contaa. ","ui.packages.updateButton":"Zaktualizovat balíčky","ui.packages.searchButton":"Vyhledat balíčky","ui.packages.searchPlaceholder":"Hledají se balíčky…","ui.packages.uploadOverlay":"Přetáhněte a pusťte soubory, které chcete nahrát","ui.packages.uploadButton":"Nahrát balíčky","ui.packages.uploadMessage":"Máte jeden nepotvrzený přenos. | Máte celkem {count} nepotvrzených přenosů.","ui.packages.uploadApply":"Potvrdit nahrání","ui.packages.uploadReset":"Smazat nahráné soubory","ui.packages.uploadIncomplete":"Tyto soubory nebyly zcela nahrány. Smažte je prosím a zkuste to znovu.","ui.packages.uploadDuplicate":"Zdá se, že byly tyto soubory nahrány několikrát. Smažte prosím dané duplikáty.","ui.packages.uploadInstalled":"Tento soubor je již nainstalovaný. Smažte prosím daný duplikát.","ui.packages.uploadUnsupported":"Nahrávání souborů není ve Vaší instalaci podporováno. Ujistěte se prosím, zda je funkce PHP ZIP nainstalovaná a zaktualizujte veškeré závislosti.","ui.packages.changesMessage":"Máte jednu nepotvrzenou změnu. | Máte celkem {count} nepotvrzených změn.","ui.packages.changesDryrun":"Zkouška nanečisto","ui.packages.changesApply":"Provést změny","ui.packages.changesApplyAll":"Zaktualizovat všechny balíčky","ui.packages.changesDryrunAll":"Vyzkoušet všechny balíčky nanečisto","ui.packages.changesReset":"Vrátit změny","ui.packages.changesReview":"Ukázat změny","ui.packagelist.loading":"Spouštění…","ui.packagelist.uploads":"Nahrání/přenos souborů","ui.packagelist.added":"Nové balíčky","ui.packagelist.installed":"Nainstalované balíčky","ui.package.hintRevert":"Vrátit změny","ui.package.hintNoupdate":"Neaktualizovat","ui.package.hintConstraint":"Tento balíček bude nainstalovaný s omezením {constraint}, pokud provedete změny.","ui.package.hintConstraintBest":"Tento balíček bude nainstalovaný v nejnověji dostupné verzi, pokud provedete změny.","ui.package.hintConstraintChange":"Toto omezení pro tento balíček bude změněno z \\"{from}\\" na \\"{to}\\", pokud provedete změny.","ui.package.hintConstraintUpdate":"Tento balíček bude zaktualizovaný, pokud aplikujete tyto změny.","ui.package.hintAdded":"Tento balíček bude nainstalovaný, když aplikujete tyto změny.","ui.package.hintRemoved":"Tento balíček bude smazaný, pokud provedete změny.","ui.package.requiredTitle":"přidáno manuálně","ui.package.requiredText":"Tento balíček je už sice uvedený ve Vašem souboru composer.json, ale ještě není nainstalovaný.","ui.package.removedTitle":"odstaněno manuálně","ui.package.removedText":"Tento balíček byl odstraněn z Vašeho souboru composer.json.","ui.package.installed":"Momentálně nainstalováno:","ui.package.version":"Verze {version}","ui.package.additionalDownloads":"{count} Stažení | {count} Stažení","ui.package.additionalStars":"{count} Hvězda | {count} hvězd","ui.package.editConstraint":"Upravit","ui.package.uploadConstraint":"Toto omezení je nadefinováno nahraným balíčkem.","ui.package.updateButton":"Zaktualizovat","ui.package.removeButton":"Smazat","ui.package.installButton":"Přidat balíček","ui.package.installButtonShort":"Přidat","ui.package.detailsButton":"Podrobnosti","ui.package.latestConstraint":"poslední verze","ui.package.update":"Existuje nová aktualizace","ui.package.updateLatest":"poslední verze","ui.package.updateAvailable":"{version}","ui.package.updateUnknown":"neznámá verze","ui.package.updateConstraint":"Je k dispozici nová verze než ta, kterou právě používáte.","ui.package.incompatible":"{package} nefunguje s Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Verze {version}","ui.cloudStatus.waitingTime":"Doba čekání","ui.cloudStatus.jobs":"Současné úlohy","ui.cloudStatus.workers":"Účastníků","ui.cloudStatus.approx":"{minutes} min.","ui.cloudStatus.none":"ne","ui.cloudStatus.short":"ca. {minutes} min.","ui.cloudStatus.long":"ca. {minutes} min. {seconds} sek.","ui.cloudStatus.error":"Nebylo možné získat status Composer Resolver Cloud. Může být zrovna neaktivní nebo má nějaké problémy.","ui.cloudStatus.button":"Status Cloudu","ui.cloudStatus.refresh":"Znovu načíst status Cloudu","ui.log-viewer.loading":"Spouštění…","ui.log-viewer.empty":"Na Vašem serveru se nenacházejí žádné protokolové soubory.","ui.log-viewer.reload":"Načíst znovu","ui.log-viewer.file":"Protokolový soubor","ui.log-viewer.channel":"Kanál","ui.log-viewer.channelTitle":"Kanál zpráv byl přihlášen.","ui.log-viewer.level":"Úroveň","ui.log-viewer.levelTitle":"Vážnost protokolované zprávy.","ui.log-viewer.timeHeader":"Čas","ui.log-viewer.messageHeader":"Zpráva","ui.log-viewer.showContext":"Zobrazit kontext","ui.log-viewer.hideContext":"Skrýt kontext","ui.log-viewer.showExtra":"Zobrazit extra","ui.log-viewer.hideExtra":"Smazat extra","ui.log-viewer.more":"Dozvědět se víc...","ui.log-viewer.download":"Stáhnout","ui.log-viewer.downloadTitle":"Stáhnout soubor \\"{file}\\"","ui.log-viewer.prodEnvironment":"Produktivní prostředí","ui.log-viewer.devEnvironment":"Vývojářské prostředí (vychytávací mód)","ui.user-manager.loading":"Načítám uživatele...","ui.user-manager.changePassword":"Změnit heslo","ui.user-manager.setupTotp":"Nastavení dvoufaktorového ověření","ui.user-manager.disableTotp":"Deaktivovat dvoufaktorové ověření","ui.user-manager.invite":"Pozvat uživatele","ui.user-manager.delete":"Smazat","ui.user-manager.deleteConfirm":"Opravdu chcete smazat \\"{username}\\"?","ui.user-manager.deleted":"Úspěšně došlo ke smazání {username}","ui.user-manager.passwordHeadline":"Změnit heslo","ui.user-manager.passwordText":"Abyste mohli změnit heslo, zadajte nejdřív vaše stávající a pak vaše nové v odpovídajících polích. ","ui.user-manager.currentPassword":"Současné heslo","ui.user-manager.newPassword":"Nové heslo","ui.user-manager.passwordPlaceholder":"min. 8 znaků","ui.user-manager.submitPassword":"Odeslat","ui.user-manager.passwordChanged":"Vaše heslo bylo úspěšně změněno.","ui.user-manager.passwordError":"Heslo není správné.","ui.user-manager.inviteHeadline":"Pozvat uživatele","ui.user-manager.inviteText":"Pokud potřebujete více přihlášení pro Správce Contaa, můžete zde vytvořit odkaz na pozvání. Sdílejte tento odkaz s někým nebo jej použijte na jiném zařízení k vytvoření nového účtu s danými oprávněními.","ui.user-manager.inviteSuccess1":"Byl vytvořen nový odkaz na pozvání. Níže uvedenou adresu lze použít k vytvoření nového uživatelského účtu pro Správce Contaa. Pozvánka vyprší na {expires} (za týden od nynějška).","ui.user-manager.inviteSuccess2":"Zkopírujte prosím tento odkaz do vaší schránky. Platí jen jednou a již se nezobrazí po zavření tohoto dialogu.","ui.user-manager.createInvitation":"Vytvořit odkaz na pozvání","ui.user-manager.clipboard":"Zkopírovat do schránky","ui.user-manager.permissions":"Dozvědět se víc o povolení","ui.user-manager.cancel":"Zrušit","ui.user-manager.close":"Zavřít","ui.user-manager.you":"Vy","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Dvoufaktorové ověření","ui.totp.setupQr":"Naskenujte prosím QR kód pomocí vaší 2FA/TOTP aplikace.","ui.totp.setupCode":"Nemůžete-li naskenovat QR kód, zadejte místo toho následující klíč:","ui.totp.codeLabel":"Ověřovací kód","ui.totp.codeDescription":"Zadejte prosím ověřovací kód vygenerovaný vaší 2FA/TOTP aplikací.","ui.totp.disableText":"Zadejte prosím ověřovací kód, abyste deaktivovali dvoufaktorové ověření. ","ui.totp.invalid":"Ověřovací kód není platný.","ui.totp.enable":"Aktivovat","ui.totp.disable":"Deaktivovat","ui.totp.cancel":"Zrušit","ui.totp.enabled":"Dvoufaktorové ověření bylo úspěšně aktivováno.","ui.totp.disabled":"Dvoufaktorové ověření bylo úspěšně deaktivováno.","ui.totp.setup":"Nastavení dvoufaktorového ověření","ui.totp.skip":"Skip Two-Factor Authentication"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[904],{5523:function(t,e,o){o.r(e),o.d(e,{default:function(){return I}});var s=o(641),a=o(33),i=o(3751),n=o(6894);const u={class:"view-account__header"},r={class:"view-account__product"},l=["href"],c={href:"https://github.com/contao/contao-manager/issues",target:"_blank"},d={key:0,class:"view-account__totp"},p={class:"view-account__headline"},h={class:"view-account__description"},g={key:1,class:"view-account__form"},m={class:"view-account__headline"},b={class:"view-account__description"},w={class:"view-account__fields"},k=["disabled"],_={class:"view-account__contribute"},v={href:"https://to.contao.org/donate",target:"_blank"};function $(t,e,o,$,f,L){const y=(0,s.g2)("i18n-t"),A=(0,s.g2)("text-field"),T=(0,s.g2)("button-group"),C=(0,s.g2)("loading-button"),P=(0,s.g2)("boxed-layout");return(0,s.uX)(),(0,s.Wv)(P,{wide:!0,slotClass:"view-account"},{default:(0,s.k6)((()=>[(0,s.Lk)("header",u,[e[11]||(e[11]=(0,s.Lk)("img",{src:n,width:"100",height:"100",alt:"Contao Logo"},null,-1)),(0,s.Lk)("p",r,[(0,s.Lk)("strong",null,(0,a.v_)(t.$t("ui.account.welcome")),1),e[8]||(e[8]=(0,s.eW)(" Contao Manager 1.10.3 "))]),(0,s.Lk)("p",null,[(0,s.bF)(y,{keypath:"ui.account.intro1"},{readTheManualToGetStarted:(0,s.k6)((()=>[(0,s.bF)(y,{tag:"strong",keypath:"ui.account.introGetStarted"},{readTheManual:(0,s.k6)((()=>[(0,s.Lk)("a",{href:`https://to.contao.org/docs/contao-manager?lang=${t.$i18n.locale}`,target:"_blank"},(0,a.v_)(t.$t("ui.account.introManual")),9,l)])),_:1})])),_:1}),e[9]||(e[9]=(0,s.Lk)("br",null,null,-1)),e[10]||(e[10]=(0,s.Lk)("br",null,null,-1)),(0,s.bF)(y,{keypath:"ui.account.intro2"},{ourGithubIssues:(0,s.k6)((()=>[(0,s.Lk)("a",c,(0,a.v_)(t.$t("ui.account.introIssues")),1)])),_:1})])]),(0,s.bF)(i.eB,{name:"animate-flip",type:"transition",mode:"out-in"},{default:(0,s.k6)((()=>[t.currentUser&&!t.hasTotp?((0,s.uX)(),(0,s.CE)("main",d,[(0,s.Lk)("h1",p,(0,a.v_)(t.$t("ui.account.totpHeadline")),1),(0,s.Lk)("p",h,(0,a.v_)(t.$t("ui.account.totpDescription")),1),(0,s.Lk)("button",{class:"widget-button widget-button--primary",onClick:e[0]||(e[0]=(...t)=>L.setupTotp&&L.setupTotp(...t))},(0,a.v_)(t.$t("ui.totp.setup")),1),(0,s.Lk)("button",{class:"widget-button widget-button--alert",onClick:e[1]||(e[1]=(...t)=>L.skipTotp&&L.skipTotp(...t))},(0,a.v_)(t.$t("ui.totp.skip")),1)])):((0,s.uX)(),(0,s.CE)("main",g,[(0,s.Lk)("form",{onSubmit:e[7]||(e[7]=(0,i.D$)(((...t)=>L.createAccount&&L.createAccount(...t)),["prevent"]))},[(0,s.Lk)("h1",m,(0,a.v_)(t.$t("ui.account.headline")),1),(0,s.Lk)("p",b,(0,a.v_)(t.$t("ui.account.description")),1),(0,s.Lk)("fieldset",w,[(0,s.bF)(A,{ref:"username",name:"username",label:t.$t("ui.account.username"),disabled:t.logging_in,required:"",error:t.errors.username,onBlur:e[2]||(e[2]=e=>t.errors.username=""),modelValue:t.username,"onUpdate:modelValue":e[3]||(e[3]=e=>t.username=e)},null,8,["label","disabled","error","modelValue"]),t.usePassword?((0,s.uX)(),(0,s.Wv)(A,{key:0,ref:"password",name:"password",type:"password",label:t.$t("ui.account.password"),placeholder:t.$t("ui.account.passwordPlaceholder"),disabled:t.logging_in,required:"",pattern:".{8,}",error:t.errors.password,onBlur:L.validatePassword,modelValue:t.password,"onUpdate:modelValue":e[4]||(e[4]=e=>t.password=e)},null,8,["label","placeholder","disabled","error","onBlur","modelValue"])):(0,s.Q3)("",!0),t.supportsWebAuthn?((0,s.uX)(),(0,s.Wv)(T,{key:1,submit:"",color:"primary",disabled:!t.valid,loading:t.logging_in,label:t.$t("ui.account.submit")},{default:(0,s.k6)((()=>[(0,s.Lk)("button",{type:"button",class:"widget-button",disabled:t.logging_in,onClick:e[5]||(e[5]=e=>t.usePassword=!t.usePassword)},(0,a.v_)(t.$t("ui.account."+(t.usePassword?"usePasskey":"usePassword"))),9,k)])),_:1},8,["disabled","loading","label"])):((0,s.uX)(),(0,s.Wv)(C,{key:2,submit:"",color:"primary",disabled:!t.valid,loading:t.logging_in},{default:(0,s.k6)((()=>[(0,s.eW)((0,a.v_)(t.$t("ui.account.submit")),1)])),_:1},8,["disabled","loading"])),L.isInvitation?((0,s.uX)(),(0,s.CE)("button",{key:3,type:"button",class:"widget-button widget-button--anchor",onClick:e[6]||(e[6]=(...t)=>L.gotoLogin&&L.gotoLogin(...t))},(0,a.v_)(t.$t("ui.account.login")),1)):(0,s.Q3)("",!0)])],32)]))])),_:1}),(0,s.Lk)("aside",_,[(0,s.Lk)("p",null,[(0,s.eW)((0,a.v_)(t.$t("ui.account.contribute1")),1),e[12]||(e[12]=(0,s.Lk)("br",null,null,-1)),(0,s.bF)(y,{keypath:"ui.account.contribute2"},{donate:(0,s.k6)((()=>[(0,s.Lk)("a",v,(0,a.v_)(t.$t("ui.account.contributeDonate")),1)])),_:1})])])])),_:1})}var f=o(6278),L=o(60),y=o(707),A=o(728),T=o(9757),C=o(85),P=o(4676),V=o(9473),W={components:{BoxedLayout:A.A,TextField:T.A,LoadingButton:C.A,ButtonGroup:P.A},data:()=>({username:"",password:"",errors:{username:"",password:""},valid:!1,logging_in:!1,usePassword:!1,supportsWebAuthn:!0}),computed:{...(0,f.aH)("auth",{currentUser:"username",hasTotp:"totpEnabled"}),isInvitation:t=>!!t.$route.query.invitation},methods:{validate(){this.valid=this.$refs.username.checkValidity()&&(!this.usePassword||this.$refs.password.checkValidity())},validatePassword(){this.errors.password=null,""!==this.password&&this.password.length<8&&(this.errors.password=this.$t("ui.account.passwordLength"))},async createAccount(){if(!this.valid)return;this.logging_in=!0;const t={username:this.username};if(this.isInvitation&&(t.invitation=this.$route.query.invitation),this.usePassword)t.password=this.password;else{const o=(await this.$request.post("api/session/options",t)).data;let s;try{s=await(0,L.Ct)({optionsJSON:o})}catch(e){return void(this.logging_in=!1)}if(!s)return void(this.logging_in=!1);t.passkey=JSON.stringify(s)}201!==(await this.$store.dispatch("auth/login",t)).status&&(this.logging_in=!1,this.errors.username=this.$t("ui.account.loginInvalid"),setTimeout((()=>{this.$refs.username.focus()}),0))},setupTotp(){this.$store.commit("modals/open",{id:"setup-totp",component:V.A})},skipTotp(){this.$store.commit("setView",y.A.BOOT)},gotoLogin(){this.$router.replace({name:this.$route.name,query:null}),this.$store.commit("setView",y.A.LOGIN)}},watch:{username(){this.validate()},password(){this.validate()},hasTotp(){this.$store.commit("setView",y.A.BOOT)}},mounted(){this.supportsWebAuthn="https:"===location.protocol&&(0,L.zZ)(),this.usePassword=!this.supportsWebAuthn,this.$refs.username&&this.$refs.username.focus()}},B=o(6262);const F=(0,B.A)(W,[["render",$]]);var I=F}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[560],{1560:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Nedrošs savienojums !!","ui.app.httpsDescription":"Bez HTTPS jūsu konfidenciālie dati tiks pārsūtīti nešifrēti.","ui.app.httpsLink":"Vairāk informācijas","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Ieslēgts drošais režīms !!","ui.app.safeModeDescription":"Dažas Contao Manager funkcijas nav pieejamas.","ui.app.safeModeExit":"Iziet no drošā režīma","ui.app.limitedHeadline":"Attālā autentifikācija","ui.app.limitedDescription":"Jums ir ierobežotas atļaujas, jo pieslēgšanās notiek bez paroles.","ui.app.limitedLogout":"Atkārtoti autentificēties","ui.app.totpHeadline":"Drošības paziņojums","ui.app.totpDescription":"Konfigurējiet divfaktoru autentifikāciju, lai aizsargātu savu kontu.","ui.app.totpSetup":"Uzstādīt","ui.app.loading":"Ielādē Contao pārvaldnieku ...","ui.app.apiError":"Negaidīts API statuss","ui.app.configSecurity1":"DROŠĪBAS BRĪDINĀJUMS !!! Konstatēts neaizsargāts konfigurācijas direktorijs","ui.app.configSecurity2":"The Contao Manager has detected that its config files are publicly accessible. All operations are disabled until the directory is secured, otherwise an attacker could access sensitive data of your installation.\\n\\nTo fix this issue, make sure to prevent access to the \\"contao-manager\\" directory on your server. To learn how to do this, please refer to the manual of your webserver or contact your hosting provider.","ui.account.welcome":"Laipni lūdzam","ui.account.intro1":"Laipni lūgti Contao pārvaldniekā, kas ir universāls rīks Contao atvērtā koda CMS instalēšanai un pārvaldībai. Ja esat jauns lietotājs, lūdzu, {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual}, lai sāktu","ui.account.introManual":"izlasiet rokasgrāmatu","ui.account.intro2":"Ja jums rodas kādas problēmas, pārbaudiet {ourGithubIssues} un nekautrējieties izveidot jaunu problēmu, ja par to vēl nav ziņots.","ui.account.introIssues":"mūsu GitHub problēmas","ui.account.headline":"Lietotāja konts","ui.account.description":"Lai pārvaldītu savu instalāciju, lūdzu, izveidojiet Contao pārvaldnieka kontu. Ņemiet vērā, ka šis konts nav saistīts ar Contao aizmuguri vai priekšu.","ui.account.username":"Lietotājvārds","ui.account.password":"Parole","ui.account.passwordPlaceholder":"min. 8 rakstzīmes","ui.account.passwordLength":"Lūdzu, ievadiet vismaz 8 rakstzīmes.","ui.account.loginInvalid":"There was an error when creating the account. Please try a different username.","ui.account.submit":"Izveidot kontu","ui.account.usePassword":"Izmantot paroli, lai pieslēgtos","ui.account.usePasskey":"Pieslēdzoties izmantot Passkey","ui.account.totpHeadline":"Divu faktoru autentifikācija","ui.account.totpDescription":"Please enable two-factor authentication, which adds an extra layer of security to your account. In addition to your username and password, you will need to enter a verification code generated by a two-factor app such as 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator or any other TOTP app.","ui.account.totpSetup":"Konfigurēt tagad","ui.account.totpSkip":"Konfigurēt vēlāk","ui.account.login":"Noraidīt ielūgumu","ui.account.contribute1":"Contao un Contao Manager sponsorē bezpeļņas organizācija Contao Association.","ui.account.contribute2":"Lūdzu, apsveriet iespēju sniegt ieguldījumu atvērtajā pirmkodā {donate}.","ui.account.contributeDonate":"ziedojuma veikšana","ui.login.headline":"Pierakstīties","ui.login.description":"Pierakstīties, lai pārvaldītu savu instalāciju.","ui.login.username":"Lietotājvārds","ui.login.password":"Parole","ui.login.totpHeadline":"Divu faktoru autentifikācija","ui.login.totpDescription":"Lūdzu, ievadiet verifikācijas kodu, lai pabeigtu pieslēgšanās procesu.","ui.login.totp":"Verifikācijas kods","ui.login.forgotPassword":"Aizmirsāt paroli?","ui.login.button":"Pierakstīties","ui.login.passkey":"Pieslēgties ar Passkey","ui.login.cancel":"Atcelt","ui.login.or":"vai","ui.login.locked":"Piekļuve ir liegta, jo Contao Manager ir bloķēts. Lai atbloķētu, izdzēsiet {lockFile} datni Contao galvenajā direktorijā.","ui.logout.headline":"Sesijas laika limits","ui.logout.warning":"Jūs esat bijis neaktīvs ilgāk par 25 minūtēm. Drošības apsvērumu dēļ jūsu sesija drīz tiks pārtraukta.","ui.logout.expired":"Jūsu sesija tika automātiski pārtraukta, jo esat bijis neaktīvs ilgāk par 30 minūtēm.","ui.logout.renew":"Palikt pieteikušamies","ui.logout.logout":"Izrakstīties","ui.logout.login":"Atpakaļ uz pieteikšanos","ui.oauth.error":"Nederīgs OAuth mēģinājums. Pārbaudiet pieprasījuma parametrus.","ui.oauth.https":"The redirect URI MUST use a secure protocol (https:) to prevent the authentication token from being transmitted in clear-text.","ui.oauth.headline":"Attālā autentifikācija","ui.oauth.description":"Šāda lietojumprogramma vai pakalpojums pieprasa attālo piekļuvi jūsu Contao Manager instancei.","ui.oauth.domain":"Pirms atļaujat piekļuvi, pārliecinieties, ka zināt šo URL un uzticaties tā īpašniekam!","ui.oauth.outOfScope":"Unfortunately, you do not have the necessary permissions to grant this access.","ui.oauth.allow":"Atļaut piekļuvi","ui.oauth.deny":"Liegt piekļuvi","ui.oauth.switchUser":"Pārslēgt lietotāju","ui.scope.admin":"Admin access including user management","ui.scope.install":"Install new packages and change Contao configuration","ui.scope.update":"Update packages and execute maintenance tasks","ui.scope.read":"Read packages and configuration","ui.boot.headline":"Sistēmas pārbaude","ui.boot.description":"Lūdzu, uzgaidiet, mēs analizējam jūsu serveri ...","ui.boot.issue1":"Konstatētās  instalēšanas problēmas","ui.boot.issue2":"Jūsu instalācijā ir problēmas, kas jānovērš, pirms var izmantot Contao Manager.","ui.boot.run":"Palaist Contao pārvaldnieku","ui.boot.safeMode":"Palaist drošajā režīmā","ui.recovery.headline":"Sistēmas atkopšana","ui.recovery.description":"Contao Manager atklāja datnes, kas izskatās kā Contao, bet komandrindas saskarne nedarbojas, kā paredzēts.","ui.recovery.console":"Konsoles izvade","ui.recovery.repairOptions":"Lūdzu, izvēlieties iespēju, lai salabotu instalāciju.","ui.recovery.repairHeadline":"Automātiskā izlabošana","ui.recovery.repairDescription":"Mēģina automātiski labot instalāciju, atjaunojot lietojumprogrammu kešatmiņu un atkārtoti instalējot Composer paketes.","ui.recovery.repairWarning":"Procesa laikā var tikt dzēstas visas piegādātāja datņu izmaiņas!","ui.recovery.repairFailed":"Automātiskā labošana nebija veiksmīga. Izmēģiniet instalāciju labot manuāli drošajā režīmā.","ui.recovery.repairButton":"Palaist sistēmas izlabošanu","ui.recovery.safeModeHeadline":"Drošais režīms","ui.recovery.safeModeDescription":"Programmas Contao Manager palaišana drošajā režīmā ļauj pārvaldīt paketes un veikt dažus uzturēšanas uzdevumus, taču funkcijas, kas ir atkarīgas no darbojošās Contao instalācijas, nebūs pieejamas.","ui.recovery.safeModeButton":"Palaist drošajā režīmā","ui.server.pending":"Gaida ...","ui.server.running":"Analizē ...","ui.server.error":"Pārbaude neizdevās, jo no servera saņemta neparedzēta atbilde.","ui.server.details":"Sīkāka informācija","ui.server.prerequisite":"Pārbaude atcelta trūkstošā priekšnosacījuma dēļ.","ui.server.selfUpdate.title":"Contao pārvaldnieka atjauninājumi","ui.server.selfUpdate.update":"Ir pieejama jauna Contao pārvaldnieka versija {latest}.","ui.server.selfUpdate.manualUpdate":"Ir pieejama jauna Contao Manager versija {latest}. Jūsu serveris neatbalsta automātiskus atjauninājumus, lūdzu, lejupielādējiet jauno versiju no {download}.","ui.server.selfUpdate.latest":"Jūs izmantojat jaunāko versiju {current}.","ui.server.selfUpdate.dev":"Izstrādes būves neatbalsta automātiskus atjauninājumus.","ui.server.selfUpdate.unsupported":"Ir pieejama jauna versija, taču tā neatbalsta jūsu PHP versiju.","ui.server.selfUpdate.button":"Palaist pašatjauninājumu","ui.server.selfUpdate.continue":"Turpināt","ui.server.config.title":"Servera konfigurācija","ui.server.config.setup":"Konfigurēt","ui.server.config.change":"Mainīt","ui.server.config.save":"Saglabāt","ui.server.config.cancel":"Atcelt","ui.server.config.customOption":"Cits ...","ui.server.config.description":"To correctly run background tasks, the Contao Manager needs to know where to find the PHP command line binary and how to run commands separated from the web process.","ui.server.config.formTitle":"Servera konfigurācija","ui.server.config.formText":"Please enter the path to your PHP binary. Make sure the binary is the same PHP version as your web process.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"The Composer Resolver Cloud allows to install Composer dependencies even if your server does not provide enough local memory. Please be aware that your package information will be transmitted to a cloud server operated by the Contao Association.","ui.server.config.cloud":"Izmantot Composer Resolver Cloud","ui.server.config.cli":"PHP binārs","ui.server.config.stateErrorCli":"Serverī netika atrasts derīgs PHP binārs.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud netiek atbalstīts.","ui.server.config.stateSuccess":"PHP binārais kodols {php_cli}.","ui.server.php_web.title":"PHP Web process","ui.server.php_web.below7":"Atrasta PHP versija {versija}. Lūdzu, pēc iespējas ātrāk pārejiet uz PHP 7!","ui.server.php_web.success":"Atrasta PHP versija {versija}, neviena zināma problēma nav atrasta.","ui.server.php_cli.title":"PHP komandrindas saskarne","ui.server.php_cli.success":"Atrasta PHP versija {versija}, neviena zināma problēma nav atrasta.","ui.server.composer.title":"Composer vide","ui.server.composer.success":"Netika atrastas zināmas problēmas.","ui.server.composer.install":"Composer dependencies are not installed.","ui.server.composer.button":"Uzstādīt","ui.server.contao.title":"Contao instalācija","ui.server.contao.setup":"Uzstādīt","ui.server.contao.check":"Pārbaudīt datubāzi","ui.server.contao.empty":"Neviena Contao instalācija nav atrasta.","ui.server.contao.old":"Contao versija {versija} nav savietojama ar Contao pārvaldnieku, lūdzu, manuāli atjauniniet instalāciju.","ui.server.contao.found":"Atrasts Contao {versija} (API versija {api}).","ui.server.contao.connectionError":"Nevar izveidot savienojumu ar datubāzes serveri.","ui.server.contao.connectionProblem":"Atrasta datubāzes problēma.","ui.server.contao.missingUser":"Administratora konts nav atrasts.","ui.setup.continue":"Turpināt","ui.setup.manager":"Palaist Contao pārvaldnieku","ui.setup.cancel":"Atcelt","ui.setup.welcome":"Laipni lūdzam","ui.setup.welcome1":"This wizard will take you through the necessary steps to set up your Contao Open Source CMS installation.","ui.setup.welcome2":"If you have any questions, please find documentation, forums, a Slack channel and more on the {support} page.","ui.setup.support":"kopienas atbalsts","ui.setup.start":"Sākt","ui.setup.complete":"Apsveicam!","ui.setup.complete1":"Contao {versija} ir veiksmīgi instalēta.","ui.setup.complete2":"To finish the setup process, please open the install tool to configure the database connection and create a back end user.","ui.setup.complete3":"You can now start to create your website in the Contao back end. If you need additional extensions, continue to the Contao Manager.","ui.setup.installTool":"Atveriet instalēšanas rīku","ui.setup.login":"Pieslēgties Contao","ui.setup.funding":"Free software is \\"free\\" as in \\"free speech\\", not as in \\"free beer\\". An Open Source project like Contao requires amounts of money that can\'t be raised by a single person or company.\\nIf you have a website or sell websites built with Contao, we would love to see you contribute back financially to the product your business relies upon.","ui.setup.fundingLink":"Uzzināt vairāk","ui.setup.document-root.headline":"Tīmekļa servera iestatīšana","ui.setup.document-root.warning":"Lai instalētu Contao, izmantojot Contao Manager, tīmekļa serverī ir jānosaka dokumenta sakne.","ui.setup.document-root.description1":"Contao uses a separate folder for public files, application files are installed in its parent folder. Contao cannot be installed if the folder structure is not correct or the folders are not empty.","ui.setup.document-root.description2":"Ja nezināt, kā konfigurēt dokumentu sakni, izlasiet Contao dokumentāciju vai sazinieties ar savu hostinga pakalpojumu sniedzēju.","ui.setup.document-root.documentation":"Izlasiet dokumentāciju","ui.setup.document-root.conflictsTitle":"Instalācijas direktorijs nav tukšs","ui.setup.document-root.conflictsDirectory":"The root directory of your future Contao installation is not empty, we have found {count} file(s) that might be overwritten by the installation process. It is recommended to create an empty directory structure for Contao, but you can also remove the following files and check again if you are sure they are unused.","ui.setup.document-root.ignoreConflicts":"I want to install Contao into the non-empty directory. I understand that this might overwrite any existing files on my webspace.","ui.setup.document-root.check":"Pārbaudiet vēlreiz","ui.setup.document-root.create":"Izveidot direktorijus","ui.setup.document-root.change":"Mainīt direktorijus","ui.setup.document-root.formTitle":"Direktoriju iestatīšana","ui.setup.document-root.formText1":"Contao Manager var automātiski izveidot jaunu direktoriju struktūru serverī.","ui.setup.document-root.formText2":"Jums būs manuāli jākonfigurē jaunā dokumenta sakne (piemēram, izmantojot hostinga administratora paneli).","ui.setup.document-root.autoconfig":"Es saprotu, ka man ir jāmaina servera konfigurācija. Dokumenta saknes nekonfigurēšana sabojās Contao Manager un atklās konfigurācijas failus (tostarp konta informāciju un paroles)!","ui.setup.document-root.directory":"Jauns direktorijs","ui.setup.document-root.currentRoot":"Pašreizējā dokumenta sakne","ui.setup.document-root.newRoot":"Jauna dokumenta sakne","ui.setup.document-root.finish":"Direktoriju iestatīšana","ui.setup.document-root.publicDir":"Izmantojiet {dir} publiskajām datnēm (Contao {version})","ui.setup.document-root.directoryInvalid":"Lūdzu, ievadiet derīgu direktorija nosaukumu.","ui.setup.document-root.directoryExists":"Mērķa direktorijs jau pastāv. Lūdzu, ievadiet citu nosaukumu.","ui.setup.document-root.confirmation":"Contao pārvaldnieks ir veiksmīgi izveidojis nepieciešamo direktoriju jūsu Contao instalācijai. Tagad jums ir jākonfigurē dokumenta sakne tīmekļa serverī. Līdz tam nepārlādējiet šo lapu no jauna.","ui.setup.document-root.reload":"Pārlādēt lapu","ui.setup.document-root.success":"The directory structure on your web server is set up correctly!","ui.setup.document-root.installingProjectDir":"Lietojumprogrammas datnes tiks instalētas {dir}.","ui.setup.document-root.installingPublicDir":"Publiskās datnes tiks instalētas {dir}.","ui.setup.document-root.installedProjectDir":"Lietojumprogrammas datnes ir instalētas {dir}.","ui.setup.document-root.installedPublicDir":"Publiskās datnes ir instalētas {dir}.","ui.setup.create-project.headline":"Contao instalācija","ui.setup.create-project.description":"Contao development follows the principle of {semver}, a new minor version is released every six months. The currently supported releases are:","ui.setup.create-project.semver":"Semantic Versioning","ui.setup.create-project.latestTitle":"Jaunākais","ui.setup.create-project.ltsTitle":"Ilgtermiņa atbalsts","ui.setup.create-project.latestQ1":"Our latest version, offers the most features with support until February {year}.","ui.setup.create-project.latestQ3":"Our latest version, offers the most features with support until August {year}.","ui.setup.create-project.ltsText":"Our current LTS version, if you focus on stability. Offers long term support until February {year}.","ui.setup.create-project.pltsText":"The previous LTS version, still has long term support until February {year}.","ui.setup.create-project.requiresPHP":"Requires at least PHP {version}, you have PHP {current}.","ui.setup.create-project.releaseplan":"Sīkāku informāciju skatiet {contaoReleasePlan}.","ui.setup.create-project.releaseplanLink":"Contao izlaišanas plāns","ui.setup.create-project.installed":"Contao {version} is successfully installed on the server. Continue to set up your database or launch the Contao Manager to install a different version.","ui.setup.create-project.formTitle":"Izvēlēties distribūciju","ui.setup.create-project.formText":"Lūdzu, izvēlieties, kura versija jāuzstāda.","ui.setup.create-project.version":"Versija","ui.setup.create-project.demo":"Instalēt Contao demo vietni","ui.setup.create-project.demoDescription":"The demo website helps you to get familiar with Contao and all of its core features. More themes can be found in the {store}.","ui.setup.create-project.coreOnly":"Minimāla instalācija (tikai Core)","ui.setup.create-project.noUpdate":"Izlaist instalāciju (tikai eksperts!)","ui.setup.create-project.theme":"Contao tēma","ui.setup.create-project.themeInstall":"To install a Contao theme, use the search input or upload a theme file (.cto/.zip) that supports installation through the Contao Manager.","ui.setup.create-project.themeBuy":"Noteikti apmeklējiet oficiālo {store}.","ui.setup.create-project.themeStore":"Contao tēmu veikals","ui.setup.create-project.themeUpload":"Augšupielādēt tēmas datni (.cto/.zip)","ui.setup.create-project.themeInvalid":"The uploaded file is not a Contao theme or does not support the Contao Manager.","ui.setup.create-project.themeWarning":"The Contao Manager cannot tell whether this theme is compatible with your server. Please check with the theme vendor if you have any questions.","ui.setup.create-project.themeTitle":"Review theme details","ui.setup.create-project.themeDetails":"The following dependencies and files will be installed with this theme.","ui.setup.create-project.themeRequire":"{count} Dependencies | {count} Dependencies","ui.setup.create-project.themeFiles":"{count} File | {count} Files","ui.setup.create-project.theme.or":"or search public themes","ui.setup.create-project.theme.search":"Meklēt tēmas","ui.setup.create-project.theme.more":"Vairāk tēmas","ui.setup.create-project.theme.empty":"No themes matching {query}","ui.setup.create-project.theme.uploaded":"Tēmas datne tika veiksmīgi augšupielādēta.","ui.setup.create-project.theme.packageName":"Package name","ui.setup.create-project.theme.version":"Versija","ui.setup.create-project.theme.authors":"Autors(i)","ui.setup.create-project.theme.upload":"Uploading {name} ({size})","ui.setup.create-project.install":"Uzstādīt","ui.setup.create-project.cancel":"Atcelt","ui.setup.database-connection.headline":"Datubāzes savienojums","ui.setup.database-connection.description":"Contao requires a MySQL database (or a compatible fork like MariaDB) to store pages, content, users and other relational data. Connection parameters are stored in the {env} file in the project root of your Contao installation.","ui.setup.database-connection.formTitle":"Savienojuma parametri","ui.setup.database-connection.formText":"Ievadiet datubāzes URL vai atsevišķi aizpildiet lietotājvārdu, paroli, serveri un datubāzes laukus.","ui.setup.database-connection.url":"Datubāzes URL","ui.setup.database-connection.validUrl":"Datubāzes URL ir nederīgs vai neizdevās izveidot savienojumu ar serveri.","ui.setup.database-connection.or":"vai","ui.setup.database-connection.user":"Lietotājvārds","ui.setup.database-connection.password":"Parole","ui.setup.database-connection.server":"Serveris (:ports)","ui.setup.database-connection.database":"Datubāzes nosaukums","ui.setup.database-connection.connected":"Successfully connected to database {database} on {server}.","ui.setup.database-connection.error":"Kļūda, savienojoties ar datubāzi.","ui.setup.database-connection.problem":"Contao ir atklājis problēmu ar jūsu datubāzes serveri.","ui.setup.database-connection.schemaTitle":"Database Schema","ui.setup.database-connection.migration":"There is one pending migration. | There are {count} pending migrations.","ui.setup.database-connection.schema":"There is one pending schema update. | There are {count} pending schema updates.","ui.setup.database-connection.noChanges":"Jūsu datubāzes shēma ir aktuāla.","ui.setup.database-connection.check":"Pārbaudīt datubāzi","ui.setup.database-connection.skip":"Izlaist","ui.setup.database-connection.save":"Saglabāt","ui.setup.database-connection.change":"Mainīt akreditācijas datus","ui.setup.database-connection.restoreTitle":"Datubāzes imports","ui.setup.database-connection.restoreText":"The theme you just installed contains a database backup. Restore the database to import theme data or skip this step to start with a blank Contao installation. | The theme you just installed contains multiple database backups. Select a backup file to import theme data or skip this step to start with a blank Contao installation.","ui.setup.database-connection.backup":"Dublējiet pašreizējo datu bāzi pirms importēšanas","ui.setup.database-connection.backupWarning":"All data in database will be overwritten on import! Create a backup first if the database is not empty.","ui.setup.database-connection.restore":"Importēt tēmas datubāzi","ui.setup.database-connection.restoreOption":"Backup from {date} ({size})","ui.setup.database-connection.restored":"Your theme database was successfully imported. Continue to validate your database schema.","ui.setup.backend-user.success":"An admin account for the Contao back end was found in your database. Use the Contao back end to add more users.","ui.setup.backend-user.error":"Unable to retrieve user list. Check the console output for details.","ui.setup.backend-user.headline":"Aizmugures konts","ui.setup.backend-user.description":"To manage your website, you need to have at least one admin account for the Contao back end. Be aware that this account is not related to the Contao Manager.","ui.setup.backend-user.formTitle":"Izveidot kontu","ui.setup.backend-user.formText":"Please enter the details for the new back end account.","ui.setup.backend-user.username":"Lietotājvārds","ui.setup.backend-user.name":"Vārds","ui.setup.backend-user.email":"E-pasta adrese","ui.setup.backend-user.emailInvalid":"Lūdzu, ievadiet derīgu e-pasta adresi","ui.setup.backend-user.password":"Parole","ui.setup.backend-user.passwordPlaceholder":"min. 8 rakstzīmes","ui.setup.backend-user.passwordLength":"Lūdzu, ievadiet vismaz 8 rakstzīmes.","ui.setup.backend-user.create":"Pievienot kontu","ui.task.headline":"Fona uzdevums","ui.task.loading":"Ielādē informāciju ...","ui.task.created":"Ielādē informāciju ...","ui.task.active":"Lūdzu, pagaidiet, kamēr Contao Manager fona režīmā tiek veiktas uzdevumu operācijas.","ui.task.complete":"Visas operācijas ir veiksmīgi pabeigtas. Sīkāku informāciju skatiet konsoles izvades failā.","ui.task.paused":"Fona operācija negaidīti apstājās. Lūdzu, pārbaudiet konsoles izvadi.","ui.task.aborting":"Lūdzu, uzgaidiet, kamēr tiek atceltas fona operācijas.","ui.task.stopped":"Dažas fona darbības tika atceltas. Lūdzu, pārbaudiet konsoles izvadi.","ui.task.error":"Fona operācija negaidīti apstājās. Lūdzu, pārbaudiet konsoles izvadi.","ui.task.failed":"Contao pārvaldniekam neizdevās palaist fona uzdevumu!","ui.task.failedDescription1":"Mēģinot izpildīt operācijas fonā, kaut kas notika nepareizi.","ui.task.failedDescription2":"Ja tas atkārtojas, iespējams, ka jūsu serveris netiek atbalstīts.","ui.task.reportProblem":"Ziņot par problēmu","ui.task.pausedDescription":"Click \\"Continue\\" if you want to ignore the error and execute the remaining operations.","ui.task.sponsor":"Composer Cloud sponsored by {sponsor}","ui.task.buttonAudit":"Atjaunināt datubāzi","ui.task.buttonClose":"Aizvērt","ui.task.buttonConfirm":"Apstiprināt & aizvērt","ui.task.buttonContinue":"Turpināt","ui.task.buttonCancel":"Atcelt","ui.task.confirmCancel":"Vai noteikti vēlaties atcelt šo uzdevumu? Tas var atstāt jūsu Contao instalāciju bojātā stāvoklī!","ui.task.autoclose":"Aizvērt uzdevuma informāciju pēc izdošanās","ui.console.toggle":"Rādīt/slēpt konsoles izvadi","ui.console.showLog":"Rādīt pilnu konsoles žurnālu","ui.console.copyLog":"Kopēt žurnālu uz starpliktuvi","ui.migrate.headline":"Datubāzes atjauninājumi","ui.migrate.migrationsOnly":"(migrations only)","ui.migrate.schemaOnly":"(schema only)","ui.migrate.loading":"Lūdzu, uzgaidiet, mēs pārbaudām jūsu datubāzi...","ui.migrate.empty":"No pending migrations or schema updates found. Your database is up to date.","ui.migrate.emptyMigrations":"No pending migrations found. Make sure to also check for schema updates.","ui.migrate.emptySchema":"No pending schema updates found. Make sure to also check for migrations.","ui.migrate.pending":"Your database is not up to date. Please review the console output below and execute the changes.","ui.migrate.previousChanges":"A previous database migration was not confirmed.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.previousComplete":"A previous database migration was not confirmed, please review the console output below.\\nThere are no more pending changes.","ui.migrate.appliedChanges":"Database updates have been applied.\\nPlease review the console output below, then continue to see the next changes.","ui.migrate.appliedComplete":"Database updates have been applied.\\nThere are no more pending migrations or schema updates. Your database is up to date.","ui.migrate.problem":"Contao has detected a problem with your database server.\\nPlease review the console output below to find out what needs to be fixed. | Contao has detected problems with your database server.\\nPlease review the console output below to find out what needs to be fixed.","ui.migrate.warning":"Contao has detected a misconfiguration of your database server.\\nWarnings can be skipped temporarily, but should be fixed for optimal performance and data integrity.","ui.migrate.error":"The changes could not be applied. Your database might have been changed, please check again to retry.","ui.migrate.execute":"Izpildīt","ui.migrate.close":"Aizvērt","ui.migrate.confirm":"Apstiprināt & aizvērt","ui.migrate.cancel":"Atcelt","ui.migrate.continue":"Turpināt","ui.migrate.setup":"Uzstādīt","ui.migrate.skip":"Izlaist","ui.migrate.retry":"Pārbaudiet vēlreiz","ui.migrate.retryAll":"Atzīmēt visus","ui.migrate.withDeletes":"Izpildīt visas datubāzes izmaiņas, tostarp DROP vaicājumus.","ui.migrate.migrationTitle":"Datubāzu migrācija","ui.migrate.schemaTitle":"Shēmas atjauninājumi","ui.migrate.problemTitle":"Datubāzes problēmas","ui.migrate.warningTitle":"Datubāzes brīdinājumi","ui.migrate.addTable":"Pievienot tabulu {table}","ui.migrate.dropTable":"Nomest tabulu {table}","ui.migrate.addField":"Pievienot lauku {table}.{field}","ui.migrate.changeField":"Mainīt lauku {table}.{field}","ui.migrate.dropField":"Nomest lauku {table}.{field}","ui.migrate.createIndex":"Izveidot indeksu \\"{name}\\" uz {table}","ui.migrate.dropIndex":"Nomest indeksu \\"{name}\\" uz {table}","ui.widget.mandatory":"Šis lauks nedrīkst būt tukšs.","ui.widget.blankOption":"Lūdzu, izvēlieties ...","ui.widget.showPassword":"Rādīt paroli","ui.widget.hidePassword":"Slēpt paroli","ui.error.title":"HTTP pieprasījums \\"{metod} {url}\\" neizdevās.","ui.error.server500":"Looks like an unexpected error happened on your server. Please check the log files of your web server (Apache/Nginx) and the Contao Manager logs at \\"contao-manager/logs\\".","ui.error.response":"Serveris atbildēja ar statusa kodu {status}.","ui.error.moreLink":"Vairāk informācijas","ui.error.support":"Contao atbalsts","ui.error.permission":"You do not have permission to use this feature.","ui.footer.help":"Palīdzība","ui.footer.reportProblem":"Ziņot par problēmu","ui.navigation.discover":"Atklāt","ui.navigation.packages":"Pakotnes","ui.navigation.tools":"Rīki","ui.navigation.installTool":"Instalēšanas rīks","ui.navigation.backend":"Contao aizmugure","ui.navigation.debug":"Contao atkļūdošanas režīms","ui.navigation.logViewer":"Žurnāla skatītājs","ui.navigation.phpinfo":"PHP informācija","ui.navigation.phpinfoLoading":"PHP informācijas ielāde...","ui.navigation.maintenance":"Uzturēšana","ui.navigation.rebuildCache":"Pārbūvēt kešatmiņu","ui.navigation.users":"Konti","ui.navigation.systemCheck":"Sistēmas pārbaude","ui.navigation.advanced":"Papildu","ui.navigation.logout":"Izrakstīties","ui.maintenance.database.title":"Datubāžu migrācija un dublējumi","ui.maintenance.database.description":"Database migrations ensure consistent data and table schemas.","ui.maintenance.database.migrations":"One pending database migration | {count} pending database migrations","ui.maintenance.database.schemaUpdates":"One pending schema update | {count} pending schema updates","ui.maintenance.database.error":"Atrasta datubāzes problēma.","ui.maintenance.database.warning":"Atrasti datubāzes brīdinājumi.","ui.maintenance.database.button":"Pārbaudīt datubāzi","ui.maintenance.database.migrationOnly":"Pārbaudīt tikai migrācijas","ui.maintenance.database.schemaOnly":"Pārbaudīt tikai shēmu","ui.maintenance.database.installTool":"Atvērt instalēšanas rīku","ui.maintenance.database.createBackup":"Izveidot dublējumu","ui.maintenance.database.backupUnsupported":"Database backups are not supported by your Contao version.","ui.maintenance.database.backupList":"You have one database backup, created on {date}. | You have {count} database backups, the latest one was created on {date}.","ui.maintenance.database.backupEmpty":"You currently have no database backups.","ui.maintenance.rebuildCache.title":"Lietojumprogrammas kešatmiņa","ui.maintenance.rebuildCache.description":"Rebuilding the application cache is required after modifying any of the configuration files.","ui.maintenance.rebuildCache.rebuildProd":"Ražošanas kešatmiņas pārbūve","ui.maintenance.rebuildCache.rebuildDev":"Izstrādes kešatmiņas pārbūve","ui.maintenance.rebuildCache.clearProd":"Notīrīt ražošanas kešatmiņu","ui.maintenance.rebuildCache.clearDev":"Notīrīt izstrādes kešatmiņu","ui.maintenance.installTool.title":"Contao instalēšanas rīks","ui.maintenance.installTool.description":"Contao instalēšanas rīks tiek automātiski bloķēts, ja trīs reizes pēc kārtas ievadāt nepareizu paroli.","ui.maintenance.installTool.unlock":"Atbloķēt instalēšanas rīku","ui.maintenance.installTool.lock":"Bloķēt instalēšanas rīku","ui.maintenance.dumpAutoload.title":"Composer Class Loader","ui.maintenance.dumpAutoload.description":"The Composer autoloader is responsible for PHP class loading. The autoloader must be dumped after adding custom namespaces to the root composer.json.","ui.maintenance.dumpAutoload.button":"Dump Autoloader","ui.maintenance.composerInstall.title":"Composer Dependencies","ui.maintenance.composerInstall.description":"Composer dependencies are located in the {vendor} folder in your application root. Reinstalling the dependencies can be necessary after manipulation or manually uploading the {composerLock} file.","ui.maintenance.composerInstall.button":"Palaist instalētāju","ui.maintenance.composerInstall.update":"Palaist Composer jauninājumu","ui.maintenance.composerCache.title":"Composer kešatmiņa","ui.maintenance.composerCache.description":"Composer caches downloaded packages for improved performance. If you have issues like broken files, try to delete the Composer cache to force a new download.","ui.maintenance.composerCache.button":"Iztīrīt kešatmiņu","ui.maintenance.maintenanceMode.title":"Uzturēšanas režīms","ui.maintenance.maintenanceMode.description":"Putting Contao in maintenance mode will display a \\"503 Service Unavailable\\" template for the website.","ui.maintenance.maintenanceMode.enable":"Iespējot","ui.maintenance.maintenanceMode.disable":"Atspējot","ui.maintenance.debugMode.title":"Atkļūdošanas režīms","ui.maintenance.debugMode.description":"Activate the debug mode by setting a user and password for the {appDevPhp} entry point.","ui.maintenance.debugMode.descriptionJwt":"Activate the debug mode by setting the debug cookie for the current domain.","ui.maintenance.debugMode.activate":"Aktivizēt","ui.maintenance.debugMode.deactivate":"Deaktivizēt","ui.maintenance.debugMode.credentials":"Akreditācijas dati","ui.maintenance.debugMode.user":"Lūdzu, ievadiet atkļūdošanas režīma lietotājvārdu.","ui.maintenance.debugMode.password":"Lūdzu, ievadiet paroli atkļūdošanas režīmam.","ui.maintenance.opcodeCache.title":"Opcode Cache","ui.maintenance.opcodeCache.description":"Opcode caches PHP files on the web process for faster execution. It must be deleted under certain circumstances if files are not recognized after changing.","ui.maintenance.opcodeCache.button":"Saīsināt kešatmiņu","ui.maintenance.safeMode":"Nav pieejams drošajā režīmā","ui.maintenance.unsupported":"Neatbalsta jūsu Contao versija","ui.packages.updateButton":"Atjaunināt pakotnes","ui.packages.searchButton":"Meklēt pakotnes","ui.packages.searchPlaceholder":"Meklēt pakotnes ...","ui.packages.uploadOverlay":"Lai augšupielādētu, velciet un nometiet failus","ui.packages.uploadButton":"Augšupielādēt pakotnes","ui.packages.uploadMessage":"Jums ir viena neapstiprināta augšupielāde. | Jums ir {count} neapstiprināta/u augšupielāde/žu.","ui.packages.uploadApply":"Apstiprināt augšupielādi","ui.packages.uploadReset":"Dzēst augšupielādes","ui.packages.uploadIncomplete":"Šis datne netika augšupielādēts pilnībā. Lūdzu, noņemiet to un mēģiniet vēlreiz.","ui.packages.uploadDuplicate":"Šķiet, ka šī datne ir augšupielādēts vairākas reizes. Lūdzu, izdzēsiet dublikātus.","ui.packages.uploadInstalled":"Šis datne jau ir instalēta. Lūdzu, izdzēsiet dublikātus.","ui.packages.uploadUnsupported":"Uploads are not supported in your installation. Please make sure that the PHP ZIP extension is installed and update your dependencies.","ui.packages.changesMessage":"You have one unconfirmed change. | You have {count} unconfirmed changes.","ui.packages.changesDryrun":"Dry Run","ui.packages.changesApply":"Pielietot izmaiņas","ui.packages.changesApplyAll":"Atjaunināt visas pakotnes","ui.packages.changesDryrunAll":"Dry run all packages","ui.packages.changesReset":"Atiestatīt izmaiņas","ui.packages.changesReview":"Pārskatīt izmaiņas","ui.packagelist.loading":"Ielādē ...","ui.packagelist.uploads":"Augšupielādes","ui.packagelist.added":"Jaunas pakotnes","ui.packagelist.installed":"Instalētās pakotnes","ui.package.hintRevert":"Atgriezt izmaiņas","ui.package.hintNoupdate":"Neatjaunināt","ui.package.hintConstraint":"This package will be installed with constraint {constraint} when you apply the changes.","ui.package.hintConstraintBest":"This package will be installed in the best available version when you apply the changes.","ui.package.hintConstraintChange":"The constraint for this package will be changed from \\"{from}\\" to \\"{to}\\" when you apply the changes.","ui.package.hintConstraintUpdate":"Šī pakotne tiks atjaunināta, kad piemērosiet izmaiņas.","ui.package.hintAdded":"Šī pakotne tiks instalēta, kad piemērosiet izmaiņas.","ui.package.hintRemoved":"Šī pakotne tiks noņemta, kad piemērosiet izmaiņas.","ui.package.requiredTitle":"manuāli pievienots","ui.package.requiredText":"Šī pakotne ir nepieciešama jūsu composer.json, bet nav instalēta.","ui.package.removedTitle":"manuāli noņemts","ui.package.removedText":"Šī pakotne tika noņemta no jūsu composer.json.","ui.package.installed":"Pašlaik instalēts:","ui.package.version":"Versija {version}","ui.package.additionalDownloads":"{count} Lejupielāde | {count} Lejupielādes","ui.package.additionalStars":"{count} Star | {count} Stars","ui.package.editConstraint":"Rediģēt","ui.package.uploadConstraint":"This constraint is defined by the uploaded package.","ui.package.updateButton":"Jaunināt","ui.package.removeButton":"Noņemt","ui.package.installButton":"Pievienot pakotni","ui.package.installButtonShort":"Pievienot","ui.package.detailsButton":"Sīkāka informācija","ui.package.latestConstraint":"jaunākā versija","ui.package.update":"Pieejams atjauninājums","ui.package.updateLatest":"jaunākā versija","ui.package.updateAvailable":"Pieejama {versija}","ui.package.updateUnknown":"nezināma versija","ui.package.updateConstraint":"A newer version outside your version constraint is available.","ui.package.incompatible":"{package} does not work with Contao {constraint}.","ui.cloudStatus.headline":"Composer Resolver Cloud","ui.cloudStatus.version":"Versija {version}","ui.cloudStatus.waitingTime":"Gaidīšanas laiks","ui.cloudStatus.jobs":"Pašreizējie darbi","ui.cloudStatus.workers":"Strādnieki","ui.cloudStatus.approx":"{minutes} min","ui.cloudStatus.none":"nav","ui.cloudStatus.short":"apt. {minutes} min","ui.cloudStatus.long":"apt. {minutes} min {seconds} sek","ui.cloudStatus.error":"Unable to fetch the status of the Composer Resolver Cloud. It might be down for maintenance or experience issues.","ui.cloudStatus.button":"Mākoņa statuss","ui.cloudStatus.refresh":"Atjaunināt mākoņa statusu","ui.log-viewer.loading":"Ielādē ...","ui.log-viewer.empty":"There are no log files on your server.","ui.log-viewer.reload":"Pārlādēt","ui.log-viewer.file":"Žurnāla datne","ui.log-viewer.channel":"Kanāls","ui.log-viewer.channelTitle":"The channel this message was logged to.","ui.log-viewer.level":"Līmenis","ui.log-viewer.levelTitle":"Severity of the log message.","ui.log-viewer.timeHeader":"Laiks","ui.log-viewer.messageHeader":"Ziņa","ui.log-viewer.showContext":"Rādīt kontekstu","ui.log-viewer.hideContext":"Slēpt kontekstu","ui.log-viewer.showExtra":"Show Extra","ui.log-viewer.hideExtra":"Hide Extra","ui.log-viewer.more":"Load more …","ui.log-viewer.download":"Lejupielādēt","ui.log-viewer.downloadTitle":"Lejupielādēt datni \\"{file}\\"","ui.log-viewer.prodEnvironment":"Production Environment","ui.log-viewer.devEnvironment":"Development Environment (Debug Mode)","ui.user-manager.loading":"Loading users …","ui.user-manager.changePassword":"Mainīt paroli","ui.user-manager.setupTotp":"Divfaktoru autentifikācijas iestatīšana","ui.user-manager.disableTotp":"Atspējot divfaktoru autentifikāciju","ui.user-manager.invite":"Uzaicināt lietotāju","ui.user-manager.delete":"Dzēst","ui.user-manager.deleteConfirm":"Vai tiešām vēlaties dzēst lietotāju “{username}”?","ui.user-manager.deleted":"Lietotājs {username} veiksmīgi dzēsts","ui.user-manager.passwordHeadline":"Mainīt paroli","ui.user-manager.passwordText":"To change your password, please enter the current and a new password in the respective fields.","ui.user-manager.currentPassword":"Pašreizējā parole","ui.user-manager.newPassword":"Jauna parole","ui.user-manager.passwordPlaceholder":"min. 8 rakstzīmes","ui.user-manager.submitPassword":"Iesniegt","ui.user-manager.passwordChanged":"Jūsu parole ir veiksmīgi nomainīta.","ui.user-manager.passwordError":"Šī parole ir nepareiza.","ui.user-manager.inviteHeadline":"Uzaicināt lietotāju","ui.user-manager.inviteText":"If you need multiple logins for the Contao Manager, you can create an invitation link here. Share this link with someone or use it on another device to create a new account with the given permissions.","ui.user-manager.inviteSuccess1":"A new invitation link was created. The URL below can be used to create a new user account for this Contao Manager. The invitation expires on {expires} (one week from now).","ui.user-manager.inviteSuccess2":"Please copy the link to your clipboard. It will only work once and you will not be able to see it again after closing this dialog.","ui.user-manager.createInvitation":"Izveidot ielūguma saiti","ui.user-manager.clipboard":"Kopēt uz starpliktuvi","ui.user-manager.permissions":"Uzzināt par atļaujām","ui.user-manager.cancel":"Atcelt","ui.user-manager.close":"Aizvērt","ui.user-manager.you":"Jūs","ui.user-manager.2fa":"2FA","ui.user-manager.2faEnabled":"This account is secured by two-factor authentication.","ui.user-manager.2faDisabled":"This account is insecure due to missing two-factor authentication.","ui.user-manager.passkey":"Passkey","ui.user-manager.passkeyTitle":"This account is secured by a Passkey.","ui.totp.headline":"Divfaktoru autentifikācija","ui.totp.setupQr":"Please scan the QR code with your 2FA/TOTP app.","ui.totp.setupCode":"If you cannot scan the QR code, enter this key instead:","ui.totp.codeLabel":"Verifikācijas kods","ui.totp.codeDescription":"Please enter the verification code generated by your 2FA/TOTP app.","ui.totp.disableText":"Please enter the verification code to disable two-factor authentication.","ui.totp.invalid":"Verifikācijas kods ir nederīgs.","ui.totp.enable":"Iespējot","ui.totp.disable":"Atspējot","ui.totp.cancel":"Atcelt","ui.totp.enabled":"Two-factor authentication was enabled successfully.","ui.totp.disabled":"Two-factor authentication was disabled successfully.","ui.totp.setup":"Iestatīt divfaktoru autentifikāciju","ui.totp.skip":"Izlaist divfaktoru autentifikāciju"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[335],{1035:function(e,s,c){c.r(s),c.d(s,{default:function(){return V}});var i=c(641),l=c(33),o=c(3751),t=c.p+"img/server-config.1a2d0888.svg";const n={class:"config-check__header"},r={class:"config-check__headline"},a={class:"config-check__description"},d={class:"config-check__form"},u={class:"config-check__fields"},g={class:"config-check__fieldtitle"},h={class:"config-check__fielddesc"},f={class:"config-check__fields"},_={class:"config-check__fieldtitle"},p={class:"config-check__fielddesc"},k={key:0,class:"config-check__issues"},v=["disabled"];function b(e,s,c,b,m,L){const $=(0,i.g2)("text-field"),w=(0,i.g2)("check-box"),C=(0,i.g2)("loading-button"),x=(0,i.g2)("boxed-layout");return(0,i.uX)(),(0,i.Wv)(x,{wide:!0,slotClass:"config-check"},{default:(0,i.k6)((()=>[(0,i.Lk)("header",n,[s[4]||(s[4]=(0,i.Lk)("img",{src:t,width:"80",height:"80",class:"config-check__icon",alt:""},null,-1)),(0,i.Lk)("h1",r,(0,l.v_)(e.$t("ui.server.config.title")),1),(0,i.Lk)("p",a,(0,l.v_)(e.$t("ui.server.config.description")),1)]),(0,i.Lk)("main",d,[(0,i.Lk)("form",{onSubmit:s[3]||(s[3]=(0,o.D$)(((...e)=>L.save&&L.save(...e)),["prevent"]))},[(0,i.Lk)("fieldset",u,[(0,i.Lk)("legend",g,(0,l.v_)(e.$t("ui.server.config.formTitle")),1),(0,i.Lk)("p",h,(0,l.v_)(e.$t("ui.server.config.formText")),1),(0,i.bF)($,{ref:"cli",name:"php_cli",label:e.$t("ui.server.config.cli"),required:"",disabled:e.processing,error:e.error,modelValue:e.php_cli,"onUpdate:modelValue":s[0]||(s[0]=s=>e.php_cli=s)},null,8,["label","disabled","error","modelValue"])]),(0,i.Lk)("fieldset",f,[(0,i.Lk)("legend",_,(0,l.v_)(e.$t("ui.server.config.cloudTitle")),1),(0,i.Lk)("p",p,(0,l.v_)(e.$t("ui.server.config.cloudText")),1),e.cloudIssues&&e.cloudIssues.length?((0,i.uX)(),(0,i.CE)("div",k,[(0,i.Lk)("p",null,(0,l.v_)(e.$t("ui.server.config.stateErrorCloud")),1),(0,i.Lk)("ul",null,[((0,i.uX)(!0),(0,i.CE)(i.FK,null,(0,i.pI)(e.cloudIssues,((e,s)=>((0,i.uX)(),(0,i.CE)("li",{key:s},(0,l.v_)(e),1)))),128))])])):(0,i.Q3)("",!0),(0,i.bF)(w,{name:"cloud",label:e.$t("ui.server.config.cloud"),disabled:e.processing,modelValue:e.cloud,"onUpdate:modelValue":s[1]||(s[1]=s=>e.cloud=s)},null,8,["label","disabled","modelValue"])]),(0,i.bF)(C,{submit:"",color:"primary",disabled:!e.php_cli,loading:e.processing},{default:(0,i.k6)((()=>[(0,i.eW)((0,l.v_)(e.$t("ui.server.config.save")),1)])),_:1},8,["disabled","loading"]),(0,i.Lk)("button",{type:"button",class:"widget-button",disabled:e.processing,onClick:s[2]||(s[2]=(...e)=>L.cancel&&L.cancel(...e))},(0,l.v_)(e.$t("ui.server.config.cancel")),9,v)],32)])])),_:1})}var m=c(728),L=c(9757),$=c(3480),w=c(85),C=c(707),x={components:{BoxedLayout:m.A,TextField:L.A,CheckBox:$.A,LoadingButton:w.A},data:()=>({processing:!0,error:"",php_cli:"",cloud:!0,cloudIssues:[]}),methods:{async save(){this.processing=!0,this.error="";const e={php_cli:this.php_cli,cloud:this.cloud},s=await this.$store.dispatch("server/config/set",e);400===s.status&&s.detail?(this.error=s.detail,this.processing=!1,setTimeout((()=>{this.$refs.cli.focus()}),0)):window.location.reload(!0)},cancel(){this.$store.commit("setView",C.A.BOOT)}},async mounted(){const e=await this.$store.dispatch("server/config/get");this.php_cli=e.php_cli,this.cloud=e.cloud.enabled,this.cloudIssues=e.cloud.issues,this.processing=!1}},y=c(6262);const T=(0,y.A)(x,[["render",b]]);var V=T}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[367],{7390:function(e,r,t){t.r(r),t.d(r,{default:function(){return b}});var o=t(641),i=t(33),a=t.p+"img/recovery.70ee118a.svg";const s={class:"view-recovery__header"},n={class:"view-recovery__headline"},c={class:"view-recovery__content"},l={class:"view-recovery__description"},d={class:"view-recovery__description"},u={class:"view-recovery__option"},v={key:0,class:"view-recovery__failed"},p={class:"view-recovery__option"},h=["disabled"];function _(e,r,t,_,k,y){const w=(0,o.g2)("console-output"),m=(0,o.g2)("loading-button"),f=(0,o.g2)("boxed-layout");return(0,o.uX)(),(0,o.Wv)(f,{wide:!0,slotClass:"view-recovery"},{default:(0,o.k6)((()=>[(0,o.Lk)("header",s,[r[1]||(r[1]=(0,o.Lk)("img",{src:a,width:"80",height:"80",alt:"",class:"view-recovery__icon"},null,-1)),(0,o.Lk)("h1",n,(0,i.v_)(e.$t("ui.recovery.headline")),1)]),(0,o.Lk)("main",c,[(0,o.Lk)("p",l,(0,i.v_)(e.$t("ui.recovery.description")),1),console?((0,o.uX)(),(0,o.Wv)(w,{key:0,class:"view-recovery__console",title:e.$t("ui.recovery.console"),operations:[{status:"error",summary:"vendor/bin/contao-console list",console:this.error}],"console-output":e.error,"show-console":"","force-console":""},null,8,["title","operations","console-output"])):(0,o.Q3)("",!0),(0,o.Lk)("p",d,(0,i.v_)(e.$t("ui.recovery.repairOptions")),1),(0,o.Lk)("div",u,[(0,o.Lk)("h3",null,(0,i.v_)(e.$t("ui.recovery.repairHeadline")),1),(0,o.Lk)("p",null,(0,i.v_)(e.$t("ui.recovery.repairDescription")),1),(0,o.Lk)("p",null,[(0,o.Lk)("strong",null,(0,i.v_)(e.$t("ui.recovery.repairWarning")),1)]),e.repairFailed?((0,o.uX)(),(0,o.CE)("p",v,(0,i.v_)(e.$t("ui.recovery.repairFailed")),1)):(0,o.Q3)("",!0),(0,o.bF)(m,{inline:"",color:"alert",icon:"run",disabled:e.repairFailed,loading:e.repairStarted&&!e.repairFailed,onClick:y.runRepair},{default:(0,o.k6)((()=>[(0,o.eW)((0,i.v_)(e.$t("ui.recovery.repairButton")),1)])),_:1},8,["disabled","loading","onClick"])]),(0,o.Lk)("div",p,[(0,o.Lk)("h3",null,(0,i.v_)(e.$t("ui.recovery.safeModeHeadline")),1),(0,o.Lk)("p",null,(0,i.v_)(e.$t("ui.recovery.safeModeDescription")),1),(0,o.Lk)("button",{class:"widget-button widget-button--inline widget-button--primary",disabled:e.repairStarted&&!e.repairFailed,onClick:r[0]||(r[0]=(...e)=>y.runSafeMode&&y.runSafeMode(...e))},(0,i.v_)(e.$t("ui.recovery.safeModeButton")),9,h)])])])),_:1})}var k=t(6278),y=t(707),w=t(728),m=t(85),f=t(2864),g={components:{BoxedLayout:w.A,LoadingButton:m.A,ConsoleOutput:f.A},data:()=>({repairStarted:!1,repairFailed:!1,error:""}),computed:{...(0,k.aH)("tasks",{taskStatus:"status"})},methods:{async runRepair(){let e;this.repairStarted=!0;const r=[{name:"contao/rebuild-cache"},{name:"composer/install"},{name:"composer/install",config:{"remove-vendor":!0}}];while(void 0!==(e=r.shift()))try{return await this.$store.dispatch("tasks/execute",e),await this.$store.dispatch("tasks/deleteCurrent"),void window.location.reload(!0)}catch(t){if("failed"===this.taskStatus){await this.$store.dispatch("tasks/deleteCurrent");break}await this.$store.dispatch("tasks/deleteCurrent")}this.repairFailed=!0},runSafeMode(){this.$store.commit("setSafeMode",!0),this.$store.commit("setView",y.A.READY)}},async mounted(){const e=await this.$store.dispatch("server/contao/get");502===e.status&&e.data.error&&(this.error=e.data.error)}},$=t(6262);const L=(0,$.A)(g,[["render",_]]);var b=L}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[542],{7542:function(e){e.exports=JSON.parse('{"ui.app.title":"Contao 扩展","ui.app.loading":"扩展列表加载中 …","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Advertisement in the extension list","ui.discover.loading":"加载 …","ui.discover.offline":"无法获取任何结果","ui.discover.offlineExplain":"检查网络连接并在浏览器中禁用JavaScript拦截器。","ui.discover.offlineButton":"重试","ui.discover.searchPlaceholder":"Search in {count} extensions …","ui.discover.empty":"No results for {query}","ui.discover.more":"更多","ui.discover.sortBy":"排序","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"已更新","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"下载","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"评级","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"详情","ui.discover.latestPackages":"最新和已更新扩展","ui.discover.faversPackages":"最高评级扩展","ui.discover.downloadsPackages":"下载最多扩展","ui.discover.exactHit":"Exact query match","ui.discover.results":"More search results","ui.package.homepage":"项目网站","ui.package.private":"私有包","ui.package.privateTitle":"私有包仅可从提供商获取 (e.g. ZIP 下载)。请访问网站获取更多信息。","ui.package.abandoned":"放弃","ui.package.abandonedText":"该程序包已放弃不再维护。","ui.package.abandonedReplace":"该程序包已放弃不再维护。作者建议使用 {replacement} 包替代.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"以前的扩展详细信息","ui.package-details.close":"关闭扩展详情","ui.package-details.loading":"加载 …","ui.package-details.tabDescription":"描述","ui.package-details.tabRequire":"需求","ui.package-details.tabFeatures":"特征","ui.package-details.tabSuggest":"建议","ui.package-details.tabConflict":"冲突","ui.package-details.tabDependents":"依赖","ui.package-details.linkRequires":"需要","ui.package-details.linkReplaces":"替换","ui.package-details.linkProvides":"提供","ui.package-details.linkConflicts":"冲突","ui.package-details.funding":"Fund package maintenance!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"最新版","ui.package-details.released":"发布于","ui.package-details.license":"许可(s)","ui.package-details.authors":"from","ui.package-details.more":"更多","ui.package-details.packagist":"包详情","ui.package-details.metadata":"编辑元数据","ui.package-details.support_docs":"文档","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"支持论坛","ui.package-details.support_issues":"问题 / 错误 报告","ui.package-details.support_source":"源代码","ui.package-details.support_irc":"IRC / 聊天","ui.package-details.support_email":"支持 E-Mail","ui.package-details.support_rss":"RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[874],{2874:function(e){e.exports=JSON.parse('{"ui.app.title":"Rozšíření Contaa","ui.app.loading":"Načítání seznamu rozšíření...","ui.app.language":"Změnit jazyk Správce Contaa","ui.app.colorDark":"Tmavé zobrazení","ui.app.colorDarkTitle":"Změnit na tmavé prostředí","ui.app.colorLight":"Světlé zobrazení","ui.app.colorLightTitle":"Změnit na světlé prostředí","ui.discover.advertisement":"Reklama v seznamu rozšíření","ui.discover.loading":"Spouštění…","ui.discover.offline":"Nemůžu načíst žádné výsledky.","ui.discover.offlineExplain":"Zkontrolujte prosím Vaše internetové připojení a deaktivujte blokování JavaScriptu ve Vašem prohlížeči.","ui.discover.offlineButton":"Zkusit znovu","ui.discover.searchPlaceholder":"Prohledat {count} rozšíření...","ui.discover.empty":"Žádné výsledky pro {query}","ui.discover.more":"Více výsledků","ui.discover.sortBy":"Seřadit podle","ui.discover.sortReleased":"Zveřejněno","ui.discover.sortReleasedTitle":"Seřadit výsledky podle zveřejnění","ui.discover.sortLatest":"Zaktualizované","ui.discover.sortLatestTitle":"Seřadit výsledky podle naposledy zaktualizovaných","ui.discover.sortDownloads":"Stažení","ui.discover.sortDownloadsTitle":"Seřadit výsledky podle počtu stažení","ui.discover.sortFavers":"Hodnocení","ui.discover.sortFaversTitle":"Seřadit výsledky podle hodnocení","ui.discover.detailsButton":"Podrobnosti","ui.discover.latestPackages":"Poslední a naposledy zaktualizovaná rozšíření","ui.discover.faversPackages":"Nejlépe hodnocená rozšíření","ui.discover.downloadsPackages":"Nejvíce stahovaná rozšíření","ui.discover.exactHit":"Exact query match","ui.discover.results":"More search results","ui.package.homepage":"Stránka projektu","ui.package.private":"Soukromý balíček","ui.package.privateTitle":"Soukromé balíčky jsou dostupné pouze z vendoru (např. jako soubor ZIP). Více informací získáte na následujícím webu. ","ui.package.abandoned":"nepřijatý","ui.package.abandonedText":"Tento balíček je označený jako nepřijatý a již se dál vyvíjí.","ui.package.abandonedReplace":"Tento balíček je označený jako nepřijatý a již se dál vyvíjí. Autor místo něho doporučuje použít {replacement}. ","ui.package.contaoVersion":"Dostupné pro Contao","ui.package-details.previous":"Předešlé podrobné informace k rozšíření","ui.package-details.close":"Zavřít podrobné informace k rozšíření","ui.package-details.loading":"Spouštění…","ui.package-details.tabDescription":"Popis","ui.package-details.tabRequire":"Požadavky","ui.package-details.tabFeatures":"Funkce","ui.package-details.tabSuggest":"Doporučení","ui.package-details.tabConflict":"Konflikty","ui.package-details.tabDependents":"Závislosti","ui.package-details.linkRequires":"vyžaduje","ui.package-details.linkReplaces":"nahrazuje","ui.package-details.linkProvides":"poskytuje","ui.package-details.linkConflicts":"konflikty","ui.package-details.funding":"Nalezen vyvíjený balíček!","ui.package-details.contaoVersions":"Podporováno verzí Contaa","ui.package-details.latest":"Poslední verze","ui.package-details.released":"Zveřejněno","ui.package-details.license":"Licence","ui.package-details.authors":"od","ui.package-details.more":"Více","ui.package-details.packagist":"Podrobnosti k balíčku","ui.package-details.metadata":"Upravit meta informace","ui.package-details.support_docs":"Dokumentace","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Podpora ve fóru","ui.package-details.support_issues":"Chyby / nahlášení chyb","ui.package-details.support_source":"Zdrojový kód","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Mail podpory","ui.package-details.support_rss":"Kanál RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[180],{2180:function(e){e.exports=JSON.parse('{"ui.app.title":"Extensiones Contao","ui.app.loading":"Cargando lista de extensiones ...","ui.app.language":"Cambiar idioma para el Contao Manager","ui.app.colorDark":"Modo oscuro","ui.app.colorDarkTitle":"Cambiar el esquema de color a oscuro","ui.app.colorLight":"Modo claro","ui.app.colorLightTitle":"Cambiar el esquema de color a claro","ui.discover.advertisement":"Aviso en la lista de extensiones","ui.discover.loading":"Cargando ...","ui.discover.offline":"No se pudo obtener ningún resultado.","ui.discover.offlineExplain":"Verifique su conexión a Internet y desactive los bloqueadores de JavaScript en su navegador.","ui.discover.offlineButton":"Inténtelo de nuevo","ui.discover.searchPlaceholder":"Buscar en {count} extensiones…","ui.discover.empty":"No hay resultados para {query}","ui.discover.more":"Más resultados","ui.discover.sortBy":"Ordenar por","ui.discover.sortReleased":"Publicado","ui.discover.sortReleasedTitle":"Ordenar resultados por fecha de lanzamiento","ui.discover.sortLatest":"Actualizado","ui.discover.sortLatestTitle":"Ordenar resultados por última actualización","ui.discover.sortDownloads":"Descargas","ui.discover.sortDownloadsTitle":"Ordenar resultados por número de descargas","ui.discover.sortFavers":"Clasificación","ui.discover.sortFaversTitle":"Ordenar resultados por calificación","ui.discover.detailsButton":"Detalles","ui.discover.latestPackages":"Extensiones más recientes y actualizadas","ui.discover.faversPackages":"Extensiones mejor calificadas","ui.discover.downloadsPackages":"Extensiones más descargadas","ui.discover.exactHit":"Exact query match","ui.discover.results":"More search results","ui.package.homepage":"Sitio web del proyecto","ui.package.private":"Paquete privado","ui.package.privateTitle":"Los paquetes privados solo están disponibles por parte del proveedor (por ejemplo, como descarga ZIP). Por favor, visite el sitio web para más información.","ui.package.abandoned":"abandonado","ui.package.abandonedText":"Este paquete está abandonado y ya no se mantiene.","ui.package.abandonedReplace":"su paquete es abandonado y ya no se mantiene. El autor sugiere usar el paquete {replacement} en su lugar.","ui.package.contaoVersion":"Disponible para Contao","ui.package-details.previous":"Detalles de extensiones anteriores","ui.package-details.close":"Cerrar detalles de extensión","ui.package-details.loading":"Cargando ...","ui.package-details.tabDescription":"Descripción","ui.package-details.tabRequire":"Requisitos","ui.package-details.tabFeatures":"Caracteristicas","ui.package-details.tabSuggest":"Sugerencias","ui.package-details.tabConflict":"Conflictos","ui.package-details.tabDependents":"Dependientes","ui.package-details.linkRequires":"requiere","ui.package-details.linkReplaces":"reemplaza","ui.package-details.linkProvides":"provee","ui.package-details.linkConflicts":"conflictos","ui.package-details.funding":"Mantenimiento del Fund Package!","ui.package-details.contaoVersions":"Version(es) compatible(s) de Contao","ui.package-details.latest":"Última versión","ui.package-details.released":"publicado el","ui.package-details.license":"Licencia(s)","ui.package-details.authors":"de","ui.package-details.more":"Más","ui.package-details.packagist":"Detalles del paquete","ui.package-details.metadata":"Editar metadatos","ui.package-details.support_docs":"Documentación","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Foro de sopporte","ui.package-details.support_issues":"Problemas / Informe de error","ui.package-details.support_source":"Código fuente","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Email del soporte ","ui.package-details.support_rss":"RSS Feed"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[716],{3716:function(e){e.exports=JSON.parse('{"ui.app.title":"Rozszerzenia Contao","ui.app.loading":"Ładowanie listy rozszerzeń …","ui.app.language":"Switch language for the Contao Manager","ui.app.colorDark":"Dark Mode","ui.app.colorDarkTitle":"Switch color scheme to dark","ui.app.colorLight":"Light Mode","ui.app.colorLightTitle":"Switch color scheme to light","ui.discover.advertisement":"Reklama w liście rozszerzeń","ui.discover.loading":"Ładowanie …","ui.discover.offline":"Nie znaleziono żadnych wyników.","ui.discover.offlineExplain":"Sprawdź swoje połączenie internetowe i wyłącz narzędzia blokujące JavaScript w przeglądarce.","ui.discover.offlineButton":"Spróbuj ponownie","ui.discover.searchPlaceholder":"Szukaj w {count} rozszerzeniach ...","ui.discover.empty":"Brak wyników dla {query}","ui.discover.more":"Więcej Wyników","ui.discover.sortBy":"Sortuj według","ui.discover.sortReleased":"Released","ui.discover.sortReleasedTitle":"Sort results by release date","ui.discover.sortLatest":"Data aktualizacji","ui.discover.sortLatestTitle":"Sort results by last updated","ui.discover.sortDownloads":"Pobrania","ui.discover.sortDownloadsTitle":"Sort results by number of downloads","ui.discover.sortFavers":"Ocena","ui.discover.sortFaversTitle":"Sort results by rating","ui.discover.detailsButton":"Szczegóły","ui.discover.latestPackages":"Najnowsze i zaktualizowane rozszerzenia","ui.discover.faversPackages":"Najwyżej oceniane rozszerzenia","ui.discover.downloadsPackages":"Najczęściej pobierane rozszerzenia","ui.discover.exactHit":"Exact query match","ui.discover.results":"More search results","ui.package.homepage":"Strona Projektu","ui.package.private":"Prywatny Pakiet","ui.package.privateTitle":"Prywatne pakiety są dostępne tylko bezpośrednio od dostawcy (np. jako plik ZIP). Odwiedź stronę po więcej informacji.","ui.package.abandoned":"porzucony","ui.package.abandonedText":"Ten pakiet jest porzucony i nie jest już wspierany.","ui.package.abandonedReplace":"Ten pakiet jest porzucony i nie jest już wspierany. Autor sugeruje użycie pakietu {replacement} zamiast niego.","ui.package.contaoVersion":"Available for Contao","ui.package-details.previous":"Szczegóły poprzedniego rozszerzenia","ui.package-details.close":"Zamknij szczegóły rozszerzenia","ui.package-details.loading":"Ładowanie …","ui.package-details.tabDescription":"Opis","ui.package-details.tabRequire":"Wymagania","ui.package-details.tabFeatures":"Funkcjonalności","ui.package-details.tabSuggest":"Sugestie","ui.package-details.tabConflict":"Konflikty","ui.package-details.tabDependents":"Zależności","ui.package-details.linkRequires":"wymaga","ui.package-details.linkReplaces":"zastępuje","ui.package-details.linkProvides":"dostarcza","ui.package-details.linkConflicts":"koliduje","ui.package-details.funding":"Finansuj rozwój pakietu!","ui.package-details.contaoVersions":"Supported Contao version(s)","ui.package-details.latest":"Ostatnia wersja","ui.package-details.released":"data wydania","ui.package-details.license":"Licencje","ui.package-details.authors":"od","ui.package-details.more":"Więcej","ui.package-details.packagist":"Szczegóły Pakietu","ui.package-details.metadata":"Edytuj metadane","ui.package-details.support_docs":"Dokumentacja","ui.package-details.support_wiki":"Wiki","ui.package-details.support_forum":"Forum","ui.package-details.support_issues":"Issues / Bug Report","ui.package-details.support_source":"Kod źródłowy","ui.package-details.support_irc":"IRC / Chat","ui.package-details.support_email":"Wsparcie E-mail","ui.package-details.support_rss":"Kanał RSS"}')}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[474],{1474:function(a,e,t){t.r(e),t.d(e,{default:function(){return Ba}});var s=t(641),n=t(33);const i={class:"package-popup__installed"},l=["dateTime","title"],o=["href"],p={key:3},c={class:"package-popup__update"},r={class:"package-popup__incompatible"};function u(a,e,t,u,d,k){const g=(0,s.g2)("package-constraint"),m=(0,s.g2)("install-button"),h=(0,s.g2)("package-details",!0);return(0,s.uX)(),(0,s.Wv)(h,{local:k.data,dependents:k.dependents},(0,s.eX)({"package-actions":(0,s.k6)((()=>[(0,s.RG)(a.$slots,"package-actions",{},(()=>[a.isInstalled?((0,s.uX)(),(0,s.CE)(s.FK,{key:0},[!a.isFeature&&a.isVisible?((0,s.uX)(),(0,s.Wv)(g,{key:0,data:k.data},null,8,["data"])):(0,s.Q3)("",!0),(0,s.Lk)("p",i,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package.installed")),1),a.installedTime?((0,s.uX)(),(0,s.CE)("time",{key:0,dateTime:a.installedTime,title:k.datimFormat(a.installedTime)},(0,n.v_)(a.$t("ui.package.version",{version:a.installedVersion})),9,l)):((0,s.uX)(),(0,s.CE)(s.FK,{key:1},[(0,s.eW)((0,n.v_)(a.$t("ui.package.version",{version:a.installedVersion})),1)],64))])],64)):a.canBeInstalled||a.isRequired?((0,s.uX)(),(0,s.CE)(s.FK,{key:1},[(0,s.bF)(m,{data:k.data},null,8,["data"]),a.isAdded||a.isRequired?((0,s.uX)(),(0,s.Wv)(g,{key:0,data:k.data},null,8,["data"])):(0,s.Q3)("",!0)],64)):a.isPrivate?((0,s.uX)(),(0,s.CE)("a",{key:2,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:a.metadata.homepage},(0,n.v_)(a.$t("ui.package.homepage")),9,o)):((0,s.uX)(),(0,s.CE)("div",p))]))])),"suggest-actions":(0,s.k6)((({name:e})=>[a.packageSuggested(e)?((0,s.uX)(),(0,s.Wv)(m,{key:0,inline:"",small:"",data:{name:e}},null,8,["data"])):(0,s.Q3)("",!0)])),"features-actions":(0,s.k6)((({name:e})=>[!a.hasRoot||a.packageInstalled(e)||a.packageRoot(e)?(0,s.Q3)("",!0):((0,s.uX)(),(0,s.Wv)(m,{key:0,inline:"",small:"",data:{name:e}},null,8,["data"]))])),_:2},[a.metadata.update&&a.metadata.update.valid&&!a.metadata.update.latest?{name:"package-update",fn:(0,s.k6)((()=>[(0,s.Lk)("p",c,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package.update"))+":",1),(0,s.eW)(" "+(0,n.v_)(a.$t("ui.package.version",{version:a.metadata.update.version}))+" ("+(0,n.v_)(a.$t("ui.package-details.released"))+" "+(0,n.v_)(k.datimFormat(a.metadata.update.time,"short","long"))+") ",1)])])),key:"0"}:a.isCompatible?void 0:{name:"package-update",fn:(0,s.k6)((()=>[(0,s.Lk)("p",r,(0,n.v_)(a.$t("ui.package.incompatible",{package:k.data.name,constraint:a.packageConstraint("contao/manager-bundle")})),1)])),key:"1"}]),1032,["local","dependents"])}t(8111),t(7588);var d=t(6278),k=t(4210),g=t(8200);const m={class:"package-popup__headline"},h=["title"],_=["title"],v={key:0,class:"package-popup__loader"},b={class:"package-popup__summary"},f={class:"package-popup__text"},y={class:"package-popup__title"},$={key:0,class:"package-popup__authors"},C=["href"],X={class:"package-popup__statistics"},E=["title"],L={key:1,class:"package-popup__stats package-popup__stats--updated"},w={key:2,class:"package-popup__stats package-popup__stats--downloads"},F={key:3,class:"package-popup__stats package-popup__stats--favers"},A={class:"package-popup__actions"},W=["href"],Q=["href"],T={class:"package-popup__tabs"},x={class:"package-popup__tabs-list"},P={key:0,class:"package-popup__abandoned"},R={key:2},q={key:3},B={key:4},I={class:"package-popup__description"};function G(a,e,t,i,l,o){const p=(0,s.g2)("loading-spinner"),c=(0,s.g2)("package-logo"),r=(0,s.g2)("more-links"),u=(0,s.g2)("details-tab"),d=(0,s.g2)("router-link"),k=(0,s.g2)("i18n-t"),g=(0,s.g2)("package-funding"),G=(0,s.g2)("details-content"),O=(0,s.g2)("popup-overlay");return(0,s.uX)(),(0,s.Wv)(O,{fixed:!0,"popup-class":"package-popup",tabindex:"-1",onClear:e[8]||(e[8]=e=>a.clearCurrent())},{content:(0,s.k6)((()=>[(0,s.Lk)("div",m,[a.hasPrevious?((0,s.uX)(),(0,s.CE)("button",{key:0,class:"package-popup__button package-popup__button--previous",title:a.$t("ui.package-details.previous"),onClick:e[0]||(e[0]=e=>a.$router.go(-1))},e[9]||(e[9]=[(0,s.Lk)("svg",{xmlns:"http://www.w3.org/2000/svg",fill:"#fff",width:"24",height:"24",viewBox:"0 0 24 24"},[(0,s.Lk)("path",{d:"M0 0h24v24H0z",fill:"none"}),(0,s.Lk)("path",{d:"M21 11H6.83l3.58-3.59L9 6l-6 6 6 6 1.41-1.41L6.83 13H21z"})],-1)]),8,h)):(0,s.Q3)("",!0),(0,s.eW)(" "+(0,n.v_)(o.data.name)+" ",1),(0,s.Lk)("button",{class:"package-popup__button package-popup__button--close",title:a.$t("ui.package-details.close"),onClick:e[1]||(e[1]=e=>a.clearCurrent())},e[10]||(e[10]=[(0,s.Lk)("svg",{height:"24",viewBox:"0 0 24 24",width:"24",fill:"#fff",xmlns:"http://www.w3.org/2000/svg"},[(0,s.Lk)("path",{d:"M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z"}),(0,s.Lk)("path",{d:"M0 0h24v24H0z",fill:"none"})],-1)]),8,_)]),a.metadata&&a.metadata.hasOwnProperty("name")?((0,s.uX)(),(0,s.CE)(s.FK,{key:1},[(0,s.Lk)("div",b,[(0,s.bF)(c,{class:"package-popup__logo","component-class":"package-popup__icon",src:a.metadata.logo},null,8,["src"]),(0,s.Lk)("div",f,[(0,s.Lk)("h1",y,(0,n.v_)(a.metadata.title||o.data.name),1),o.authors?((0,s.uX)(),(0,s.CE)("p",$,[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.authors"))+" ",1),((0,s.uX)(!0),(0,s.CE)(s.FK,null,(0,s.pI)(o.authors,((a,e)=>((0,s.uX)(),(0,s.CE)(s.FK,null,[a.homepage?((0,s.uX)(),(0,s.CE)("a",{class:"package-popup__author",key:e,href:a.homepage,target:"_blank",rel:"noreferrer noopener"},(0,n.v_)(a.name),9,C)):((0,s.uX)(),(0,s.CE)("span",{class:"package-popup__author",key:e},(0,n.v_)(a.name),1))],64)))),256))])):(0,s.Q3)("",!0),(0,s.Lk)("p",X,[a.metadata.private?((0,s.uX)(),(0,s.CE)("span",{key:0,class:"package-popup__stats package-popup__stats--private",title:a.$t("ui.package.privateTitle")},(0,n.v_)(a.$t("ui.package.private")),9,E)):(0,s.Q3)("",!0),a.metadata.updated?((0,s.uX)(),(0,s.CE)("span",L,(0,n.v_)(o.datimFormat(a.metadata.updated,!1)),1)):(0,s.Q3)("",!0),a.metadata.downloads>0?((0,s.uX)(),(0,s.CE)("span",w,(0,n.v_)(o.numberFormat(a.metadata.downloads)),1)):(0,s.Q3)("",!0),a.metadata.favers>0?((0,s.uX)(),(0,s.CE)("span",F,(0,n.v_)(o.numberFormat(a.metadata.favers)),1)):(0,s.Q3)("",!0),(0,s.bF)(r,{name:a.metadata.name,homepage:a.metadata.homepage,support:Object.assign({},a.metadata.support),metadata:a.metadata.metadata,"hide-packagist":a.metadata.private},null,8,["name","homepage","support","metadata","hide-packagist"])])]),(0,s.Lk)("div",A,[(0,s.RG)(a.$slots,"package-actions",(0,n._B)((0,s.Ng)({data:a.metadata})),(()=>[a.metadata&&a.metadata.homepage?((0,s.uX)(),(0,s.CE)("a",{key:0,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:a.metadata.homepage},(0,n.v_)(a.$t("ui.package.homepage")),9,W)):a.metadata.private?(0,s.Q3)("",!0):((0,s.uX)(),(0,s.CE)("a",{key:1,class:"widget-button widget-button--primary widget-button--link",target:"_blank",href:`https://packagist.org/packages/${o.data.name}`},(0,n.v_)(a.$t("ui.package-details.packagist")),9,Q))]))])]),(0,s.Lk)("div",T,[(0,s.Lk)("ul",x,[(0,s.bF)(u,{"show-empty":"",links:!1,active:""===o.tab,onClick:e[2]||(e[2]=a=>o.setTab(""))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabDescription")),1)])),_:1},8,["active"]),a.metadata.features?((0,s.uX)(),(0,s.Wv)(u,{key:0,highlight:"",links:a.metadata.features,active:"features"===o.tab,onClick:e[3]||(e[3]=a=>o.setTab("features"))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabFeatures")),1)])),_:1},8,["links","active"])):(0,s.Q3)("",!0),(0,s.bF)(u,{highlight:"",active:"suggest"===o.tab,links:a.metadata.suggest,onClick:e[4]||(e[4]=a=>o.setTab("suggest"))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabSuggest")),1)])),_:1},8,["active","links"]),(0,s.bF)(u,{"show-empty":"",active:"require"===o.tab,links:a.metadata.require,onClick:e[5]||(e[5]=a=>o.setTab("require"))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabRequire")),1)])),_:1},8,["active","links"]),(0,s.bF)(u,{"show-empty":"",active:"conflict"===o.tab,links:a.metadata.conflict,onClick:e[6]||(e[6]=a=>o.setTab("conflict"))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabConflict")),1)])),_:1},8,["active","links"]),t.dependents?((0,s.uX)(),(0,s.Wv)(u,{key:1,active:"dependents"===o.tab,links:t.dependents,onClick:e[7]||(e[7]=a=>o.setTab("dependents"))},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.$t("ui.package-details.tabDependents")),1)])),_:1},8,["active","links"])):(0,s.Q3)("",!0)])]),(0,s.bF)(G,{active:""===o.tab},{default:(0,s.k6)((()=>[a.metadata.abandoned?((0,s.uX)(),(0,s.CE)("div",P,[!0===a.metadata.abandoned?((0,s.uX)(),(0,s.CE)(s.FK,{key:0},[(0,s.eW)((0,n.v_)(a.$t("ui.package.abandonedText")),1)],64)):((0,s.uX)(),(0,s.Wv)(k,{key:1,keypath:"ui.package.abandonedReplace"},{replacement:(0,s.k6)((()=>[(0,s.bF)(d,{to:{query:{p:a.metadata.abandoned}}},{default:(0,s.k6)((()=>[(0,s.eW)((0,n.v_)(a.metadata.abandoned),1)])),_:1},8,["to"])])),_:1}))])):(0,s.Q3)("",!0),a.metadata.funding?((0,s.uX)(),(0,s.Wv)(g,{key:1,class:"package-popup__funding",items:a.metadata.funding},null,8,["items"])):(0,s.Q3)("",!0),(0,s.RG)(a.$slots,"package-update"),a.metadata.contaoVersions?((0,s.uX)(),(0,s.CE)("p",R,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package-details.contaoVersions"))+":",1),(0,s.eW)(" "+(0,n.v_)(a.metadata.contaoVersions.join(", ")),1)])):(0,s.Q3)("",!0),a.metadata.latest?((0,s.uX)(),(0,s.CE)("p",q,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package-details.latest"))+":",1),(0,s.eW)(" "+(0,n.v_)(a.metadata.latest.version)+" ("+(0,n.v_)(a.$t("ui.package-details.released"))+" "+(0,n.v_)(o.datimFormat(a.metadata.latest.time,"short","long"))+")",1)])):(0,s.Q3)("",!0),a.metadata.license?((0,s.uX)(),(0,s.CE)("p",B,[(0,s.Lk)("strong",null,(0,n.v_)(a.$t("ui.package-details.license"))+":",1),(0,s.eW)(" "+(0,n.v_)(o.license),1)])):(0,s.Q3)("",!0),(0,s.Lk)("p",I,(0,n.v_)(a.metadata.description),1)])),_:3},8,["active"]),a.metadata.features?((0,s.uX)(),(0,s.Wv)(G,{key:0,active:"features"===o.tab,links:a.metadata.features},{actions:(0,s.k6)((({name:e})=>[(0,s.RG)(a.$slots,"features-actions",(0,n._B)((0,s.Ng)({name:e})))])),_:3},8,["active","links"])):(0,s.Q3)("",!0),(0,s.bF)(G,{active:"suggest"===o.tab,links:a.metadata.suggest},{actions:(0,s.k6)((({name:e})=>[(0,s.RG)(a.$slots,"suggest-actions",(0,n._B)((0,s.Ng)({name:e})))])),_:3},8,["active","links"]),(0,s.bF)(G,{active:"require"===o.tab,links:a.metadata.require},{actions:(0,s.k6)((({name:e})=>[(0,s.RG)(a.$slots,"require-actions",(0,n._B)((0,s.Ng)({name:e})))])),_:3},8,["active","links"]),(0,s.bF)(G,{active:"conflict"===o.tab,links:a.metadata.conflict},{actions:(0,s.k6)((({name:e})=>[(0,s.RG)(a.$slots,"conflict-actions",(0,n._B)((0,s.Ng)({name:e})))])),_:3},8,["active","links"]),t.dependents?((0,s.uX)(),(0,s.Wv)(G,{key:1,active:"dependents"===o.tab,links:t.dependents},{actions:(0,s.k6)((({name:e})=>[(0,s.RG)(a.$slots,"dependents-actions",(0,n._B)((0,s.Ng)({name:e})))])),_:3},8,["active","links"])):(0,s.Q3)("",!0)],64)):((0,s.uX)(),(0,s.CE)("div",v,[(0,s.bF)(p,{horizontal:""}),(0,s.Lk)("p",null,(0,n.v_)(a.$t("ui.package-details.loading")),1)]))])),_:3})}var O=t(9376),S=t(416),j=t(266),K=t(7423),V=t(9045);const D={key:0,class:"link-more"};function H(a,e,t,i,l,o){const p=(0,s.g2)("link-menu");return o.linkItems.length?((0,s.uX)(),(0,s.CE)("div",D,[(0,s.Lk)("button",{onClick:e[0]||(e[0]=(...a)=>o.toggle&&o.toggle(...a))},(0,n.v_)(a.$t("ui.package-details.more")),1),a.visible?((0,s.uX)(),(0,s.CE)("div",{key:0,ref:"menu",class:"link-more__menu",tabindex:"-1",onFocusout:e[1]||(e[1]=(...a)=>o.close&&o.close(...a)),onClick:e[2]||(e[2]=(...a)=>o.close&&o.close(...a))},[(0,s.bF)(p,{items:o.linkItems,color:"contao"},null,8,["items"])],544)):(0,s.Q3)("",!0)])):(0,s.Q3)("",!0)}var M=t(4758),N={components:{LinkMenu:M.A},props:{name:String,homepage:String,support:Object,metadata:String,hidePackagist:Boolean},data:()=>({visible:!1}),computed:{linkItems(){const a=[];return this.homepage&&a.push({label:this.$t("ui.package.homepage"),href:this.homepage,target:"_blank"}),this.name&&!this.hidePackagist&&a.push({label:this.$t("ui.package-details.packagist"),href:`https://packagist.org/packages/${this.name}`,target:"_blank"}),this.support&&Object.keys(this.support).forEach((e=>{const t=`ui.package-details.support_${e}`;let s=this.$t(`ui.package-details.support_${e}`);s===t&&(s=e),"email"===e?a.push({label:s,href:`mailto:${this.support[e]}`}):a.push({label:s,href:this.support[e],target:"_blank"})})),this.metadata&&a.push({label:this.$t("ui.package-details.metadata"),href:this.metadata,target:"_blank"}),a}},methods:{open(){this.visible=!0,setTimeout((()=>this.$refs.menu?.focus()),0)},close(a){a&&this.$refs.menu?.contains(a.relatedTarget)||(this.$refs.menu.blur(),setTimeout((()=>{this.visible=!1}),100))},toggle(){this.visible?this.close():this.open()}}},z=t(6262);const U=(0,z.A)(N,[["render",H]]);var Y=U;const J=["disabled"];function Z(a,e,t,i,l,o){return t.showEmpty||o.count>0?((0,s.uX)(),(0,s.CE)("li",{key:0,class:(0,n.C4)(["package-popup__tab",{"package-popup__tab--active":t.active}])},[(0,s.Lk)("button",{onClick:e[0]||(e[0]=e=>a.$emit("click")),disabled:0===o.count&&!1!==t.links},[(0,s.RG)(a.$slots,"default"),!1!==t.links?((0,s.uX)(),(0,s.CE)("span",{key:0,class:(0,n.C4)({"package-popup__pill":!0,"package-popup__pill--highlight":t.highlight&&o.count>0})},(0,n.v_)(o.count),3)):(0,s.Q3)("",!0)],8,J)],2)):(0,s.Q3)("",!0)}var aa={emits:["click"],props:{active:Boolean,showEmpty:Boolean,highlight:Boolean,links:[Object,Array,Boolean]},computed:{count(){return this.links?this.links instanceof Array?this.links.length:Object.values(this.links).length:0}}};const ea=(0,z.A)(aa,[["render",Z]]);var ta=ea,sa=t(3751);const na={class:"package-popup__tabcontent",tabindex:"-1"},ia={key:0,class:"package-popup__packagelist"};function la(a,e,t,n,i,l){const o=(0,s.g2)("package-link");return(0,s.bo)(((0,s.uX)(),(0,s.CE)("div",na,[(0,s.RG)(a.$slots,"default",{},(()=>[t.links?((0,s.uX)(),(0,s.CE)("div",ia,[((0,s.uX)(!0),(0,s.CE)(s.FK,null,(0,s.pI)(l.iterableLinks,((e,t)=>(0,s.RG)(a.$slots,"links",(0,s.v6)({ref_for:!0},{name:t,text:e}),(()=>[((0,s.uX)(),(0,s.Wv)(o,{name:t,key:t,text:e},{default:(0,s.k6)((()=>[(0,s.RG)(a.$slots,"actions",(0,s.v6)({ref_for:!0},{name:t}))])),_:2},1032,["name","text"]))])))),256))])):(0,s.Q3)("",!0)]))],512)),[[sa.aG,t.active]])}const oa={class:"package-link__details"},pa=["title"],ca={class:"package-link__text"},ra={class:"package-link__actions"};function ua(a,e,t,i,l,o){const p=(0,s.g2)("details-button");return(0,s.uX)(),(0,s.CE)("article",{class:(0,n.C4)(["package-link",{"package-link--limit":!t.text}])},[(0,s.Lk)("div",oa,[(0,s.Lk)("p",{class:"package-link__name",title:t.name},(0,n.v_)(a.metadata&&a.metadata.title||t.name),9,pa),(0,s.Lk)("p",ca,(0,n.v_)(t.text||a.metadata&&a.metadata.description),1)]),(0,s.Lk)("div",ra,[(0,s.RG)(a.$slots,"default"),(0,s.bF)(p,{small:"",name:t.name},null,8,["name"])])],2)}var da=t(9071),ka={mixins:[S.A],components:{DetailsButton:da.A},props:{name:String,text:String},computed:{data:a=>({name:a.name})}};const ga=(0,z.A)(ka,[["render",ua]]);var ma=ga,ha={components:{PackageLink:ma},props:{active:Boolean,links:[Object,Array]},computed:{iterableLinks(){if(this.links instanceof Array){const a={};return this.links.forEach((e=>{a[e]=null})),a}return this.links}},watch:{active(){setTimeout((()=>{this.$el.focus()}),0)}}};const _a=(0,z.A)(ha,[["render",la]]);var va=_a,ba=t(1687);const fa={key:0,class:"package-funding"},ya=["href"],$a=["href"],Ca=["href"],Xa=["href"],Ea=["href"];function La(a,e,t,i,l,o){return t.items&&t.items.length?((0,s.uX)(),(0,s.CE)("div",fa,[(0,s.Lk)("div",null,[(0,s.Lk)("span",null,(0,n.v_)(a.$t("ui.package-details.funding")),1),((0,s.uX)(!0),(0,s.CE)(s.FK,null,(0,s.pI)(t.items,((a,e)=>((0,s.uX)(),(0,s.CE)(s.FK,null,["github"===a.type?((0,s.uX)(),(0,s.CE)("a",{href:o.githubUrl(a),target:"_blank",rel:"noreferrer noopener",key:e},"GitHub",8,ya)):"tidelift"===a.type?((0,s.uX)(),(0,s.CE)("a",{href:a.url,target:"_blank",rel:"noreferrer noopener",key:e},"Tidelift",8,$a)):"patreon"===a.type?((0,s.uX)(),(0,s.CE)("a",{href:a.url,target:"_blank",rel:"noreferrer noopener",key:e},"Patreon",8,Ca)):"opencollective"===a.type?((0,s.uX)(),(0,s.CE)("a",{href:a.url,target:"_blank",rel:"noreferrer noopener",key:e},"OpenCollective",8,Xa)):((0,s.uX)(),(0,s.CE)("a",{href:a.url,target:"_blank",rel:"noreferrer noopener",key:e},(0,n.v_)(a.url.replace(/^https?:\/\/(www.)?([^/]+).*$/,"$2")),9,Ea))],64)))),256))])])):(0,s.Q3)("",!0)}var wa={name:"PackageFunding",props:{items:{type:Array,required:!0}},computed:{githubUrl:()=>a=>a.url.replace(/^https:\/\/github.com\/([^/]+)$/,"https://github.com/sponsors/$1")}};const Fa=(0,z.A)(wa,[["render",La],["__scopeId","data-v-5a8fd14b"]]);var Aa=Fa,Wa={mixins:[S.A],components:{PopupOverlay:ba.A,MoreLinks:Y,LoadingSpinner:V.A,PackageLogo:K.A,PackageFunding:Aa,DetailsTab:ta,DetailsContent:va},props:{local:{type:Object},dependents:{type:Object}},data:()=>({appTitle:"",links:[],hasPrevious:!1}),computed:{current:a=>a.$route.query.p,tab:a=>String(a.$route.hash).substring(1),exists:a=>a.metadata,data:a=>a.local||{name:a.current},authors:a=>a.metadata.authors&&a.metadata.authors.length?a.metadata.authors.filter((a=>!!a.name)):null,license:a=>a.metadata.license?a.metadata.license instanceof Array?a.metadata.license.join(", "):a.metadata.license:"–",contaoVersions:a=>a.metadata.contaoVersions||null},methods:{datimFormat:k.A,numberFormat:j.A,...(0,d.PY)("packages/details",["clearCurrent"]),setTab(a){this.$router.replace({query:this.$route.query,hash:`#${a}`,append:!0})},updatePage(){let a=`${this.current} - ${this.appTitle}`,e="";this.metadata&&(this.metadata.title&&(a=`${this.metadata.title} (${this.current}) - ${this.appTitle}`),e=this.metadata.description||""),document.title=a,document.head.querySelector('meta[name="description"]').setAttribute("content",e)},addLink(a,e,t=null){const s=new URL(location.pathname,location);s.search=a;const n=document.createElement("link");n.setAttribute("rel",e),n.setAttribute("href",s.toString()),t&&n.setAttribute("hrefLang",t),document.head.appendChild(n),this.links.push(n)}},watch:{current(){this.updatePage(),this.hasPrevious=/[?&]p=/.test(window.history.state?.back)},exists(a){a||this.clearCurrent()},metadata(){this.updatePage()}},created(){this.appTitle=document.title},mounted(){document.head.querySelector('meta[name="robots"]').setAttribute("content","index,follow"),this.updatePage(),this.addLink(`?p=${this.current}&_locale=${this.$i18n.locale}`,"canonical"),Object.keys(O.A).forEach((a=>{this.addLink(`?p=${this.current}&_locale=${a}`,"alternate",a)}))},beforeUnmount(){document.title=this.appTitle,document.head.querySelector('meta[name="description"]').setAttribute("content",""),this.links.forEach((a=>{document.head.removeChild(a)}))}};const Qa=(0,z.A)(Wa,[["render",G]]);var Ta=Qa,xa=t(5761),Pa=t(5062),Ra={mixins:[g.A],components:{PackageConstraint:Pa.A,PackageDetails:Ta,InstallButton:xa.A},computed:{...(0,d.aH)("packages",{allInstalled:"installed"}),...(0,d.L8)("packages",["packageConstraint"]),current:a=>a.$route.query.p,data:a=>a.add[a.current]||a.allInstalled&&a.allInstalled[a.current]||{name:a.current},dependents(){if(!this.allInstalled||!this.allInstalled[this.data.name]?.dependents)return null;const a={},e=["requires","replaces","provides","conflicts"];return Object.values(this.allInstalled[this.data.name].dependents).forEach((t=>{if("__root__"===t.source||!e.includes(t.description)||t.source===this.data.name&&"replaces"===t.description)return;const s=this.$t(`ui.package-details.link${t.description[0].toUpperCase()}${t.description.slice(1)}`);let n=t.target;n===this.data.name&&this.metadata&&this.metadata.title&&(n=this.metadata.title),a[t.source]=`${s} ${n} ${t.constraint}`})),a}},methods:{datimFormat:k.A}};const qa=(0,z.A)(Ra,[["render",u]]);var Ba=qa}}]);"use strict";(self["webpackChunkcontao_manager"]=self["webpackChunkcontao_manager"]||[]).push([[643],{6643:function(e){e.exports=JSON.parse('{"ui.app.httpsHeadline":"!! Osäker anslutning !!","ui.app.httpsDescription":"Utan HTTPS kommer din konfidentiella data att överföras okrypterad.","ui.app.httpsLink":"Mer information","ui.app.httpsHref":"https://https.cio.gov/everything/","ui.app.safeModeHeadline":"!! Säkert läge aktiverat !!","ui.app.safeModeDescription":"Vissa funktioner i Contao Manager är inte tillgängliga.","ui.app.safeModeExit":"Avsluta felsäkert läge","ui.app.limitedHeadline":"Fjärrautentisering","ui.app.limitedDescription":"Du har begränsade behörigheter på grund av lösenordslös inloggning.","ui.app.limitedLogout":"Autentisera på nytt","ui.app.totpHeadline":"Säkerhetsmeddelande","ui.app.totpDescription":"Konfigurera tvåfaktorsautentisering nu för att säkra ditt konto.","ui.app.totpSetup":"Setup","ui.app.loading":"Laddar Contao Manager …","ui.app.apiError":"Oväntad API-status","ui.app.configSecurity1":"SÄKERHETSVARNING !!! Oskyddad konfigurationskatalog upptäcktes","ui.app.configSecurity2":"Contao Manager har upptäckt att dess konfigurationsfiler är offentligt tillgängliga. Alla operationer är inaktiverade tills katalogen är säker, annars kan en angripare komma åt känsliga data från din installation.\\n\\nFör att åtgärda det här problemet, se till att förhindra åtkomst till \\"contao-manager\\"-katalogen på din server. För att lära dig hur du gör detta, se manualen för din webbserver eller kontakta din värdleverantör.","ui.account.welcome":"Välkommen","ui.account.intro1":"Välkommen till Contao Manager, ett universellt verktyg för att installera och hantera Contao Open Source CMS. Om du är ny på det, vänligen {readTheManualToGetStarted}.","ui.account.introGetStarted":"{readTheManual} för att komma igång","ui.account.introManual":"läs manualen","ui.account.intro2":"Om du stöter på några problem, kolla {ourGithubIssues} och skapa gärna ett nytt för allt som inte har rapporterats ännu.","ui.account.introIssues":"våra GitHub-problem","ui.account.headline":"Användarkonto","ui.account.description":"För att hantera din installation, skapa ett konto för Contao Manager. Var medveten om att det här kontot inte är relaterat till Contao backend eller frontend.","ui.account.username":"Användarnamn","ui.account.password":"Lösenord","ui.account.passwordPlaceholder":"min. 8 tecken","ui.account.passwordLength":"Ange minst 8 tecken.","ui.account.loginInvalid":"Det uppstod ett fel när du skapade kontot. Vänligen försök med ett annat användarnamn.","ui.account.submit":"Skapa konto","ui.account.usePassword":"Använd lösenord för inloggning","ui.account.usePasskey":"Använd Passkey för inloggning","ui.account.totpHeadline":"Tvåfaktorsautentisering","ui.account.totpDescription":"Vänligen aktivera tvåfaktorsautentisering, vilket ger ditt konto ett extra säkerhetslager. Förutom ditt användarnamn och lösenord måste du ange en verifieringskod som genereras av en tvåfaktorsapp som 1Password, Authy, Google Authenticator, Microsoft Authenticator, LastPass Authenticator eller någon annan TOTP-app.","ui.account.totpSetup":"Konfigurera nu","ui.account.totpSkip":"Konfigureras senare","ui.account.login":"Avvisa inbjudan","ui.account.contribute1":"Contao och Contao Manager är sponsrade av den ideella Contao Association.","ui.account.contribute2":"Vänligen överväg att bidra till öppen källkod genom att {donate}.","ui.account.contributeDonate":"göra en donation","ui.login.headline":"Logga in","ui.login.description":"Logga in för att hantera din installation.","ui.login.username":"Användarnamn","ui.login.password":"Lösenord","ui.login.totpHeadline":"Tvåfaktorsautentisering","ui.login.totpDescription":"Ange din verifieringskod för att slutföra inloggningsprocessen.","ui.login.totp":"Verifieringskod","ui.login.forgotPassword":"Glömt ditt lösenord?","ui.login.button":"Logga in","ui.login.passkey":"Logga in med Passkey","ui.login.cancel":"Avbryt","ui.login.or":"eller","ui.login.locked":"Åtkomst har nekats eftersom Contao Manager är låst. För att låsa upp, radera {lockFile}-filen i din Contao-rotkatalog.","ui.logout.headline":"Sessionen har gått ut","ui.logout.warning":"Du har varit inaktiv i mer än 25 minuter. Av säkerhetsskäl kommer din session att avslutas inom kort.","ui.logout.expired":"Din session avslutades automatiskt eftersom du har varit inaktiv i mer än 30 minuter.","ui.logout.renew":"Håll inloggad","ui.logout.logout":"Logga ut","ui.logout.login":"Tillbaka till login","ui.oauth.error":"Ogiltigt OAuth-försök. Kontrollera request-parametrarna.","ui.oauth.https":"Omdirigerings-URI:n MÅSTE använda ett säkert protokoll (https:) för att förhindra att autentiseringstoken sänds i klartext.","ui.oauth.headline":"Fjärrautentisering","ui.oauth.description":"Följande applikation eller tjänst begär fjärråtkomst till din Contao Manager-instans.","ui.oauth.domain":"Innan du tillåter åtkomst, se till att du känner till den här webbadressen och litar på dess ägare!","ui.oauth.outOfScope":"Tyvärr har du inte de nödvändiga behörigheterna för att bevilja denna åtkomst.","ui.oauth.allow":"Tillåta åtkomst","ui.oauth.deny":"Neka åtkomst","ui.oauth.switchUser":"Växla användare","ui.scope.admin":"Admin-åtkomst inklusive användarhantering","ui.scope.install":"Installera nya paket och ändra Contao-konfigurationen","ui.scope.update":"Uppdatera paket och utföra underhållsåtgärder","ui.scope.read":"Läs paket och konfiguration","ui.boot.headline":"Systemkontroll","ui.boot.description":"Vänta, vi analyserar din server...","ui.boot.issue1":"Installationsproblem upptäcktes","ui.boot.issue2":"Din installation har problem som måste åtgärdas innan Contao Manager kan användas.","ui.boot.run":"Starta Contao Manager","ui.boot.safeMode":"Starta i felsäkert läge Safe Mode","ui.recovery.headline":"Systemåterställning","ui.recovery.description":"Contao Manager upptäckte filer som ser ut som Contao, men kommandoradsgränssnittet fungerar inte som förväntat.","ui.recovery.console":"Konsolutgång","ui.recovery.repairOptions":"Välj ett alternativ för att reparera din installation.","ui.recovery.repairHeadline":"Automatisk reparation","ui.recovery.repairDescription":"Försöker att automatiskt reparera installationen genom att bygga om programcachen och installera om Composer-paketen.","ui.recovery.repairWarning":"Eventuella ändringar av vendor-filerna kan raderas under processen!","ui.recovery.repairFailed":"Den automatiska reparationen lyckades inte. Prova felsäkert läge Safe Mode för att manuellt reparera installationen.","ui.recovery.repairButton":"Kör systemreparation","ui.recovery.safeModeHeadline":"Säkert läge Safe Mode","ui.recovery.safeModeDescription":"Att starta Contao Manager i felsäkert läge gör det möjligt att hantera paket och köra vissa underhållsuppgifter, men funktioner som förlitar sig på en fungerande Contao-installation kommer inte att vara tillgängliga.","ui.recovery.safeModeButton":"Starta i felsäkert läge Safe Mode","ui.server.pending":"Väntar …","ui.server.running":"Analyserar …","ui.server.error":"Kontrollen misslyckades på grund av ett oväntat svar från servern.","ui.server.details":"Detaljer","ui.server.prerequisite":"Checken annullerad på grund av att förutsättning saknas.","ui.server.selfUpdate.title":"Uppdateringar av Contao Manager","ui.server.selfUpdate.update":"En ny version av Contao Manager {latest} är tillgänglig.","ui.server.selfUpdate.manualUpdate":"En ny version av Contao Manager {latest} är tillgänglig. Din server stöder inte automatiska uppdateringar, ladda ner den nya versionen från {download}.","ui.server.selfUpdate.latest":"Du använder den senaste versionen {current}.","ui.server.selfUpdate.dev":"Utvecklingsbyggen stöder inte automatiska uppdateringar.","ui.server.selfUpdate.unsupported":"En ny version är tillgänglig men den stöder inte din PHP-version.","ui.server.selfUpdate.button":"Kör självuppdatering","ui.server.selfUpdate.continue":"Fortsätta","ui.server.config.title":"Serverkonfiguration","ui.server.config.setup":"Konfigurera","ui.server.config.change":"Förändra","ui.server.config.save":"Spara","ui.server.config.cancel":"Avbryt","ui.server.config.customOption":"Övrig …","ui.server.config.description":"För att köra bakgrundsuppgifter korrekt måste Contao Manager veta var man hittar PHP-kommandoradens binära filer och hur man kör kommandon separerade från webbprocessen.","ui.server.config.formTitle":"Serverkonfiguration","ui.server.config.formText":"Ange sökvägen till din PHP-binär. Se till att binären är samma PHP-version som din webbprocess.","ui.server.config.cloudTitle":"Composer Resolver Cloud","ui.server.config.cloudText":"Composer Resolver Cloud gör det möjligt att installera Composer-beroenden även om din server inte tillhandahåller tillräckligt med lokalt minne. Var medveten om att din paketinformation kommer att överföras till en molnserver som drivs av Contao Association.","ui.server.config.cloud":"Använd Composer Resolver Cloud","ui.server.config.cli":"PHP binär","ui.server.config.stateErrorCli":"Ingen giltig PHP-binär hittades på servern.","ui.server.config.stateErrorCloud":"Composer Resolver Cloud stöds inte.","ui.server.config.stateSuccess":"PHP binär på {php_cli}.","ui.server.php_web.title":"PHP webbprocess","ui.server.php_web.below7":"Hittade PHP-versionen {version}. Byt till PHP 7 så snart som möjligt!","ui.server.php_web.success":"Hittade PHP-versionen {version}, inga kända problem hittades.","ui.server.php_cli.title":"PHP kommandoradsgränssnitt","ui.server.php_cli.success":"Hittade PHP-versionen {version}, inga kända problem hittades.","ui.server.composer.title":"Composer-Miljö","ui.server.composer.success":"Inga kända problem hittades.","ui.server.composer.install":"Composer-beroenden är inte installerade.","ui.server.composer.button":"Installera","ui.server.contao.title":"Contao installation","ui.server.contao.setup":"Setup","ui.server.contao.check":"Kontrollera databasen","ui.server.contao.empty":"Ingen Contao-installation har hittats.","ui.server.contao.old":"Contao version {version} är inte kompatibel med Contao Manager, uppdatera din installation manuellt.","ui.server.contao.found":"Hittade Contao {version} (API-version {api}).","ui.server.contao.connectionError":"Det går inte att ansluta till databasservern.","ui.server.contao.connectionProblem":"Databasproblem hittades.","ui.server.contao.missingUser":"Administratörskonto hittades inte.","ui.setup.continue":"Fortsätta","ui.setup.manager":"Starta Contao Manager","ui.setup.cancel":"Avbryt","ui.setup.welcome":"Välkommen","ui.setup.welcome1":"Den här guiden tar dig igenom de nödvändiga stegen för att konfigurera din Contao Open Source CMS-installation.","ui.setup.welcome2":"Om du har några frågor kan du hitta dokumentation, forum, en Slack-kanal och mer på sidan {support}.","ui.setup.support":"community support","ui.setup.start":"Komma igång","ui.setup.complete":"Grattis!","ui.setup.complete1":"Contao {version} har installerats.","ui.setup.complete2":"För att avsluta installationsprocessen, öppna installationsverktyget för att konfigurera databasanslutningen och skapa en backend-användare.","ui.setup.complete3":"Du kan nu börja skapa din webbplats i Contaos back end. Om du behöver ytterligare tillägg, fortsätt till Contao Manager.","ui.setup.installTool":"Öppna installationsverktyget","ui.setup.login":"Logga in på Contao","ui.setup.funding":"Fri programvara är \\"fri\\" som i \\"yttrandefritt\\", inte som i \\"gratis öl\\". Ett Open Source-projekt som Contao kräver summor pengar som inte kan samlas in av en enda person eller företag.\\nOm du har en webbplats eller säljer webbplatser byggda med Contao, skulle vi gärna se att du bidrar ekonomiskt till den produkt som ditt företag är beroende av.","ui.setup.fundingLink":"Läs mer","ui.setup.document-root.headline":"Webserverinstallation","ui.setup.document-root.warning":"För att installera Contao via Contao Manager måste du fixa dokumentroten på webbservern.","ui.setup.document-root.description1":"Contao använder en separat mapp för offentliga filer, programfiler installeras i dess överordnade mapp. Contao kan inte installeras om mappstrukturen inte är korrekt eller om mapparna inte är tomma.","ui.setup.document-root.description2":"Om du inte vet hur du konfigurerar din dokumentrot, läs Contao-dokumentationen eller kontakta din värdleverantör.","ui.setup.document-root.documentation":"Läs dokumentationen","ui.setup.document-root.conflictsTitle":"Installationskatalogen är inte tom","ui.setup.document-root.conflictsDirectory":"Rotkatalogen för din framtida Contao-installation är inte tom, vi har hittat {count} fil(er) som kan skrivas över av installationsprocessen. Det rekommenderas att skapa en tom katalogstruktur för Contao, men du kan också ta bort följande filer och kontrollera igen om du är säker på att de är oanvända.","ui.setup.document-root.ignoreConflicts":"Jag vill installera Contao i den icke-tomma katalogen. Jag förstår att detta kan skriva över alla befintliga filer på mitt webbutrymme.","ui.setup.document-root.check":"Kolla igen","ui.setup.document-root.create":"Skapa kataloger","ui.setup.document-root.change":"Byt kataloger","ui.setup.document-root.formTitle":"Kataloginställningar","ui.setup.document-root.formText1":"Contao Manager kan automatiskt skapa en ny katalogstruktur på servern.","ui.setup.document-root.formText2":"Du måste konfigurera den nya dokumentroten manuellt (t.ex. via en värdadministratörspanel).","ui.setup.document-root.autoconfig":"Jag förstår att jag måste ändra min serverkonfiguration. Att inte konfigurera dokumentroten kommer att bryta Contao Manager och exponera konfigurationsfiler (inklusive kontodetaljer och lösenord)!","ui.setup.document-root.directory":"Ny katalog","ui.setup.document-root.currentRoot":"Aktuell dokumentrot","ui.setup.document-root.newRoot":"Ny dokumentrot","ui.setup.document-root.finish":"Installera kataloger","ui.setup.document-root.publicDir":"Använd {dir} för offentliga filer (för Contao {version})","ui.setup.document-root.directoryInvalid":"Vänligen ange ett giltigt katalognamn.","ui.setup.document-root.directoryExists":"Vänligen ange ett giltigt katalognamn.","ui.setup.document-root.confirmation":"Contao Manager har skapat den nödvändiga katalogen för din Contao-installation. Du måste nu konfigurera dokumentroten på din webbserver. Ladda inte om den här sidan förrän då.","ui.setup.document-root.reload":"Ladda om sidan","ui.setup.document-root.success":"Katalogstrukturen på din webbserver är korrekt inställd!","ui.setup.document-root.installingProjectDir":"Programfiler kommer att installeras i {dir}.","ui.setup.document-root.installingPublicDir":"Offentliga filer kommer att installeras i {dir}.","ui.setup.document-root.installedProjectDir":"Programfiler installeras i {dir}.","ui.setup.document-root.installedPublicDir":"Offentliga filer installeras i {dir}.","ui.setup.create-project.headline":"Contao installation","ui.setup.create-project.description":"Contao-utvecklingen följer principen för {semver}, en ny minor version släpps var sjätte månad. De utgåvor som för närvarande stöds är:","ui.setup.create-project.semver":"Semantisk versionering","ui.setup.create-project.latestTitle":"Senast","ui.setup.create-project.ltsTitle":"Långtidssupport","ui.setup.create-project.latestQ1":"Vår senaste version erbjuder de flesta funktionerna med support fram till februari {year}.","ui.setup.create-project.latestQ3":"Vår senaste version erbjuder de flesta funktionerna med support fram till augusti {year}.","ui.setup.create-project.ltsText":"Vår nuvarande LTS-version, om du fokuserar på stabilitet. Erbjuder långsiktig support till februari {year}.","ui.setup.create-project.pltsText":"Den tidigare LTS-versionen har fortfarande långtidssupport fram till februari {year}.","ui.setup.create-project.requiresPHP":"Kräver minst PHP {version}, du har PHP {current}.","ui.setup.create-project.releaseplan":"Se {contaoReleasePlan} för detaljerad information.","ui.setup.create-project.releaseplanLink":"Contao Release Plan","ui.setup.create-project.installed":"Contao {version} har installerats på servern. Fortsätt att ställa in din databas eller starta Contao Manager för att installera en annan version.","ui.setup.create-project.formTitle":"Välj en distribution","ui.setup.create-project.formText":"Välj vilken version som ska installeras.","ui.setup.create-project.version":"Version","ui.setup.create-project.demo":"Installera Contaos demowebbplats","ui.setup.create-project.demoDescription":"Demowebbplatsen hjälper dig att bli bekant med Contao och alla dess kärnfunktioner. Fler teman finns i {butiken}.","ui.setup.create-project.coreOnly":"Minimal installation (endast kärna core)","ui.setup.create-project.noUpdate":"Hoppa över installationen (endast experter!)","ui.setup.create-project.theme":"Contao Theme","ui.setup.create-project.themeInstall":"För att installera ett Contao-tema, använd sökingången eller ladda upp en temafil (.cto/.zip) som stöder installation via Contao Manager.","ui.setup.create-project.themeBuy":"Se till att besöka den officiella {butiken}.","ui.setup.create-project.themeStore":"Contao Themes Store","ui.setup.create-project.themeUpload":"Ladda upp temafil (.cto/.zip)","ui.setup.create-project.themeInvalid":"Den uppladdade filen är inte ett Contao-tema eller stöder inte Contao Manager.","ui.setup.create-project.themeWarning":"Contao Manager kan inte avgöra om detta tema är kompatibelt med din server. Kontrollera med temaleverantören om du har några frågor.","ui.setup.create-project.themeTitle":"Granska temadetaljer","ui.setup.create-project.themeDetails":"Följande beroenden och filer kommer att installeras med detta tema.","ui.setup.create-project.themeRequire":"{count} beroenden | {count} beroenden","ui.setup.create-project.themeFiles":"{count} Fil | {count} filer","ui.setup.create-project.theme.or":"eller sök efter offentliga teman","ui.setup.create-project.theme.search":"Sök teman","ui.setup.create-project.theme.more":"Fler teman","ui.setup.create-project.theme.empty":"Inga teman matchar {query}","ui.setup.create-project.theme.uploaded":"Temafilen laddades upp.","ui.setup.create-project.theme.packageName":"Paketnamn","ui.setup.create-project.theme.version":"Version","ui.setup.create-project.theme.authors":"Författare","ui.setup.create-project.theme.upload":"Uploading {name} ({size})","ui.setup.create-project.install":"Installera","ui.setup.create-project.cancel":"Avbryt","ui.setup.database-connection.headline":"Databasanslutning","ui.setup.database-connection.description":"Contao kräver en MySQL-databas (eller en kompatibel databas som MariaDB) för att lagra sidor, innehåll, användare och annan relationsdata. Anslutningsparametrar lagras i filen {env} i projektroten för din Contao-installation.","ui.setup.database-connection.formTitle":"Anslutningsparametrar","ui.setup.database-connection.formText":"Ange en databas-URL eller fyll i användarnamn, lösenord, server och databasfält separat.","ui.setup.database-connection.url":"Databas URL","ui.setup.database-connection.validUrl":"Databas-URL är ogiltig eller anslutningen till servern misslyckades.","ui.setup.database-connection.or":"eller","ui.setup.database-connection.user":"Användarnamn","ui.setup.database-connection.password":"Lösenord","ui.setup.database-connection.server":"Server (:Port)","ui.setup.database-connection.database":"Databas namn","ui.setup.database-connection.connected":"Ansluten till databasen {database} på {server}.","ui.setup.database-connection.error":"Fel vid anslutning till databasen.","ui.setup.database-connection.problem":"Contao har upptäckt ett problem med din databasserver.","ui.setup.database-connection.schemaTitle":"Databasschema","ui.setup.database-connection.migration":"Det finns en väntande migrering. | Det finns {count} väntande migreringar.","ui.setup.database-connection.schema":"Det finns en väntande schemauppdatering. | Det finns {count} väntande schemauppdateringar.","ui.setup.database-connection.noChanges":"Ditt databasschema är uppdaterat.","ui.setup.database-connection.check":"Kontrollera databasen","ui.setup.database-connection.skip":"Hoppa över","ui.setup.database-connection.save":"Spara","ui.setup.database-connection.change":"Ändra autentiseringsuppgifter","ui.setup.database-connection.restoreTitle":"Databasimport","ui.setup.database-connection.restoreText":"Temat du just installerade innehåller en databassäkerhetskopiering. Återställ databasen för att importera temadata eller hoppa över detta steg för att börja med en tom