/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.audit.ListenerAuditService;
import com.intellij.database.dataSource.connection.statements.BatchesContainer;
import com.intellij.database.dataSource.connection.statements.CallableStatementBasis;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ClosableResultsProducer;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.JdbcBasedSmartStatement;
import com.intellij.database.dataSource.connection.statements.ParameterizedStatementDecoration;
import com.intellij.database.dataSource.connection.statements.ReusableNoisyStatement;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementsUtil;
import com.intellij.database.dataSource.connection.statements.StatementHolder;
import com.intellij.database.util.JdbcUtil;
import java.sql.PreparedStatement;
import java.sql.Statement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u00182\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0011H\u0014J\b\u0010\u001a\u001a\u00020\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0018H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/intellij/database/dataSource/connection/statements/ReusableCallableStatement;", "Lcom/intellij/database/dataSource/connection/statements/JdbcBasedSmartStatement$Call;", "Lcom/intellij/database/dataSource/connection/statements/ParameterizedStatementDecoration;", "Lcom/intellij/database/dataSource/connection/statements/ReusableSmartStatement;", "basis", "Lcom/intellij/database/dataSource/connection/statements/CallableStatementBasis;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "auditService", "Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;", "configuration", "Lcom/intellij/database/dataSource/connection/statements/Configuration;", "(Lcom/intellij/database/dataSource/connection/statements/CallableStatementBasis;Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dataSource/connection/audit/ListenerAuditService;Lcom/intellij/database/dataSource/connection/statements/Configuration;)V", "batches", "Lcom/intellij/database/dataSource/connection/statements/BatchesContainer;", "statementHolder", "Lcom/intellij/database/dataSource/connection/statements/StatementHolder$Reusable;", "Ljava/sql/PreparedStatement;", "getStatementHolder", "()Lcom/intellij/database/dataSource/connection/statements/StatementHolder$Reusable;", "addBatch", "", "input", "before", "Lcom/intellij/database/dataSource/connection/Either;", "statement", "close", "decoration", "escapeIndex", "", "executeBatch", "Lcom/intellij/database/dataSource/connection/statements/ClosableResultsProducer;", "extract", "", "intellij.database.impl"})
public final class ReusableCallableStatement
extends JdbcBasedSmartStatement.Call<ParameterizedStatementDecoration>
implements ReusableSmartStatement<ParameterizedStatementDecoration> {
    @NotNull
    private final StatementHolder.Reusable<PreparedStatement> statementHolder;
    private final BatchesContainer batches;
    private final CallableStatementBasis basis;

    @Override
    @NotNull
    protected StatementHolder.Reusable<PreparedStatement> getStatementHolder() {
        return this.statementHolder;
    }

    @Override
    public void addBatch(@NotNull ParameterizedStatementDecoration input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        PreparedStatement statement = (PreparedStatement)this.getCurrentStatement(input).tryGet().getValue();
        this.completeStatement(statement, input);
        statement.addBatch();
        this.batches.add(this.basis.getSql());
    }

    @Override
    @NotNull
    protected Either<Unit> before(@NotNull ParameterizedStatementDecoration input, @NotNull PreparedStatement statement) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        this.getAuditService().beforeCallableStatement(new CallableStatementData(this.basis, input), this);
        return super.before(input, statement);
    }

    @Override
    @NotNull
    public Either<ClosableResultsProducer> executeBatch() {
        Object s = ((StatementHolder.Reusable)this.getStatementHolder()).getStatement();
        if (s == null) {
            Intrinsics.throwNpe();
        }
        return SmartStatementsUtil.executeBatch(s, this.getConnection(), this, this.batches);
    }

    @Override
    public void close() {
        if (((StatementHolder.Reusable)this.getStatementHolder()).getStatement() != null) {
            ListenerAuditService listenerAuditService = this.getAuditService();
            Object s = ((StatementHolder.Reusable)this.getStatementHolder()).getStatement();
            if (s == null) {
                Intrinsics.throwNpe();
            }
            listenerAuditService.beforeStatementClosing((Statement)s, this);
        }
        JdbcUtil.closeSafe((AutoCloseable)((AutoCloseable)((StatementHolder.Reusable)this.getStatementHolder()).getStatement()));
        this.batches.clear();
    }

    @Override
    @NotNull
    public String extract(@NotNull ParameterizedStatementDecoration input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.basis.getSql();
    }

    @Override
    public int escapeIndex(@NotNull ParameterizedStatementDecoration input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.basis.getEscapeIdx();
    }

    @Override
    @NotNull
    public CallableStatementBasis basis(@NotNull ParameterizedStatementDecoration input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return this.basis;
    }

    @Override
    @NotNull
    public ParameterizedStatementDecoration decoration(@NotNull ParameterizedStatementDecoration input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return input;
    }

    public ReusableCallableStatement(@NotNull CallableStatementBasis basis, @NotNull DatabaseConnection connection2, @NotNull ListenerAuditService auditService, @NotNull Configuration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)basis, (String)"basis");
        Intrinsics.checkParameterIsNotNull((Object)connection2, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)auditService, (String)"auditService");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        super(connection2, auditService, configuration);
        this.basis = basis;
        this.statementHolder = new StatementHolder.Reusable();
        this.batches = new BatchesContainer();
    }

    @Override
    @NotNull
    public ReusableNoisyStatement<ParameterizedStatementDecoration> noisy() {
        return ReusableSmartStatement.DefaultImpls.noisy(this);
    }
}

