/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.template;

import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.ParameterEditorModel;
import com.intellij.database.dataSource.url.template.ParametersHolder;
import com.intellij.database.dataSource.url.template.StatelessParametersHolder;
import com.intellij.database.dataSource.url.template.UrlEditorModelBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UrlEditorModel
extends UrlEditorModelBase {
    private final List<ParameterEditorModel> myGroups;
    private int myActive;
    private String myUrl;
    private int myPrevActive;
    private boolean myColdStart;

    public UrlEditorModel(@NotNull Collection<StatelessJdbcUrlParser> parsers) {
        if (parsers == null) {
            UrlEditorModel.$$$reportNull$$$0(0);
        }
        this.myUrl = "";
        this.myColdStart = true;
        MultiMap grouped = MultiMap.createLinked();
        for (StatelessJdbcUrlParser parser : parsers) {
            grouped.putValue((Object)parser.getName(), (Object)parser);
        }
        this.myGroups = ContainerUtil.newArrayListWithCapacity((int)grouped.keySet().size());
        for (String name : grouped.keySet()) {
            this.myGroups.add(new ParameterEditorModel(name, grouped.get((Object)name)));
        }
        this.myGroups.add(new ParameterEditorModel("URL only", Collections.emptyList()));
        this.myActive = this.myPrevActive = this.getDefaultIdx();
    }

    public void setUrl(@NotNull String url) {
        if (url == null) {
            UrlEditorModel.$$$reportNull$$$0(1);
        }
        if (this.myUrl.equals(url)) {
            return;
        }
        this.invalidate(UrlEditorModelBase.State.URL_CHANGED);
        this.myUrl = url;
    }

    @NotNull
    private ParameterEditorModel getActiveGroup() {
        ParameterEditorModel parameterEditorModel = this.myGroups.get(this.myActive);
        if (parameterEditorModel == null) {
            UrlEditorModel.$$$reportNull$$$0(2);
        }
        return parameterEditorModel;
    }

    public void setParameter(@NotNull String param, @NotNull String value) {
        if (param == null) {
            UrlEditorModel.$$$reportNull$$$0(3);
        }
        if (value == null) {
            UrlEditorModel.$$$reportNull$$$0(4);
        }
        this.getActiveGroup().setParameter(param, value);
        if (this.getActiveGroup().getState() == UrlEditorModelBase.State.PARAMS_CHANGED) {
            this.invalidate(UrlEditorModelBase.State.PARAMS_CHANGED);
        }
    }

    public boolean commit(@Nullable Object arg) {
        if (this.getState() == UrlEditorModelBase.State.VALID && this.myPrevActive == this.myActive) {
            assert (this.getActiveGroup().getState() == UrlEditorModelBase.State.VALID);
            return false;
        }
        boolean changed = false;
        if (this.getState() == UrlEditorModelBase.State.URL_CHANGED) {
            if (this.myPrevActive == this.myActive || this.myColdStart) {
                changed = this.chooseGroup();
            }
            this.getActiveGroup().setUrl(this.myUrl);
        }
        changed |= this.getActiveGroup().commit(arg);
        if (!this.myUrl.equals(this.getActiveGroup().getUrl())) {
            changed = true;
            this.myUrl = this.getActiveGroup().getUrl();
        }
        boolean bl = this.myPrevActive != this.myActive;
        this.myPrevActive = this.myActive;
        this.myColdStart = false;
        return this.validate(changed |= bl, arg);
    }

    @Nullable
    public StatelessJdbcUrlParser getMeaningfulParser() {
        if (!this.isUrlOnly()) {
            return this.getCurrentParser();
        }
        for (ParameterEditorModel group2 : this.myGroups) {
            StatelessJdbcUrlParser parser = group2.getMeaningfulParser(this.getUrl());
            if (parser == null) continue;
            return parser;
        }
        return null;
    }

    private boolean chooseGroup() {
        if (!this.myColdStart && this.getActiveGroup().isUrlValueValid(this.myUrl)) {
            return false;
        }
        int i2 = 0;
        while (i2 + 1 < this.myGroups.size()) {
            ParameterEditorModel group2 = this.myGroups.get(i2);
            if ((this.myColdStart || i2 != this.myActive) && group2.isUrlValueValid(this.myUrl)) {
                this.myActive = i2;
                return true;
            }
            ++i2;
        }
        return false;
    }

    @NotNull
    public String getUrl() {
        assert (this.getState() != UrlEditorModelBase.State.PARAMS_CHANGED);
        String string = this.myUrl;
        if (string == null) {
            UrlEditorModel.$$$reportNull$$$0(5);
        }
        return string;
    }

    public int getActiveGroupId() {
        return this.myActive;
    }

    @NotNull
    public String getGroupName(int id) {
        String string = this.myGroups.get(id).getName();
        if (string == null) {
            UrlEditorModel.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @Nullable
    public String getParameter(@NotNull String param) {
        if (param == null) {
            UrlEditorModel.$$$reportNull$$$0(7);
        }
        return this.getActiveGroup().getParameter(param);
    }

    @Override
    @Nullable
    protected StatelessParametersHolder getParametersHolderDelegate() {
        return this.getActiveGroup();
    }

    public int getGroupsCount() {
        return this.myGroups.size();
    }

    @NotNull
    public StatelessParametersHolder getGroup(int i2) {
        StatelessParametersHolder statelessParametersHolder = this.myGroups.get(i2);
        if (statelessParametersHolder == null) {
            UrlEditorModel.$$$reportNull$$$0(8);
        }
        return statelessParametersHolder;
    }

    private boolean isValidUrlValue(@NotNull String url) {
        if (url == null) {
            UrlEditorModel.$$$reportNull$$$0(9);
        }
        if (!this.isUrlOnly() && this.getActiveGroup().isUrlValueValid(url)) {
            return true;
        }
        int i2 = 0;
        while (i2 + 1 < this.myGroups.size()) {
            ParameterEditorModel group2 = this.myGroups.get(i2);
            if (i2 != this.myActive && group2.isUrlValueValid(url)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public void assign(@NotNull UrlEditorModel source) {
        String url;
        if (source == null) {
            UrlEditorModel.$$$reportNull$$$0(10);
        }
        if (this.isValidUrlValue(url = source.getUrl()) || source.isUrlOnly() || !source.isParserValid()) {
            this.setUrl(url);
            return;
        }
        int covering = -1;
        for (int i2 = 0; i2 < this.myGroups.size(); ++i2) {
            if (!UrlEditorModel.commonParameters(source, this.myGroups.get(i2), true)) continue;
            covering = i2;
            break;
        }
        if (covering == -1) {
            this.setUrl(url);
            return;
        }
        this.myActive = covering;
        UrlEditorModel.transferParameters(source, this);
    }

    private static boolean commonParameters(@NotNull ParametersHolder source, @NotNull StatelessParametersHolder parameters, boolean covers) {
        if (source == null) {
            UrlEditorModel.$$$reportNull$$$0(11);
        }
        if (parameters == null) {
            UrlEditorModel.$$$reportNull$$$0(12);
        }
        HashSet parserParams = ContainerUtil.newHashSet(parameters.getParameters());
        for (String s : source.getParameters()) {
            boolean swapSidWithService;
            if (StringUtil.isEmpty((String)source.getParameter(s))) continue;
            boolean bl = swapSidWithService = "SID".equals(s) && parserParams.contains("service") || "service".equals(s) && parserParams.contains("SID");
            if (parserParams.contains(s) == covers && !swapSidWithService) continue;
            return !covers;
        }
        return covers;
    }

    private static void transferParameters(@NotNull ParametersHolder source, @NotNull UrlEditorModel target) {
        if (source == null) {
            UrlEditorModel.$$$reportNull$$$0(13);
        }
        if (target == null) {
            UrlEditorModel.$$$reportNull$$$0(14);
        }
        for (String parameter : source.getParameters()) {
            String value = source.getParameter(parameter);
            if (value == null) continue;
            target.setParameter(parameter, value);
            if ("SID".equals(parameter)) {
                target.setParameter("service", value);
            }
            if (!"service".equals(parameter)) continue;
            target.setParameter("SID", value);
        }
    }

    @NotNull
    public Collection<TextRange> getInvalidRanges() {
        Collection<TextRange> collection = this.getActiveGroup().getInvalidRanges();
        if (collection == null) {
            UrlEditorModel.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @Nullable
    public TextRange getParameterRange(@NotNull String param) {
        if (param == null) {
            UrlEditorModel.$$$reportNull$$$0(16);
        }
        return this.getActiveGroup().getParameterRange(param);
    }

    public void selectGroup(int group2) {
        if (this.myActive == group2) {
            return;
        }
        ParameterEditorModel cur = this.myGroups.get(group2);
        ParameterEditorModel prev = this.getActiveGroup();
        this.myActive = group2;
        if (!cur.isUrlValueValid(this.myUrl) && UrlEditorModel.commonParameters(prev, cur, false)) {
            UrlEditorModel.transferParameters(prev, this);
        } else {
            cur.setUrl(this.myUrl);
            this.invalidate(UrlEditorModelBase.State.URL_CHANGED);
        }
    }

    public boolean isParserValid() {
        return this.getActiveGroup().isParserValid();
    }

    @Nullable
    public StatelessJdbcUrlParser getCurrentParser() {
        return this.getActiveGroup().getActiveParser();
    }

    public boolean isUrlOnly() {
        return this.myActive + 1 == this.myGroups.size();
    }

    public void setUrlOnly(boolean only) {
        if (only == this.isUrlOnly()) {
            return;
        }
        this.selectGroup(only ? this.myGroups.size() - 1 : this.getDefaultIdx());
        this.myColdStart = !only;
    }

    private int getDefaultIdx() {
        for (int i2 = 0; i2 < this.myGroups.size(); ++i2) {
            if (!this.myGroups.get(i2).getName().equals("default")) continue;
            return i2;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsers";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/url/template/UrlEditorModel";
                break;
            }
            case 3: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/url/template/UrlEditorModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveGroup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setUrl";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 15: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setParameter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParameter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isValidUrlValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "assign";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "commonParameters";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "transferParameters";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getParameterRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

