/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.ssh;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.codec.DecoderException;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.git4idea.GitExternalApp;
import org.jetbrains.git4idea.util.ScriptGenerator;
import org.jetbrains.ide.BuiltInServerManager;

public abstract class GitXmlRpcHandlerService<T> {
    @NotNull
    private final String myScriptTempFilePrefix;
    @NotNull
    private final String myHandlerName;
    @NotNull
    private final Class<? extends GitExternalApp> myScriptMainClass;
    @Nullable
    private File myBatchScriptPath;
    @Nullable
    private File myShellScriptPath;
    @NotNull
    private final Object SCRIPT_FILE_LOCK;
    @NotNull
    private final THashMap<UUID, T> handlers;
    @NotNull
    private final Object HANDLERS_LOCK;

    protected GitXmlRpcHandlerService(@NotNull String prefix, @NotNull String handlerName, @NotNull Class<? extends GitExternalApp> aClass) {
        if (prefix == null) {
            GitXmlRpcHandlerService.$$$reportNull$$$0(0);
        }
        if (handlerName == null) {
            GitXmlRpcHandlerService.$$$reportNull$$$0(1);
        }
        if (aClass == null) {
            GitXmlRpcHandlerService.$$$reportNull$$$0(2);
        }
        this.SCRIPT_FILE_LOCK = new Object();
        this.handlers = new THashMap();
        this.HANDLERS_LOCK = new Object();
        this.myScriptTempFilePrefix = prefix;
        this.myHandlerName = handlerName;
        this.myScriptMainClass = aClass;
    }

    public int getXmlRcpPort() {
        return BuiltInServerManager.getInstance().waitForStart().getPort();
    }

    @NotNull
    public File getScriptPath() throws IOException {
        File file = this.getScriptPath(SystemInfo.isWindows);
        if (file == null) {
            GitXmlRpcHandlerService.$$$reportNull$$$0(3);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public File getScriptPath(boolean useBatchFile) throws IOException {
        ScriptGenerator generator = new ScriptGenerator(this.myScriptTempFilePrefix, this.myScriptMainClass);
        generator.addClasses(XmlRpcClientLite.class, DecoderException.class, FileUtilRt.class);
        this.customizeScriptGenerator(generator);
        Object object = this.SCRIPT_FILE_LOCK;
        // MONITORENTER : object
        if (useBatchFile) {
            if (this.myBatchScriptPath == null || !this.myBatchScriptPath.exists()) {
                this.myBatchScriptPath = generator.generate(useBatchFile);
            }
            File file = this.myBatchScriptPath;
            // MONITOREXIT : object
            if (file != null) return file;
            GitXmlRpcHandlerService.$$$reportNull$$$0(4);
            return file;
        }
        if (this.myShellScriptPath == null || !this.myShellScriptPath.exists()) {
            this.myShellScriptPath = generator.generate(useBatchFile);
        }
        File file = this.myShellScriptPath;
        // MONITOREXIT : object
        if (file != null) return file;
        GitXmlRpcHandlerService.$$$reportNull$$$0(5);
        return file;
    }

    protected abstract void customizeScriptGenerator(@NotNull ScriptGenerator var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public UUID registerHandler(@NotNull T handler, @NotNull Disposable parentDisposable) {
        if (handler == null) {
            GitXmlRpcHandlerService.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            GitXmlRpcHandlerService.$$$reportNull$$$0(7);
        }
        Object object = this.HANDLERS_LOCK;
        // MONITORENTER : object
        XmlRpcServer xmlRpcServer = XmlRpcServer.SERVICE.getInstance();
        if (!xmlRpcServer.hasHandler(this.myHandlerName)) {
            xmlRpcServer.addHandler(this.myHandlerName, this.createRpcRequestHandlerDelegate());
        }
        final UUID key = UUID.randomUUID();
        this.handlers.put((Object)key, handler);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                GitXmlRpcHandlerService.this.handlers.remove((Object)key);
            }
        });
        UUID uUID = key;
        // MONITOREXIT : object
        if (uUID != null) return uUID;
        GitXmlRpcHandlerService.$$$reportNull$$$0(8);
        return uUID;
    }

    @NotNull
    protected abstract Object createRpcRequestHandlerDelegate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected T getHandler(UUID key) {
        Object object2 = this.HANDLERS_LOCK;
        // MONITORENTER : object2
        Object rc = this.handlers.get((Object)key);
        if (rc == null) {
            throw new IllegalStateException("No handler for the key " + key);
        }
        Object object = rc;
        // MONITOREXIT : object2
        if (object != null) return (T)object;
        GitXmlRpcHandlerService.$$$reportNull$$$0(9);
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandler(UUID key) {
        Object object = this.HANDLERS_LOCK;
        synchronized (object) {
            if (this.handlers.remove((Object)key) == null) {
                throw new IllegalArgumentException("The handler " + key + " is not registered");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handlerName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/git4idea/ssh/GitXmlRpcHandlerService";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/git4idea/ssh/GitXmlRpcHandlerService";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "registerHandler";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

