/*
 * Decompiled with CFR 0.152.
 */
package ini4idea.formatting;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.formatter.common.AbstractBlock;
import ini4idea.lang.IniElementTypes;
import ini4idea.lang.IniTokenTypes;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IniBlock
extends AbstractBlock {
    private final SpacingBuilder spacingBuilder;
    private final Indent myIndent;

    protected IniBlock(@NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, SpacingBuilder spacingBuilder, Indent indent) {
        if (node == null) {
            IniBlock.$$$reportNull$$$0(0);
        }
        super(node, wrap, alignment);
        this.spacingBuilder = spacingBuilder;
        this.myIndent = indent;
    }

    protected List<Block> buildChildren() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (ASTNode child = this.myNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (IniBlock.isWhitespace(child) || child.getTextLength() == 0) continue;
            Alignment alignment = this.createAlignment(child);
            IniBlock block = new IniBlock(child, Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false), alignment, this.spacingBuilder, this.getIndent(child));
            blocks.add((Block)block);
        }
        return blocks;
    }

    private Indent getIndent(ASTNode child) {
        if (this.isMultilineValue(child)) {
            return Indent.getNormalIndent();
        }
        return Indent.getNoneIndent();
    }

    private Alignment createAlignment(ASTNode child) {
        if (this.isMultilineValue(child)) {
            return Alignment.createChildAlignment((Alignment)this.getAlignment());
        }
        return Alignment.createAlignment();
    }

    private boolean isMultilineValue(ASTNode child) {
        return this.getNode().getElementType() == IniElementTypes.INI_VALUE && child.getElementType() == IniTokenTypes.MULTILINE_VALUE_PART;
    }

    private static boolean isWhitespace(ASTNode child) {
        return IniTokenTypes.WHITESPACES.contains(child.getElementType());
    }

    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            IniBlock.$$$reportNull$$$0(1);
        }
        return this.spacingBuilder.getSpacing((Block)this, child1, child2);
    }

    public boolean isLeaf() {
        return this.myNode.getFirstChildNode() == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        objectArray2[1] = "ini4idea/formatting/IniBlock";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacing";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

