/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.codeStyle;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.css.rearranger.CssRearranger;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssArrangementSettingsPanel
extends CodeStyleAbstractPanel {
    @VisibleForTesting
    public static final String VENDOR_PREFIX_PATTERN = "(-[a-z]+-)?";
    private static final Function<List<String>, String> PROPERTIES_LIST_JOINER = strings -> StringUtil.join((Collection)strings, (String)", ");
    private static final Function<String, List<String>> PROPERTIES_LIST_SPLITTER = s -> StringUtil.split((String)s.replace(',', ' '), (String)" ");
    private JPanel myMainPanel;
    private JBCheckBox mySortPropertiesCheckBox;
    private JBRadioButton mySortByNameRadioButton;
    private JBRadioButton myCustomOrderRadioButton;
    private ExpandableTextField myCustomOrderField;

    CssArrangementSettingsPanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        this.mySortPropertiesCheckBox.addActionListener(e -> this.updateControls());
        this.mySortByNameRadioButton.addActionListener(e -> this.updateControls());
        this.myCustomOrderRadioButton.addActionListener(e -> this.updateControls());
        this.myCustomOrderRadioButton.addActionListener(e -> IdeFocusManager.findInstance().requestFocus((Component)this.myCustomOrderField, true));
    }

    protected String getTabTitle() {
        return ApplicationBundle.message((String)"arrangement.title.settings.tab", (Object[])new Object[0]);
    }

    @Nullable
    protected String getPreviewText() {
        return null;
    }

    protected int getRightMargin() {
        Logger.getInstance(CssArrangementSettingsPanel.class).error("This method should not be called because getPreviewText() returns null");
        return 0;
    }

    @NotNull
    protected FileType getFileType() {
        Logger.getInstance(CssArrangementSettingsPanel.class).error("This method should not be called because getPreviewText() returns null");
        FileType fileType = FileTypes.UNKNOWN;
        if (fileType == null) {
            CssArrangementSettingsPanel.$$$reportNull$$$0(0);
        }
        return fileType;
    }

    @Nullable
    protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
        return null;
    }

    @Nullable
    public JComponent getPanel() {
        return this.myMainPanel;
    }

    protected void resetImpl(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CssArrangementSettingsPanel.$$$reportNull$$$0(1);
        }
        StdArrangementSettings arrangementSettings = (StdArrangementSettings)settings.getCommonSettings((Language)CSSLanguage.INSTANCE).getArrangementSettings();
        CssCodeStyleSettings customSettings = (CssCodeStyleSettings)settings.getCustomSettings(CssCodeStyleSettings.class);
        if (arrangementSettings == null || arrangementSettings.getSections().isEmpty()) {
            this.mySortPropertiesCheckBox.setSelected(false);
            this.mySortByNameRadioButton.setSelected(true);
            this.myCustomOrderField.setText(customSettings.PROPERTIES_ORDER);
        } else if (CssRearranger.isSortPropertiesByName((ArrangementSettings)arrangementSettings)) {
            this.mySortPropertiesCheckBox.setSelected(true);
            this.mySortByNameRadioButton.setSelected(true);
            this.myCustomOrderField.setText(customSettings.PROPERTIES_ORDER);
        } else {
            this.mySortPropertiesCheckBox.setSelected(true);
            this.myCustomOrderRadioButton.setSelected(true);
            this.resetCustomListByRules(ArrangementUtil.collectMatchRules((List)arrangementSettings.getSections()));
        }
        this.myCustomOrderField.setCaretPosition(0);
        this.updateControls();
    }

    private void resetCustomListByRules(@NotNull List<StdArrangementMatchRule> rules) {
        if (rules == null) {
            CssArrangementSettingsPanel.$$$reportNull$$$0(2);
        }
        ArrayList<String> customOrder = new ArrayList<String>(rules.size());
        for (StdArrangementMatchRule rule : rules) {
            ArrangementMatchCondition condition = rule.getMatcher().getCondition();
            if (!(condition instanceof ArrangementAtomMatchCondition) || ((ArrangementAtomMatchCondition)condition).getType() != StdArrangementTokens.Regexp.NAME) continue;
            String namePattern = ((ArrangementAtomMatchCondition)condition).getValue().toString();
            String propertyName = StringUtil.trimStart((String)namePattern, (String)VENDOR_PREFIX_PATTERN);
            customOrder.add(propertyName);
        }
        this.myCustomOrderField.setText((String)PROPERTIES_LIST_JOINER.fun(customOrder));
    }

    public boolean isModified(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CssArrangementSettingsPanel.$$$reportNull$$$0(3);
        }
        CssCodeStyleSettings customSettings = (CssCodeStyleSettings)settings.getCustomSettings(CssCodeStyleSettings.class);
        String currentCustomOrder = this.myCustomOrderField.getText();
        if (currentCustomOrder.equals(CssCodeStyleSettings.DEFAULT_PROPERTIES_ORDER) && !currentCustomOrder.equals(customSettings.PROPERTIES_ORDER)) {
            return true;
        }
        StdArrangementSettings saved = (StdArrangementSettings)settings.getCommonSettings((Language)CSSLanguage.INSTANCE).getArrangementSettings();
        StdArrangementSettings fromUI = this.getSettingsFromUI();
        if (saved == null || saved.getRules().isEmpty()) {
            return !fromUI.getRules().isEmpty();
        }
        return !saved.equals((Object)fromUI);
    }

    public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
        if (settings == null) {
            CssArrangementSettingsPanel.$$$reportNull$$$0(4);
        }
        settings.getCommonSettings((Language)CSSLanguage.INSTANCE).setArrangementSettings((ArrangementSettings)this.getSettingsFromUI());
        String currentCustomOrder = this.myCustomOrderField.getText();
        if (this.mySortPropertiesCheckBox.isSelected() && this.myCustomOrderRadioButton.isSelected() || currentCustomOrder.equals(CssCodeStyleSettings.DEFAULT_PROPERTIES_ORDER)) {
            CssCodeStyleSettings customSettings = (CssCodeStyleSettings)settings.getCustomSettings(CssCodeStyleSettings.class);
            customSettings.PROPERTIES_ORDER = this.myCustomOrderField.getText();
        }
    }

    @NotNull
    private StdArrangementSettings getSettingsFromUI() {
        if (!this.mySortPropertiesCheckBox.isSelected()) {
            StdArrangementSettings stdArrangementSettings = new StdArrangementSettings();
            if (stdArrangementSettings == null) {
                CssArrangementSettingsPanel.$$$reportNull$$$0(5);
            }
            return stdArrangementSettings;
        }
        if (this.mySortByNameRadioButton.isSelected()) {
            StdArrangementSettings stdArrangementSettings = new StdArrangementSettings(Collections.singletonList(ArrangementSectionRule.create((StdArrangementMatchRule[])new StdArrangementMatchRule[]{CssRearranger.SORT_BY_NAME_RULE})));
            if (stdArrangementSettings == null) {
                CssArrangementSettingsPanel.$$$reportNull$$$0(6);
            }
            return stdArrangementSettings;
        }
        List properties = (List)PROPERTIES_LIST_SPLITTER.fun((Object)this.myCustomOrderField.getText());
        ArrayList<StdArrangementMatchRule> rules = new ArrayList<StdArrangementMatchRule>(properties.size());
        for (String propertyName : properties) {
            String namePattern = VENDOR_PREFIX_PATTERN + propertyName;
            rules.add(new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.Regexp.NAME, (Object)namePattern)), StdArrangementTokens.Order.BY_NAME));
        }
        StdArrangementSettings stdArrangementSettings = new StdArrangementSettings(Collections.singletonList(ArrangementSectionRule.create((StdArrangementMatchRule[])rules.toArray(new StdArrangementMatchRule[0]))));
        if (stdArrangementSettings == null) {
            CssArrangementSettingsPanel.$$$reportNull$$$0(7);
        }
        return stdArrangementSettings;
    }

    private void updateControls() {
        this.mySortByNameRadioButton.setEnabled(this.mySortPropertiesCheckBox.isSelected());
        this.myCustomOrderRadioButton.setEnabled(this.mySortPropertiesCheckBox.isSelected());
        this.myCustomOrderField.setEnabled(this.myCustomOrderRadioButton.isEnabled() && this.myCustomOrderRadioButton.isSelected());
    }

    private void createUIComponents() {
        this.myCustomOrderField = new ExpandableTextField(PROPERTIES_LIST_SPLITTER, PROPERTIES_LIST_JOINER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/codeStyle/CssArrangementSettingsPanel";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/codeStyle/CssArrangementSettingsPanel";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsFromUI";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetCustomListByRules";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        this.mySortPropertiesCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Sort CSS properties");
        jBCheckBox.setMnemonic('S');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySortByNameRadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("By name");
        jBRadioButton2.setMnemonic('B');
        jBRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myCustomOrderRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Custom order:");
        jBRadioButton.setMnemonic('C');
        jBRadioButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        ExpandableTextField expandableTextField = this.myCustomOrderField;
        jPanel.add((Component)expandableTextField, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setForeground(new Color(-8882056));
        jBLabel.setText("Comma-separated list of CSS properties without vendor prefix");
        jPanel.add((Component)jBLabel, new GridConstraints(3, 1, 1, 1, 8, 0, 7, 0, new Dimension(0, -1), null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

