/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.components;

import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.nodejs.run.profile.cpu.view.TreeTableModelWithCustomRenderer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;

public class ChainTreeTableModel
implements TreeTableModelWithCustomRenderer {
    private final ColumnInfo[] myColumns;
    private final Node<Object> myRoot;

    public ChainTreeTableModel(ColumnInfo[] columns) {
        this.myColumns = columns;
        this.myRoot = new Node<Object>(new Object(), new ArrayList());
    }

    public void addTopKey(Node key) {
        this.myRoot.getChildren().add(key);
    }

    public Node createNode(Object o) {
        Node<Object> node = new Node<Object>(o, new ArrayList());
        return node;
    }

    private static Object castForColumns(Object object) {
        if (object instanceof Node) {
            return ((Node)object).getT();
        }
        return object;
    }

    public int getColumnCount() {
        return this.myColumns.length;
    }

    public String getColumnName(int column) {
        return this.myColumns[column].getName();
    }

    public Class getColumnClass(int column) {
        return column == 0 ? TreeTableModel.class : String.class;
    }

    @Override
    public TableCellRenderer getCustomizedRenderer(int column, Object o, TableCellRenderer renderer) {
        return this.myColumns[column].getCustomizedRenderer(ChainTreeTableModel.castForColumns(o), renderer);
    }

    public Object getValueAt(Object node, int column) {
        return this.myColumns[column].valueOf(ChainTreeTableModel.castForColumns(node));
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public void setValueAt(Object aValue, Object node, int column) {
    }

    public void setTree(JTree tree) {
    }

    public Object getRootObject() {
        return this.myRoot.getT();
    }

    public Object getRoot() {
        return this.myRoot;
    }

    public Object getChild(Object parent, int index) {
        List<Node<?>> children = this.getChildren(parent);
        if (children == null || children.size() <= index) {
            return null;
        }
        return children.get(index);
    }

    public int getChildCount(Object parent) {
        List<Node<?>> children = this.getChildren(parent);
        if (children == null) {
            return 0;
        }
        return children.size();
    }

    public boolean isLeaf(Object node) {
        List<Node<?>> children = this.getChildren(node);
        if (children == null) {
            return true;
        }
        return children.isEmpty();
    }

    public int getIndexOfChild(Object parent, Object child) {
        List<Node<?>> children = this.getChildren(parent);
        if (children == null) {
            return 0;
        }
        for (int i = 0; i < children.size(); ++i) {
            Node<?> current = children.get(i);
            if (!child.equals(current)) continue;
            return i;
        }
        return 0;
    }

    protected List<Node<?>> getChildren(Object object) {
        if (!(object instanceof Node)) {
            return null;
        }
        Node node = (Node)object;
        return this.filter(node.getChildren());
    }

    protected List<Node<?>> filter(List<Node<?>> children) {
        return children;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    public static class Node<T> {
        private final T myT;
        private final List<Node<T>> myChildren;
        private int myMeaningfulChildren;
        private boolean myOnlyPartOfChildren;

        Node(T t, List<Node<T>> children) {
            this.myT = t;
            this.myChildren = children;
        }

        public int getMeaningfulChildren() {
            return this.myMeaningfulChildren;
        }

        public void setMeaningfulChildren(int meaningfulChildren) {
            this.myMeaningfulChildren = meaningfulChildren;
        }

        public T getT() {
            return this.myT;
        }

        public List<Node<T>> getChildren() {
            return this.myChildren;
        }

        public boolean isOnlyPartOfChildren() {
            return this.myOnlyPartOfChildren;
        }

        public void setOnlyPartOfChildren(boolean onlyPartOfChildren) {
            this.myOnlyPartOfChildren = onlyPartOfChildren;
        }

        public String toString() {
            return this.myT.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.myT.equals(node.myT);
        }

        public int hashCode() {
            return this.myT.hashCode();
        }
    }
}

