/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerRunningData;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerAbstractAction;
import com.jetbrains.php.composer.actions.ComposerActionCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerCommandExecutor;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.configData.PackageComposerConfigClient;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerInstallAction
extends ComposerAbstractAction {
    @Override
    protected void doPerformAction(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerInstallAction.$$$reportNull$$$0(0);
        }
        if (configFile == null) {
            ComposerInstallAction.$$$reportNull$$$0(1);
        }
        if (placeForStatistics == null) {
            ComposerInstallAction.$$$reportNull$$$0(2);
        }
        ComposerCommandExecutor commandExecutor = ComposerInstallAction.createExecutor(project, ComposerDataService.getInstance(project), configFile, "--no-interaction --ansi", placeForStatistics);
        commandExecutor.execute();
    }

    @NotNull
    protected static ComposerCommandExecutor createExecutor(final @NotNull Project project, final @NotNull ComposerRunningData runningData, final @NotNull VirtualFile configFile, final @Nullable String commandLineOptions, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerInstallAction.$$$reportNull$$$0(3);
        }
        if (runningData == null) {
            ComposerInstallAction.$$$reportNull$$$0(4);
        }
        if (configFile == null) {
            ComposerInstallAction.$$$reportNull$$$0(5);
        }
        if (placeForStatistics == null) {
            ComposerInstallAction.$$$reportNull$$$0(6);
        }
        ComposerActionStatistics statistics = ComposerActionStatistics.createWithoutOptions("install", placeForStatistics);
        ComposerActionCommandExecutor.WithConfig withConfig = new ComposerActionCommandExecutor.WithConfig(project, runningData, configFile, commandLineOptions, statistics, true, false){

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List<String> list = ComposerUtils.getSimpleBasicCommand(runningData, "install");
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            protected String getProgressTitle() {
                return PhpBundle.message("framework.composer.install.task.title", new Object[0]);
            }

            @Override
            protected String getActionName() {
                return PhpBundle.message("framework.composer.install.action.name", new Object[0]);
            }

            @Override
            protected void onFinish(boolean success) {
                super.onFinish(success);
                ComposerUtils.refreshVendorDir(configFile);
                ComposerAbstractAction.refreshConfigAndLockFiles(configFile, () -> {
                    if (project == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    PackageComposerConfigClient.updatePackagesSettings(project);
                });
            }

            @Override
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                String configFilePath = configFile.getPath();
                List<String> beginning = this.myRunningData.getComposerCommandBeginning();
                return ComposerInstallAction.createGenerator(() -> beginning, configFilePath, commandLineOptions);
            }

            @Override
            @Nls(capitalization=Nls.Capitalization.Title)
            @NotNull
            protected String getTaskTitle() {
                if ("Install Composer Packages" == null) {
                    1.$$$reportNull$$$0(1);
                }
                return "Install Composer Packages";
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createSuccessfulSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage().appendText("All packages for ").appendLink(this.myComposerJson, this.myProject).appendText(" have been installed.");
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createFailureSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage().appendText("Failed to install packages for  ").appendLink(this.myComposerJson, this.myProject).appendText(".");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerInstallAction$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBasicCommand";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTaskTitle";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerInstallAction$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "lambda$onFinish$0";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (withConfig == null) {
            ComposerInstallAction.$$$reportNull$$$0(7);
        }
        return withConfig;
    }

    @NotNull
    private static ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> createGenerator(@NotNull ComposerRunningData data, @NotNull String configFilePath, @Nullable String commandLineOptions) {
        if (data == null) {
            ComposerInstallAction.$$$reportNull$$$0(8);
        }
        if (configFilePath == null) {
            ComposerInstallAction.$$$reportNull$$$0(9);
        }
        ThrowableNotNullFunction throwableNotNullFunction = generatorProject -> {
            if (configFilePath == null) {
                ComposerInstallAction.$$$reportNull$$$0(11);
            }
            if (data == null) {
                ComposerInstallAction.$$$reportNull$$$0(12);
            }
            VirtualFile generatorConfigFile = LocalFileSystem.getInstance().findFileByPath(configFilePath);
            ComposerCommandExecutor.checkFileExists(configFilePath, generatorConfigFile);
            return ComposerInstallAction.createExecutor(generatorProject, data, generatorConfigFile, commandLineOptions, "ComposerLogRerun");
        };
        if (throwableNotNullFunction == null) {
            ComposerInstallAction.$$$reportNull$$$0(10);
        }
        return throwableNotNullFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeForStatistics";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runningData";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerInstallAction";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerInstallAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doPerformAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createExecutor";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createGenerator";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createGenerator$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

