/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.codeStyle.constructor;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/php/lang/inspections/codeStyle/constructor/PhpReplaceOldStyleConstructorWithNewStyleQuickFix;", "Lcom/jetbrains/php/lang/inspections/quickfix/PhpQuickFixBase;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "fixConstructor", "method", "Lcom/jetbrains/php/lang/psi/elements/Method;", "getFamilyName", "", "intellij.php.impl"})
public final class PhpReplaceOldStyleConstructorWithNewStyleQuickFix
extends PhpQuickFixBase {
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.convert.to.new.style.constructor", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PhpBundle.message(\"quick\u2026o.new.style.constructor\")");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
        PsiElement nameElement = descriptor.getPsiElement();
        Method psiElement = (Method)PhpPsiUtil.getParentByCondition(nameElement, (Condition<? super PsiElement>)Method.INSTANCEOF);
        this.fixConstructor(project, psiElement);
    }

    public final void fixConstructor(@NotNull Project project, @Nullable Method method) {
        block4: {
            PhpClass containingClass;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Method method2 = method;
            Object object = containingClass = method2 != null ? method2.getContainingClass() : null;
            if (method == null || containingClass == null) break block4;
            Collection collection = ReferencesSearch.search((PsiElement)((PsiElement)method)).findAll();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"ReferencesSearch.search(method).findAll()");
            Collection search = collection;
            Iterator iterator = search.iterator();
            while (iterator.hasNext()) {
                PsiReference it;
                PsiReference psiReference = it = (PsiReference)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiReference, (String)"it");
                if (!(psiReference.getElement() instanceof MethodReference)) continue;
                PsiElement psiElement = it.getElement();
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.MethodReference");
                }
                MethodReference methodReference = (MethodReference)psiElement;
                ASTNode nameNode = methodReference.getNameNode();
                PsiElement firstChild = methodReference.getFirstChild();
                PsiElement sibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace(firstChild, true);
                if (nameNode == null) continue;
                nameNode.getPsi().replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.IDENTIFIER, "function __construct(){}"));
                if (!PhpPsiUtil.isOfType(firstChild, (IElementType)PhpElementTypes.VARIABLE)) continue;
                PsiElement psiElement2 = firstChild;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"firstChild");
                if (!Intrinsics.areEqual((Object)psiElement2.getText(), (Object)"$this") || !PhpPsiUtil.isOfType(sibling, PhpTokenTypes.ARROW)) continue;
                PsiElement psiElement3 = sibling;
                if (psiElement3 != null) {
                    psiElement3.replace(PhpPsiElementFactory.createScopeResolution(project));
                }
                firstChild.replace((PsiElement)PhpPsiElementFactory.createClassReference(project, containingClass.getName()));
            }
            PsiElement psiElement = method.getNameIdentifier();
            if (psiElement != null) {
                psiElement.replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.IDENTIFIER, "function __construct(){}"));
            }
        }
    }
}

