/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.HyperlinkLabel;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.config.PhpAnalysisConfiguration;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocThrowsTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpThrownExceptionsAnalyzer;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocRedundantThrowsInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/php/lang/inspections/phpdoc/PhpDocRedundantThrowsInspection;", "Lcom/jetbrains/php/lang/inspections/PhpInspection;", "()V", "buildVisitor", "Lcom/jetbrains/php/lang/psi/visitors/PhpElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "createOptionsPanel", "Ljavax/swing/JComponent;", "Companion", "PhpRemoveThrowsTagQuickFix", "intellij.php.impl"})
public final class PhpDocRedundantThrowsInspection
extends PhpInspection {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PhpElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new PhpElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitPhpMethod(@NotNull Method method) {
                Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
                if (method.isAbstract()) {
                    return;
                }
                this.visitPhpFunction((Function)method);
            }

            public void visitPhpFunction(@NotNull Function function) {
                Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
                PhpDocComment docComment = function.getDocComment();
                if (docComment == null) {
                    return;
                }
                PhpType thrownExceptions = this.getThrownExceptions((PhpScopeHolder)function);
                Project project = function.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"function.project");
                Project p = project;
                PhpIndex phpIndex = PhpIndex.getInstance((Project)p);
                Intrinsics.checkExpressionValueIsNotNull((Object)phpIndex, (String)"PhpIndex.getInstance(p)");
                PhpIndex index = phpIndex;
                for (PhpDocTag throwsTag : this.getThrowsTags(docComment)) {
                    if (!(throwsTag instanceof PhpDocThrowsTag)) {
                        return;
                    }
                    PhpType declaredException = this.getException((PhpDocThrowsTag)throwsTag);
                    if (!thrownExceptions.isEmpty() && (PhpDocRedundantThrowsInspection.Companion.isRuntime(declaredException, p) || declaredException.isConvertibleFrom(thrownExceptions, index))) continue;
                    StringBuilder stringBuilder = new StringBuilder().append("Exception '");
                    Set set = declaredException.getTypes();
                    Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"declaredException.types");
                    String m = stringBuilder.append(PhpLangUtil.toShortName((String)CollectionsKt.single((Iterable)set))).append("' is never thrown in the function").toString();
                    this.$holder.registerProblem((PsiElement)throwsTag, m, new LocalQuickFix[]{PhpRemoveThrowsTagQuickFix.Companion.getINSTANCE(), PhpDocSignatureInspection.UPDATE_PHP_DOC_QUICK_FIX});
                }
            }

            /*
             * WARNING - void declaration
             */
            private final PhpType getThrownExceptions(@NotNull PhpScopeHolder $receiver) {
                void $receiver$iv;
                PhpType initial$iv;
                Set<PhpType> set = PhpThrownExceptionsAnalyzer.getExceptionClasses($receiver, null, false);
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"PhpThrownExceptionsAnaly\u2026lasses(this, null, false)");
                Iterable iterable = set;
                PhpType accumulator$iv = initial$iv = new PhpType();
                for (T element$iv : $receiver$iv) {
                    void it;
                    PhpType phpType = (PhpType)element$iv;
                    PhpType acc = accumulator$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)acc.add((PhpType)it), (String)"acc.add(it)");
                }
                PhpType phpType = accumulator$iv.add(PhpType.EXCEPTION).add(PhpType.THROWABLE);
                Intrinsics.checkExpressionValueIsNotNull((Object)phpType, (String)"PhpThrownExceptionsAnaly\u2026  .add(PhpType.THROWABLE)");
                return phpType;
            }

            private final PhpDocTag[] getThrowsTags(@NotNull PhpDocComment $receiver) {
                PhpDocTag[] phpDocTagArray = $receiver.getTagElementsByName("@throws");
                Intrinsics.checkExpressionValueIsNotNull((Object)phpDocTagArray, (String)"this.getTagElementsByName(PhpDocUtil.THROWS_TAG)");
                return phpDocTagArray;
            }

            /*
             * WARNING - void declaration
             */
            private final PhpType getException(@NotNull PhpDocThrowsTag $receiver) {
                void $receiver$iv;
                PhpType initial$iv;
                PhpDocType phpDocType = (PhpDocType)PhpPsiUtil.getChildByCondition((PsiElement)$receiver, (Condition<? super PsiElement>)PhpDocType.INSTANCEOF);
                if (phpDocType == null || (phpDocType = phpDocType.getType()) == null) {
                    PhpType phpType = PhpType.EMPTY;
                    Intrinsics.checkExpressionValueIsNotNull((Object)phpType, (String)"PhpType.EMPTY");
                    return phpType;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)phpDocType, (String)"PhpPsiUtil.getChildByCon\u2026e ?: return PhpType.EMPTY");
                PhpDocType type = phpDocType;
                Collection<String> collection = PhpThrownExceptionsAnalyzer.filterNonThrowable((PhpType)type, $receiver.getProject());
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"PhpThrownExceptionsAnaly\u2026nThrowable(type, project)");
                Iterable iterable = collection;
                PhpType accumulator$iv = initial$iv = new PhpType();
                for (T element$iv : $receiver$iv) {
                    void it;
                    String string = (String)element$iv;
                    PhpType acc = accumulator$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)acc.add((String)it), (String)"acc.add(it)");
                }
                return accumulator$iv;
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public JComponent createOptionsPanel() {
        HyperlinkLabel settingsLink = new HyperlinkLabel(PhpBundle.message("exception.analysis.settings.path", new Object[0]));
        settingsLink.addHyperlinkListener((HyperlinkListener)createOptionsPanel.1.INSTANCE);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)settingsLink, "North");
        return panel;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/php/lang/inspections/phpdoc/PhpDocRedundantThrowsInspection$PhpRemoveThrowsTagQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "Companion", "intellij.php.impl"})
    private static final class PhpRemoveThrowsTagQuickFix
    implements LocalQuickFix {
        @NotNull
        private static final PhpRemoveThrowsTagQuickFix INSTANCE;
        public static final Companion Companion;

        @NotNull
        public String getFamilyName() {
            return "Remove @throws tag";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
            PsiElement psiElement = descriptor.getPsiElement();
            if (!(psiElement instanceof PhpDocThrowsTag)) {
                psiElement = null;
            }
            PhpDocThrowsTag phpDocThrowsTag = (PhpDocThrowsTag)psiElement;
            if (phpDocThrowsTag == null) {
                return;
            }
            PhpDocThrowsTag throwsTag = phpDocThrowsTag;
            PhpPsiElement next = throwsTag.getNextPsiSibling();
            PsiElement psiElement2 = throwsTag.getNextSibling();
            if (psiElement2 == null) {
                psiElement2 = (PsiElement)throwsTag;
            }
            PsiElement last = psiElement2;
            throwsTag.getParent().deleteChildRange(PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)throwsTag, true), last);
            if (next != null) {
                Editor editor = PsiUtilBase.findEditor((PsiElement)((PsiElement)next));
                if (editor == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"PsiUtilBase.findEditor(next) ?: return");
                Editor editor2 = editor;
                editor2.getCaretModel().moveToOffset(next.getTextOffset());
                editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }

        static {
            Companion = new Companion(null);
            INSTANCE = new PhpRemoveThrowsTagQuickFix();
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/php/lang/inspections/phpdoc/PhpDocRedundantThrowsInspection$PhpRemoveThrowsTagQuickFix$Companion;", "", "()V", "INSTANCE", "Lcom/jetbrains/php/lang/inspections/phpdoc/PhpDocRedundantThrowsInspection$PhpRemoveThrowsTagQuickFix;", "getINSTANCE", "()Lcom/jetbrains/php/lang/inspections/phpdoc/PhpDocRedundantThrowsInspection$PhpRemoveThrowsTagQuickFix;", "intellij.php.impl"})
        public static final class Companion {
            @NotNull
            public final PhpRemoveThrowsTagQuickFix getINSTANCE() {
                return INSTANCE;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/php/lang/inspections/phpdoc/PhpDocRedundantThrowsInspection$Companion;", "", "()V", "isRuntime", "", "Lcom/jetbrains/php/lang/psi/resolve/types/PhpType;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.php.impl"})
    public static final class Companion {
        public final boolean isRuntime(@NotNull PhpType $receiver, @NotNull Project project) {
            boolean bl;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                PhpAnalysisConfiguration configuration = PhpAnalysisConfiguration.getInstance(project);
                PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
                Intrinsics.checkExpressionValueIsNotNull((Object)phpIndex, (String)"PhpIndex.getInstance(project)");
                PhpIndex index = phpIndex;
                PhpAnalysisConfiguration phpAnalysisConfiguration = configuration;
                Intrinsics.checkExpressionValueIsNotNull((Object)phpAnalysisConfiguration, (String)"configuration");
                Set<String> set = phpAnalysisConfiguration.getUncheckedExceptions();
                Intrinsics.checkExpressionValueIsNotNull(set, (String)"configuration.uncheckedExceptions");
                Iterable $receiver$iv = set;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        String it = (String)element$iv;
                        if (!new PhpType().add(it).isConvertibleFrom($receiver, index)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

