/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.CaseInsensitiveCharSequenceHashingStrategy;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocPropertyTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpClassStub;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpClassImpl
extends PhpNamedElementImpl<PhpClassStub>
implements PhpClass {
    private static final boolean FIELDS_FROM_CONSTRUCTORS = true;
    private static final TokenSet FIELDS_TS = TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.CLASS_FIELDS, PhpElementTypes.CLASS_CONSTANTS});
    private static final Function<PhpClass, Icon> CLASS_ICON_EVALUATOR = clazz -> {
        if (clazz.isTrait()) {
            return PhpIcons.TRAIT;
        }
        if (clazz.isInterface()) {
            return PhpIcons.INTERFACE;
        }
        Ref isTestClassRef = new Ref((Object)false);
        Ref isExceptionClassRef = new Ref((Object)false);
        if (clazz.isValid() && !DumbService.getInstance((Project)clazz.getProject()).isDumb()) {
            PhpClassHierarchyUtils.processSuperClasses((PhpClass)clazz, (boolean)true, (boolean)true, aClass -> {
                if (PhpUnitUtil.isRootTestClass(aClass)) {
                    isTestClassRef.set((Object)true);
                } else if (PhpLangUtil.equalsClassNames("Exception", aClass.getNameCS())) {
                    isExceptionClassRef.set((Object)true);
                }
                return (Boolean)isTestClassRef.get() == false && (Boolean)isExceptionClassRef.get() == false;
            });
        }
        if (((Boolean)isTestClassRef.get()).booleanValue()) {
            if (clazz.isFinal()) {
                return PhpIcons.FINAL_TEST_CLASS;
            }
            if (clazz.isAbstract()) {
                return PhpIcons.ABSTRACT_TEST_CLASS;
            }
            return PhpIcons.PHP_TEST_CLASS;
        }
        if (((Boolean)isExceptionClassRef.get()).booleanValue()) {
            if (clazz.isFinal()) {
                return PhpIcons.FINAL_EXCEPTION;
            }
            if (clazz.isAbstract()) {
                return PhpIcons.ABSTRACT_EXCEPTION;
            }
            return PhpIcons.EXCEPTION;
        }
        if (clazz.isAbstract()) {
            return PhpIcons.ABSTRACT_CLASS;
        }
        if (clazz.isFinal()) {
            return PhpIcons.FINAL_CLASS;
        }
        return PhpIcons.CLASS;
    };
    public static final TokenSet FIELDS = TokenSet.create((IElementType[])new IElementType[]{PhpStubElementTypes.CLASS_FIELD, PhpStubElementTypes.CLASS_CONST});
    private CachedValue<MultiMap<CharSequence, Field>> ownFieldsCache;
    private CachedValue<MultiMap<CharSequence, Method>> ownMethodsCache;

    public PhpClassImpl(ASTNode node) {
        super(node);
    }

    public PhpClassImpl(PhpClassStub stub) {
        super(stub, PhpStubElementTypes.CLASS);
    }

    public Collection<Field> getFields() {
        HashMap<Pair<String, Boolean>, Field> allFields = new HashMap<Pair<String, Boolean>, Field>();
        PhpClassImpl.getFieldsInternal(this, allFields);
        return allFields.values();
    }

    private static void getFieldsInternal(PhpClass phpClass, Map<Pair<String, Boolean>, Field> allFields) {
        PhpClassHierarchyUtils.processFields((PhpClass)phpClass, (PhpClass)phpClass, (field, subClass, baseClass) -> {
            String name = field.getName();
            if (!StringUtil.isEmpty((String)name)) {
                PhpClass currentContainingClass;
                Pair key = Pair.create((Object)(name = name.toLowerCase()), (Object)field.isConstant());
                Field current = (Field)allFields.get(key);
                PhpClass phpClass = currentContainingClass = current == null ? null : current.getContainingClass();
                if (!(current != null && field instanceof MyRenamableFakePsiElement || currentContainingClass != null && !PhpLangUtil.isObject(currentContainingClass) && !currentContainingClass.isTrait())) {
                    allFields.put(key, field);
                }
            }
            return true;
        }, (boolean)false);
    }

    public Field[] getOwnFields() {
        Collection values = this.getOwnFieldMap().values();
        return (Field[])values.toArray(Field.ARRAY_FACTORY.create(values.size()));
    }

    public MultiMap<CharSequence, Field> getOwnFieldMap() {
        if (this.ownFieldsCache == null) {
            CachedValueProvider provider = () -> new CachedValueProvider.Result(this.getOwnFieldsInternal(), new Object[]{this});
            this.ownFieldsCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(provider, false);
        }
        return (MultiMap)this.ownFieldsCache.getValue();
    }

    private MultiMap<CharSequence, Field> getOwnFieldsInternal() {
        Field[] comment;
        MultiMap fields = MultiMap.create();
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if ((stub == null || stub.hasPropertyTags()) && (comment = this.getDocComment()) != null) {
            List tags = comment.getPropertyTags();
            for (PhpDocPropertyTag tag : tags) {
                String phpDocPropertyName;
                PhpDocProperty phpDocProperty = tag.getProperty();
                if (phpDocProperty == null || (phpDocPropertyName = phpDocProperty.getName()).isEmpty()) continue;
                fields.putValue((Object)phpDocPropertyName, (Object)phpDocProperty);
            }
        }
        if (stub != null) {
            for (Field field : (Field[])stub.getChildrenByType(FIELDS, Field.ARRAY_FACTORY)) {
                fields.putValue((Object)field.getName(), (Object)field);
            }
        } else {
            for (PsiElement element : this.findChildrenByType(FIELDS_TS)) {
                for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!(child instanceof Field)) continue;
                    fields.putValue((Object)((Field)child).getName(), (Object)((Field)child));
                }
            }
        }
        if (stub == null || stub.hasConstructorFields()) {
            Map<String, AssignmentExpression> map = PhpClassImpl.getAssignmentsPerField(this);
            for (String name : map.keySet()) {
                AssignmentExpression expression;
                PhpPsiElement variable;
                if (fields.containsKey((Object)name) || !((variable = (expression = map.get(name)).getVariable()) instanceof FieldReference)) continue;
                MyRenamableFakePsiElement field = new MyRenamableFakePsiElement((PsiElement)this, expression, (FieldReference)variable);
                fields.putValue((Object)name, (Object)field);
            }
        }
        return fields;
    }

    public Collection<Method> getMethods() {
        HashMap allMethods = new HashMap();
        PhpClassHierarchyUtils.processMethods((PhpClass)this, (PhpClass)this, (method, subClass, baseClass) -> {
            String methodName = method.getName();
            if (!StringUtil.isEmpty((String)methodName)) {
                PhpClass currentContainingClass;
                Method current = (Method)allMethods.get(methodName = methodName.toLowerCase());
                PhpClass phpClass = currentContainingClass = current == null ? null : current.getContainingClass();
                if (currentContainingClass == null || PhpLangUtil.isObject(currentContainingClass) || current.isAbstract() && currentContainingClass.isTrait() && !method.isAbstract()) {
                    allMethods.put(methodName, method);
                }
            }
            return true;
        }, (boolean)false);
        return allMethods.values();
    }

    public Method[] getOwnMethods() {
        return this.getOwnMethodsMap().values().toArray(Method.EMPTY);
    }

    public MultiMap<CharSequence, Method> getOwnMethodsMap() {
        if (this.ownMethodsCache == null) {
            CachedValueProvider provider = () -> new CachedValueProvider.Result(this.getOwnMethodsInternal(), new Object[]{this});
            this.ownMethodsCache = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(provider, false);
        }
        return (MultiMap)this.ownMethodsCache.getValue();
    }

    public MultiMap<CharSequence, Method> getOwnMethodsInternal() {
        PhpDocMethod[] tags;
        PhpDocComment comment;
        MultiMap result = MultiMap.create((TObjectHashingStrategy)CaseInsensitiveCharSequenceHashingStrategy.INSTANCE);
        Method[] normalMethods = (Method[])this.getStubOrPsiChildren(PhpStubElementTypes.CLASS_METHOD, Method.ARRAY_FACTORY);
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if ((stub == null || stub.hasMethodTags()) && (comment = this.getDocComment()) != null && (tags = comment.getMethods()).length > 0) {
            boolean i = false;
            for (PhpDocMethod method : tags) {
                result.putValue((Object)method.getName(), (Object)method);
            }
        }
        for (Method method : normalMethods) {
            result.putValue((Object)method.getName(), (Object)method);
        }
        return result;
    }

    public boolean hasMethodTags() {
        PhpDocComment comment = this.getDocComment();
        if (comment == null) {
            return false;
        }
        return comment.getMethods().length > 0;
    }

    public boolean hasPropertyTags() {
        PhpDocComment comment = this.getDocComment();
        if (comment == null) {
            return false;
        }
        return comment.getPropertyTags().size() > 0;
    }

    public boolean hasConstructorFields() {
        for (Field ownField : this.getOwnFieldMap().values()) {
            if (!(ownField instanceof MyRenamableFakePsiElement)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getSuperName() {
        String superFQN = this.getSuperFQN();
        if (superFQN != null) {
            int i = superFQN.lastIndexOf(92);
            return i >= 0 ? superFQN.substring(i + 1) : superFQN;
        }
        return null;
    }

    public String getSuperFQN() {
        if (this.isInterface()) {
            return null;
        }
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.getSuperclass();
        }
        ClassReference superRef = this.getSuperRef();
        return superRef != null ? superRef.getFQN() : null;
    }

    @Nullable
    private ClassReference getSuperRef() {
        ExtendsList list = this.getExtendsList();
        return (ClassReference)ContainerUtil.getFirstItem((List)list.getReferenceElements());
    }

    @Nullable
    public PhpClass getSuperClass() {
        Collection classes;
        String superName = this.getSuperFQN();
        PhpIndex phpIndex = PhpIndex.getInstance((Project)this.getProject());
        Collection collection = classes = this.isInterface() ? phpIndex.getInterfacesByFQN(superName) : phpIndex.getClassesByFQN(superName);
        if (classes.size() == 1) {
            return (PhpClass)classes.iterator().next();
        }
        return PhpClassImpl.selectBestClass(classes, this);
    }

    @Nullable
    public static PhpClass selectBestClass(Collection<? extends PhpClass> classes, PhpPsiElement origin) {
        String my = PhpClassImpl.getPath((PsiElement)origin);
        if (my == null) {
            return null;
        }
        int best = 0;
        PhpClass bestClass = null;
        if (classes.size() > 0) {
            for (PhpClass phpClass : classes) {
                if (phpClass.getContainingFile() == origin.getContainingFile()) {
                    return phpClass;
                }
                String path = PhpClassImpl.getPath((PsiElement)phpClass);
                assert (path != null);
                int i = StringUtil.commonPrefixLength((CharSequence)my, (CharSequence)path);
                if (i <= best) continue;
                best = i;
                bestClass = phpClass;
            }
        }
        return bestClass;
    }

    @Nullable
    static String getPath(PsiElement e) {
        PsiFile file = e.getContainingFile();
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        return virtualFile.getPath();
    }

    @Override
    @NotNull
    public String getNamespaceName() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getNamespaceName();
            if (string == null) {
                PhpClassImpl.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = super.getNamespaceName();
        if (string == null) {
            PhpClassImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String[] getInterfaceNames() {
        List referenceElements;
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            String[] stringArray = stub.getInterfaces();
            if (stringArray == null) {
                PhpClassImpl.$$$reportNull$$$0(2);
            }
            return stringArray;
        }
        List list = referenceElements = !this.isInterface() ? this.getImplementsList().getReferenceElements() : this.getExtendsList().getReferenceElements();
        if (referenceElements.isEmpty()) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                PhpClassImpl.$$$reportNull$$$0(3);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] names = new String[referenceElements.size()];
        int referenceElementsLength = referenceElements.size();
        for (int i = 0; i < referenceElementsLength; ++i) {
            String fqn;
            names[i] = fqn = ((ClassReference)referenceElements.get(i)).getFQN();
        }
        if (names == null) {
            PhpClassImpl.$$$reportNull$$$0(4);
        }
        return names;
    }

    public PhpClass[] getImplementedInterfaces() {
        ArrayList interfaceList = new ArrayList();
        PhpIndex phpIndex = PhpIndex.getInstance((Project)this.getProject());
        for (String fqn : this.getInterfaceNames()) {
            interfaceList.addAll(phpIndex.getInterfacesByFQN(fqn));
        }
        return interfaceList.toArray(PhpClass.EMPTY_ARRAY);
    }

    public boolean hasTraitUses() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasTraitUses();
        }
        return this.getTraitNames().length > 0;
    }

    @NotNull
    public String[] getTraitNames() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            String[] stringArray = stub.getTraits();
            if (stringArray == null) {
                PhpClassImpl.$$$reportNull$$$0(5);
            }
            return stringArray;
        }
        String[] stringArray = (String[])CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            THashSet names = new THashSet();
            for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
                PhpUse[] declarations;
                if (!(child instanceof PhpUseList)) continue;
                for (PhpUse use : declarations = ((PhpUseList)child).getDeclarations()) {
                    PhpReference reference = use.getTargetReference();
                    if (reference == null) continue;
                    names.add(reference.getFQN());
                }
            }
            return new CachedValueProvider.Result((Object)ArrayUtil.toStringArray((Collection)names), new Object[]{this});
        });
        if (stringArray == null) {
            PhpClassImpl.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    public PhpClass[] getTraits() {
        ArrayList traits = new ArrayList();
        PhpIndex phpIndex = PhpIndex.getInstance((Project)this.getProject());
        for (String fqn : this.getTraitNames()) {
            traits.addAll(phpIndex.getTraitsByFQN(fqn));
        }
        return traits.toArray(PhpClass.EMPTY_ARRAY);
    }

    @NotNull
    public String[] getMixinNames() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            String[] stringArray = stub.getMixins();
            if (stringArray == null) {
                PhpClassImpl.$$$reportNull$$$0(7);
            }
            return stringArray;
        }
        String[] stringArray = (String[])CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            THashSet names = new THashSet();
            PhpDocComment comment = this.getDocComment();
            if (comment != null) {
                PhpDocTag[] mixinTags;
                for (PhpDocTag tag : mixinTags = comment.getTagElementsByName("@mixin")) {
                    PhpType type = tag.getType();
                    names.addAll(type.getTypes());
                }
            }
            return new CachedValueProvider.Result((Object)ArrayUtil.toStringArray((Collection)names), new Object[]{this});
        });
        if (stringArray == null) {
            PhpClassImpl.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    public PhpClass[] getMixins() {
        ArrayList mixins = new ArrayList();
        PhpIndex phpIndex = PhpIndex.getInstance((Project)this.getProject());
        for (String fqn : this.getMixinNames()) {
            mixins.addAll(phpIndex.getAnyByFQN(fqn));
        }
        return mixins.toArray(PhpClass.EMPTY_ARRAY);
    }

    @Nullable
    public Method getConstructor() {
        PhpClassImpl aClass = this;
        THashSet visited = new THashSet();
        while (aClass != null && !PhpLangUtil.isObject(aClass)) {
            PhpClass[] traits;
            visited.add(aClass);
            if (aClass.isInterface()) {
                return null;
            }
            Method own = aClass.getOwnConstructor();
            if (own != null) {
                return own;
            }
            for (PhpClass trait : traits = aClass.getTraits()) {
                Method constructor = trait.getOwnConstructor();
                if (constructor == null) continue;
                return constructor;
            }
            if (!visited.contains((Object)(aClass = aClass.getSuperClass()))) continue;
            break;
        }
        return null;
    }

    @Nullable
    public Method getOwnConstructor() {
        if (this.isInterface()) {
            return null;
        }
        Method c = this.findOwnMethodByName("__construct");
        if (c == null && "\\".equals(this.getNamespaceName())) {
            c = this.findOwnMethodByName(this.getName());
        }
        return c;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode nameNode;
        if (name == null) {
            PhpClassImpl.$$$reportNull$$$0(9);
        }
        if ((nameNode = this.getNameNode()) != null && !name.equals(this.getName())) {
            ConstantReference constantReference = PhpPsiElementFactory.createConstantReference(this.getProject(), name);
            ASTNode newNameNode = constantReference.getNameNode();
            assert (newNameNode != null);
            nameNode.getTreeParent().replaceChild(nameNode, newNameNode);
        }
        return this;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor psiElementVisitor) {
        if (psiElementVisitor == null) {
            PhpClassImpl.$$$reportNull$$$0(10);
        }
        if (psiElementVisitor instanceof PhpElementVisitor) {
            ((PhpElementVisitor)psiElementVisitor).visitPhpClass((PhpClass)this);
        } else {
            super.accept(psiElementVisitor);
        }
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = IconDeferrer.getInstance().defer(PhpIcons.CLASS, (Object)this, CLASS_ICON_EVALUATOR);
        if (icon == null) {
            PhpClassImpl.$$$reportNull$$$0(11);
        }
        return icon;
    }

    public boolean isAbstract() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isAbstract();
        }
        return this.isInterface() || this.getNode().getFirstChildNode().getElementType() == PhpTokenTypes.kwABSTACT;
    }

    public boolean isFinal() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isFinal();
        }
        return this.getNode().getFirstChildNode().getElementType() == PhpTokenTypes.kwFINAL;
    }

    public boolean isAnonymous() {
        return this.getStub() == null && this.getParent() instanceof NewExpression && this.getNameNode() == null && this.findChildByClass(PsiErrorElement.class) == null;
    }

    public boolean isInterface() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isInterface();
        }
        return this.getNode().getFirstChildNode().getElementType() == PhpTokenTypes.kwINTERFACE;
    }

    public boolean isTrait() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isTrait();
        }
        return this.getNode().getFirstChildNode().getElementType() == PhpTokenTypes.kwTRAIT;
    }

    public List<PhpTraitUseRule> getTraitUseRules() {
        if (this.getGreenStub() != null) {
            PhpTraitUseRule[] stubRules = (PhpTraitUseRule[])this.getStubOrPsiChildren(PhpStubElementTypes.TRAIT_USE_RULE, PhpTraitUseRule.ARRAY_FACTORY);
            if (stubRules.length > 0) {
                return Arrays.asList(stubRules);
            }
            return Collections.emptyList();
        }
        ArrayList<PhpTraitUseRule> rules = new ArrayList<PhpTraitUseRule>();
        for (PhpUseList useList : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, PhpUseList.class)) {
            rules.addAll(PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)useList, PhpTraitUseRule.class));
        }
        return rules;
    }

    public boolean hasStaticMembers() {
        THashSet visited = new THashSet();
        PhpClassImpl phpClass = this;
        do {
            if (phpClass.hasOwnStaticMembers()) {
                return true;
            }
            visited.add(phpClass);
            phpClass = phpClass.getSuperClass();
            if (phpClass != null && !PhpLangUtil.isObject(phpClass)) continue;
            return false;
        } while (!visited.contains((Object)phpClass));
        return false;
    }

    public boolean hasOwnStaticMembers() {
        PhpClassStub stub = (PhpClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasOwnStaticMembers();
        }
        for (Method method : this.getOwnMethods()) {
            if (!method.isStatic()) continue;
            return true;
        }
        for (Field field : this.getOwnFieldMap().values()) {
            if (!field.getModifier().isStatic()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public PhpModifier getModifier() {
        if (this.isAbstract()) {
            PhpModifier phpModifier = PhpModifier.PUBLIC_ABSTRACT_DYNAMIC;
            if (phpModifier == null) {
                PhpClassImpl.$$$reportNull$$$0(12);
            }
            return phpModifier;
        }
        if (this.isFinal()) {
            PhpModifier phpModifier = PhpModifier.PUBLIC_FINAL_DYNAMIC;
            if (phpModifier == null) {
                PhpClassImpl.$$$reportNull$$$0(13);
            }
            return phpModifier;
        }
        PhpModifier phpModifier = PhpModifier.PUBLIC_IMPLEMENTED_DYNAMIC;
        if (phpModifier == null) {
            PhpClassImpl.$$$reportNull$$$0(14);
        }
        return phpModifier;
    }

    @Override
    public ItemPresentation getPresentation() {
        return PhpPresentationUtil.getClassPresentation(this);
    }

    @Override
    public void processDocs(Processor<PhpDocComment> processor) {
        PhpClassHierarchyUtils.processSuperClasses((PhpClass)this, (boolean)true, (boolean)false, aClass -> !processor.process((Object)aClass.getDocComment()));
    }

    @NotNull
    public ExtendsList getExtendsList() {
        ExtendsList extendsList = (ExtendsList)this.findChildByClass(ExtendsList.class);
        if (extendsList == null) {
            PhpClassImpl.$$$reportNull$$$0(15);
        }
        return extendsList;
    }

    @NotNull
    public ImplementsList getImplementsList() {
        ImplementsList implementsList = (ImplementsList)this.findChildByClass(ImplementsList.class);
        if (implementsList == null) {
            PhpClassImpl.$$$reportNull$$$0(16);
        }
        return implementsList;
    }

    public PhpClass[] getSupers() {
        ArrayList<PhpClass> superClasses = new ArrayList<PhpClass>();
        PhpClass superClass = this.getSuperClass();
        if (superClass != null) {
            superClasses.add(superClass);
        }
        Collections.addAll(superClasses, this.getImplementedInterfaces());
        Collections.addAll(superClasses, this.getTraits());
        return superClasses.toArray(PhpClass.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public PhpType getType() {
        if (this.isAnonymous()) {
            PhpType type = new PhpType().add("__anonymous@" + this.getTextOffset());
            type.add(this.getSuperFQN());
            for (String s : this.getInterfaceNames()) {
                type.add(s);
            }
            if (this.findOwnMethodByName("__invoke") != null) {
                type.add(PhpType.CALLABLE);
            }
            PhpType phpType = type;
            if (phpType == null) {
                PhpClassImpl.$$$reportNull$$$0(17);
            }
            return phpType;
        }
        String fqn = this.getFQN();
        PhpType phpType = new PhpType().add(fqn);
        if (phpType == null) {
            PhpClassImpl.$$$reportNull$$$0(18);
        }
        return phpType;
    }

    @Override
    public String toString() {
        return "PhpClass: " + this.getName();
    }

    @Nullable
    public Method findOwnMethodByName(@Nullable CharSequence name) {
        return name != null ? (Method)ContainerUtil.getFirstItem((Collection)this.getOwnMethodsMap().get((Object)StringUtilRt.toUpperCase((CharSequence)name))) : null;
    }

    @Nullable
    public Method findMethodByName(@Nullable CharSequence name) {
        if (name == null) {
            return null;
        }
        Ref result = new Ref();
        PhpClassHierarchyUtils.processSupers((PhpClass)this, (boolean)true, (boolean)false, aClass -> {
            if (aClass.hasTraitUses()) {
                List rules = aClass.getTraitUseRules();
                for (PhpTraitUseRule rule : rules) {
                    for (Method method : rule.getMethods()) {
                        if (!method.isValid() || !PhpLangUtil.equalsMethodNames(method.getName(), name)) continue;
                        result.set((Object)method);
                        return false;
                    }
                }
            }
            result.set((Object)aClass.findOwnMethodByName(name));
            return result.isNull();
        });
        return (Method)result.get();
    }

    @Nullable
    public Field findOwnFieldByName(@Nullable CharSequence name, boolean findConstant) {
        Collection fields = this.getOwnFieldMap().get((Object)name);
        for (Field field : fields) {
            if (field.isConstant() != findConstant) continue;
            return field;
        }
        return null;
    }

    @Nullable
    public Field findFieldByName(@Nullable CharSequence name, boolean findConstant) {
        if (name == null) {
            return null;
        }
        Ref result = new Ref();
        PhpClassHierarchyUtils.processSupers((PhpClass)this, (boolean)true, (boolean)false, aClass -> {
            result.set((Object)aClass.findOwnFieldByName(name, findConstant));
            return result.isNull() || result.get() instanceof MyRenamableFakePsiElement;
        });
        return (Field)result.get();
    }

    @Nullable
    public static PhpClass getContainingClass(@NotNull PhpPsiElement point) {
        if (point == null) {
            PhpClassImpl.$$$reportNull$$$0(19);
        }
        if (point instanceof PhpClass) {
            return (PhpClass)point;
        }
        Method method = (Method)PhpPsiUtil.getParentByCondition((PsiElement)point, true, (Condition<? super PsiElement>)Method.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF);
        if (method != null) {
            if (point instanceof Variable && "this".equalsIgnoreCase(point.getName()) && method.isStatic()) {
                return null;
            }
            return (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)method, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF);
        }
        return (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)point, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF);
    }

    @NotNull
    public String getPresentableFQN() {
        String fqn = this.getFQN();
        String string = PhpLangUtil.toPresentableFQN(fqn);
        if (string == null) {
            PhpClassImpl.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static Map<String, AssignmentExpression> getAssignmentsPerField(PhpClass phpClass) {
        Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)phpClass, (CachedValueProvider)new ConstructorAssignmentsCachedValueProvider(phpClass));
        if (map == null) {
            PhpClassImpl.$$$reportNull$$$0(21);
        }
        return map;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 9: 
            case 10: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 9: 
            case 10: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementVisitor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterfaceNames";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitNames";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMixinNames";
                break;
            }
            case 9: 
            case 10: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifier";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsList";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementsList";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableFQN";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssignmentsPerField";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getContainingClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConstructorAssignmentsCachedValueProvider
    implements CachedValueProvider<Map<String, AssignmentExpression>> {
        private final PhpClass myClass;

        ConstructorAssignmentsCachedValueProvider(PhpClass aClass) {
            this.myClass = aClass;
        }

        @NotNull
        public CachedValueProvider.Result<Map<String, AssignmentExpression>> compute() {
            Method myMethod = this.myClass != null ? this.myClass.getOwnConstructor() : null;
            THashMap accessMap = ContainerUtil.newTroveMap();
            if (myMethod != null) {
                myMethod.accept((PsiElementVisitor)new PhpRecursiveElementVisitor((Map)accessMap){
                    final /* synthetic */ Map val$accessMap;
                    {
                        this.val$accessMap = map;
                    }

                    public void visitPhpAssignmentExpression(AssignmentExpression expr) {
                        PhpPsiElement v = expr.getVariable();
                        if (v instanceof FieldReference) {
                            try {
                                String name;
                                FieldReference reference = (FieldReference)v;
                                PhpExpression classReference = reference.getClassReference();
                                if (classReference != null && ("$this".equals(classReference.getText()) || "self".equals(classReference.getText())) && reference.getNameNode() != null && StringUtil.isNotEmpty((String)(name = reference.getName()))) {
                                    this.val$accessMap.put(name, expr);
                                }
                            }
                            catch (ProcessCanceledException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                throw new RuntimeException("expr = " + expr.getText() + " for " + myClass.getText(), e);
                            }
                        }
                    }

                    public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
                        this.visitPhpAssignmentExpression((AssignmentExpression)expression);
                    }

                    public void visitPhpMultiassignmentExpression(MultiassignmentExpression multiassignmentExpression) {
                        this.visitPhpAssignmentExpression((AssignmentExpression)multiassignmentExpression);
                    }
                });
            }
            CachedValueProvider.Result result = new CachedValueProvider.Result((Object)accessMap, new Object[]{this.myClass});
            if (result == null) {
                ConstructorAssignmentsCachedValueProvider.$$$reportNull$$$0(0);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl$ConstructorAssignmentsCachedValueProvider", "compute"));
        }
    }

    public static class MyRenamableFakePsiElement
    extends RenameableFakePsiElement
    implements Field {
        private final AssignmentExpression myExpr;
        private final FieldReference myRef;

        @NotNull
        public PsiElement getNavigationElement() {
            FieldReference fieldReference = this.myRef;
            if (fieldReference == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(0);
            }
            return fieldReference;
        }

        public MyRenamableFakePsiElement(PsiElement anchor, AssignmentExpression expr, @NotNull FieldReference ref) {
            if (ref == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(1);
            }
            super(anchor);
            this.myExpr = expr;
            this.myRef = ref;
        }

        public String getTypeName() {
            return "Constructor field";
        }

        public Icon getIcon() {
            return null;
        }

        @NotNull
        public String getFQN() {
            String string = this.getContainingClass().getFQN() + "->" + this.getName();
            if (string == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getNamespaceName() {
            String string = this.getContainingClass().getNamespaceName();
            if (string == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean isDeprecated() {
            return false;
        }

        public boolean isInternal() {
            return false;
        }

        public PsiElement getParent() {
            return this.myRef;
        }

        public ASTNode getNameNode() {
            return this.myRef.getNameNode();
        }

        @NotNull
        public String getName() {
            String string = this.myRef.getName();
            if (string == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public CharSequence getNameCS() {
            String string = this.getName();
            if (string == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(5);
            }
            return string;
        }

        public PhpDocComment getDocComment() {
            return null;
        }

        public void processDocs(Processor<PhpDocComment> processor) {
            PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)this, (method, subClass, baseClass) -> !processor.process((Object)method.getDocComment()));
        }

        @NotNull
        public PhpModifier getModifier() {
            PhpExpression classReference = this.myRef.getClassReference();
            boolean dynamic = classReference != null && ("$this".equals(classReference.getText()) || "parent".equals(classReference.getText()));
            PhpModifier phpModifier = PhpModifier.instance((PhpModifier.Access)PhpModifier.Access.PUBLIC, (PhpModifier.Abstractness)PhpModifier.Abstractness.IMPLEMENTED, (PhpModifier.State)(dynamic ? PhpModifier.State.DYNAMIC : PhpModifier.State.STATIC));
            if (phpModifier == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(6);
            }
            return phpModifier;
        }

        @NotNull
        public PhpClass getContainingClass() {
            PhpClass phpClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)this.myRef, PhpClass.class, (boolean)false);
            if (phpClass == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(7);
            }
            return phpClass;
        }

        public boolean isConstant() {
            return false;
        }

        public PsiElement getDefaultValue() {
            return null;
        }

        public String getDefaultValuePresentation() {
            return null;
        }

        public boolean isWriteAccess() {
            return true;
        }

        public PhpPsiElement getFirstPsiChild() {
            return null;
        }

        public PhpPsiElement getNextPsiSibling() {
            return null;
        }

        public PhpPsiElement getPrevPsiSibling() {
            return null;
        }

        @NotNull
        public PhpType getType() {
            PhpType phpType = this.myExpr.getType();
            if (phpType == null) {
                MyRenamableFakePsiElement.$$$reportNull$$$0(8);
            }
            return phpType;
        }

        public PsiElement getNameIdentifier() {
            return null;
        }

        public String toString() {
            return "FakeConstructorField " + this.getName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl$MyRenamableFakePsiElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/PhpClassImpl$MyRenamableFakePsiElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFQN";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespaceName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNameCS";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModifier";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainingClass";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

