/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phar;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.ByteArrayCharSequence;
import com.jetbrains.php.phar.PharCompression;
import com.jetbrains.php.phar.PharHandlerBase;
import gnu.trove.THashMap;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.jetbrains.annotations.NotNull;

class TarHandler
extends PharHandlerBase {
    TarHandler(@NotNull String path, @NotNull PharCompression compression) {
        if (path == null) {
            TarHandler.$$$reportNull$$$0(0);
        }
        if (compression == null) {
            TarHandler.$$$reportNull$$$0(1);
        }
        super(path, compression);
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        THashMap map = new THashMap();
        map.put("", this.createRootEntry());
        try (TarArchiveInputStream stream = new TarArchiveInputStream(this.myCompression.wrapStream(new FileInputStream(this.getFile())));){
            TarArchiveEntry entry;
            while ((entry = stream.getNextTarEntry()) != null) {
                this.getOrCreate((Map<String, ArchiveHandler.EntryInfo>)map, entry, stream.getBytesRead());
            }
        }
        THashMap tHashMap = map;
        if (tHashMap == null) {
            TarHandler.$$$reportNull$$$0(2);
        }
        return tHashMap;
    }

    private ArchiveHandler.EntryInfo getOrCreate(Map<String, ArchiveHandler.EntryInfo> map, TarArchiveEntry tarEntry, long offset) {
        String entryName = tarEntry.getName();
        ArchiveHandler.EntryInfo entry = map.get(entryName);
        if (entry == null) {
            Pair path = this.splitPath(entryName);
            ArchiveHandler.EntryInfo parentEntry = this.getOrCreate(map, (String)path.first);
            CharSequence shortName = ByteArrayCharSequence.convertToBytesIfPossible((CharSequence)((CharSequence)path.second));
            boolean dir = tarEntry.isDirectory();
            entry = dir ? new ArchiveHandler.EntryInfo(shortName, true, tarEntry.getSize(), tarEntry.getModTime().getTime(), parentEntry) : new TarEntryInfo(parentEntry, shortName, tarEntry.getSize(), tarEntry.getModTime().getTime(), offset);
            map.put(entryName, entry);
        }
        return entry;
    }

    @Override
    @NotNull
    protected byte[] readContentsFromStream(@NotNull String relativePath, @NotNull InputStream inputStream) throws IOException {
        block18: {
            ArchiveHandler.EntryInfo info;
            if (relativePath == null) {
                TarHandler.$$$reportNull$$$0(3);
            }
            if (inputStream == null) {
                TarHandler.$$$reportNull$$$0(4);
            }
            if ((info = this.getEntryInfo(relativePath)) instanceof TarEntryInfo) {
                byte[] byArray;
                block19: {
                    try (BufferedInputStream stream = new BufferedInputStream(inputStream);){
                        long offset = ((TarEntryInfo)info).offset;
                        if (stream.skip(offset) != offset) break block18;
                        long length = ((TarEntryInfo)info).length;
                        byArray = FileUtil.loadBytes((InputStream)stream, (int)((int)length));
                        if (byArray != null) break block19;
                    }
                    TarHandler.$$$reportNull$$$0(5);
                }
                return byArray;
            }
        }
        if (ArrayUtil.EMPTY_BYTE_ARRAY == null) {
            TarHandler.$$$reportNull$$$0(6);
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compression";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phar/TarHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phar/TarHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntriesMap";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readContentsFromStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readContentsFromStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TarEntryInfo
    extends ArchiveHandler.EntryInfo {
        private final long offset;

        private TarEntryInfo(ArchiveHandler.EntryInfo parent, CharSequence shortName, long length, long timestamp, long offset) {
            super(shortName, false, length, timestamp, parent);
            this.offset = offset;
        }
    }
}

