/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.intellij.ide.ui.laf.darcula.ui.DarculaTextBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaTextFieldUI;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBTextField;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;

abstract class SettingsSearch
extends SearchTextField
implements KeyListener {
    private boolean myDelegatingNow;

    SettingsSearch() {
        super("SettingsSearchHistory");
        this.updateToolTipText();
        this.addKeyListener(new KeyAdapter(){});
        if (!SystemInfo.isMac) {
            JBTextField editor = this.getTextEditor();
            editor.putClientProperty("JTextField.variant", "search");
            if (!(editor.getUI() instanceof TextFieldWithPopupHandlerUI)) {
                editor.setUI((DarculaTextFieldUI)DarculaTextFieldUI.createUI((JComponent)editor));
                editor.setBorder(new DarculaTextBorder());
            }
        }
    }

    abstract void onTextKeyEvent(KeyEvent var1);

    void delegateKeyEvent(KeyEvent event) {
        this.keyEventToTextField(event);
    }

    protected boolean isSearchControlUISupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean preprocessEventForTextField(KeyEvent event) {
        if (!this.myDelegatingNow) {
            KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(event);
            String strokeString = stroke.toString();
            if ("pressed ESCAPE".equals(strokeString) && this.getText().length() > 0) {
                this.setText("");
                return true;
            }
            if (this.getTextEditor().isFocusOwner()) {
                try {
                    boolean treeNavigation;
                    this.myDelegatingNow = true;
                    int code = stroke.getKeyCode();
                    boolean bl = treeNavigation = stroke.getModifiers() == 0 && (code == 38 || code == 40);
                    if (treeNavigation || !SettingsSearch.hasAction(stroke, this.getTextEditor().getInputMap())) {
                        this.onTextKeyEvent(event);
                        boolean bl2 = true;
                        return bl2;
                    }
                }
                finally {
                    this.myDelegatingNow = false;
                }
            }
        }
        return false;
    }

    private static boolean hasAction(KeyStroke stroke, InputMap map) {
        return map != null && map.get(stroke) != null;
    }

    @Override
    public void keyPressed(KeyEvent event) {
        this.keyTyped(event);
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.keyTyped(event);
    }

    @Override
    public void keyTyped(KeyEvent event) {
        Object source = event.getSource();
        if (source instanceof JTree) {
            JTree tree = (JTree)source;
            if (!SettingsSearch.hasAction(KeyStroke.getKeyStrokeForEvent(event), tree.getInputMap())) {
                this.delegateKeyEvent(event);
            }
        }
    }

    void updateToolTipText() {
        ShortcutSet set = SettingsDialog.getFindActionShortcutSet();
        String text = set == null ? null : StringUtil.join((Object[])set.getShortcuts(), KeymapUtil::getShortcutText, (String)"\n");
        this.getTextEditor().setToolTipText(StringUtil.isEmpty((String)text) ? null : text);
    }
}

