/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesAdapter;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesPanel;
import com.intellij.openapi.vcs.changes.committed.VcsConfigurationChangeListener;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class CommittedChangesViewManager
implements ChangesViewContentProvider {
    private final MessageBus myBus;
    private MessageBusConnection myConnection;
    private CommittedChangesPanel myComponent;
    private final Project myProject;
    private final VcsListener myVcsListener = new MyVcsListener();

    public CommittedChangesViewManager(Project project, MessageBus bus) {
        this.myProject = project;
        this.myBus = bus;
    }

    private void updateChangesContent() {
        CommittedChangesProvider provider = CommittedChangesCache.getInstance(this.myProject).getProviderForProject();
        if (provider == null) {
            return;
        }
        if (this.myComponent == null) {
            this.myComponent = new CommittedChangesPanel(this.myProject, provider, provider.createDefaultSettings(), null, null);
            this.myConnection.subscribe(VcsConfigurationChangeListener.BRANCHES_CHANGED, (Object)new VcsConfigurationChangeListener.Notification(){

                @Override
                public void execute(Project project, VirtualFile vcsRoot) {
                    CommittedChangesViewManager.this.sendUpdateCachedListsMessage(vcsRoot);
                }
            });
        } else {
            this.myComponent.setProvider(provider);
            this.sendUpdateCachedListsMessage(null);
        }
    }

    private void sendUpdateCachedListsMessage(VirtualFile vcsRoot) {
        ApplicationManager.getApplication().invokeLater(() -> this.myComponent.passCachedListsToListener((VcsConfigurationChangeListener.DetailedNotification)this.myBus.syncPublisher(VcsConfigurationChangeListener.BRANCHES_CHANGED_RESPONSE), this.myProject, vcsRoot), o -> !this.myProject.isOpen() || this.myProject.isDisposed() || this.myComponent == null);
    }

    @Override
    public JComponent initContent() {
        this.myConnection = this.myBus.connect();
        this.myConnection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this.myVcsListener);
        this.myConnection.subscribe(CommittedChangesCache.COMMITTED_TOPIC, (Object)new MyCommittedChangesListener());
        this.updateChangesContent();
        this.myComponent.refreshChanges(true);
        return this.myComponent;
    }

    @Override
    public void disposeContent() {
        this.myConnection.disconnect();
        Disposer.dispose((Disposable)this.myComponent);
        this.myComponent = null;
    }

    private class MyCommittedChangesListener
    extends CommittedChangesAdapter {
        private MyCommittedChangesListener() {
        }

        @Override
        public void changesLoaded(RepositoryLocation location, List<CommittedChangeList> changes2) {
            this.presentationChanged();
        }

        @Override
        public void presentationChanged() {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (CommittedChangesViewManager.this.myComponent != null && !CommittedChangesViewManager.this.myProject.isDisposed()) {
                    CommittedChangesViewManager.this.myComponent.refreshChanges(true);
                }
            });
        }

        @Override
        public void refreshErrorStatusChanged(@Nullable VcsException lastError) {
            if (lastError != null) {
                VcsBalloonProblemNotifier.showOverChangesView(CommittedChangesViewManager.this.myProject, lastError.getMessage(), MessageType.ERROR, new NamedRunnable[0]);
            }
        }
    }

    private class MyVcsListener
    implements VcsListener {
        private MyVcsListener() {
        }

        public void directoryMappingChanged() {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!CommittedChangesViewManager.this.myProject.isDisposed()) {
                    CommittedChangesViewManager.this.updateChangesContent();
                }
            });
        }
    }
}

