/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.ui;

import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.ui.JSScriptingContextConfigurable;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.editor.HectorComponentPanelsProvider;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSUsedLibrariesHectorProvider
implements HectorComponentPanelsProvider {
    @Nullable
    public HectorComponentPanel createConfigurable(@NotNull PsiFile file2) {
        VirtualFile virtualFile;
        if (file2 == null) {
            JSUsedLibrariesHectorProvider.$$$reportNull$$$0(0);
        }
        if ((virtualFile = file2.getVirtualFile()) == null || !JavaScriptSupportLoader.isPlainJavaScriptFile(file2)) {
            return null;
        }
        ArrayList<String> libNames = new ArrayList<String>();
        JSLibraryMappings.getInstance(file2.getProject()).forEachLibraryInScopeForFile(virtualFile, model -> libNames.add(model.getName()));
        Collections.sort(libNames);
        return new MyPanel(file2.getProject(), libNames);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/ui/JSUsedLibrariesHectorProvider", "createConfigurable"));
    }

    private static class MyPanel
    extends HectorComponentPanel {
        private final Project myProject;
        private final Collection<String> myLibNames;

        MyPanel(Project project, Collection<String> libNames) {
            this.myProject = project;
            this.myLibNames = libNames;
        }

        @Nullable
        public JComponent createComponent() {
            JPanel p = new JPanel(new BorderLayout());
            p.setBorder((Border)JBUI.Borders.empty((int)0, (int)4, (int)0, (int)4));
            HyperlinkAdapter listener2 = new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    JSScriptingContextConfigurable c = new JSScriptingContextConfigurable(myProject);
                    ShowSettingsUtil.getInstance().editConfigurable(myProject, (Configurable)c);
                }
            };
            if (this.myLibNames.isEmpty()) {
                HyperlinkLabel label = new HyperlinkLabel("No libraries in scope");
                p.add((Component)label, "Center");
                label.addHyperlinkListener((HyperlinkListener)listener2);
            } else {
                HyperlinkLabel label = new HyperlinkLabel("Libraries in scope:");
                p.add((Component)label, "West");
                label.addHyperlinkListener((HyperlinkListener)listener2);
                String allLibs = StringUtil.join(this.myLibNames, (String)", ");
                JLabel label2 = new JLabel(allLibs){

                    @Override
                    public Dimension getMinimumSize() {
                        Dimension s = super.getMinimumSize();
                        return new Dimension(Math.min(s.width, 300), s.height);
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension s = super.getPreferredSize();
                        return new Dimension(Math.min(s.width, 300), s.height);
                    }
                };
                label2.setToolTipText(allLibs);
                p.add((Component)label2, "Center");
            }
            return p;
        }

        public boolean isModified() {
            return false;
        }

        public void apply() throws ConfigurationException {
        }
    }
}

