/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.FillInterest;
import org.eclipse.jetty.io.IdleTimeout;
import org.eclipse.jetty.io.WriteFlusher;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class AbstractEndPoint
extends IdleTimeout
implements EndPoint {
    private static final Logger LOG = Log.getLogger(AbstractEndPoint.class);
    private final long _created = System.currentTimeMillis();
    private final InetSocketAddress _local;
    private final InetSocketAddress _remote;
    private volatile Connection _connection;
    private final FillInterest _fillInterest = new FillInterest(){

        @Override
        protected void needsFillInterest() throws IOException {
            AbstractEndPoint.this.needsFillInterest();
        }
    };
    private final WriteFlusher _writeFlusher = new WriteFlusher(this){

        @Override
        protected void onIncompleteFlush() {
            AbstractEndPoint.this.onIncompleteFlush();
        }
    };

    protected AbstractEndPoint(Scheduler scheduler, InetSocketAddress local, InetSocketAddress remote) {
        super(scheduler);
        this._local = local;
        this._remote = remote;
    }

    @Override
    public long getCreatedTimeStamp() {
        return this._created;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this._local;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this._remote;
    }

    @Override
    public Connection getConnection() {
        return this._connection;
    }

    @Override
    public void setConnection(Connection connection) {
        this._connection = connection;
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return false;
    }

    @Override
    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onOpen {}", this);
        }
        super.onOpen();
    }

    @Override
    public void onClose() {
        super.onClose();
        if (LOG.isDebugEnabled()) {
            LOG.debug("onClose {}", this);
        }
        this._writeFlusher.onClose();
        this._fillInterest.onClose();
    }

    @Override
    public void close() {
        this.onClose();
    }

    @Override
    public void fillInterested(Callback callback) throws IllegalStateException {
        this.notIdle();
        this._fillInterest.register(callback);
    }

    @Override
    public void write(Callback callback, ByteBuffer ... buffers) throws IllegalStateException {
        this._writeFlusher.write(callback, buffers);
    }

    protected abstract void onIncompleteFlush();

    protected abstract void needsFillInterest() throws IOException;

    public FillInterest getFillInterest() {
        return this._fillInterest;
    }

    protected WriteFlusher getWriteFlusher() {
        return this._writeFlusher;
    }

    @Override
    protected void onIdleExpired(TimeoutException timeout) {
        boolean output_shutdown = this.isOutputShutdown();
        boolean input_shutdown = this.isInputShutdown();
        boolean fillFailed = this._fillInterest.onFail(timeout);
        boolean writeFailed = this._writeFlusher.onFail(timeout);
        if (this.isOpen() && (output_shutdown || input_shutdown) && !fillFailed && !writeFailed) {
            this.close();
        } else {
            LOG.debug("Ignored idle endpoint {}", this);
        }
    }

    @Override
    public void upgrade(Connection newConnection) {
        Connection old_connection = this.getConnection();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} upgradeing from {} to {}", this, old_connection, newConnection);
        }
        ByteBuffer prefilled = old_connection instanceof Connection.UpgradeFrom ? ((Connection.UpgradeFrom)old_connection).onUpgradeFrom() : null;
        old_connection.onClose();
        old_connection.getEndPoint().setConnection(newConnection);
        if (newConnection instanceof Connection.UpgradeTo) {
            ((Connection.UpgradeTo)newConnection).onUpgradeTo(prefilled);
        } else if (BufferUtil.hasContent(prefilled)) {
            throw new IllegalStateException();
        }
        newConnection.onOpen();
    }

    public String toString() {
        Class<?> c = this.getClass();
        String name = c.getSimpleName();
        while (name.length() == 0 && c.getSuperclass() != null) {
            c = c.getSuperclass();
            name = c.getSimpleName();
        }
        return String.format("%s@%x{%s<->%d,%s,%s,%s,%s,%s,%d/%d,%s}", name, this.hashCode(), this.getRemoteAddress(), this.getLocalAddress().getPort(), this.isOpen() ? "Open" : "CLOSED", this.isInputShutdown() ? "ISHUT" : "in", this.isOutputShutdown() ? "OSHUT" : "out", this._fillInterest.isInterested() ? "R" : "-", this._writeFlusher.isInProgress() ? "W" : "-", this.getIdleFor(), this.getIdleTimeout(), this.getConnection() == null ? null : this.getConnection().getClass().getSimpleName());
    }
}

