/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.ComputedElement;
import net.sf.saxon.expr.instruct.ElementCreator;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.expr.instruct.UseAttributeSets;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public class XSLElement
extends StyleElement {
    private Expression elementName;
    private Expression namespace = null;
    private String use;
    private AttributeSet[] attributeSets = null;
    private int validation;
    private SchemaType schemaType = null;
    private boolean inheritNamespaces = true;
    private Expression onEmpty;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String nameAtt = null;
        String namespaceAtt = null;
        String validationAtt = null;
        String typeAtt = null;
        String inheritAtt = null;
        String onEmptyAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("name")) {
                nameAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("namespace")) {
                namespaceAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("validation")) {
                validationAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("type")) {
                typeAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("inherit-namespaces")) {
                inheritAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("use-attribute-sets")) {
                this.use = atts.getValue(a);
                continue;
            }
            if (f.equals("on-empty")) {
                onEmptyAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
        } else {
            this.elementName = this.makeAttributeValueTemplate(nameAtt);
            if (this.elementName instanceof StringLiteral && !this.getConfiguration().getNameChecker().isQName(((StringLiteral)this.elementName).getStringValue())) {
                this.compileError("Element name " + Err.wrap(((StringLiteral)this.elementName).getStringValue(), 1) + " is not a valid QName", "XTDE0820");
                this.elementName = new StringLiteral("saxon-error-element");
            }
        }
        if (namespaceAtt != null) {
            this.namespace = this.makeAttributeValueTemplate(namespaceAtt);
            if (this.namespace instanceof StringLiteral && !StandardURIChecker.getInstance().isValidURI(((StringLiteral)this.namespace).getStringValue())) {
                this.compileError("The value of the namespace attribute must be a valid URI", "XTDE0835");
            }
        }
        if (validationAtt != null) {
            this.validation = Validation.getCode(validationAtt);
            if (this.validation != 4 && !this.getPreparedStylesheet().isSchemaAware()) {
                this.validation = 4;
                this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
            }
            if (this.validation == -1) {
                this.compileError("Invalid value for @validation attribute. Permitted values are (strict, lax, preserve, strip)", "XTSE0020");
            }
        } else {
            this.validation = this.getContainingStylesheet().getDefaultValidation();
        }
        if (typeAtt != null) {
            if (!this.getPreparedStylesheet().isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.schemaType = this.getSchemaType(typeAtt);
            this.validation = 8;
        }
        if (typeAtt != null && validationAtt != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
        if (inheritAtt != null) {
            this.checkAttributeValue("inherit-namespaces", inheritAtt, false, StyleElement.YES_NO);
            this.inheritNamespaces = inheritAtt.equals("yes");
        }
        if (onEmptyAtt != null) {
            this.onEmpty = this.makeExpression(onEmptyAtt);
        }
    }

    public void validate(Declaration decl) throws XPathException {
        if (this.use != null) {
            this.attributeSets = this.getAttributeSets(this.use, null);
        }
        this.elementName = this.typeCheck("name", this.elementName);
        this.namespace = this.typeCheck("namespace", this.namespace);
        this.onEmpty = this.typeCheck("on-empty", this.onEmpty);
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        SavedNamespaceContext nsContext = null;
        if (this.elementName instanceof StringLiteral) {
            String[] parts;
            String qName = ((StringLiteral)this.elementName).getStringValue();
            try {
                parts = this.getConfiguration().getNameChecker().getQNameParts(qName);
            }
            catch (QNameException e) {
                this.compileError("Invalid element name: " + qName, "XTDE0820");
                return null;
            }
            String nsuri = null;
            if (this.namespace instanceof StringLiteral) {
                nsuri = ((StringLiteral)this.namespace).getStringValue();
                if (nsuri.length() == 0) {
                    parts[0] = "";
                }
            } else if (this.namespace == null && (nsuri = this.getURIForPrefix(parts[0], true)) == null) {
                this.undeclaredNamespaceError(parts[0], "XTDE0830");
            }
            if (nsuri != null) {
                FingerprintedQName qn = new FingerprintedQName(parts[0], nsuri, parts[1]);
                qn.allocateNameCode(this.getNamePool());
                FixedElement inst = new FixedElement(qn, NamespaceBinding.EMPTY_ARRAY, this.inheritNamespaces, this.schemaType, this.validation);
                inst.setBaseURI(this.getBaseURI());
                return this.compileContentExpression(exec, decl, inst);
            }
        } else if (this.namespace == null) {
            nsContext = this.makeNamespaceContext();
        }
        ComputedElement inst = new ComputedElement(this.elementName, this.namespace, nsContext, this.schemaType, this.validation, this.inheritNamespaces, false);
        if (this.onEmpty != null) {
            inst.setOnEmpty(this.onEmpty);
        }
        return this.compileContentExpression(exec, decl, inst);
    }

    private Expression compileContentExpression(Executable exec, Declaration decl, ElementCreator inst) throws XPathException {
        Expression content = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true);
        if (this.attributeSets != null) {
            UseAttributeSets use = new UseAttributeSets(this.attributeSets);
            if (content == null) {
                content = use;
            } else {
                content = Block.makeBlock(use, content);
                content.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            }
        }
        if (content == null) {
            content = Literal.makeEmptySequence();
        }
        inst.setContentExpression(content);
        return inst;
    }
}

