/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.sourceforge.squirrel_sql.fw.gui.TextPopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.action.BaseAction;
import net.sourceforge.squirrel_sql.fw.util.DefaultExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.ExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class MessagePanel
extends JTextPane
implements IMessageHandler {
    private static final ILogger s_log = LoggerController.createLogger(MessagePanel.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MessagePanel.class);
    private final TextPopupMenu _popupMenu = new MessagePanelPopupMenu();
    private SimpleAttributeSet _saSetMessage;
    private SimpleAttributeSet _saSetError;
    private SimpleAttributeSet _saSetWarning;
    private int _lastLength;
    private String _lastMessage;
    private SimpleAttributeSet _lastSASet;
    private HashMap<SimpleAttributeSet, SimpleAttributeSet> _saSetHistoryBySaSet = new HashMap();
    private DefaultExceptionFormatter defaultExceptionFormatter = new DefaultExceptionFormatter();

    public MessagePanel() {
        this._popupMenu.setTextComponent(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    MessagePanel.this._popupMenu.show(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    MessagePanel.this._popupMenu.show(evt);
                }
            }
        });
        this._saSetMessage = new SimpleAttributeSet();
        StyleConstants.setBackground(this._saSetMessage, Color.green);
        SimpleAttributeSet saSetMessageHistory = new SimpleAttributeSet();
        StyleConstants.setBackground(saSetMessageHistory, this.getBackground());
        this._saSetHistoryBySaSet.put(this._saSetMessage, saSetMessageHistory);
        this._saSetWarning = new SimpleAttributeSet();
        StyleConstants.setBackground(this._saSetWarning, Color.yellow);
        SimpleAttributeSet saSetWarningHistory = new SimpleAttributeSet();
        StyleConstants.setBackground(saSetWarningHistory, new Color(255, 255, 210));
        this._saSetHistoryBySaSet.put(this._saSetWarning, saSetWarningHistory);
        this._saSetError = new SimpleAttributeSet();
        StyleConstants.setForeground(this._saSetError, Color.red);
        SimpleAttributeSet saSetErrorHistory = new SimpleAttributeSet();
        StyleConstants.setForeground(saSetErrorHistory, new Color(255, 102, 102));
        this._saSetHistoryBySaSet.put(this._saSetError, saSetErrorHistory);
    }

    public void addToMessagePanelPopup(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null");
        }
        this._popupMenu.add(action);
    }

    @Override
    public synchronized void showMessage(Throwable th, ExceptionFormatter formatter) {
        if (th == null) {
            throw new IllegalArgumentException("th cannot be null");
        }
        this.privateShowMessage(th, formatter, this._saSetMessage);
    }

    @Override
    public synchronized void showErrorMessage(Throwable th, ExceptionFormatter formatter) {
        if (th == null) {
            throw new IllegalArgumentException("th cannot be null");
        }
        this.privateShowMessage(th, formatter, this._saSetError);
    }

    @Override
    public synchronized void showMessage(String msg) {
        if (msg == null) {
            throw new IllegalArgumentException("msg cannot be null");
        }
        this.privateShowMessage(msg, this._saSetMessage);
    }

    @Override
    public void showWarningMessage(String msg) {
        if (msg == null) {
            throw new IllegalArgumentException("msg cannot be null");
        }
        this.privateShowMessage(msg, this._saSetWarning);
    }

    @Override
    public synchronized void showErrorMessage(String msg) {
        if (msg == null) {
            throw new IllegalArgumentException("msg cannot be null");
        }
        this.privateShowMessage(msg, this._saSetError);
    }

    private void privateShowMessage(Throwable th, ExceptionFormatter formatter, SimpleAttributeSet saSet) {
        if (th != null) {
            String message = "";
            if (formatter == null) {
                message = this.defaultExceptionFormatter.format(th);
            } else {
                try {
                    message = formatter.format(th);
                }
                catch (Exception e) {
                    s_log.error("Unable to format message: " + e.getMessage(), e);
                }
            }
            this.privateShowMessage(message, saSet);
            s_log.error("privateShowMessage: Exception was " + th.getMessage(), th);
        }
    }

    private void privateShowMessage(final String msg, final SimpleAttributeSet saSet) {
        if (msg == null) {
            throw new IllegalArgumentException("null Message");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessagePanel.this.addLine(msg, saSet);
            }
        });
    }

    private void append(String string, SimpleAttributeSet saSet) {
        StyledDocument document = this.getStyledDocument();
        try {
            if (document.getLength() >= this._lastLength && null != this._lastMessage) {
                SimpleAttributeSet historySaSet = this._saSetHistoryBySaSet.get(this._lastSASet);
                document.remove(this._lastLength, this._lastMessage.length());
                document.insertString(document.getLength(), this._lastMessage, historySaSet);
            }
            this._lastLength = document.getLength();
            this._lastMessage = string;
            this._lastSASet = saSet;
            document.insertString(document.getLength(), string, saSet);
        }
        catch (BadLocationException ble) {
            s_log.error("Error appending text to MessagePanel document.", ble);
        }
    }

    private void addLine(String line, SimpleAttributeSet saSet) {
        if (this.getDocument().getLength() > 0) {
            this.append("\n", saSet);
        }
        this.append(line, saSet);
        int len = this.getDocument().getLength();
        this.select(len, len);
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private class MessagePanelPopupMenu
    extends TextPopupMenu {
        static final long serialVersionUID = -425002646648750251L;

        public MessagePanelPopupMenu() {
            this.add(new ClearAction());
        }

        private class ClearAction
        extends BaseAction {
            static final long serialVersionUID = 2124058843445088350L;

            protected ClearAction() {
                super(I18N.CLEAR_LABEL);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    Document doc = MessagePanel.this.getDocument();
                    doc.remove(0, doc.getLength());
                    MessagePanel.this._lastMessage = null;
                }
                catch (BadLocationException ex) {
                    s_log.error("Error clearing document", ex);
                }
            }
        }
    }

    private static interface I18N {
        public static final String CLEAR_LABEL = MessagePanel.access$000().getString("MessagePanel.clearLabel");
    }
}

